/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */


#ifndef _XmNlPartRes_h
#define _XmNlPartRes_h

#if defined(VMS) || defined(__VMS)
#include <X11/apienvset.h>
#endif

//#include <Xm/Ext.h>

/************************************************************
*	INCLUDE FILES
*************************************************************/
#include "XmNl.h"

/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

#define XmANY_COLUMN	-1

#define XmNnumItems		"num_items"
/*#define XmNnumCols		"num_cols"
#define XmCNumCols		"NumCols"*/
#define XmNnumCells		"num_cells"
//#define XmNentryData		"entry_data"
#define XmCNumItems		"NumItems"
#define XmCNumCells		"NumCells"
//#define XmCEntryData		"EntryData"
//#define XmCScrollBar		"ScrollBar"
#define XmNBackground		"Background"
#define XmNSelectBackground	"SelectBackground"
#define XmNForeground		"Foreground"
#define XmNSelectForeground	"SelectForeground"

#define XmNchangePartOn	"change_part_on"
#define XmCChangePartOn	"ChangePartOn"

#define XmNlabelOrder	"label_order"
#define XmCLabelOrder	"LabelOrder"

#define	XmNpartitionsSize	"partitions_size"
#define XmCPartitionsSize	"PartitionsSize"

#define XmNmaxValue	"max_value"
//#define XmCMaxValue	"MaxValue"

#define XmNfontlist		"fontlist"
#define XtNchangePartCallback	"changePartCallback"
#define XtNchangeStructPartCallback	"changeStructPartCallback"
#define XtNhighlightCallback	"highlightCallback"
//#define XmNdoubleClickCallback	"doubleClickCallback"
#define XtNstartMovePartCallback	"StartMovePartCallback"
#define XtNmovePartCallback	"MovePartCallback"

#define XmNlprResizeCallback	"prResizeCallback"

#define XmNPRmod	"pr_resize_mod"
#define XmCPRmod	"PR_Resize_Mod"

#define XmNprefHeight	"pref_height"
#define XmCprefHeight	"PrefHeight"

#define XmNPR_Manual	1
#define XmNPR_Proportional	2


#define XmNl_PixOnly	1
#define XmNl_PixBeginString	2
#define XmNl_PixEndString	3
#define XmNl_StringOnly	4

typedef struct _XmNlPartResClassRec	*XmNlPartResWidgetClass;
typedef struct _XmNlPartResRec		*XmNlPartResWidget;


/************************************************************
*	MACROS
*************************************************************/

/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/

typedef struct _PartResElement {

/* Public elements */
Pixmap pixmap;
Pixmap mask;
String text;
XmString xmlabel;
int size;
unsigned char element_type;
unsigned char alignment;
Boolean resizible;
/* Private elements */

} PartResElement;

typedef struct _PartResChangeReturnStruct {
  int		reason;
  XEvent	*event;
  int		pos;
  int		new_size;
} PartResChangeReturnStruct;

typedef struct _PartResStartMoveReturnStruct {
  int		reason;
  XEvent	*event;
  int		pos;
  int		new_size;
} PartResStartMoveReturnStruct;

typedef struct _PartResStartReturnStruct {
  int		reason;
  XEvent	*event;
  int		pos;
  int		new_size;
} PartResMoveReturnStruct;

typedef struct _PartResChangeStructReturnStruct {
  int		reason;
  XEvent	*event;
//  int		pos;
//  int		new_size;
} PartResChangeStructReturnStruct;


/************************************************************
* Public function declarations
*************************************************************/
void PRSetCellsWidth(Widget w, Dimension * data);
void PRSetElements(Widget w, int count, PartResElement * data);
int PRGetColsWidth(Widget w, Dimension * data);
int PRGetGeometry(Widget w, Dimension * data, int * viewable_size);
void PRSetColsTitles(Widget w, char ** data);
void PRSetColNum(Widget w, int col_num);
void PRSetShift(Widget w, int shift);
int PRGetShift(Widget w);
void PRSetTitleBarAlignment(Widget w, int num, unsigned char alignment);
void PRGetRealVector(Widget w, int ** data);

Boolean XmNlPartResSetCell(Widget w, XmNlCell *cell_data, unsigned char valuemask, int position);
Boolean XmNlPartResSetRow(Widget w, XmNlCell *cell_data, unsigned char valuemask);

/************************************************************
*	EXTERNAL DECLARATIONS
*************************************************************/

extern WidgetClass xmNlPartResWidgetClass;

#if defined(__cplusplus)
}
#endif

#if defined(VMS) || defined(__VMS)
#include <X11/apienvrst.h>
#endif

#endif /* _XmPartRes_h */
