/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */


/************************************************************
*	INCLUDE FILES
*************************************************************/

#ifdef HAVE_CONFIG_H
//#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>

#include <Xm/XmP.h>
#if (XmVERSION >= 2)
#include <Xm/DrawP.h>
#endif
#include "XmNlPartResP.h"
#include "XmNl.h"

#include <Xm/ScrollBar.h>
//#include <Xm/ExtP.h>
#include <Xm/XmP.h>
//#include <Xm/XmStrDefs.h>

//#define DEBUG 1
/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/

#define CHECK_CLIP_CORRECT (XmVERSION >= 2 && XmREVISION >= 3 && XmUPDATE_LEVEL >= 4)

#define SUPERCLASS ((WidgetClass) &xmPrimitiveClassRec)

#define SM_H_MARGIN 3
#define SM_V_MARGIN 3
#define SM_F_SPACE 2
#define SM_SCROLLING_SHIFT 4

#define H_MARGIN 3
#define V_MARGIN 3
#define RS_LIMIT 4
#define CELL_DEFAULT_ALIGNMENT XmALIGNMENT_CENTER

#define DELAY_TIME(w)  (XtGetMultiClickTime(XtDisplay(w))/3)

#define NoTimeout ((XtIntervalId) 0)

    
#define GetDefaultFont XmeRenderTableGetDefaultFont
/* Cursors */

#define horizp_width 19
#define horizp_height 13
static unsigned char horizp_bits[] = {
 0x00, 0x00, 0x00, 0xff, 0x07, 0x00, 0xff, 0x07, 0x00, 0x00, 0x06, 0x00,
 0x00, 0x06, 0x00, 0x20, 0x46, 0x00, 0x30, 0xc6, 0x00, 0x38, 0xc6, 0x01,
 0xfc, 0xff, 0x03, 0x38, 0xc6, 0x01, 0x30, 0xc6, 0x00, 0x20, 0x46, 0x00,
 0x00, 0x06, 0x00 };

#define horizm_width 19
#define horizm_height 13
static unsigned char horizm_bits[] = {
 0xff, 0x0f, 0x00, 0xff, 0x0f, 0x00, 0xff, 0x0f, 0x00, 0xff, 0x0f, 0x00,
 0x60, 0x6f, 0x00, 0x70, 0xef, 0x00, 0x78, 0xef, 0x01, 0xfc, 0xff, 0x03,
 0xfe, 0xff, 0x07, 0xfc, 0xff, 0x03, 0x78, 0xef, 0x01, 0x70, 0xef, 0x00,
 0x60, 0x6f, 0x00 };

/************************************************************
*	MACROS
*************************************************************/

#define streq(a, b) (((a) != NULL) && ((b) != NULL) && (strcmp((a), (b)) == 0))
#define IsValidPixmap(p) (((p) != None) && ((p) != XmUNSPECIFIED_PIXMAP))
#define PIX_FOUND(value) ((value <= XmUNSPECIFIED_PIXMAP) ? 0 : 1)

/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/

extern Boolean XmeRenderTableGetDefaultFont (XmFontList, XFontStruct **);

static Widget global_current_widget;		/* static global to hold
						   widget id for qsort. */

/************************************************************
*	STATIC FUNCTION DECLARATIONS
*************************************************************/

/******************************
 * Exported Widget Functions
 ******************************/


static void ClassInitialize();
static void Initialize(Widget, Widget, ArgList, Cardinal *);
static void Realize(Widget, Mask *, XSetWindowAttributes *);
static void Resize(Widget), Redisplay(Widget, XEvent *, Region);
static void Destroy(Widget);
static Boolean SetValues(Widget, Widget, Widget, ArgList, Cardinal *);
static void DestroyGC(XmNlPartResWidget);
static void ResizeDoCallback(Widget w, char status, int source);

/***********************************
 * Internal routines.
 ***********************************/


static void RecalcParam( Widget w);
static Boolean CalcGeom( Widget w, Boolean recalcLabel);
static void ResizeSliders(Widget w);
static void AdjustGlobalShift(Widget w);
static void AdjustGlobalHorShift(Widget w);
static int InternRedisplay (Widget w);
static void HighlightDoCallback(Widget w);
static int BoundSelect(Widget w);
static void FW_SelectUpScroll(XtPointer client_data, XtIntervalId *timer);
static void FW_SelectDownScroll(XtPointer client_data, XtIntervalId *timer);
static void ResizeStuff(XmNlPartResWidget w);
void FreeCellElements(Widget w);
static void CheckSetRenderTable(Widget wid, int offset, XrmValue *value);
/***********************************
 * Actions and Callback function defs.
 ***********************************/

static void VScrollCallback(Widget w, XtPointer client_data, XtPointer call_data); 
static void HScrollCallback(Widget w, XtPointer client_data, XtPointer call_data); 
static void ButtonMotionAction(Widget, XEvent *, String *, Cardinal *);
static void MouseMotionAction(Widget, XEvent *, String *, Cardinal *);
static void ButtonDownAction(Widget, XEvent *, String *, Cardinal *);
static void ButtonUpAction(Widget, XEvent *, String *, Cardinal *);
static void MotionAction(Widget, XEvent *, String *, Cardinal *);
static void ScrollAction(Widget, XEvent *, String *, Cardinal *);
static void KeyPressAction(Widget, XEvent *, String *, Cardinal *);
static void Focus_In(Widget, XEvent *, String *, Cardinal *);
static void Focus_Out(Widget, XEvent *, String *, Cardinal *);
int min_value(int a, int b, int c);

/************************************************************
*	STATIC DECLARATIONS
*************************************************************/



static char defaultTranslations[] =
     "<Btn1Down>:		     ButtonDown()\n\
    <Btn1Motion>:		button_motion()\n\
     <MotionNotify>:		mouse_moution()\n\
     <FocusIn>:		focus_in()\n\
     <FocusOut>:		focus_out()\n\
     Ctrl <Btn1Down>:		   ButtonDown(Extended)\n\
     <Key>Return:        keypress(Enter)\n\
     <Key>osfUp:         keypress(Up)\n\
     <Key>osfDown:       keypress(Down)\n\
     <Key>osfLeft:       keypress(Left)\n\
     <Key>osfRight:      keypress(Right)\n\
     <Key>space:      keypress(Space)\n\
     <Btn4Up>:			Scroll(Up)\n\
     <Btn5Up>:			Scroll(Down)\n\
     <Btn1Up>:			ButtonUp()";

static XtActionsRec actionsList[] =
{
  {"button_motion",	ButtonMotionAction},
  {"mouse_moution",	MouseMotionAction},
  {"ButtonDown",		ButtonDownAction},
  {"ButtonUp",		ButtonUpAction},
  {"Scroll",		ScrollAction},
  {"keypress",     KeyPressAction},
  {"focus_in",     Focus_In},
  {"focus_out",     Focus_Out},
};


/* ARGSUSED */

//static XmPartResource resources[] = {
static XtResource resources[] = {
#define offset(field) XtOffsetOf(XmNlPartResRec, partres.field)
/*  {XmNnumItems, XmCNumItems, XmRInt, sizeof(int),
     offset(num_items), XmRImmediate, (XtPointer) 1},*/
	{XmNnumCols, XmCNumCols, XmRInt, sizeof(int),
		offset(num_items), XmRImmediate, (XtPointer) 1},
	{XmNpartitionsSize, XmCPartitionsSize, XmRPointer, sizeof(XtPointer),
		offset(PartitionsSize), XmRImmediate, (XtPointer) NULL},
	{XmNmaxValue, XmCMaxValue, XmRInt, sizeof(int),
		offset(MaxSize), XmRImmediate, (XtPointer) 100},
/*  {XmNnumCells, XmCNumCells, XmRInt, sizeof(int),
     offset(count_cell), XmRImmediate, (XtPointer) 0},*/
//  {XmNentryData, XmCEntryData, XmRPointer, sizeof(XtPointer),
//     offset(item_data), XmRImmediate, (XtPointer) NULL},
/*  {XmNnumColumns, XmCNumColumns, XmRInt, sizeof(int),
     offset(num_items), XmRImmediate, (XtPointer) 1},*/

  {XmNprefHeight, XmCprefHeight, XmRInt, sizeof(int),
     offset(prefferedHeight), XmRImmediate, (XtPointer) 10},
  {XmNalignment, XmCAlignment, XmRAlignment, sizeof(unsigned char), 
	  offset(default_align), XmRImmediate, (XtPointer) XmALIGNMENT_CENTER},

  {XmNlabelType, XmCLabelType, XmRLabelType, sizeof(unsigned char),
	  offset(default_type), XmRImmediate, (XtPointer) XmSTRING},

  {XmNlabelOrder, XmCLabelOrder, XmRLabelType, sizeof(unsigned char),
	  offset(default_priority), XmRImmediate, (XtPointer) XmPIXMAP},

	{"pri.vate", "Pri.vate", XmRBoolean, sizeof(Boolean),
		offset(MouseMoved), XmRImmediate, (XtPointer)False},

	{XmNfontList,	XmCFontList, XmRFontList, sizeof (XmFontList),
		offset (font_list), XmRCallProc, (XtPointer)CheckSetRenderTable},

	{XmNrenderTable, XmCRenderTable, XmRRenderTable, sizeof(XmRenderTable),
		offset(font_list), XmRCallProc, (XtPointer)CheckSetRenderTable},

//  {XmNfontList,	XmCFontList, XmRFontList, sizeof (XmFontList),
//     offset (font_list), XmRImmediate, (XtPointer) NULL},
//  {XmNverticalScrollBar, XmCScrollBar, XmRWidget, sizeof (Widget),
//     offset (v_bar), XmRImmediate, (XtPointer) NULL},
//  {XmNverticalScrollBar, XmCVerticalScrollBar, XmRWidget, sizeof (Widget),
//     offset (v_bar), XmRImmediate, (XtPointer) NULL},
//  {XmNhorizontalScrollBar, XmCScrollBar, XmRWidget, sizeof (Widget),
//     offset (h_bar), XmRImmediate, (XtPointer) NULL},
//  {XmNhorizontalScrollBar, XmCHorizontalScrollBar, XmRWidget, sizeof (Widget),
//     offset (h_bar), XmRImmediate, (XtPointer) NULL},
/*  {XmNBackground, XmCBackground, XtRPixel, sizeof(Pixel),
    offset(background_pixel), XmRImmediate, (XtPointer) NULL},
  {XmNForeground, XmCForeground, XtRPixel, sizeof(Pixel),
    offset(foreground_pixel), XmRImmediate, (XtPointer) NULL},
  {XmNSelectBackground, XmCBackground, XtRPixel, sizeof(Pixel),
    offset(select_background_pixel), XmRImmediate, (XtPointer) NULL},*/
  {XmNlayoutFrozen, XmCLayoutFrozen, XmRBoolean, sizeof(Boolean),
    offset(LayoutFrozen), XmRImmediate, (XtPointer) NULL},

  {XmNchangePartOn, XmCChangePartOn, XmRBoolean, sizeof(Boolean),
    offset(RepartingOn), XmRImmediate, (XtPointer) True},

/*  {XmNSelectForeground, XmCForeground, XtRPixel, sizeof(Pixel),
    offset(select_foreground_pixel), XmRImmediate, (XtPointer) NULL},*/
  {XtNchangePartCallback, XmCCallback, XmRCallback,sizeof(XtCallbackList),
    offset(changeCallback), XmRImmediate, (XtPointer) NULL},
  {XtNchangeStructPartCallback, XmCCallback, XmRCallback,sizeof(XtCallbackList),
    offset(changeStructPartCallback), XmRImmediate, (XtPointer) NULL},
  {XtNstartMovePartCallback, XmCCallback, XmRCallback,sizeof(XtCallbackList),
    offset(startMoveCallback), XmRImmediate, (XtPointer) NULL},
  {XtNmovePartCallback, XmCCallback, XmRCallback,sizeof(XtCallbackList),
    offset(moveCallback), XmRImmediate, (XtPointer) NULL},

	{XtNhighlightCallback, XmCCallback, XmRCallback,sizeof(XtCallbackList),
     offset(highlightCallback), XmRImmediate, (XtPointer) NULL},

  {XmNlprResizeCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
     offset(resizeCallback), XmRImmediate, (XtPointer) NULL},

  {XmNPRmod, XmCPRmod, XmRChar, sizeof (char),
    offset(ResizeMode), XmRImmediate, (XtPointer) XmNPR_Manual},

	{XmNlBufferingOn, XmCbufferingOn, XmRBoolean, sizeof(Boolean), 
		offset(buffering), XmRImmediate, (XtPointer) False},
//  {XtNhighlightCallback, XmCCallback, XmRCallback,sizeof(XtCallbackList),
//     offset(highlightCallback), XmRImmediate, (XtPointer) NULL},
//  {XmNdoubleClickCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
//     offset(double_click), XmRImmediate, (XtPointer) NULL},
#undef offset
};


XmNlPartResClassRec xmNlPartResClassRec = {
  { /* core fields */
    /* superclass		*/	SUPERCLASS,
    /* class_name		*/	"XmNlPartRes",
    /* widget_size		*/	sizeof(XmNlPartResPart),
    /* class_initialize		*/	ClassInitialize,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	actionsList,
    /* num_actions		*/	XtNumber(actionsList),
    /* resources		*/	(XtResource*)resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	XtExposeCompressMultiple,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	Resize,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	defaultTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* Xmprimitive fields */
      NULL,			/* border_highlight   */
      NULL,			/* border_unhighlight */
      /*NULL,*/   XtInheritTranslations,    /* translations       */
      NULL,                     /* arm_and_activate   */
      NULL,   		/* syn resources      */
      0,		/* num syn_resources  */
      NULL                      /* extension          */
  },
  { /* ICS List fields */
      NULL                      /* extension          */
  }
};

WidgetClass xmNlPartResWidgetClass = (WidgetClass)&xmNlPartResClassRec;

XmOffsetPtr XmNlPartRes_offsets;

static void ResizeManual(Widget w, Boolean recalc);
static void
ResizePartAuto(Widget w);

/************************************************************
*	STATIC (EXPORTED) CODE
*************************************************************/
static void CheckRenderOrder(XmNlPartResWidget pres)
{
	XmDirection direction = ((XmPrimitiveWidget)(pres))->primitive.layout_direction;
	
	if (direction == XmRIGHT_TO_LEFT_TOP_TO_BOTTOM || direction == XmRIGHT_TO_LEFT_BOTTOM_TO_TOP || direction == XmTOP_TO_BOTTOM_RIGHT_TO_LEFT
		|| direction == XmBOTTOM_TO_TOP_RIGHT_TO_LEFT || direction == XmRIGHT_TO_LEFT)  
	{
		pres->partres.render_order = RtoL_render;
		return ;
	}	
		
	if (direction == XmLEFT_TO_RIGHT_TOP_TO_BOTTOM || direction == XmLEFT_TO_RIGHT_BOTTOM_TO_TOP || direction == XmTOP_TO_BOTTOM_LEFT_TO_RIGHT
		|| direction == XmBOTTOM_TO_TOP_LEFT_TO_RIGHT || direction == XmLEFT_TO_RIGHT)
	{
		pres->partres.render_order = LtoR_render;
		return ;
	}	

	pres->partres.render_order = LtoR_render;
	return ;
}

static void AddDefaultCells(XmNlPartResWidget pres, int cnt)
{
	int i;
	XmNlPR_Cell * cell = pres->partres.item_data;
	
	for (i = cnt; i < pres->partres.num_items; i++)
	{
		cell[i].info_type = pres->partres.default_type;
		cell[i].alignment = pres->partres.default_align;
		cell[i].pixmap = XmUNSPECIFIED_PIXMAP;
		cell[i].mask = XmUNSPECIFIED_PIXMAP;
		cell[i].pix_h = 0;
		cell[i].pix_w = 0;
		if (pres->partres.default_priority == XmPIXMAP_AND_STRING)
			cell[i].priority = XmPIXMAP;
		else
			cell[i].priority = pres->partres.default_priority;

		if (cell[i].info_type == XmSTRING || cell[i].info_type == XmPIXMAP)
			cell[i].real_width = 2 * pres->primitive.shadow_thickness + 2 * H_MARGIN;

		if (cell[i].info_type == XmPIXMAP_AND_STRING)
			cell[i].real_width = 2 * pres->primitive.shadow_thickness + 3 * H_MARGIN;

		cell[i].current_width = pres->partres.item_data[i].real_width;
		cell[i].xmlabel = NULL;
		cell[i].label_h = 0;
		cell[i].label_w = 0;
	}
}

static void AssignDefaultPartitions(Widget w)
{
	XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i, n, sum = 0;
	

	if (pres->partres.num_items > 0)
	{
		n = pres->partres.MaxSize / pres->partres.num_items;
		if (pres->partres.item_data)
		{
			for (i = 0; i < pres->partres.num_items; i++)
			{
				pres->partres.item_data[i].value = n;
				sum = sum + n;
			}
			if (sum < pres->partres.MaxSize)
				pres->partres.item_data[pres->partres.num_items - 1].value = n + (pres->partres.MaxSize - sum);
		}
	}
}

static void CreateDefaultCells(Widget w)
{
	XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i, n, sum = 0;
	
	if (pres->partres.num_items > 0)
	{
		n = pres->partres.MaxSize / pres->partres.num_items;
		pres->partres.item_data = calloc(pres->partres.num_items, sizeof(XmNlPR_Cell));
		if (pres->partres.item_data)
		{
			for (i = 0; i < pres->partres.num_items; i++)
			{
				pres->partres.item_data[i].info_type = pres->partres.default_type;
				pres->partres.item_data[i].alignment = pres->partres.default_align;
				pres->partres.item_data[i].pixmap = XmUNSPECIFIED_PIXMAP;
				pres->partres.item_data[i].mask = XmUNSPECIFIED_PIXMAP;
				if (pres->partres.default_priority == XmPIXMAP_AND_STRING)
					pres->partres.item_data[i].priority = XmPIXMAP;
				else
					pres->partres.item_data[i].priority = pres->partres.default_priority;
				if (pres->partres.item_data[i].info_type == XmSTRING || pres->partres.item_data[i].info_type == XmPIXMAP)
					pres->partres.item_data[i].real_width = 2 * pres->primitive.shadow_thickness + 2 * H_MARGIN;
				if (pres->partres.item_data[i].info_type == XmPIXMAP_AND_STRING)
					pres->partres.item_data[i].real_width = 2 * pres->primitive.shadow_thickness + 3 * H_MARGIN;
				pres->partres.item_data[i].current_width = pres->partres.item_data[i].real_width;
				
				pres->partres.item_data[i].value = n;
				sum = sum + n;
			}
			if (sum < pres->partres.MaxSize)
				pres->partres.item_data[pres->partres.num_items - 1].value = n + (pres->partres.MaxSize - sum);
		}
	}
}

static void CopyCells(XmNlPR_Cell * dest, XmNlPR_Cell * src , int cnt)
{
	int i;
	for (i = 0; i < cnt; i++)
	{
		dest[i].pixmap = src[i].pixmap;
		dest[i].mask = src[i].mask;
		dest[i].pix_w = src[i].pix_w;
		dest[i].pix_h = src[i].pix_h;
		dest[i].text = src[i].text;
		if (src[i].xmlabel)
			dest[i].xmlabel = XmStringCopy(src[i].xmlabel);
		dest[i].label_w = src[i].label_w;
		dest[i].label_h = src[i].label_h;
		dest[i].real_width = src[i].real_width;
		dest[i].current_width = src[i].current_width;
		dest[i].info_type = src[i].info_type;
		dest[i].resizible = src[i].resizible;
		dest[i].autoresize = src[i].autoresize;
		dest[i].align_type = src[i].align_type;
		dest[i].displayed = src[i].displayed;
		dest[i].alignment = src[i].alignment;
		dest[i].priority = src[i].priority;
		dest[i].x = src[i].x;
	}
}

static void ClearCellsFrom(XmNlPartResWidget pres, int cnt)
{
	int i;
	XmNlPR_Cell * cell = pres->partres.item_data;
#ifdef DEBUG
      printf("\n ClearCellsFrom: %d \n", cnt);
#endif
	for (i = pres->partres.num_items; i < cnt; i++)
	{
		if (cell[i].pixmap > XmUNSPECIFIED_PIXMAP)
			XFreePixmap(XtDisplay((Widget) pres), cell[i].pixmap);
		if (cell[i].mask > XmUNSPECIFIED_PIXMAP)
			XFreePixmap(XtDisplay((Widget) pres), cell[i].mask);
		if (cell[i].xmlabel)
			XmStringFree(cell[i].xmlabel);
		cell[i].xmlabel = NULL;
	}
}


static void	CleanCells(Widget w, XmNlPR_Cell * cell, int label_cnt, int pix_cnt)
{
	int i;
	
#ifdef DEBUG
      printf("\n CleanCells: %d %d \n", label_cnt, pix_cnt);
#endif
	for (i = 0; i < label_cnt; i++)
	{
		if (i > pix_cnt)
		{
			if (cell[i].pixmap > XmUNSPECIFIED_PIXMAP)
				XFreePixmap(XtDisplay(w), cell[i].pixmap);
			if (cell[i].mask > XmUNSPECIFIED_PIXMAP)
				XFreePixmap(XtDisplay(w), cell[i].mask);
		}
		if (cell[i].xmlabel)
			XmStringFree(cell[i].xmlabel);
	}
}


static void
DestroyGC(XmNlPartResWidget w)
{
	XtReleaseGC((Widget) w, w->partres.drawGC);
	XtReleaseGC((Widget) w, w->partres.pixGC);
	XtReleaseGC((Widget) w, w->partres.eorGC);
	XtReleaseGC((Widget) w, w->partres.highlightGC);
	XtReleaseGC((Widget) w, w->partres.top_GC);
	XtReleaseGC((Widget) w, w->partres.bottom_GC);
}

static void
InitializeGC(XmNlPartResWidget w)
{
	XGCValues values;
	XtGCMask mask;

	values.line_style = LineSolid;
	values.line_width = 1;
	values.fill_style = FillSolid;
	values.background = w->partres.background_pixel;
	values.foreground = w->partres.foreground_pixel;

	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground;
	w->partres.drawGC = XtGetGC((Widget) w, mask, &values);

	values.function = GXcopy;
	mask = GCFunction;
	w->partres.pixGC = XtGetGC((Widget) w, mask, &values);


	w->partres.top_GC = XtGetGC((Widget) w, mask, &values);
	w->partres.bottom_GC = XtGetGC((Widget) w, mask, &values);

	values.function = GXinvert;
	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground | GCFunction;
	w->partres.eorGC = XtGetGC((Widget) w, mask, &values);

	values.background = (Pixel)XtDefaultForeground;
	values.foreground = w->core.background_pixel;
	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground ;
	w->partres.highlightGC = XtGetGC((Widget) w, mask, &values);
}



static void
CheckSetRenderTable(Widget wid, int offset, XrmValue *value)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) wid;

	if (pres->partres.MouseMoved)
		value->addr = NULL;
	else
	{
		value->addr = (char*)&(pres->partres.font_list);
		pres->partres.MouseMoved = True;
	}
	
}

/*      Function Name: ClassInitialize
 *      Description:   Inits class-specific data (offsets)
 *      Arguments:     none
 *      Returns:       nothing
 */
static void
ClassInitialize()
{
    XmResolveAllPartOffsets(xmNlPartResWidgetClass,
			    &XmNlPartRes_offsets,
			    NULL);
}

/*	Function Name: Initialize
 *	Description:   Called to initialize information specific
 *                     to this widget.
 *	Arguments:     req - what was originally requested.
 *                     set - what will be created (our superclassed have
 *                           already mucked with this)
 *                     args, num_args - The arguments passed to
 *                                      the creation call.
 *	Returns:       none.
 */

/*ARGSUSED*/
static void Initialize(Widget req, Widget set, 
		       ArgList args, Cardinal * num_args)
{
	Display *dpy;
	Pixmap pix, pixMask;
	XColor bg, fg;
    XmNlPartResWidget pres = (XmNlPartResWidget) set;
	XFontStruct *font;
	Boolean fontFound;
    int i;

	printf("\n PartRes Init w %d h %d\n", pres->core.width, pres->core.height);

#ifdef DEBUG
	printf("\n Initialize %d %d \n", pres->partres.num_items, ((XmNlPartResWidget) req)->partres.num_items);


    for (i = 0; i < *num_args; i++)
    {
		String name = args[i].name;
		printf("Name %s\n", name);
		if (streq(XmNnumColumns, name))
		{
			printf("Value %ld\n", args[i].value);
		}
		if (streq(XmNnumItems, name))
		{
			printf("Value %ld\n", args[i].value);
		}
	}


#endif


//      ft=XLoadFont(XtDisplay(set), "helvetica");
//	ibox->itbox.font=XtDefaultFont;
	dpy = XtDisplay(set);
	pres->partres.font = XLoadQueryFont(XtDisplay(set), "fixed");

	if (pres->partres.font_list == NULL)
		pres->partres.font_list = XmeGetDefaultRenderTable(set, XmTEXT_FONTLIST);
	pres->partres.font_list = XmFontListCopy(pres->partres.font_list);


//	pres->partres.item_data=NULL;
	pres->partres.viewHeight = 0;
	pres->partres.lastViewHeight = 0;
	pres->partres.viewWidth = 0;
	pres->partres.lastViewWidth = 0;
	pres->partres.prefferedHeight = 0;
	
	pres->partres.LayoutFrozen = False;
	pres->partres.ChangeInFrozen = False;
	pres->partres.ResizeState = False;
	pres->partres.CurrentResizerPos = -1;
	pres->partres.LastResizerPos = -1;
//	pres->partres.count_cell = 0;


	if (pres->partres.num_items > 0)
		CreateDefaultCells(set);
		
	if (pres->partres.num_items > 0)
		pres->partres.ElSharpSize = (int *)XtMalloc(pres->partres.num_items * sizeof(int));
	else
		pres->partres.ElSharpSize = NULL;

	if (pres->partres.num_items > 0)
		pres->partres.ElCurSize = (int *)XtMalloc(pres->partres.num_items * sizeof(int));
	else
		pres->partres.ElCurSize = NULL;

	if (pres->partres.num_items > 0)
		pres->partres.ElNewSize = (int *)XtMalloc(pres->partres.num_items * sizeof(int));
	else
		pres->partres.ElNewSize = NULL;


    for (i = 0; i < *num_args; i++)
    {
		String name = args[i].name;
		if (streq(XmNpartitionsSize, name))
		{
#ifdef DEBUG
			printf("XmNlPartRes: Partitions Size set in Initialize procedure\n");
#endif
			if (pres->partres.PartitionsSize && pres->partres.num_items > 0)
			{
				for (i = 0; i < pres->partres.num_items; i++)
				{
					pres->partres.item_data[i].value = pres->partres.PartitionsSize[i];
#ifdef DEBUG
					printf("XmNlPartRes: column %d assigned %d input %d\n", i, pres->partres.item_data[i].value, pres->partres.PartitionsSize[i]);
#endif
				}
			}
			break;
		}
	}



//	pres->partres.num_cols = 0;
	pres->partres.cell_width = 0;
	pres->partres.cell_height = 0;
	pres->partres.RealW = NULL;
//	pres->partres.pix_buf_w = 0;
//	pres->partres.pix_buf_h = 0;
	pres->partres.col_num = 0;
	pres->partres.row_num = 0;
	pres->partres.max_icon_height = 0;
	pres->partres.max_icon_width = 0;
	pres->partres.pix = XmUNSPECIFIED_PIXMAP;
	pres->partres.full_height = 0;
	pres->partres.full_width = 0;
	pres->partres.scroll_height = 0;
//	pres->partres.pix_buf_row = 0;
//	pres->partres.pix_shift = 0;
	pres->partres.global_v_shift = 0;
	pres->partres.global_h_shift = 0;
/*	pres->partres.v_shift_in_pix = 0;
	pres->partres.multiclick = 500;
	pres->partres.sm_tm = 0;
	pres->partres.auto_scroll = 0;

	pres->partres.m_select = 0;
	pres->partres.m_x1 = 0;
	pres->partres.m_x2 = 0;
	pres->partres.m_y1 = 0;
	pres->partres.m_y2 = 0;
	pres->partres.m_last_x1 = 0;
	pres->partres.m_last_x2 = 0;
	pres->partres.m_last_y1 = 0;
	pres->partres.m_last_y2 = 0;
	pres->partres.m_cur_x = 0;
	pres->partres.m_cur_y = 0;

	pres->partres.cur_sel_count = 0;
	pres->partres.old_sel_count = 0;
	pres->partres.cur_sel_massiv = NULL;
	pres->partres.old_sel_massiv = NULL;*/
//	pres->partres.DblClicked=False;
//	pres->partres.clicked_item=-1;
//	pres->partres.current_item=-1;
//	pres->partres.HasFocus=False;

//      itm=partres->itbox.item_data;
//	itm->name=NULL;
    pres->partres.background_pixel = ((XmPrimitiveWidget)req)->core.background_pixel;
    pres->partres.foreground_pixel = ((XmPrimitiveWidget)req)->primitive.foreground;

	InitializeGC(pres);

	fg.red = ~0;
	fg.green = ~0;
	fg.blue = ~0;
	fg.pixel = WhitePixelOfScreen(XtScreen(set));
	fg.flags = DoRed | DoGreen | DoBlue;
	bg.red = 0;
	bg.green = 0;
	bg.blue = 0;
	bg.pixel = BlackPixelOfScreen(XtScreen(set));
	bg.flags = DoRed | DoGreen | DoBlue;

    pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		(char *)horizp_bits, horizp_width, horizp_height, 0, 1, 1);
    pixMask = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		(char *)horizm_bits, horizm_width, horizm_height, 1, 0, 1);
	pres->partres.hResizeCursor = XCreatePixmapCursor(dpy, pix, pixMask,
		&fg, &bg, 9, 9);
	XFreePixmap(dpy, pix);
	XFreePixmap(dpy, pixMask);
	
#ifdef DEBUG
	printf("\n PartRes Initialize before size check %d %d %d %d\n", req->core.width, req->core.height, set->core.width, set->core.height);
#endif
	
	fontFound = XmeRenderTableGetDefaultFont(pres->partres.font_list, &font);

#ifdef DEBUG
	if (fontFound)
		printf("\n PartRes Initialize font found\n");
//		printf("PR ascend %d descend %d\n", font->ascent, font->descent);
#endif

	if (XtHeight(req) == 0)
	{
		Dimension height;
		if (fontFound)
			height = font->ascent + font->descent + 
					4*((XmPrimitiveWidget)set)->primitive.shadow_thickness + 2 * V_MARGIN;
//			height = font->ascent + font->descent + 
//					4*((XmPrimitiveWidget)set)->primitive.shadow_thickness + 
//					2*((XmPrimitiveWidget)set)->primitive.highlight_thickness + 2 * V_MARGIN;
		else
			height = 14 + 
					4*((XmPrimitiveWidget)set)->primitive.shadow_thickness + 2 * V_MARGIN;
//			height = 14 + 
//					4*((XmPrimitiveWidget)set)->primitive.shadow_thickness + 
//					2*((XmPrimitiveWidget)set)->primitive.highlight_thickness + 2 * V_MARGIN;
		
		pres->core.height = height;
		pres->partres.prefferedHeight = height;
	}

	if (XtWidth(req) == 0)
	{
		Dimension width;
		if (fontFound)
		{
			if (pres->partres.num_items <= 1)
				width = (font->ascent + font->descent) * 16 + 
					4*((XmPrimitiveWidget)set)->primitive.shadow_thickness + 2 * V_MARGIN
					+ 2*((XmPrimitiveWidget)set)->primitive.highlight_thickness;
			else
				if (pres->partres.num_items < 6)
					width = ((font->ascent + font->descent) * 8 + 
						2*((XmPrimitiveWidget)set)->primitive.shadow_thickness + 2 * V_MARGIN)
						* pres->partres.num_items + 
						2*((XmPrimitiveWidget)set)->primitive.shadow_thickness +
						2*((XmPrimitiveWidget)set)->primitive.highlight_thickness;
				else
					width = (font->ascent + font->descent) * 30 + 
						4*((XmPrimitiveWidget)set)->primitive.shadow_thickness + 2 * V_MARGIN
						+ 2*((XmPrimitiveWidget)set)->primitive.highlight_thickness;
		}
		else
		{
			if (pres->partres.num_items <= 1)
				width = 180 + 
					4*((XmPrimitiveWidget)set)->primitive.shadow_thickness + 2 * V_MARGIN
					+ 2*((XmPrimitiveWidget)set)->primitive.highlight_thickness;
			else
				if (pres->partres.num_items < 6)
					width = (20 + 
						2*((XmPrimitiveWidget)set)->primitive.shadow_thickness + 2 * V_MARGIN)
						* pres->partres.num_items + 
						2*((XmPrimitiveWidget)set)->primitive.shadow_thickness +
						2*((XmPrimitiveWidget)set)->primitive.highlight_thickness;
				else
					width = 240 + 
						4*((XmPrimitiveWidget)set)->primitive.shadow_thickness + 2 * V_MARGIN
						+ 2*((XmPrimitiveWidget)set)->primitive.highlight_thickness;
		}
		pres->core.width = width;
	}

	{
		XtWidgetProc resize;
	//	_XmProcessLock();
		resize = set->core.widget_class->core_class.resize;
	//	_XmProcessUnlock();

		(* (resize)) ((Widget) set);
	}
#ifdef DEMO
    _XmInitialIzeConverters(req);
#endif
#ifdef DEBUG
	printf("\n PartRes Initialize OK %d %d\n", set->core.width, set->core.height);
	fflush(stdout);
#endif

}

/*	Function Name: Realize
 *	Description:   Called to realize this widget.
 *	Arguments:     w - PartRes Widget to realize.
 *                     valueMask, attributes - attributes to use when creating
 *                     this widget's window.
 *	Returns:       none.
 *
 *      This overrides the Manager's frobbing with various values.
 */

static void 
Realize(Widget w, Mask *valueMask, XSetWindowAttributes * attributes)
{
	XmNlPartResWidget pres = (XmNlPartResWidget)w;

	CheckRenderOrder(pres);
#ifdef DEBUG
	printf("Partres Realize start w = %d h = %d\n", w->core.width, w->core.height);
#endif

	if (pres->partres.render_order == LtoR_render) 
//		attributes->bit_gravity = ForgetGravity;
		attributes->bit_gravity = NorthWestGravity;
	else
//		attributes->bit_gravity = ForgetGravity;
		attributes->bit_gravity = NorthEastGravity;
	
    *valueMask |= CWBitGravity;

//    CreateGCs(w);



    (*xmNlPartResWidgetClass->core_class.superclass->core_class.realize)
	(w, valueMask, attributes);

//#define	superclass	(&xmPrimitiveClassRec)
//  (*superclass->core_class.realize) (w, valueMask, attributes);
//#undef	superclass
//	XtResizeWidget(w, w->core.width, pres->partres.prefferedHeight, 0);
    (*xmNlPartResWidgetClass->core_class.resize)(w);

#ifdef DEBUG
	printf("Partres Realize complete\n");
#endif
}

/*	Function Name: SetValues
 *	Description:   Called when some widget data needs to be modified on-
 *                     the-fly.
 *	Arguments:     current - the current (old) widget values.
 *                     request - before superclassed have changed things.
 *                     set - what will acutally be the new values. 
 *                     args, num_args - the arguments in the list.
 *	Returns:       none
 *
 */

/*ARGSUSED*/
static Boolean SetValues(Widget current, Widget request, Widget set,
			 ArgList args, Cardinal * num_args)
{
    XmNlPartResWidget 	l_old = (XmNlPartResWidget)current;
    XmNlPartResWidget	l_set = (XmNlPartResWidget)set;
    register int i;
    int n;
    Boolean 	redisplay = False;
    Boolean		recalculateFull = False;
    Boolean		recalculateGeom = False;
    Boolean		refreshGC = False;
    Boolean		refreshBuf = False;
    Boolean		resizeNeed = False;

#ifdef DEBUG
      printf("\n SetValues \n");
#endif


/** At first step check of columns number changing **/

    for (i = 0; i < *num_args; i++)
    {
		String name = args[i].name;

		if (streq(XmNnumCols, name))
		{
			if (l_set->partres.num_items != l_old->partres.num_items)
			{
				if (l_set->partres.num_items <= 0)
					l_set->partres.num_items = l_old->partres.num_items;
				else
				{
					recalculateFull = True;
					redisplay = True;
#ifdef DEBUG
					printf("\n PartRes SetValues 1: new number of columns = %d old number of columns = %d\n",l_set->partres.num_items, l_old->partres.num_items);
#endif
					if (l_set->partres.num_items < l_old->partres.num_items)
					{
#ifdef DEBUG
						printf("Old ptr %p\n", l_set->partres.item_data);
#endif
						ClearCellsFrom(l_set, l_old->partres.num_items);
						l_set->partres.item_data = realloc(l_set->partres.item_data, l_set->partres.num_items * sizeof(XmNlPR_Cell));
#ifdef DEBUG
						printf("New ptr %p\n", l_set->partres.item_data);
#endif
/*						CreateDefaultCells(set);
						CopyCells(l_set->partres.item_data, l_old->partres.item_data, l_set->partres.num_items);
						CleanCells(current, l_old->partres.item_data, l_old->partres.num_items, l_set->partres.num_items);
						if (l_old->partres.item_data)
							free((void *) l_old->partres.item_data);*/
					}
					else
					{
#ifdef DEBUG
					printf("\n PartRes SetValues 2: new number of columns = %d old number of columns = %d\n",l_set->partres.num_items, l_old->partres.num_items);
#endif
#ifdef DEBUG
						printf("Old ptr %p\n", l_set->partres.item_data);
#endif
						l_set->partres.item_data = realloc(l_set->partres.item_data, l_set->partres.num_items * sizeof(XmNlPR_Cell));
						memset(l_set->partres.item_data + l_old->partres.num_items, 0, (l_set->partres.num_items - l_old->partres.num_items) * sizeof(XmNlPR_Cell));
#ifdef DEBUG
						printf("Size %ld Nsize %ld\n", sizeof(XmNlPR_Cell), l_set->partres.num_items * sizeof(XmNlPR_Cell));
						printf("New ptr %p + %ld\n", l_set->partres.item_data, l_set->partres.num_items * sizeof(XmNlPR_Cell));
#endif
						AddDefaultCells(l_set, l_old->partres.num_items);
/*						CreateDefaultCells(set);
						CopyCells(l_set->partres.item_data, l_old->partres.item_data, l_old->partres.num_items);
						CleanCells(current, l_old->partres.item_data, l_old->partres.num_items, l_old->partres.num_items);
						if (l_old->partres.item_data)
							free((void *) l_old->partres.item_data);*/
					}

					AssignDefaultPartitions(set);
					
					if (l_set->partres.ElSharpSize)
						XtFree((char *)l_set->partres.ElSharpSize);
					l_set->partres.ElSharpSize = (int *)XtMalloc(l_set->partres.num_items * sizeof(int));

					if (l_set->partres.ElCurSize)
						XtFree((char *)l_set->partres.ElCurSize);
					l_set->partres.ElCurSize = (int *)XtMalloc(l_set->partres.num_items * sizeof(int));

					if (l_set->partres.ElNewSize)
						XtFree((char *)l_set->partres.ElNewSize);
					l_set->partres.ElNewSize = (int *)XtMalloc(l_set->partres.num_items * sizeof(int));
					
					resizeNeed = True;
					
					printf("PR set ok\n");
				}
			}
		}
	}

/** After checking of columns number changing check all others values **/

    for (i = 0; i < *num_args; i++)
    {
		String name = args[i].name;

		if (streq(XmNPRmod, name))
		{
			if (l_set->partres.ResizeMode != l_old->partres.ResizeMode)
			{
/*				FreeCellElements(set);
				l_set->partres.num_items = 0;*/
				recalculateFull = True;
				redisplay = True;
			}
#ifdef DEBUG
		  printf("\n number of cols=%d \n",l_set->partres.num_cols );
#endif
		}
		
		if (streq(XmNpartitionsSize, name))
		{
			if (l_set->partres.PartitionsSize && l_set->partres.item_data)
			{
				for (n = 0; n < l_set->partres.num_items; n++)
				{
					l_set->partres.item_data[n].value = l_set->partres.PartitionsSize[n];
				}
				resizeNeed = True;
				redisplay = True;
			}
#ifdef DEBUG
		  printf("\n Change partitions sizes\n");
#endif
		}

		if (streq(XmNBackground, name))
		{
			refreshBuf = True;
			redisplay = True;
#ifdef DEBUG
		  printf("\n changed\n");
#endif
		}

		if (streq(XmNForeground, name))
		{
			refreshBuf = True;
			redisplay = True;
#ifdef DEBUG
		  printf("\n changed\n");
#endif
		}

		if (streq(XmNSelectForeground, name))
		{
			refreshBuf = True;
			redisplay = True;
#ifdef DEBUG
		  printf("\n changed\n");
#endif
		}

		if (streq(XmNSelectBackground, name))
		{
			refreshBuf = True;
			redisplay = True;
#ifdef DEBUG
		  printf("\n changed\n");
#endif
		}

		if (streq(XmNfontList, name))
		{
			recalculateFull = True;
			recalculateGeom = True;
			refreshBuf = True;
			redisplay = True;
#ifdef DEBUG
		  printf("\n fontlist changed\n");
#endif
		}

		if (streq(XmNrenderTable, name))
		{
			recalculateFull = True;
			recalculateGeom = True;
			refreshBuf = True;
			redisplay = True;
#ifdef DEBUG
		  printf("\n renderTable changed\n");
#endif
		}
    }

/*    if ((l_set->partres.LayoutFrozen != l_old->partres.LayoutFrozen) &&
	(l_set->partres.LayoutFrozen == False))
    {
		if (l_old->partres.ChangeInFrozen == True || l_set->partres.ChangeInFrozen == True)
		{
			l_old->partres.ChangeInFrozen = False;
			l_set->partres.ChangeInFrozen = False;
			recalculateFull = True;
			recalculateGeom = True;
			refreshBuf = True;
			redisplay = True;
		}
	}
*/
/*    if ((l_set->partres.v_bar != l_old->partres.v_bar) ||
	(l_set->partres.h_bar != l_old->partres.h_bar))
    {

	XtAddCallback(l_set->partres.v_bar, XmNvalueChangedCallback,
		      VScrollCallback, (XtPointer) set);
 	XtAddCallback(l_set->partres.v_bar, XmNdragCallback,
 		      VScrollCallback, (XtPointer) set);

	XtAddCallback(l_set->partres.h_bar, XmNvalueChangedCallback,
		      HScrollCallback, (XtPointer) set);
 	XtAddCallback(l_set->partres.h_bar, XmNdragCallback,
 		      HScrollCallback, (XtPointer) set);

    }*/


	if (((XmPrimitiveWidget)set)->core.background_pixel != ((XmPrimitiveWidget)current)->core.background_pixel)
	{
		l_set->partres.background_pixel=((XmPrimitiveWidget)set)->core.background_pixel;
	    refreshBuf = True;
	    redisplay = True;
	}
	if (((XmPrimitiveWidget)set)->primitive.foreground != ((XmPrimitiveWidget)current)->primitive.foreground)
	{
		l_set->partres.foreground_pixel=((XmPrimitiveWidget)set)->primitive.foreground;
	    refreshBuf = True;
	    redisplay = True;
	}
	
    if ((((XmPrimitiveWidget)set)->primitive.shadow_thickness != ((XmPrimitiveWidget)current)->primitive.shadow_thickness) ||
	(((XmPrimitiveWidget)set)->primitive.highlight_thickness != ((XmPrimitiveWidget)current)->primitive.highlight_thickness))
	{
	    recalculateGeom = True;
	    redisplay = True;
#ifdef DEBUG
      printf("\n number=%d \n",l_set->partres.num_items );
#endif
	}

    if (refreshGC)
    {
		DestroyGC(l_set);
		InitializeGC(l_set);
    }
    if (recalculateFull)
    {
    	RecalcParam( set);
		l_set->partres.global_v_shift=0;
		l_set->partres.global_h_shift=0;
//		printf("PR recalcfull\n");
    }
    if (recalculateFull || recalculateGeom)
    {
		ResizeStuff(l_set);
    	refreshBuf = CalcGeom(set, True);
#ifdef DEBUG
		printf("\n PartRes CalcGeom\n");
#endif
    }
    if (resizeNeed)
    {
		if (l_set->partres.ResizeMode == XmNPR_Manual)
		{
			if (l_set->partres.resizeCallback)
				ResizeDoCallback(set, XmNlItemsFound, XmNlContentChange);
			else
				ResizeManual(set, True);
		}
		else
			ResizePartAuto(set);
	}
//    if (recalculateFull || recalculateGeom || refreshBuf) PutToPixLarge( set );

#ifdef DEBUG
		printf("\n PartRes SetValue preffered %d current %d c_w %d\n", l_set->partres.prefferedHeight, set->core.height, set->core.width);
#endif
	if (refreshBuf) 
	{
#ifdef DEBUG
		printf("^^^^^^^^^^^ Do XtResizeWidget\n");
#endif
		XtResizeWidget(set, set->core.width, l_set->partres.prefferedHeight, 0);
	}
	
#ifdef DEBUG
		printf("PartRes: set values finished\n");
#endif
	
	if (!XtIsRealized(current))
		return False;

	return(TRUE);

	return(redisplay);
}

static void
ResizeStuff(XmNlPartResWidget w)
{
	XRectangle clip;

/*  w->partres.viewWidth = w->core.width - 2*((XmPrimitiveWidget)(w))->primitive.shadow_thickness
    - 2*((XmPrimitiveWidget)(w))->primitive.highlight_thickness;
  w->partres.viewHeight = w->core.height - 2*((XmPrimitiveWidget)(w))->primitive.shadow_thickness
    - 2*((XmPrimitiveWidget)(w))->primitive.highlight_thickness;*/

	w->partres.lastViewWidth = w->partres.viewWidth;
	w->partres.lastViewHeight = w->partres.viewHeight;
  
	w->partres.viewWidth = w->core.width - 2*((XmPrimitiveWidget)(w))->primitive.shadow_thickness;
	w->partres.viewHeight = w->core.height - 2*((XmPrimitiveWidget)(w))->primitive.shadow_thickness;



/*  w->partres.viewX=((XmPrimitiveWidget)(w))->primitive.shadow_thickness+((XmPrimitiveWidget)(w))->primitive.highlight_thickness;
  w->partres.viewY=((XmPrimitiveWidget)(w))->primitive.shadow_thickness+((XmPrimitiveWidget)(w))->primitive.highlight_thickness;*/


	w->partres.viewX=((XmPrimitiveWidget)(w))->primitive.shadow_thickness;
	w->partres.viewY=((XmPrimitiveWidget)(w))->primitive.shadow_thickness;


	clip.x = w->partres.viewX;
	clip.y = w->partres.viewY;
	clip.width = w->partres.viewWidth;
	clip.height = w->partres.viewHeight;
	XSetClipRectangles(XtDisplay((Widget) w), w->partres.drawGC,
						0, 0, &clip, 1, Unsorted);
	XSetClipRectangles(XtDisplay((Widget) w), w->partres.eorGC,
						0, 0, &clip, 1, Unsorted);
	XSetClipRectangles(XtDisplay((Widget) w), w->partres.highlightGC,
						0, 0, &clip, 1, Unsorted);
#ifdef DEBUG
	printf("\nResizeStuff: v_h=%d v_w=%d cl_h %d\n", w->partres.viewHeight, w->partres.viewWidth, clip.height);
#endif
	return ;
}


/*	Function Name: Redisplay
 *	Description:   This function redraws the list contents.
 *	Arguments:     w - PartRes widget.
 *                     event - event that caused the exposure.
 *                     region - the region containing all the exposures.
 *	Returns:       none
 *
 */

/*ARGSUSED*/
static void
Redisplay(Widget w, XEvent * event, Region region)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;

#ifdef DEBUG
	printf("\n  Partres Redisplay started \n");
#endif

	ResizeStuff(pres);

	if (InternRedisplay(w) != 0)
		XmeDrawShadows (XtDisplay (w), XtWindow (w),
                pres->primitive.top_shadow_GC,
                pres->primitive.bottom_shadow_GC,
                0,
                0,
				pres->core.width,
				pres->core.height,
				pres->primitive.shadow_thickness,
				XmSHADOW_IN);
#ifdef DEBUG
	printf("\n  Partres Redisplay ok \n");
#endif
	return ;
}

static void 
DrawPixAfterString(XmNlPartResWidget pres, XmNlPR_Cell * cell, int x, int left_edge, int right_edge)
{

	Display *dpy;
	int delta;
	int x2, width;
	
	dpy=XtDisplay((Widget) pres);


	if (cell->alignment == XmALIGNMENT_BEGINNING || 
		cell->alignment == XmALIGNMENT_CENTER)
	{
		x=x+cell->label_w + H_MARGIN;
		if (left_edge > x) delta = left_edge - x;
		else delta = 0;

#ifdef DEBUG
		printf("\n DrawPixInCorner: x=%d, pixw=%d, le=%d, re=%d\n", x, cell->pix_w, left_edge, right_edge);
#endif
		x2 = x + cell->pix_w;
		if (x2 > right_edge) x2 = right_edge;
		width = x2 -x;

		if (PIX_FOUND(cell->mask)) 
		{
			XSetClipOrigin(dpy, pres->partres.drawGC, x,
							(pres->core.height-cell->pix_h)/2);
			XSetClipMask(dpy, pres->partres.drawGC, cell->mask);
		}
		else
			XSetClipMask(dpy, pres->partres.drawGC, None);

		if (x < left_edge) x = left_edge;
		

		XCopyArea(dpy, cell->pixmap, XtWindow((Widget) pres), pres->partres.drawGC,
				delta, 0, width, cell->pix_h, 
				x, (pres->core.height-cell->pix_h)/2);
#ifdef DEBUG
		printf("\n DrawPixInCorner: x=%d, x2=%d, delta=%d, width=%d\n", x, x2, delta, width);
#endif		
		
	}	
	if (cell->alignment == XmALIGNMENT_END)
	{
		x=x + cell->current_width - pres->primitive.shadow_thickness - 2*H_MARGIN - cell->label_w;
		if (left_edge > x) delta = left_edge - x;
		else delta = 0;

#ifdef DEBUG
		printf("\n DrawPixInCorner: x=%d, pixw=%d, le=%d, re=%d\n", x, cell->pix_w, left_edge, right_edge);
#endif
		x2 = x + cell->pix_w;
		if (x2 > right_edge) x2 = right_edge;
		

		if (PIX_FOUND(cell->mask)) 
		{
			XSetClipOrigin(dpy, pres->partres.drawGC, x,
							(pres->core.height-cell->pix_h)/2);
			XSetClipMask(dpy, pres->partres.drawGC, cell->mask);
		}
		else
			XSetClipMask(dpy, pres->partres.drawGC, None);
		
		if (x < left_edge) x = left_edge;
		
		width = x2 -x;

		XCopyArea(dpy, cell->pixmap, XtWindow((Widget) pres), pres->partres.drawGC,
				delta, 0, width, cell->pix_h, 
				x, (pres->core.height-cell->pix_h)/2);
#ifdef DEBUG
		printf("\n DrawPixInCorner: x=%d, x2=%d, delta=%d, width=%d\n", x, x2, delta, width);
#endif		
				
	}

	
/*	if (cell->alignment == XmALIGNMENT_BEGINNING || 
		cell->alignment == XmALIGNMENT_CENTER)
	{
		x=0;
		delta=left_edge+cell->label_w+H_MARGIN;
		if (delta < pres->partres.viewX)
		{
			x=pres->partres.viewX-delta;
			delta=pres->partres.viewX;
		}
		x2=min_value(right_edge, pres->partres.viewX+pres->partres.viewWidth,
					left_edge+cell->label_w+pres->primitive.shadow_thickness+cell->pix_w);
		width=x2-delta;

		if (cell->mask != (Pixmap) NULL) 
		{
			XSetClipOrigin(dpy, pres->partres.drawGC, 
			left_edge + cell->label_w+H_MARGIN,
			(pres->core.height-cell->pix_h)/2);
			XSetClipMask(dpy, pres->partres.drawGC, cell->mask);
		}
		XCopyArea(dpy, cell->pixmap, XtWindow((Widget) pres), pres->partres.drawGC,
				x, 0, width, cell->pix_h, 
				delta, (pres->core.height-cell->pix_h)/2);
#ifdef DEBUG
		printf("\n DrawPixAfterString at begin");
#endif		
		
	}	
	if (cell->alignment == XmALIGNMENT_END)
	{
		x=0;
		delta=right_edge-cell->label_w-H_MARGIN-cell->pix_w;
		if (delta < pres->partres.viewX || delta < left_edge)
		{
//			x=pres->partres.viewX-delta;
			if (pres->partres.viewX >= left_edge) 
			{			
				x=pres->partres.viewX-delta;
				delta=pres->partres.viewX;
			}
			else 
			{
				x=left_edge-delta;
				delta=left_edge;
			}
		}

		x2=min_value(right_edge-cell->label_w-H_MARGIN, 
					pres->partres.viewX+pres->partres.viewWidth,
					delta+cell->pix_w);
		width=x2-delta;

		if (cell->mask != (Pixmap) NULL) 
		{
			XSetClipOrigin(dpy, pres->partres.drawGC, 
			right_edge-cell->label_w-H_MARGIN-cell->pix_w,
			(pres->core.height-cell->pix_h)/2);
			XSetClipMask(dpy, pres->partres.drawGC, cell->mask);
		}
		XCopyArea(dpy, cell->pixmap, XtWindow((Widget) pres), pres->partres.drawGC,
				x, 0, width, cell->pix_h, 
				delta, (pres->core.height-cell->pix_h)/2);
		XSetClipMask(dpy, pres->partres.drawGC, (Pixmap) NULL);
		
#ifdef DEBUG
		printf("\n DrawPixAfterString at and");
#endif		

	}*/
}


static void GetPixBuf(XmNlPartResWidget pres, XmNlPR_Cell * cell)
{


	if (PIX_FOUND(cell->pixbuf))
	{
		if (cell->pixbuf_h < cell->label_h || cell->pixbuf_w < cell->label_w)
		{
			XFreePixmap(XtDisplay(XtWindow(pres)), cell->pixbuf);
			cell->pixbuf = XmUNSPECIFIED_PIXMAP;
		}
	}
	if (!PIX_FOUND(cell->pixbuf))
	{
		cell->pixbuf = XCreatePixmap(XtDisplay((Widget) pres), RootWindowOfScreen(XtScreen((Widget) pres)),
						cell->label_w, cell->label_h, pres->core.depth);
		cell->pixbuf_h = cell->label_h;
		cell->pixbuf_w = cell->label_w;	

		XSetForeground(XtDisplay((Widget) pres), pres->partres.drawGC, pres->partres.background_pixel);

//		XSetClipRectangles(dpy, pres->partres.drawGC,
//					0, 0, NULL, 0, Unsorted);
		XSetClipMask(XtDisplay((Widget) pres), pres->partres.drawGC, None);
		XFillRectangle(XtDisplay((Widget) pres), cell->pixbuf, pres->partres.drawGC, 0, 0, cell->pixbuf_w, cell->pixbuf_h);
		XSetForeground(XtDisplay((Widget) pres), pres->partres.drawGC, pres->partres.foreground_pixel);
		XmStringDraw(XtDisplay((Widget) pres), cell->pixbuf, pres->partres.font_list, cell->xmlabel, pres->partres.drawGC,
							0, 0, cell->label_w, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
	}
	
	return ;
}

static void 
DrawString(XmNlPartResWidget pres, XmNlPR_Cell * cell, int x, int left_edge, int right_edge)
{

	Display *dpy;
	int string_x, string_clip_w;
	int delta;
    XRectangle clip;
	int x2, width;
	
	dpy = XtDisplay((Widget) pres);
				
	string_x = x;
				
	clip.x = left_edge;
	clip.width = right_edge - left_edge;
	clip.y = pres->partres.viewY + pres->primitive.shadow_thickness;
	clip.height = pres->partres.viewHeight - 2*pres->primitive.shadow_thickness;
			
//	XSetClipRectangles(dpy, pres->partres.drawGC,
//				0, 0, &clip, 1, Unsorted);

/*******************************************************************************/
/** If used XFT rendering need use clip in XmStringDraw(), otherwise not need **/
/*******************************************************************************/

	if (!CHECK_CLIP_CORRECT)
		XSetClipRectangles(dpy, pres->partres.drawGC,
					0, 0, &clip, 1, Unsorted);

	if (!pres->partres.buffering)
	{
//		printf("Draw xmlabel %p\n", cell->xmlabel);
		fflush(stdout);
		XmStringDraw(dpy, XtWindow ((Widget) pres), pres->partres.font_list, 
					cell->xmlabel, pres->partres.drawGC, 
					string_x, 
					(pres->core.height-cell->label_h)/2,  
					cell->label_w, 
					cell->alignment, 
					XmSTRING_DIRECTION_DEFAULT, &clip);
//		printf("Drawed xmlabel %p ok\n", cell->xmlabel);
	}
	else
	{
//		printf("GetPixBuf %ld\n", cell->pixbuf);
		GetPixBuf(pres, cell);
		if (PIX_FOUND(cell->pixbuf))
			XCopyArea(dpy, cell->pixbuf, XtWindow((Widget) pres), pres->partres.drawGC,
					0, 0, cell->pixbuf_w, cell->pixbuf_h, 
					x, (pres->core.height-cell->label_h)/2);
//		printf("Copy ok\n");

	}

//	XSetClipRectangles(dpy, pres->partres.drawGC,
//				0, 0, &clip, 1, Unsorted);

#ifdef DEBUG
		printf("\n DrawStringInCorner at begin");
#endif		

	
}


static void 
DrawPix(XmNlPartResWidget pres, XmNlPR_Cell * cell, int x, int left_edge, int right_edge)
{
	Display *dpy = XtDisplay((Widget) pres);
	int delta;
	int x2, width;

	if (left_edge > x) delta = left_edge - x;
	else delta = 0;

#ifdef DEBUG
	printf("\n DrawPixInCorner: x=%d, pixw=%d, le=%d, re=%d\n", x, cell->pix_w, left_edge, right_edge);
#endif
	x2 = x + cell->pix_w;
	if (x2 > right_edge) x2 = right_edge;
		

	if (PIX_FOUND(cell->mask)) 
	{
		XSetClipOrigin(dpy, pres->partres.drawGC, x,
						(pres->core.height-cell->pix_h)/2);
		XSetClipMask(dpy, pres->partres.drawGC, cell->mask);
	}
	else
		XSetClipMask(dpy, pres->partres.drawGC, None);

	if (x < left_edge) x = left_edge;
		
	width = x2 -x;

	XCopyArea(dpy, cell->pixmap, XtWindow((Widget) pres), pres->partres.drawGC,
				delta, 0, width, cell->pix_h, 
				x, (pres->core.height-cell->pix_h)/2);
#ifdef DEBUG
	printf("\n DrawPixInCorner: x=%d, x2=%d, delta=%d, width=%d\n", x, x2, delta, width);
#endif		
		

}


static void 
DrawPixInCorner(XmNlPartResWidget pres, XmNlPR_Cell * cell, int x, int left_edge, int right_edge)
{

	Display *dpy;
	int delta;
//    XRectangle clip;
	int x2, width;
	dpy=XtDisplay((Widget) pres);
	if (cell->alignment == XmALIGNMENT_BEGINNING || 
		cell->alignment == XmALIGNMENT_CENTER)
	{
//		x=0;
		if (left_edge > x) delta = left_edge - x;
		else delta = 0;
/*		if (left_edge < pres->partres.viewX)
		{
			x=pres->partres.viewX-left_edge;
			delta=pres->partres.viewX;
		}
		x2=min_value(right_edge, pres->partres.viewX+pres->partres.viewWidth,
					left_edge+cell->pix_w);*/
					
/*		if (left_edge < pres->partres.viewX + pres->primitive.shadow_thickness)
		{
			x=pres->partres.viewX+pres->primitive.shadow_thickness-left_edge;
			delta=pres->partres.viewX+pres->primitive.shadow_thickness;
		}
		x2=min_value(right_edge, pres->partres.viewX+pres->partres.viewWidth,
					left_edge+cell->pix_w);
					
		width=x2-delta;
*/

#ifdef DEBUG
		printf("\n DrawPixInCorner: x=%d, pixw=%d, le=%d, re=%d\n", x, cell->pix_w, left_edge, right_edge);
#endif
		x2 = x + cell->pix_w;
		if (x2 > right_edge) x2 = right_edge;
		

		if (PIX_FOUND(cell->mask)) 
		{
			XSetClipOrigin(dpy, pres->partres.drawGC, x,
							(pres->core.height-cell->pix_h)/2);
			XSetClipMask(dpy, pres->partres.drawGC, cell->mask);
		}
		else
			XSetClipMask(dpy, pres->partres.drawGC, None);

		if (x < left_edge) x = left_edge;
		
		width = x2 -x;

		XCopyArea(dpy, cell->pixmap, XtWindow((Widget) pres), pres->partres.drawGC,
				delta, 0, width, cell->pix_h, 
				x, (pres->core.height-cell->pix_h)/2);
#ifdef DEBUG
		printf("\n DrawPixInCorner: x=%d, x2=%d, delta=%d, width=%d\n", x, x2, delta, width);
#endif		
		
	}	
	if (cell->alignment == XmALIGNMENT_END)
	{
/*		x=0;
		delta=right_edge-cell->pix_w;
		if (delta < pres->partres.viewX)
		{
			x=pres->partres.viewX-delta;
			delta=pres->partres.viewX;
		}
		x2=min_value(right_edge, pres->partres.viewX+pres->partres.viewWidth,
					delta+cell->pix_w);
		width=x2-delta;

		if (cell->mask != (Pixmap) NULL) 
		{
			XSetClipOrigin(dpy, pres->partres.drawGC, right_edge-cell->pix_w,
			(pres->core.height-cell->pix_h)/2);
			XSetClipMask(dpy, pres->partres.drawGC, cell->mask);
		}
		XCopyArea(dpy, cell->pixmap, XtWindow((Widget) pres), pres->partres.drawGC,
				x, 0, width, cell->pix_h, 
				delta, (pres->core.height-cell->pix_h)/2);*/
		x=x + cell->current_width - pres->primitive.shadow_thickness - H_MARGIN;
		if (left_edge > x) delta = left_edge - x;
		else delta = 0;
/*		if (left_edge < pres->partres.viewX)
		{
			x=pres->partres.viewX-left_edge;
			delta=pres->partres.viewX;
		}
		x2=min_value(right_edge, pres->partres.viewX+pres->partres.viewWidth,
					left_edge+cell->pix_w);*/
					
/*		if (left_edge < pres->partres.viewX + pres->primitive.shadow_thickness)
		{
			x=pres->partres.viewX+pres->primitive.shadow_thickness-left_edge;
			delta=pres->partres.viewX+pres->primitive.shadow_thickness;
		}
		x2=min_value(right_edge, pres->partres.viewX+pres->partres.viewWidth,
					left_edge+cell->pix_w);
					
		width=x2-delta;
*/

#ifdef DEBUG
		printf("\n DrawPixInCorner: x=%d, pixw=%d, le=%d, re=%d\n", x, cell->pix_w, left_edge, right_edge);
#endif
		x2 = x + cell->pix_w;
		if (x2 > right_edge) x2 = right_edge;
		

		if (PIX_FOUND(cell->mask)) 
		{
			XSetClipOrigin(dpy, pres->partres.drawGC, x,
							(pres->core.height-cell->pix_h)/2);
			XSetClipMask(dpy, pres->partres.drawGC, cell->mask);
		}
		else
			XSetClipMask(dpy, pres->partres.drawGC, None);

		if (x < left_edge) x = left_edge;
		
		width = x2 -x;

		XCopyArea(dpy, cell->pixmap, XtWindow((Widget) pres), pres->partres.drawGC,
				delta, 0, width, cell->pix_h, 
				x, (pres->core.height-cell->pix_h)/2);
#ifdef DEBUG
		printf("\n DrawPixInCorner: x=%d, x2=%d, delta=%d, width=%d\n", x, x2, delta, width);
#endif		
				
	}
}


static int InternEmptyRedisplay (Widget w)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;

	XmeDrawShadows (XtDisplay (w), XtWindow (w),
                pres->primitive.top_shadow_GC,
                pres->primitive.bottom_shadow_GC,
				pres->partres.viewX, pres->partres.viewY,
				pres->partres.viewWidth, pres->partres.viewHeight,
				pres->primitive.shadow_thickness, XmSHADOW_OUT);
	return 1;
}

static void 
PartResDrawLeftCell(XmNlPartResWidget pres, XmNlPR_Cell * cell, int x, int left_edge, int right_edge, XRectangle *cclip)
{

	Display *dpy = XtDisplay((Widget) pres);
	int delta, string_x, string_clip_w, pix_clip_w;
    XRectangle clip;
#ifdef DEBUG
	printf("\n  PartResDrawLeftCell started with cell %p\n", cell);
//	printf("\n  PartResDrawLeftCell: current_width = %d ", cell->current_width);
	printf("\n  PartResDrawLeftCell: info_type = %hhx ", cell->info_type);
#endif	

	if (cell->info_type == XmPIXMAP	|| (cell->info_type == XmPIXMAP_AND_STRING && cell->priority == XmPIXMAP))
	{
		if (cell->pixmap != XmUNSPECIFIED_PIXMAP)
		{
#ifdef DEBUG
			printf("\n  DrawPix next step x=%d \n", x);
#endif	
			if (x < right_edge) 
				DrawPix(pres, cell, x, left_edge, right_edge);
		}
		if (cell->info_type == XmPIXMAP_AND_STRING && cell->priority == XmPIXMAP && cell->xmlabel)
		{
//			printf("\n  DrawLabel next step x=%d \n", x);
			if (x + H_MARGIN + cell->pix_w < right_edge)
				DrawString(pres, cell, x + H_MARGIN + cell->pix_w, left_edge, right_edge);
		}
			
	return;
	}
	
	if (cell->info_type == XmSTRING	|| (cell->info_type == XmPIXMAP_AND_STRING && cell->priority == XmSTRING))
	{
//		printf("label %p\n", cell->xmlabel);
//		return;
		if (cell->xmlabel)
		{
			if (x < right_edge)
				DrawString(pres, cell, x, left_edge, right_edge);
		}
		if (cell->info_type == XmPIXMAP_AND_STRING && cell->priority == XmSTRING && cell->pixmap != XmUNSPECIFIED_PIXMAP)
		{
			if (x + H_MARGIN + cell->label_w < right_edge)
				DrawPix(pres, cell, x + H_MARGIN + cell->label_w, left_edge, right_edge);
		}
		
	}
	
}

static void PartResDrawRightCell(XmNlPartResWidget pres, XmNlPR_Cell * cell, int x, int left_edge, int right_edge, XRectangle *cclip)
{
	Display *dpy = XtDisplay((Widget) pres);
    XRectangle clip;
	int delta, string_x, string_clip_w, pix_clip_w;

#ifdef DEBUG
	printf("\n  PartResDrawRightCell started ");
#endif	

	if (cell->info_type == XmPIXMAP	|| (cell->info_type == XmPIXMAP_AND_STRING && cell->priority == XmPIXMAP))
	{
		if (cell->pixmap != XmUNSPECIFIED_PIXMAP) 
		{
			if (x + cell->current_width - 2*pres->primitive.shadow_thickness - 2*H_MARGIN - cell->pix_w > left_edge)
				DrawPix(pres, cell, x + cell->current_width - 2*pres->primitive.shadow_thickness - 2*H_MARGIN - cell->pix_w, 
						left_edge, right_edge);
		}
		if (cell->info_type == XmPIXMAP_AND_STRING && cell->priority == XmPIXMAP && cell->xmlabel)
		{
			if (x + cell->current_width - 2*pres->primitive.shadow_thickness - 3*H_MARGIN - cell->pix_w > left_edge)
				DrawString(pres, cell, 
						x + cell->current_width - 2*pres->primitive.shadow_thickness - 3*H_MARGIN - cell->pix_w - cell->label_w, 
						left_edge, right_edge);
		}
			
	}
	
	if (cell->info_type == XmSTRING	|| (cell->info_type ==  XmPIXMAP_AND_STRING && cell->priority == XmSTRING))
	{
		if ( cell->xmlabel)
		{
			if (x + cell->current_width - 2*pres->primitive.shadow_thickness - 2*H_MARGIN > left_edge)
				DrawString(pres, cell, x + cell->current_width - 2*pres->primitive.shadow_thickness - 2*H_MARGIN - cell->label_w, 
							left_edge, right_edge);
		}
		if (cell->info_type ==  XmPIXMAP_AND_STRING && cell->priority == XmSTRING && cell->pixmap != XmUNSPECIFIED_PIXMAP)
		{
			if (x + cell->current_width - 2*pres->primitive.shadow_thickness - 3*H_MARGIN - cell->label_w > left_edge)
				DrawPix(pres, cell, x + cell->current_width - 2*pres->primitive.shadow_thickness - 3*H_MARGIN - cell->pix_w - cell->label_w, left_edge, right_edge);
		}
		
	}

	
}

static void PartResDrawCell(XmNlPartResWidget pres, int i, int x, int left_edge, int right_edge, XRectangle *clip)
{
	XmNlPR_Cell * cell;

//	printf("\n  PartResDrawCell pre started %p %d\n", pres->partres.item_data, i);
	cell = pres->partres.item_data;
	cell = cell + i;
#ifdef DEBUG
	printf("\n  PartResDrawCell started %p\n", cell);
#endif	
	if ((cell->alignment == XmALIGNMENT_BEGINNING || cell->alignment == XmALIGNMENT_CENTER) && pres->partres.render_order == LtoR_render)
		PartResDrawLeftCell(pres, cell, x, left_edge, right_edge, clip);

	if (cell->alignment == XmALIGNMENT_END && pres->partres.render_order == LtoR_render)
		PartResDrawRightCell(pres, cell, x, left_edge, right_edge, clip);

	if ((cell->alignment == XmALIGNMENT_BEGINNING || cell->alignment == XmALIGNMENT_CENTER) && pres->partres.render_order == RtoL_render)
		PartResDrawRightCell(pres, cell, x, left_edge, right_edge, clip);

	if (cell->alignment == XmALIGNMENT_END && pres->partres.render_order == RtoL_render)
		PartResDrawLeftCell(pres, cell, x, left_edge, right_edge, clip);
#ifdef DEBUG
	printf("\n  PartResDrawCell complete \n");
#endif	
}

static int InternManualRedisplay (Widget w);
static int InternPropportionalRedisplay (Widget w);

static int InternRedisplay (Widget w)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int ret;
	
	if (pres->partres.num_items == 0 || pres->partres.item_data == NULL) 
	{
		ret = InternEmptyRedisplay(w);
		return ret;
	}
#ifdef DEBUG
	printf("\n  PartRes:  InternManualRedisplay\n");
#endif	
//	if (pres->partres.ResizeMode == XmNPR_Manual) 
		ret = InternManualRedisplay(w);
//	else
//		ret = InternPropportionalRedisplay(w);
		
	return ret;
		
}

static int InternPropportionalRedisplay (Widget w)
{
//    XmNlPartResWidget pres = (XmNlPartResWidget) w;
}

static int InternManualRedisplay (Widget w)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
//    short num_rows;
//	GC top_GC, bottom_GC;
//	XGCValues values;
	unsigned long mask;
	XmNlPR_Cell * cell;
    XRectangle clip;
    int x, y, i, left_edge, right_edge;
#ifdef DEBUG
	printf("\n  InternManualRedisplay started column %d\n", pres->partres.num_items);
#endif
	int width, height, dest_x, src_x1, src_x2, str_height;
	int shad_hig, shad_hig2, shadow, shadow2, hig, hig2, shdt;
	int thick_x, thick_wd, clip_width;
	
//	mask=GCFunction | GCPlaneMask | GCForeground | GCBackground | GCLineWidth |
//       GCLineStyle | GCCapStyle | GCJoinStyle | GCFillStyle | GCFillRule | GCTile |
//       GCStipple | GCTileStipXOrigin | GCTileStipYOrigin | GCFont | GCSubwindowMode | 
//	GCClipXOrigin | GCClipYOrigin | GCDashOffset | GCArcMode;

	if (pres->partres.num_items == 0) return 1;
	
	mask=GCFunction | GCPlaneMask | GCForeground | GCBackground | GCLineWidth |
       GCLineStyle | GCCapStyle | GCJoinStyle | GCFillStyle | GCFillRule | 
       GCDashOffset | GCArcMode;
	
//	XCopyGC(XtDisplay (w), pres->primitive.top_shadow_GC, pres->partres.top_GC, mask);
//	XCopyGC(XtDisplay (w), pres->primitive.bottom_shadow_GC, pres->partres.bottom_GC, mask);
/*	XGetGCValues(XtDisplay (w), pres->primitive.top_shadow_GC, mask, &values);
	XChangeGC(XtDisplay (w), pres->partres.top_GC, mask, &values);
	XGetGCValues(XtDisplay (w), pres->primitive.bottom_shadow_GC, mask, &values);
	XChangeGC(XtDisplay (w), pres->partres.bottom_GC, mask, &values);

	clip.x = pres->partres.viewX;
    clip.y = pres->partres.viewY;
	clip.width = pres->partres.viewWidth;
	clip.height = pres->partres.viewHeight;
	

	XSetClipRectangles(XtDisplay(w), pres->partres.top_GC,
				0, 0, &clip, 1, Unsorted);
	
	XSetClipRectangles(XtDisplay(w), pres->partres.bottom_GC,
				0, 0, &clip, 1, Unsorted);*/
	
	shadow = pres->primitive.shadow_thickness;
	/* Size of shadow*/
	shad_hig = pres->primitive.highlight_thickness+shadow;
	/* Size of shadow & highlight*/
	hig = pres->primitive.highlight_thickness;
	/* Size of highlight*/
	shadow2 = 2 * pres->primitive.shadow_thickness;
	/* Double size of shadow*/
	shad_hig2 = 2* (pres->primitive.highlight_thickness+shadow);
	/* Double size of shadow & highlight*/
	hig2 = 2*pres->primitive.highlight_thickness;
	/* Double size of highlight*/
	shdt = 2 * pres->primitive.shadow_thickness+pres->primitive.highlight_thickness;
	/* Size of 2 shadow & 1 highlight*/

	
	cell = pres->partres.item_data;
	
	XClearArea(XtDisplay (w), XtWindow (w),
						pres->partres.viewX, pres->partres.viewY,  
						pres->partres.viewWidth, pres->partres.viewHeight, False);
//	x=pres->partres.global_h_shift+pres->partres.viewX;
//	x=pres->partres.global_h_shift+pres->partres.viewX;
#ifdef DEBUG
	printf("\n  InternManualRedisplay area cleared");
#endif
	if (cell == NULL) return 1;

	x = pres->partres.viewX - pres->partres.global_h_shift;
	y = pres->partres.viewY;
	for (i = 0; i< pres->partres.num_items; i++)
	{
		if (x >= pres->partres.viewWidth) break;
		if (x + cell[i].current_width > pres->partres.viewX)
		{
			if (pres->partres.render_order == LtoR_render) 
				thick_x = x;
			else
				thick_x = pres->core.width - x - cell[i].current_width;
			thick_wd = cell[i].current_width;
			if (thick_x < pres->partres.viewX) 
			{
				thick_wd = thick_wd - (pres->partres.viewX - thick_x);
				thick_x = pres->partres.viewX;
			}
				if (thick_x + thick_wd > pres->core.width - shadow) 
					thick_wd = pres->core.width - thick_x - shadow;
			XmeDrawShadows(XtDisplay (w), XtWindow (w),
						pres->primitive.top_shadow_GC,
						pres->primitive.bottom_shadow_GC,
						thick_x, y,
						thick_wd,
						pres->partres.viewHeight,
						pres->primitive.shadow_thickness, XmSHADOW_OUT);
						
				
#ifdef DEBUG
			printf("\n  InternManualRedisplay: drawed %d %p\n", i, &(cell[i]));
#endif
			if (pres->partres.render_order == LtoR_render)
			{
				left_edge = x + shadow + H_MARGIN;
				right_edge = x + cell[i].current_width - shadow - H_MARGIN;
			}
			else
			{
				left_edge = pres->core.width - x - cell[i].current_width + shadow + H_MARGIN;
				right_edge = pres->core.width - x - shadow - H_MARGIN;
			}
			if (left_edge < pres->partres.viewX + pres->partres.viewWidth - shadow -H_MARGIN
				&& right_edge > pres->partres.viewX + shadow + H_MARGIN)
			{
				if (left_edge < pres->partres.viewX + shadow + H_MARGIN)
					left_edge = pres->partres.viewX + shadow + H_MARGIN;
				if (right_edge > pres->partres.viewX + pres->partres.viewWidth - shadow - H_MARGIN)
					right_edge = pres->partres.viewX + pres->partres.viewWidth - shadow - H_MARGIN;
				clip.x = left_edge;
				clip.width = right_edge - left_edge;
				clip.y = y+shadow;

#ifdef DEBUG
		printf("\n InternManualRedisplay: i = %d, x=%d, le=%d, re=%d\n", i, x, left_edge, right_edge);
#endif
				clip.height = pres->partres.viewHeight - shadow2;
#ifdef DEBUG
				printf("\n InternManualRedisplay: x+=%d\n", x+shadow+H_MARGIN);
#endif
				if (pres->partres.render_order == LtoR_render) 
						PartResDrawCell(pres, i, x + shadow + H_MARGIN, left_edge, right_edge, &clip);
				else
						PartResDrawCell(pres, i, pres->core.width - x - cell[i].current_width + shadow + H_MARGIN, left_edge, right_edge, &clip);
#ifdef DEBUG
				printf("\ni for label=%d\n",  i);
				printf("\tX for label=%d\n",  x+shadow+H_MARGIN);
				printf("\tX for left_edge=%d\n",  left_edge);
				printf("\tX for clip=%d\n",  clip.x);
				printf("\tY for clip=%d\n",  clip.y);
				printf("\twidth for clip=%d\n",  clip.width);
				printf("\theight for clip=%d\n",  clip.height);
		
#endif
			}
		}
		x = x + cell[i].current_width;
	}
	
	clip.x = pres->partres.viewX;
	clip.y = pres->partres.viewY;
	clip.width = pres->partres.viewWidth;
	clip.height = pres->partres.viewHeight;
	XSetClipRectangles(XtDisplay((Widget) w), pres->partres.drawGC,
						0, 0, &clip, 1, Unsorted);
	XmeDrawShadows (XtDisplay (w), XtWindow (w),
					pres->primitive.top_shadow_GC,
					pres->primitive.bottom_shadow_GC,
					0,
					0,
					pres->core.width,
					pres->core.height,
					pres->primitive.shadow_thickness,
					XmSHADOW_IN);

#ifdef DEBUG
		printf("\n InternManualRedisplay: ok");
#endif

	return 0;

}


/*	Function Name: Resize
 *	Description:   Called when this widget has been resized.
 *	Arguments:     w - PartRes Widget to realize.
 *	Returns:       none.
 */

static void
Resize(Widget w)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	XmNlPR_Cell  * cell;
	Window ww, root;
	int x, y;
	unsigned int width, height, bw, depth;

//	printf("PartRes resize\n");

#ifdef DEBUG
      printf("\n PartRes resize w %d h %d\n", pres->core.width, pres->core.height);
	fflush(stdout);
#endif

    if (!XtIsRealized(w))
    {
		printf("PartRes Resize and not realized h = %d\n", w->core.height);
		return;
	}
	
	ResizeStuff(pres);
#ifdef DEBUG
	printf("--------PartRes Resize core h %d pref h %d\n", w->core.height, pres->partres.prefferedHeight);
#endif

	AdjustGlobalShift(w);

	cell = pres->partres.item_data;
	ww = XtWindow(w);

	XGetGeometry(XtDisplay(w), ww,
				 &root, &x, &y, &width, &height, &bw, &depth);
//printf("PartRes window w %d h %d\n", width, height);	


//printf("PartRes Height current %d returned %d\n", w->core.height, height);	
	if (pres->partres.ResizeMode == XmNPR_Manual)
	{
		if (pres->partres.resizeCallback && cell)
		{
			ResizeDoCallback(w, XmNlItemsFound, XmNlSizeChange);
		}
		else
		{
			ResizeManual(w, False);
		}
	}
	else
	{
		ResizePartAuto(w);
	}
//printf("PR resize 1\n");
	if (pres->partres.lastViewHeight > pres->partres.viewHeight ||
		pres->partres.lastViewWidth > pres->partres.viewWidth) 
					InternRedisplay(w);
//printf("PR resize 2\n");
}

/*	Function Name: Destroy
 *	Description:   Cleans up after the widget.
 *	Arguments:     w - the widget.
 *	Returns:       none.
 */

static void
Destroy(Widget w)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;

#ifdef DEBUG
	printf("Destroy partres\n");
#endif

	FreeCellElements(w);
    DestroyGC(pres);

	if (pres->partres.font_list)
		XmRenderTableFree(pres->partres.font_list);

    if (pres->partres.RealW) 
		free((void *) pres->partres.RealW);
	
	if (pres->partres.ElSharpSize)
		XtFree((char *)pres->partres.ElSharpSize);

	if (pres->partres.ElCurSize)
		XtFree((char *)pres->partres.ElCurSize);

	if (pres->partres.ElNewSize)
		XtFree((char *)pres->partres.ElNewSize);
	/*  tmp hack */
	
	//FreeCells(pres);
	
	

//    FreeColumnTitles(ilist);
//    XtFree((XtPointer) XmI18List_column_widths(ilist));
}

static void
ResizePartAuto(Widget w)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i, x;
	XmNlPR_Cell * cell;
	float factor;
	float part;
	
#ifdef DEBUG
	printf("\nResizePartAuto items %d max size %d\n", pres->partres.num_items, pres->partres.MaxSize);
#endif
	if (pres->partres.num_items == 0)
		return ;
	cell = pres->partres.item_data;

	if (pres->partres.num_items == 1)
	{
		cell->x = 0;
		cell->current_width = pres->partres.viewWidth;
		pres->partres.full_width = pres->partres.viewWidth;
#ifdef DEBUG
	printf("\nResizeManual: only 1 column\n");
#endif
		return ;
	}

	x = 0;
	pres->partres.full_width = 0;
	
	for (i = 0; i < pres->partres.num_items; i++)
	{
		(cell+i)->x = x;
		factor = ((float) cell[i].value) / pres->partres.MaxSize;
//		printf("\nResizeManual cell %d MaxSize %d factor: %f\n", cell[i].value, pres->partres.MaxSize, factor);
		part = factor * pres->partres.viewWidth;
		(cell+i)->current_width = (int) part;
		x = x + (cell+i)->current_width;	
		pres->partres.full_width = pres->partres.full_width + (cell+i)->current_width;
	}

	if (pres->partres.full_width != pres->partres.viewWidth)
	{
		int wd;
		wd = pres->partres.viewWidth - 
			(cell[pres->partres.num_items - 2].x + cell[pres->partres.num_items - 2].current_width);
		if (wd < 0)
			cell[pres->partres.num_items - 1].current_width = 0;
		else
			cell[pres->partres.num_items - 1].current_width = wd;
	}

#ifdef DEBUG
	for (i = 0; i < pres->partres.num_items; i++)
	{
		printf("\nResizePartAuto col %d x = %d current = %d\n", i, (cell+i)->x, (cell+i)->current_width);
	}
#endif
}

static void
ResizeManual(Widget w, Boolean recalc)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i, x, delta, cnt, fwd, limit, min;
	XmNlPR_Cell * cell;
	 
#ifdef DEBUG
	printf("\nResizeManual %d\n", pres->partres.num_items);
#endif
	if (pres->partres.num_items == 0)
		return ;
	cell = pres->partres.item_data;
	
	if (pres->partres.num_items == 1)
	{
		cell->x = 0;
		cell->current_width = pres->partres.viewWidth;
		pres->partres.full_width = pres->partres.viewWidth;
#ifdef DEBUG
	printf("\nResizeManual: only 1 column\n");
#endif
		return ;
	}

	x = 0;
	pres->partres.full_width = 0;
	
	for (i = 0; i < pres->partres.num_items; i++)
	{
		(cell+i)->x = x;
		if (recalc)
			(cell+i)->current_width = (cell+i)->real_width;
		x = x + (cell+i)->current_width;	
		pres->partres.full_width = pres->partres.full_width + (cell+i)->current_width;
	}

#ifdef DEBUG
	printf("\nResizeManual view %d full %d\n", pres->partres.viewWidth, pres->partres.full_width);
#endif

	if (pres->partres.full_width < pres->partres.viewWidth)
	{
		delta = (pres->partres.viewWidth - pres->partres.full_width) / pres->partres.num_items;
#ifdef DEBUG
	printf("\nResizeManual delta %d\n", delta);
#endif
		if (delta != 0)
		{
			x = 0;
			pres->partres.full_width = 0;
			for (i = 0; i < pres->partres.num_items; i++)
			{
				(cell+i)->x = x;
				(cell+i)->current_width = (cell+i)->current_width + delta;	
				x = x + (cell+i)->current_width;	
				pres->partres.full_width = pres->partres.full_width + (cell+i)->current_width;
			}
		}
		if (pres->partres.full_width < pres->partres.viewWidth)
		{
			delta = pres->partres.viewWidth - pres->partres.full_width;
			(cell+pres->partres.num_items - 1)->current_width = (cell+pres->partres.num_items - 1)->current_width + delta;	
			pres->partres.full_width = pres->partres.full_width + delta;
		}
	}
	else
	{
		if (pres->partres.full_width > pres->partres.viewWidth)
		{
			delta = pres->partres.full_width - pres->partres.viewWidth;
			limit = delta/pres->partres.num_items;
			if (limit == 0)
			{
				for (i = 0; i < pres->partres.num_items; i++)
				{
					if ((cell+i)->current_width > (cell+i)->real_width)
					{
						(cell+i)->current_width = (cell+i)->current_width - delta;
						break;
					}
				}
				goto rs1;
			}
			cnt = pres->partres.num_items;
			fwd = 0;
			min = limit;
			for (i = 0; i < pres->partres.num_items; i++)
			{
				limit = delta/cnt;
				min = (cell+i)->current_width - (cell+i)->real_width;
				if (min <= 0)
				{
					cnt--;
//					fwd = fwd + (cell+i)->current_width;
					continue ;
				}
				if (limit <= min)
				{
					(cell+i)->current_width = (cell+i)->current_width - limit;
					delta-=limit;
					if (delta <= 0)
						break;
				}
				else
				{
					(cell+i)->current_width = (cell+i)->current_width - min;
					delta-=min;
//					fwd = fwd + (cell+i)->current_width;
					if (delta <= 0)
						break;
				}
				cnt--;
			}
rs1:
			x = 0;
			for (i = 0; i < pres->partres.num_items; i++)
			{
				(cell+i)->x = x;
				x = x + (cell+i)->current_width;	
				pres->partres.full_width = pres->partres.full_width + (cell+i)->current_width;
			}
		}
	}
	
	AdjustGlobalHorShift(w);
	
#ifdef DEBUG
	for (i = 0; i < pres->partres.num_items; i++)
	{
		printf("\nResizeManual x = %d real = %d current = %d\n", (cell+i)->x, (cell+i)->real_width, (cell+i)->current_width);
	}
//#endif
	
//#ifdef DEBUG
	printf("\nResizeManual view %d full %d\n", pres->partres.viewWidth, pres->partres.full_width);
#endif
	
	
}



void FreeCellElements(Widget w)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	XmNlPR_Cell  * cell;
	int i;

#ifdef DEBUG
	printf("\n FreeCellElements started");
	fflush(stdout);
#endif	

	if (pres->partres.num_items != 0 && pres->partres.item_data != NULL)
	{
		cell = pres->partres.item_data;
		for (i=0; i<pres->partres.num_items; i++)
		{
			if (cell[i].xmlabel) 
				XmStringFree(cell[i].xmlabel);
			if (PIX_FOUND(cell[i].pixbuf))
			{
//				printf("Pixmap free %lx\n", cell[i].pixbuf);

				XFreePixmap(XtDisplay(w), cell[i].pixbuf);
			}
		}
	}
	pres->partres.num_items = 0;
	XtFree((char *) pres->partres.item_data);
	pres->partres.item_data = NULL;
#ifdef DEBUG
	printf("\n FreeCellElements complet");
	fflush(stdout);
#endif	
}

void ReallocCellElements(Widget w, int count)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	XmNlPR_Cell  * cell;
	int i;
#ifdef DEBUG
	printf("\n ReallocCellElements started");
#endif
	
	
	if (count <= 0)
		return;
		
	if (pres->partres.item_data != NULL) 
		FreeCellElements(w);
	pres->partres.num_items = count;
	
	CreateDefaultCells(w);

//	pres->partres.item_data = (XmNlPR_Cell *) XtMalloc(sizeof (XmNlPR_Cell) * pres->partres.count_cell); 
	
	if (pres->partres.ElSharpSize)
		XtFree((char *)pres->partres.ElSharpSize);
	pres->partres.ElSharpSize = (int *)XtMalloc(pres->partres.num_items * sizeof(int));

	if (pres->partres.ElCurSize)
		XtFree((char *)pres->partres.ElCurSize);
	pres->partres.ElCurSize = (int *)XtMalloc(pres->partres.num_items * sizeof(int));

	if (pres->partres.ElNewSize)
		XtFree((char *)pres->partres.ElNewSize);
	pres->partres.ElNewSize = (int *)XtMalloc(pres->partres.num_items * sizeof(int));
	
//	pres->partres.item_data=(XmNlPR_Cell *) XtRealloc((char *) pres->partres.item_data, 
//		pres->partres.count_cell * sizeof (XmNlPR_Cell));
#ifdef DEBUG
	printf("\n ReallocCellElements complet");
#endif
	
}

static Boolean RequestNewSize(Widget w)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
    Dimension w_ret, h_ret;
    XtGeometryResult ret_val;
    
//printf("^^^^^^^^Request new size %d \n", pres->partres.prefferedHeight);
    ret_val = XtMakeResizeRequest(w, w->core.width, pres->partres.prefferedHeight, &w_ret, &h_ret);
    
//	printf("RetVal = %d\n", ret_val);
//	if (ret_val == XtGeometryYes)
//		printf("++Yes\n");
//	if (ret_val == XtGeometryNo)
//		printf("++No\n");

	if (ret_val == XtGeometryAlmost)
    {
//		printf("RetVal height = %d\n", h_ret);
		(void) XtMakeResizeRequest(w, w_ret, h_ret, NULL, NULL);
	}
	Resize(w);

	if (ret_val == XtGeometryYes || ret_val == XtGeometryAlmost)
		return True;
	else
		return False;
}


static void PRSetCell(Widget w, XmNlCell *cell_data, unsigned char valuemask, int position)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	XmNlPR_Cell  * cell;
	unsigned int width, height, bw, depth;
	int x, y;
	Window root;

//printf("PartRes item data %p\n", pres->partres.item_data);

	cell = pres->partres.item_data + position;
//printf("PartRes item data2 %p\n", cell);

	cell->info_type = cell_data->element_type;

//printf("\n  PartRes: pixbuf = %ld \n", cell->pixbuf);


	if (valuemask & CellPixmap)
	{
//		printf("PIX \n");
		if (PIX_FOUND(cell_data->pixmap))
		{
//		printf("PIX found\n");
			cell->pixmap = cell_data->pixmap;

			XGetGeometry(XtDisplay(w), cell->pixmap,
				 &root, &x, &y, &width, &height, &bw, &depth);

			cell->pix_h = height;
			cell->pix_w = width;

			if (PIX_FOUND(cell_data->mask)) 
				cell->mask = cell_data->mask;
			else
				cell->mask = XmUNSPECIFIED_PIXMAP;
		}
		else 
			cell->pixmap = XmUNSPECIFIED_PIXMAP;
	}

	if (valuemask & CellCharString) 
		cell->text = cell_data->text;

	if (valuemask & CellXmString)
	{
		if (cell_data->xmlabel)
		{
			if (cell->xmlabel)
				XmStringFree(cell->xmlabel);
			cell->xmlabel = XmStringCopy(cell_data->xmlabel);

			width = XmStringWidth(pres->partres.font_list, cell->xmlabel);
			height = XmStringHeight(pres->partres.font_list, cell->xmlabel);
			cell->label_w = width;
			cell->label_h = height;
		}
		else
		{
			if (cell->xmlabel)
				XmStringFree(cell->xmlabel);
			cell->xmlabel = NULL;
			cell->label_w = 0;
			cell->label_h = 0;
		}
	}

	if (valuemask & CellPriority) 
		cell->priority = cell_data->priority;

	if (valuemask & CellAlignment) 
		cell->alignment = cell_data->alignment;
//	else 
//		cell->alignment = XmALIGNMENT_UNSPECIFIED;

	if (valuemask & CellUserData) 
		cell->UserDataPointer = cell_data->UserDataPointer;


	if (cell->info_type == XmSTRING)
		cell->real_width = 2 * pres->primitive.shadow_thickness + 2 * H_MARGIN + cell->label_w;
	
	if (cell->info_type == XmPIXMAP)
		cell->real_width = 2 * pres->primitive.shadow_thickness + 2 * H_MARGIN + cell->pix_w;

	if (cell->info_type == XmPIXMAP_AND_STRING)
		cell->real_width = 2 * pres->primitive.shadow_thickness + 3 * H_MARGIN + cell->pix_w + cell->label_w;

	return ;
}

Boolean XmNlPartResSetRow(Widget w, XmNlCell *cell_data, unsigned char valuemask)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	Boolean ResNeed;
	int i;

#ifdef DEBUG
	printf("\n +++++++++++XmNlPartResSetRow: start\n");
	fflush(stdout);
#endif

	for (i = 0; i < pres->partres.num_items; i++)
	{
		PRSetCell(w, cell_data + i, valuemask, i);
	}


#ifdef DEBUG
	printf("\n ++++++++XmNlPartResSetRow: data ok\n");
	fflush(stdout);
#endif

	if (pres->partres.ResizeMode == XmNPR_Manual)
	{
		if (pres->partres.resizeCallback)
			ResizeDoCallback(w, XmNlItemsFound, XmNlContentChange);
		else
			ResizeManual(w, True);
	}
	else
		ResizePartAuto(w);
		
	ResNeed = CalcGeom(w, False);

	
#ifdef DEBUG
	for (i = 0; i < pres->partres.num_items; i++)
	{
		printf("PR col %d r_w %d c_w %d type %hhx\n", i, pres->partres.item_data[i].real_width, pres->partres.item_data[i].current_width, pres->partres.item_data[i].info_type);
	}
#endif

	if (ResNeed)
	{
//		printf("++++++++++ResNeed\n");
		if (RequestNewSize(w))
			return True;
	}

	if (XtIsRealized(w))
	{
		InternRedisplay(w);
	}
	
#ifdef DEBUG
	printf("\n XmNlPartResSetRow complete\n");
	fflush(stdout);
#endif

	return True;
}


Boolean XmNlPartResSetCell(Widget w, XmNlCell *cell_data, unsigned char valuemask, int position)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	Boolean ResNeed;

	if (position > (pres->partres.num_items - 1) || position < 0)
		return False;
		
	PRSetCell(w, cell_data, valuemask, position);


#ifdef DEBUG
	printf("\n XmNlPartResSetCell: data ok\n");
	fflush(stdout);
#endif

	if (pres->partres.ResizeMode == XmNPR_Manual)
	{
		if (pres->partres.resizeCallback)
			ResizeDoCallback(w, XmNlItemsFound, XmNlContentChange);
		else
			ResizeManual(w, True);
	}
	else
		ResizePartAuto(w);
		
	ResNeed = CalcGeom(w, False);

	if (ResNeed)
	{
		if (RequestNewSize(w))
			return True;
	}

	if (XtIsRealized(w))
	{
		InternRedisplay(w);
	}
	
#ifdef DEBUG
	printf("\n XmNlPartResSetCell complete\n");
	fflush(stdout);
#endif

	return True;
}


void PRSetElements(Widget w, int count, PartResElement * data)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	XmNlPR_Cell  * cell;
	Display * dpy;
	Window root;
	int i, x, y, delta_x;
	unsigned int width, height, bw, depth;
//	Dimension height;
#ifdef DEBUG
	printf("\n PRSetElements started");
#endif
	dpy=XtDisplay(w);
	
	
	ReallocCellElements(w, count);
	
	if (pres->partres.RealW) free((void *) pres->partres.RealW);
	pres->partres.RealW = malloc(sizeof(int) * count);
		
	cell = pres->partres.item_data;

//	delta_x = pres->partres.global_h_shift;
	delta_x = 0;

	for (i=0; i<pres->partres.num_items; i++)
	{
		cell[i].alignment = data[i].alignment;
		cell[i].autoresize = data[i].resizible;
		if (pres->partres.ResizeMode == XmNPR_Manual) 
		{
			cell[i].current_width = data[i].size;
			cell[i].x = delta_x;
			delta_x = delta_x+data[i].size;
		}
/* tmp hack */
		else cell[i].current_width = pres->partres.viewWidth/100 * data[i].size;
		if (data[i].pixmap != (Pixmap) NULL) 
		{
			cell[i].pixmap=data[i].pixmap;
			XGetGeometry(dpy, cell[i].pixmap,
				 &root, &x, &y, &width, &height, &bw, &depth);
			cell[i].pix_h=height;
			cell[i].pix_w=width;
		}
		else
		{
			cell[i].pix_h=0;
			cell[i].pix_w=0;
		}
		if (data[i].mask!= (Pixmap) NULL) 
		{
			cell[i].mask=data[i].mask;
			XGetGeometry(dpy, cell[i].mask,
				 &root, &x, &y, &width, &height, &bw, &depth);
			if (cell[i].pix_h > height) cell[i].pix_h=height;
			if (cell[i].pix_w > width) cell[i].pix_w=width;
		}
		if (data[i].text!= (String) NULL) 
		{
			cell[i].text=data[i].text;
			cell[i].xmlabel = XmStringCreateLocalized(cell[i].text);
			width=XmStringWidth(pres->partres.font_list, cell[i].xmlabel);
			height=XmStringHeight(pres->partres.font_list, cell[i].xmlabel);
			cell[i].label_w=width;
			cell[i].label_h=height;
		}
		else
		{
			cell[i].label_w=0;
			cell[i].label_h=0;
		}
		cell[i].info_type=data[i].element_type;
		if (cell[i].info_type == XmNl_PixOnly)
		{ 
			pres->partres.RealW[i] = cell[i].pix_w + 2*H_MARGIN;
			if (cell[i].current_width == 0)
				cell[i].current_width = pres->partres.RealW[i];
		}
		if (cell[i].info_type == XmNl_PixBeginString || cell[i].info_type == XmNl_PixEndString)	
		{
			pres->partres.RealW[i] = cell[i].pix_w + cell[i].label_w + 3*H_MARGIN;
			cell[i].real_width = pres->partres.RealW[i];
			if (cell[i].current_width == 0)
				cell[i].current_width = pres->partres.RealW[i];
		}
		if (cell[i].info_type == XmNl_StringOnly)
		{
			pres->partres.RealW[i] = cell[i].label_w + 2*H_MARGIN;
			cell[i].real_width = pres->partres.RealW[i];
			if (cell[i].current_width == 0)
				cell[i].current_width = pres->partres.RealW[i];
		}
	}

	CalcGeom(w, False);
//printf("PartRes: resize callback content change\n");
//	XtResizeWidget(w, w->core.width, pres->partres.prefferedHeight, 0);
	ResizeDoCallback(w, XmNlItemsFound, XmNlContentChange);
	XtResizeWidget(w, w->core.width, pres->partres.prefferedHeight, 0);
//	XtWidgetProc resize;
//	_XmProcessLock();
//	resize = w->core.widget_class->core_class.resize;
//	_XmProcessUnlock();

	if (XtIsRealized(w))
	{
//		(* (resize)) ((Widget) pres);
//		XtResizeWindow(w);
		InternRedisplay(w);
	}
#ifdef DEBUG
	printf("\n PRSetElements complet");
#endif	
	return ;
}

void PRSetColNum(Widget w, int col_num)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	XmNlPR_Cell  * cell;
	int i;
#ifdef DEBUG
	printf("\n PRSetColNum started");
#endif	
		pres->partres.item_data=(XmNlPR_Cell *) XtRealloc((char *) pres->partres.item_data, 
		col_num* sizeof (XmNlPR_Cell));
//		pres->partres.num_cols=col_num;
		pres->partres.num_items=col_num;
		if (pres->partres.RealW) free((void *) pres->partres.RealW);
		pres->partres.RealW = malloc(sizeof(int) * pres->partres.num_items);
#ifdef DEBUG
	printf("\n RCSetColNum: num_cols=%d", pres->partres.num_cols=col_num);
#endif		
		cell=pres->partres.item_data;

	for (i=0; i<pres->partres.num_items; i++)
	{
		cell[i].alignment=CELL_DEFAULT_ALIGNMENT; 
		pres->partres.RealW[i] = 0;
	}
	
	
	return ;
}

int PRGetShift(Widget w)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
#ifdef DEBUG
	printf("\n PRGetShift complet");
#endif
	return pres->partres.global_h_shift;
}

void PRSetShift(Widget w, int shift)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i, x;
	XmNlPR_Cell  * cell;
#ifdef DEBUG
	printf("\n  PRSetShift started");
#endif

	cell = pres->partres.item_data;
//	x=pres->partres.global_h_shift;
	x = 0;
	for (i = 0; i < pres->partres.num_items; i++)
	{
		cell[i].x = x;
		x = x + cell[i].current_width;
	}
	
	if ((shift + pres->partres.viewWidth) > x )
		pres->partres.global_h_shift = x - pres->partres.viewWidth;
	else	
		pres->partres.global_h_shift = shift;
	
	if (XtIsRealized(w)) 
		InternRedisplay(w);
#ifdef DEBUG
	printf("\n PRSetColsWidth complet");
#endif
	return ;
}


void PRSetCellsWidth(Widget w, Dimension * data)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i, x, x2, CheckShift = -1;
	XmNlPR_Cell * cell;
#ifdef DEBUG
	printf("\n  PRSetCellsWidth started");
#endif
	cell = pres->partres.item_data;
	x = 0;
	x2 = 0;
	for (i=0; i<pres->partres.num_items; i++)
	{
		if (pres->partres.ResizeMode == XmNPR_Manual)
		{
			if (data[i] != 0)
			{
				cell[i].current_width = data[i];
				CheckShift = i;
			}
			cell[i].x = x;
			x = x + cell[i].current_width;
			x2 = x2 + cell[i].current_width;
#ifdef DEBUG
			printf("PRSetCellsWidth: col=%d x=%d width=%d\n", i, cell[i].x, cell[i].current_width);
#endif
		}
		else cell[i].current_width = pres->partres.viewWidth/100 * data[i];
	}
	pres->partres.full_width = x2;

	if (CheckShift != -1)
	{
		if (pres->partres.global_h_shift + pres->partres.viewWidth > pres->partres.full_width)
		{
			x2 = pres->partres.full_width - pres->partres.viewWidth;
			if (x2 >= 0)
			{
				pres->partres.global_h_shift = x2;
			}
			else
			{
				pres->partres.global_h_shift = 0;
//				printf("!!!!\n");
			}
		}
	}

	if (XtIsRealized(w))
		InternRedisplay(w);
	
#ifdef DEBUG
	printf("\n PRSetCellsWidth complet");
#endif
	return ;
}

void PRGetRealVector(Widget w, int ** data)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i, x, res;
#ifdef DEBUG
	printf("\n  PRGetRealVector started");
#endif

	*data = pres->partres.RealW;

	return ;
}



int PRGetGeometry(Widget w, Dimension * data, int * viewable_size)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i, x, res;
	XmNlPR_Cell * cell;
#ifdef DEBUG
	printf("\n  PRGetColsWidth started");
#endif
	cell=pres->partres.item_data;
	x=pres->partres.global_h_shift;
	res=0;
	for (i=0; i<pres->partres.num_items; i++)
	{
		data[i]=cell[i].current_width; 
		res=res+cell[i].current_width;
	}
#ifdef DEBUG
	printf("\n PRGetColsWidth complet");
#endif
	*viewable_size=pres->partres.viewWidth;
//	return  pres->partres.full_width;
	return res;
}

int PRGetColsWidth(Widget w, Dimension * data)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i, x, res;
	XmNlPR_Cell * cell;
#ifdef DEBUG
	printf("\n  PRGetColsWidth started");
#endif
	cell=pres->partres.item_data;
	x=pres->partres.global_h_shift;
	res=0;
	for (i=0; i<pres->partres.num_items; i++)
	{
		data[i]=cell[i].current_width; 
		res=res+cell[i].current_width;
	}
#ifdef DEBUG
	printf("\n PRGetColsWidth complet");
#endif
//	return  pres->partres.full_width;
	return res;
}

void PRSetTitleBarAlignment(Widget w, int num, unsigned char alignment)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i;
	XmNlPR_Cell * cell;
	cell=pres->partres.item_data;
	cell[num].alignment=alignment;
	if (XtIsRealized(w)) 	InternRedisplay(w);
	return ;

}



void PRSetColsTitles(Widget w, char ** data)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i;
	XmNlPR_Cell * cell;
#ifdef DEBUG
	printf("\n  PRSetColsTitles started");
#endif
	cell=pres->partres.item_data;
	
	for (i=0; i<pres->partres.num_items; i++)
	{
		cell[i].text=data[i];
		cell[i].xmlabel = XmStringCreateLocalized(cell[i].text);
		cell[i].label_w=XmStringWidth(pres->partres.font_list, cell[i].xmlabel);
		cell[i].label_h=XmStringHeight(pres->partres.font_list, cell[i].xmlabel);
		
	}
#ifdef DEBUG
	printf("\n PRSetColsTitles complet");
#endif
	return ;
}

static void RecalcParam( Widget w)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	XmNlPR_Cell  * cell;
	String tmp_str;
	int x, y;
	unsigned int width, height, bw, depth;
	Window root;
	int tmp_w, tmp_h;
	int i;
	int string_h = 0;
	int string_w = 0;
	int j = 0;
	Display *dpy;
	dpy = XtDisplay(w);

/*	tmp_h=0;
	cell=pres->partres.item_data;


	for (i=0; i<pres->partres.count_cell; i++)
	{
			if (cell[i].pix_h > tmp_h) tmp_h=cell[i].pix_h;
			if (cell[i].label_h > tmp_h) tmp_h=cell[i].label_h;
	}*/
	
/*	for (i=0; i<pres->partres.num_cols; i++)
	{
	tmp_w=0;
	rw=pres->partres.prop_data;*/

/*	if (rw[i].info_type==1)
		{
		for (j=0; j<pres->partres.num_rows; j++)
			{
			cell=RCgetCell(w, j, i);
			if (cell->pixmap!=(Pixmap)NULL && dpy) XGetGeometry(dpy, cell->pixmap,
				 &root, &x, &y, &width, &height, &bw, &depth);
			cell->pix_w=width;
			cell->pix_h=height;
			if (width > tmp_w) tmp_w=width;
			if (height > tmp_h) tmp_h=height;
			
			}
		rw[i].real_width=tmp_w+2*SM_H_MARGIN;
		}*/
/*	if (rw[i].info_type==2)
		{
		for (j=0; j<pres->partres.num_rows; j++)
			{
			cell=RCgetCell(w, j, i);
			cell->xmlabel = XmStringCreateLocalized(cell->text);
			width=XmStringWidth(pres->partres.font_list, cell->xmlabel);
			height=XmStringHeight(pres->partres.font_list, cell->xmlabel);
			cell->label_w=width;
			cell->label_h=height;
			if (width > tmp_w) tmp_w=width;
			if (height > tmp_h) tmp_h=height;
			
			}
		rw[i].real_width=tmp_w+2*SM_H_MARGIN;
		}
	}
	pres->partres.cell_height=tmp_h+2*SM_V_MARGIN;

#ifdef DEBUG
	printf("\n cell_recalc\n");
#endif
	for (i=0; i<pres->partres.num_cols; i++)
	{
	printf("\n Column=%d w=%d\n", i, rw[i].real_width);	
	}



	printf("\n XmPartRes: CalcGeom height= %d\n", tmp_h);
	fflush(stdout);*/
}


static Boolean CalcGeom( Widget w, Boolean recalcLabel)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	XmNlPR_Cell  * cell;
	int i, delta, delta2;
	Dimension tmp_w, tmp_h;
	XFontStruct *font;

	tmp_w = 0;
	delta = 0;
	
#ifdef DEBUG
	printf("\n XmPartRes: CalcGeom started\n");
#endif
	tmp_h = 0;
	cell = pres->partres.item_data;


	for (i = 0; i < pres->partres.num_items; i++)
	{
		if (cell[i].pix_h > tmp_h) tmp_h = cell[i].pix_h;
#ifdef DEBUG
	printf("\n XmPartRes: CalcGeom %d height= %d %d\n", i, tmp_h, cell[i].pix_h);
	fflush(stdout);
#endif
		if (recalcLabel && cell[i].xmlabel)
		{
			cell[i].label_w = XmStringWidth(pres->partres.font_list, cell[i].xmlabel);
			cell[i].label_h = XmStringHeight(pres->partres.font_list, cell[i].xmlabel);
		}
			if (cell[i].label_h > tmp_h) tmp_h = cell[i].label_h;
#ifdef DEBUG
	printf("\n XmPartRes: CalcGeom %d height= %d %d\n", i, tmp_h, cell[i].label_h);
	fflush(stdout);
#endif
	}
	
/*	pres->partres.full_height=pres->partres.cell_height*pres->partres.num_rows;
	
	rw=pres->partres.prop_data;

		for (i=0; i<pres->partres.num_cols; i++)
			{
			if(rw[i].current_width==0) rw[i].current_width=rw[i].real_width;
			tmp_w=tmp_w+rw[i].current_width;
			rw[i].x=delta;
			delta=delta+rw[i].current_width;
	printf("\nCalcGeom: x=%d\n", rw[i].x);
			}
	pres->partres.scroll_height=pres->partres.full_height-pres->partres.viewHeight;
	pres->partres.pix_buf_row=pres->partres.viewHeight/pres->partres.cell_height+4;
	pres->partres.pix_buf_h=pres->partres.pix_buf_row*pres->partres.cell_height;

	pres->partres.full_width=tmp_w;
	if (tmp_w>=pres->partres.viewWidth) 	pres->partres.scroll_width=pres->partres.full_width-pres->partres.viewWidth;
		else
		{
			delta2=pres->partres.viewWidth-tmp_w;
			delta=0;
		for (i=0; i<pres->partres.num_cols; i++)
			{
			if(rw[i].autoresize==True) rw[i].current_width=rw[i].current_width+delta2;
			tmp_w=tmp_w+rw[i].current_width;
			rw[i].x=delta;
			delta=delta+rw[i].current_width;
	printf("\nCalcGeom: x=%d\n", rw[i].x);
			}
			
		}

	return True;*/

	if (tmp_h == 0)
		if (XmeRenderTableGetDefaultFont(pres->partres.font_list, &font))
			tmp_h = font->ascent + font->descent;


	if (tmp_h)
		tmp_h = tmp_h + 4*((XmPrimitiveWidget)w)->primitive.shadow_thickness + 2 * V_MARGIN;
	else
		tmp_h = 14 + 4*((XmPrimitiveWidget)w)->primitive.shadow_thickness + 2 * V_MARGIN;
//	tmp_h = tmp_h + 2*((XmPrimitiveWidget)w)->primitive.shadow_thickness +
//		2*((XmPrimitiveWidget)w)->primitive.highlight_thickness + 2 * V_MARGIN;

//	pres->core.height=tmp_h;
#ifdef DEBUG
	printf("\n XmPartRes: CalcGeom height= %d\n", tmp_h);
	fflush(stdout);
#endif

	if (pres->partres.prefferedHeight != tmp_h)
	{
		pres->partres.prefferedHeight = tmp_h;
//#ifdef DEBUG
	printf("\n XmPartRes: CalcGeom prefferedHeight= %d\n", pres->partres.prefferedHeight);
	fflush(stdout);
//#endif
		return True;
	}
	else
		return False;
}






/************************************************************
 *
 * Callbacks and Action Routines.
 *
 ************************************************************/
static void
ResizeDoCallback(Widget w, char status, int source)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i, x;
	XmNlPR_Cell * cell;
    static ListResizeReturnStruct ret;


	cell = pres->partres.item_data;
	ret.state = status;
	ret.reason = source;
	ret.wid_width = pres->partres.viewWidth;
	ret.cur_h_shift = pres->partres.global_h_shift;

	ret.col_sharp_width = pres->partres.ElSharpSize;
	ret.col_cur_width = pres->partres.ElCurSize;
	ret.col_new_width = pres->partres.ElNewSize;

//printf("Partres resize do callback\n");
	
	if (!cell)
	{
		ret.cols_num = 0;
//		XtCallCallbacks(w, XmNlprResizeCallback, (XtPointer) &ret);
		return ;
	}

/*	for (i=0; i< pres->partres.count_cell; i++)
	{
		ret.col_sharp_width[i] = pres->partres.RealW[i];
		ret.col_cur_width[i] = pres->partres.RealW[i];
	}

	XtCallCallbacks(w, XmNlprResizeCallback, (XtPointer) &ret);
*/	

	pres->partres.full_width = 0;
//printf("Partres resize do callback2\n");
	for (i=0; i< pres->partres.num_items; i++)
	{
		*(pres->partres.ElSharpSize+i) = (cell+i)->real_width;
		*(pres->partres.ElCurSize+i) = (cell+i)->current_width;
		*(pres->partres.ElNewSize+i) = 0;
		pres->partres.full_width = pres->partres.full_width + (cell+i)->current_width;
	}
//printf("Partres resize do callback3\n");

	ret.cols_num = pres->partres.num_items;
	ret.wid_width = pres->partres.viewWidth;
	ret.last_wid_width = pres->partres.viewWidth;
	ret.col_sharp_width = pres->partres.ElSharpSize;
	ret.col_cur_width = pres->partres.ElCurSize;
	ret.col_new_width = pres->partres.ElNewSize;
	ret.list_full_width = pres->partres.full_width;
	ret.cur_h_shift = pres->partres.global_h_shift;
	ret.new_h_shift = 0;

    XtCallCallbacks(w, XmNlprResizeCallback, (XtPointer) &ret);
//printf("Partres resize do callback4\n");

	pres->partres.global_h_shift = ret.new_h_shift;
/*	if (pres->partres.render_order == LtoR_render) 
		x = pres->partres.viewX - pres->partres.global_h_shift;
	else 
		x = pres->partres.viewX + pres->partres.viewWidth + pres->partres.global_h_shift;
*/
	x = 0;
	pres->partres.full_width = 0;
	for (i = 0; i < pres->partres.num_items; i++)
	{
		(cell+i)->current_width = ret.col_new_width[i];
		printf("PartRes after resize callback current_width%d = %d pixbuf  = %ld\n", i, ret.col_new_width[i], (cell+i)->pixbuf);
		(cell+i)->x = x;
/*		if (pres->partres.render_order == LtoR_render) 
			x = x + (cell+i)->current_width;
		else
			x = x - (cell+i)->current_width;*/
		x = x + (cell+i)->current_width;	
		pres->partres.full_width = pres->partres.full_width + (cell+i)->current_width;
	}
//printf("Partres resize do callback5\n");
	return ;
}

static void
ChangedDoCallback(Widget w, int pos, int size)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i;
	XmNlPR_Cell * cell;
    static PartResChangeReturnStruct ret;
	cell=pres->partres.item_data;
	ret.pos=pos;
	ret.new_size=size;
    XtCallCallbacks(w, XtNchangePartCallback, (XtPointer) &ret);
	return ;
}


static void
StartMoveDoCallback(Widget w, int pos)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i;
	XmNlPR_Cell * cell;
    static PartResStartMoveReturnStruct ret;
	ret.pos=pos;
    XtCallCallbacks(w, XtNstartMovePartCallback, (XtPointer) &ret);
	return ;
}

static void
MoveDoCallback(Widget w, int pos)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i, x1;
	XmNlPR_Cell * cell;
    static PartResMoveReturnStruct ret;


	ret.pos = pres->partres.CurrentResizedPos;

	cell = pres->partres.item_data;
	if (!cell)
		return ;


	if (pres->partres.render_order == LtoR_render) 
//		ret.new_size = pos - cell[pres->partres.CurrentResizedPos].x;
		x1 = pos + pres->partres.global_h_shift;
	else
		x1 = pres->partres.viewWidth - pos + pres->partres.global_h_shift;
//		ret.new_size = cell[pres->partres.CurrentResizedPos].x - pos;

	ret.new_size = x1 - cell[pres->partres.CurrentResizedPos].x;

#ifdef DEBUG
	for (i=0; i<pres->partres.num_items; i++)
	{
		printf("MoveDoCallback: col=%d x=%d width=%d\n", 
					i, cell[i].x, cell[i].current_width);		
	}

	printf("MoveDoCallback: col=%d shift=%d pos=%d x=%d x1=%d new_size=%d\n", 
				pres->partres.CurrentResizedPos, pres->partres.global_h_shift, pos,
				cell[pres->partres.CurrentResizedPos].x, x1, ret.new_size);		
#endif

	x1 = 0;
	for (i = 0; i < pres->partres.num_items; i++)
	{
		if (i == pres->partres.CurrentResizedPos) 
			x1 = x1 + ret.new_size;
		else
			x1 = x1 + (cell+i)->current_width;	
	}
	
	if (x1 < pres->partres.viewWidth)
		return ;
	
	if (ret.new_size > 10)
		XtCallCallbacks(w, XtNmovePartCallback, (XtPointer) &ret);

	return ;
}

static void
MoveDoCallbackBack(Widget w, int pos)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i;
	XmNlPR_Cell * cell;
    static PartResMoveReturnStruct ret;
	ret.pos=pos;
    XtCallCallbacks(w, XtNmovePartCallback, (XtPointer) &ret);
	return ;
}

/************************************************************
 *
 * Internal routines.
 *
 ************************************************************/
/*int SetHorShift (Widget w, int newshift, Boolean change_select)
{


}
*/

/*int SetVerShift (Widget w, int newshift, Boolean change_select)
{
	return 0;
}
*/
static void
VScrollCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
}

static void
HScrollCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
}

/*	Function Name: ResizeSliders
 *	Description:   Resizes the thumbs of the v and h scrollbars.
 *	Arguments:     w - the PartRes widget.
 *	Returns:       none
 *
 */

static void
ResizeSliders(Widget w)
{

}

static int FW_ClickInItem(unsigned long x, unsigned long y, Widget w)
{


}

static void DeselctAll(Widget w)
{

}


static void AdjustGlobalHorShift(Widget w)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i;
	

#ifdef DEBUG
	printf("\nAdjustGlobalHorShift 1: %d \n", pres->partres.global_h_shift);
#endif

	pres->partres.full_width = 0;
	for (i = 0; i < pres->partres.num_items; i++)
	{
		pres->partres.full_width = pres->partres.full_width + pres->partres.item_data[i].current_width;
	}
	
	if ((pres->partres.viewWidth + pres->partres.global_h_shift) > pres->partres.full_width)
		pres->partres.global_h_shift = pres->partres.full_width - pres->partres.viewWidth;

#ifdef DEBUG
	printf("\nAdjustGlobalHorShift 2: %d \n", pres->partres.global_h_shift);
#endif
	return ;
}	
	
static void AdjustGlobalShift(Widget w)
{

	return;


}


static void ButtonDownAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
	Display *dpy;
	Window win;
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
    XButtonEvent * bevent = (XButtonEvent *) event;
	int i, x1, y1;
	Boolean resized=False;
	Position x, y;
	XmNlPR_Cell * cell;
	x=bevent->x;
	y=bevent->y;
	dpy = XtDisplay(w);
	win = XtWindow(w);
	cell = pres->partres.item_data;
#ifdef DEBUG
	printf(">>>>>>>\nButtonDownAction\n");
#endif
	if (pres->partres.ResizeState == True)
	{
		pres->partres.LastResizerPos = x;
		pres->partres.StartResizerPos = x;
/*		XDrawLine(dpy, win, pres->partres.eorGC, x, pres->partres.viewY, 
		x, pres->partres.viewY+pres->partres.viewHeight);
		if (pres->partres.startMoveCallback) 
			StartMoveDoCallback(w, x-pres->partres.viewY);*/
	}

return;
}


static void ButtonUpAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
	Display *dpy;
	Window win;
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
    XButtonEvent * bevent = (XButtonEvent *) event;
	int i, x1, y1;
	Boolean resized=False;
	Position x, y;
	XmNlPR_Cell * cell;
	x=bevent->x;
	y=bevent->y;
	dpy = XtDisplay(w);
	win = XtWindow(w);
	cell=pres->partres.item_data;
#ifdef DEBUG
	printf("\nButtonUpAction\n");
#endif
	if (pres->partres.ResizeState==True)
	{
/*		XDrawLine(dpy, win, pres->partres.eorGC, pres->partres.LastResizerPos, pres->partres.viewY, 
		pres->partres.LastResizerPos, pres->partres.viewY+pres->partres.viewHeight);*/
		XUndefineCursor(dpy, win);
        pres->partres.ResizeState=False;
		i=pres->partres.CurrentResizedPos;
//		cell[i].current_width=cell[i].current_width-(pres->partres.StartResizerPos-x);
/*		if (pres->partres.render_order == LtoR_render)
			cell[i].current_width=cell[i].current_width-(pres->partres.StartResizerPos-pres->partres.LastResizerPos);
		else
			cell[i].current_width=cell[i].current_width-(pres->partres.LastResizerPos-pres->partres.StartResizerPos);
*/		
//		if (pres->partres.changeCallback) ChangedDoCallback(w, i, cell[i].current_width);
		pres->partres.CurrentResizedPos=-1;
//		InternRedisplay(w);
	}
#ifdef DEBUG
	for (i=0; i<pres->partres.num_items; i++)
	{
			printf("PR ButtonUpAction: col=%d x=%d width=%d\n", i, cell[i].x, cell[i].current_width);
	}
#endif

	return;
}




static void ButtonDownActionBack(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
	Display *dpy;
	Window win;
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
    XButtonEvent * bevent = (XButtonEvent *) event;
	int i, x1, y1;
	Boolean resized=False;
	Position x, y;
	XmNlPR_Cell * cell;
	x=bevent->x;
	y=bevent->y;
	dpy = XtDisplay(w);
	win = XtWindow(w);
	cell=pres->partres.item_data;
#ifdef DEBUG
	printf("\nButtonDownAction\n");
#endif
	if (pres->partres.ResizeState==True)
	{
		pres->partres.LastResizerPos=x;
		pres->partres.StartResizerPos=x;
		XDrawLine(dpy, win, pres->partres.eorGC, x, pres->partres.viewY, 
		x, pres->partres.viewY+pres->partres.viewHeight);
		if (pres->partres.startMoveCallback) 
			StartMoveDoCallback(w, x-pres->partres.viewY);
	}

return;
}


static void ButtonUpActionBack(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
	Display *dpy;
	Window win;
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
    XButtonEvent * bevent = (XButtonEvent *) event;
	int i, x1, y1;
	Boolean resized=False;
	Position x, y;
	XmNlPR_Cell * cell;
	x=bevent->x;
	y=bevent->y;
	dpy = XtDisplay(w);
	win = XtWindow(w);
	cell=pres->partres.item_data;
#ifdef DEBUG
	printf("\nButtonUpAction\n");
#endif
	if (pres->partres.ResizeState==True)
	{
		XDrawLine(dpy, win, pres->partres.eorGC, pres->partres.LastResizerPos, pres->partres.viewY, 
		pres->partres.LastResizerPos, pres->partres.viewY+pres->partres.viewHeight);
//		XDrawLine(dpy, win, pres->partres.drawGC, x, pres->partres.viewY, x, pres->partres.viewY+pres->partres.viewHeight);
		XUndefineCursor(dpy, win);
        pres->partres.ResizeState=False;
		i=pres->partres.CurrentResizedPos;
//		cell[i].current_width=cell[i].current_width-(pres->partres.StartResizerPos-x);
		if (pres->partres.render_order == LtoR_render)
			cell[i].current_width=cell[i].current_width-(pres->partres.StartResizerPos-pres->partres.LastResizerPos);
		else
			cell[i].current_width=cell[i].current_width-(pres->partres.LastResizerPos-pres->partres.StartResizerPos);
		
		if (pres->partres.changeCallback) ChangedDoCallback(w, i, cell[i].current_width);
		pres->partres.CurrentResizedPos=-1;
		InternRedisplay(w);
	}
return;
}






static int 
XYtoEdgePos(Widget w, Position x, Position y)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i, x1, y1, ret;
	XmNlPR_Cell * cell = pres->partres.item_data;

	ret = -1;

	if (pres->partres.render_order == LtoR_render) 
	{
		x1 = x - pres->partres.viewX + pres->partres.global_h_shift;
	}
	else
	{
		x1 = pres->partres.viewX + pres->partres.viewWidth - x + pres->partres.global_h_shift;
	}

#ifdef DEBUG
			printf("XYtoEdgePos: x1 = %d \n", x1);
#endif
	for (i = 0; i < pres->partres.num_items; i++)
	{
		if ((cell[i].x + cell[i].current_width - pres->partres.global_h_shift) < 0)
			continue ;
			
		if ((cell[i].x + cell[i].current_width - pres->partres.global_h_shift) > pres->partres.viewWidth)
			break;
			
			
		if ((cell[i].x + cell[i].current_width + 1) > x1 && (cell[i].x + cell[i].current_width - 3) < x1)
		{
			ret=i;
#ifdef DEBUG
			printf("XYtoEdgePos: col = %d pos = %d x1 = %d x = %d\n", i, x1, cell[i].x + cell[i].current_width);
#endif
		}
	}	

/*	x1 = pres->partres.viewX - pres->partres.global_h_shift;
	y1 = pres->partres.viewY;
	for (i=0; i< pres->partres.num_items; i++)
	{
		x1=x1+cell[i].current_width;
		if (pres->partres.render_order == LtoR_render) 
		{
			if (x1 >=pres->partres.viewWidth) 
				break;
		}
		else
		{
			if (pres->partres.viewWidth - x1 >=pres->partres.viewWidth)
				break;
		}
		if ((pres->partres.render_order == LtoR_render && x1 > pres->partres.viewX) ||
			(pres->partres.render_order == RtoL_render && pres->partres.viewWidth - x1 > pres->partres.viewX))
		{
			if (pres->partres.render_order == LtoR_render) 
			{
				if (x>(x1-3) && x<(x1+1) )
				{
					ret=i;
#ifdef DEBUG
					printf("XYtoEdgePos: col = %d pos = %d x = %d x1 = %d\n", i, x, cell[i].x, x1);
#endif
				}
			}
			else
			{
				if (pres->partres.viewWidth - x>(x1-3) && pres->partres.viewWidth - x<(x1+1) )
					ret=i;
			}
			if ( y < pres->partres.viewY || y > pres->partres.viewY+pres->partres.viewHeight )
				ret=-1;
		}
	}*/
	return ret;
	
}

static Boolean 
ResizerOutOfRang(Widget w, Position x)
{
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	int i, k, x1, x2, x3, x4 = 0;
	Boolean ret;
	XmNlPR_Cell * cell;
	cell = pres->partres.item_data;
	ret = FALSE;

	x1 = pres->partres.viewX;
	x3 = pres->partres.viewX + pres->partres.viewWidth;
	k = pres->partres.CurrentResizedPos;

//	x2 = pres->partres.viewX - pres->partres.global_h_shift;



	if (pres->partres.render_order == LtoR_render) 
	{
		x2 = x - pres->partres.viewX + pres->partres.global_h_shift;
	}
	else
	{
		x2 = pres->partres.viewX + pres->partres.viewWidth - x + pres->partres.global_h_shift;
	}




	
	for (i = 0; i < k; i++)
		{
			x4 = x4 + cell[i].current_width;
		}
	x4 = x4 + RS_LIMIT;	
//	printf("ResizerOutOfRang %d x = %d x1 = %d x2 = %d x3 = %d x4 = %d\n", k, x, x1, x2, x3, x4);
	if (x < x1 || x2 < x4 || x > x3) ret = TRUE;
		return ret;
	
}


static void 
ButtonMotionAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
	Display *dpy;
	Window win;
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
    XButtonEvent * bevent = (XButtonEvent *) event;
	int i, x1, y1;
	Boolean resized=False;
	Position x, y;
	XmNlPR_Cell * cell;
	x=bevent->x;
	y=bevent->y;
	dpy = XtDisplay(w);
	win = XtWindow(w);
	cell=pres->partres.item_data;
	if (pres->partres.ResizeState == True && x != pres->partres.LastResizerPos && !ResizerOutOfRang(w, x))
	{
//		XDrawLine(dpy, win, pres->partres.eorGC, pres->partres.LastResizerPos, pres->partres.viewY, 
//		pres->partres.LastResizerPos, pres->partres.viewY+pres->partres.viewHeight);
		
		pres->partres.LastResizerPos = x;
		
//		XDrawLine(dpy, win, pres->partres.eorGC, pres->partres.LastResizerPos, pres->partres.viewY, 
//		pres->partres.LastResizerPos, pres->partres.viewY+pres->partres.viewHeight);
		if (pres->partres.moveCallback) 
		{
			MoveDoCallback(w, x - pres->partres.viewX);
		}
	}
#ifdef DEBUG
	printf("\nButtonMotionAction\n");
#endif
}


static void 
ButtonMotionActionBack(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
	Display *dpy;
	Window win;
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
    XButtonEvent * bevent = (XButtonEvent *) event;
	int i, x1, y1;
	Boolean resized=False;
	Position x, y;
	XmNlPR_Cell * cell;
	x=bevent->x;
	y=bevent->y;
	dpy = XtDisplay(w);
	win = XtWindow(w);
	cell=pres->partres.item_data;
	if (pres->partres.ResizeState==True && x!=pres->partres.LastResizerPos && !ResizerOutOfRang(w, x))
	{
		XDrawLine(dpy, win, pres->partres.eorGC, pres->partres.LastResizerPos, pres->partres.viewY, 
		pres->partres.LastResizerPos, pres->partres.viewY+pres->partres.viewHeight);
		
		pres->partres.LastResizerPos=x;
		
		XDrawLine(dpy, win, pres->partres.eorGC, pres->partres.LastResizerPos, pres->partres.viewY, 
		pres->partres.LastResizerPos, pres->partres.viewY+pres->partres.viewHeight);
		if (pres->partres.moveCallback) 
		{
					MoveDoCallback(w, x-pres->partres.viewY);
		}
	}
#ifdef DEBUG
	printf("\nButtonMotionAction\n");
#endif
}


static void 
MouseMotionAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
	Display *dpy;
	Window win;
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	XMotionEvent *me;
	int i, x1, y1;
	Boolean resized=False;
	Position x, y;
	XmNlPR_Cell * cell;
	
	if (!pres->partres.RepartingOn) 
		return;
	
	if (event->type != MotionNotify) 
		return;
		
	me = (XMotionEvent *) event;

	x = me->x;
	y = me->y;
	dpy = XtDisplay(w);
	win = XtWindow(w);
	cell = pres->partres.item_data;

	i = XYtoEdgePos(w, x, y);

			if (i>=0 && i!=pres->partres.num_items-1)
			{
				pres->partres.CurrentResizedPos = i;
				if (pres->partres.ResizeState != True)
				XDefineCursor(dpy, win, pres->partres.hResizeCursor);
				pres->partres.ResizeState = True;
				resized = True;
			}

		if (pres->partres.ResizeState==True && resized==False)
		{
			pres->partres.ResizeState = False;
			XUndefineCursor(dpy, win);
			pres->partres.CurrentResizedPos = -1;
		}
}


static void 
MouseMotionActionBack(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
	Display *dpy;
	Window win;
    XmNlPartResWidget pres = (XmNlPartResWidget) w;
	XMotionEvent *me;
	int i, x1, y1;
	Boolean resized=False;
	Position x, y;
	XmNlPR_Cell * cell;
	
	if (!pres->partres.RepartingOn) return;
	
	if (event->type != MotionNotify) return;
		me=(XMotionEvent *) event;
	x=me->x;
	y=me->y;
	dpy = XtDisplay(w);
	win = XtWindow(w);
	cell=pres->partres.item_data;
	i=XYtoEdgePos(w, x, y);
			if (i>=0 && i!=pres->partres.num_items-1)
			{
				pres->partres.CurrentResizedPos=i;
				if (pres->partres.ResizeState!=True)
				XDefineCursor(dpy, win, pres->partres.hResizeCursor);
				pres->partres.ResizeState=True;
				resized=True;
				
			}

		if (pres->partres.ResizeState==True && resized==False)
		{
				pres->partres.ResizeState=False;
		XUndefineCursor(dpy, win);
				pres->partres.CurrentResizedPos=-1;
			
			
		}
}


static void ScrollAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{

}
/*static Boolean
SelectChanged(XmPartResWidget pres)
{

}*/

//static void
//MakeHighlightCallbackStructOrig(XmResColListWidget it, ListItemReturnStruct * ret)
//{

//}

//static void
//MakeHighlightCallbackStruct(XmResColListWidget it, ListItemReturnStruct * ret)
//{

//}

static void
DoubleClickDoCallback(Widget w, int number)
{
}

static void
HighlightDoCallback(Widget w)
{
    XtCallCallbacks(w, XtNhighlightCallback, (XtPointer) NULL);

}




static void KeyPressAction(Widget w, XEvent *event, String *params, Cardinal *num_params)

//static void FW_CbKey(Widget w, XtPointer client_data, XEvent *event)
{
	

}

int min_value(int a, int b, int c)
{
	int ret;
	if (a < b) ret=a;
		else ret=b;
	if (ret <= c) return ret;
		else ret=c;
	
	return ret;
}

static void
Focus_In(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
}

static void
Focus_Out(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
}
