/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */

#ifndef _XmNlListP_h
#define _XmNlListP_h

#if defined(VMS) || defined(__VMS)
#include <X11/apienvset.h>
#endif

/************************************************************
*	INCLUDE FILES
*************************************************************/
#include <Xm/ManagerP.h>
#include <Xm/PrimitiveP.h>

#include "XmNlList.h"
#include "XmNlPartRes.h"
#include "XmNlResColList.h"
#include "XmNlCompResource.h"
/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

#define RtoL_render 1
#define LtoR_render 2


/************************************************************
*	MACROS
*************************************************************/



/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/




/*
 * XmNlList.
 */

typedef struct ListTbarCell {
	Pixmap pixmap;
	Pixmap mask;
	Dimension pix_w;
	Dimension pix_h;
/*	String text;*/
	XmString xmlabel;
	Dimension label_w;
	Dimension label_h;
/*	Pixmap pixbuf;
	Dimension pixbuf_w;
	Dimension pixbuf_h;*/
	Dimension real_width;
	Dimension current_width;
	unsigned char info_type;
	unsigned char column_type;
//	unsigned char alignment;
	unsigned char priority;
	Boolean resizible;
	Boolean autoresize;
	Boolean armed;
	int align_type;
	unsigned char markedStatus;
/*	Boolean displayed;*/
	int x;
/*	void * UserDataPointer;*/
	int value;
	int marginW; /* margin width */
	int marginH; /* margin heoght */
	int padding; /* spacing between icon and text label */
	Pixel background;
	Pixel foreground;
} ListTbarCell;

typedef struct {
	XtPointer extension;	/* Just in case we need it later. */
} XmNlListClassPart;

typedef struct _XmNlListClassRec {
    CoreClassPart		core_class;
    CompositeClassPart		composite_class;
    ConstraintClassPart		constraint_class;
    XmManagerClassPart		manager_class;
    XmNlListClassPart		list_class;
} XmNlListClassRec;

typedef struct _XmNlListPart{
    /* resources */

	XmFontList render_table;	/* This widget's font list. */
	Boolean MouseMoved;
	XmString default_label;
	char ViewListType;
	int readonly_num_cols;
	int autores;
	Dimension		margin_width;
	Dimension		margin_height;
	Dimension		margin_title;
	Dimension		title_shadow_thickness;
	Dimension		pixmapTextPadding;
	Pixel arm_color;
    /* private state */

	unsigned char render_order;
	Cursor hResizeCursor;
	XmNlCell * highlightCell;

//	Position TbCurrentResizerPos;
	Position TbStartResizerPos;
	Position TbLastResizerPos;
	int TbCurrentResizedPos;
	Boolean TbResizeState;

	int autoAdjustedNum;
	int highlightCount;
	/* intern widgets */
//	Widget title_bar;		/* The list title widget. */
    Widget rclist;		/* The internal list widget. */
    Widget v_bar, h_bar;	/* The scrollbars. */
	Widget item_box;		/* The ItemBox. */
	Widget tree;
	XtCallbackList highlightCallback;
	XtCallbackList double_click;
	XtCallbackList tileClick;
	
	Boolean ItemBoxScrollsFound;
	Boolean ResColScrollsFound;
	
	Boolean AuotoResChanged;
	Boolean TSizeNotSet;
	Boolean ListEmpty;
	Boolean adjust_last_column;
	Boolean PropConsistency;
	Boolean AutoPlacementMarker;
	int * FlSize;		/* Full column size */
	int * CurSize;		/* Current Column size */
	int * TSize;		/* Full title col size */
	int * TIdealSize; 	/* Ideal size for each particular tile */
	int ideal_full_width_title;
	int num_cols;
	int h_shift;
	ListTbarCell * tbar_item;
	ListTbarCell * tbar_item_last;
	int SelectedPositionCount;
	int incrCol;
	int decrCol;
	int * SelectedPositions;
	GC drawGC;
	GC fill_gc;
	Pixmap markerUpPixmap;
	Pixmap markerUpMask;
	Pixmap markerDownPixmap;
	Pixmap markerDownMask;
	int markedColNumber;
	unsigned char markedStatus;
/******* layout geometry ********/
	int TBfullHeight;
	int TBfullWidth;
	Position TbarX;
	Position TbarY;
	Position RCshadX;
	Position RCshadY;
	Dimension RCfullHeight;
	Dimension RCfullWidth;
	Dimension TBfullTilesWidth;
	Position TBviewX;
	Position TBviewY;
	Dimension TBviewWidth;
	Dimension TBviewHeight;
	} XmNlListPart;

typedef struct _XmNlListRec {
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    XmManagerPart	manager;
    XmNlListPart	list;
} XmNlListRec;

/************************************************************
*	EXTERNAL DECLARATIONS
*************************************************************/



extern XmNlListClassRec xmNlListClassRec;


#if defined(__cplusplus)
}
#endif

/************************************************************
*	STATIC DECLARATIONS
*************************************************************/

#if defined(VMS) || defined(__VMS)
#include <X11/apienvrst.h>
#endif

#endif /* _XmNlListP_h */
