/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */

#ifndef _XmNlList_h
#define _XmNlList_h

#if defined(VMS) || defined(__VMS)
#include <X11/apienvset.h>
#endif


/************************************************************
*	INCLUDE FILES
*************************************************************/
#include "XmNlItemBox.h"
#include "XmNl.h"
#include "XmNlResColList.h"

/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

#define XmCItemLay			"ItemLay"
#define XmNItemLay			"itemlay"
#define XmRItemLay			"ItemLayPointer"

#define XmCItemLayTable			"ItemLayTable"
#define XmNItemLayTable			"itemlaytable"
#define XmRItemLayTable "ItemLayTablePointer"

#define XmCViewListType			"ViewType"
#define XmNViewListType			"view_type"

#define XmNlAutoAdjustLastCol	"autoAdjustLastCol"
#define XmCautoAdjustLastCol	"AutoAdjustLastCol"

#define XtNhighlightCallback	"highlightCallback"

#define XtNhighlightCount 		"HighlightCount"
#define XmChighlightCount 		"highlight_count"

#define XtNhighlightList 		"HighlightList"
#define XmChighlightList 		"highlight_list"

#define XmNlList_Detail		1
#define XmNlList_Big		2
#define XmNlList_Tree		3
#define XmNlList_TreeCol	4
#define XmNlList_Small		5

#define XmNlTileClickedCallback	"tileClickedCallback"


typedef struct _XmNlListClassRec	*XmNlListWidgetClass;
typedef struct _XmNlListRec		*XmNlListWidget;


/************************************************************
*	MACROS
*************************************************************/

/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/
/*typedef struct _XmNlListPropRecElement
{
	char RowType;
	String	RowTitleText;
} XmNlListPropRecElement;
*/
/*typedef struct _XmNlListPropCol {*/
/* Title property */
/*	Pixmap TitlePixmap;
	Pixmap TitleMask;
	String TitleText;
	XmString TitleXmlabel;
	unsigned char TitleType;
	unsigned char TitleAlignment;*/
/* List property */
/*	Boolean ColResizible;
	int size;
	unsigned char ColumnType;
	unsigned char ColumnAlignement;
} XmNlListPropCol;*/

/************************************************************
* Public function declarations
*************************************************************/
Widget XmNlListGetRCWidget(Widget w);
Widget XmNlListGetIBWidget(Widget w);

void XmNlListSetCell(Widget w, XmNlCell * cell_data, unsigned char valuemask, int row, int col);

void XmNlListSetFrozenStatus(Widget w, Boolean status);

void XmNlListSetAutoresCol(Widget w, int n);

void XmNlListSetSelectedItems(Widget w, int num, int* data);

void XmNlListAddItems(Widget w, XmNlCell * items, int count, unsigned char valuemask);

void XmNlListAddRows(Widget w, XmNlCell * cell, int row_count, unsigned char valuemask);

void XmNlListDeleteRow(Widget w, int position);

void XmNlListInsertRow(Widget w, XmNlCell * cell, int row_pos, unsigned char valuemask);

void XmNlListDeletAllInfo(Widget w);

XmNlCell * XmNlListGetSelCells(Widget w, int *count);

Boolean XmNlListGetItem(Widget w, XmNlCell *cell, unsigned char valuemask, int position);

int XmNlListXYtoPos(Widget w, unsigned long x, unsigned long y);

XmNlListTreeItem *XmNlListTreeAddBranch (Widget w, XmNlListTreeItem *parent, XmNlCell *cell, unsigned char valuemask);

XmNlListTreeItem *XmNlListTreeAddLeaf (Widget w, XmNlListTreeItem *parent, XmNlCell *cell, unsigned char valuemask);

//XmNlListTreeItem *XmNlListTreeAddLeafOpt (Widget w, XmNlListTreeItem *parent, XmNlCell *data);

//XmNlListTreeItem *XmNlListTreeAddBranchOpt (Widget w, XmNlListTreeItem *parent, XmNlCell * data);

void XmNlListTreeRefresh(Widget w); 


int XmNlListAppendColumn(Widget w, XmNlColSpecRec * csrec);
int XmNlListCleanAllColumn(Widget w);
int XmNlListSetColumn(Widget w, XmNlColSpecRec * csrec, int col_num);
int XmNlListDeleteColumn(Widget w, int column);




/************************************************************
*	EXTERNAL DECLARATIONS
*************************************************************/

extern WidgetClass xmNlListWidgetClass;

#if defined(__cplusplus)
}
#endif

#if defined(VMS) || defined(__VMS)
#include <X11/apienvrst.h>
#endif

#endif /* _XmNlList_h */
