/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */

/************************************************************
*	INCLUDE FILES
*************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <X11/X.h> 
#include <Xm/XmP.h>
#include <Xm/ExtP.h>
#include <Xm/DrawP.h>
#include <X11/ShellP.h>

#include "XmNlListP.h"
#include "XmNlPartRes.h"
#include "XmNlResColList.h"
#include "XmNlItemBox.h"
//#include "XmNlListTree.h"
#include "XmNl.h"
//#include <Xm/Label.h>
//#include <Xm/PushB.h>
#include <Xm/ScrollBar.h>
//#include <Xm/TextF.h>

//#include <Xm/ExtP.h>
#include "XmNlResColListP.h"
#include "XmNlPartResP.h"



/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/

#define CHECK_CLIP_CORRECT (XmVERSION >= 2 && XmREVISION >= 3 && XmUPDATE_LEVEL >= 4)
#define PIX_FOUND(value) ((value <= XmUNSPECIFIED_PIXMAP) ? 0 : 1)

#define SUPERCLASS ((WidgetClass) &xmManagerClassRec)

#define MAX_XMNLLIST_STARTED_WIDGET_WIDTH 250
#define H_MARGIN elist->list.margin_width
#define V_MARGIN elist->list.margin_height
#define T_MARGIN elist->list.margin_title
#define RESOURCE_DEFAULT 2

#define ItemBox		1
#define TitleBar	2
#define ResCol		3
#define ListTree	4


#define DEFAULT_tag		XmS

#define DEFAULT_TEXT_IN_TILE "o"

#define RS_LIMIT 6

//#define DEBUG 1
/************************************************************
*	MACROS
*************************************************************/
#define streq(a, b) (((a) != NULL) && ((b) != NULL) && (strcmp((a), (b)) == 0))

#define _DRAW_RC_SHADOW(a, b) XmeDrawShadows(XtDisplay(a), XtWindow(a), \
					b->manager.top_shadow_GC, \
					b->manager.bottom_shadow_GC, \
					b->list.RCshadX, b->list.RCshadY, \
					b->list.RCfullWidth, b->list.RCfullHeight, \
					b->manager.shadow_thickness, XmSHADOW_IN);

#define _DRAW_TB_SHADOW(a, b) XmeDrawShadows(XtDisplay(a), XtWindow(a), \
					b->manager.top_shadow_GC, \
					b->manager.bottom_shadow_GC, \
					b->list.TbarX, b->list.TbarY, \
					b->list.TBfullWidth, b->list.TBfullHeight, \
					b->list.title_shadow_thickness, XmSHADOW_IN);



#define _XM_CALC_FULL_TILES_WIDTH( x )	\
{							\
	static int index ;					\
	if (x->list.num_cols > 0)					\
	{	\
		x->list.TBfullTilesWidth = 0;					\
		for (index = 0; index < x->list.num_cols; index++)		\
		{						\
			x->list.TBfullTilesWidth = x->list.TBfullTilesWidth + x->list.tbar_item[index].current_width;		\
		}						\
	}		\
} 


/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/

/*extern Xm18RowInfo *XmI18ListFindRow(Widget, String, int *, Boolean, Boolean);
extern int *XmI18ListGetSelectedRowArray(XmI18ListWidget, int *);
extern void XmI18ListMakeRowVisible(XmI18ListWidget, int);
extern void XmI18ListDeselectRow(XmI18ListWidget, int);
extern void XmI18ListSelectRow(XmI18ListWidget, int, Boolean);
extern void XmI18ListSelectAllItems(XmI18ListWidget, Boolean);
extern void XmI18ListDeselectItems(XmI18ListWidget, XmString, int);
extern void XmI18ListSelectItems(XmI18ListWidget, XmString, int, Boolean);
*/
/************************************************************
*	STATIC FUNCTION DECLARATIONS
*************************************************************/

static Widget CreateScrollbar(Widget, Boolean, ArgList, Cardinal);
static void   LayoutChildren(Widget), ChangeManaged(Widget);

static void ClassInitialize();
static void Initialize(Widget, Widget, ArgList, Cardinal *);
static void Resize(Widget);
static void Destroy(Widget);
static void Redisplay(Widget, XEvent *, Region);
//void StartColSizeChangeCallback(Widget w, XtPointer client_data, XtPointer call_data);

static Boolean SetValues(Widget, Widget, Widget, ArgList, Cardinal *);
static void GetValuesHook(Widget, ArgList, Cardinal *);

static void CreateViewWidget (Widget, ArgList, Cardinal);
static void RecreateViewWidget(Widget, ArgList, Cardinal, char);

static XtGeometryResult GeometryManager(Widget, XtWidgetGeometry *,
					XtWidgetGeometry *);

static XtGeometryResult QueryGeometry(Widget, XtWidgetGeometry *, XtWidgetGeometry *);

static void HighlightDoCallback(Widget, XtPointer, XtPointer);
static void DoubleClickDoCallback(Widget, XtPointer, XtPointer);
static void ResizeRCCallback(Widget, XtPointer, XtPointer);

static void GetValues_XmNselectedPositionCount(Widget w, int n, XtArgVal *value);
static void GetValues_XmNselectedPositions(Widget w, int n, XtArgVal *value);
static void CheckSetRenderTable(Widget wid, int offset, XrmValue *value);

static void DestroyGC(Widget w);
static void InitializeGC(Widget w);
static void CalcTitleBarParam(Widget w, Boolean initCurrentW);
static void CalcTitleBarGeomOverall(Widget w);
static int InternRedisplayTitleBar(Widget w);
static void RefreshHScroll(XmNlListWidget elist, int list_w, Dimension view_w, int value);
static void HScrollCallback(Widget w, XtPointer client_data, XtPointer call_data);
static void LoadTbCellFromColSpec(Widget w, XmNlColSpecRec * csrec, int col_num);

static void ButtonDownAction(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void ButtonMotionAction(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void MouseMotionAction(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void ButtonUpAction(Widget w, XEvent *event, String *params, Cardinal *num_params);

static void _XmSelectColorDefault(Widget widget, int offset, XrmValue *value );

static void GetFillGC(Widget w);
static void GetDrawGC(Widget w);

#ifdef DEBUG
static void ListTbarCellSetPrint(int num, ListTbarCell * in_cell);
#endif
static void CleanTbarCellSet(Widget w);
/************************************************************
*	STATIC DECLARATIONS
*************************************************************/
/* Cursors */

#define horizp_width 19
#define horizp_height 13
static unsigned char horizp_bits[] = {
 0x00, 0x00, 0x00, 0xff, 0x07, 0x00, 0xff, 0x07, 0x00, 0x00, 0x06, 0x00,
 0x00, 0x06, 0x00, 0x20, 0x46, 0x00, 0x30, 0xc6, 0x00, 0x38, 0xc6, 0x01,
 0xfc, 0xff, 0x03, 0x38, 0xc6, 0x01, 0x30, 0xc6, 0x00, 0x20, 0x46, 0x00,
 0x00, 0x06, 0x00 };

#define horizm_width 19
#define horizm_height 13
static unsigned char horizm_bits[] = {
 0xff, 0x0f, 0x00, 0xff, 0x0f, 0x00, 0xff, 0x0f, 0x00, 0xff, 0x0f, 0x00,
 0x60, 0x6f, 0x00, 0x70, 0xef, 0x00, 0x78, 0xef, 0x01, 0xfc, 0xff, 0x03,
 0xfe, 0xff, 0x07, 0xfc, 0xff, 0x03, 0x78, 0xef, 0x01, 0x70, 0xef, 0x00,
 0x60, 0x6f, 0x00 };



static char defaultTranslations[] =
"<Btn1Down>:		     ButtonDown()\n\
<Btn1Motion>:		ButtonMotion()\n\
<MotionNotify>:		MouseMoution()\n\
<Btn1Up>:			ButtonUp()";

static XtActionsRec actionsList[] =
{
	{"ButtonMotion",	ButtonMotionAction},
	{"MouseMoution",	MouseMotionAction},
	{"ButtonDown",		ButtonDownAction},
	{"ButtonUp",		ButtonUpAction},
};

//#define offset(field) XmPartOffset(XmNllist, field)
#define offset(field) XtOffsetOf(XmNlListRec, list.field)
static XmPartResource resources[] = {
	{XmNselectedPositionCount, XmCSelectedPositionCount, XmRInt, sizeof(int),
		offset(SelectedPositionCount), XmRImmediate, (XtPointer) 0},

	{XmNselectedPositions, XmCSelectedPositions, XmRPointer, sizeof(XtPointer),
		offset(SelectedPositions), XmRImmediate, (XtPointer) NULL},

	{XmNViewListType, XmCViewListType, XmRChar, sizeof (char),
		offset(ViewListType), XmRImmediate, (XtPointer) XmNlList_Big},

	{XmNnumCols, XmCNumCols, XmRInt, sizeof(int),
		offset(readonly_num_cols), XmRImmediate, (XtPointer) 0},

	{XmNautoResCol, XmCAutoResCol, XmRInt, sizeof(int),
		offset(autores), XmRImmediate, (XtPointer) XmNlastColumn},

	{"pri.vate", "Pri.vate", XmRBoolean, sizeof(Boolean),
		offset(MouseMoved), XmRImmediate, (XtPointer)False},

	{XmNfontList,	XmCFontList, XmRFontList, sizeof (XmFontList),
		offset(render_table), XmRCallProc, (XtPointer)CheckSetRenderTable},

	{XmNrenderTable, XmCRenderTable, XmRRenderTable, sizeof(XmRenderTable),
		offset(render_table), XmRCallProc, (XtPointer)CheckSetRenderTable},

	{XtNhighlightCount, XmChighlightCount, XmRInt, sizeof(int),
		offset(highlightCount), XmRImmediate, (XtPointer) 0},

	{XtNhighlightCallback, XmCCallback, XmRCallback,sizeof(XtCallbackList),
		offset(highlightCallback), XmRImmediate, (XtPointer) NULL},

	{XmNdoubleClickCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
		offset(double_click), XmRImmediate, (XtPointer) NULL},

	{XmNlTileClickedCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
		offset(tileClick), XmRImmediate, (XtPointer) NULL},

	{XmNlAutoAdjustLastCol, XmCautoAdjustLastCol, XmRBoolean, sizeof(Boolean), 
		offset(adjust_last_column), XmRImmediate, (XtPointer) False},

    {XmNshadowThickness, XmCShadowThickness, XmRHorizontalDimension, sizeof (Dimension),
        XtOffsetOf(XmNlListRec, manager.shadow_thickness), XmRImmediate,  (XtPointer) RESOURCE_DEFAULT},

    {XmNtitleShadowThickness, XmCTitleShadowThickness, XmRHorizontalDimension, sizeof (Dimension),
		offset(title_shadow_thickness), XmRImmediate,  (XtPointer) 1},

	{XmNmarginWidth, XmCMarginWidth, XmRHorizontalDimension, sizeof(Dimension), 
		offset(margin_width), XmRImmediate, (XtPointer) 2},

	{XmNmarginHeight, XmCMarginHeight, XmRVerticalDimension, sizeof(Dimension), 
		offset(margin_height), XmRImmediate, (XtPointer) 2},

	{XmNmarginTitle, XmCMarginTitle, XmRVerticalDimension, sizeof(Dimension), 
		offset(margin_title), XmRImmediate, (XtPointer) 1},

	{XmNpixmapTextPadding, XmCSpace, XmRHorizontalDimension, sizeof(Dimension), 
		offset(pixmapTextPadding), XmRImmediate, (XtPointer) 8},

	{XmNlabelString, XmCXmString, XmRXmString, sizeof(XmString), 
		offset(default_label), XmRImmediate, (XtPointer) NULL},

	{XmNarmColor, XmCArmColor, XmRPixel, sizeof (Pixel),
		offset(arm_color),  XmRCallProc, (XtPointer) _XmSelectColorDefault},

	{XmNlmarkUpPixmap, XmCPixmap, XmRPixmap, sizeof(Pixmap),
		offset(markerUpPixmap), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XmNlmarkUpPixmapMask, XtCPixmap, XtRBitmap, sizeof(Pixmap),
		offset(markerUpMask), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XmNlmarkDownPixmap, XmCPixmap, XmRPixmap, sizeof(Pixmap),
		offset(markerDownPixmap), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XmNlmarkDownPixmapMask, XtCPixmap, XtRBitmap, sizeof(Pixmap),
		offset(markerDownMask), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XmNlMarkedColumnNum, XmCMarkedColumnNum, XmRInt, sizeof(int),
		offset(markedColNumber), XmRImmediate, (XtPointer) 0},

	{XmNlAutoMarkerPlacement, XmCAutoMarkerPlacement, XmRBoolean, sizeof(Boolean), 
		offset(AutoPlacementMarker), XmRImmediate, (XtPointer) False},

	{XmNarrowDirection, XmCArrowDirection, XmRArrowDirection, sizeof(unsigned char), 
		offset(markedStatus), XmRImmediate, (XtPointer) XmARROW_DOWN},
};
#undef offset


static XmSyntheticResource syn_resources[] =
  {
#define offset(field) XtOffsetOf(XmNlListRec, list.field)
	{ 
		XmNtitleShadowThickness, 
		sizeof(Dimension),
		offset(title_shadow_thickness), 
		XmeFromHorizontalPixels, 
		XmeToHorizontalPixels 
	},
	{ 
		XmNmarginWidth, 
		sizeof(Dimension),
		offset(margin_width), 
		XmeFromHorizontalPixels, 
		XmeToHorizontalPixels 
	},
	{ 
		XmNmarginHeight, 
		sizeof(Dimension),
		offset(margin_height),
		XmeFromVerticalPixels, 
		XmeToVerticalPixels 
	},
	{ 
		XmNmarginTitle, 
		sizeof(Dimension),
		offset(margin_title),
		XmeFromVerticalPixels, 
		XmeToVerticalPixels 
	},
	{
		XmNpixmapTextPadding, 
		sizeof(Dimension), 
		offset(pixmapTextPadding),
		XmeFromHorizontalPixels, 
		XmeToHorizontalPixels 
	},
	{
		XmNselectedPositionCount,
		sizeof(int),
		offset(SelectedPositionCount),
		GetValues_XmNselectedPositionCount,
		NULL
	},
	{
		XmNselectedPositions,
		sizeof(XtPointer),
		offset(SelectedPositions),
		GetValues_XmNselectedPositions,
		NULL
	},
#undef offset
  };



XmNlListClassRec xmNlListClassRec = {
	{ /* core fields */
	/* superclass		*/	SUPERCLASS,
		/* class_name		*/		"XmNlList",
		/* widget_size		*/		sizeof(XmNlListPart),
		/* class_initialize		*/	ClassInitialize,
		/* class_part_initialize */	NULL,
		/* class_inited		*/		FALSE,
		/* initialize		*/		Initialize,
		/* initialize_hook		*/	NULL,
		/* realize			*/		XtInheritRealize,
		/* actions			*/      actionsList, /*NULL,*/
		/* num_actions		*/      XtNumber(actionsList), /*(Cardinal)0,*/
		/* resources		*/		(XtResource*) resources,
		/* num_resources		*/	XtNumber(resources),
		/* xrm_class		*/		NULLQUARK,
		/* compress_motion		*/	TRUE,
		/* compress_exposure	*/	TRUE,
		/* compress_enterleave	*/	TRUE,
		/* visible_interest		*/	FALSE,
		/* destroy			*/		Destroy,
		/* resize			*/		Resize,
		/* expose			*/		Redisplay,
		/* set_values		*/		SetValues,
		/* set_values_hook		*/	NULL,
		/* set_values_almost	*/	XtInheritSetValuesAlmost,
		/* get_values_hook		*/	NULL, /*GetValuesHook,*/
		/* accept_focus		*/		NULL,
		/* version			*/		XtVersion,
		/* callback_private		*/	NULL,
		/* tm_table			*/		defaultTranslations, /*XtInheritTranslations,*/
		/* query_geometry		*/	QueryGeometry, /*XtInheritQueryGeometry,*/
		/* display_accelerator	*/	XtInheritDisplayAccelerator,
		/* extension		*/		NULL
	},
	{		/* composite_class fields */
		/* geometry_manager   */      GeometryManager,
		/* change_managed     */      ChangeManaged,
		/* insert_child       */      XtInheritInsertChild,
		/* delete_child       */      XtInheritDeleteChild,
		/* extension          */      NULL,
	},
	{		/* constraint_class fields */
		/* resource list        */         NULL,
		/* num resources        */         0,
		/* constraint size      */         0,
		/* destroy proc         */         NULL,
		/* init proc            */         NULL,
		/* set values proc      */         NULL,
		/* extension            */         NULL,
	},
	{		/* manager_class fields */
		/* default translations   */      XtInheritTranslations,
		/* syn_resources          */      syn_resources,
		/* num_syn_resources      */      XtNumber(syn_resources),
		/* syn_cont_resources     */      NULL,
		/* num_syn_cont_resources */      0,
		/* parent_process         */      NULL,
		/* extension	      */     	NULL,
	},
	{ /* Extended List fields */
		NULL                      /* extension          */
	}
};

WidgetClass xmNlListWidgetClass = (WidgetClass) &xmNlListClassRec;

XmOffsetPtr XmNlList_offsets;
//XmOffsetPtr XmExt18ListC_offsets;

static XtConvertArgRec selfConvertArgs[] = {
    { XtBaseOffset, (XtPointer) 0, sizeof(int) }
};

/************************************************************
*	STATIC CODE
*************************************************************/



/*      Function Name: ClassInitialize
 *      Description:   Initializes class-specific data (offsets)
 *      Arguments:     none
 *      Returns:       nothing
 */
static void
ClassInitialize()
{
    XmResolveAllPartOffsets(xmNlListWidgetClass,
			    &XmNlList_offsets,
			    NULL);

/*	XtSetTypeConverter(XmRString, XmRPointer, AlignmentConverter, 
						NULL, 0, XtCacheNone, NULL);
*/

/*	XtSetTypeConverter(XmRNlString, XmRPointer, AlignmentConverter, 
						NULL, 0, XtCacheNone, NULL);
*/
/*	XtSetTypeConverter(XmRString, XmRAlignmentList, AlignmentConverter, 
						NULL, 0, (XtCacheNone | XtCacheRefCount), AlignmentListDestroy);
*/
/*	XtSetTypeConverter(XmRString, XmRItemLayTable, ItemLayConverter, 
						NULL, 0, (XtCacheNone | XtCacheRefCount), ItemLayDestroy);*/


//	XtSetTypeConverter(XmRString, XmRTileAppearanceTable, TileAppearanceConverter, 
//						selfConvertArgs, XtNumber(selfConvertArgs), (XtCacheNone | XtCacheRefCount), TileAppearanceDestroy);

/*    XmResolveAllPartOffsets(xmNlListWidgetClass,
			    &XmNlList_offsets,
			    NULL);
*/
#ifdef DEBUG
      printf("\n XmNlList Class Initialize Ok\n");
#endif
}


static void
CheckSetRenderTable(Widget wid, int offset, XrmValue *value)
{

	XmNlListWidget elist = (XmNlListWidget) wid;

	if (elist->list.MouseMoved)
		value->addr = NULL;
	else
	{
		value->addr = (char*)&(elist->list.render_table);
		elist->list.MouseMoved = True;
	}
}



/*	Function Name: Initialize
 *	Description:   Called to initialize information specific
 *                     to this widget.
 *	Arguments:     req - what was originally requested.
 *                     set - what will be created (our superclassed have
 *                           already mucked with this)
 *                     args, num_args - The arguments passed to
 *                                      the creation call.
 *	Returns:       none.
 */

/*ARGSUSED*/
static void Initialize(Widget req, Widget set,
		       ArgList args, Cardinal * num_args)
{
/*    ArgList f_args;
    Cardinal f_num_args;*/
    XmNlListWidget elist = (XmNlListWidget) set;
	int i; 
	Pixmap pix, pixMask;
	XColor bg, fg;

#ifdef DEMO
    _XmInitialIzeConverters( req );
#endif

    /*
  * Pass filtered setvalues requests down to all children.
  */

/*	_XmFilterArgs(args, *num_args, xm_std_filter, &f_args, &f_num_args);*/

#ifdef DEBUG
	printf("\n XmNlList Initialize stage 0\n");
#endif


	if (elist->list.render_table == NULL)
	{	
		elist->list.render_table = XmeGetDefaultRenderTable(set, XmLABEL_FONTLIST);
	}

	elist->list.render_table = XmFontListCopy(elist->list.render_table);
  


	if (elist->list.default_label == NULL)   
	{
		elist->list.default_label = XmStringCreateLocalized(DEFAULT_TEXT_IN_TILE);
	}
	else if (XmeStringIsValid(elist->list.default_label))
		{
			elist->list.default_label = XmStringCopy(elist->list.default_label);
		}
		else
		{
//			XmeWarning((Widget) set, CS_STRING_MESSAGE);
			elist->list.default_label = XmStringCreateLocalized(DEFAULT_TEXT_IN_TILE);
		}

	elist->list.item_box = NULL;
	elist->list.rclist = NULL;
	elist->list.tree = NULL;
	elist->list.v_bar = NULL;
	elist->list.h_bar = NULL;

	elist->list.ItemBoxScrollsFound = False;
	elist->list.ResColScrollsFound = False;

	elist->list.autoAdjustedNum = 0;
	elist->list.num_cols = 0;
	elist->list.readonly_num_cols = elist->list.num_cols;
	elist->list.h_shift = 0;

	elist->list.TSize = NULL;
	elist->list.FlSize = NULL;
	elist->list.CurSize = NULL;
	elist->list.TIdealSize = NULL;
	elist->list.tbar_item = NULL;
	elist->list.tbar_item_last = NULL;
	elist->list.TSizeNotSet = True;

	elist->list.incrCol = 0;
	elist->list.decrCol = 0;

	InitializeGC(set);
	
	CalcTitleBarParam(set, True);
	CalcTitleBarGeomOverall(set);
	
#ifdef DEBUG
	printf(".... Title bar view h %d w %d\n", elist->list.TBviewHeight, elist->list.ideal_full_width_title);
	for (i = 0; i < elist->list.num_cols; i++)
	{
		printf("....for %i col tile width = %d\n", i, elist->list.TIdealSize[i]);
	}
#endif

//    elist->list.v_bar = CreateScrollbar(set, True, f_args, f_num_args);
//    elist->list.h_bar = CreateScrollbar(set, False, f_args, f_num_args);
    elist->list.v_bar = CreateScrollbar(set, True, NULL, 0);
    elist->list.h_bar = CreateScrollbar(set, False, NULL, 0);

    elist->list.AuotoResChanged = False;
    elist->list.ListEmpty = True;

	CreateViewWidget(set, NULL, 0);



	if (elist->list.num_cols > 0 && elist->list.rclist)
	{
		int num_col;

		
		XtVaGetValues(elist->list.rclist, XmNnumCols, &num_col, NULL);

		
		if (num_col != elist->list.num_cols)
		{
			XtVaSetValues(elist->list.rclist, XmNpropConsistency, False, NULL);
			elist->list.PropConsistency = False;
			
		}
	}

 	fg.red = ~0;
	fg.green = ~0;
	fg.blue = ~0;
	fg.pixel = WhitePixelOfScreen(XtScreen(set));
	fg.flags = DoRed | DoGreen | DoBlue;
	bg.red = 0;
	bg.green = 0;
	bg.blue = 0;
	bg.pixel = BlackPixelOfScreen(XtScreen(set));
	bg.flags = DoRed | DoGreen | DoBlue;

	pix = XCreatePixmapFromBitmapData(XtDisplay(set), DefaultRootWindow(XtDisplay(set)),
		(char *)horizp_bits, horizp_width, horizp_height, 0, 1, 1);
	pixMask = XCreatePixmapFromBitmapData(XtDisplay(set), DefaultRootWindow(XtDisplay(set)),
		(char *)horizm_bits, horizm_width, horizm_height, 1, 0, 1);
	elist->list.hResizeCursor = XCreatePixmapCursor(XtDisplay(set), pix, pixMask,
		&fg, &bg, 9, 9);
	XFreePixmap(XtDisplay(set), pix);
	XFreePixmap(XtDisplay(set), pixMask);

	elist->list.TbStartResizerPos = -1;
	elist->list.TbLastResizerPos = -1;
	elist->list.TbCurrentResizedPos = -1;
	elist->list.TbResizeState = False;

/*    if (XtWidth(req) == 0)
    {
	XtWidth(set) = 300;
    }

    if (XtHeight(req) == 0)
    {
	XtHeight(set) = 250;
    }
*/
//    XtFree((XtPointer) f_args);
#ifdef DEBUG
	printf("\n XmNlList Initialize Ok %d %d %d %d\n", XtWidth(req), XtHeight(req), XtWidth(set), XtHeight(set));
#endif
}

/*	Function Name: Destroy
 *	Description:   Cleans up after the widget.
 *	Arguments:     w - the widget.
 *	Returns:       none.
 */

static void
Destroy(Widget w)
{
    XmNlListWidget elist = (XmNlListWidget) w;
    ListTbarCell * cell = elist->list.tbar_item;
    int i;

    XmFontListFree(elist->list.render_table);

	if (elist->list.TSize)
		XtFree((char *) elist->list.TSize);
	if (elist->list.FlSize)
		XtFree((char *) elist->list.FlSize);
	if (elist->list.CurSize)
		XtFree((char *) elist->list.CurSize);

	if (elist->list.tbar_item)
		CleanTbarCellSet(w);

	elist->list.tbar_item = NULL;

	DestroyGC(w);
}

/*	Function Name: Resize
 *	Description:   Called when this widget has been resized.
 *	Arguments:     w - Extended List Widget to realize.
 *	Returns:       none.
 */

static void
Resize(Widget w)
{
    XmNlListWidget elist = (XmNlListWidget) w;

    Widget rclist = elist->list.rclist;
    Widget vbar = elist->list.v_bar;
    Widget hbar = elist->list.h_bar;
	Widget item_box = elist->list.item_box;
	Widget tree = elist->list.tree;

    Dimension title_height, h_thick, v_thick, temp_val;
    Position scroll_top, scroll_bottom, scroll_left, scroll_right;

    Dimension height = elist->core.height;
    Dimension width = elist->core.width;

#ifdef DEBUG
	printf("Resize XmNlList started %d %d \n", width, height);
#endif

	LayoutChildren(w);
    if (XtIsRealized (w))
    {
#ifdef DEBUG
		printf("==============Main %d %d\n", XtWidth(w), XtHeight(w));
//		if (XtIsRealized (t_wid))
//			printf("==========Title %d %d\n", XtWidth(t_wid), XtHeight(t_wid));
		
		if (XtIsRealized (rclist))
			printf("==========List %d %d\n", XtWidth(rclist), XtHeight(rclist));
#endif

       XClearArea(XtDisplay(w), XtWindow(w), 0, 0,
            XtWidth(w),XtHeight(w), True);

    }
#ifdef DEBUG
      printf("\n XmNlList Resized Ok\n");
#endif
}



/**************************************************************************
 *
 *  ChangeManaged:
 *      Called by the Intrinsics whenever either of the following happens:
 *           * a managed child becomes unmanaged.
 *           * an unmanaged child becomes managed.
 *
 *************************************************************************/
//static void 
//ChangeManaged(
//        Widget w
//             )
//{
// Dimension gridWidth, gridHeight;
// ExmGridWidgetClass gwc = (ExmGridWidgetClass) XtClass(w);
	
  /* If you get an initial (C) size from the user or application, keep it.  
     Otherwise, just force width and height to 0 so that CalcSize will
     overwrite the appropriate fields. */ 
 //   if (!XtIsRealized(w))  {
	/* The first time, only attempts to change non specified sizes */
//	gridWidth = XtWidth(w) ;   /* might be 0 */
//	gridHeight = XtHeight(w) ; /* might be 0 */
 //   } else {
//	gridWidth = 0 ;
//	gridHeight = 0 ;
 //   }

  /* Determine the ideal size of Grid. */
//    if (gwc->grid_class.calc_size)
//	(*(gwc->grid_class.calc_size))(w, NULL, &gridWidth, &gridHeight); 
//    else 
//	CalcSize (w, NULL, &gridWidth, &gridHeight);

 /* Ask parent of Grid if Grid's new size is acceptable.  Keep asking until
    parent returns either XtGeometryYes or XtGeometryNo. */
 //   while (XtMakeResizeRequest (w, gridWidth, gridHeight,
//   		                &gridWidth, &gridHeight) == XtGeometryAlmost);

    /* Now that we have a size for the Grid, we can layout the children
       of the grid. */ 
//    if (gwc->grid_class.layout)
//	(*(gwc->grid_class.layout))(w, NULL); 
//    else 
//	Layout (w, NULL);
    
    /* Update keyboard traversal */
//    XmeNavigChangeManaged (w);
//}



#define Max(x, y) (((x) > (y)) ? (x) : (y))
#define Min(x, y) (((x) < (y)) ? (x) : (y))
#define SHADOW_TH_LS elist->manager.shadow_thickness
#define SHADOW_TH_TW ((XmPrimitiveWidget)(elist->list.title_bar))->primitive.shadow_thickness

void CalcSize(Widget w, Dimension *TotalWidthListWidget, Dimension *TotalHeightListWidget)
{
    XmNlListWidget elist = (XmNlListWidget) w;
	Dimension maxWidth = MAX_XMNLLIST_STARTED_WIDGET_WIDTH;
	Dimension maxHeight = 4 * V_MARGIN + 3 * elist->manager.shadow_thickness;
	Widget ic;

	Dimension width = 0, height = 0;

	Dimension titleWidth, titleHeight;
	Dimension rescolWidth, rescolHeight;
	Dimension iboxWidth, iboxHeight;

	if (elist->list.ViewListType == XmNlList_Detail || elist->list.ViewListType == XmNlList_TreeCol)
	{
#ifdef DEBUG
		printf("In list mode W = %d H = %d\n", *TotalWidthListWidget, *TotalHeightListWidget);
#endif
		titleWidth = elist->list.ideal_full_width_title;
		width = elist->list.ideal_full_width_title + elist->list.title_shadow_thickness + 10;

		titleHeight = elist->list.TBfullHeight;

		if (elist->list.rclist)
		{
			ic = elist->list.rclist;
			if (XtIsManaged(ic)) 
			{
				rescolWidth = ic->core.width;
				rescolHeight = ic->core.height;

				height = rescolHeight + 3 * V_MARGIN + T_MARGIN + XtHeight(elist->list.h_bar) 
						+ titleHeight + 3 * elist->manager.shadow_thickness;
			}
		}

		if (!*TotalWidthListWidget) 
		{
			*TotalWidthListWidget = Min(width, maxWidth);
		}

		if (!*TotalHeightListWidget) 
		{
			*TotalHeightListWidget = Max(height, maxHeight);
		}
		return ;
	}

	if (elist->list.ViewListType == XmNlList_Big || elist->list.ViewListType == XmNlList_Small)
	{
		if (elist->list.item_box)
		{
			ic = elist->list.item_box;
			if (XtIsManaged(ic)) 
			{
				iboxWidth = ic->core.width;
				iboxHeight = ic->core.height;
				width = iboxWidth + 3 * H_MARGIN + 2 * elist->manager.shadow_thickness +
						XtWidth(elist->list.v_bar);
				height = iboxHeight + 3 * V_MARGIN + XtHeight(elist->list.h_bar) 
						+ 2 * elist->manager.shadow_thickness;
			}
		}
		if (!*TotalWidthListWidget) 
		{
			*TotalWidthListWidget = Max(width, maxWidth);
		}

		if (!*TotalHeightListWidget) 
		{
			*TotalHeightListWidget = Max(height, maxHeight);
		}
		return ;
	}

	if (elist->list.ViewListType == XmNlList_Tree)
	{
		if (elist->list.rclist)
		{
			ic = elist->list.rclist;
			if (XtIsManaged(ic)) 
			{
				iboxWidth = ic->core.width;
				iboxHeight = ic->core.height;
				width = iboxWidth + 3 * H_MARGIN + 2 * elist->manager.shadow_thickness +
						XtWidth(elist->list.v_bar);
				height = iboxHeight + 3 * V_MARGIN + XtHeight(elist->list.h_bar) 
						+ 2 * elist->manager.shadow_thickness;
			}
		}

		if (!*TotalWidthListWidget) 
		{
			*TotalWidthListWidget = Max(width, maxWidth);
		}

		if (!*TotalHeightListWidget) 
		{
			*TotalHeightListWidget = Max(height, maxHeight);
		}
		return ;
	}

}

/*
void CalcSizeBack(Widget w, Dimension *TotalWidthListWidget, Dimension *TotalHeightListWidget)
{
    XmNlListWidget elist = (XmNlListWidget) w;
	Dimension maxWidth = 3 * H_MARGIN;
	Dimension maxHeight = 4 * V_MARGIN + 3 * elist->manager.shadow_thickness;
	Widget ic;

	Dimension width = 0, height = 0;

	Dimension titleWidth, titleHeight;
	Dimension rescolWidth, rescolHeight;
	Dimension iboxWidth, iboxHeight;



	if (elist->list.ViewListType == XmNlList_Detail || elist->list.ViewListType == XmNlList_TreeCol)
	{
		if (elist->list.title_bar)
		{
			ic = elist->list.title_bar;
			if (XtIsManaged(ic)) 
			{
				titleWidth = ic->core.width;
				titleHeight = ic->core.height;
				width = (SHADOW_TH_LS >= SHADOW_TH_TW) ? titleWidth + 2 * (H_MARGIN + SHADOW_TH_LS - SHADOW_TH_TW) + H_MARGIN + XtWidth(elist->list.v_bar) :
							titleWidth + 3 * H_MARGIN + XtWidth(elist->list.v_bar);
			}
		}

		if (elist->list.rclist)
		{
			ic = elist->list.rclist;
			if (XtIsManaged(ic)) 
			{
				rescolWidth = ic->core.width;
				rescolHeight = ic->core.height;

				height = rescolHeight + 3 * V_MARGIN + T_MARGIN + XtHeight(elist->list.h_bar) 
						+ titleHeight + 3 * elist->manager.shadow_thickness;
			}
		}

		if (!*TotalWidthListWidget) 
		{
			*TotalWidthListWidget = Max(width, maxWidth);
		}

		if (!*TotalHeightListWidget) 
		{
			*TotalHeightListWidget = Max(height, maxHeight);
		}
		return ;
	}

	if (elist->list.ViewListType == XmNlList_Big || elist->list.ViewListType == XmNlList_Small)
	{
		if (elist->list.item_box)
		{
			ic = elist->list.item_box;
			if (XtIsManaged(ic)) 
			{
				iboxWidth = ic->core.width;
				iboxHeight = ic->core.height;
				width = iboxWidth + 3 * H_MARGIN + 2 * elist->manager.shadow_thickness +
						XtWidth(elist->list.v_bar);
				height = iboxHeight + 3 * V_MARGIN + XtHeight(elist->list.h_bar) 
						+ 2 * elist->manager.shadow_thickness;
			}
		}
		if (!*TotalWidthListWidget) 
		{
			*TotalWidthListWidget = Max(width, maxWidth);
		}

		if (!*TotalHeightListWidget) 
		{
			*TotalHeightListWidget = Max(height, maxHeight);
		}
		return ;
	}

	if (elist->list.ViewListType == XmNlList_Tree)
	{
		if (elist->list.rclist)
		{
			ic = elist->list.rclist;
			if (XtIsManaged(ic)) 
			{
				iboxWidth = ic->core.width;
				iboxHeight = ic->core.height;
				width = iboxWidth + 3 * H_MARGIN + 2 * elist->manager.shadow_thickness +
						XtWidth(elist->list.v_bar);
				height = iboxHeight + 3 * V_MARGIN + XtHeight(elist->list.h_bar) 
						+ 2 * elist->manager.shadow_thickness;
			}
		}

		if (!*TotalWidthListWidget) 
		{
			*TotalWidthListWidget = Max(width, maxWidth);
		}

		if (!*TotalHeightListWidget) 
		{
			*TotalHeightListWidget = Max(height, maxHeight);
		}
		return ;
	}
}
*/


#undef SHADOW_TH_LS
#undef SHADOW_TH_TW
//#undef Max
#undef Min


/*      Function Name: ChangeManaged
 *      Description:   when a management change has occurred.
 *      Arguments:     w - the XmNlList widget.
 *      Returns:       none.
 */

/* ARGSUSED */
static void
ChangeManaged(Widget w)
{
	Dimension listWidth, listHeight;
    XmNlListWidget elist = (XmNlListWidget) w;
 
    XtGeometryResult answer ;


#ifdef DEBUG
	printf("========== Start ChangedManaged with widget %s\n", XtName(w));
#endif
	if (!XtIsRealized(w))  {
	/* The first time, only attempts to change non specified sizes */
#ifdef DEBUG
		printf("Not realized\n");
#endif
		listWidth = XtWidth(w) ;   /* might be 0 */
		listHeight = XtHeight(w) ; /* might be 0 */
	} 
	else 
	{
		listWidth = 0 ;
		listHeight = 0 ;
    }
#ifdef DEBUG
	printf("ChangedManaged: before calc size %d %d Tbar w %d Tbar ideal full wide %d\n", listWidth, listHeight, elist->list.TBviewWidth, elist->list.ideal_full_width_title);
#endif
	CalcSize(w, &listWidth, &listHeight);

    while ( 1)
   	{
							answer = XtMakeResizeRequest (w, listWidth, listHeight,
   		                &listWidth, &listHeight);
							if (answer == XtGeometryYes) 
								{
									break;
								}
#ifdef DEBUG
							if (answer == XtGeometryAlmost) printf(">>>>>>>> almost %d %d\n", listWidth, listHeight);
#endif
							if (answer == XtGeometryNo) 
							{
								break;
							}
							
	}

	if (elist->list.ViewListType == XmNlList_Detail || elist->list.ViewListType == XmNlList_TreeCol)
		_XM_CALC_FULL_TILES_WIDTH(elist);

	LayoutChildren(w);
	XmeNavigChangeManaged((Widget)w);   /* for Motif navigation */

#ifdef DEBUG
	printf("\n ======= XmNlList ChangeManaged Ok\n");
#endif
}

/*	Function Name: GetValuesHook
 *	Description:   Called to retrieve resource values from either
 *                     the extended list or the interal list
 *      Arguments:     w - the extended list widget.
 *                     args, num_args - the argument list.
 *	Returns:       none
 *
 *      Added:         04/09/92 beth
 */

/*ARGSUSED*/
static void
GetValuesHook(Widget w, ArgList args, Cardinal *num_args)
{
    XmNlListWidget elist = (XmNlListWidget) w;
    register Cardinal i, num=0, j = *num_args;
    Arg i_args[15];

    /*
     * Get the correct args to pass to the widget
     */
}


static void
GetValues_XmNselectedPositionCount(Widget w, int n, XtArgVal *value)
{
    XmNlListWidget elist = (XmNlListWidget) w;

	if ((elist->list.ViewListType == XmNlList_Big || elist->list.ViewListType == XmNlList_Small) && elist->list.item_box)
		XtVaGetValues(elist->list.item_box, XmNselectedPositionCount, &(elist->list.SelectedPositionCount), NULL);

	if ((elist->list.ViewListType == XmNlList_Detail) && elist->list.rclist)
		XtVaGetValues(elist->list.rclist, XmNselectedPositionCount, &(elist->list.SelectedPositionCount), NULL);

	(*value)= (XtArgVal) elist->list.SelectedPositionCount;
}

static void
GetValues_XmNselectedPositions(Widget w, int n, XtArgVal *value)
{
    XmNlListWidget elist = (XmNlListWidget) w;

	if ((elist->list.ViewListType == XmNlList_Big || elist->list.ViewListType == XmNlList_Small) && elist->list.item_box)
		XtVaGetValues(elist->list.item_box, XmNselectedPositions, &(elist->list.SelectedPositions), NULL);

	if ((elist->list.ViewListType == XmNlList_Detail) && elist->list.rclist)
		XtVaGetValues(elist->list.rclist, XmNselectedPositions, &(elist->list.SelectedPositions), NULL);

	(*value)= (XtArgVal) elist->list.SelectedPositions;
}




/*	Function Name: SetValues
 *	Description:   Called when some widget data needs to be modified on-
 *                     the-fly.
 *	Arguments:     current - the current (old) widget values.
 *                     request - before superclassed have changed things.
 *                     set - what will acutally be the new values.
 *                     args, num_args - the arguments in the list.
 *	Returns:       none
 */

/*ARGSUSED*/
static Boolean
SetValues(Widget current, Widget request, Widget set,
	  ArgList args, Cardinal * num_args)
{
	XmNlListWidget e_old = (XmNlListWidget) current;
	XmNlListWidget e_set = (XmNlListWidget) set;
	char lastViewMode;
	ArgList f_args;
	Cardinal f_num_args;
	int i;
	Boolean redisplay = True;
	Boolean RecreateView = False;
	Boolean ChangeColNum = False;
	Boolean ChangeTitleShadow = False;
	Boolean ChangeFont = False;

#ifdef DEBUG
	printf("\n XmNlList SetValues started current %p request %p set %p\n", current, request, set);
#endif

    /*
  * Pass filtered setvalues requests down to all children.
  */

	_XmFilterArgs(args, *num_args, xm_std_filter, &f_args, &f_num_args);


#ifdef DEBUG
    for (i = 0; i < *num_args; i++)
    {
		String name = args[i].name;

		printf("SetValue XmNlList: %s\n", name);

		if (streq(XtNhighlightCallback, name))
		{
			printf("\n XmNlList SetValues: XtNhighlightCallback added\n");
		}

		if (streq(XmNdoubleClickCallback, name))
		{
			printf("\n XmNlList SetValues: XmNdoubleClickCallback added\n");
		}

		if (streq(XmNrenderTable, name))
		{
			printf("\n XmNlList SetValues: RenderTable added\n");
		}

		if (streq(XmNfontList, name))
		{
			printf("\n XmNlList SetValues: FontList added\n");
		}
	}
#endif
	
#ifdef DEBUG
	printf("\n XmNlList SetValues:  XmNlViewListType checked\n");
#endif


	if (e_old->list.ViewListType != e_set->list.ViewListType)
	{
			RecreateView = True;
//			CleanTbarCellSet(current);
//			e_set->list.num_cols = 0;
//			e_set->list.tbar_item = NULL;
			lastViewMode = e_old->list.ViewListType;
	//	    redisplay = True;
	}

	if (e_old->list.title_shadow_thickness != e_set->list.title_shadow_thickness)
	{
		ChangeTitleShadow = True;
	}

	if (e_set->list.render_table != e_old->list.render_table)
	{
#ifdef DEBUG
		printf("\n XmNlList SetValues: change font\n");
#endif
		ChangeFont = True;
		redisplay = True;
		if (e_set->list.render_table == NULL)
		{	
#ifdef DEBUG
			printf("\n XmNlList SetValues: new font is NULL\n");
#endif
			e_set->list.render_table = XmeGetDefaultRenderTable(set, XmLABEL_FONTLIST);
		}
		e_set->list.render_table = XmFontListCopy(e_set->list.render_table);
#ifdef DEBUG
		printf("\n XmNlList SetValues: copyed font\n");
#endif
	}

    if (ChangeFont && e_old->list.render_table) 
		XmFontListFree(e_old->list.render_table); 
	
	if (e_set->list.arm_color != e_old->list.arm_color)
	{
		XFreeGC(XtDisplay(set), e_set->list.fill_gc);
		GetFillGC(set);
		redisplay = True;
	}

	if (e_set->list.markedColNumber != e_old->list.markedColNumber)
	{
		if (e_set->list.tbar_item && e_set->list.markedColNumber < e_set->list.num_cols 
			&& e_old->list.markedColNumber < e_set->list.num_cols)
		{
			e_set->list.tbar_item[e_old->list.markedColNumber].markedStatus = XmARROW_LEFT;
			e_set->list.tbar_item[e_set->list.markedColNumber].markedStatus = e_set->list.markedStatus;
		}
	}

	if ((e_set->core.background_pixel != e_old->core.background_pixel) || (e_set->manager.foreground != e_old->manager.foreground))
	{
		XFreeGC(XtDisplay(set), e_set->list.drawGC);
		GetDrawGC(set);
		redisplay = True;
	}

	if (RecreateView)
	{
		e_set->list.AuotoResChanged = False;
//		e_set->list.ListEmpty = True;
/*		if (!ChangeColNum)
		{
			if (f_num_args < *num_args)
			{
				XtSetArg(f_args[f_num_args], XmNnumCols, e_set->list.num_cols); f_num_args++;
			}
			else
			{
				f_args = (ArgList) XtRealloc(f_args, sizeof(Arg) * (f_num_args + 1));
				XtSetArg(f_args[f_num_args], XmNnumCols, e_set->list.num_cols); f_num_args++;
			}
		}*/
		RecreateViewWidget (set, NULL, 0, lastViewMode);

		redisplay = True;

		if (XtIsRealized (set))
		{
			XClearArea(XtDisplay(set), XtWindow(set), 0, 0,
						XtWidth(set), XtHeight(set), True);
		}
	}


	if (e_set->list.num_cols > 0 && e_set->list.rclist)
	{
		int num_col;
		
		XtVaGetValues(e_set->list.rclist, XmNnumCols, &num_col, NULL);

		
		if (num_col != e_set->list.num_cols)
		{
			XtVaSetValues(e_set->list.rclist, XmNpropConsistency, False, NULL);
			e_set->list.PropConsistency = False;
			
		}
	}

/*	if (e_set->list.SelectedPositionCount != e_old->list.SelectedPositionCount)
	{
		if ((e_set->list.ViewListType == XmNlList_Big || e_set->list.ViewListType == XmNlList_Small) && e_set->list.item_box)
		{
			XtVaSetValues(e_set->list.item_box, XmNselectedPositionCount, e_set->list.SelectedPositionCount, XmNselectedPositions, e_set->list.SelectedPositions, NULL);
		}
		else
		{
			if (e_set->list.rclist)
			XtVaSetValues(e_set->list.rclist, XmNselectedPositionCount, e_set->list.SelectedPositionCount, XmNselectedPositions, e_set->list.SelectedPositions, NULL);
			
		}
	}
*/
	if ((e_set->list.ViewListType == XmNlList_Big || e_set->list.ViewListType == XmNlList_Small) && e_set->list.item_box)
	{
		XtSetValues(e_set->list.item_box, f_args, f_num_args);
	}
	else
	{
		if (e_set->list.rclist)
			XtSetValues(e_set->list.rclist, f_args, f_num_args);
	}

	CalcTitleBarParam(set, False);
	CalcTitleBarGeomOverall(set);
    LayoutChildren(set);

	if (XtIsRealized(set) && (e_set->list.ViewListType == XmNlList_Detail || e_set->list.ViewListType == XmNlList_TreeCol))
		XClearArea(XtDisplay(set), XtWindow(set), 0, 0,
				XtWidth(set), XtHeight(set), True);

/*
	if ((e_set->list.ViewListType == XmNlList_Big || e_set->list.ViewListType == XmNlList_Small) && e_set->list.item_box)
	{
		XtSetValues(e_set->list.item_box, f_args, f_num_args);
	}
	else
	{
		if (e_set->list.rclist)
			XtSetValues(e_set->list.rclist, f_args, f_num_args);
	}
*/
	if (f_args)
		XtFree((XtPointer) f_args);

#ifdef DEBUG
      printf("\n XmNlList SetValues Ok\n");
#endif

    return(redisplay);
}


/*	Function Name: GeometryManager
 *	Description:   handles requests from children for a size change.
 *	Arguments:     child - the child to change.
 *                     request - the geometry that the child wants.
 *                     return - what we will allow if this is an almost.
 *	Returns:       status.
 *
 * This function will allow any width or height request on the label,
 * find button, or frame.  Any other widget will have its request
 * disallowed.
 */

/*ARGSUSED*/
static XtGeometryResult
GeometryManager(Widget w, XtWidgetGeometry * request,
		XtWidgetGeometry * result)
{
    XmNlListWidget	elist = (XmNlListWidget) XtParent(w);
    XtGeometryResult answer; 
    
    /*= XtGeometryYes;*/
    Dimension max_height, max_width, curHeight, curWidth;

#ifdef DEBUG
      printf("\n +++++++++++++++++\n++++++++++++++++++\nXmNlList GeometryManager started\n");
#endif

	if (!(request->request_mode & (CWWidth | CWHeight | CWBorderWidth)))
		return(XtGeometryNo);

//	if (w != elist->list.title_bar)
//		return(XtGeometryNo);

	result->request_mode = request->request_mode;
	result->width = request->width;
	result->height = request->height;
	result->border_width = request->border_width;


	max_height = elist->core.height - 60 - 4 * V_MARGIN - XtHeight(elist->list.h_bar) - 3 * elist->manager.shadow_thickness;
	max_width = elist->core.width - 3 * H_MARGIN - XtWidth(elist->list.v_bar);

	if ((request->request_mode & CWWidth) || (request->request_mode & CWHeight))
	{
		Widget parent = XtParent(w);
		XtWidgetGeometry ext_request, ext_reply;

#ifdef DEBUG
		if (request->request_mode & CWWidth)
			printf("Request width\n");

		if (request->request_mode & CWHeight)
			printf("Request height\n");

		if (w == elist->list.rclist)
			printf("+++++++++++++++++++++++++++\n Request from RClist %d %d\n", request->width, request->height);

		if (w == elist->list.v_bar)
			printf("+++++++++++++++++++++++++++\n Request from V Scroll %d %d\n", request->width, request->height);

		if (w == elist->list.h_bar)
			printf("+++++++++++++++++++++++++++\n Request from H Scroll %d %d\n", request->width, request->height);
#endif

		ext_request.request_mode = 0;
		ext_request.width = elist->core.width;
		ext_request.height = elist->core.height;

		if (request->request_mode & CWWidth)
		{
			if (request->width > max_width)
			{
				ext_request.request_mode |= CWWidth;
				ext_request.width = request->width + 3 * H_MARGIN + XtWidth(elist->list.v_bar);
			}
			else
			{
				answer = XtGeometryYes;
				result->width = request->width;
				result->request_mode |= CWWidth;
			}
		}

		if (request->request_mode & CWHeight)
		{
			if (request->height > max_height)
			{
				ext_request.request_mode |= CWHeight;
				ext_request.height = request->height + 60 + 4 * V_MARGIN + XtHeight(elist->list.h_bar) + 3 * elist->manager.shadow_thickness;
			}
			else
			{
				answer = XtGeometryYes;
				result->height = request->height;
				result->request_mode |= CWHeight;
			}
		}

		if (request->width > max_width || request->height > max_height)
		{ 
			answer = XtMakeGeometryRequest(parent, &ext_request, &ext_reply);

			if (answer == XtGeometryYes)
			{
				if (request->request_mode & CWHeight)
				{
//					elist->core.height = ext_request.height;
//					result->height = elist->core.height - 60 - 4 * V_MARGIN - XtHeight(elist->list.h_bar) - 3 * elist->manager.shadow_thickness;
					result->height = request->height;
				}
				if (request->request_mode & CWWidth)
				{
					result->width = elist->core.width - 3 * H_MARGIN - XtWidth(elist->list.v_bar);
//					elist->core.width = ext_request.width;
				}
			}
			else if (answer == XtGeometryAlmost)
			{
				answer = XtGeometryNo;

/*				if (request->request_mode & CWHeight)
				elist->core.height = ext_reply.height;
				if (request->request_mode & CWWidth)
				elist->core.width = ext_reply.width;*/
			}
		}

   }

	if (answer == XtGeometryYes)
	{
		w->core.width = result->width;
		w->core.height = result->height;
		LayoutChildren((Widget) elist);
	}



#ifdef DEBUG
      printf("\n XmNlList GeometryManager ok\n");
#endif

    return(answer);
}


static XtGeometryResult
QueryGeometry(
        Widget widget,
        XtWidgetGeometry *request,
        XtWidgetGeometry *reply )
{
    /* deal with user initial size setting */


	if (!XtIsRealized(widget))
	{
		reply->width = XtWidth(widget) ;    /* might be 0 */
		reply->height = XtHeight(widget) ;  /* might be 0 */
	}
	else
	{
	/* always computes natural size afterwards */
		if (!(request->request_mode & (CWWidth | CWHeight | CWBorderWidth)))
			return(XtGeometryNo);

		if (request->request_mode & (CWWidth | CWHeight))
		{
			if (request->width < 100 || request->height < 80)
			{
				reply->request_mode = CWWidth | CWHeight;
				reply->width = 400;
				reply->height = 300;
//				return(XtGeometryAlmost);
			}
			else 
			{
				reply->request_mode = CWWidth | CWHeight;
				reply->width = request->width;
				reply->height = request->height;
//				return(XtGeometryAlmost);
			}
//			else return (XtGeometryYes);
		}
	}

//    GetSize (widget, &desired->width, &desired->height);

    /* this function will set CWidth and CHeight */
    return XmeReplyToQueryGeometry(widget, request, reply) ;
}

static void CheckRenderOrder(XmNlListWidget elist);

/************************************************************
 *
 * Actions and Callbacks (More entry points into the widget code).
 *
 ************************************************************/

/*ARGSUSED*/

#define SHADOW_TH_LS elist->manager.shadow_thickness
//#define SHADOW_TH_TW ((XmPrimitiveWidget)(t_wid))->primitive.shadow_thickness
#define SHADOW_TH_TW (elist->list.title_shadow_thickness)


static void
Redisplay(Widget w, XEvent * event, Region region)
{
    Arg args[1];
    XmNlListWidget elist = (XmNlListWidget) w;

    Widget rclist = elist->list.rclist;
    Widget vbar = elist->list.v_bar;
    Widget hbar = elist->list.h_bar;
	Widget item_box = elist->list.item_box;
	Widget tree = elist->list.tree;

    Dimension title_height, h_thick, v_thick, temp_val, rc_height;
    Position scroll_top, scroll_bottom, scroll_left, scroll_right, rc_y;

    Dimension height = elist->core.height;
    Dimension width = elist->core.width;

	int rcMargin, twMargin;

#ifdef DEBUG
      printf("\n =+=+=+=+=+=+=+=+=+=+=+=+ XmNlList Redisplay started type %d\n", event->type);
#endif
    v_thick = vbar->core.width + 2 * vbar->core.border_width;
    h_thick = hbar->core.height + 2 * vbar->core.border_width;
    scroll_top =  V_MARGIN;
    scroll_bottom = height - V_MARGIN - h_thick;
    scroll_left = width - H_MARGIN - v_thick;
    scroll_right = width - H_MARGIN;
#ifdef DEBUG
      printf("\n XmNlList LayoutChildren calc ok\n");
#endif

	CheckRenderOrder(elist);


	CalcTitleBarGeomOverall(w);

//	if ((elist->list.ViewListType == XmNlList_Detail || elist->list.ViewListType == XmNlList_TreeCol) && rclist && t_wid)
	if ((elist->list.ViewListType == XmNlList_Detail || elist->list.ViewListType == XmNlList_TreeCol) && rclist)
	{
#ifdef DEBUG
      printf("\n XmNlList Redisplay table draw\n");
#endif
		rcMargin = (SHADOW_TH_LS >= SHADOW_TH_TW) ? H_MARGIN : H_MARGIN + SHADOW_TH_TW - SHADOW_TH_LS;
		rc_y = V_MARGIN + elist->list.TBfullHeight + T_MARGIN;
		rc_height = height - 3*V_MARGIN - T_MARGIN - hbar->core.height - elist->list.TBfullHeight;
		
		_DRAW_RC_SHADOW(w, elist);
		rcMargin = (SHADOW_TH_LS >= SHADOW_TH_TW) ? H_MARGIN + SHADOW_TH_LS - SHADOW_TH_TW: H_MARGIN + SHADOW_TH_TW - SHADOW_TH_LS;

/*		if (elist->list.render_order == LtoR_render)
			XmeDrawShadows(XtDisplay (w), XtWindow (w),
					elist->manager.top_shadow_GC,
					elist->manager.bottom_shadow_GC,
					rcMargin, 
					V_MARGIN,
					width - H_MARGIN - vbar->core.width - 2*rcMargin,
//					height - 3*V_MARGIN - T_MARGIN - hbar->core.height - t_wid->core.height,
//					height - 3*V_MARGIN - T_MARGIN - hbar->core.height - elist->list.TBfullHeight,
					elist->list.TBfullHeight,
					elist->list.title_shadow_thickness,
					XmSHADOW_IN);
		else
			XmeDrawShadows(XtDisplay (w), XtWindow (w),
					elist->manager.top_shadow_GC,
					elist->manager.bottom_shadow_GC,
					H_MARGIN + vbar->core.width + rcMargin, 
					V_MARGIN,
					width - H_MARGIN - vbar->core.width - 2*rcMargin,
//					height - 3*V_MARGIN - T_MARGIN - hbar->core.height - t_wid->core.height,
					elist->list.TBfullHeight,
					elist->list.title_shadow_thickness,
					XmSHADOW_IN);
*/
		_DRAW_TB_SHADOW(w, elist);


		InternRedisplayTitleBar(w);

	}

/*	if (elist->list.ViewListType == XmNlList_TreeCol && rclist!=NULL)
	{
	XmeDrawShadows (XtDisplay (w), XtWindow (w),
                elist->manager.top_shadow_GC,
                elist->manager.bottom_shadow_GC,
				H_MARGIN, 2*V_MARGIN + t_wid->core.height,
    			width - 3*H_MARGIN - vbar->core.width,
    			height - 4*V_MARGIN - hbar->core.height - t_wid->core.height,
				elist->manager.shadow_thickness,
				XmSHADOW_IN);
	}
*/

	if (elist->list.ViewListType == XmNlList_Tree && rclist)
	{
		if (elist->list.render_order == LtoR_render)
			XmeDrawShadows (XtDisplay (w), XtWindow (w),
						elist->manager.top_shadow_GC,
						elist->manager.bottom_shadow_GC,
						(Position) H_MARGIN, (Position) V_MARGIN,
						width - 3*H_MARGIN - vbar->core.width,
						height - 3*V_MARGIN - hbar->core.height,
						elist->manager.shadow_thickness,
						XmSHADOW_IN);
		else
			XmeDrawShadows (XtDisplay (w), XtWindow (w),
						elist->manager.top_shadow_GC,
						elist->manager.bottom_shadow_GC,
						(Position) (2*H_MARGIN + vbar->core.width), (Position) V_MARGIN,
						width - 3*H_MARGIN - vbar->core.width,
						height - 3*V_MARGIN - hbar->core.height,
						elist->manager.shadow_thickness,
						XmSHADOW_IN);
	}


	if ((elist->list.ViewListType == XmNlList_Big || elist->list.ViewListType == XmNlList_Small) && item_box!=NULL)
	{
		if (elist->list.render_order == LtoR_render)
			XmeDrawShadows (XtDisplay (w), XtWindow (w),
						elist->manager.top_shadow_GC,
						elist->manager.bottom_shadow_GC,
						(Position) H_MARGIN, (Position) V_MARGIN,
						width - 3*H_MARGIN - vbar->core.width,
						height - 3*V_MARGIN - hbar->core.height,
						elist->manager.shadow_thickness,
						XmSHADOW_IN);
		else
			XmeDrawShadows (XtDisplay (w), XtWindow (w),
						elist->manager.top_shadow_GC,
						elist->manager.bottom_shadow_GC,
						(Position) (2*H_MARGIN + vbar->core.width), (Position) V_MARGIN,
						width - 3*H_MARGIN - vbar->core.width,
						height - 3*V_MARGIN - hbar->core.height,
						elist->manager.shadow_thickness,
						XmSHADOW_IN);

/*	XmeDrawShadows (XtDisplay (w), XtWindow (w),
                elist->manager.top_shadow_GC,
                elist->manager.bottom_shadow_GC,
				(Position) H_MARGIN, (Position) V_MARGIN,
    			scroll_left - 2*H_MARGIN, height-2*V_MARGIN-h_thick,
				2,
				XmSHADOW_IN);
	*/
#ifdef DEBUG
      printf("\n XmNlList LayoutChildren: item_box configured\n");
#endif

	}

#ifdef DEBUG
      printf("\n XmNlList LayoutChildren ok\n");
#endif
}






#undef SHADOW_TH_LS
#undef SHADOW_TH_TW

/************************************************************
*	LOCAL CODE
*************************************************************/


static void
DestroyGC(Widget w)
{
	XFreeGC(XtDisplay(w), ((XmNlListWidget) w)->list.drawGC);
}

static void 
GetFillGC(Widget w)
{
	XmNlListWidget elist = (XmNlListWidget) w;
	XGCValues values;
	XtGCMask  valueMask;
  
	valueMask = GCForeground | GCBackground | GCFillStyle;
  
	values.foreground = elist->list.arm_color;
	values.background = elist->core.background_pixel;
	values.fill_style = FillSolid;
  
	elist->list.fill_gc = XCreateGC(XtDisplay(w), XRootWindowOfScreen(XtScreen(w)), valueMask, &values);
}

static void
GetDrawGC(Widget w)
{
	XGCValues values;
	unsigned long mask;
	XmNlListWidget elist = (XmNlListWidget) w;

	values.line_style = LineSolid;
	values.line_width = 1;
	values.fill_style = FillSolid;
	values.background = ((XmManagerWidget)w)->core.background_pixel;
	values.foreground = ((XmManagerWidget)w)->manager.foreground;

	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground;
	elist->list.drawGC = XCreateGC(XtDisplay(w), XRootWindowOfScreen(XtScreen(w)), mask, &values);
}

static void
InitializeGC(Widget w)
{
	XGCValues values;
	unsigned long mask;
	XmNlListWidget elist = (XmNlListWidget) w;

	values.line_style = LineSolid;
	values.line_width = 1;
	values.fill_style = FillSolid;
	values.background = ((XmManagerWidget)w)->core.background_pixel;
	values.foreground = ((XmManagerWidget)w)->manager.foreground;

	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground;
	elist->list.drawGC = XCreateGC(XtDisplay(w), XRootWindowOfScreen(XtScreen(w)), mask, &values);


	mask = GCForeground | GCBackground | GCFillStyle;
  
	values.foreground = elist->list.arm_color;
	values.background = elist->core.background_pixel;
	values.fill_style = FillSolid;
  
	elist->list.fill_gc = XCreateGC(XtDisplay(w), XRootWindowOfScreen(XtScreen(w)), mask, &values);

}



static void _XmSelectColorDefault(Widget widget, int offset, XrmValue *value)
{
	XmeGetDefaultPixel (widget, XmSELECT, offset, value);
}



#define SHADOW_TH_LS (elist->manager.shadow_thickness)
#define SHADOW_TH_TW (elist->list.title_shadow_thickness)

static void CalcTitleBarGeomOverall(Widget w)
{
	XmNlListWidget elist = (XmNlListWidget) w;
	int rcMargin;
    Widget vbar = elist->list.v_bar;
    Widget hbar = elist->list.h_bar;
    Dimension width = elist->core.width;
	
	
	rcMargin = (SHADOW_TH_LS >= SHADOW_TH_TW) ? H_MARGIN + SHADOW_TH_LS - SHADOW_TH_TW: H_MARGIN + SHADOW_TH_TW - SHADOW_TH_LS;

	elist->list.TBviewHeight = elist->list.TBfullHeight - 2 * SHADOW_TH_TW;
	if (vbar) 
		elist->list.TBviewWidth = width - H_MARGIN - vbar->core.width - 2*rcMargin - 2 * SHADOW_TH_TW;
	else
		elist->list.TBviewWidth = 0;
		
	elist->list.TBviewY = V_MARGIN + SHADOW_TH_TW;

	if (!vbar)
	{
		elist->list.TBviewX = 0;
		return ;
	} 
	
	if (elist->list.render_order == LtoR_render)
		elist->list.TBviewX = rcMargin + SHADOW_TH_TW;
	else
		elist->list.TBviewX = H_MARGIN + vbar->core.width + rcMargin + SHADOW_TH_TW;
}


#undef SHADOW_TH_LS
#undef SHADOW_TH_TW


/*********************************************************
* If need init current column width from ideal width 
* set initCurrentW to TRUE
*********************************************************/ 

static void CalcTitleBarParam(Widget w, Boolean initCurrentW)
{
	XmNlListWidget elist = (XmNlListWidget) w;
	unsigned int width_s, width_i, height_s, height_i, bw, depth;
	int x, y;
	int i, x_accum = 0;
	int max_icon_width = 0, max_icon_height = 0;
	int max_string_width = 0, max_string_height = 0;
	int max_title_height = 0, title_ideal_width = 0, title_current_width = 0;
	int spc;
	Window root;
	ListTbarCell * cell;


	spc = 2 * (elist->manager.shadow_thickness - elist->list.title_shadow_thickness);


	if (elist->list.num_cols == 0)
	{
		width_s = XmStringWidth(elist->list.render_table, elist->list.default_label);
		height_s = XmStringHeight(elist->list.render_table, elist->list.default_label);

		max_title_height = height_s + 2 * elist->list.margin_height;
		max_title_height = max_title_height + 4 * elist->list.title_shadow_thickness;

#ifdef DEBUG
		printf("max_title_height %d - %d\n", max_title_height, height_s);
#endif

		elist->list.TBfullHeight = max_title_height;
		return ;
	}

	for (i = 0; i < elist->list.num_cols; i++)
	{
		cell = elist->list.tbar_item + i;

/** Calcing geom parameters **/

		width_s =0;
		width_i = 0;
		height_i = 0;
		height_s = 0;
		
		if (cell->xmlabel && (cell->info_type == XmSTRING || cell->info_type == XmPIXMAP_AND_STRING))
		{
			width_s = XmStringWidth(elist->list.render_table, cell->xmlabel);
			height_s = XmStringHeight(elist->list.render_table, cell->xmlabel);
		}
		
		if (cell->pixmap != XmUNSPECIFIED_PIXMAP && (cell->info_type == XmPIXMAP || cell->info_type == XmPIXMAP_AND_STRING))
		{
			XGetGeometry(XtDisplay(w), cell->pixmap,
				 &root, &x, &y, &width_i, &height_i, &bw, &depth);
		}

		if (cell->mask != XmUNSPECIFIED_PIXMAP && (cell->info_type == XmPIXMAP || cell->info_type == XmPIXMAP_AND_STRING))
		{
			XGetGeometry(XtDisplay(w), cell->mask,
				 &root, &x, &y, &width_i, &height_i, &bw, &depth);
		}
		
		if (elist->list.AutoPlacementMarker && cell->info_type == XmPIXMAP_AND_STRING && 
			(cell->markedStatus == XmARROW_UP || cell->markedStatus == XmARROW_DOWN))
		{
			if (height_i == 0)
				height_i = height_s - height_s / 5;

			if (width_i == 0)
				width_i = height_i;
		}

		if (max_title_height < ((Max(height_s, height_i)) + 2 * cell->marginH))
			max_title_height = (Max(height_s, height_i) + 2 * cell->marginH);
			
		if (cell->info_type == XmPIXMAP)
			elist->list.TIdealSize[i] = width_i + 2 * cell->marginW + 2 * elist->list.title_shadow_thickness;

		if (cell->info_type == XmSTRING)
			elist->list.TIdealSize[i] = width_s + 2 * cell->marginW + 2 * elist->list.title_shadow_thickness;

		if (cell->info_type == XmPIXMAP_AND_STRING)
			elist->list.TIdealSize[i] = width_i + width_s + cell->padding + 2 * cell->marginW + 2 * elist->list.title_shadow_thickness;
			
		title_ideal_width = title_ideal_width + elist->list.TIdealSize[i];

		cell->pix_w = width_i;
		cell->pix_h = height_i;
		cell->label_w = width_s;
		cell->label_h = height_s;
		cell->real_width = elist->list.TIdealSize[i];
		if (initCurrentW || cell->current_width == 0) 
		{
			cell->current_width = elist->list.TIdealSize[i];
			cell->x = x_accum;
			x_accum = x_accum + cell->current_width;
		}

		title_current_width = title_current_width + cell->current_width;
//		title_width = title_width + elist->list.TIdealSize[i];


//		cell->resizible;
//		cell->autoresize;
//		cell->align_type;
//		cell->displayed;
//		cell->alignment;
//		cell->priority;
//		cell->x;
	}

	max_title_height = max_title_height + 4 * elist->list.title_shadow_thickness;


	elist->list.ideal_full_width_title = title_ideal_width;

	elist->list.TBfullHeight = max_title_height;
	
	elist->list.TBfullTilesWidth = title_current_width;

	return ;
}




#ifdef DEBUG
static void ListTbarCellSetPrint(int num, ListTbarCell * in_cell)
{
	ListTbarCell * cell;
	int i;
	
	if (num <= 0 || !in_cell)
		return ;
		
	printf("__________TBARCELL %i\n", num);
		
	for (i = 0; i < num; i++)
	{
		cell = in_cell + i;
			
		printf("__________background for %i is %ld\n", i, cell->background);
		printf("__________foreground for %i is %ld\n", i, cell->foreground);

		printf("__________icon for %i is %ld\n", i, cell->pixmap);
		printf("__________iconMask for %i is %ld\n", i, cell->mask);
		printf("__________xmlabel for %i is %p\n", i, cell->xmlabel);

		switch (cell->align_type) {
			case XmALIGNMENT_BEGINNING :
				printf("__________alignment for %i is BEGIN\n", i);
				break ;
			case XmALIGNMENT_CENTER :
				printf("__________alignment for %i is CENTER\n", i);
				break ;
			case XmALIGNMENT_END :
				printf("__________alignment for %i is END\n", i);
				break ;
			default:
				break ;
		}
		switch (cell->info_type) {
			case XmSTRING :
				printf("__________type for %i is STRING\n", i);
				break ;
			case XmPIXMAP_AND_STRING :
				printf("__________type for %i is PIXMAP_AND_STRING\n", i);
				break ;
			case XmPIXMAP :
				printf("__________type for %i is PIXMAP\n", i);
				break ;
			default:
				printf("__________type for %i is not defined %hhu\n", i, cell->info_type);
				break ;
		}
		switch (cell->priority) {
			case XmPIXMAP :
				printf("__________pixmap first for %i\n", i);
				break ;
			case XmSTRING :
				printf("__________string first for %i\n", i);
				break ;
			default:
				break ;
			}
			printf("__________padding for %i is %d\n", i, cell->padding);
			printf("__________mH for %i is %d\n", i, cell->marginH);
			printf("__________mW for %i is %d\n", i, cell->marginW);
			
		}
	return ;	
}
#endif

static void CleanTbarCellSet(Widget w)
{
	XmNlListWidget elist = (XmNlListWidget) w;
	ListTbarCell * cell = elist->list.tbar_item;
	int i;
	
	if (!cell)
		return ;
	for (i = 0; i < elist->list.num_cols; i++)
	{
		cell = elist->list.tbar_item + i;
		
		if (cell->xmlabel)
		{
			XmStringFree(cell->xmlabel);
		}
	}	
		
	XtFree((char *) elist->list.tbar_item);	
	if (elist->list.tbar_item_last)
		XtFree((char *) elist->list.tbar_item_last);
}


static void LoadTbCellSetFromColSpecTable(Widget w, XmNlColSpecRec * csrec)
{
	XmNlListWidget elist = (XmNlListWidget) w;
	ListTbarCell * cell = elist->list.tbar_item;
	
	if (!cell)
		return ;
	

	cell = elist->list.tbar_item + elist->list.num_cols - 1;
		
	cell->pixmap = csrec->icon;
	cell->mask = csrec->iconMask;

	if (csrec->typeTb == XmSTRING || csrec->typeTb == XmPIXMAP_AND_STRING)
	{
		if (csrec->xmstringTb == NULL)
		{
			cell->xmlabel = XmStringCreateLocalized(DEFAULT_TEXT_IN_TILE);
		}
		else if (XmeStringIsValid(csrec->xmstringTb))
			{
				cell->xmlabel = XmStringCopy(csrec->xmstringTb);
			}
				else
				{
					XmeWarning(w, "XmNlList: invalid string\n");
					cell->xmlabel = XmStringCreateLocalized(DEFAULT_TEXT_IN_TILE);
				}
	}
	else
	{
		cell->xmlabel = NULL;
	}

	cell->column_type = csrec->typeCol;


	if (csrec->backgroundTb == XmUNSPECIFIED_PIXEL)
		cell->background = ((XmManagerWidget)w)->core.background_pixel;
	else
		cell->background = csrec->backgroundTb;

	if (csrec->foregroundTb == XmUNSPECIFIED_PIXEL)
		cell->foreground = ((XmManagerWidget)w)->manager.foreground;
	else
		cell->foreground = csrec->foregroundTb;

	cell->marginW = elist->list.margin_width;
	cell->marginH = elist->list.margin_height;
	cell->padding = elist->list.pixmapTextPadding;
	if (csrec->pixmapPlacementTb == XmPIXMAP_LEFT)
		cell->priority = XmPIXMAP;
	else
		cell->priority = XmSTRING;
	cell->info_type = csrec->typeTb;
	cell->align_type = csrec->alignmentTb;
	cell->armed = False;
}

static void LoadTbCellFromColSpec(Widget w, XmNlColSpecRec * csrec, int col_num)
{
	XmNlListWidget elist = (XmNlListWidget) w;
	ListTbarCell * cell = elist->list.tbar_item;
	
	if (!cell)
		return ;
	

	if (col_num >= elist->list.num_cols)
		return ;

	cell = elist->list.tbar_item + col_num;
		
	cell->pixmap = csrec->icon;
	cell->mask = csrec->iconMask;

	if (csrec->typeTb == XmSTRING || csrec->typeTb == XmPIXMAP_AND_STRING)
	{
		if (csrec->xmstringTb == NULL)
		{
			cell->xmlabel = XmStringCreateLocalized(DEFAULT_TEXT_IN_TILE);
		}
		else if (XmeStringIsValid(csrec->xmstringTb))
			{
				cell->xmlabel = XmStringCopy(csrec->xmstringTb);
			}
				else
				{
					XmeWarning(w, "XmNlList: invalid string\n");
					cell->xmlabel = XmStringCreateLocalized(DEFAULT_TEXT_IN_TILE);
				}
	}
	else
	{
		cell->xmlabel = NULL;
	}

	cell->column_type = csrec->typeCol;

	if (csrec->backgroundTb == XmUNSPECIFIED_PIXEL)
		cell->background = ((XmManagerWidget)w)->core.background_pixel;
	else
		cell->background = csrec->backgroundTb;

	if (csrec->foregroundTb == XmUNSPECIFIED_PIXEL)
		cell->foreground = ((XmManagerWidget)w)->manager.foreground;
	else
		cell->foreground = csrec->foregroundTb;

	cell->marginW = elist->list.margin_width;
	cell->marginH = elist->list.margin_height;
	cell->padding = elist->list.pixmapTextPadding;
	if (csrec->pixmapPlacementTb == XmPIXMAP_LEFT)
		cell->priority = XmPIXMAP;
	else
		cell->priority = XmSTRING;
	cell->info_type = csrec->typeTb;
	cell->align_type = csrec->alignmentTb;
	cell->armed = False;
}



static void CheckRenderOrder(XmNlListWidget elist)
{
	XmDirection direction = ((XmManagerWidget)(elist))->manager.string_direction;

	if (direction == XmRIGHT_TO_LEFT_TOP_TO_BOTTOM || direction == XmRIGHT_TO_LEFT_BOTTOM_TO_TOP || direction == XmTOP_TO_BOTTOM_RIGHT_TO_LEFT
		|| direction == XmBOTTOM_TO_TOP_RIGHT_TO_LEFT || direction == XmRIGHT_TO_LEFT)
	{
		elist->list.render_order = RtoL_render;
		return ;
	}

	if (direction == XmLEFT_TO_RIGHT_TOP_TO_BOTTOM || direction == XmLEFT_TO_RIGHT_BOTTOM_TO_TOP || direction == XmTOP_TO_BOTTOM_LEFT_TO_RIGHT
		|| direction == XmBOTTOM_TO_TOP_LEFT_TO_RIGHT || direction == XmLEFT_TO_RIGHT)
	{
		elist->list.render_order = LtoR_render;
		return ;
	}

	elist->list.render_order = LtoR_render;
	return ;
}

static void DrawString(XmNlListWidget elist, ListTbarCell * cell, int x, int left_edge, int right_edge)
{
	int string_x;
	int delta;
    XRectangle clip;

	if (x >= right_edge || (x + cell->label_w) <= left_edge)
		return ;
				
	string_x = x;
				
	clip.x = left_edge;
	clip.width = right_edge - left_edge;
	clip.y = elist->list.TBviewY + elist->list.title_shadow_thickness;
	clip.height = elist->list.TBfullHeight - 4*elist->list.title_shadow_thickness;
			

/*******************************************************************************/
/** If used XFT rendering need use clip in XmStringDraw(), otherwise not need **/
/*******************************************************************************/

	if (!CHECK_CLIP_CORRECT)
		XSetClipRectangles(XtDisplay((Widget) elist), elist->list.drawGC,
					0, 0, &clip, 1, Unsorted);

#ifdef DEBUG
	printf("DrawString le=%d re=%d cl=%d clw=%d\n", left_edge, right_edge, clip.x, clip.width);
	fflush(stdout);
#endif		
	XSetForeground(XtDisplay((Widget) elist), elist->list.drawGC, cell->foreground);
	XmStringDraw(XtDisplay((Widget) elist), XtWindow((Widget) elist), elist->list.render_table, 
					cell->xmlabel, elist->list.drawGC, 
					string_x, 
					elist->list.TBviewY + (elist->list.TBviewHeight - cell->label_h)/2,  
					cell->label_w, 
					cell->align_type, 
					XmSTRING_DIRECTION_DEFAULT, &clip);

#ifdef DEBUG
	printf("\n DrawStringInCorner at begin");
#endif		

}


static void 
DrawPix(XmNlListWidget elist, ListTbarCell * cell, int x, int left_edge, int right_edge)
{
	Display *dpy = XtDisplay((Widget) elist);
	int delta;
	int x2, width;
	XRectangle rect;

	if (x >= right_edge || (x + cell->pix_w) <= left_edge)
		return ;

	if (left_edge > x) delta = left_edge - x;
	else delta = 0;

#ifdef DEBUG
	printf("\n !!!!!!!!!!!!!!!!!!!!!DrawPixInCorner: x=%d, pixw=%d, le=%d, re=%d\n", x, cell->pix_w, left_edge, right_edge);
#endif
	x2 = x + cell->pix_w;
	if (x2 > right_edge) x2 = right_edge;
		

	if (PIX_FOUND(cell->pixmap))
	{
		if (PIX_FOUND(cell->mask)) 
		{
			XSetClipOrigin(dpy, elist->list.drawGC, x,
							elist->list.TBviewY + (elist->list.TBviewHeight - cell->pix_h)/2);
			XSetClipMask(dpy, elist->list.drawGC, cell->mask);
		}
		else
			XSetClipMask(dpy, elist->list.drawGC, None);

		if (x < left_edge) x = left_edge;
			
		width = x2 -x;

		XCopyArea(dpy, cell->pixmap, XtWindow((Widget) elist), elist->list.drawGC,
					delta, 0, width, cell->pix_h, 
					x, elist->list.TBviewY + (elist->list.TBviewHeight - cell->pix_h)/2);
#ifdef DEBUG
		printf("\n !!!!!!!!!!!!!!!!!!!!!!!DrawPixInCorner: y=%d, x=%d, x2=%d, delta=%d, width=%d\n", elist->list.TBviewY + (elist->list.TBviewHeight - cell->pix_h)/2, 
																		x, x2, delta, width);
#endif		
	}
	else
		if (elist->list.AutoPlacementMarker && (cell->markedStatus == XmARROW_UP || cell->markedStatus == XmARROW_DOWN))
		{
			rect.x = left_edge;
			rect.y = 0;
			rect.width = right_edge - left_edge;
			rect.height = elist->list.TBviewHeight;

			XSetClipRectangles(dpy, elist->manager.top_shadow_GC, 0, 0, 
								&rect, 1, Unsorted);
											
			XSetClipRectangles(dpy, elist->manager.bottom_shadow_GC, 0, 0, 
								&rect, 1, Unsorted);

			XmeDrawArrow(dpy, XtWindow((Widget) elist), elist->manager.bottom_shadow_GC, elist->manager.top_shadow_GC, NULL, 
					x, elist->list.TBviewY + (elist->list.TBviewHeight - cell->pix_h)/2, cell->pix_w, cell->pix_h,
					elist->manager.shadow_thickness, cell->markedStatus);
/*			XmeDrawArrow(dpy, XtWindow((Widget) elist), elist->manager.top_shadow_GC, elist->manager.bottom_shadow_GC, NULL, 
					x, elist->list.TBviewY + (elist->list.TBviewHeight - cell->pix_h)/2, cell->pix_w, cell->pix_h,
					elist->manager.shadow_thickness, XmARROW_UP);*/
			XSetClipMask(dpy, elist->manager.top_shadow_GC, None);
/*			XSetClipRectangles(dpy, elist->manager.top_shadow_GC, 0, 0, 
								NULL, 0, Unsorted);*/

			XSetClipMask(dpy, elist->manager.bottom_shadow_GC, None);
											
/*			XSetClipRectangles(dpy, elist->manager.bottom_shadow_GC, 0, 0, 
								NULL, 0, Unsorted);*/

		}
}


static void 
ElistDrawLeftCell(XmNlListWidget elist, ListTbarCell * cell, int x, int left_edge, int right_edge)
{
	Display *dpy = XtDisplay((Widget) elist);
#ifdef DEBUG
	printf("\n  PartResDrawLeftCell started with cell %p\n", cell);
//	printf("\n  PartResDrawLeftCell: current_width = %d ", cell->current_width);
	printf("\n  PartResDrawLeftCell: info_type = %hhx ", cell->info_type);
#endif	

	if (cell->info_type == XmPIXMAP	|| (cell->info_type == XmPIXMAP_AND_STRING && cell->priority == XmPIXMAP))
	{
		if (cell->pixmap != XmUNSPECIFIED_PIXMAP || cell->markedStatus == XmARROW_UP || cell->markedStatus == XmARROW_DOWN)
		{
#ifdef DEBUG
			printf("\n  DrawPix next step x=%d \n", x);
#endif	
			if (x < right_edge) 
				DrawPix(elist, cell, x, left_edge, right_edge);
		}
		if (cell->info_type == XmPIXMAP_AND_STRING && cell->priority == XmPIXMAP && cell->xmlabel)
		{
			if (x + cell->padding + cell->pix_w < right_edge)
				DrawString(elist, cell, x + cell->padding + cell->pix_w, left_edge, right_edge);
		}
			
		return;
	}
	
	if (cell->info_type == XmSTRING	|| (cell->info_type == XmPIXMAP_AND_STRING && cell->priority == XmSTRING))
	{
		if (cell->xmlabel)
		{
			if (x < right_edge)
			{
#ifdef DEBUG
			printf("\n  _^_^_^_^_^_^_^_^_^_^_ DrawLeftCell x=%d l_w=%d left_edge=%d right_edge=%d\n", x, cell->label_w, left_edge, right_edge);
#endif	
				DrawString(elist, cell, x, left_edge, right_edge);
			}
		}
		if (cell->info_type == XmPIXMAP_AND_STRING && cell->priority == XmSTRING && 
			(cell->pixmap != XmUNSPECIFIED_PIXMAP || cell->markedStatus == XmARROW_UP || cell->markedStatus == XmARROW_DOWN))
		{
			if (x + cell->padding + cell->label_w < right_edge)
				DrawPix(elist, cell, x + cell->padding + cell->label_w, left_edge, right_edge);
		}
		
	}
	
}

static void ElistDrawRightCell(XmNlListWidget elist, ListTbarCell * cell, int x, int left_edge, int right_edge)
{
	Display *dpy = XtDisplay((Widget) elist);

#ifdef DEBUG
	printf("\n  PartResDrawRightCell started \n");
#endif	

	if (cell->info_type == XmPIXMAP	|| (cell->info_type == XmPIXMAP_AND_STRING && cell->priority == XmPIXMAP))
	{
#ifdef DEBUG
	printf("\n  PartResDrawRightCell  XmPIXMAP\n");
#endif	
		if (cell->pixmap != XmUNSPECIFIED_PIXMAP || cell->markedStatus == XmARROW_UP || cell->markedStatus == XmARROW_DOWN) 
		{
#ifdef DEBUG
	printf("\n  PartResDrawRightCell  PIXMAP_FOUND %d %d \n",
			x + cell->current_width - 2*elist->list.title_shadow_thickness - 2*cell->marginW - cell->pix_w, left_edge);
#endif	
			if (x + cell->current_width - 2*elist->list.title_shadow_thickness - 2*cell->marginW - cell->pix_w < right_edge)
				DrawPix(elist, cell, x + cell->current_width - 2*elist->list.title_shadow_thickness - 2*cell->marginW - cell->pix_w, 
						left_edge, right_edge);
		}
		if (cell->info_type == XmPIXMAP_AND_STRING && cell->priority == XmPIXMAP && cell->xmlabel)
		{
			if (x + cell->current_width - 2*elist->list.title_shadow_thickness - 2*cell->marginW - cell->padding - cell->pix_w - cell->label_w < right_edge)
				DrawString(elist, cell, 
						x + cell->current_width - 2*elist->list.title_shadow_thickness - 2*cell->marginW - cell->padding - cell->pix_w - cell->label_w, 
						left_edge, right_edge);
		}
			
	}
	
	if (cell->info_type == XmSTRING	|| (cell->info_type ==  XmPIXMAP_AND_STRING && cell->priority == XmSTRING))
	{
		if (cell->xmlabel)
		{
#ifdef DEBUG
	printf("\n  PartResDrawRightCell  STRING_FOUND %d %d \n",
							x + cell->current_width - 2*elist->list.title_shadow_thickness - 2*cell->marginW - cell->label_w, right_edge);
#endif	
			if (x + cell->current_width - 2*elist->list.title_shadow_thickness - 2*cell->marginW - cell->label_w < right_edge)
				DrawString(elist, cell, x + cell->current_width - 2*elist->list.title_shadow_thickness - 2*cell->marginW - cell->label_w, 
							left_edge, right_edge);
		}
		if (cell->info_type ==  XmPIXMAP_AND_STRING && cell->priority == XmSTRING 
			&& (cell->pixmap != XmUNSPECIFIED_PIXMAP || cell->markedStatus == XmARROW_UP || cell->markedStatus == XmARROW_DOWN))
		{
			if (x + cell->current_width - 2*elist->list.title_shadow_thickness - 2*cell->marginW - cell->padding - cell->label_w - cell->pix_w < right_edge)
				DrawPix(elist, cell, x + cell->current_width - 2*elist->list.title_shadow_thickness - 2*cell->marginW - cell->padding - cell->pix_w - cell->label_w, left_edge, right_edge);
		}
	}
}

static void 
ElistDrawCenterCell(XmNlListWidget elist, ListTbarCell * cell, int x, int left_edge, int right_edge)
{
	Display *dpy = XtDisplay((Widget) elist);
	int rr_edge, ll_edge;
#ifdef DEBUG
	printf("\n PartResDrawCenterCell started with cell %p\n", cell);
	printf("\n PartResDrawCenterCell: info_type = %hhx ", cell->info_type);
#endif	

	if (cell->info_type == XmPIXMAP_AND_STRING && cell->priority == XmPIXMAP)
	{
		if (elist->list.render_order == LtoR_render)
		{
			ll_edge = x + cell->marginW + cell->pix_w;

			if (ll_edge < elist->list.TBviewX + elist->list.title_shadow_thickness + cell->marginW)
				ll_edge = elist->list.TBviewX + elist->list.title_shadow_thickness + cell->marginW;
			
			if (cell->xmlabel && ll_edge < right_edge)
			{
				DrawString(elist, cell, x + cell->current_width - 2*elist->list.title_shadow_thickness -
							 2*cell->marginW - cell->label_w, ll_edge, right_edge);
			}
			if (cell->pixmap != XmUNSPECIFIED_PIXMAP || cell->markedStatus == XmARROW_UP || cell->markedStatus == XmARROW_DOWN)
			{
				DrawPix(elist, cell, x, left_edge, right_edge);
			}
		}
		if (elist->list.render_order == RtoL_render)
		{
			rr_edge = x + cell->current_width - 2*elist->list.title_shadow_thickness - 
							2*cell->marginW - cell->pix_w;
			if (rr_edge > elist->list.TBviewX + elist->list.TBviewWidth - 
					elist->list.title_shadow_thickness - cell->marginW)
				rr_edge = elist->list.TBviewX + elist->list.TBviewWidth - 
					elist->list.title_shadow_thickness - cell->marginW;

			if (cell->xmlabel && left_edge < rr_edge)
			{
				DrawString(elist, cell, x, left_edge, 
							 rr_edge);
			}
			if (cell->pixmap != XmUNSPECIFIED_PIXMAP || cell->markedStatus == XmARROW_UP || cell->markedStatus == XmARROW_DOWN)
			{
				DrawPix(elist, cell, x + cell->current_width - 2*elist->list.title_shadow_thickness -
							 2*cell->marginW - cell->pix_w, left_edge, right_edge);
			}
		}
	}
	
	if (cell->info_type == XmPIXMAP_AND_STRING && cell->priority == XmSTRING)
	{
		if (elist->list.render_order == LtoR_render)
		{
			rr_edge = x + cell->current_width - 2*elist->list.title_shadow_thickness - 
							2*cell->marginW - cell->pix_w;
			if (rr_edge > elist->list.TBviewX + elist->list.TBviewWidth - 
					elist->list.title_shadow_thickness - cell->marginW)
				rr_edge = elist->list.TBviewX + elist->list.TBviewWidth - 
					elist->list.title_shadow_thickness - cell->marginW;

			if (cell->xmlabel && left_edge < rr_edge)
			{
				DrawString(elist, cell, x, left_edge, rr_edge);
			}
			if (cell->pixmap != XmUNSPECIFIED_PIXMAP || cell->markedStatus == XmARROW_UP || cell->markedStatus == XmARROW_DOWN)
			{
				DrawPix(elist, cell, x + cell->current_width - 2*elist->list.title_shadow_thickness -
							 2*cell->marginW - cell->pix_w, left_edge, right_edge);
			}
		}
		if (elist->list.render_order == RtoL_render)
		{
			ll_edge = x + cell->marginW + cell->pix_w;

			if (ll_edge < elist->list.TBviewX + elist->list.title_shadow_thickness + cell->marginW)
				ll_edge = elist->list.TBviewX + elist->list.title_shadow_thickness + cell->marginW;
			if (cell->xmlabel && ll_edge < right_edge)
			{
				DrawString(elist, cell, x + cell->current_width - 2*elist->list.title_shadow_thickness -
							 2*cell->marginW - cell->label_w, ll_edge, right_edge);
			}
			if (cell->pixmap != XmUNSPECIFIED_PIXMAP || cell->markedStatus == XmARROW_UP || cell->markedStatus == XmARROW_DOWN)
			{
				DrawPix(elist, cell, x + cell->marginW, left_edge, right_edge);
			}
		}
	}
	
	
	if (cell->info_type == XmPIXMAP && (cell->pixmap != XmUNSPECIFIED_PIXMAP
		|| cell->markedStatus == XmARROW_UP || cell->markedStatus == XmARROW_DOWN))
	{
		DrawPix(elist, cell, x + (cell->current_width - 2*elist->list.title_shadow_thickness -
							 2*cell->marginW)/2 - cell->pix_w/2, left_edge, right_edge);
	}
	
	if (cell->info_type == XmSTRING && cell->xmlabel)
	{
		DrawString(elist, cell, x + (cell->current_width- 2*elist->list.title_shadow_thickness -
							 2*cell->marginW)/2 - cell->label_w/2, left_edge, right_edge);
	}
}



static void ElistDrawCell(XmNlListWidget elist, int i, int x, int left_edge, int right_edge)
{
	ListTbarCell * cell;

	cell = elist->list.tbar_item;
	cell = cell + i;
#ifdef DEBUG
	printf("ElistDrawCell i=%d x=%d le=%d re=%d\n", i, x, left_edge, right_edge);
#endif	
	if (cell->align_type == XmALIGNMENT_CENTER)
		ElistDrawCenterCell(elist, cell, x, left_edge, right_edge);

	if (cell->align_type == XmALIGNMENT_BEGINNING && elist->list.render_order == LtoR_render)
		ElistDrawLeftCell(elist, cell, x, left_edge, right_edge);

	if (cell->align_type == XmALIGNMENT_END && elist->list.render_order == LtoR_render)
	{
#ifdef DEBUG
	printf("\n  PartResDrawCell XmALIGNMENT_END\n", i);
#endif	
		
		ElistDrawRightCell(elist, cell, x, left_edge, right_edge);
	}

	if (cell->align_type == XmALIGNMENT_BEGINNING && elist->list.render_order == RtoL_render)
		ElistDrawRightCell(elist, cell, x, left_edge, right_edge);

	if (cell->align_type == XmALIGNMENT_END && elist->list.render_order == RtoL_render)
		ElistDrawLeftCell(elist, cell, x, left_edge, right_edge);
#ifdef DEBUG
	printf("\n  PartResDrawCell complete \n");
#endif	
}


static int InternRedisplayTitleBar(Widget w)
{
    XmNlListWidget elist = (XmNlListWidget) w;
	ListTbarCell * cell;
    XRectangle box;
    int x, y, i, left_edge, right_edge;
#ifdef DEBUG
	printf("\n  InternRedisplayTitleBar started column %d\n", elist->list.num_cols);
#endif
	int width, height, dest_x, src_x1, src_x2, str_height;
	int shad_hig, shad_hig2, shadow, shadow2, hig, hig2, shdt;
	int thick_x, thick_wd, clip_width;

	if (elist->list.num_cols == 0)
	{
		XmeDrawShadows(XtDisplay(w), XtWindow(w),
						elist->manager.top_shadow_GC,
						elist->manager.bottom_shadow_GC,
						elist->list.TBviewX, elist->list.TBviewY,
						elist->list.TBviewWidth,
						elist->list.TBviewHeight,
						elist->list.title_shadow_thickness, XmSHADOW_OUT);
		return 1;
	}

#ifdef DEBUG
	printf("\n  InternRedisplayTitleBar continue column %d\n", elist->list.num_cols);
#endif
	
	shadow = elist->list.title_shadow_thickness;
	shadow2 = 2 * elist->list.title_shadow_thickness;

	CheckRenderOrder(elist);
	
	cell = elist->list.tbar_item;
	
#ifdef DEBUG
	printf("\n  InternManualRedisplay area cleared");
#endif
	if (cell == NULL) 
		return 1;

	x = - elist->list.h_shift;
	y = elist->list.TBviewY;
	for (i = 0; i < elist->list.num_cols; i++)
	{
		if (x >= elist->list.TBviewWidth) 
			break;

		if (x + cell[i].current_width > 0)
		{
			if (elist->list.render_order == LtoR_render)
			{
				thick_x = x + elist->list.TBviewX;

				if (thick_x < elist->list.TBviewX) 
					thick_x = elist->list.TBviewX;

				thick_wd = x + elist->list.TBviewX + cell[i].current_width - thick_x;

				if (thick_x + thick_wd > elist->list.TBviewX + elist->list.TBviewWidth) 
					thick_wd = elist->list.TBviewX + elist->list.TBviewWidth - thick_x;
			}
			else
			{
				thick_x = elist->list.TBviewX + elist->list.TBviewWidth - x - cell[i].current_width;
				
				if (thick_x < elist->list.TBviewX) 
					thick_x = elist->list.TBviewX;

				thick_wd = (elist->list.TBviewX + elist->list.TBviewWidth - x) - thick_x;

				if (thick_x + thick_wd > elist->list.TBviewX + elist->list.TBviewWidth) 
					thick_wd = elist->list.TBviewX + elist->list.TBviewWidth - thick_x;
			}

			if (cell[i].armed)
			{
				box.x = thick_x;
				box.width = thick_wd;
				box.height = elist->list.TBviewHeight;
				box.y = y;

				XFillRectangle(XtDisplay(w), XtWindow(w), elist->list.fill_gc,
						box.x, box.y, box.width, box.height);

				XmeDrawShadows(XtDisplay(w), XtWindow(w),
						elist->manager.top_shadow_GC,
						elist->manager.bottom_shadow_GC,
						thick_x, y,
						thick_wd,
						elist->list.TBviewHeight,
						elist->list.title_shadow_thickness, XmSHADOW_IN);
			}
			else
			{
				XClearArea(XtDisplay(w), XtWindow(w), thick_x, y,
						thick_wd, elist->list.TBviewHeight, False);
				XmeDrawShadows(XtDisplay(w), XtWindow(w),
						elist->manager.top_shadow_GC,
						elist->manager.bottom_shadow_GC,
						thick_x, y,
						thick_wd,
						elist->list.TBviewHeight,
						elist->list.title_shadow_thickness, XmSHADOW_OUT);
			}
						
				
#ifdef DEBUG
			printf("\n  InternManualRedisplay: drawed %d %p\n", i, &(cell[i]));
#endif

			left_edge = thick_x + shadow + cell->marginW;
			right_edge = thick_x + thick_wd - shadow - cell->marginW;

			if(right_edge < left_edge)
			{
				right_edge = left_edge;
				x = x + cell[i].current_width;
				continue ;
			}

			if ((right_edge - left_edge) && left_edge < elist->list.TBviewX + elist->list.TBviewWidth && 
					right_edge > elist->list.TBviewX && right_edge < elist->list.TBviewX + elist->list.TBviewWidth)
			{
#ifdef DEBUG
				printf("\n InternManualRedisplay: i = %d, x=%d, cw=%d, tx=%d, txwd=%d, le=%d, re=%d TBx=%d TBw=%d\n", 
				i, x, cell[i].current_width, thick_x, thick_wd, left_edge, right_edge, elist->list.TBviewX, elist->list.TBviewWidth);
#endif

#ifdef DEBUG
				printf("\n InternManualRedisplay: x+=%d\n", x+shadow+H_MARGIN);
#endif
				if (elist->list.render_order == LtoR_render) 
						ElistDrawCell(elist, i, x + elist->list.TBviewX + shadow + cell->marginW, left_edge, right_edge);
				else
						ElistDrawCell(elist, i, elist->list.TBviewX + elist->list.TBviewWidth - x - cell[i].current_width + shadow + cell->marginW, left_edge, right_edge);
#ifdef DEBUG
				printf("\ni for label=%d\n",  i);
				printf("\tX for label=%d\n",  x+shadow+H_MARGIN);
				printf("\tX for left_edge=%d\n",  left_edge);
#endif
			}
		}
		x = x + cell[i].current_width;
	}


#ifdef DEBUG
		printf("\n InternRedisplayTitleBar: ok\n");
#endif

	return 0;
}


#define SHADOW_TH_LS elist->manager.shadow_thickness
//#define SHADOW_TH_TW ((XmPrimitiveWidget)(t_wid))->primitive.shadow_thickness
#define SHADOW_TH_TW (elist->list.title_shadow_thickness)

static void
RedrawTitleBarOnly(Widget w)
{
    Arg args[1];
    XmNlListWidget elist = (XmNlListWidget) w;

    Widget rclist = elist->list.rclist;
    Widget vbar = elist->list.v_bar;
    Widget hbar = elist->list.h_bar;
	Widget item_box = elist->list.item_box;
	Widget tree = elist->list.tree;

    Dimension title_height, h_thick, v_thick, temp_val, rc_height;
    Position scroll_top, scroll_bottom, scroll_left, scroll_right, rc_y;

    Dimension height = elist->core.height;
    Dimension width = elist->core.width;

	int rcMargin, twMargin;

#ifdef DEBUG
      printf("\n XmNlList Redisplay: LayoutChildren started\n");
#endif
    v_thick = vbar->core.width + 2 * vbar->core.border_width;
    h_thick = hbar->core.height + 2 * vbar->core.border_width;
    scroll_top =  V_MARGIN;
    scroll_bottom = height - V_MARGIN - h_thick;
    scroll_left = width - H_MARGIN - v_thick;
    scroll_right = width - H_MARGIN;
#ifdef DEBUG
      printf("\n XmNlList LayoutChildren calc ok\n");
#endif

//	CheckRenderOrder(elist);


//	CalcTitleBarGeomOverall(w);

	if ((elist->list.ViewListType == XmNlList_Detail || elist->list.ViewListType == XmNlList_TreeCol) && rclist)
	{
		rcMargin = (SHADOW_TH_LS >= SHADOW_TH_TW) ? H_MARGIN + SHADOW_TH_LS - SHADOW_TH_TW: H_MARGIN + SHADOW_TH_TW - SHADOW_TH_LS;

/*printf("CLEAR TILES VIEW 2 %d - %d - %d - %d\n\n",
				rcMargin + SHADOW_TH_TW,
				V_MARGIN + SHADOW_TH_TW,
				elist->list.TBviewWidth,
				elist->list.TBfullHeight - 2*SHADOW_TH_TW);
*/
		XClearArea(XtDisplay(w), XtWindow(w), rcMargin + SHADOW_TH_TW, 
				V_MARGIN + SHADOW_TH_TW,
				elist->list.TBviewWidth,
				elist->list.TBfullHeight - 2*SHADOW_TH_TW,
				False);

#ifdef DEBUG
      printf("\n XmNlList  RedrawTitleBarOnly: area cleared\n");
#endif


		InternRedisplayTitleBar(w);

	}
}

#undef SHADOW_TH_LS
#undef SHADOW_TH_TW




static void RefreshTitleBar(Widget w)
{
    XmNlListWidget elist = (XmNlListWidget) w;
    int i, accum = 0;
    ListTbarCell * cell;
    int k, delta;
    Boolean corrected = False;
    
    cell = elist->list.tbar_item;
    

	if (elist->list.num_cols > 0)
	{
		if (elist->list.autores < 0 || elist->list.autores >= elist->list.num_cols)
		{
			k = elist->list.num_cols - 1;
			if (k < 0)
				k = 0;
		}
		else
			k = elist->list.autores;

		if (elist->list.TBfullTilesWidth < elist->list.TBviewWidth)
		{
			
			delta = elist->list.TBviewWidth - elist->list.TBfullTilesWidth;
			cell[k].current_width = cell[k].current_width + delta;

			if (k < elist->list.num_cols - 1)
			{
				for (i = 0; i < elist->list.num_cols; i++)
				{
					cell[i].x = accum;
					accum = accum + cell[i].current_width;
				}
			}

			elist->list.TBfullTilesWidth = elist->list.TBfullTilesWidth + delta;
			if (elist->list.h_shift + elist->list.TBfullTilesWidth != elist->list.TBviewWidth)
				elist->list.h_shift = (elist->list.TBviewWidth > elist->list.TBfullTilesWidth) ? elist->list.TBviewWidth - elist->list.TBfullTilesWidth :
																elist->list.TBfullTilesWidth - elist->list.TBviewWidth;


			RefreshHScroll(elist, (int) elist->list.TBfullTilesWidth, elist->list.TBviewWidth, elist->list.h_shift);
			return ;
		}

		if (elist->list.TBfullTilesWidth > elist->list.TBviewWidth && 
			elist->list.TBfullTilesWidth > elist->list.ideal_full_width_title &&
			((elist->list.TBfullTilesWidth - elist->list.TBviewWidth) <= (cell[k].current_width - cell[k].real_width)))
		{
			delta = elist->list.TBfullTilesWidth - elist->list.TBviewWidth;
			cell[k].current_width = cell[k].current_width - delta;

			if (k < elist->list.num_cols - 1)
			{
				corrected = True;
				accum = 0;
			}

			elist->list.TBfullTilesWidth = elist->list.TBfullTilesWidth - delta;
			if (elist->list.h_shift + elist->list.TBviewWidth != elist->list.TBfullTilesWidth)
				elist->list.h_shift = (elist->list.TBviewWidth > elist->list.TBfullTilesWidth) ? elist->list.TBviewWidth - elist->list.TBfullTilesWidth :
																elist->list.TBfullTilesWidth - elist->list.TBviewWidth;
			for (i = 0; i < elist->list.num_cols, corrected; i++)
			{
				cell[i].x = accum;
				accum = accum + cell[i].current_width;
			}


			RefreshHScroll(elist, (int) elist->list.TBfullTilesWidth, elist->list.TBviewWidth, elist->list.h_shift);
			return ;
		}

		if (elist->list.h_shift + elist->list.TBviewWidth > elist->list.TBfullTilesWidth)
			elist->list.h_shift = (elist->list.TBviewWidth > elist->list.TBfullTilesWidth) ? elist->list.TBviewWidth - elist->list.TBfullTilesWidth :
																elist->list.TBfullTilesWidth - elist->list.TBviewWidth;
		RefreshHScroll(elist, (int) elist->list.TBfullTilesWidth, elist->list.TBviewWidth, elist->list.h_shift);
	}


/*	for (i = 0; i < elist->list.num_cols; i++)
	{
		sum = sum + cell[i].current_width;
	}
	
	if (sum < elist->list.TBviewWidth)
	{
		if (elist->list.autores < 0)
			k = elist->list.num_cols - 1;
		else
			k = elist->list.autores;
			
		delta = elist->list.TBviewWidth - sum;
		cell[k].current_width = cell[k].current_width + delta;
	}
*/
}


/*	Function Name: LayoutChildren
 *	Description:   Lays out the "child" widgets in the Ext List widget.
 *	Arguments:     w - the ext list widget.
 *	Returns:       none.
 */

#define SHADOW_TH_LS elist->manager.shadow_thickness
//#define SHADOW_TH_TW ((XmPrimitiveWidget)(t_wid))->primitive.shadow_thickness
#define SHADOW_TH_TW (elist->list.title_shadow_thickness)

static void LayoutChildren(Widget w)
{
    Arg args[1];
    XmNlListWidget elist = (XmNlListWidget) w;
    ListTbarCell * cell = elist->list.tbar_item;

	int i;

    Widget rclist = elist->list.rclist;
    Widget vbar = elist->list.v_bar;
    Widget hbar = elist->list.h_bar;
	Widget item_box = elist->list.item_box;
	Widget tree = elist->list.tree;

    Dimension title_height, h_thick, v_thick, temp_val, rc_height;
    Position scroll_top, scroll_bottom, scroll_left, scroll_right, rc_y;

    Dimension height = elist->core.height;
    Dimension width = elist->core.width;

//    if (!XtIsRealized(w)) return ;

	if (height < 2 || width < 2) return ;
#ifdef DEBUG
      printf("\n XmNlList LayoutChildren started W= %d H= %d\n", width, height);
      if (rclist && XtIsManaged(rclist))
		printf("RClist managed\n");
      if (item_box && XtIsManaged(item_box))
		printf("Itembox managed\n");
      if (tree && XtIsManaged(tree))
		printf("Tree managed\n");
#endif

    for (i = 0; i < elist->composite.num_children; i++) {
		Widget ic = elist->composite.children[i];
		String str;
	
		str = XtName(ic);
	}

    v_thick = vbar->core.width + 2 * vbar->core.border_width;
    h_thick = hbar->core.height + 2 * vbar->core.border_width;
    scroll_top =  V_MARGIN;
    scroll_bottom = height - V_MARGIN - h_thick;
    scroll_left = width - H_MARGIN - v_thick;
    scroll_right = width - H_MARGIN;
#ifdef DEBUG
      printf("\n XmNlList LayoutChildren calc ok\n");
#endif
	/*
	* Put the title widget in the top left corner
	*/
//	_XmMoveWidget(t_wid, (Position) H_MARGIN, (Position) V_MARGIN);

	CheckRenderOrder(elist);
	if (elist->list.ViewListType == XmNlList_Detail || elist->list.ViewListType == XmNlList_TreeCol)
	{
		int rcMargin, twMargin;
//		if (!t_wid || !rclist)
		if (!rclist)
			return ;

//		title_height = t_wid->core.height;
//		title_height = elist->list.TBfullHeight;
		title_height = elist->list.TBfullHeight;


		rc_height = (height - title_height - 3*V_MARGIN - 2*SHADOW_TH_LS - T_MARGIN - hbar->core.height > 0) ? 
					height - title_height - 3*V_MARGIN - 2*SHADOW_TH_LS - T_MARGIN - hbar->core.height : 1;
		rc_y = V_MARGIN + title_height + T_MARGIN + SHADOW_TH_LS;

		elist->list.RCfullHeight = rc_height + 2*SHADOW_TH_LS;
		elist->list.RCshadY = rc_y - SHADOW_TH_LS;


		twMargin = (SHADOW_TH_LS >= SHADOW_TH_TW) ? H_MARGIN + SHADOW_TH_LS - SHADOW_TH_TW: H_MARGIN + SHADOW_TH_TW - SHADOW_TH_LS;

 
		if (elist->list.ListEmpty || !elist->list.PropConsistency)
		{
//			rcMargin = (SHADOW_TH_LS >= SHADOW_TH_TW) ? H_MARGIN + SHADOW_TH_LS - SHADOW_TH_TW: H_MARGIN + SHADOW_TH_TW - SHADOW_TH_LS;
			if (vbar) 
			{
				elist->list.TBviewWidth = width - H_MARGIN - vbar->core.width - 2*twMargin - 2*SHADOW_TH_TW;
//				RefreshTitleBar(w);
			}
		}
		

		elist->list.TbarY = V_MARGIN;
		elist->list.TBfullWidth = width - H_MARGIN - vbar->core.width - 2*twMargin;
 
	/*
     * Place the RCList.
     *
     * NOTE: I am reusing "width" and "height" for the size of the widget
     *       that I am about to configure.
     */
		if (rclist != NULL)
		{
			rcMargin = (SHADOW_TH_LS >= SHADOW_TH_TW) ? H_MARGIN + SHADOW_TH_LS : H_MARGIN + SHADOW_TH_TW;

			if (elist->list.render_order == LtoR_render)
			{
				elist->list.RCshadX = rcMargin - SHADOW_TH_LS;
				elist->list.RCfullWidth = ((width - H_MARGIN - 2*rcMargin - vbar->core.width > 0) ? 
										width - H_MARGIN - 2*rcMargin - vbar->core.width : 1) + 2 * SHADOW_TH_LS;

				elist->list.TbarX = twMargin;


				XtConfigureWidget(rclist, 
					(Position) rcMargin,
					rc_y,
					(width - H_MARGIN - 2*rcMargin - vbar->core.width > 0) ? width - H_MARGIN - 2*rcMargin - vbar->core.width : 1,
					rc_height,
					0);
			}
			else
			{
				elist->list.RCshadX = rcMargin + H_MARGIN + vbar->core.width - SHADOW_TH_LS;
				elist->list.RCfullWidth = ((width - H_MARGIN - 2*rcMargin - vbar->core.width > 0) ? 
										width - H_MARGIN - 2*rcMargin - vbar->core.width : 1) + 2 * SHADOW_TH_LS;

				elist->list.TbarX = H_MARGIN + vbar->core.width + twMargin;

				XtConfigureWidget(rclist, 
					(Position) (H_MARGIN + vbar->core.width + rcMargin),
					rc_y,
					(width - H_MARGIN - 2*rcMargin - vbar->core.width > 0) ? width - H_MARGIN - 2*rcMargin - vbar->core.width : 1,
					rc_height,
					0);
			}
			
#ifdef DEBUG
			printf("XmNlList: RClist configured\n");
			for (i = 0; i < elist->list.num_cols; i++)
			{
				printf("XmNlList: current width %d = %d x = %d\n", i, cell[i].current_width, cell[i].x);
			}
#endif
		}
 	}


	if ((elist->list.ViewListType == XmNlList_Big || elist->list.ViewListType == XmNlList_Small) && item_box != NULL)
	{

		if (!item_box)
			return ;

		if (elist->list.render_order == LtoR_render)
			XtConfigureWidget(elist->list.item_box, 
					(Position) (H_MARGIN + SHADOW_TH_LS),
					(Position) (V_MARGIN + SHADOW_TH_LS),
					(width - 3*H_MARGIN - 2*SHADOW_TH_LS - vbar->core.width > 0) ? width - 3*H_MARGIN - 2*SHADOW_TH_LS - vbar->core.width : 1,
					(height - 3*V_MARGIN - 2*SHADOW_TH_LS - hbar->core.height > 0) ? height - 3*V_MARGIN - 2*SHADOW_TH_LS - hbar->core.height : 1,
					0);
		else
		{
			XtConfigureWidget(elist->list.item_box, 
					(Position) (vbar->core.width + 2*H_MARGIN + SHADOW_TH_LS),
					(Position) (V_MARGIN + SHADOW_TH_LS),
					(width - 3*H_MARGIN - 2*SHADOW_TH_LS - vbar->core.width > 0) ? width - 3*H_MARGIN - 2*SHADOW_TH_LS - vbar->core.width : 1,
					(height - 3*V_MARGIN - 2*SHADOW_TH_LS - hbar->core.height > 0) ? height - 3*V_MARGIN - 2*SHADOW_TH_LS - hbar->core.height : 1,
					0);
		}
#ifdef DEBUG
      printf("\n XmNlList LayoutChildren: item_box configured\n");
#endif

	}

	if (elist->list.ViewListType == XmNlList_Tree && rclist != NULL)
	{
		if (elist->list.render_order == LtoR_render)
			XtConfigureWidget(rclist, 
					(Position) (H_MARGIN + SHADOW_TH_LS),
					(Position) (V_MARGIN + SHADOW_TH_LS),
					(width - 3*H_MARGIN - 2*SHADOW_TH_LS - vbar->core.width > 0) ? width - 3*H_MARGIN - 2*SHADOW_TH_LS - vbar->core.width : 1,
					(height - 3*V_MARGIN - 2*SHADOW_TH_LS - hbar->core.height > 0) ? height - 3*V_MARGIN - 2*SHADOW_TH_LS - hbar->core.height : 1,
					0);
		else
			XtConfigureWidget(rclist, 
					(Position) (vbar->core.width + 2*H_MARGIN + SHADOW_TH_LS),
					(Position) (V_MARGIN + SHADOW_TH_LS),
					(width - 3*H_MARGIN - 2*SHADOW_TH_LS - vbar->core.width > 0) ? width - 3*H_MARGIN - 2*SHADOW_TH_LS - vbar->core.width : 1,
					(height - 3*V_MARGIN - 2*SHADOW_TH_LS - hbar->core.height > 0) ? height - 3*V_MARGIN - 2*SHADOW_TH_LS - hbar->core.height : 1,
					0);
		
#ifdef DEBUG
		printf("\n XmNlList LayoutChildren: tree configured\n");
#endif

	}



    /*
     * Place the scrollbars.
     */
	if (elist->list.render_order == LtoR_render)
		XtConfigureWidget(hbar, H_MARGIN,
				(height - V_MARGIN - hbar->core.height > 0) ? height - V_MARGIN - hbar->core.height : V_MARGIN,
				(width - 3*H_MARGIN - vbar->core.width > 0) ? width - 3*H_MARGIN - vbar->core.width : 1,
				hbar->core.height, 0);
	else
		XtConfigureWidget(hbar, 
				2*H_MARGIN + vbar->core.width,
				(height - V_MARGIN - hbar->core.height > 0) ? height - V_MARGIN - hbar->core.height : V_MARGIN,
				(width - 3*H_MARGIN - vbar->core.width > 0) ? width - 3*H_MARGIN - vbar->core.width : 1,
				hbar->core.height, 0);


	if (elist->list.render_order == LtoR_render)
		XtConfigureWidget(vbar,
				(width - H_MARGIN - vbar->core.width > 0) ? width - H_MARGIN - vbar->core.width : H_MARGIN,
				V_MARGIN,
				vbar->core.width,
				(height - 3*V_MARGIN - hbar->core.height > 0) ? height - 3*V_MARGIN - hbar->core.height : V_MARGIN,
				0);
	else
		XtConfigureWidget(vbar,
				H_MARGIN,
				V_MARGIN,
				vbar->core.width,
				(height - 3*V_MARGIN - hbar->core.height > 0) ? height - 3*V_MARGIN - hbar->core.height : V_MARGIN,
				0);

#ifdef DEBUG
printf("\n XmNlList LayoutChildren ok\n");
#endif
}

#undef SHADOW_TH_LS
#undef SHADOW_TH_TW




static void DetachScrollCallbacks(Widget w)
{
    XmNlListWidget elist = (XmNlListWidget) w;

	if (elist->list.h_bar)
	{
		XtRemoveAllCallbacks(elist->list.h_bar, XmNvalueChangedCallback);
		XtRemoveAllCallbacks(elist->list.h_bar, XmNdragCallback);
	}
			
	if (elist->list.v_bar)
	{
		XtRemoveAllCallbacks(elist->list.v_bar, XmNvalueChangedCallback);
		XtRemoveAllCallbacks(elist->list.v_bar, XmNdragCallback);
	}

//	elist->list.ItemBoxScrollsFound = False;
//	elist->list.ResColScrollsFound = False;
}

static void DetachCallbacks(Widget w, int mode)
{
    XmNlListWidget elist = (XmNlListWidget) w;

	switch (mode) {
		case ItemBox :
			XtRemoveCallback(elist->list.item_box, XtNhighlightCallback,
						HighlightDoCallback, (XtPointer) w);
			XtRemoveCallback(elist->list.item_box, XmNdoubleClickCallback,
						DoubleClickDoCallback, (XtPointer) w);
			break;
		case ResCol :
			XtRemoveCallback(elist->list.rclist, XtNhighlightCallback,
						HighlightDoCallback, (XtPointer) w);
			XtRemoveCallback(elist->list.rclist, XmNdoubleClickCallback,
						DoubleClickDoCallback, (XtPointer) w);
			XtRemoveCallback(elist->list.rclist, XmNlrcResizeCallback,
						ResizeRCCallback, (XtPointer) w);
			break ;
		case ListTree :
			XtRemoveCallback(elist->list.rclist, XtNhighlightCallback,
						HighlightDoCallback, (XtPointer) w);
			XtRemoveCallback(elist->list.rclist, XmNdoubleClickCallback,
						DoubleClickDoCallback, (XtPointer) w);
			break;
		default :
			return;

	}
}


static void AttachCallbacks(Widget w, int mode)
{
    XmNlListWidget elist = (XmNlListWidget) w;

	switch (mode) {
		case ItemBox :
			XtAddCallback(elist->list.item_box, XtNhighlightCallback,
							HighlightDoCallback, (XtPointer) w);
			XtAddCallback(elist->list.item_box, XmNdoubleClickCallback,
							DoubleClickDoCallback, (XtPointer) w);
			break;
		case ResCol :
			XtAddCallback(elist->list.rclist, XtNhighlightCallback,
						HighlightDoCallback, (XtPointer) w);
			XtAddCallback(elist->list.rclist, XmNdoubleClickCallback,
						DoubleClickDoCallback, (XtPointer) w);
			XtAddCallback(elist->list.rclist, XmNlrcResizeCallback,
						ResizeRCCallback, (XtPointer) w);
			break ;
		case ListTree :
			XtAddCallback(elist->list.rclist, XtNhighlightCallback,
						HighlightDoCallback, (XtPointer) w);
			XtAddCallback(elist->list.rclist, XmNdoubleClickCallback,
						DoubleClickDoCallback, (XtPointer) w);
			break ;
		default :
			return;
	}
}


static void CreateViewWidget (Widget w, ArgList args, Cardinal num_args)
{
    XmNlListWidget elist = (XmNlListWidget) w;

	if (elist->list.ViewListType != XmNlList_Big && elist->list.ViewListType != XmNlList_Small)
		elist->list.item_box = XtCreateWidget("itembox", xmNlItemBoxWidgetClass, w, NULL, 0);

	if (elist->list.ViewListType == XmNlList_Big)
		elist->list.item_box = XtVaCreateManagedWidget("itembox", xmNlItemBoxWidgetClass, w,
														XmNviewType, XmLARGE_ICON, NULL);
	if	(elist->list.ViewListType == XmNlList_Small)
		elist->list.item_box = XtVaCreateManagedWidget("itembox", xmNlItemBoxWidgetClass, w,
														XmNviewType, XmSMALL_ICON, NULL);
	if (args)
		XtSetValues(elist->list.item_box, args, num_args);

	if (elist->list.ViewListType == XmNlList_Big || elist->list.ViewListType == XmNlList_Small)
	{
#ifdef DEBUG
		printf("\n XmNlList: item_box created at start\n");
#endif
		AttachCallbacks(w, ItemBox);
			
		XtVaSetValues(elist->list.item_box, XmNverticalScrollBar, elist->list.v_bar,
					XmNhorizontalScrollBar, elist->list.h_bar, NULL);

		elist->list.ItemBoxScrollsFound = True;
		
		if (elist->list.h_bar)
			XtVaSetValues(elist->list.h_bar, XmNmaximum, 1, XmNsliderSize, 1, XmNvalue, 0, NULL);
	}

/*************************************************************************************************/
	

	if (elist->list.ViewListType != XmNlList_Detail && elist->list.ViewListType != XmNlList_TreeCol
		&& elist->list.ViewListType != XmNlList_Tree)
	{
    	elist->list.rclist = XtVaCreateWidget ("rescol", xmNlResColListWidgetClass, w, 
//														XmNnumCols, elist->list.num_cols,
//														XmNrenderTable, elist->list.font_list,
														NULL);

#ifdef DEBUG
		printf("\n XmNlList: rescol created in DETAIL mode at start not managed\n");
		fflush(stdout);
#endif
	}

/******************* RC List start ***************************/
	if (elist->list.ViewListType == XmNlList_Detail)
	{

/*    	elist->list.rclist = XtCreateManagedWidget ("rescol", xmNlResColListWidgetClass, w, args, num_args);*/
    	elist->list.rclist = XtVaCreateManagedWidget ("rescol", xmNlResColListWidgetClass, w, 
//														XmNnumCols, elist->list.num_cols,
//														XmNrenderTable, elist->list.font_list,
														NULL);

#ifdef DEBUG
		printf("\n XmNlList: rescol created in DETAIL mode at start\n");
		fflush(stdout);
#endif
		AttachCallbacks(w, ResCol);

		XtVaSetValues(elist->list.rclist, XmNverticalScrollBar,
						elist->list.v_bar, XmNhorizontalScrollBar, elist->list.h_bar, NULL);

		if (elist->list.h_bar != NULL) {
			XtAddCallback(elist->list.h_bar, XmNvalueChangedCallback,
						HScrollCallback, (XtPointer) w);
			XtAddCallback(elist->list.h_bar, XmNdragCallback,
						HScrollCallback, (XtPointer) w);
		}

#ifdef DEBUG
		printf("\n XmNlList: scrollbar to rclist added\n");
		fflush(stdout);
#endif
		elist->list.ResColScrollsFound = True;
	}
/**************************** RClist end *********************************/

/**************************** ListTree start *****************************/
	if (elist->list.ViewListType == XmNlList_Tree)
	{
		elist->list.rclist = XtVaCreateManagedWidget ("rescol", xmNlResColListWidgetClass, w,
														XmNlTreeMode, True, 
														NULL);
#ifdef DEBUG
		printf("\n XmNlList: tree created in TREE mode at start\n");
		fflush(stdout);
#endif

		XtVaSetValues(elist->list.rclist, XmNverticalScrollBar,
					elist->list.v_bar, XmNhorizontalScrollBar, elist->list.h_bar, NULL);
		elist->list.ResColScrollsFound = True;

#ifdef DEBUG
		printf("\n XmNlList: scrollbar to tree added\n");
		fflush(stdout);
#endif

		AttachCallbacks(w, ListTree);
	}
/**************************** ListTree end  ******************************/

/********************* ListTree Multi Column start ***********************/
	if (elist->list.ViewListType == XmNlList_TreeCol)
	{
		elist->list.rclist = XtVaCreateManagedWidget ("rescol", xmNlResColListWidgetClass, w,
														XmNlTreeMode, True, 
//														XmNnumCols, elist->list.num_cols,
														NULL);
#ifdef DEBUG
		printf("\n XmNlList: tree created in TREE_COL mode at start\n");
		fflush(stdout);
#endif

		XtVaSetValues(elist->list.rclist, XmNverticalScrollBar,
					elist->list.v_bar, XmNhorizontalScrollBar, elist->list.h_bar, NULL);
		elist->list.ResColScrollsFound = True;

#ifdef DEBUG
		printf("\n XmNlList: scrollbar to tree added\n");
		fflush(stdout);
#endif

		AttachCallbacks(w, ResCol);
	}
/********************* ListTree Multi Column end ***********************/
}


static void RecreateViewWidget (Widget w, ArgList args, Cardinal num_args, char lastViewMode)
{
    XmNlListWidget elist = (XmNlListWidget) w;

#ifdef DEBUG
	printf("RecreateViewWidget %hhx\n", elist->list.ViewListType);
#endif
/*** First step - detach ScrollBar callback proc for all widgets   ***/

	DetachScrollCallbacks(w);


/*** Second step - clening all not active widgets                   ***/

	if ((elist->list.ViewListType != XmNlList_Big && lastViewMode == XmNlList_Big) || 
		(elist->list.ViewListType != XmNlList_Small && lastViewMode == XmNlList_Small))

	{
		XmNlItBoxDeleteAllItems(elist->list.item_box);
	}

	if (elist->list.ViewListType != XmNlList_Big && elist->list.ViewListType != XmNlList_Small && 
		(lastViewMode == XmNlList_Small || lastViewMode == XmNlList_Big))
	{
#ifdef DEBUG
		printf("========Detach itembox callbacks\n");
#endif
		DetachCallbacks(w, ItemBox);
	}

	if (elist->list.ViewListType != XmNlList_Detail && lastViewMode == XmNlList_Detail)
	{
		XmNlResColDeleteAllRows(elist->list.rclist);
#ifdef DEBUG
		printf("========rclist delete all rows data\n");
#endif
		XmNlResColCleanAllColumns(elist->list.rclist);
#ifdef DEBUG
		printf("========rclist clean all columns\n");
#endif
		DetachCallbacks(w, ResCol);
#ifdef DEBUG
		printf("========Detach rclist callbacks\n");
#endif
	}

	if (elist->list.ViewListType != XmNlList_TreeCol && lastViewMode == XmNlList_TreeCol)
	{
#ifdef DEBUG
		printf("========rclist next time delete all tree data\n");
#endif
		XmNlRCTreeDeleteAllItems(elist->list.rclist);
#ifdef DEBUG
		printf("========rclist delete all tree data\n");
#endif
		XmNlResColCleanAllColumns(elist->list.rclist);
#ifdef DEBUG
		printf("========rclist clean all columns\n");
#endif
		DetachCallbacks(w, ResCol);
#ifdef DEBUG
		printf("========Detach rclist callbacks\n");
#endif
	}

	if (elist->list.ViewListType != XmNlList_Tree && lastViewMode == XmNlList_Tree)
	{
#ifdef DEBUG
		printf("========rclist next time delete all tree data\n");
#endif
		XmNlRCTreeDeleteAllItems(elist->list.rclist);
#ifdef DEBUG
		printf("========rclist delete all tree data\n");
#endif
		XmNlResColCleanAllColumns(elist->list.rclist);
#ifdef DEBUG
		printf("========rclist clean all columns\n");
#endif
		DetachCallbacks(w, ListTree);
#ifdef DEBUG
		printf("========Detach listtree callbacks\n");
#endif
	}

	elist->list.ListEmpty = True;

/*** Next step - switch to unmanaged state all not active widgets ***/
	if (elist->list.ViewListType != XmNlList_Big && elist->list.ViewListType != XmNlList_Small)
	{
#ifdef DEBUG
		printf("========itembox 1\n");
#endif
		if (elist->list.item_box != NULL)
		{

			if (XtIsManaged(elist->list.item_box))
			{
				XtUnmanageChild(elist->list.item_box);
			}
		}
	}

	if (elist->list.ViewListType != XmNlList_Detail && elist->list.ViewListType != XmNlList_TreeCol &&
		elist->list.ViewListType != XmNlList_Tree)
	{
#ifdef DEBUG
		printf("========rclist 1\n");
#endif
		if (elist->list.rclist != NULL)
		{
			if (XtIsManaged(elist->list.rclist))
			{
				XtUnmanageChild(elist->list.rclist);
			}
		}
	}

/*** Next step - switch to managed state all active widgets ************/

/********************* Big or Small List start *************************/
	if (elist->list.ViewListType == XmNlList_Big || elist->list.ViewListType == XmNlList_Small)
	{
		if (elist->list.ViewListType == XmNlList_Big)
			XtVaSetValues(elist->list.item_box, XmNviewType, XmLARGE_ICON, NULL);
		else
			XtVaSetValues(elist->list.item_box, XmNviewType, XmSMALL_ICON, NULL);

		if (args)
			XtSetValues(elist->list.item_box, args, num_args);
		if (!XtIsManaged(elist->list.item_box))
		{
			XtManageChild(elist->list.item_box);
			AttachCallbacks(w, ItemBox);
		
			if (!elist->list.ItemBoxScrollsFound)
			{
				XtVaSetValues(elist->list.item_box, XmNverticalScrollBar, elist->list.v_bar,
							XmNhorizontalScrollBar, elist->list.h_bar, NULL);
				elist->list.ItemBoxScrollsFound = True;
			}
			else
				_XmNlItBoxAddScrolls(elist->list.item_box);
		}

		if (elist->list.h_bar)
			XtVaSetValues(elist->list.h_bar, XmNmaximum, 1, XmNsliderSize, 1, XmNvalue, 0, NULL);
#ifdef DEBUG
		printf("\n XmNlList: scrollbar to item_box added\n");
		fflush(stdout);
#endif
	}
/******************* Big or Small list end  ***************************/

	
/******************* RC List start ***************************/
	if (elist->list.ViewListType == XmNlList_Detail)
	{
		if (elist->list.rclist != NULL)
		{
			XtVaSetValues(elist->list.rclist, 
//							XmNnumCols, elist->list.num_cols,
							XmNlTreeMode, False, 
							NULL);
			AttachCallbacks(w, ResCol);

			if (!XtIsManaged(elist->list.rclist)) 
			{
				XtManageChild(elist->list.rclist);
			}

			if (!elist->list.ResColScrollsFound)
			{
				XtVaSetValues(elist->list.rclist, XmNverticalScrollBar,
							elist->list.v_bar, XmNhorizontalScrollBar, elist->list.h_bar, NULL);
				elist->list.ResColScrollsFound = True;
#ifdef DEBUG
				printf("\n XmNlList: scrollbar to rclist added\n");
#endif
			}
			else
				_XmNlResColAddScrolls(elist->list.rclist);
			
		}
		if (elist->list.h_bar != NULL) {
			XtAddCallback(elist->list.h_bar, XmNvalueChangedCallback,
						HScrollCallback, (XtPointer) w);
			XtAddCallback(elist->list.h_bar, XmNdragCallback,
						HScrollCallback, (XtPointer) w);
		}
	}
/**************************** RClist end *********************************/

/**************************** ListTree start *****************************/
	if (elist->list.ViewListType == XmNlList_Tree || elist->list.ViewListType == XmNlList_TreeCol)
	{
		if (elist->list.rclist != NULL)
		{
			if (!XtIsManaged(elist->list.rclist))
			{
				XtManageChild(elist->list.rclist);
			}

			if (!elist->list.ResColScrollsFound)
			{
				XtVaSetValues(elist->list.rclist, XmNverticalScrollBar,
							elist->list.v_bar, XmNhorizontalScrollBar, elist->list.h_bar, NULL);
				elist->list.ResColScrollsFound = True;
#ifdef DEBUG
				printf("\n XmNlList: scrollbar to rclist added\n");
#endif
			}
			else
				_XmNlResColAddScrolls(elist->list.rclist);

		}

		if (elist->list.rclist)
			XtVaSetValues(elist->list.rclist,
							XmNlTreeMode, True, 
							NULL);
#ifdef DEBUG
		printf("\n ^^^^^^^^^^^^^^^^^^^^^^^^^^^\t\t\t\tXmNlList: tree managed and set XmNlTreeMode\n");
		fflush(stdout);
#endif

		if (elist->list.ViewListType == XmNlList_TreeCol)
		{
			AttachCallbacks(w, ResCol);
			if (elist->list.h_bar != NULL) {
				XtAddCallback(elist->list.h_bar, XmNvalueChangedCallback,
							HScrollCallback, (XtPointer) w);
				XtAddCallback(elist->list.h_bar, XmNdragCallback,
							HScrollCallback, (XtPointer) w);
			}
		}

		if (elist->list.ViewListType == XmNlList_Tree)
		{
			AttachCallbacks(w, ListTree);
		}
	}
/****************** Tree list end *******************/
}



static int 
XYtoEdgePos(Widget w, Position x, Position y)
{
    XmNlListWidget elist = (XmNlListWidget) w;
	int i, x1, y1, ret;
	ListTbarCell * cell = elist->list.tbar_item;

	ret = -1;

	if (y < elist->list.TBviewY || y > elist->list.TBviewY + elist->list.TBviewHeight)
		return ret;

	if (elist->list.render_order == LtoR_render) 
	{
		x1 = x - elist->list.TBviewX + elist->list.h_shift;
	}
	else
	{
		x1 = elist->list.TBviewX + elist->list.TBviewWidth - x + elist->list.h_shift;
	}

#ifdef DEBUG
			printf("XYtoEdgePos: x1 = %d \n", x1);
#endif
	for (i = 0; i < elist->list.num_cols; i++)
	{
		if ((cell[i].x + cell[i].current_width - elist->list.h_shift) < 0)
			continue ;
			
		if ((cell[i].x + cell[i].current_width - elist->list.h_shift) > elist->list.TBviewWidth)
			break;
			
			
		if ((cell[i].x + cell[i].current_width + 1) > x1 && (cell[i].x + cell[i].current_width - 3) < x1)
		{
			ret = i;
#ifdef DEBUG
			printf("XYtoEdgePos: col = %d pos = %d x1 = %d x = %d\n", i, x1, cell[i].x + cell[i].current_width);
#endif
			break ;
		}
	}	

#ifdef DEBUG
			printf("XYtoEdgePos: col = %d pos = %d x1 = %d x = %d\n", i, ret, x1, cell[i].x + cell[i].current_width);
#endif

	return ret;
}

static int 
XYtoCellPos(Widget w, Position x, Position y)
{
    XmNlListWidget elist = (XmNlListWidget) w;
	int i, x1, y1, ret;
	ListTbarCell * cell = elist->list.tbar_item;

	ret = -1;

	if (y < elist->list.TBviewY || y > elist->list.TBviewY + elist->list.TBviewHeight)
		return ret;

	if (elist->list.render_order == LtoR_render) 
	{
		x1 = x - elist->list.TBviewX + elist->list.h_shift;
	}
	else
	{
		x1 = elist->list.TBviewX + elist->list.TBviewWidth - x + elist->list.h_shift;
	}

#ifdef DEBUG
			printf("XYtoEdgePos: x1 = %d \n", x1);
#endif
	for (i = 0; i < elist->list.num_cols; i++)
	{
		if ((cell[i].x + cell[i].current_width - elist->list.h_shift) < 0)
			continue ;
			
		if ((cell[i].x - elist->list.h_shift) > elist->list.TBviewWidth)
			break;
#ifdef DEBUG
			printf("XYtoCellPos: col = %d x1 = %d cell_x = %d cell_width = %d shift %d TbWidth = %d\n", i, x1, cell[i].x, cell[i].current_width,
			elist->list.h_shift, elist->list.TBviewWidth);
#endif
			
			
		if ((cell[i].x + 2) < x1 && (cell[i].x + cell[i].current_width - 3) > x1)
		{
			ret = i;
#ifdef DEBUG
			printf("XYtoCellPos: col = %d x1 = %d x = %d\n", i, x1, cell[i].x + cell[i].current_width);
#endif
			break ;
		}
	}	

#ifdef DEBUG
			printf("XYtoEdgePos: col = %d pos = %d x1 = %d x = %d\n", i, ret, x1, cell[i].x + cell[i].current_width);
#endif

	return ret;
}



static Boolean 
ResizerOutOfRang(Widget w, Position x)
{
    XmNlListWidget elist = (XmNlListWidget) w;
	int i, k, x1, x2, x3, x4 = 0;
	Boolean ret;
	ListTbarCell * cell = elist->list.tbar_item;

	ret = FALSE;

	x1 = elist->list.TBviewX;
	x3 = elist->list.TBviewX + elist->list.TBviewWidth;
	k = elist->list.TbCurrentResizedPos;

//	x2 = pres->partres.viewX - pres->partres.global_h_shift;

	if (elist->list.render_order == LtoR_render) 
	{
		x2 = x - elist->list.TBviewX + elist->list.h_shift;
	}
	else
	{
		x2 = elist->list.TBviewX + elist->list.TBviewWidth - x + elist->list.h_shift;
	}
	
	for (i = 0; i < k; i++)
	{
		x4 = x4 + cell[i].current_width;
	}
	x4 = x4 + RS_LIMIT;	
	if (x < x1 || x2 < x4 || x > x3) 
		ret = TRUE;

	return ret;
}

static void	DoResizeColumnInRCWidget(Widget w, int pos)
{
    XmNlListWidget elist = (XmNlListWidget) w;
	ListTbarCell * cell = elist->list.tbar_item;
	int i, x1, new_size, autores;
	Dimension *cols_size;


	if (!cell)
		return ;

	if (elist->list.autores >= 0) 
		autores = elist->list.autores;
	else
		autores = elist->list.num_cols - 1;


	if (elist->list.render_order == LtoR_render) 
		x1 = pos + elist->list.h_shift;
	else
		x1 = elist->list.TBviewWidth - pos + elist->list.h_shift;

	new_size = x1 - cell[elist->list.TbCurrentResizedPos].x;
	

#ifdef DEBUG
	for (i = 0; i < elist->list.num_cols; i++)
	{
		printf("MoveDoCallback: col=%d x=%d width=%d\n", 
					i, cell[i].x, cell[i].current_width);		
	}

	printf("MoveDoCallback: col=%d shift=%d pos=%d x=%d x1=%d new_size=%d\n", 
				elist->list.TbCurrentResizedPos, elist->list.h_shift, pos,
				cell[elist->list.TbCurrentResizedPos].x, x1, ret.new_size);		
#endif

	x1 = 0;
	for (i = 0; i < elist->list.num_cols; i++)
	{
		if (i == elist->list.TbCurrentResizedPos) 
			x1 = x1 + new_size;
		else
			x1 = x1 + (cell+i)->current_width;	
	}
	
	if (x1 < elist->list.TBviewWidth)
		return ;
	
	if (new_size > 10)
	{
		cols_size = (Dimension *) XtMalloc(elist->list.num_cols * sizeof(Dimension));
#ifdef DEBUG
		printf("\n@@@@@@ Position=%d New size=%d columns %d\n", pos, new_size, cols_num);
#endif

		cell[elist->list.TbCurrentResizedPos].current_width = new_size;
		x1 = 0;
		for (i = 0; i < elist->list.num_cols; i++)
		{
			cols_size[i] = 0;
			cell[i].x = x1;
			x1 = x1 + cell[i].current_width;
		}
		cols_size[elist->list.TbCurrentResizedPos] = (Dimension) new_size;

		if (elist->list.TbCurrentResizedPos == autores) 
			elist->list.AuotoResChanged = True;
		if (elist->list.ViewListType == XmNlList_Detail) RCSetColSize(elist->list.rclist, cols_size);
		if (elist->list.ViewListType == XmNlList_TreeCol) RCSetColSize(elist->list.rclist, cols_size);
		
		elist->list.TBfullTilesWidth = x1;
		
		RedrawTitleBarOnly(w);
	}

	return ;
}


static void
DoCallbackTileActivate(Widget w, int number)
{
    XmNlListWidget elist = (XmNlListWidget) w;
    static ListTileActivateReturnStruct ret;
	int i;

	ret.reason = XmNlTileClicked;
	ret.col_number = number;
	ret.status = elist->list.tbar_item[i].markedStatus;


	if (elist->list.tileClick) {

		XtCallCallbacks(w, XmNlTileClickedCallback, (XtPointer) &ret);

	}
}


static void ButtonDownAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmNlListWidget elist = (XmNlListWidget) w;
    XButtonEvent * bevent = (XButtonEvent *) event;
	int i, x1, y1;
	Boolean resized = False;
	Position x, y;

	if (elist->list.ViewListType != XmNlList_Detail && elist->list.ViewListType != XmNlList_TreeCol)
		return ;
	
	if (elist->list.num_cols == 0 || elist->list.ListEmpty)
		return ;

	x = bevent->x;
	y = bevent->y;
#ifdef DEBUG
	printf(">>>>>>>\nButtonDownAction\n");
#endif

	i = XYtoCellPos(w, x, y);
	if (i >= 0)
	{
		elist->list.tbar_item[i].armed = True;
		InternRedisplayTitleBar(w);
	}
	
	if (elist->list.TbResizeState == True)
	{
		elist->list.TbLastResizerPos = x;
		elist->list.TbStartResizerPos = x;
	}

	return;
}

static void ButtonMotionAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmNlListWidget elist = (XmNlListWidget) w;
    XButtonEvent * bevent = (XButtonEvent *) event;
	int i, x1, y1;
	Boolean resized = False;
	Position x, y;
	ListTbarCell * cell = elist->list.tbar_item;
	x = bevent->x;
	y = bevent->y;


	if (elist->list.ViewListType != XmNlList_Detail && elist->list.ViewListType != XmNlList_TreeCol)
		return ;
	
	if (elist->list.num_cols == 0 || elist->list.ListEmpty)
		return ;



	if (elist->list.TbResizeState == True && x != elist->list.TbLastResizerPos && !ResizerOutOfRang(w, x))
	{
		
		elist->list.TbLastResizerPos = x;
		
		if (elist->list.rclist) 
		{
			DoResizeColumnInRCWidget(w, x - elist->list.TBviewX);
		}
	}
#ifdef DEBUG
	printf(">>>>>>>\nButtonMotionAction\n");
#endif
}


static void MouseMotionAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmNlListWidget elist = (XmNlListWidget) w;
	XMotionEvent *me;
	int i, x1, y1;
	Boolean resized = False;
	Position x, y;
	ListTbarCell * cell = elist->list.tbar_item;
	
	
	if (elist->list.ViewListType != XmNlList_Detail && elist->list.ViewListType != XmNlList_TreeCol)
		return ;
	
	if (elist->list.num_cols == 0 || elist->list.ListEmpty)
		return ;

	if (event->type != MotionNotify) 
		return;

		
	me = (XMotionEvent *) event;

	x = me->x;
	y = me->y;

	i = XYtoEdgePos(w, x, y);

	if ( i >= 0 && i != elist->list.num_cols - 1)
	{
		elist->list.TbCurrentResizedPos = i;
		if (elist->list.TbResizeState != True)
			XDefineCursor(XtDisplay(w), XtWindow(w), elist->list.hResizeCursor);
		elist->list.TbResizeState = True;
		resized = True;
	}

	if (elist->list.TbResizeState == True && resized == False)
	{
		elist->list.TbResizeState = False;
		XUndefineCursor(XtDisplay(w), XtWindow(w));
		elist->list.TbCurrentResizedPos = -1;
	}
#ifdef DEBUG
	printf(">>>>>>>\nMouseMotionAction\n");
#endif
}


static void ButtonUpAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmNlListWidget elist = (XmNlListWidget) w;
    XButtonEvent * bevent = (XButtonEvent *) event;
	int i, x1, y1;
	Boolean resized = False;
	Position x, y;
	ListTbarCell * cell = elist->list.tbar_item;

	if (elist->list.ViewListType != XmNlList_Detail && elist->list.ViewListType != XmNlList_TreeCol)
		return ;
	
	if (elist->list.num_cols == 0 || elist->list.ListEmpty)
		return ;

	x = bevent->x;
	y = bevent->y;

#ifdef DEBUG
	printf("\nButtonUpAction\n");
#endif

	i = XYtoCellPos(w, x, y);
	if (i >= 0)
	{
		elist->list.tbar_item[i].armed = False;
		if (i == elist->list.markedColNumber)
		{
			if (elist->list.tbar_item[i].markedStatus == XmARROW_UP)
				elist->list.tbar_item[i].markedStatus = XmARROW_DOWN;
			else
				if (elist->list.tbar_item[i].markedStatus == XmARROW_DOWN)
					elist->list.tbar_item[i].markedStatus = XmARROW_UP;
		}
		DoCallbackTileActivate(w, i);
		InternRedisplayTitleBar(w);
//		DoCallbackTileActivate(w, i);
	}

	if (elist->list.TbResizeState==True)
	{
		XUndefineCursor(XtDisplay(w), XtWindow(w));
        elist->list.TbResizeState = False;
		i = elist->list.TbCurrentResizedPos;
		elist->list.TbCurrentResizedPos = -1;
	}
#ifdef DEBUG
	for (i = 0; i < elist->list.num_cols; i++)
	{
			printf("PR ButtonUpAction: col=%d x=%d width=%d\n", i, cell[i].x, cell[i].current_width);
	}
#endif

	return;
#ifdef DEBUG
	printf(">>>>>>>\nButtonUpAction\n");
#endif
}



/************************************************************
 *
 * Functions that Create Widgets.
 *
 ************************************************************/


/*	Function Name: CreateScrollbar
 *	Description:   Creates a vert or horizontal scrollbar.
 *	Arguments:     parent - parent of the scrollbar widget.
 *                     is_vert - if true then create a vertical scrollbar,
 *                               else, create a horiz one.
 *                     args, num_args - arguments used to create ext list.
 *	Returns:       none
 */

static Widget
CreateScrollbar(Widget parent, Boolean is_vert, ArgList args, Cardinal num_args)
{
	Widget w;
	Arg *new_args, largs[5];
	Cardinal num_largs = 0;
	String name;

	if (is_vert) {
		XtSetArg(largs[num_largs], XmNorientation, XmVERTICAL);
		name = "vertBar";
	}
	else {
		XtSetArg(largs[num_largs], XmNorientation, XmHORIZONTAL);
		name = "horizBar";
	}
	num_largs++;

	XtSetArg(largs[num_largs], XmNmaximum, 1);
	num_largs++;
	XtSetArg(largs[num_largs], XmNsliderSize, 1);
	num_largs++;
	XtSetArg(largs[num_largs], XmNvalue, 0);
	num_largs++;
	
	new_args = XtMergeArgLists(args, num_args, largs, num_largs);

    w = XtCreateManagedWidget(name, xmScrollBarWidgetClass, parent,
			      new_args, num_args + num_largs);

    XtFree((XtPointer) new_args);

    return(w);
}

void XmNlListMoveColumnTo(Widget w, int col, int position)
{
    XmNlListWidget elist = (XmNlListWidget) w;
    int i, tmp_x = 0;
	
	memcpy(elist->list.tbar_item_last, elist->list.tbar_item, sizeof(ListTbarCell) * elist->list.num_cols);

	memcpy(elist->list.tbar_item + position, elist->list.tbar_item_last + col, sizeof(ListTbarCell));
	
	if (col < position)
		memcpy(elist->list.tbar_item + col, elist->list.tbar_item_last + col + 1, sizeof(ListTbarCell) * (position - col));
	else
		memcpy(elist->list.tbar_item + position + 1, elist->list.tbar_item_last + position, sizeof(ListTbarCell) * (col - position));
		
	for (i = 0; i < elist->list.num_cols; i++)
	{
		elist->list.tbar_item[i].x = tmp_x;
		tmp_x = elist->list.tbar_item[i].current_width;
	}
	RedrawTitleBarOnly(w);
	return ;
}

/************************************************************
 *
 * Public Functions.
 *
 ************************************************************/
void XmNlListDeletAllInfo(Widget w)
{
    XmNlListWidget elist = (XmNlListWidget) w;

	if (elist->list.ViewListType == XmNlList_Big || elist->list.ViewListType == XmNlList_Small)
		XmNlItBoxDeleteAllItems(elist->list.item_box);
	if (elist->list.ViewListType == XmNlList_Detail)
	{
		XmNlResColDeleteAllRows(elist->list.rclist);
		elist->list.ListEmpty = True;
	}
	if (elist->list.ViewListType == XmNlList_Tree || elist->list.ViewListType == XmNlList_TreeCol)
	{
		XmNlRCTreeDeleteAllItems(elist->list.rclist);
		elist->list.ListEmpty = True;
	}
	elist->list.highlightCount = 0;
	elist->list.highlightCell = NULL;
	return;
}

int XmNlListXYtoPos(Widget w, unsigned long x, unsigned long y)
{
    XmNlListWidget elist = (XmNlListWidget) w;
	int n;

	if (elist->list.ViewListType == XmNlList_Big || elist->list.ViewListType == XmNlList_Small)
		n = XmNlItBoxXYtoPos(elist->list.item_box, x, y);
	if (elist->list.ViewListType == XmNlList_Detail)
		n = RCXYtoRow(elist->list.rclist, x, y);

	return n;
}

Boolean XmNlListGetItem(Widget w, XmNlCell *cell, unsigned char valuemask, int position)
{
    XmNlListWidget elist = (XmNlListWidget) w;
    Boolean ret;

	if (elist->list.ViewListType == XmNlList_Big || elist->list.ViewListType == XmNlList_Small)
		ret = XmNlItBoxGetItem(elist->list.item_box, cell, valuemask, position);

	if (elist->list.ViewListType == XmNlList_Detail)
		ret = XmNlResColGetItem(elist->list.rclist, cell, valuemask, position);

	return ret;
}

XmNlCell * XmNlListGetSelCells(Widget w, int *count)
{
    XmNlListWidget elist = (XmNlListWidget) w;
	XmNlCell * Cl = NULL;
	if (elist->list.ViewListType == XmNlList_Big || elist->list.ViewListType == XmNlList_Small)
		XmNlItBoxGetSelectedItems(elist->list.item_box, count, NULL);
//		return;
	if (elist->list.ViewListType == XmNlList_Detail)
		Cl = RCGetSelectedCells(elist->list.rclist, count);
//		RCGetSelectedCells(elist->list.rclist, count, Cl);
//	printf("+++++++++++xmnl selsel %s", Cl[0].UserDataPointer);
//	fflush(stdout);
//	Cells=Cl;
	return Cl;
}


void XmNlListAddItems(Widget w, XmNlCell * items, int count, unsigned char valuemask)
{
    XmNlListWidget elist = (XmNlListWidget) w;

	if (elist->list.ViewListType != XmNlList_Big && elist->list.ViewListType != XmNlList_Small) return ;
	if (elist->list.item_box) XmNlItBoxAddItems(elist->list.item_box, items, count, valuemask);

#ifdef DEBUG
	printf("XmNlListAddItems complete \n");
	fflush(stdout);
#endif
	return;
}


Widget XmNlListGetRCWidget(Widget w)
{
    XmNlListWidget elist = (XmNlListWidget) w;



	return elist->list.rclist;


}

Widget XmNlListGetIBWidget(Widget w)
{
    XmNlListWidget elist = (XmNlListWidget) w;



	return elist->list.item_box;


}


void XmNlListAddRows(Widget w, XmNlCell * cell, int row_count, unsigned char valuemask)
{
    XmNlListWidget elist = (XmNlListWidget) w;

	if (elist->list.ViewListType != XmNlList_Detail) 
		return ;
	if (elist->list.rclist) XmNlResColAddRows(elist->list.rclist, cell, row_count, valuemask);

//	if (elist->list.ListEmpty) XtVaSetValues(elist->list.title_bar, XmNchangePartOn, True, NULL);
	elist->list.ListEmpty = False;
/*	LayoutChildren(w);
    if (XtIsRealized (w))
    {
        XClearArea(XtDisplay(w), XtWindow(w), 0, 0,
            XtWidth(w),XtHeight(w), True);

    }*/

	return;
}

void XmNlListDeleteRow(Widget w, int position)
{
    XmNlListWidget elist = (XmNlListWidget) w;
    int row_count;

	if (elist->list.ViewListType != XmNlList_Detail) return ;
	if (elist->list.rclist) XmNlResColDeleteRows(elist->list.rclist, position, 1);

	XtVaGetValues(elist->list.rclist, XmNitemCount, &row_count, NULL);

	if (!row_count)
	{
		elist->list.ListEmpty = True;
		LayoutChildren(w);
		if (XtIsRealized (w))
		{
			XClearArea(XtDisplay(w), XtWindow(w), 0, 0, XtWidth(w),XtHeight(w), True);
		}
	}
	return;
}

void XmNlListInsertRow(Widget w, XmNlCell * cell, int row_pos, unsigned char valuemask)
{
    XmNlListWidget elist = (XmNlListWidget) w;

	if (elist->list.ViewListType != XmNlList_Detail) return ;
	if (elist->list.rclist) XmNlResColInsertRow(elist->list.rclist, cell, row_pos, valuemask);
    elist->list.ListEmpty = False;
	LayoutChildren(w);

	return;
}


void XmNlListSetAutoresCol(Widget w, int n)
{
    XmNlListWidget elist = (XmNlListWidget) w;

    elist->list.autores = n;

	if (elist->list.ViewListType == XmNlList_Detail && elist->list.rclist) 
		RCSetAutoresCol(elist->list.rclist, n);

	return ;

}

void RCSetCell(Widget , int , int , XmNlCell * , unsigned char );

void XmNlListSetCell(Widget w, XmNlCell * cell_data, unsigned char valuemask, int row, int col)
{
    XmNlListWidget elist = (XmNlListWidget) w;

	if (elist->list.ViewListType == XmNlList_Detail)
		RCSetCell(elist->list.rclist, row, col, cell_data, valuemask);
	return ;

}

void XmNlListSetSelectedItems(Widget w, int num, int* data)
{
	XmNlListWidget elist = (XmNlListWidget) w;

	RCSetSelectedItems(elist->list.rclist, num, data);
}

void XmNlListSetFrozenStatus(Widget w, Boolean status)
{
    XmNlListWidget elist = (XmNlListWidget) w;
    XmNlResColListWidget rcol = (XmNlResColListWidget) elist->list.rclist;
	Dimension * col_width;
//	Dimension col_width[10];
	int i;

	XtVaSetValues(elist->list.rclist, XmNlayoutFrozen, status, NULL);
	if (status==FALSE)
	{
		i = rcol->rescol.num_cols;
#ifdef DEBUG
		printf("\n   @@@@@@@@@ XmNlList i = %d\n", i);
#endif
		col_width = (Dimension *) XtMalloc(i * sizeof(Dimension));
//		for (i=0; i < elist->list.col_num; i++)
//		{
			RCGetColsWidth(elist->list.rclist, col_width);
#ifdef DEBUG
		printf("\n   @@@@@@@@@ XmNlList 0 = %d\n", col_width[0]);
		printf("\n   @@@@@@@@@ XmNlList 1 = %d\n", col_width[1]);
		printf("\n   @@@@@@@@@ XmNlList 2 = %d\n", col_width[2]);
		printf("\n   @@@@@@@@@ XmNlList 3 = %d\n", col_width[3]);
#endif
//			PRSetCellsWidth(elist->list.title_bar, col_width);
//		}

	}
	return ;

}


XmNlListTreeItem *XmNlListTreeAddBranch (Widget w, XmNlListTreeItem *parent, XmNlCell *cell, unsigned char valuemask)
{
    XmNlListWidget elist = (XmNlListWidget) w;
	XmNlListTreeItem * item;

	if (elist->list.ViewListType == XmNlList_Tree || elist->list.ViewListType == XmNlList_TreeCol)
	{
		item=XmNlRCTreeAddBranch (elist->list.rclist, parent, cell, valuemask);
//		XmNlRCTreeRefresh(elist->list.rclist);
//		elist->list.ListEmpty = False;
	}
	return item;
}

XmNlListTreeItem *XmNlListTreeAddLeaf (Widget w, XmNlListTreeItem *parent, XmNlCell *cell, unsigned char valuemask)
{
    XmNlListWidget elist = (XmNlListWidget) w;
	XmNlListTreeItem * item;

	if (elist->list.ViewListType == XmNlList_TreeCol)
	{
		item=XmNlRCTreeAddLeaf (elist->list.rclist, parent, cell, valuemask);
//		XmNlRCTreeRefresh(elist->list.rclist);
//		elist->list.ListEmpty = False;
	}
	return item;
}


/*XmNlListTreeItem *XmNlListTreeAddBranchOpt (Widget w, XmNlListTreeItem *parent, char *string, XmNlCell * data)
{
    XmNlListWidget elist = (XmNlListWidget) w;
	XmNlListTreeItem * item;

	if (elist->list.ViewListType == XmNlList_TreeCol)
		item=XmNlTreeAddBranchOpt (elist->list.tree, parent, string, data);
	return item;
}

XmNlListTreeItem *XmNlListTreeAddLeaf (Widget w, XmNlListTreeItem *parent, char *string)
{
    XmNlListWidget elist = (XmNlListWidget) w;
	XmNlListTreeItem * item;

	if (elist->list.ViewListType == XmNlList_Tree)
		item=XmNlTreeAddLeaf (elist->list.tree, parent, string);
	return item;
}
*/


void XmNlListTreeRefresh(Widget w)
{
    XmNlListWidget elist = (XmNlListWidget) w;

	if (elist->list.ViewListType == XmNlList_Tree || elist->list.ViewListType == XmNlList_TreeCol)
		XmNlRCTreeRefresh(elist->list.rclist);

//	if (elist->list.ListEmpty && elist->list.title_bar) 
//		XtVaSetValues(elist->list.title_bar, XmNchangePartOn, True, NULL);

	elist->list.ListEmpty = False;
//		LayoutChildren(w);
	return;
}

static void RefreshHScroll(XmNlListWidget elist, int list_w, Dimension view_w, int value)
{
	if (!elist->list.h_bar)
		return ;

	if (list_w > view_w)
	{
		XtVaSetValues(elist->list.h_bar, XmNmaximum, list_w, XmNsliderSize, view_w,
						XmNvalue, value, NULL);
	}
	else
	{
		XtVaSetValues(elist->list.h_bar, XmNmaximum, view_w, XmNsliderSize, list_w,
						XmNvalue, value, NULL);
	}
}


static void
DoubleClickDoCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    XmNlListWidget elist = (XmNlListWidget) client_data;
//    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
//    XmItemBoxWidget it = (XmItemBoxWidget) w;
    ItemActivateReturnStruct ret;

  if (elist->list.double_click) {
//    ret.item_number=number;
    XtCallCallbacks((Widget) client_data, XmNdoubleClickCallback, (XtPointer) call_data);
#ifdef DEBUG
		printf("\n XmNlList DoubleClickDoCallback called\n");
#endif
  }

}

/*static void
HDCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
	printf("------Callback from PartRes\n");
}
*/
static void
HighlightDoCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    XmNlListWidget elist = (XmNlListWidget) client_data;
//    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
//    XmItemBoxWidget it = (XmItemBoxWidget) w;
    static ListItemReturnStruct ret;
	int count;
#ifdef DEBUG
		printf("\n XmNlList HighlightDoCallback called\n");
#endif


	if (elist->list.ViewListType == XmNlList_Detail)
	{
		elist->list.highlightCell = RCGetSelectedCells(elist->list.rclist, &count);
		elist->list.highlightCount=count;
	}

	if (elist->list.ViewListType == XmNlList_Big || elist->list.ViewListType == XmNlList_Small)
	{
		elist->list.highlightCell = NULL;
		XmNlItBoxGetSelectedItems(elist->list.item_box, &count, NULL);
		elist->list.highlightCount=count;
	}

	if (elist->list.highlightCallback) {
//    MakeHighlightCallbackStruct(rcol, &ret);
    XtCallCallbacks((Widget) client_data, XtNhighlightCallback, (XtPointer) call_data);
#ifdef DEBUG
		printf("\n XmNlList HighlightDoCallback: callbacks transfered\n");
#endif
//    if (ret.number) XtFree(ret.number);
//    if (ret.number!=NULL) free(ret.number);
#ifdef DEBUG
		printf("\n XmNlList HighlightDoCallback complet\n");
#endif
  }

}



static void
ResizeRCCallback_Back(Widget w, XtPointer client_data, XtPointer call_data)
{
    XmNlListWidget elist = (XmNlListWidget) client_data;
    ListResizeReturnStruct *data;
    int i, fw, delta2, delta3, foundLessThanReal = 0;
    ListTbarCell * cell = elist->list.tbar_item;

    int newshift, autores, real_w, cur_w, delta;
    Boolean shift_changed;

    int *RealSize, *CurSize, *NewSize, *RealWd;

    data=(ListResizeReturnStruct *)call_data;

#ifdef DEBUG
	printf("XmNlList: Start check horizontal Widget %p Col num list %d col num data %d\n", elist, elist->list.num_cols, data->cols_num);
#endif

	RealSize = data->col_sharp_width;
	CurSize = data->col_cur_width;
	NewSize = data->col_new_width;


	if (elist->list.autores >= 0) 
		autores = elist->list.autores;
	else
		autores = elist->list.num_cols - 1;

	real_w = RealSize[autores];
	cur_w = CurSize[autores];


	elist->list.h_shift = data->cur_h_shift;

	if (data->reason == XmNlConsistencyChange)
	{
		
		if (data->state & XmNlPropertyConsistency)
		{
			elist->list.PropConsistency = True;
		}
		if (data->state & XmNlPropertyInconsistency)
		{
			elist->list.PropConsistency = False;
		}
		
		return ;
	}


	if (!elist->list.PropConsistency)
	{
#ifdef DEBUG
		printf("XmNlList: resize cb - inconsistency\n");
#endif
		return ;
	}

/* Begin Resize tree column */
	if (data->reason == XmNlTreeSizeChange && data->state == XmNlItemsFound)
	{

#ifdef DEBUG
		for (i = 0; i < data->cols_num; i++)
		{
			printf("Tree preview current %d real %d\n", CurSize[i], RealSize[i]);
		}
#endif

		NewSize[0] = RealSize[0];
		cell[0].current_width = NewSize[0];
		cell[0].x = 0;
		fw = NewSize[0];
		for (i = 1; i < data->cols_num; i++)
		{
			NewSize[i] = CurSize[i];
			cell[i].current_width = NewSize[i];
			cell[i].x = fw;
			fw = fw + NewSize[i];
		}

#ifdef DEBUG
		for (i = 0; i < data->cols_num; i++)
		{
			printf("Tree after current %d new %d x %d\n", CurSize[i], NewSize[i], cell[i].x);
		}
#endif


		data->list_full_width = fw;
		data->new_h_shift = data->cur_h_shift;
		elist->list.TBfullTilesWidth = fw;

		if (data->list_full_width < data->wid_width)
		{


			NewSize[autores] = CurSize[autores] + (data->wid_width - data->list_full_width);
			elist->list.AuotoResChanged = False;

			fw = 0;
			for (i = 0; i < data->cols_num; i++)
			{
				cell[i].x = fw;
				fw = fw + NewSize[i];
				cell[i].current_width = NewSize[i];
			}
			data->list_full_width = fw;
			elist->list.TBfullTilesWidth = fw;


#ifdef DEBUG
		for (i = 0; i < data->cols_num; i++)
		{
			printf("Tree correct1 current %d new %d x %d\n", CurSize[i], NewSize[i], cell[i].x);
		}
#endif

		}
		else
			if (data->list_full_width > data->wid_width)
			{
				if (NewSize[0] > CurSize[0] && RealSize[autores] < NewSize[autores])
				{
					NewSize[autores] = NewSize[autores] - (((data->list_full_width - data->wid_width) >= (NewSize[autores] - RealSize[autores])) ? 
										NewSize[autores] - RealSize[autores] :
										data->list_full_width - data->wid_width);
					fw = 0;
					for (i = 0; i < data->cols_num; i++)
					{
						cell[i].x = fw;
						fw = fw + NewSize[i];
						cell[i].current_width = NewSize[i];
					}

#ifdef DEBUG
		for (i=0; i < data->cols_num; i++)
		{
			printf("Tree correct2 current %d new %d x %d\n", CurSize[i], NewSize[i], cell[i].x);
		}
#endif

					data->list_full_width = fw;
					elist->list.TBfullTilesWidth = fw;
				}
			}
			
		if (data->wid_width + data->cur_h_shift > data->list_full_width)
		{
			data->new_h_shift = data->list_full_width - data->wid_width;
			if (data->new_h_shift < 0)
				data->new_h_shift = 0;
		}

		elist->list.h_shift = data->new_h_shift;
		elist->list.TSizeNotSet = False;


		RedrawTitleBarOnly((Widget) client_data);

		return ;
	}
/* End Resize tree column */

	if ((data->reason == XmNlSizeChange  || data->reason == XmNlContentChange) && data->state == XmNlEmpty)
/* Begin ListEmpty */
	{
		fw = 0;
#ifdef DEBUG
		for (i = 0; i < data->cols_num; i++)
		{
			printf("ListEmpty %d TSize = %d\n", i, cell[i].current_width);
		}
#endif
		
		if (elist->list.TSizeNotSet)
		{
			for (i = 0; i < data->cols_num; i++)
			{
				cell[i].x = fw;
				NewSize[i] = RealSize[i];
				cell[i].current_width = NewSize[i];
				fw = fw + NewSize[i];
			}
			elist->list.TSizeNotSet = False;
		}
		else
		{
			for (i = 0; i < data->cols_num; i++)
			{
				cell[i].x = fw;
				NewSize[i] = cell[i].current_width;
				fw = fw + NewSize[i];
			}
		}
		data->list_full_width = fw;
		elist->list.TBfullTilesWidth = fw;


		if (fw < data->wid_width && data->cols_num > 0)
		{
			delta = data->wid_width - fw;
			delta2 = delta/data->cols_num;
			if (delta2 == 0)
			{
				if (elist->list.incrCol >= elist->list.num_cols)
					elist->list.incrCol = 0;
				NewSize[elist->list.incrCol] = NewSize[elist->list.incrCol] + delta;
				elist->list.incrCol++;
				fw = 0;
				for (i=0; i < data->cols_num; i++)
				{
					cell[i].x = fw;
					fw = fw + NewSize[i];
					cell[i].current_width = NewSize[i];
				}
				data->list_full_width = fw;
				elist->list.TBfullTilesWidth = fw;
			}
			else
			{
				fw = 0;
				for (i = 0; i < data->cols_num; i++)
				{
					cell[i].x = fw;
					NewSize[i]+=delta2;
					fw = fw + NewSize[i];
					cell[i].current_width = NewSize[i];
				}
				if (fw < data->wid_width)
				{
					int accum_x = 0;
					NewSize[autores] = NewSize[autores] + (data->wid_width - fw);
					cell[autores].current_width = NewSize[autores];
					fw = data->wid_width;
					for (i = 0; i < data->cols_num; i++)
					{
						cell[i].x = accum_x;
						accum_x = accum_x + cell[i].current_width;
					}
				}
				data->list_full_width = fw;
				elist->list.TBfullTilesWidth = fw;
			}

		}

		if (fw > data->wid_width && data->cols_num > 0)
		{
			delta = fw - data->wid_width;
			delta2 = delta/data->cols_num;
			if (delta2 != 0)
			{	
				fw = 0;
				for (i = 0; i < data->cols_num; i++)
				{
					cell[i].x = fw;
					if (cell[i].current_width > (delta2 + 4)) 
						cell[i].current_width = cell[i].current_width - delta2;
					else
						cell[i].current_width = elist->list.FlSize[i] > 4 ? elist->list.FlSize[i] : cell[i].real_width;

					NewSize[i] = cell[i].current_width;
					fw = fw + NewSize[i];
				}
			}
			else
			{
				if (elist->list.decrCol >= elist->list.num_cols)
					elist->list.decrCol = 0;

				delta2 = cell[elist->list.decrCol].current_width;
				cell[elist->list.decrCol].current_width = cell[elist->list.decrCol].current_width - delta;
				if (cell[elist->list.decrCol].current_width < elist->list.FlSize[elist->list.decrCol])
				{
					cell[elist->list.decrCol].current_width = elist->list.FlSize[elist->list.decrCol];
					delta = delta - (delta2 - elist->list.FlSize[elist->list.decrCol]);

					cell[autores].current_width = cell[autores].current_width - delta;
					if (cell[autores].current_width < elist->list.FlSize[autores])
						cell[autores].current_width = elist->list.FlSize[autores];
				}
				NewSize[elist->list.decrCol] = cell[elist->list.decrCol].current_width;
				NewSize[autores] = cell[autores].current_width;
				elist->list.decrCol++;

				fw = 0;
				for (i = 0; i < data->cols_num; i++)
				{
					cell[i].x = fw;
					fw = fw + NewSize[i];
				}
			}

			data->list_full_width = fw;
			elist->list.TBfullTilesWidth = fw;
		}

		if (data->wid_width + data->cur_h_shift > data->list_full_width)
		{
			data->new_h_shift = data->list_full_width - data->wid_width;
			if (data->new_h_shift < 0)
				data->new_h_shift = 0;
		}
		else
			data->new_h_shift = data->cur_h_shift;
		elist->list.h_shift = data->new_h_shift;


		RedrawTitleBarOnly((Widget) client_data);

		return ;
	}
/* End ListEmpty */
	if (data->reason == XmNlContentChange && data->state == XmNlItemsFound && elist->list.ListEmpty)
/* Begin ListEmpty */
	{
		fw = 0;
		for (i=0; i < data->cols_num; i++)
		{
			NewSize[i] = RealSize[i];
			cell[i].current_width = NewSize[i];
			cell[i].x = fw;
			fw = fw + NewSize[i];
		}
		data->list_full_width = fw;
		elist->list.TBfullTilesWidth = fw;

		if (data->list_full_width < data->wid_width)
		{
			NewSize[autores] = NewSize[autores] + (data->wid_width - data->list_full_width);
			elist->list.AuotoResChanged = False;

			fw = 0;
			for (i=0; i < data->cols_num; i++)
			{
				cell[i].x = fw;
				fw = fw + NewSize[i];
				cell[i].current_width = NewSize[i];
			}
			data->list_full_width = fw;
			elist->list.TBfullTilesWidth = fw;
		}
		data->new_h_shift = data->cur_h_shift;

		if (data->wid_width + data->cur_h_shift > data->list_full_width)
		{
			data->new_h_shift = data->list_full_width - data->wid_width;
			if (data->new_h_shift < 0)
				data->new_h_shift = 0;
		}
		elist->list.h_shift = data->new_h_shift;
		elist->list.TSizeNotSet = False;

		RedrawTitleBarOnly((Widget) client_data);
		elist->list.ListEmpty = False;
		return ;
	}

	if (data->reason == XmNlContentChange && data->state == XmNlItemsFound && !elist->list.ListEmpty)
/* Begin Not ListEmpty */
	{
		fw = 0;
		delta2 = 0;
		delta3 = 0;
		delta = CurSize[autores] - RealSize[autores];

		for (i = 0; i < data->cols_num; i++)
		{
			if ((i == autores || ((i == data->cols_num - 1) && elist->list.adjust_last_column)) && CurSize[i] < RealSize[i])
			{
				if (i == autores)
				{
					delta = CurSize[i] * 2;
					if (delta < RealSize[i])
						NewSize[i] = delta;
					else
						NewSize[i] = RealSize[i];
				}
				else
					NewSize[i] = RealSize[i];

			}
			else
			{
				if (CurSize[i] >= RealSize[i])
					NewSize[i] = CurSize[i];
				else
				{
					delta = CurSize[i] * 2;
					if (delta < RealSize[i])
						NewSize[i] = delta;
					else
						NewSize[i] = RealSize[i];
				}
			}

			cell[i].current_width = NewSize[i];
			cell[i].x = fw;
			fw = fw + NewSize[i];
		}


		data->list_full_width = fw;
		elist->list.TBfullTilesWidth = fw;


		if (data->list_full_width < data->wid_width)
		{
			NewSize[autores] = NewSize[autores] + (data->wid_width - data->list_full_width);
			elist->list.AuotoResChanged = False;

			fw = 0;
			for (i=0; i < data->cols_num; i++)
			{
				cell[i].x = fw;
				fw = fw + NewSize[i];
				cell[i].current_width = NewSize[i];
			}
			data->list_full_width = fw;
			elist->list.TBfullTilesWidth = fw;
		}

		if (data->list_full_width > data->wid_width && NewSize[autores] > RealSize[autores])
		{
			NewSize[autores] = NewSize[autores] - 
								((data->list_full_width - data->wid_width) < (NewSize[autores] - RealSize[autores]) ? 
								(data->list_full_width - data->wid_width) : (NewSize[autores] - RealSize[autores]));
			elist->list.AuotoResChanged = False;

			fw = 0;
			for (i = 0; i < data->cols_num; i++)
			{
				cell[i].x = fw;
				fw = fw + NewSize[i];
				cell[i].current_width = NewSize[i];
			}
			data->list_full_width = fw;
			elist->list.TBfullTilesWidth = fw;
		}

		data->new_h_shift = data->cur_h_shift;

		if (data->wid_width + data->cur_h_shift > data->list_full_width)
		{
			data->new_h_shift = data->list_full_width - data->wid_width;
			if (data->new_h_shift < 0)
				data->new_h_shift = 0;
		}
		elist->list.h_shift = data->new_h_shift;

		elist->list.TSizeNotSet = False;


		RedrawTitleBarOnly((Widget) client_data);

		return ;
	}



	if (data->reason == XmNlSizeChange && data->state == XmNlItemsFound && !elist->list.ListEmpty)
	{
		fw = 0;
		for (i = 0; i < data->cols_num; i++)
		{
			if (CurSize[i] < RealSize[i])
				foundLessThanReal = 1;
			NewSize[i] = CurSize[i];
			cell[i].current_width = NewSize[i];
			cell[i].x = fw;
			fw = fw + NewSize[i];
		}
		data->list_full_width = fw;
		elist->list.TBfullTilesWidth = fw;
		data->new_h_shift = data->cur_h_shift;
		if (data->wid_width >= data->last_wid_width)
		{
			if (data->list_full_width < data->wid_width)
			{
				if (foundLessThanReal)
				{
					delta = data->wid_width - data->list_full_width;
					fw = 0;
					for (i = 0; i < data->cols_num; i++)
					{
						if (cell[i].current_width < RealSize[i])
						{
							if ((RealSize[i] - cell[i].current_width) <= delta)
							{
								NewSize[i] = RealSize[i];
								delta = delta - (RealSize[i] - cell[i].current_width);
							}
							else
							{
								NewSize[i] = cell[i].current_width + delta;
								delta = 0;
							}
						}
						cell[i].x = fw;
						fw = fw + NewSize[i];
						cell[i].current_width = NewSize[i];
					}
				}
				else
				{
					NewSize[autores] = NewSize[autores] + (data->wid_width - data->list_full_width);
					elist->list.AuotoResChanged = False;

					fw = 0;
					for (i=0; i < data->cols_num; i++)
					{
						cell[i].x = fw;
						fw = fw + NewSize[i];
						cell[i].current_width = NewSize[i];
					}
				}

 				data->list_full_width = fw;
				elist->list.TBfullTilesWidth = fw;
			}
			data->new_h_shift = data->cur_h_shift;
			if (data->wid_width + data->cur_h_shift > data->list_full_width)
			{
				data->new_h_shift = data->list_full_width - data->wid_width;
				if (data->new_h_shift < 0)
					data->new_h_shift = 0;
				elist->list.h_shift = data->new_h_shift;
			}
			elist->list.h_shift = data->new_h_shift;
			elist->list.TSizeNotSet = False;


			return ;
		}
		else
		{
			if (!elist->list.AuotoResChanged)
			{
				if (data->list_full_width > data->wid_width && CurSize[autores] > RealSize[autores])
				{
					NewSize[autores] = CurSize[autores] - (data->list_full_width - data->wid_width);
					if (NewSize[autores] < RealSize[autores]) NewSize[autores] = RealSize[autores];
					fw = 0;
					for (i=0; i < data->cols_num; i++)
					{
						cell[i].x = fw;
						fw = fw + NewSize[i];
						cell[i].current_width = NewSize[i];
					}
					data->new_h_shift = data->cur_h_shift;
					data->list_full_width = fw;
					elist->list.TBfullTilesWidth = fw;
					if (data->wid_width + data->cur_h_shift > data->list_full_width)
					{
						data->new_h_shift = data->list_full_width - data->wid_width;
						if (data->new_h_shift < 0)
							data->new_h_shift = 0;
					}
					elist->list.h_shift = data->new_h_shift;
				}
			}
			elist->list.TSizeNotSet = False;


			return ;
		}
	}
/* End Not ListEmpty */

#ifdef DEBUG
	printf("\n--------- XmNlList: resize  ---------\n");
	printf("viewWidth = %d, fullWidth = %d\n", data->wid_width, data->list_full_width);
#endif
#ifdef DEBUG
    for (i=0; i<data->cols_num; i++)
    {
		printf("| %d |", data->col_cur_width[i]);
		printf("| %d |", CurSize[i]);
	}
	printf("\n");
#endif

#ifdef DEBUG
    for (i=0; i<data->cols_num; i++)
    {
		printf("| %d |", data->col_new_width[i]);
		printf("| %d |", NewSize[i]);
	}
	printf("\n");
#endif
}


static int
TbarNeedRedraw(XmNlListWidget elist)
{
	int i;
	
	for (i = 0; i < elist->list.num_cols; i++)
	{
		if (elist->list.tbar_item[i].current_width != elist->list.tbar_item_last[i].current_width ||
			elist->list.tbar_item[i].x != elist->list.tbar_item_last[i].x)
		{
			return 1;
		}
	}
	return 0;
}




static void
ResizeRCCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    XmNlListWidget elist = (XmNlListWidget) client_data;
    ListResizeReturnStruct *data;
    int i, fw, delta2, delta3, foundLessThanReal = 0;
    ListTbarCell * cell = elist->list.tbar_item;

    int newshift, autores, real_w, cur_w, delta;
    Boolean shift_changed;

    int *RealSize, *CurSize, *NewSize, *RealWd;

    data=(ListResizeReturnStruct *)call_data;

#ifdef DEBUG
	printf("XmNlList: Start check horizontal Widget %p Col num list %d col num data %d\n", elist, elist->list.num_cols, data->cols_num);
#endif
//	if (!rcol->rescol.item_data) return 0;

	RealSize = data->col_sharp_width;
	CurSize = data->col_cur_width;
	NewSize = data->col_new_width;


	if (elist->list.autores >= 0) 
		autores = elist->list.autores;
	else
		autores = elist->list.num_cols - 1;

	real_w = RealSize[autores];
	cur_w = CurSize[autores];


	elist->list.h_shift = data->cur_h_shift;

	if (data->reason == XmNlConsistencyChange)
	{
		
		if (data->state & XmNlPropertyConsistency)
		{
			elist->list.PropConsistency = True;
		}
		if (data->state & XmNlPropertyInconsistency)
		{
			elist->list.PropConsistency = False;
		}
		
		return ;
	}


	if (!elist->list.PropConsistency)
	{
#ifdef DEBUG
		printf("XmNlList: resize cb - inconsistency\n");
#endif
		return ;
	}

	memcpy(elist->list.tbar_item_last, elist->list.tbar_item, sizeof(ListTbarCell) * data->cols_num);

/* Begin Resize tree column */
	if (data->reason == XmNlTreeSizeChange && data->state == XmNlItemsFound)
	{

#ifdef DEBUG
		for (i = 0; i < data->cols_num; i++)
		{
			printf("Tree preview current %d real %d\n", CurSize[i], RealSize[i]);
		}
#endif

		NewSize[0] = RealSize[0];
		cell[0].current_width = NewSize[0];
		cell[0].x = 0;
		fw = NewSize[0];
		for (i = 1; i < data->cols_num; i++)
		{
			NewSize[i] = CurSize[i];
			cell[i].current_width = NewSize[i];
			cell[i].x = fw;
			fw = fw + NewSize[i];
		}

#ifdef DEBUG
		for (i = 0; i < data->cols_num; i++)
		{
			printf("Tree after current %d new %d x %d\n", CurSize[i], NewSize[i], cell[i].x);
		}
#endif


		data->list_full_width = fw;
		data->new_h_shift = data->cur_h_shift;
		elist->list.TBfullTilesWidth = fw;

		if (data->list_full_width < data->wid_width)
		{


			NewSize[autores] = CurSize[autores] + (data->wid_width - data->list_full_width);
			elist->list.AuotoResChanged = False;

			fw = 0;
			for (i = 0; i < data->cols_num; i++)
			{
				cell[i].x = fw;
				fw = fw + NewSize[i];
				cell[i].current_width = NewSize[i];
			}
			data->list_full_width = fw;
			elist->list.TBfullTilesWidth = fw;


#ifdef DEBUG
		for (i = 0; i < data->cols_num; i++)
		{
			printf("Tree correct1 current %d new %d x %d\n", CurSize[i], NewSize[i], cell[i].x);
		}
#endif

		}
		else
			if (data->list_full_width > data->wid_width)
			{
				if (NewSize[0] > CurSize[0] && RealSize[autores] < NewSize[autores])
				{
					NewSize[autores] = NewSize[autores] - (((data->list_full_width - data->wid_width) >= (NewSize[autores] - RealSize[autores])) ? 
										NewSize[autores] - RealSize[autores] :
										data->list_full_width - data->wid_width);
					fw = 0;
					for (i = 0; i < data->cols_num; i++)
					{
						cell[i].x = fw;
						fw = fw + NewSize[i];
						cell[i].current_width = NewSize[i];
					}

#ifdef DEBUG
		for (i=0; i < data->cols_num; i++)
		{
			printf("Tree correct2 current %d new %d x %d\n", CurSize[i], NewSize[i], cell[i].x);
		}
#endif

					data->list_full_width = fw;
					elist->list.TBfullTilesWidth = fw;
				}
			}
			
		if (data->wid_width + data->cur_h_shift > data->list_full_width)
		{
			data->new_h_shift = data->list_full_width - data->wid_width;
			if (data->new_h_shift < 0)
				data->new_h_shift = 0;
		}

		elist->list.h_shift = data->new_h_shift;
		elist->list.TSizeNotSet = False;

//		for (i = 0; i < data->cols_num; i++)
//		{
//			cell[i].current_width = NewSize[i];
//		}

		if (TbarNeedRedraw(elist))
			RedrawTitleBarOnly((Widget) client_data);

		return ;
	}
/* End Resize tree column */

	if ((data->reason == XmNlSizeChange  || data->reason == XmNlContentChange) && data->state == XmNlEmpty)
/* Begin ListEmpty */
	{
		fw = 0;
#ifdef DEBUG
		for (i = 0; i < data->cols_num; i++)
		{
			printf("ListEmpty %d TSize = %d\n", i, cell[i].current_width);
		}
#endif
		
		if (elist->list.TSizeNotSet)
		{
			for (i = 0; i < data->cols_num; i++)
			{
				cell[i].x = fw;
				NewSize[i] = RealSize[i];
				cell[i].current_width = NewSize[i];
				fw = fw + NewSize[i];
			}
			elist->list.TSizeNotSet = False;
		}
		else
		{
			for (i = 0; i < data->cols_num; i++)
			{
				cell[i].x = fw;
				NewSize[i] = cell[i].current_width;
				fw = fw + NewSize[i];
			}
		}
		data->list_full_width = fw;
		elist->list.TBfullTilesWidth = fw;


		if (fw < data->wid_width && data->cols_num > 0)
		{
			delta = data->wid_width - fw;
			delta2 = delta/data->cols_num;
			if (delta2 == 0)
			{
				if (elist->list.incrCol >= elist->list.num_cols)
					elist->list.incrCol = 0;
				NewSize[elist->list.incrCol] = NewSize[elist->list.incrCol] + delta;
				elist->list.incrCol++;
				fw = 0;
				for (i=0; i < data->cols_num; i++)
				{
					cell[i].x = fw;
					fw = fw + NewSize[i];
					cell[i].current_width = NewSize[i];
				}
				data->list_full_width = fw;
				elist->list.TBfullTilesWidth = fw;
			}
			else
			{
				fw = 0;
				for (i = 0; i < data->cols_num; i++)
				{
					cell[i].x = fw;
					NewSize[i]+=delta2;
					fw = fw + NewSize[i];
					cell[i].current_width = NewSize[i];
				}
				if (fw < data->wid_width)
				{
					int accum_x = 0;
					NewSize[autores] = NewSize[autores] + (data->wid_width - fw);
					cell[autores].current_width = NewSize[autores];
					fw = data->wid_width;
					for (i = 0; i < data->cols_num; i++)
					{
						cell[i].x = accum_x;
						accum_x = accum_x + cell[i].current_width;
					}
				}
				data->list_full_width = fw;
				elist->list.TBfullTilesWidth = fw;
			}

/*			NewSize[autores] = NewSize[autores] + (data->wid_width - fw);
			fw = 0;
			for (i = 0; i < data->cols_num; i++)
			{
				fw = fw + NewSize[i];
				elist->list.TSize[i] = NewSize[i];
				printf("NewSize %d = %d\n", i, NewSize[i]);
			}

			data->list_full_width = fw;*/
		}

		if (fw > data->wid_width && data->cols_num > 0)
		{
			delta = fw - data->wid_width;
			delta2 = delta/data->cols_num;
			if (delta2 != 0)
			{	
				fw = 0;
				for (i = 0; i < data->cols_num; i++)
				{
					cell[i].x = fw;
					if (cell[i].current_width > (delta2 + 4)) 
						cell[i].current_width = cell[i].current_width - delta2;
					else
//					if ((cell[i].current_width < elist->list.FlSize[i]) || (cell[i].current_width <= 0))
						cell[i].current_width = elist->list.FlSize[i] > 4 ? elist->list.FlSize[i] : cell[i].real_width;

					NewSize[i] = cell[i].current_width;
					fw = fw + NewSize[i];
				}
			}
			else
			{
				if (elist->list.decrCol >= elist->list.num_cols)
					elist->list.decrCol = 0;

				delta2 = cell[elist->list.decrCol].current_width;
				cell[elist->list.decrCol].current_width = cell[elist->list.decrCol].current_width - delta;
				if (cell[elist->list.decrCol].current_width < elist->list.FlSize[elist->list.decrCol])
				{
					cell[elist->list.decrCol].current_width = elist->list.FlSize[elist->list.decrCol];
					delta = delta - (delta2 - elist->list.FlSize[elist->list.decrCol]);

					cell[autores].current_width = cell[autores].current_width - delta;
					if (cell[autores].current_width < elist->list.FlSize[autores])
						cell[autores].current_width = elist->list.FlSize[autores];
				}
				NewSize[elist->list.decrCol] = cell[elist->list.decrCol].current_width;
				NewSize[autores] = cell[autores].current_width;
				elist->list.decrCol++;

				fw = 0;
				for (i = 0; i < data->cols_num; i++)
				{
					cell[i].x = fw;
					fw = fw + NewSize[i];
				}
			}

			data->list_full_width = fw;
			elist->list.TBfullTilesWidth = fw;
		}

		if (data->wid_width + data->cur_h_shift > data->list_full_width)
		{
			data->new_h_shift = data->list_full_width - data->wid_width;
			if (data->new_h_shift < 0)
				data->new_h_shift = 0;
		}
		else
			data->new_h_shift = data->cur_h_shift;
		elist->list.h_shift = data->new_h_shift;

//		for (i = 0; i < data->cols_num; i++)
//		{
//			cell[i].current_width = NewSize[i];
//		}

		if (TbarNeedRedraw(elist))
			RedrawTitleBarOnly((Widget) client_data);

		return ;
	}
/* End ListEmpty */

	if (data->reason == XmNlContentChange && data->state == XmNlItemsFound && elist->list.ListEmpty)
/* Begin ListEmpty */
	{
#ifdef DEBUG
		printf("ADD to list\n");
#endif
		fw = 0;
		for (i=0; i < data->cols_num; i++)
		{
			NewSize[i] = RealSize[i];
			cell[i].current_width = NewSize[i];
			cell[i].x = fw;
			fw = fw + NewSize[i];
#ifdef DEBUG
			printf("+ %d %d\n", i, NewSize[i]);
#endif
		}
		data->list_full_width = fw;
		elist->list.TBfullTilesWidth = fw;

		if (data->list_full_width < data->wid_width)
		{
			NewSize[autores] = NewSize[autores] + (data->wid_width - data->list_full_width);
			elist->list.AuotoResChanged = False;

			fw = 0;
			for (i=0; i < data->cols_num; i++)
			{
				cell[i].x = fw;
				fw = fw + NewSize[i];
				cell[i].current_width = NewSize[i];
#ifdef DEBUG
			printf("++ %d %d\n", i, NewSize[i]);
#endif
			}
			data->list_full_width = fw;
			elist->list.TBfullTilesWidth = fw;
		}
		data->new_h_shift = data->cur_h_shift;

#ifdef DEBUG
		printf("ADD 2 shift %d\n", data->new_h_shift, data->list_full_width);
#endif

		if (data->wid_width + data->cur_h_shift > data->list_full_width)
		{
			data->new_h_shift = data->list_full_width - data->wid_width;
			if (data->new_h_shift < 0)
				data->new_h_shift = 0;
		}
		elist->list.h_shift = data->new_h_shift;
		elist->list.TSizeNotSet = False;
//		for (i = 0; i < data->cols_num; i++)
//		{
//			cell[i].current_width = NewSize[i];
//		}

		if (TbarNeedRedraw(elist))
			RedrawTitleBarOnly((Widget) client_data);
		elist->list.ListEmpty = False;
#ifdef DEBUG
		printf("ADD 2 wwid %d shift %d wlist %d\n", data->wid_width, data->new_h_shift, data->list_full_width);
#endif
		return ;
	}

	if (data->reason == XmNlContentChange && data->state == XmNlItemsFound && !elist->list.ListEmpty)
/* Begin Not ListEmpty */
	{
		fw = 0;
		delta2 = 0;
		delta3 = 0;
		delta = CurSize[autores] - RealSize[autores];

#ifdef DEBUG
		printf("OK wwidlast %d wwid %d shift %d wlist %d\n",data->last_wid_width, data->wid_width, data->new_h_shift, data->list_full_width);
#endif

		if (data->wid_width == data->list_full_width)
		{
#ifdef DEBUG
			printf("OK\n");
#endif
			int minN = 0;
			int minVal = RealSize[0];

			for (i = 0; i < data->cols_num; i++)
			{
				if (RealSize[i] < minVal)
				{
					minVal = RealSize[i];
					minN = i;
				}
				
				NewSize[i] = RealSize[i];
				cell[i].current_width = NewSize[i];
				cell[i].x = fw;
				fw = fw + NewSize[i];
#ifdef DEBUG
				printf("+1 %d %d\n", i, NewSize[i]);
#endif
			}
			data->list_full_width = fw;
			elist->list.TBfullTilesWidth = fw;


			if (data->list_full_width < data->wid_width)
			{
				NewSize[autores] = NewSize[autores] + (data->wid_width - data->list_full_width);
				elist->list.AuotoResChanged = False;

				fw = 0;
				for (i=0; i < data->cols_num; i++)
				{
					cell[i].x = fw;
					fw = fw + NewSize[i];
					cell[i].current_width = NewSize[i];
#ifdef DEBUG
					printf("+2 %d %d\n", i, NewSize[i]);
#endif
				}
				data->list_full_width = fw;
				elist->list.TBfullTilesWidth = fw;
			}
			else
				if (data->list_full_width > data->wid_width)
				{
					if (elist->list.adjust_last_column) delta = (data->list_full_width - data->wid_width) / (elist->list.autoAdjustedNum - 1);
					else delta = (data->list_full_width - data->wid_width) / elist->list.autoAdjustedNum;

#ifdef DEBUG
					printf("delta %d\n", delta);
#endif
					if (delta > 0)
					{
						fw = 0;
						for (i = 0; i < data->cols_num - elist->list.adjust_last_column; i++)
						{
/*							if ((delta < (RealSize[i] - 4)) && (elist->list.tbar_item[i].column_type != XmPIXMAP))*/
							if ((delta < (RealSize[i] / 3)) && (elist->list.tbar_item[i].column_type != XmPIXMAP))
								NewSize[i] = NewSize[i] - delta;

							cell[i].x = fw;
							fw = fw + NewSize[i];
							cell[i].current_width = NewSize[i];
#ifdef DEBUG
										printf("+3 %d %d\n", i, NewSize[i]);
#endif
						}

						if (elist->list.adjust_last_column)
						{
							cell[data->cols_num - 1].x = fw;
							fw = fw + NewSize[data->cols_num - 1];
							cell[data->cols_num - 1].current_width = NewSize[data->cols_num - 1];
						}

						data->list_full_width = fw;
						elist->list.TBfullTilesWidth = fw;

						if (data->list_full_width > data->wid_width)
						{
							NewSize[autores] = NewSize[autores] - (data->list_full_width - data->wid_width);
/*							if ((NewSize[autores] * 3) < RealSize[autores])
								NewSize[autores] = 20;*/

							if ((NewSize[autores] * 3) < RealSize[autores])
								NewSize[autores] = RealSize[autores] / 5 * 2;

							fw = 0;
							for (i=0; i < data->cols_num; i++)
							{
								cell[i].x = fw;
								fw = fw + NewSize[i];
								cell[i].current_width = NewSize[i];
#ifdef DEBUG
								printf("+4 %d %d\n", i, NewSize[i]);
#endif
							}
							data->list_full_width = fw;
							elist->list.TBfullTilesWidth = fw;
						}
						
					}
					else
					{
						NewSize[autores] = NewSize[autores] + (data->wid_width - data->list_full_width);
						elist->list.AuotoResChanged = False;

						fw = 0;
						for (i=0; i < data->cols_num; i++)
						{
							cell[i].x = fw;
							fw = fw + NewSize[i];
							cell[i].current_width = NewSize[i];
#ifdef DEBUG
							printf("+5 %d %d\n", i, NewSize[i]);
#endif
						}
						data->list_full_width = fw;
						elist->list.TBfullTilesWidth = fw;
					}
				}
		}
		else
		{
						fw = 0;
						for (i = 0; i < data->cols_num; i++)
						{
							NewSize[i] = CurSize[i];

							cell[i].x = fw;
							fw = fw + NewSize[i];
							cell[i].current_width = NewSize[i];
#ifdef DEBUG
										printf("+6 %d %d\n", i, NewSize[i]);
#endif
						}
						data->list_full_width = fw;
						elist->list.TBfullTilesWidth = fw;

						if (data->list_full_width < data->wid_width)
						{
							NewSize[autores] = NewSize[autores] + (data->wid_width - data->list_full_width);
							elist->list.AuotoResChanged = False;

							fw = 0;
							for (i=0; i < data->cols_num; i++)
							{
								cell[i].x = fw;
								fw = fw + NewSize[i];
								cell[i].current_width = NewSize[i];
#ifdef DEBUG
								printf("+7 %d %d\n", i, NewSize[i]);
#endif
							}
							data->list_full_width = fw;
							elist->list.TBfullTilesWidth = fw;
						}
		}



		data->new_h_shift = data->cur_h_shift;

		if (data->wid_width + data->cur_h_shift > data->list_full_width)
		{
			data->new_h_shift = data->list_full_width - data->wid_width;
			if (data->new_h_shift < 0)
				data->new_h_shift = 0;
		}
		elist->list.h_shift = data->new_h_shift;

		elist->list.TSizeNotSet = False;

//		for (i = 0; i < data->cols_num; i++)
//		{
//			cell[i].current_width = NewSize[i];
//		}
		if (TbarNeedRedraw(elist))
			RedrawTitleBarOnly((Widget) client_data);

		return ;
	}



	if (data->reason == XmNlSizeChange && data->state == XmNlItemsFound && !elist->list.ListEmpty)
	{
		fw = 0;
		for (i = 0; i < data->cols_num; i++)
		{
			if (CurSize[i] < RealSize[i])
				foundLessThanReal = 1;
			NewSize[i] = CurSize[i];
			cell[i].current_width = NewSize[i];
			cell[i].x = fw;
			fw = fw + NewSize[i];
		}
		data->list_full_width = fw;
		elist->list.TBfullTilesWidth = fw;
		data->new_h_shift = data->cur_h_shift;
		if (data->wid_width >= data->last_wid_width)
		{
			if (data->list_full_width < data->wid_width)
			{
				if (foundLessThanReal)
				{
					delta = data->wid_width - data->list_full_width;
					fw = 0;
					for (i = 0; i < data->cols_num; i++)
					{
						if (cell[i].current_width < RealSize[i])
						{
							if ((RealSize[i] - cell[i].current_width) <= delta)
							{
								NewSize[i] = RealSize[i];
								delta = delta - (RealSize[i] - cell[i].current_width);
							}
							else
							{
								NewSize[i] = cell[i].current_width + delta;
								delta = 0;
							}
						}
						cell[i].x = fw;
						fw = fw + NewSize[i];
						cell[i].current_width = NewSize[i];
					}
				}
				else
				{
					NewSize[autores] = NewSize[autores] + (data->wid_width - data->list_full_width);
					elist->list.AuotoResChanged = False;

					fw = 0;
					for (i=0; i < data->cols_num; i++)
					{
						cell[i].x = fw;
						fw = fw + NewSize[i];
						cell[i].current_width = NewSize[i];
					}
				}

 				data->list_full_width = fw;
				elist->list.TBfullTilesWidth = fw;
			}
			data->new_h_shift = data->cur_h_shift;
			if (data->wid_width + data->cur_h_shift > data->list_full_width)
			{
				data->new_h_shift = data->list_full_width - data->wid_width;
				if (data->new_h_shift < 0)
					data->new_h_shift = 0;
				elist->list.h_shift = data->new_h_shift;
			}
			elist->list.h_shift = data->new_h_shift;
			elist->list.TSizeNotSet = False;


			return ;
		}
		else
		{
			if (!elist->list.AuotoResChanged)
			{
				if (data->list_full_width > data->wid_width && CurSize[autores] > RealSize[autores])
				{
					NewSize[autores] = CurSize[autores] - (data->list_full_width - data->wid_width);
					if (NewSize[autores] < RealSize[autores]) NewSize[autores] = RealSize[autores];
					fw = 0;
					for (i=0; i < data->cols_num; i++)
					{
						cell[i].x = fw;
						fw = fw + NewSize[i];
						cell[i].current_width = NewSize[i];
					}
					data->new_h_shift = data->cur_h_shift;
					data->list_full_width = fw;
					elist->list.TBfullTilesWidth = fw;
					if (data->wid_width + data->cur_h_shift > data->list_full_width)
					{
						data->new_h_shift = data->list_full_width - data->wid_width;
						if (data->new_h_shift < 0)
							data->new_h_shift = 0;
					}
					elist->list.h_shift = data->new_h_shift;
				}
			}
			elist->list.TSizeNotSet = False;

//			for (i = 0; i < data->cols_num; i++)
//			{
//				cell[i].current_width = NewSize[i];
//			}

			return ;
		}
	}
/* End Not ListEmpty */

#ifdef DEBUG
	printf("\n--------- XmNlList: resize  ---------\n");
	printf("viewWidth = %d, fullWidth = %d\n", data->wid_width, data->list_full_width);
#endif
#ifdef DEBUG
    for (i=0; i<data->cols_num; i++)
    {
		printf("| %d |", data->col_cur_width[i]);
		printf("| %d |", CurSize[i]);
	}
	printf("\n");
#endif

#ifdef DEBUG
    for (i=0; i<data->cols_num; i++)
    {
		printf("| %d |", data->col_new_width[i]);
		printf("| %d |", NewSize[i]);
	}
	printf("\n");
#endif
}



static void
HScrollCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
	XmNlRCL_Property_Row * rw;
	XmNlListWidget elist = (XmNlListWidget) client_data;
	XmNlRCL_Cell  * cell;
    XmScrollBarCallbackStruct * scroll_info;
    int newshift;

	if (elist->list.ViewListType != XmNlList_Detail && elist->list.ViewListType != XmNlList_TreeCol)
		return ;


    scroll_info = (XmScrollBarCallbackStruct *) call_data;

    newshift = (int) scroll_info->value;
    elist->list.h_shift = newshift;

	if (elist->list.ListEmpty)
		RefreshTitleBar((Widget) client_data);

	if (XtIsRealized(w))  
	{
		RedrawTitleBarOnly((Widget) client_data);
	}
#ifdef DEBUG
	printf("\n Vscrolled\n ");
#endif
}



int XmNlListAppendColumn(Widget w, XmNlColSpecRec * csrec)
{
	XmNlListWidget elist = (XmNlListWidget) w;
	int i;


#ifdef DEBUG
	printf("\n XmNlListAppendColumn start cols %d\n", elist->list.num_cols);
#endif

	if (elist->list.num_cols > 0)
	{
		elist->list.TSize = (int *) XtRealloc((char *) elist->list.TSize, (elist->list.num_cols + 1) * sizeof(int));

		elist->list.FlSize = (int *) XtRealloc((char *) elist->list.FlSize, (elist->list.num_cols + 1) * sizeof(int));

		elist->list.CurSize = (int *) XtRealloc((char *) elist->list.CurSize, (elist->list.num_cols + 1) * sizeof(int));
	
		elist->list.TIdealSize = (int *) XtRealloc((char *) elist->list.TIdealSize, (elist->list.num_cols + 1) * sizeof(int));

		elist->list.tbar_item = (ListTbarCell *) XtRealloc((char *) elist->list.tbar_item, (elist->list.num_cols + 1) * sizeof(ListTbarCell));

		elist->list.tbar_item_last = (ListTbarCell *) XtRealloc((char *) elist->list.tbar_item_last, (elist->list.num_cols + 1) * sizeof(ListTbarCell));
	}
	else
	{
		elist->list.TSize = (int *) XtCalloc(elist->list.num_cols + 1, sizeof(int));

		elist->list.FlSize = (int *) XtCalloc(elist->list.num_cols + 1, sizeof(int));

		elist->list.CurSize = (int *) XtCalloc(elist->list.num_cols + 1, sizeof(int));
		
		elist->list.TIdealSize = (int *) XtCalloc(elist->list.num_cols + 1, sizeof(int));

		elist->list.tbar_item = (ListTbarCell *) XtCalloc(elist->list.num_cols + 1, sizeof(ListTbarCell));

		elist->list.tbar_item_last = (ListTbarCell *) XtCalloc(elist->list.num_cols + 1, sizeof(ListTbarCell));
	}
	
	elist->list.num_cols++;

	elist->list.readonly_num_cols = elist->list.num_cols;
#ifdef DEBUG
	printf("\n XmNlListAppendColumn ok cols %d\n", elist->list.num_cols);
#endif

	LoadTbCellSetFromColSpecTable(w, csrec);
	
	if (elist->list.AutoPlacementMarker && (elist->list.num_cols - 1) == elist->list.markedColNumber)
	{
		elist->list.tbar_item[elist->list.num_cols - 1].markedStatus = elist->list.markedStatus;
		if (elist->list.tbar_item[elist->list.num_cols - 1].markedStatus == XmARROW_UP)
		{
			elist->list.tbar_item[elist->list.num_cols - 1].pixmap = elist->list.markerUpPixmap;
			elist->list.tbar_item[elist->list.num_cols - 1].mask = elist->list.markerUpMask;
		}
		else
			if (elist->list.tbar_item[elist->list.num_cols - 1].markedStatus == XmARROW_DOWN)
			{
				elist->list.tbar_item[elist->list.num_cols - 1].pixmap = elist->list.markerDownPixmap;
				elist->list.tbar_item[elist->list.num_cols - 1].mask = elist->list.markerDownMask;
			}
			else
				{
					elist->list.tbar_item[elist->list.num_cols - 1].pixmap = XmUNSPECIFIED_PIXMAP;
					elist->list.tbar_item[elist->list.num_cols - 1].mask = XmUNSPECIFIED_PIXMAP;
				}
	}
	else
	{
		elist->list.tbar_item[elist->list.num_cols - 1].markedStatus = XmARROW_LEFT;
	}
	
	elist->list.autoAdjustedNum = 0;
	for (i = 0; i < elist->list.num_cols; i++)
	{
		if (elist->list.tbar_item[i].column_type != XmPIXMAP)
			elist->list.autoAdjustedNum++;
	}

//	ListTbarCellSetPrint(elist->list.num_cols, elist->list.tbar_item);
	
	CalcTitleBarParam(w, True);
	CalcTitleBarGeomOverall(w);
	
	if (!XtIsRealized(w))
		return 0;
	
	LayoutChildren(w);
/***********************************************************************
 * LayoutChildren(w) call XtConfigure for ResCol widget. If ResCol widget
 * not empty then ResizeCB will be called and title bar will be redrawed
 * correctly. If ResCol widget is empty, then need call redrawing manualy
 **********************************************************************/
 
	if (elist->list.ListEmpty)
	{
		RefreshTitleBar(w);
		InternRedisplayTitleBar(w);
	}
	
	elist->list.readonly_num_cols = elist->list.num_cols;
#ifdef DEBUG
	printf("\n XmNlListAppendColumn ok cols %d\n", elist->list.num_cols);
#endif
	
}

int XmNlListDeleteColumn(Widget w, int column)
{
	XmNlListWidget elist = (XmNlListWidget) w;
	int i, *col;
	ListTbarCell * tbar_item_new;


#ifdef DEBUG
	printf("\n XmNlListDeleteColumn start cols %d\n", elist->list.num_cols);
#endif

	if (column > elist->list.num_cols - 1)
		return -1;

	if (elist->list.num_cols < 2)
		return -1;

	col = (int *) XtCalloc(elist->list.num_cols - 1, sizeof(int));
	memcpy((void *) col, (void *) elist->list.TSize, sizeof(int) * column);
	memcpy((void *) (col + column), (void *) (elist->list.TSize + column + 1), 
			sizeof(int) * (elist->list.num_cols - column - 1));
	XtFree((char *) elist->list.TSize);
	elist->list.TSize = col;
	
	col = (int *) XtCalloc(elist->list.num_cols - 1, sizeof(int));
	memcpy((void *) col, (void *) elist->list.FlSize, sizeof(int) * column);
	memcpy((void *) (col + column), (void *) (elist->list.FlSize + column + 1), 
			sizeof(int) * (elist->list.num_cols - column - 1));
	XtFree((char *) elist->list.FlSize);
	elist->list.FlSize = col;
	
	col = (int *) XtCalloc(elist->list.num_cols - 1, sizeof(int));
	memcpy((void *) col, (void *) elist->list.CurSize, sizeof(int) * column);
	memcpy((void *) (col + column), (void *) (elist->list.CurSize + column + 1), 
			sizeof(int) * (elist->list.num_cols - column - 1));
	XtFree((char *) elist->list.CurSize);
	elist->list.CurSize = col;
	

	tbar_item_new = elist->list.tbar_item + column;
	if (tbar_item_new->xmlabel)
		XmStringFree(tbar_item_new->xmlabel);


	tbar_item_new = (ListTbarCell *) XtCalloc(elist->list.num_cols - 1, sizeof(ListTbarCell));
	memcpy((void *) tbar_item_new, (void *) elist->list.tbar_item, sizeof(ListTbarCell) * column);
	memcpy((void *) (tbar_item_new + column), (void *) (elist->list.tbar_item + column + 1), 
			sizeof(ListTbarCell) * (elist->list.num_cols - column - 1));
	XtFree((char *) elist->list.tbar_item);
	elist->list.tbar_item = tbar_item_new;
	
	
	tbar_item_new = (ListTbarCell *) XtCalloc(elist->list.num_cols - 1, sizeof(ListTbarCell));
	memcpy((void *) tbar_item_new, (void *) elist->list.tbar_item_last, sizeof(ListTbarCell) * column);
	memcpy((void *) (tbar_item_new + column), (void *) (elist->list.tbar_item_last + column + 1), 
			sizeof(ListTbarCell) * (elist->list.num_cols - column - 1));
	XtFree((char *) elist->list.tbar_item_last);
	elist->list.tbar_item_last = tbar_item_new;
	
	elist->list.num_cols--;

	elist->list.readonly_num_cols = elist->list.num_cols;
#ifdef DEBUG
	printf("\n XmNlListDeleteColumn ok cols %d\n", elist->list.num_cols);
#endif

	
	
	elist->list.autoAdjustedNum = 0;
	for (i = 0; i < elist->list.num_cols; i++)
	{
		if (elist->list.tbar_item[i].column_type != XmPIXMAP)
			elist->list.autoAdjustedNum++;
	}

//	ListTbarCellSetPrint(elist->list.num_cols, elist->list.tbar_item);
	
	CalcTitleBarParam(w, True);
	CalcTitleBarGeomOverall(w);
	
	if (!XtIsRealized(w))
		return 0;
	
	LayoutChildren(w);
/***********************************************************************
 * LayoutChildren(w) call XtConfigure for ResCol widget. If ResCol widget
 * not empty then ResizeCB will be called and title bar will be redrawed
 * correctly. If ResCol widget is empty, then need call redrawing manualy
 **********************************************************************/
 
	if (elist->list.ListEmpty)
	{
		RefreshTitleBar(w);
		InternRedisplayTitleBar(w);
	}
	
	elist->list.readonly_num_cols = elist->list.num_cols;
#ifdef DEBUG
	printf("\n XmNlListAppendColumn ok cols %d\n", elist->list.num_cols);
#endif
	
}




int XmNlListSetColumn(Widget w, XmNlColSpecRec * csrec, int col_num)
{
	XmNlListWidget elist = (XmNlListWidget) w;
	int i;

#ifdef DEBUG
	printf("\n XmNlListSetColumn start cols %d changed %d\n", elist->list.num_cols, col_num);
#endif

	if (col_num >= elist->list.num_cols)
	{
		return 1;
	}

	LoadTbCellFromColSpec(w, csrec, col_num);

	elist->list.autoAdjustedNum = 0;
	for (i = 0; i < elist->list.num_cols; i++)
	{
		if (elist->list.tbar_item[i].column_type != XmPIXMAP)
			elist->list.autoAdjustedNum++;
	}

#ifdef DEBUG
	printf("\n XmNlListSetColumn loaded\n");
#endif

#ifdef DEBUG
	ListTbarCellSetPrint(elist->list.num_cols, elist->list.tbar_item);
#endif
	
	CalcTitleBarParam(w, False);
	CalcTitleBarGeomOverall(w);
	XClearArea(XtDisplay(w), XtWindow(w), 0, 0,
				XtWidth(w),XtHeight(w), False);
	LayoutChildren(w);
	_DRAW_TB_SHADOW(w, elist);
	_DRAW_RC_SHADOW(w, elist);
		InternRedisplayTitleBar(w);
/***********************************************************************
 * LayoutChildren(w) call XtConfigure for ResCol widget. If ResCol widget
 * not empty then ResizeCB will be called and title bar will be redrawed
 * correctly. If ResCol widget is empty, then need call redrawing manualy
 **********************************************************************/
 
	if (elist->list.ListEmpty)
	{
		RefreshTitleBar(w);
		InternRedisplayTitleBar(w);
	}
	
	elist->list.readonly_num_cols = elist->list.num_cols;
#ifdef DEBUG
	printf("\n XmNlListSetColumn ok cols %d\n", elist->list.num_cols);
#endif
	
}



int XmNlListCleanAllColumn(Widget w)
{
	XmNlListWidget elist = (XmNlListWidget) w;
	ListTbarCell * cell = elist->list.tbar_item;
	int i;
#ifdef DEBUG
	printf("\n XmNlListCleanAllColumn enter cols %d\n", elist->list.num_cols);
#endif


	CleanTbarCellSet(w);
	elist->list.tbar_item = NULL;
	elist->list.tbar_item_last = NULL;
	elist->list.num_cols = 0;

#ifdef DEBUG
	printf("\n XmNlListCleanAllColumn exit cols %d\n", elist->list.num_cols);
#endif
	return 0;
}
