/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */

#ifndef _XmNlItemBoxP_h
#define _XmNlItemBoxP_h

#if defined(VMS) || defined(__VMS)
#include <X11/apienvset.h>
#endif

/************************************************************
*	INCLUDE FILES
*************************************************************/
//#include <Xm/ManagerP.h>
#include <Xm/PrimitiveP.h>

#include "XmNl.h"
#include "XmNlItemBox.h"
#include "XmNlShareP.h"

/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*
 * ItemBox Stuff.
 */

#define XmNlItemBoxIndex (XmPrimitiveIndex + 1)
#define RtoL_render 1
#define LtoR_render 2


/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/
/*typedef struct _IconInfo {
	Pixmap pix;
	Pixmap mask;
	Pixmap parent;
	Pixmap highlighted;
	unsigned int width, height;
	int use_counter;
	struct _IconInfo * next;
} IconInfo;
*/

typedef struct _XmNlItBoxInfo {
//	Pixmap pixmap;
//	Pixmap mask;
	String name;
	XmString xmlabel;
	Dimension label_width;
	Dimension label_height;
	Boolean selected;
	void * UserDataPointer;
	unsigned char alignment;
	IconInfo * icon;
	void * buf; /* pointer to CacheBufElement*/
} XmNlItBoxInfo;

//typedef struct _CacheBufElement {
//	Pixmap id;
//	int ht;
//	int wd;
//	XmNlItBoxInfo * cell;
//	void * cell; /* Pointer to XmNlItBoxInfo cell or XmNlRCL_Cell cell */
//	struct _CacheBufElement * next;
//} CacheBufElement;

/*
 * ItemBox widget definitions.
 */

typedef struct _ItemBoxClassPart {
    XtPointer extension;	/* Just in case we need it later. */
} ItemBoxClassPart;

typedef struct _XmNlItemBoxClassRec {
    CoreClassPart		core_class;
    XmPrimitiveClassPart	primitive;
    ItemBoxClassPart		ibox_class;
} XmNlItemBoxClassRec;

typedef struct _XmNlItemBoxPart {
	/*
	* Resources
	*/
	XFontStruct *font;
    XmFontList font_list;	/* This widget's font list. */
	int PublicItemCount;
	int SelectedPositionsCount;
	int * SelectedPositions;
	int TopItemPosition;
	int VisibleItemCount;
	Boolean DestroyPhase;
	Boolean buffering;
	Boolean select_notify;
	unsigned char render_order;
	unsigned char viewtype;
	Dimension margin_h;
	Dimension margin_w;
	Dimension select_line_w;
	Dimension select_line_margin;
	unsigned char select_line_style;
	Dimension text_spacing;
    unsigned char alignment;
    Pixel select_background_pixel;
    Pixel select_foreground_pixel;
    Widget v_bar, h_bar; /* Scrollbars that may be used to scroll this widget. */

	XtCallbackList double_click; /* The double click callback list. */
	XtCallbackList highlightCallback;


	XtPointer mps;
	XtPointer mpsX;


	/* 
	* Private State
	*/
	Dimension viewX;
	Dimension viewY;
	Dimension viewWidth;
	Dimension viewHeight;
	Dimension base_y;
	GC pixGC;
	GC normalGC;
	GC eraseGC;
	GC eorGC;
	GC highlightGC;
	XmNlItBoxInfo ** item_data;
//	int num_ptrs;
	int num_items;  /* Number of items in widget */
	IconInfo * IconList;
	CacheBufElement * CacheBufIndex;
/*************************************************/
	CacheBufElement * FirstBuf;
	CacheBufElement * LastBuf;
	CacheBufElement * FirstFreeBuf;
	int CacheBufLimit;
	int UsedBufNum;
	int FreeBufNum;
/************************************************/
	int CacheBufNum;
	int CacheBufPosition;
	int firstViewItem;
	int lastViewItem;
	unsigned int cell_width;
	unsigned int cell_height;
	int col_num;		/* Column number in file view win	*/
	int row_num;		/* Row number in file view win		*/
	int view_row;
	int max_icon_height;
	int max_icon_width;
	int full_height;
	int scroll_height;
	int global_shift;
	Boolean HasFocus;
	int clicked_item;
/* Multiclick */
	Boolean DblClicked;
	int last_click_time;
	int last_click_item;

	int VisibleCount;
	int VisibilityState;
	Boolean       DownShift;
	Boolean       RedrawNeed;
	Boolean	MouseMoved;
	int TopVisibleRow;
	int BotVisibleRow;
	int LastTopVisibleRow;
	int LastBotVisibleRow;
	int firstVisibleItem;
	int firstVisibleY;
	int DeltaShift;

    Pixel background_pixel;
	Pixel foreground_pixel;
	Pixel highlight_pixel;
	int	select_start_point_x;
	int	select_start_point_y;
	int	select_end_point_x;
	int	select_end_point_y;
	int last_select_end_point_x;
	int last_select_end_point_y;
	int b_col;
	int e_col;
	int b_row;
	int e_row;
	
	int	m_select;
	int	m_x1;
	int	m_x2;
	int	m_y1;
	int	m_y2;
	int	m_last_x1;
	int	m_last_x2;
	int	m_last_y1;
	int	m_last_y2;
	int	m_cur_x;
	int	m_cur_y;
	int	m_b_x;
	int	m_b_y;
	int	auto_scroll;
	int	interval;
	int	delta_shift;
	XtIntervalId motion_timer;
	int motion_timer_found;
//	int	cur_sel_count;
//	int * cur_sel_massiv; /* Public resource of widget*/
	int current_item;
} XmNlItemBoxPart;

typedef struct _XmNlItemBoxRec {
    CorePart		core;
    XmPrimitivePart	primitive;
    XmNlItemBoxPart	itbox;
} XmNlItemBoxRec;


/************************************************************
*	EXTERNAL DECLARATIONS
*************************************************************/



//typedef struct _XmItemBoxClassRec	*XmItemBoxWidgetClass;
//typedef struct _XmItemBoxRec	*XmItemBoxWidget;

extern void _XmHighlightColorDefault( 
                        Widget widget,
                        int offset,
                        XrmValue *value) ;

extern void _XmForegroundColorDefault(
        		Widget widget,
        		int offset,
        		XrmValue *value );

extern void _XmBackgroundColorDefault(
        	Widget widget,
        	int offset,
        	XrmValue *value );

extern XmNlItemBoxClassRec xmNlItemBoxClassRec;
extern WidgetClass xmNlItemBoxWidgetClass; 

#if defined(__cplusplus)
}
#endif

/************************************************************
*	STATIC DECLARATIONS
*************************************************************/

#if defined(VMS) || defined(__VMS)
#include <X11/apienvrst.h>
#endif

#endif /* _XmNlItemBoxP_h */
