/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */

#ifndef _XmNlItemBox_h
#define _XmNlItemBox_h

#if defined(VMS) || defined(__VMS)
#include <X11/apienvset.h>
#endif

//#include <Xm/Ext.h>

/************************************************************
*	INCLUDE FILES
*************************************************************/
#include "XmNl.h"

/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

#define XmANY_COLUMN	-1

/*#define XmNnumItems		"num_items"*/
//#define XmNentryData		"entry_data"
/*#define XmCNumItems		"NumItems"*/
//#define XmCEntryData		"EntryData"
//#define XmCScrollBar		"ScrollBar"
/*#define XmNBackground		"Background"
#define XmNSelectBackground	"SelectBackground"
#define XmNForeground		"Foreground"
#define XmNSelectForeground	"SelectForeground"
#define XmNfontlist		"fontlist"
#define XtNhighlightCallback	"highlightCallback"*/
//#define XmNdoubleClickCallback	"doubleClickCallback"



/*#define XmNselectLineStyle	"select_line_style" 
#define XmNselectLineWidth	"select_line_width"
#define XmCSelectLineWidth	"SelectLineWdth"
#define XmNselectLineMargin	"select_line_margin"
#define XmCSelectLineMargin	"SelectLineMargin"

#define XmNlTextSpacing		"textSpacing"
#define XmCTextSpacing		"text_spacing"
#define XmNlBufferingOn		"bufferingOn"
#define XmCbufferingOn		"buffering_on"
#define XmNlRLineStyle		"mNlLineStyle"*/

#define XmNlSelectAutoNotify		"selectNotify"
#define XmCSelectAutoNotify		"select_notify"

enum { XmNlLINE_SOLID=0, XmNlLINE_DASH=1, XmNlLINE_OFDASH=2 };

typedef struct _XmNlItemBoxClassRec	*XmNlItemBoxWidgetClass;
typedef struct _XmNlItemBoxRec		*XmNlItemBoxWidget;

/*typedef struct _XmNlItBoxInfo {

Pixmap pixmap;
Pixmap mask;
String name;
XmString xmlabel;
Boolean selected;
void * UserDataPointer;
Boolean textselected;
Pixmap buftext;
} XmNlItBoxInfo;*/

void XmNlItBoxDeleteAllItems(Widget w);

int XmNlItBoxXYtoPos(Widget w, unsigned long x, unsigned long y);

void XmNlItBoxAddItems(Widget w, XmNlCell *items, int count, unsigned char valuemask);

void XmNlItBoxGetSelectedItems(Widget w, int *count, int ** select_numbers);

void XmNlItBoxSetItem(Widget w, XmNlCell *items, unsigned char valuemask, int position);

void * XmNlItBoxGetUserDataFromPos(Widget w, int number);

void XmNlItBoxInsertItems(Widget w, XmNlCell *items, int first_pos, int count, unsigned char valuemask);

Boolean XmNlItBoxGetItem(Widget w, XmNlCell *item, unsigned char valuemask, int position);

Boolean XmNlItBoxGetItemAtPointer(Widget w, XmNlCell *item, unsigned char valuemask, const void * pointer);

void XmNlItBoxDeleteItems(Widget w, int * position, int count);

void XmNlItBoxSort(Widget w, int start, int lenght, int (*comparer)(const void *, const void *));

/* This is private function, used only from XmNlList widget */
void _XmNlItBoxAddScrolls(Widget);

/************************************************************
*	MACROS
*************************************************************/

/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/

/*typedef struct _ListItemReturnStruct {
  int		reason;
  XEvent	*event;
  int		*number;
  int		count;
} ListItemReturnStruct;


typedef struct _ItemActivateReturnStruct {
  int		reason;
  XEvent	*event;
  int		item_number;
} ItemActivateReturnStruct;

*/
/************************************************************
*	EXTERNAL DECLARATIONS
*************************************************************/

extern WidgetClass xmNlItemBoxWidgetClass;

#if defined(__cplusplus)
}
#endif

#if defined(VMS) || defined(__VMS)
#include <X11/apienvrst.h>
#endif

#endif /* _XmNlItemBox_h */
