/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */


/************************************************************
*	INCLUDE FILES
*************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>

#include <Xm/XmP.h>

#if (XmVERSION >= 2)
#include <Xm/DrawP.h>
#endif

#include "XmNlItemBoxP.h"
//#include "XmNl.h"
#include <Xm/ScrollBar.h>
#include <Xm/XmP.h>
#include <Xm/RepType.h>

#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <assert.h>
/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/

#define SUPERCLASS ((WidgetClass) &xmPrimitiveClassRec)

#define SM_H_MARGIN 3
#define SM_V_MARGIN 3
#define SM_F_SPACE 2
#define SM_SCROLLING_SHIFT 8


/************************************************************
*	MACROS
*************************************************************/

#define streq(a, b) (((a) != NULL) && ((b) != NULL) && (strcmp((a), (b)) == 0))
#define PIX_FOUND(value) ((value <= XmUNSPECIFIED_PIXMAP) ? 0 : 1)

/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/

static String SelectLineStyleNames[] = {
	"line_solid",
	"line_double_dash",
	"line_on_of_dash"
};

static XmRepTypeId SelectLineStyleId;

/************************************************************
*	STATIC FUNCTION DECLARATIONS
*************************************************************/

/******************************
 * Exported Widget Functions
 ******************************/

static void ClassInitialize();
static void Initialize(Widget, Widget, ArgList, Cardinal *);
static void Realize(Widget, Mask *, XSetWindowAttributes *);
static void Resize(Widget);
static void Redisplay(Widget, XEvent *, Region);
static void Destroy(Widget);
static Boolean SetValues(Widget, Widget, Widget, ArgList, Cardinal *);
static void ClassPartInitialize(WidgetClass c );

/***********************************
 * Internal routines.
 ***********************************/
static Boolean RecalcParamLarge( Widget w, int FirstPosition, int count);
static Boolean RecalcParamSmall( Widget w, int FirstPosition, int count);
static Boolean CalcGeom( Widget w);
static void ResizeStuff(XmNlItemBoxWidget w);
static void ResizeSliders(Widget w);
static Boolean AdjustGlobalShift(Widget w);
static void MakeMultiCallbackStruct(XmNlItemBoxWidget it, ListItemReturnStruct * ret);
static void HighlightDoCallback(Widget w, int reason, XEvent *event);
static void DoubleClickDoCallback(Widget w, int number);
static int BoundSelect(Widget w);
static int ReBoundSelect(Widget w);
static void SelectUpScroll(XtPointer client_data, XtIntervalId *timer);
static void SelectDownScroll(XtPointer client_data, XtIntervalId *timer);
static Boolean SelectChanged(XmNlItemBoxWidget it);
static void CheckSetRenderTable(Widget wid, int offset, XrmValue *value);
static void RedrawWindow(Widget w, XEvent * event, Region region);
static void RecalcRegions(Widget w);
static void ConvertLineStyleProc(Widget wid, int offset, XrmValue *value);
void RedrawRegion(Widget , int , int , int , int , int );
void DrawItem(Widget , XmNlItBoxInfo * , int , int , int , int );
static void CheckRenderOrder(XmNlItemBoxWidget it);
static void DeleteCell(XmNlItemBoxWidget it, XmNlItBoxInfo * cell);
static void RedrawAllDirect(Widget );
static void DeletePixBufCache(XmNlItemBoxWidget );
static void DeleteAllPixBufCache(XmNlItemBoxWidget );
static void FreeCacheNode(XmNlItemBoxWidget , XmNlItBoxInfo * );
static void CorrectGlobalShift(Widget );
static void VisibilityChangeProc(Widget , XtPointer , XEvent *, Boolean *);
static void ChangeIconsBackgroud(XmNlItemBoxWidget );
/*static void ClearIconList(XmNlItemBoxWidget );*/
static void RefreshLabels(Widget w);
static void ClearSelectedPositions(XmNlItemBoxWidget it);
static void CopySelectedPositions(XmNlItemBoxWidget it);
static void ChangeCellSelection(Widget w, XmNlItBoxInfo * cell, Boolean selected);

/***********************************
 * Actions and Callback function defs.
 ***********************************/

static void VScrollCallback(Widget w, XtPointer client_data, XtPointer call_data);
static void HScrollCallback(Widget w, XtPointer client_data, XtPointer call_data);
static void ButtonDownAction(Widget, XEvent *, String *, Cardinal *);
static void ButtonUpAction(Widget, XEvent *, String *, Cardinal *);
static void MotionAction(Widget, XEvent *, String *, Cardinal *);
static void ScrollAction(Widget, XEvent *, String *, Cardinal *);
static void KeyPressAction(Widget, XEvent *, String *, Cardinal *);
static void FocusInAction(Widget, XEvent *, String *, Cardinal *);
static void FocusOutAction(Widget, XEvent *, String *, Cardinal *);
/*static void UpMoveAction(Widget w, XEvent *event);
static void DownMoveAction(Widget w, XEvent *event);
static void LeftMoveAction(Widget w, XEvent *event);
static void RightMoveAction(Widget w, XEvent *event);
static void ActivateKeyAction(Widget w, XEvent *event);*/
static void SelectExtendedAction(Widget w, XEvent *event, String *params, Cardinal *num_params);


/************************************************************
*	STATIC DECLARATIONS
*************************************************************/

static char defaultTranslations[] =
     "<FocusIn>:			FocusIn()\n\
     <FocusOut>:			FocusOut()\n\
     c ~m ~s ~a <Btn1Down>:	SelectExtended()\n\
     <Btn1Down>:			ButtonDown()\n\
     Button1 <Motion>:		Motion()\n\
     <Btn4Up>:				Scroll(Up)\n\
     <Btn5Up>:				Scroll(Down)\n\
     <Btn1Up>:				ButtonUp()\n\
     :<Key>Return:			Keypress(Enter)\n\
     :<Key>osfUp:			Keypress(Up)\n\
     :<Key>osfDown:			Keypress(Down)\n\
     :<Key>osfLeft:			Keypress(Left)\n\
     :<Key>osfRight:		Keypress(Right)\n\
     :<Key>space:			Keypress(Space)\n\
     s ~m ~a <Key>Tab:		Keypress(PrevTab)\n\
     ~m ~a <Key>Tab:		Keypress(NextTab)";

static XtActionsRec actionsList[] =
{
  {"ButtonDown",		ButtonDownAction},
  {"ButtonUp",			ButtonUpAction},
  {"SelectExtended", 	SelectExtendedAction},
  {"Scroll",		 	ScrollAction},
  {"Motion",		 	MotionAction},
  {"Keypress",		 	KeyPressAction},
  {"FocusIn",		 	FocusInAction},
  {"FocusOut",		 	FocusOutAction},
};


/* ARGSUSED */
#define offset(field) XtOffsetOf(XmNlItemBoxRec, itbox.field)
static XtResource resources[] = {
	{XmNitemCount, XmCItemCount, XmRInt, sizeof(int),
		offset(PublicItemCount), XmRImmediate, (XtPointer) 0},
	{XmNselectedPositionCount, XmCSelectedPositionCount, XmRInt, sizeof(int),
		offset(SelectedPositionsCount), XmRImmediate, (XtPointer) 0},
	{XmNselectedPositions, XmCSelectedPositions, XmRPointer, sizeof(XtPointer),
		offset(SelectedPositions), XmRImmediate, (XtPointer) 0},
	{XmNtopItemPosition, XmCTopItemPosition, XmRInt, sizeof(int),
		offset(TopItemPosition), XmRImmediate, (XtPointer) 0},
	{XmNvisibleItemCount, XmCVisibleItemCount, XmRInt, sizeof(int),
		offset(VisibleItemCount), XmRImmediate, (XtPointer) 0},
	{"pri.vate", "Pri.vate", XmRBoolean,
		sizeof(Boolean), offset(MouseMoved),
		XmRImmediate, (XtPointer)False
	},
	{XmNfontList,	XmCFontList, XmRFontList, sizeof (XmFontList),
		offset (font_list), XmRCallProc, (XtPointer)CheckSetRenderTable},
	{XmNrenderTable, XmCRenderTable, XmRRenderTable,
		sizeof(XmRenderTable), offset(font_list),
		XmRCallProc, (XtPointer)CheckSetRenderTable
	},
	{XmNverticalScrollBar, XmCVerticalScrollBar, XmRWidget, sizeof (Widget),
		offset (v_bar), XmRImmediate, (XtPointer) NULL},
	{XmNhorizontalScrollBar, XmCHorizontalScrollBar, XmRWidget, sizeof (Widget),
		offset (h_bar), XmRImmediate, (XtPointer) NULL},
	{XmNselectColor, XmCSelectColor, XmRSelectColor, sizeof(Pixel),
		offset(select_background_pixel), XmRImmediate, (XtPointer)XmREVERSED_GROUND_COLORS},
	{XmNselectForeground, XmCSelectForeground, XtRPixel, sizeof(Pixel),
		offset(select_foreground_pixel), XmRCallProc, (XtPointer) _XmBackgroundColorDefault},
//   {
//     XmNhighlightColor, XmCHighlightColor, XmRPixel,
//     sizeof (Pixel),
//     offset(highlight_pixel),
//     XmRCallProc, (XtPointer) _XmHighlightColorDefault
//   },
    {
		XmNmarginHeight, XmCMarginHeight, XmRVerticalDimension,
		sizeof(Dimension),
		offset(margin_h),
		XmRImmediate,(XtPointer)SM_V_MARGIN},
    {
		XmNmarginWidth, XmCMarginWidth, XmRHorizontalDimension,
		sizeof(Dimension),
		offset(margin_w),
		XmRImmediate,(XtPointer)SM_H_MARGIN},
    {
		XmNselectLineStyle, XmCLineStyle, XmNlRLineStyle,
		sizeof(unsigned char),
		offset(select_line_style),
		XmRImmediate, (XtPointer) 0},
    {
		XmNselectLineWidth, XmCSelectLineWidth, XmRHorizontalDimension,
		sizeof(Dimension),
		offset(select_line_w),
		XmRImmediate,(XtPointer)2},
    {
		XmNselectLineMargin, XmCSelectLineMargin, XmRHorizontalDimension,
		sizeof(Dimension),
		offset(select_line_margin),
		XmRImmediate,(XtPointer)2},
    {
		XmNlTextSpacing, XmCTextSpacing, XmRHorizontalDimension,
		sizeof(Dimension),
		offset(text_spacing),
		XmRImmediate,(XtPointer)2},
	{XtNhighlightCallback, XmCCallback, XmRCallback,sizeof(XtCallbackList),
		offset(highlightCallback), XmRImmediate, (XtPointer) NULL},
	{XmNdoubleClickCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
		offset(double_click), XmRImmediate, (XtPointer) NULL},
	{
		XmNlBufferingOn, XmCbufferingOn, XmRBoolean,
		sizeof(Boolean), offset(buffering),
		XmRImmediate, (XtPointer)False
	},
	{
		XmNlSelectAutoNotify, XmCSelectAutoNotify, XmRBoolean,
		sizeof(Boolean), offset(select_notify),
		XmRImmediate, (XtPointer)False
	},
	{
		 XmNalignment, XmCAlignment, XmRAlignment, sizeof(unsigned char),
		 offset(alignment),
		 XmRImmediate, (XtPointer) XmALIGNMENT_BEGINNING
//	     XmRImmediate, (XtPointer) XmALIGNMENT_CENTER
//  	   XmRImmediate, (XtPointer) XmALIGNMENT_END
	},
	{
		XmNviewType, XmCViewType, XmRViewType, sizeof(unsigned char),
		offset(viewtype),
//		XmRImmediate,(XtPointer)XmSMALL_ICON},
		XmRImmediate,(XtPointer)XmLARGE_ICON},
};
#undef offset

static XmSyntheticResource syn_resources[] =
  {
#define offset(field) XtOffsetOf(XmNlItemBoxRec, itbox.field)
	{
	XmNmarginHeight,
  	sizeof (Dimension),
	offset(margin_h),
  	XmeFromHorizontalPixels,
	XmeToHorizontalPixels
	},
	{
	XmNmarginWidth,
  	sizeof (Dimension),
	offset(margin_w),
  	XmeFromVerticalPixels,
	XmeToVerticalPixels
	},
	{
	XmNselectLineWidth,
  	sizeof (Dimension),
	offset(select_line_w),
  	XmeFromHorizontalPixels,
	XmeToHorizontalPixels
	},
	{
	XmNselectLineMargin,
  	sizeof (Dimension),
	offset(select_line_margin),
  	XmeFromHorizontalPixels,
	XmeToHorizontalPixels
	},
	{
	XmNlTextSpacing,
  	sizeof (Dimension),
	offset(text_spacing),
  	XmeFromHorizontalPixels,
	XmeToHorizontalPixels
	},
#undef offset
  };

static XmBaseClassExtRec BaseClassExtRec = {
  NULL,				/* next_extension	 */
  NULLQUARK,			/* record_type		 */
  XmBaseClassExtVersion,	/* version		 */
  sizeof(XmBaseClassExtRec),	/* record_size		 */
  NULL,				/* InitializePrehook	 */
  NULL,				/* SetValuesPrehook	 */
  NULL,				/* InitializePosthook	 */
  NULL,				/* SetValuesPosthook	 */
  NULL,				/* secondaryObjectClass	 */
  NULL,				/* secondaryCreate	 */
  NULL,				/* getSecRes data	 */
  { 0 },			/* fastSubclass flags	 */
  NULL,				/* get_values_prehook	 */
  NULL,				/* get_values_posthook	 */
  NULL,				/* classPartInitPrehook  */
  NULL,				/* classPartInitPosthook */
  NULL,				/* ext_resources         */
  NULL,				/* compiled_ext_resources*/
  0,				/* num_ext_resources     */
  FALSE,			/* use_sub_resources     */
  XmInheritWidgetNavigable,	/* widgetNavigable       */
  XmInheritFocusChange,		/* focusChange           */
};

XmNlItemBoxClassRec xmNlItemBoxClassRec = {
  { /* core fields 				*/
    /* superclass				*/	SUPERCLASS,
    /* class_name				*/	"XmNlItemBox",
    /* widget_size				*/	sizeof(XmNlItemBoxPart),
    /* class_initialize			*/	ClassInitialize,
    /* class_part_initialize	*/	NULL, /*ClassPartInitialize,*/
    /* class_inited				*/	FALSE,
    /* initialize				*/	Initialize,
    /* initialize_hook			*/	NULL,
    /* realize					*/	Realize,
    /* actions					*/	actionsList,
    /* num_actions				*/	XtNumber(actionsList),
    /* resources				*/	(XtResource*)resources,
    /* num_resources			*/	XtNumber(resources),
    /* xrm_class				*/	NULLQUARK,
    /* compress_motion			*/	TRUE,
    /* compress_exposure		*/	XtExposeCompressMultiple,
    /* compress_enterleave		*/	TRUE,
    /* visible_interest			*/	FALSE,
    /* destroy					*/	Destroy,
    /* resize					*/	Resize,
    /* expose					*/	Redisplay,
    /* set_values				*/	SetValues,
    /* set_values_hook			*/	NULL,
    /* set_values_almost		*/	XtInheritSetValuesAlmost,
    /* get_values_hook			*/	NULL,
    /* accept_focus				*/	NULL,
    /* version					*/	XtVersion,
    /* callback_private			*/	NULL,
    /* tm_table					*/	defaultTranslations,
    /* query_geometry			*/	XtInheritQueryGeometry,
    /* display_accelerator		*/	NULL, /*XtInheritDisplayAccelerator,*/
    /* extension				*/	(XtPointer) &BaseClassExtRec, /*NULL*/
  },
  { /* Xmprimitive fields */
      NULL, /*XmInheritBorderHighlight,*/			/* border_highlight   */
      NULL, /*XmInheritBorderUnhighlight,*/		/* border_unhighlight */
      NULL,  /*XtInheritTranslations, */   /* translations       */
      NULL,			               		/* arm_and_activate   */
      /*NULL,*/ syn_resources,   		/* syn resources      */
      /*0,*/ XtNumber(syn_resources),		/* num syn_resources  */
      NULL    			             /* extension          */
  },
  { /* ICS List fields */
      NULL          	            /* extension          */
  }
};

WidgetClass xmNlItemBoxWidgetClass = (WidgetClass)&xmNlItemBoxClassRec;

XmOffsetPtr XmNlItemBox_offsets;


/************************************************************
*	STATIC (EXPORTED) CODE
*************************************************************/

static void
DestroyGC(XmNlItemBoxWidget );

static void
InitializeGC(XmNlItemBoxWidget );

extern void
_XmInitializeSyntheticResources(XmSyntheticResource *, int );

extern void 
_XmBuildResources(XmSyntheticResource **, int *, XmSyntheticResource *, int );

extern void 
_XmSelectColorDefault(Widget widget, int offset, XrmValue *value);

static void 
ClassPartInitialize(
        WidgetClass c )
{
	XmPrimitiveWidgetClass wc = (XmPrimitiveWidgetClass) c ;

	XmPrimitiveWidgetClass sc = (XmPrimitiveWidgetClass) 
	wc->core_class.superclass;

	_XmInitializeSyntheticResources(wc->primitive_class.syn_resources,
	wc->primitive_class.num_syn_resources);

	if (sc == (XmPrimitiveWidgetClass) widgetClass) return;

	_XmBuildResources (&(wc->primitive_class.syn_resources),
						&(wc->primitive_class.num_syn_resources),
						sc->primitive_class.syn_resources,
						sc->primitive_class.num_syn_resources);
    
}


/*      Function Name: ClassInitialize
 *      Description:   Inits class-specific data (offsets)
 *      Arguments:     none
 *      Returns:       nothing
 */
static void
ClassInitialize()
{
    XmResolveAllPartOffsets(xmNlItemBoxWidgetClass,
			    &XmNlItemBox_offsets,
			    NULL);
    SelectLineStyleId = XmRepTypeRegister (XmNlRLineStyle, SelectLineStyleNames,
                                   NULL, XtNumber(SelectLineStyleNames));
}

/*	Function Name: Initialize
 *	Description:   Called to initialize information specific
 *                     to this widget.
 *	Arguments:     req - what was originally requested.
 *                     set - what will be created.
 *                     args, num_args - The arguments passed to
 *                                      the creation call.
 *	Returns:       none.
 */

/*ARGSUSED*/
static void Initialize(Widget req, Widget set,
		       ArgList args, Cardinal * num_args)
{
    XmNlItemBoxWidget ibox = (XmNlItemBoxWidget) set;
	EventMask event_mask;
	XrmValue val;
	XFontStruct *font;
	Boolean fontFound;

#ifdef DEBUG
	printf("\n XmNlItemBoxWidget Initialize, buffering %hhd fontlist %p selection line w %d \n", 
			ibox->itbox.buffering, ibox->itbox.font_list, ibox->itbox.select_line_w);
			
	printf("\n XmNlItemBoxWidget Initialize, fontlist addr %p %ld\n", 
			&(ibox->itbox.font_list), XtOffsetOf(XmNlItemBoxRec, itbox.font_list));

#endif

	ibox->itbox.font = XLoadQueryFont(XtDisplay(set), "fixed");
//      if (ibox->itbox.font_list == NULL)

//        ibox->itbox.font_list = XmeGetDefaultRenderTable(set, XmTEXT_FONTLIST);
//#ifdef DEBUG
//      printf("\n Initialize 2\n");
//#endif
//	ibox->itbox.font_list = XmFontListCopy(ibox->itbox.font_list);

#ifdef DEBUG
      printf("\n Initialize 3\n");
#endif


	ibox->itbox.DestroyPhase = False;
	ibox->itbox.item_data=NULL;
	ibox->itbox.num_items=0;
//	ibox->itbox.num_ptrs=0;
	ibox->itbox.cell_width=0;
	ibox->itbox.cell_height=0;
//	ibox->itbox.CacheBufLimit=40;
	ibox->itbox.CacheBufIndex=NULL;
	ibox->itbox.CacheBufNum=0;


	ibox->itbox.FirstBuf = NULL;
	ibox->itbox.LastBuf = NULL;
	ibox->itbox.FirstFreeBuf = NULL;
	ibox->itbox.CacheBufLimit = 0;
	ibox->itbox.UsedBufNum = 0;
	ibox->itbox.FreeBufNum = 0;



//	ibox->itbox.VisibleElement=NULL;
	ibox->itbox.VisibleCount=0;
	ibox->itbox.TopVisibleRow=0;
	ibox->itbox.BotVisibleRow=0;
	ibox->itbox.LastTopVisibleRow=0;
	ibox->itbox.LastBotVisibleRow=0;
	ibox->itbox.firstVisibleItem=0;
	ibox->itbox.firstVisibleY=0;


	ibox->itbox.PublicItemCount = 0;
	ibox->itbox.SelectedPositionsCount = 0;
	ibox->itbox.TopItemPosition = 0;
	ibox->itbox.VisibleItemCount = 0;


	ibox->itbox.firstViewItem = -1;
	ibox->itbox.lastViewItem = -1;

	ibox->itbox.DownShift=FALSE;
	ibox->itbox.RedrawNeed=FALSE;
	ibox->itbox.DeltaShift = 0;

	ibox->itbox.base_y = 0;

//	ibox->itbox.pix_buf_w=0;
//	ibox->itbox.pix_buf_h=0;
	ibox->itbox.col_num=0;
	ibox->itbox.row_num=0;
	ibox->itbox.view_row=0;
	ibox->itbox.max_icon_height=0;
	ibox->itbox.max_icon_width=0;
//	ibox->itbox.pix= (Pixmap) NULL;
	ibox->itbox.full_height=0;
	ibox->itbox.scroll_height=0;
//	ibox->itbox.pix_buf_row=0;
//	ibox->itbox.pix_shift=0;
	ibox->itbox.global_shift=0;
//	ibox->itbox.shift_in_pix=0;
//	ibox->itbox.multiclick=500;
//	ibox->itbox.sm_tm=0;
	ibox->itbox.auto_scroll=0;
	ibox->itbox.motion_timer_found = 0;

	ibox->itbox.m_select=0;
	ibox->itbox.m_x1=0;
	ibox->itbox.m_x2=0;
	ibox->itbox.m_y1=0;
	ibox->itbox.m_y2=0;
	ibox->itbox.m_last_x1=0;
	ibox->itbox.m_last_x2=0;
	ibox->itbox.m_last_y1=0;
	ibox->itbox.m_last_y2=0;
	ibox->itbox.m_cur_x=0;
	ibox->itbox.m_cur_y=0;

	ibox->itbox.b_col=0;
	ibox->itbox.e_col=0;
	ibox->itbox.b_row=0;
	ibox->itbox.e_row=0;

	ibox->itbox.SelectedPositionsCount = 0;
	ibox->itbox.SelectedPositions = NULL;
	ibox->itbox.DblClicked=False;
	ibox->itbox.clicked_item=-1;
	ibox->itbox.last_click_item = -1;
	ibox->itbox.last_click_time = 0;
	ibox->itbox.current_item=-1;
	ibox->itbox.HasFocus=False;
//	ibox->itbox.Rend = NULL;
	ibox->itbox.VisibilityState=VisibilityFullyObscured;
//      itm=ibox->itbox.item_data;
//	itm->name=NULL;
	if (ibox->itbox.font_list == NULL)
		ibox->itbox.font_list = XmeGetDefaultRenderTable ((Widget) ibox, XmTEXT_FONTLIST);
	ibox->itbox.font_list = XmFontListCopy(ibox->itbox.font_list);

#ifdef DEBUG
      printf("\n Initialize 2\n");
#endif

//    ibox->itbox.Rend = XmRenditionCreate(NULL, XmS, NULL, 0);

/*  Color initialization */

	if (ibox->itbox.select_background_pixel == XmDEFAULT_SELECT_COLOR)
	{
		_XmSelectColorDefault(set, 0, &val);
		ibox->itbox.select_background_pixel = *((Pixel*) val.addr);
	}
	else if (ibox->itbox.select_background_pixel == XmHIGHLIGHT_COLOR)
	{
		ibox->itbox.select_background_pixel = ibox->primitive.highlight_color;
	}

    ibox->itbox.background_pixel = ((XmPrimitiveWidget)req)->core.background_pixel;
    ibox->itbox.foreground_pixel = ((XmPrimitiveWidget)req)->primitive.foreground;

	InitializeGC(ibox);

    if (ibox->itbox.v_bar != NULL) {
			XtAddCallback(ibox->itbox.v_bar, XmNvalueChangedCallback,
					  VScrollCallback, (XtPointer) set);
			XtAddCallback(ibox->itbox.v_bar, XmNdragCallback,
					  VScrollCallback, (XtPointer) set);
    }

    if (ibox->itbox.h_bar != NULL) {
			XtAddCallback(ibox->itbox.h_bar, XmNvalueChangedCallback,
					  HScrollCallback, (XtPointer) set);
			XtAddCallback(ibox->itbox.h_bar, XmNdragCallback,
					  HScrollCallback, (XtPointer) set);
    }

#ifdef DEMO
    _XmInitialIzeConverters(req);
#endif


	fontFound = XmeRenderTableGetDefaultFont(ibox->itbox.font_list, &font);

    if (XtHeight(req) == 0)
    {
		Dimension height;
		if (fontFound)
			height = (font->ascent + font->descent + 2*ibox->itbox.select_line_w
					+ 3*ibox->itbox.select_line_margin + 2*ibox->itbox.margin_h) * 10;
		else
			height = (14 + 2*ibox->itbox.select_line_w
					+ 3*ibox->itbox.select_line_margin + 2*ibox->itbox.margin_h) * 10;

		ibox->core.height = height;
    }
    
    if (XtWidth(req) == 0)
    {
		Dimension width;
		if (fontFound)
			width = (font->ascent + font->descent + 2*ibox->itbox.select_line_w 
				+ 2*ibox->itbox.select_line_margin + 2*ibox->itbox.margin_w) * 5;
		else
			width = (20 + 2*ibox->itbox.select_line_w 
				+ 2*ibox->itbox.select_line_margin + 2*ibox->itbox.margin_w) * 5;

		ibox->core.width = width;
    }
    
	event_mask = VisibilityChangeMask;
	XtAddEventHandler(set, event_mask, False, VisibilityChangeProc, NULL);
}

/*	Function Name: Realize
 *	Description:   Called to realize this widget.
 *	Arguments:     w - Icon Box Widget to realize.
 *                     valueMask, attributes - attributes to use when creating
 *                     this widget's window.
 *	Returns:       none.
 *
 *      This overrides the Manager's frobbing with various values.
 */

static void
Realize(Widget w, Mask *valueMask, XSetWindowAttributes * attributes)
{
    XmNlItemBoxWidget ibox = (XmNlItemBoxWidget)w;

//    attributes->bit_gravity = ForgetGravity;
	CheckRenderOrder(ibox);
    if (ibox->itbox.render_order == LtoR_render) attributes->bit_gravity = NorthWestGravity;
    else attributes->bit_gravity = NorthEastGravity;
    *valueMask |= CWBitGravity;



#ifdef DEBUG
	if (XmGetFocusWidget(w) == w)
		printf("Realizeed ___FOCUSED___\n");
	else
		printf("Realizeed ___NOT_FOCUSED___\n");
#endif

    (*xmNlItemBoxWidgetClass->core_class.superclass->core_class.realize)
	(w, valueMask, attributes);


    (*xmNlItemBoxWidgetClass->core_class.resize)(w);
}

/*	Function Name: SetValues
 *	Description:   Called when some widget data needs to be modified on-
 *                     the-fly.
 *	Arguments:     current - the current (old) widget values.
 *                     request - before superclassed have changed things.
 *                     set - what will acutally be the new values.
 *                     args, num_args - the arguments in the list.
 *	Returns:       none
 *
 */

/*ARGSUSED*/
static Boolean SetValues(Widget current, Widget request, Widget set,
			 ArgList args, Cardinal * num_args)
{
    XmNlItemBoxWidget 	i_old = (XmNlItemBoxWidget)current;
    XmNlItemBoxWidget	i_set = (XmNlItemBoxWidget)set;
    register int 	i;
    Boolean 	redisplay = False;
    Boolean		recalculateFull = False;
    Boolean		recalculateGeom = False;
    Boolean		resort = False;
    Boolean		refreshGC = False;
    Boolean		readjust = False;
    Boolean		check_pos = False;
    Boolean		copyTitles = False;
    Boolean		refreshBuf = False;
    Boolean		refreshIcons = False;
	Boolean		resetSelectedList = False;
	Boolean		rebuildSelectedList = False;
//    XmNlItBoxInfo * itm;
	XrmValue val;

#ifdef DEBUG
      printf("\n SetValues \n");
#endif
//     itm=i_set->itbox.item_data;
    for (i = 0; i < *num_args; i++)
    {
		String name = args[i].name;
		if (streq(XmNnumItems, name))
		{
			if (i_set->itbox.num_items != i_old->itbox.num_items)
				i_set->itbox.num_items = i_old->itbox.num_items;
		}

/* Color section */

		if (i_set->itbox.select_background_pixel != i_old->itbox.select_background_pixel)
		{
			if (i_set->itbox.select_background_pixel == XmDEFAULT_SELECT_COLOR)
			{
				_XmSelectColorDefault((Widget)i_set,
								XtOffsetOf(XmNlItemBoxRec, itbox.select_background_pixel),
								&val);
				i_set->itbox.select_background_pixel = *((Pixel*) val.addr);
			}
			else if (i_set->itbox.select_background_pixel == XmHIGHLIGHT_COLOR)
			{
				i_set->itbox.select_background_pixel = i_set->primitive.highlight_color;
			}

			if (i_set->itbox.select_background_pixel != i_old->itbox.select_background_pixel)
			{
				redisplay = TRUE;
				refreshGC = TRUE;
				refreshBuf = True;
			}
		}


		if (i_set->core.background_pixel != i_old->core.background_pixel)
		{
			i_set->itbox.background_pixel=i_set->core.background_pixel;
			refreshIcons = True;
			refreshGC = True;
			redisplay = True;
			refreshBuf = True;
		}

		if (i_set->primitive.foreground != i_old->primitive.foreground)
		{
			i_set->itbox.foreground_pixel=i_set->primitive.foreground;
			refreshGC = True;
			redisplay = True;
			refreshBuf = True;
		}

		if (i_set->primitive.highlight_color != i_old->primitive.highlight_color)
		{
//			i_set->itbox.select_background_pixel=i_set->primitive.highlight_color;
			refreshGC = True;
			redisplay = True;
			refreshBuf = True;
		}

		if (i_set->itbox.select_foreground_pixel != i_old->itbox.select_foreground_pixel)
		{
			i_set->itbox.select_foreground_pixel=i_set->itbox.select_foreground_pixel;
			refreshGC = True;
			redisplay = True;
			refreshBuf = True;
		}

		if (i_set->itbox.viewtype != i_old->itbox.viewtype)
		{
			recalculateFull = True;
			recalculateGeom = True;
			refreshBuf = True;
			redisplay = True;
#ifdef DEBUG
			printf("\n IconBox viewtype changed\n");
#endif
		}


		if (streq(XmNfontList, name))
		{
	//	    refreshGC = True;
			  if (i_set->itbox.font_list == NULL)
			{
			  XmFontList font = XmeGetDefaultRenderTable(set, XmTEXT_FONTLIST);
			  i_set->itbox.font_list = XmFontListCopy(font);
			}
			  else if (i_set->itbox.font_list != i_old->itbox.font_list)
			{
			  i_set->itbox.font_list = XmFontListCopy(i_set->itbox.font_list);
			}

			  if (i_set->itbox.font_list != i_old->itbox.font_list)
			{
			  XmFontListFree(i_old->itbox.font_list);
			}
			recalculateFull = True;
			recalculateGeom = True;
			refreshBuf = True;
			redisplay = True;
#ifdef DEBUG
			printf("\n fontlist changed\n");
#endif
		}


		if (streq(XmNrenderTable, name))
		{
			recalculateFull = True;
			recalculateGeom = True;
			refreshBuf = True;
			redisplay = True;
#ifdef DEBUG
		  printf("\n fontlist changed\n");
#endif

		}


		if (streq(XmNmarginHeight, name))
		{
	//	    refreshGC = True;
			recalculateFull = True;
			recalculateGeom = True;
			refreshBuf = True;
			redisplay = True;
#ifdef DEBUG
		  printf("\n  XmNmarginHeight changed\n");
#endif
		}

		if (streq(XmNmarginWidth, name))
		{
	//	    refreshGC = True;
			recalculateFull = True;
			recalculateGeom = True;
			refreshBuf = True;
			redisplay = True;
#ifdef DEBUG
		  printf("\n  XmNmarginWidth changed\n");
#endif
		}

		if (streq(XmNselectLineWidth, name))
		{
	//	    refreshGC = True;
			recalculateFull = True;
			recalculateGeom = True;
			refreshBuf = True;
			redisplay = True;
#ifdef DEBUG
		  printf("\n  XmNselectLineWidth changed\n");
#endif
		}

		if (streq(XmNselectLineMargin, name))
		{
	//	    refreshGC = True;
			recalculateFull = True;
			recalculateGeom = True;
			refreshBuf = True;
			redisplay = True;
#ifdef DEBUG
		  printf("\n  XmNselectLineMargin changed\n");
#endif
		}
		if (streq(XmNlTextSpacing, name))
		{
	//	    refreshGC = True;
			recalculateFull = True;
			recalculateGeom = True;
			refreshBuf = True;
			redisplay = True;
#ifdef DEBUG
		  printf("\n  XmNselectLineMargin changed\n");
#endif
		}

    }


/**********************************************************************/

	if ((i_set->itbox.SelectedPositions != i_old->itbox.SelectedPositions) ||
		(i_set->itbox.SelectedPositionsCount != i_old->itbox.SelectedPositionsCount))
	{
		if (i_set->itbox.SelectedPositions && (i_set->itbox.SelectedPositionsCount > 0))
        {
			ClearSelectedPositions(i_old);
			CopySelectedPositions(i_set);
			redisplay = True;
			resetSelectedList = True;
			rebuildSelectedList = True;
		}
		else if (i_set->itbox.SelectedPositionsCount == 0)
		{
			ClearSelectedPositions(i_old);
			i_set->itbox.SelectedPositions = NULL;
			redisplay = True;
			resetSelectedList = True;
		}
		else if ((i_set->itbox.SelectedPositionsCount > 0) && (i_set->itbox.SelectedPositions == NULL))
			{
				XmeWarning((Widget) i_set, "SetValues: selectedPositions not found\n");
				i_set->itbox.SelectedPositions = i_old->itbox.SelectedPositions;
				i_set->itbox.SelectedPositionsCount = i_old->itbox.SelectedPositionsCount;
			}
			else
			{
				XmeWarning((Widget) i_set, "SetValues: selectedPositions not found\n");
				i_set->itbox.SelectedPositions = i_old->itbox.SelectedPositions;
				i_set->itbox.SelectedPositionsCount = i_old->itbox.SelectedPositionsCount;
			}
	}

/**********************************************************************/




    if ((i_set->itbox.v_bar != i_old->itbox.v_bar) ||
	(i_set->itbox.h_bar != i_old->itbox.h_bar))
    {

//	i_set->itbox.v_bar = i_old->itbox.v_bar;
//	i_set->itbox.h_bar = i_old->itbox.h_bar;
		XtAddCallback(i_set->itbox.v_bar, XmNvalueChangedCallback,
				  VScrollCallback, (XtPointer) set);
		XtAddCallback(i_set->itbox.v_bar, XmNdragCallback,
				  VScrollCallback, (XtPointer) set);

		XtAddCallback(i_set->itbox.h_bar, XmNvalueChangedCallback,
				  HScrollCallback, (XtPointer) set);
		XtAddCallback(i_set->itbox.h_bar, XmNdragCallback,
				  HScrollCallback, (XtPointer) set);
		XtVaSetValues(i_set->itbox.h_bar, XmNmaximum, 1,
			XmNsliderSize, 1, XmNvalue, 0, NULL);

    }



    if ((((XmPrimitiveWidget)set)->primitive.shadow_thickness != ((XmPrimitiveWidget)current)->primitive.shadow_thickness) ||
	(((XmPrimitiveWidget)set)->primitive.highlight_thickness != ((XmPrimitiveWidget)current)->primitive.highlight_thickness))
	{
	    recalculateGeom = True;
	    redisplay = True;
	}

    if (refreshGC)
    {
		DestroyGC(i_set);
		InitializeGC(i_set);
    }

	if (resetSelectedList)
	{
		for (i = 0; i < i_set->itbox.num_items; i++)
		{
			if (i_set->itbox.buffering && i_set->itbox.item_data[i]->selected == True) 
				ChangeCellSelection(set, i_set->itbox.item_data[i], False);
			i_set->itbox.item_data[i]->selected = False;
		}
	}
	if (rebuildSelectedList)
	{
		for (i = 0; i < i_set->itbox.SelectedPositionsCount; i++)
		{
			if ((i_set->itbox.SelectedPositions[i] >= 0) && (i_set->itbox.SelectedPositions[i] < i_set->itbox.num_items))
			{
				if (i_set->itbox.buffering && i_set->itbox.item_data[i_set->itbox.SelectedPositions[i]]->selected == False) 
					ChangeCellSelection(set, i_set->itbox.item_data[i_set->itbox.SelectedPositions[i]], True);
				i_set->itbox.item_data[i_set->itbox.SelectedPositions[i]]->selected = True;
			}
		}
	}

	if (resetSelectedList || rebuildSelectedList)
	{
		if (i_set->itbox.SelectedPositionsCount == 0)
			HighlightDoCallback(set, XmNlCR_DELETE_SELECT, NULL);
		else if (i_set->itbox.SelectedPositionsCount == 1)
			HighlightDoCallback(set, XmNlCR_SINGLE_SELECT, NULL);
			else
				HighlightDoCallback(set, XmNlCR_MULTPLE_SELECT, NULL);
	}

    if (refreshIcons) 
		ChangeIconsBackgroud(i_set);

	if (refreshBuf)
	{
//		printf("RefreshBuf\n");
		RefreshLabels(set);
	}

    if (recalculateFull)
    {
    	i_set->itbox.cell_height=0;
		i_set->itbox.cell_width=0;
		i_set->itbox.max_icon_height=0;
		i_set->itbox.max_icon_width=0;

		if (i_set->itbox.viewtype == XmLARGE_ICON) RecalcParamLarge(set, 0, i_set->itbox.num_items);
    	else RecalcParamSmall(set, 0, i_set->itbox.num_items);
		i_set->itbox.global_shift=0;
//		i_set->itbox.shift_in_pix=0;
//		i_set->itbox.pix_shift=0;
//	ResizeSliders(set);
//	ResizeStuff(i_set);
//    	refreshBuf = CalcGeom(set);
    }
    if (recalculateFull || recalculateGeom)
    {
//    	RecalcParamLarge( set);
		ResizeStuff(i_set);
    	refreshBuf = CalcGeom(set);
    }
//    if (recalculateGeom)
//    {
//	ResizeStuff(i_set);
//    	refreshBuf = CalcGeom(set);
//    }
//    if (refreshBuf)
//    {
//		printf("Delete Buf\n");
//		DeletePixBufCache(i_set);
//	}
    if (recalculateFull || recalculateGeom || refreshBuf)
	{
//	if (i_set->itbox.buffering) PutToPixLarge( set );
//	else RecalcRegions(set);
		RecalcRegions(set);
	}

	if (!XtIsRealized(current))
		return False;


    return(redisplay);
}

static void
ResizeStuff(XmNlItemBoxWidget w)
{
  XRectangle clip;

/*  w->itbox.viewWidth = w->core.width - 2*((XmPrimitiveWidget)(w))->primitive.shadow_thickness
    - 2*((XmPrimitiveWidget)(w))->primitive.highlight_thickness;
  w->itbox.viewHeight = w->core.height - 2*((XmPrimitiveWidget)(w))->primitive.shadow_thickness
    - 2*((XmPrimitiveWidget)(w))->primitive.highlight_thickness;

  w->itbox.viewX=((XmPrimitiveWidget)(w))->primitive.shadow_thickness+((XmPrimitiveWidget)(w))->primitive.highlight_thickness;
  w->itbox.viewY=((XmPrimitiveWidget)(w))->primitive.shadow_thickness+((XmPrimitiveWidget)(w))->primitive.highlight_thickness;

  clip.x = w->itbox.viewX;
  clip.y = w->itbox.viewY;
  clip.width = w->itbox.viewWidth;
  clip.height = w->itbox.viewHeight;
  XSetClipRectangles(XtDisplay((Widget) w), w->itbox.normalGC,
    0, 0, &clip, 1, Unsorted);
  XSetClipRectangles(XtDisplay((Widget) w), w->itbox.eorGC,
    0, 0, &clip, 1, Unsorted);
  XSetClipRectangles(XtDisplay((Widget) w), w->itbox.highlightGC,
    0, 0, &clip, 1, Unsorted);*/
//    ResizeSliders((Widget) w);
//    if (CalcGeom((Widget) w)) PutToPixLarge((Widget) w);

  w->itbox.viewWidth = w->core.width;
  w->itbox.viewHeight = w->core.height;

  w->itbox.viewX=0;
  w->itbox.viewY=0;


}


/*	Function Name: Redisplay
 *	Description:   This function redraws the list contents.
 *	Arguments:     w - the Icon Box widget.
 *                     event - event that caused the exposure.
 *                     region - the region containing all the exposures.
 *	Returns:       none
 *
 */

/*ARGSUSED*/
static void
Redisplay(Widget w, XEvent * event, Region region)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
    short num_rows;
    XmString string;
    int x, y, i;
	long nummm;

#ifdef DEBUG
    XExposeEvent * exp_event = (XExposeEvent *) event;
    XAnyEvent * any_event = (XAnyEvent *) event;
	printf("\t\tRedisplay\t%d\t", any_event->type);
	if (exp_event->send_event) printf("Send event\t");
	if (it->itbox.DownShift) printf("Down\t");
	if (it->itbox.RedrawNeed) printf("RedrawNeed");
	printf("\n");

	REGION DReg = *region;
	BOX *bx;
	for(i=0; i < DReg.numRects; i++)
	{
		bx=DReg.rects;
		bx=bx+i;
		printf("--Redisplay: region x1= %d y1= %d x2= %d y2= %d\n", bx->x1, bx->y1, bx->x2, bx->y2 );
	}
#endif


#ifdef DEBUG
	printf("\nRedisplay w=%d h=%d\n",it->itbox.viewWidth, it->itbox.viewHeight);
	fflush(stdout);
#endif

	if (it->itbox.num_items == 0) return;

	CheckRenderOrder(it);

#ifdef DEBUG
	printf("\nRedisplay Render Order = %hhx\n", it->itbox.render_order);
	fflush(stdout);
#endif

	if (it->itbox.RedrawNeed == TRUE)
	{
//		XClearArea(XtDisplay(w), XtWindow(w), 0, 0, 0, 0, True);
		RedrawAllDirect(w);
		it->itbox.RedrawNeed = False;
		it->itbox.DownShift = False;
		it->itbox.DeltaShift = 0;
		return ;
	}

	if (it->itbox.DownShift == TRUE)
	{
//		it->itbox.DownShift = FALSE;
		XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), it->itbox.normalGC,
				0, 0, it->itbox.viewWidth, it->itbox.viewHeight - it->itbox.DeltaShift,
				0, it->itbox.DeltaShift);
		RedrawRegion(w, 0, 0, (int) it->itbox.viewWidth, it->itbox.DeltaShift, -1);
		it->itbox.DownShift = FALSE;
//		RedrawWindow(w, event, region);
		it->itbox.DeltaShift = 0;
		return ;
	}


	RedrawWindow(w, event, region);
	it->itbox.DownShift=FALSE;
	it->itbox.RedrawNeed=FALSE;
}

void CleanCacheBuf(Widget w, CacheBufElement * CacheBufIndex, int * CacheBufNum, int CacheBufLimit);

/*	Function Name: Resize
 *	Description:   Called when this widget has been resized.
 *	Arguments:     w - Icon Box Widget to realize.
 *	Returns:       none.
 */

static void
Resize(Widget w)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	Boolean recalc=False, shifted;
	Boolean decrement=FALSE;

#ifdef DEBUG
	printf("ItBox: Resize started");
	fflush(stdout);
#endif

    if (!XtIsRealized(w)) return;

	if (it->itbox.viewWidth > w->core.width) decrement=TRUE;
	ResizeStuff(it);
	recalc=CalcGeom(w);

	it->itbox.CacheBufLimit = it->itbox.VisibleCount + 2 * it->itbox.col_num;

/*	if (it->itbox.buffering)
	{
		if (it->itbox.CacheBufLimit < (it->itbox.CacheBufNum - 2*it->itbox.col_num))
			CleanCacheBuf(w, it->itbox.CacheBufIndex, &(it->itbox.CacheBufNum), it->itbox.CacheBufLimit);
	}
*/
//	printf("-------CacheBufLimit %d\n", it->itbox.CacheBufLimit);

	shifted = AdjustGlobalShift(w);


	ResizeSliders(w);
/*
	if (shifted) RecalcRegions(w);
	if ((recalc || shifted) && !it->itbox.Resized)
	{
		XClearArea(XtDisplay(w), XtWindow(w), 0, 0, 0, 0, True);
	}
*/
	if (recalc || shifted || it->itbox.DownShift)
		RecalcRegions(w);

	if (recalc)
	{
		it->itbox.RedrawNeed = True;
		XClearArea(XtDisplay(w), XtWindow(w), 0, 0, 0, 0, True);
	}

#ifdef DEBUG
	printf("ItBox: Resize completed");
	fflush(stdout);
#endif
}


/*	Function Name: Destroy
 *	Description:   Cleans up after the widget.
 *	Arguments:     w - the widget.
 *	Returns:       none.
 */

static void
Destroy(Widget w)
{
    XmNlItemBoxWidget ibox = (XmNlItemBoxWidget) w;
    int i;
	XmNlItBoxInfo * data;

	ibox->itbox.DestroyPhase = True;

	XmNlItBoxDeleteAllItems(w); /* All text pixmap cache deleted in XmNlItBoxDeletAllItems() */

	DeleteAllPixBufCache(ibox);

    if (ibox->itbox.font_list)
		XmFontListFree(ibox->itbox.font_list);

    DestroyGC(ibox);

//	ClearIconList(ibox);
	return ;
}

static void
DestroyGC(XmNlItemBoxWidget w)
{
	XtReleaseGC((Widget) w, w->itbox.normalGC);
	XtReleaseGC((Widget) w, w->itbox.pixGC);
	XtReleaseGC((Widget) w, w->itbox.eorGC);
	XtReleaseGC((Widget) w, w->itbox.highlightGC);
	XtReleaseGC((Widget) w, w->itbox.eraseGC);
}

static void
InitializeGC(XmNlItemBoxWidget w)
{
	XGCValues values;
	XtGCMask mask;


	values.line_style = LineSolid;
	values.line_width = 1;
	values.fill_style = FillSolid;


	values.background = w->itbox.background_pixel;
	values.foreground = w->itbox.background_pixel;
	values.subwindow_mode = ClipByChildren;

	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground;
	w->itbox.eraseGC = XtGetGC((Widget) w, mask, &values);

	values.background = w->itbox.background_pixel;
	values.foreground = w->itbox.foreground_pixel;
	values.subwindow_mode = ClipByChildren;

	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground;
	w->itbox.normalGC = XtGetGC((Widget) w, mask, &values);

	values.function = GXcopy;
	mask = GCFunction | GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground | GCSubwindowMode;
	w->itbox.pixGC = XtGetGC((Widget) w, mask, &values);

	values.function = GXinvert;
	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground | GCFunction;
	w->itbox.eorGC = XtGetGC((Widget) w, mask, &values);


	values.background = w->itbox.select_background_pixel;
	values.foreground = w->itbox.select_foreground_pixel;


	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground;
	w->itbox.highlightGC = XtGetGC((Widget) w, mask, &values);

#ifdef DEBUG
      printf("\n InitializeGC ok\n");
#endif
}

static void
CheckSetRenderTable(Widget w, int offset, XrmValue *value)
{

	XmNlItemBoxWidget ibox = (XmNlItemBoxWidget) w;

	if (ibox->itbox.MouseMoved)
		value->addr = NULL;
	else
	{
		value->addr = (char*)&(ibox->itbox.font_list);
		ibox->itbox.MouseMoved = True;
	}
}


static void
ConvertLineStyleProc(Widget w, int offset, XrmValue *value)
{
	XmNlItemBoxWidget ibox = (XmNlItemBoxWidget) w;

	if (ibox->itbox.MouseMoved)
		value->addr = NULL;
	else {
		value->addr = (char*)&(ibox->itbox.font_list);
		ibox->itbox.MouseMoved = True;
	}
}


static void ClearSelectedPositions(XmNlItemBoxWidget it)
{
	if (!(it->itbox.SelectedPositions && it->itbox.SelectedPositionsCount))
		return;

	XtFree((char*) it->itbox.SelectedPositions);

	it->itbox.SelectedPositionsCount = 0;
	it->itbox.SelectedPositions = NULL;
}

static void CopySelectedPositions(XmNlItemBoxWidget it)
{
	if (it->itbox.SelectedPositions && it->itbox.SelectedPositionsCount)
	{
		int size = sizeof(int) * it->itbox.SelectedPositionsCount;
		int * sl = (int *) XtMalloc(size);

		memcpy((char *)sl, (char *) it->itbox.SelectedPositions, size);
		it->itbox.SelectedPositions = sl;
	}
}



void _XmNlItBoxAddScrolls(Widget w)
{
	XmNlItemBoxWidget ibox = (XmNlItemBoxWidget) w;
	
	if (ibox->itbox.v_bar)
	{
		XtAddCallback(ibox->itbox.v_bar, XmNvalueChangedCallback,
				  VScrollCallback, (XtPointer) w);
		XtAddCallback(ibox->itbox.v_bar, XmNdragCallback,
				  VScrollCallback, (XtPointer) w);
	}
	
	if (ibox->itbox.h_bar)
	{
		XtAddCallback(ibox->itbox.h_bar, XmNvalueChangedCallback,
				  HScrollCallback, (XtPointer) w);
		XtAddCallback(ibox->itbox.h_bar, XmNdragCallback,
				  HScrollCallback, (XtPointer) w);
	}
}

/*
static void DelIconFromList(XmNlItemBoxWidget it, IconInfo * icon)
{
	IconInfo * ptr1, * ptr2;

	if (icon)
	{
		ptr1 = icon;
		if ((--(ptr1->use_counter)) <= 0)
		{
			if (PIX_FOUND(ptr1->pix))
				XFreePixmap(XtDisplay((Widget) it), ptr1->pix);
			if (PIX_FOUND(ptr1->mask))
				XFreePixmap(XtDisplay((Widget) it), ptr1->mask);
			ptr1 = it->itbox.IconList;
			ptr2 = ptr1;
			while(ptr1)
			{
				if (ptr1 == icon) break;
				else
				{
					ptr2 = ptr1;
					ptr1 = ptr1->next;
				}
			}
			if (!ptr1)
			{
				printf("XmNlItemBoxWidget DelIconFromList: Fatal ERROR\n");
				return ;
			}
			if (ptr1 == ptr2)
			{
				it->itbox.IconList = ptr1->next;
				free(ptr1);
				return ;
			}
			ptr2->next = ptr1->next;
			free(ptr1);
		}
	}
}
*/
#ifdef DEBUG_CACHE_ICON

static void IconCacheInfo(XmNlItemBoxWidget ibox)
{
	IconInfo * ptr1;

	ptr1 = ibox->itbox.IconList;
	while (ptr1)
	{
		printf("Pixmap %ld count %d\n", ptr1->parent, ptr1->use_counter);
		ptr1 = ptr1->next;
	}
}

#endif

/*static IconInfo * AddIconToList(XmNlItemBoxWidget ibox, Pixmap pix, Pixmap mask)
{
	IconInfo * ptr1, * ptr2 = NULL;
	XGCValues values;
	unsigned long valuesmask;
	unsigned int width, height, bw, depth;
	Window root;
	GC mask_gc;
	int x, y;

	if (!ibox->itbox.IconList)
	{
		ibox->itbox.IconList = calloc(sizeof(IconInfo), sizeof(char));
		if (!ibox->itbox.IconList) return NULL;
		ptr1 = ibox->itbox.IconList;
		ptr1->next = NULL;
	}
	else
	{
		ptr1 = ibox->itbox.IconList;
		while (ptr1)
		{
			if (ptr1->parent == pix)
			{
				return ptr1;
			}
			else
			{
				ptr2 = ptr1;
				ptr1 = ptr1->next;
			}
		}
		ptr1 = calloc(sizeof(IconInfo), sizeof(char));
		if (!ptr1) return NULL;
		ptr1->next = NULL;
		ptr2->next = ptr1;
	}

	XGetGeometry(XtDisplay((Widget) ibox), pix, &root, &x, &y, &width, &height, &bw, &depth);
	ptr1->pix = XCreatePixmap(XtDisplay((Widget) ibox), RootWindowOfScreen(XtScreen((Widget) ibox)),
									width, height, depth);
	ptr1->parent = pix;
	if (!PIX_FOUND(ptr1->pix))
	{
		free((void *) ptr1);
		if (ptr2) ptr2->next = NULL;
		return NULL;
	}

	ptr1->width = width;
	ptr1->height = height;
	XCopyArea(XtDisplay((Widget) ibox), pix, ptr1->pix, ibox->itbox.normalGC,
					0, 0, width, height, 0, 0);

	if (PIX_FOUND(mask))
	{
		ptr1->mask = XCreatePixmap(XtDisplay((Widget) ibox), RootWindowOfScreen(XtScreen((Widget) ibox)),
								width, height, 1);*/
/* Copy inverted mask for icon */
/*		valuesmask = GCFunction;
		values.function = GXcopyInverted;
		mask_gc = XCreateGC(XtDisplay((Widget) ibox), ptr1->mask, valuesmask, &values);

		XCopyArea(XtDisplay((Widget) ibox), mask, ptr1->mask, mask_gc,
							0, 0, width, height, 0, 0);
		XFreeGC(XtDisplay((Widget) ibox), mask_gc);

*/
/* Fill icon pixmp with background color */
/*		XSetForeground(XtDisplay((Widget) ibox), ibox->itbox.normalGC, ibox->itbox.background_pixel);
		XSetClipOrigin(XtDisplay((Widget) ibox), ibox->itbox.normalGC, 0, 0);
		XSetClipMask(XtDisplay((Widget) ibox), ibox->itbox.normalGC, ptr1->mask);
		XFillRectangle(XtDisplay((Widget) ibox), ptr1->pix, ibox->itbox.normalGC, 0, 0, width, height);
*/
/* Restore normalGC */
/*		XSetForeground(XtDisplay((Widget) ibox), ibox->itbox.normalGC, ibox->itbox.foreground_pixel);
		XSetClipOrigin(XtDisplay((Widget) ibox), ibox->itbox.normalGC, 0, 0);
		XSetClipMask(XtDisplay((Widget) ibox), ibox->itbox.normalGC, None);
	}
	else ptr1->mask = XmUNSPECIFIED_PIXMAP;
	return ptr1;
}
*/

static void ChangeIcon(XmNlItemBoxWidget ibox, Pixmap pix, Pixmap mask)
{
}


/*static void ClearIconList(XmNlItemBoxWidget ibox)
{
	IconInfo * ptr1 = ibox->itbox.IconList, * ptr2;

	while(ptr1)
	{
		if (PIX_FOUND(ptr1->pix)) XFreePixmap(XtDisplay((Widget) ibox), ptr1->pix);
		if (PIX_FOUND(ptr1->mask)) XFreePixmap(XtDisplay((Widget) ibox), ptr1->mask);
		ptr2 = ptr1;
		ptr1 = ptr1->next;
		free(ptr2);
	}
	ibox->itbox.IconList = NULL;
}*/

static void ChangeIconsBackgroud(XmNlItemBoxWidget ibox)
{
	IconInfo * ptr1 = ibox->itbox.IconList;

	while(ptr1)
	{
		if (PIX_FOUND(ptr1->pix) && PIX_FOUND(ptr1->mask))
		{
/* Fill icon pixmp with background color */
			XSetForeground(XtDisplay((Widget) ibox), ibox->itbox.normalGC, ibox->itbox.background_pixel);
			XSetClipOrigin(XtDisplay((Widget) ibox), ibox->itbox.normalGC, 0, 0);
			XSetClipMask(XtDisplay((Widget) ibox), ibox->itbox.normalGC, ptr1->mask);
			XFillRectangle(XtDisplay((Widget) ibox), ptr1->pix, ibox->itbox.normalGC,
							0, 0, ptr1->width, ptr1->height);

/* Restore normalGC */
			XSetForeground(XtDisplay((Widget) ibox), ibox->itbox.normalGC, ibox->itbox.foreground_pixel);
			XSetClipOrigin(XtDisplay((Widget) ibox), ibox->itbox.normalGC, 0, 0);
			XSetClipMask(XtDisplay((Widget) ibox), ibox->itbox.normalGC, None);
		}
		ptr1 = ptr1->next;
	}
}

static void VisibilityChangeProc(Widget w, XtPointer client_data, XEvent* event, Boolean* cont)
{
    XmNlItemBoxWidget ibox = (XmNlItemBoxWidget) w;
    XVisibilityEvent * vevent = (XVisibilityEvent *) event;

	ibox->itbox.VisibilityState=vevent->state;
#ifdef DEBUG
	printf("ItemBoxWidget: state = %d\n", vevent->state);
#endif
}


static void CheckRenderOrder(XmNlItemBoxWidget it)
{
	XmDirection direction = ((XmPrimitiveWidget)(it))->primitive.layout_direction;

	if (direction == XmRIGHT_TO_LEFT_TOP_TO_BOTTOM || direction == XmRIGHT_TO_LEFT_BOTTOM_TO_TOP || direction == XmTOP_TO_BOTTOM_RIGHT_TO_LEFT
		|| direction == XmBOTTOM_TO_TOP_RIGHT_TO_LEFT || direction == XmRIGHT_TO_LEFT)
	{
		it->itbox.render_order = RtoL_render;
		return ;
	}

	if (direction == XmLEFT_TO_RIGHT_TOP_TO_BOTTOM || direction == XmLEFT_TO_RIGHT_BOTTOM_TO_TOP || direction == XmTOP_TO_BOTTOM_LEFT_TO_RIGHT
		|| direction == XmBOTTOM_TO_TOP_LEFT_TO_RIGHT || direction == XmLEFT_TO_RIGHT)
	{
		it->itbox.render_order = LtoR_render;
		return ;
	}

	it->itbox.render_order = LtoR_render;
	return ;
}

static void RefreshLabels(Widget w)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int i;
	XmNlItBoxInfo * data;
	CacheBufElement * ptr;

	for (i = 0; i < it->itbox.num_items; i++)
	{
		data = it->itbox.item_data[i];
		if (data->xmlabel)
		{
			data->label_height = XmStringHeight(it->itbox.font_list, data->xmlabel);
			data->label_width = XmStringWidth(it->itbox.font_list, data->xmlabel);
		}
		if (data->buf)
		{
//			printf("!!!!!!!!!\n");
			ptr = (CacheBufElement *) data->buf;
			ptr->cell = NULL;
			FreeCacheNode(it, data);
			data->buf = NULL;
		}
	}
}

static Boolean RecalcParamSmall(Widget w, int FirstItem, int count)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int x, y;
	int cell_height, cell_width;
	unsigned int width, height;
	int tmp_w, tmp_h;
	int i;
	int string_h = 0;
	int string_w = 0;
	XmNlItBoxInfo * data;
	Boolean ret = FALSE;
	Dimension base_y;

#ifdef DEBUG
	printf("\n small cell recalc\n");
#endif
	width=0;
	height=0;

	for (i=FirstItem; i<FirstItem+count; i++)
	{
//		assert(i < it->itbox.num_items);
		data=it->itbox.item_data[i];
		if (data->xmlabel)
		{
			tmp_w = data->label_width + 2 * it->itbox.text_spacing;
#ifdef DEBUG
			printf("\n recalc param W: i=%d\n", i);
#endif
			tmp_h = data->label_height + 2 * it->itbox.text_spacing;
#ifdef DEBUG
			printf("\n recalc param H: i=%d\n", i);
#endif
		}
		else
		{
			tmp_w = 2*it->itbox.text_spacing;
			tmp_h = 2*it->itbox.text_spacing;
		}

		if (tmp_w > string_w) string_w = tmp_w;
		if (tmp_h > string_h) string_h = tmp_h;

		if (data->icon)
		{
			width = data->icon->width;
			height = data->icon->height;
		}

		if (it->itbox.max_icon_width < width) it->itbox.max_icon_width = width;
		if (it->itbox.max_icon_height < height) it->itbox.max_icon_height = height;
#ifdef DEBUG
		printf("\n recalc param: i=%d\n", i);
#endif
	}

	cell_width = string_w + it->itbox.max_icon_width +
				2*it->itbox.select_line_w + 3*it->itbox.select_line_margin + 2*it->itbox.margin_w;

	if (it->itbox.max_icon_height >= string_h)
		cell_height = it->itbox.max_icon_height + 2*it->itbox.select_line_w + 2*it->itbox.select_line_margin + 2*it->itbox.margin_h;
	else cell_height = string_h + 2*it->itbox.select_line_w + 2*it->itbox.select_line_margin + 2*it->itbox.margin_h;

	if (cell_height != it->itbox.cell_height)
	{
		if (cell_height > it->itbox.cell_height) ret = TRUE;
		if (cell_height > it->itbox.cell_height) it->itbox.cell_height = cell_height;
	}
	if (cell_width != it->itbox.cell_width)
	{
		if (cell_width > it->itbox.cell_width) ret = TRUE;
		if (cell_width > it->itbox.cell_width) it->itbox.cell_width = cell_width;
	}
#ifdef DEBUG
	printf("\n cell_height=%d %d\n",it->itbox.cell_height, cell_height);
	printf("\n icon_height=%d\n",it->itbox.max_icon_height);
	printf("\n string_height=%d\n",string_h);
	printf("\n cell_width=%d\n",it->itbox.cell_width);
	printf("\n icon_width=%d\n",it->itbox.max_icon_width);
	printf("\n string_width=%d\n",string_w);
	printf("\n Small cell recalc completed\n");
#endif
	return ret;
}



static Boolean RecalcParamLarge(Widget w, int FirstItem, int count)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int x, y;
	int cell_height, cell_width;
	unsigned int width, height;
	int tmp_w, tmp_h;
	int i;
	int string_h = 0;
	int string_w = 0;
	XmNlItBoxInfo * data;
	Boolean ret=FALSE;
	Dimension base_y;

#ifdef DEBUG
	printf("\n cell_recalc\n");
#endif
	width=0;
	height=0;

	for (i = FirstItem; i < FirstItem+count; i++)
	{
//		assert(i < it->itbox.num_items);
		data = it->itbox.item_data[i];
		if (data->xmlabel)
		{
			tmp_w = data->label_width + 2 * it->itbox.text_spacing;
#ifdef DEBUG
			printf("\n recalc param W: i=%d\n", i);
#endif
			tmp_h = data->label_height + 2 * it->itbox.text_spacing;
#ifdef DEBUG
			printf("\n recalc param H: i=%d\n", i);
#endif
		}
		else
		{
			tmp_w = 2*it->itbox.text_spacing;
			tmp_h = 2*it->itbox.text_spacing;
		}
		if (tmp_w > string_w) string_w = tmp_w;
		if (tmp_h > string_h) string_h = tmp_h;

		if (data->icon)
		{
			width = data->icon->width;
			height = data->icon->height;
		}

		if (it->itbox.max_icon_width < width) it->itbox.max_icon_width = width;
		if (it->itbox.max_icon_height < height) it->itbox.max_icon_height = height;
#ifdef DEBUG
		printf("\n recalc param: i=%d\n", i);
#endif
	}

	base_y = it->itbox.margin_h + it->itbox.select_line_w + it->itbox.select_line_margin + it->itbox.max_icon_height;
	it->itbox.base_y = base_y;

	if (string_w >= it->itbox.max_icon_width)
		cell_width=string_w+2*it->itbox.select_line_w+2*it->itbox.select_line_margin+2*it->itbox.margin_w;
	else
		cell_width=it->itbox.max_icon_width+2*it->itbox.select_line_w+2*it->itbox.select_line_margin+2*it->itbox.margin_w;

	cell_height=it->itbox.max_icon_height+string_h+2*it->itbox.select_line_w+3*it->itbox.select_line_margin+2*it->itbox.margin_h;

	if (cell_height != it->itbox.cell_height)
	{
		if (cell_height > it->itbox.cell_height) ret = TRUE;
		if (cell_height > it->itbox.cell_height) it->itbox.cell_height = cell_height;
	}
	if (cell_width != it->itbox.cell_width)
	{
		if (cell_width > it->itbox.cell_width) ret = TRUE;
		if (cell_width > it->itbox.cell_width) it->itbox.cell_width = cell_width;
	}
#ifdef DEBUG
	printf("\n cell_height=%d\n",it->itbox.cell_height);
	printf("\n icon_height=%d\n",it->itbox.max_icon_height);
	printf("\n string_height=%d\n",string_h);
	printf("\n cell_width=%d\n",it->itbox.cell_width);
	printf("\n icon_width=%d\n",it->itbox.max_icon_width);
	printf("\n string_width=%d\n",string_w);
	printf("\n cell_recalc complet\n");
#endif
	return ret;
}

/* Calc region of viewable items
 * first viewable row;
 * last viewable row;
 * number of viewable items;
 * y of firs viewable row
 */

static
void RecalcRegions(Widget w)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int b_row, e_row, n_lines, n;

	if (it->itbox.num_items == 0) return;

	b_row=it->itbox.global_shift/it->itbox.cell_height;

	e_row=(it->itbox.global_shift + it->itbox.viewHeight)/it->itbox.cell_height;

//	if ((e_row * it->itbox.cell_height - it->itbox.global_shift + it->itbox.cell_height) < it->itbox.viewHeight)
	if (e_row * it->itbox.cell_height < it->itbox.global_shift + it->itbox.viewHeight)
		e_row++;
//	printf("+++++++++++++RecalRegions b_row %d e_row %d\n", b_row, e_row);

	n=(e_row - b_row) * it->itbox.col_num;
	n_lines=e_row - b_row;

	it->itbox.TopVisibleRow=b_row;
	it->itbox.BotVisibleRow=e_row;

	it->itbox.firstVisibleItem = b_row * it->itbox.col_num;
	it->itbox.firstVisibleY = b_row * it->itbox.cell_height - it->itbox.global_shift;

	it->itbox.VisibleCount=n;

	it->itbox.TopItemPosition = it->itbox.firstVisibleItem;
	it->itbox.VisibleItemCount = it->itbox.VisibleCount;

//	printf("RecalRegion ok\n");

}



static Boolean CalcGeom( Widget w)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	Boolean res = False;
	int col_num,row_num, view_row, n_lines;
	int b_row, e_row, n;

	if (it->itbox.num_items == 0)
		return True;

	col_num = it->itbox.viewWidth/it->itbox.cell_width;
	if(col_num == 0)
	{
		col_num = 1;
	}

	if (it->itbox.col_num != col_num) res = True;
	it->itbox.col_num = col_num;


	b_row=it->itbox.global_shift/it->itbox.cell_height;

	e_row=(it->itbox.global_shift+it->itbox.viewHeight)/it->itbox.cell_height;

//	if ((e_row * it->itbox.cell_height - it->itbox.global_shift + it->itbox.cell_height) < it->itbox.viewHeight)
	if (e_row * it->itbox.cell_height < it->itbox.global_shift + it->itbox.viewHeight)
		e_row++;

	n = (e_row - b_row) * it->itbox.col_num;
	n_lines = e_row - b_row;

	it->itbox.TopVisibleRow = b_row;
	it->itbox.BotVisibleRow = e_row;

	it->itbox.firstVisibleItem = b_row * it->itbox.col_num;
	it->itbox.firstVisibleY = b_row * it->itbox.cell_height - it->itbox.global_shift;

	it->itbox.VisibleCount = n;

	view_row = e_row - b_row;

//printf("CalcGeom: view row %d\n", view_row);

	row_num = it->itbox.num_items/col_num;
	if(row_num*col_num < it->itbox.num_items) row_num++;
	it->itbox.row_num = row_num;

	it->itbox.full_height = row_num * it->itbox.cell_height;
	if (it->itbox.full_height < 0)
		it->itbox.scroll_height = it->itbox.viewHeight;
	else
		it->itbox.scroll_height = it->itbox.full_height - it->itbox.viewHeight;

//	if (it->itbox.view_row!=view_row) res=True;
	it->itbox.view_row=view_row;

#ifdef DEBUG
	printf("\n !! calc geom: ROW=%d  COL=%d", it->itbox.row_num, it->itbox.col_num);

	printf("\n !! calc geom: full_height=%d\n", it->itbox.full_height);
#endif

	it->itbox.firstViewItem = it->itbox.firstVisibleItem;
	it->itbox.lastViewItem = n_lines * col_num + it->itbox.firstViewItem;

	return res;
}


static void ChangeCellSelection(Widget w, XmNlItBoxInfo * cell, Boolean selected)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;
	CacheBufElement * ptr;
	Pixmap pix;
	unsigned char align;

	if (selected == cell->selected)
				return ;

	cell->selected = selected;

	if (!it->itbox.buffering)
				return ;

	if (cell->buf)
	{
		ptr = (CacheBufElement *) cell->buf;

		pix = ptr->id;

		if (PIX_FOUND(pix))
		{
			background_color = it->itbox.background_pixel;
			foreground_color = it->itbox.foreground_pixel;
			sel_fg_color = it->itbox.select_foreground_pixel;


			if (it->itbox.select_background_pixel == XmREVERSED_GROUND_COLORS)
					sel_bg_color=it->primitive.foreground;
			else
					sel_bg_color=it->itbox.select_background_pixel;

			if (cell->alignment == XmALIGNMENT_UNSPECIFIED)
				align = it->itbox.alignment;
			else
				align = cell->alignment;

			if(cell->selected == True)
			{
				XSetForeground(XtDisplay(w), it->itbox.pixGC, sel_bg_color);
				XFillRectangle(XtDisplay(w), pix, it->itbox.pixGC, 0,0, ptr->wd, ptr->ht);

				XSetForeground(XtDisplay(w), it->itbox.pixGC, sel_fg_color);
				XSetBackground(XtDisplay(w), it->itbox.pixGC, sel_bg_color);
				if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
					(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
									XmStringDraw(XtDisplay(w), pix, it->itbox.font_list,
												cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
												XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
				if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
					(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
									XmStringDraw(XtDisplay(w), pix, it->itbox.font_list,
												cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
												XmALIGNMENT_END, XmSTRING_DIRECTION_DEFAULT, NULL);
				if (align == XmALIGNMENT_CENTER)
									XmStringDraw(XtDisplay(w), pix, it->itbox.font_list,
												cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
												XmALIGNMENT_CENTER, XmSTRING_DIRECTION_DEFAULT, NULL);
			}
			else
			{
				XSetForeground(XtDisplay(w), it->itbox.pixGC, background_color);
				XFillRectangle(XtDisplay(w), pix, it->itbox.pixGC, 0, 0, ptr->wd, ptr->ht);
				XSetForeground(XtDisplay(w), it->itbox.pixGC, foreground_color);
				if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
					(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
									XmStringDraw(XtDisplay(w), pix, it->itbox.font_list,
												cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
												XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
				if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
					(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
									XmStringDraw(XtDisplay(w), pix, it->itbox.font_list,
												cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
												XmALIGNMENT_END, XmSTRING_DIRECTION_DEFAULT, NULL);
				if (align == XmALIGNMENT_CENTER)
									XmStringDraw(XtDisplay(w), pix, it->itbox.font_list,
												cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
												XmALIGNMENT_CENTER, XmSTRING_DIRECTION_DEFAULT, NULL);
			}
		}
	}
	return ;
}


static void FreeCacheNode(XmNlItemBoxWidget it, XmNlItBoxInfo * cell)
{
	CacheNodeToFreeList((CacheBufElement *) cell->buf, &(it->itbox.FirstBuf), &(it->itbox.LastBuf), &(it->itbox.FirstFreeBuf), 
					&(it->itbox.UsedBufNum), &(it->itbox.FreeBufNum));
					
	return ;
}


static void DeleteAllPixBufCache(XmNlItemBoxWidget it)
{

	CleanPixBufNew((Widget) it, &(it->itbox.FirstBuf), &(it->itbox.LastBuf), &(it->itbox.FirstFreeBuf), 
							&(it->itbox.UsedBufNum), &(it->itbox.FreeBufNum));

	return ;
}


static void DeletePixBufCache(XmNlItemBoxWidget it)
{
	CacheBufElement * ptr1, * ptr2;
	XmNlItBoxInfo * cell;

	ptr1 = it->itbox.CacheBufIndex;
	while(ptr1)
	{
		if (PIX_FOUND(ptr1->id))
			XFreePixmap(XtDisplay((Widget) it), ptr1->id);
		ptr2 = ptr1->next;
		if (ptr1->cell)
		{
			cell = (XmNlItBoxInfo *) ptr1->cell;
			cell->buf = NULL;
		}
		free((void *) ptr1);
		ptr1 = ptr2;
		if (ptr1 == it->itbox.CacheBufIndex) break ;
	}

	it->itbox.CacheBufNum = 0;

#ifdef DEBUG
	printf("DeletePixBufCache completed\n");
#endif

	return ;
}

//static int nm = 0;
/*
void CleanCacheBuf(Widget w, CacheBufElement * CacheBufIndex, int * CacheBufNum, int CacheBufLimit)
{
	CacheBufElement * ptr1, * ptr2, * ptr3;
	XmNlItBoxInfo * cell;

	while (*CacheBufNum > CacheBufLimit)
	{
		ptr1 = CacheBufIndex->next;
		if (ptr1 != CacheBufIndex)
		{
			ptr2 = ptr1->next;
			CacheBufIndex->next = ptr2;
			if (ptr1->cell)
			{
				cell = ptr1->cell;
				cell->buf = NULL;
			}
			if (PIX_FOUND(ptr1->id))
				XFreePixmap(XtDisplay(w), ptr1->id);
			XtFree((char *)ptr1);
			(*CacheBufNum)--;
			if (*CacheBufNum < 3) return ;
		}
	}

}
*/

#ifdef DEBUG
static void CheckCacheChunk(XmNlItemBoxWidget it)
{
	CacheBufElement * ptr1, * ptr2, * ptr3;
	XmNlItBoxInfo * cell, * cell2;
	printf ("---------------\n");
	ptr1 = it->itbox.FirstBuf;
	ptr3 = it->itbox.FirstFreeBuf;
	while (ptr1 || ptr3)
	{
		if (ptr1)
		{
			cell = (XmNlItBoxInfo *) ptr1->cell;
			printf("-- %s\t", cell->name);
//			printf("-- %p\t", cell);
			ptr2 = ptr1;
			ptr1 = ptr1->next;
			if (ptr2 != it->itbox.LastBuf)
				if (ptr1->prev != ptr2)
					printf("!!!!!!!! not valid pointer\n");
		}
		else 
			printf("\t\t\t\t");
		
		if (ptr3)
		{
			printf("FreeNode\n");
			ptr3 = ptr3->next;
		}
		else
			printf("\n");
	}
	if (it->itbox.FirstBuf && it->itbox.LastBuf)
	{ 
		cell = (XmNlItBoxInfo *) it->itbox.FirstBuf->cell;
		cell2 = (XmNlItBoxInfo *) it->itbox.LastBuf->cell;
//		printf("First %s Last %s\n", cell->name, cell2->name);
	}
	else
		printf("First and Last not found\n");
}
#endif


static CacheBufElement * GetPixBufNew(Widget w, XmNlItBoxInfo * cell, int number, int direction)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;
	CacheBufElement * CacheBufIndex, * ptr1, * ptr2, * ptr3;
	XmNlItBoxInfo * cell1, * cell2;
//	int index, limit;
	unsigned char align;

	background_color = it->itbox.background_pixel;
	foreground_color = it->itbox.foreground_pixel;
	sel_fg_color = it->itbox.select_foreground_pixel;

//printf("Enter to GetPixBuf\n name %s\t h %d w %d\n", cell->name, cell->label_height, cell->label_width);

	if (it->itbox.select_background_pixel == XmREVERSED_GROUND_COLORS)
			sel_bg_color=it->primitive.foreground;
	else
			sel_bg_color=it->itbox.select_background_pixel;

	if (cell->alignment == XmALIGNMENT_UNSPECIFIED)
		align = it->itbox.alignment;
	else
		align = cell->alignment;


	if (number > 0)
	{
		cell1 = it->itbox.item_data[number - 1];
		ptr1 = (CacheBufElement *) cell1->buf;
	}
		else
			ptr1 = NULL;

	if (number < it->itbox.num_items - 1)
	{
		cell2 = it->itbox.item_data[number + 1];
		ptr2 = (CacheBufElement *) cell2->buf;
	}
		else
			ptr2 = NULL;


	CacheBufIndex = PreparePixBufNew(w, &it->itbox.FirstBuf, &it->itbox.LastBuf, &it->itbox.FirstFreeBuf, ptr1, ptr2, 
									&(it->itbox.UsedBufNum), &(it->itbox.FreeBufNum), it->itbox.CacheBufLimit, direction);

//	CacheBufIndex = PreparePixBuf(w, it->itbox.CacheBufIndex, &(it->itbox.CacheBufNum), it->itbox.CacheBufLimit);

	if (!CacheBufIndex) return NULL;
	it->itbox.CacheBufIndex = CacheBufIndex;
//printf("Element getted\n");
	if (CacheBufIndex->cell)
	{
//		printf("Element not empty\n");
		CacheBufIndex->cell = NULL;
		if (PIX_FOUND(CacheBufIndex->id))
		{
			if (CacheBufIndex->ht < cell->label_height || CacheBufIndex->wd < cell->label_width)
			{
				XFreePixmap(XtDisplay(w), CacheBufIndex->id);
				CacheBufIndex->id = XmUNSPECIFIED_PIXMAP;
				CacheBufIndex->wd = 0;
				CacheBufIndex->ht = 0;
			}
		}
	}

	if (!PIX_FOUND(CacheBufIndex->id))
	{
//		printf("Create pixmap\n");
		CacheBufIndex->id = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
						cell->label_width, cell->label_height, it->core.depth);
		CacheBufIndex->wd = cell->label_width;
		CacheBufIndex->ht = cell->label_height;
	}


	if(cell->selected == True)
	{
		XSetForeground(XtDisplay(w), it->itbox.pixGC, sel_bg_color);
		XFillRectangle(XtDisplay(w), CacheBufIndex->id, it->itbox.pixGC, 0,0, CacheBufIndex->wd, CacheBufIndex->ht);

		XSetForeground(XtDisplay(w), it->itbox.pixGC, sel_fg_color);
		XSetBackground(XtDisplay(w), it->itbox.pixGC, sel_bg_color);
		if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
			(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
								XmStringDraw(XtDisplay(w), CacheBufIndex->id, it->itbox.font_list,
											cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
											XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
		if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
			(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
								XmStringDraw(XtDisplay(w), CacheBufIndex->id, it->itbox.font_list,
											cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
											XmALIGNMENT_END, XmSTRING_DIRECTION_DEFAULT, NULL);
		if (align == XmALIGNMENT_CENTER)
								XmStringDraw(XtDisplay(w), CacheBufIndex->id, it->itbox.font_list,
											cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
											XmALIGNMENT_CENTER, XmSTRING_DIRECTION_DEFAULT, NULL);
	}
	else
	{
		XSetForeground(XtDisplay(w), it->itbox.pixGC, background_color);
		XFillRectangle(XtDisplay(w), CacheBufIndex->id, it->itbox.pixGC, 0, 0, CacheBufIndex->wd, CacheBufIndex->ht);
		XSetForeground(XtDisplay(w), it->itbox.pixGC, foreground_color);
		if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
			(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
								XmStringDraw(XtDisplay(w), CacheBufIndex->id, it->itbox.font_list,
											cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
											XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
		if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
			(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
								XmStringDraw(XtDisplay(w), CacheBufIndex->id, it->itbox.font_list,
											cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
											XmALIGNMENT_END, XmSTRING_DIRECTION_DEFAULT, NULL);
		if (align == XmALIGNMENT_CENTER)
								XmStringDraw(XtDisplay(w), CacheBufIndex->id, it->itbox.font_list,
											cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
											XmALIGNMENT_CENTER, XmSTRING_DIRECTION_DEFAULT, NULL);
	}
	CacheBufIndex->cell = cell;
//	printf("Return pointer %p\n", CacheBufIndex);
#ifdef DEBUG
	CheckCacheChunk(it);
#endif

	return CacheBufIndex;
}




/***************************************************************/
static CacheBufElement * GetPixBuf(Widget w, XmNlItBoxInfo * cell)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;
	CacheBufElement * CacheBufIndex, * ptr1, * ptr2, * ptr3;
//	int index, limit;
	unsigned char align;

	background_color = it->itbox.background_pixel;
	foreground_color = it->itbox.foreground_pixel;
	sel_fg_color = it->itbox.select_foreground_pixel;

//printf("Enter to GetPixBuf\n name %s\t h %d w %d\n", cell->name, cell->label_height, cell->label_width);

	if (it->itbox.select_background_pixel == XmREVERSED_GROUND_COLORS)
			sel_bg_color=it->primitive.foreground;
	else
			sel_bg_color=it->itbox.select_background_pixel;

	if (cell->alignment == XmALIGNMENT_UNSPECIFIED)
		align = it->itbox.alignment;
	else
		align = cell->alignment;


	CacheBufIndex = PreparePixBuf(w, it->itbox.CacheBufIndex, &(it->itbox.CacheBufNum), it->itbox.CacheBufLimit);

	if (!CacheBufIndex) return NULL;
	it->itbox.CacheBufIndex = CacheBufIndex;
//printf("Element getted\n");
	if (CacheBufIndex->cell)
	{
//		printf("Element not empty\n");
		CacheBufIndex->cell = NULL;
		if (PIX_FOUND(CacheBufIndex->id))
		{
			if (CacheBufIndex->ht < cell->label_height || CacheBufIndex->wd < cell->label_width)
			{
				XFreePixmap(XtDisplay(w), CacheBufIndex->id);
				CacheBufIndex->id = XmUNSPECIFIED_PIXMAP;
				CacheBufIndex->wd = 0;
				CacheBufIndex->ht = 0;
			}
		}
	}

	if (!PIX_FOUND(CacheBufIndex->id))
	{
//		printf("Create pixmap\n");
		CacheBufIndex->id = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
						cell->label_width, cell->label_height, it->core.depth);
		CacheBufIndex->wd = cell->label_width;
		CacheBufIndex->ht = cell->label_height;
	}


	if(cell->selected == True)
	{
		XSetForeground(XtDisplay(w), it->itbox.pixGC, sel_bg_color);
		XFillRectangle(XtDisplay(w), CacheBufIndex->id, it->itbox.pixGC, 0,0, CacheBufIndex->wd, CacheBufIndex->ht);

		XSetForeground(XtDisplay(w), it->itbox.pixGC, sel_fg_color);
		XSetBackground(XtDisplay(w), it->itbox.pixGC, sel_bg_color);
		if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
			(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
								XmStringDraw(XtDisplay(w), CacheBufIndex->id, it->itbox.font_list,
											cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
											XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
		if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
			(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
								XmStringDraw(XtDisplay(w), CacheBufIndex->id, it->itbox.font_list,
											cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
											XmALIGNMENT_END, XmSTRING_DIRECTION_DEFAULT, NULL);
		if (align == XmALIGNMENT_CENTER)
								XmStringDraw(XtDisplay(w), CacheBufIndex->id, it->itbox.font_list,
											cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
											XmALIGNMENT_CENTER, XmSTRING_DIRECTION_DEFAULT, NULL);
	}
	else
	{
		XSetForeground(XtDisplay(w), it->itbox.pixGC, background_color);
		XFillRectangle(XtDisplay(w), CacheBufIndex->id, it->itbox.pixGC, 0, 0, CacheBufIndex->wd, CacheBufIndex->ht);
		XSetForeground(XtDisplay(w), it->itbox.pixGC, foreground_color);
		if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
			(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
								XmStringDraw(XtDisplay(w), CacheBufIndex->id, it->itbox.font_list,
											cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
											XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
		if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
			(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
								XmStringDraw(XtDisplay(w), CacheBufIndex->id, it->itbox.font_list,
											cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
											XmALIGNMENT_END, XmSTRING_DIRECTION_DEFAULT, NULL);
		if (align == XmALIGNMENT_CENTER)
								XmStringDraw(XtDisplay(w), CacheBufIndex->id, it->itbox.font_list,
											cell->xmlabel, it->itbox.pixGC, 0, 0, cell->label_width,
											XmALIGNMENT_CENTER, XmSTRING_DIRECTION_DEFAULT, NULL);
	}
	CacheBufIndex->cell = cell;
//	printf("Return pointer %p\n", CacheBufIndex);
	return CacheBufIndex;
}



void RedrawItemDirect(Widget w, int num, int direction)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
    int x, y;

    if (it->itbox.render_order == LtoR_render) x = (num - (num/it->itbox.col_num) * it->itbox.col_num) * it->itbox.cell_width;
    else x = it->itbox.viewWidth - it->itbox.cell_width - (num - (num/it->itbox.col_num) * it->itbox.col_num) * it->itbox.cell_width;
    y = (num/it->itbox.col_num) * it->itbox.cell_height - it->itbox.global_shift;

	XClearArea(XtDisplay(w), XtWindow(w), x, y,
				it->itbox.cell_width, it->itbox.cell_height, False);

//	assert(num >= 0 && num < it->itbox.num_items);
	if (num < it->itbox.num_items) DrawItem(w, it->itbox.item_data[num], x, y, num, direction);

	return;
}


void RedrawElement(Widget w, int i, int x, int y, int direction, Boolean ClearOn)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	XmNlItBoxInfo * data;

	if (it->itbox.num_items==0) return;

//	assert(i >= 0 && i < it->itbox.num_items);
	if (i < it->itbox.num_items) data = it->itbox.item_data[i];
	else data = NULL;

//	printf("\nRedrawElement i = %d x = %d y = %d\n", i, x, y);


	if (ClearOn) XClearArea(XtDisplay(w), XtWindow(w), x, y,
				it->itbox.cell_width, it->itbox.cell_height, False);
	if (data == NULL) return;


	DrawItem(w, data, x, y, i, direction);

//	printf("\nRedrawElement ok\n");
	return ;
}


static void RedrawAllDirect(Widget w)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
		int i, j,k=0;
	int b_row, x, y, col;
	int shift;
	int x1, x2, x3, y1, y2, y3;
#ifdef DEBUG
	printf("RedrawAllDirect Start \n");
#endif
	if (!it->itbox.VisibleCount) return ;
		XClearArea(XtDisplay(w), XtWindow(w), 0, 0, 0, 0, False);

#ifdef DEBUG
	printf("-----RedrawAllDirect Start %d -> %d\n", it->itbox.firstVisibleItem, it->itbox.firstVisibleItem+it->itbox.VisibleCount);
#endif

	col = 0;
	y = it->itbox.firstVisibleY;
	if (it->itbox.render_order == LtoR_render) x = 0;
	else x = it->itbox.viewWidth - it->itbox.cell_width;
	i = it->itbox.firstVisibleItem;
	for (k = 0; k < it->itbox.VisibleCount; k++, i++)
	{
// 	      _XmProcessLock();
#ifdef DEBUG
	printf("Element  %d in region\n", i);
#endif
		if (it->itbox.DownShift)
			RedrawElement(w, i, x, y, -1, True);
		else
			RedrawElement(w, i, x, y, 0, True);
//	      _XmProcessUnlock();

		col++;
		if (it->itbox.render_order == LtoR_render) x = x + it->itbox.cell_width;
		else x = x - it->itbox.cell_width;
		if (col >= it->itbox.col_num)
		{
			col = 0;
			if (it->itbox.render_order == LtoR_render) x = 0;
			else x = it->itbox.viewWidth - it->itbox.cell_width;
			y = y + it->itbox.cell_height;
		}
	}

#ifdef DEBUG
	printf("Complete \n");
#endif

return ;
}


void RedrawRegion(Widget w, int x, int y, int width, int height, int direction)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
    int i, j,k=0, x1, y1, col;

	if (!it->itbox.VisibleCount) return ;

	col = 0;
	y1 = it->itbox.firstVisibleY;
	if (it->itbox.render_order == LtoR_render) x1 = 0;
	else x1 = it->itbox.viewWidth - it->itbox.cell_width;
	i = it->itbox.firstVisibleItem;
	for (k = 0; k < it->itbox.VisibleCount; k++, i++)
	{
// 	      _XmProcessLock();
#ifdef DEBUG
	printf("Element in region\n");
#endif
		if (x1 < x + width      &&
			x1 + it->itbox.cell_width > x &&
			y1 < y + height     &&
			y1 + it->itbox.cell_height > y)
				RedrawElement(w, i, x1, y1, direction, True);
//	      _XmProcessUnlock();

		col++;
		if (it->itbox.render_order == LtoR_render) x1 = x1 + it->itbox.cell_width;
		else x1 = x1 - it->itbox.cell_width;
		if (col >= it->itbox.col_num)
		{
			col = 0;
			if (it->itbox.render_order == LtoR_render) x1 = 0;
			else x1 = it->itbox.viewWidth - it->itbox.cell_width;
			y1 = y1 + it->itbox.cell_height;
		}
	}
}


void RedrawWindow( Widget w, XEvent * event, Region region )
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int i, k = 0;
	int y, x, col;

	if (!it->itbox.VisibleCount ) return ;
#ifdef DEBUG
	printf("Redraw window\n");
#endif
	col = 0;
	y = it->itbox.firstVisibleY;
	if (it->itbox.render_order == LtoR_render) x = 0;
	else x = it->itbox.viewWidth - it->itbox.cell_width;
	i = it->itbox.firstVisibleItem;
	for (k = 0; k < it->itbox.VisibleCount; k++, i++)
	{
//		Element = it->itbox.VisibleElement+ i;
		if (region == NULL)
		{

//	       _XmProcessLock();
//	       _XmProcessUnlock();
#ifdef DEBUG
	printf("Region null\n");
#endif
//            }
		}
		else
		{
			if (XRectInRegion (region, x, y, it->itbox.cell_width, it->itbox.cell_height))
			{
// 	      _XmProcessLock();
#ifdef DEBUG
printf("Element in region\n");
#endif
				RedrawElement(w, i, x, y, 0, True);
//	      _XmProcessUnlock();

			}
		}
		col++;
		if (it->itbox.render_order == LtoR_render) x = x + it->itbox.cell_width;
		else x = x - it->itbox.cell_width;
		if (col >= it->itbox.col_num)
		{
			col = 0;
			if (it->itbox.render_order == LtoR_render) x = 0;
			else x = it->itbox.viewWidth - it->itbox.cell_width;
			y = y + it->itbox.cell_height;
		}
	}
	return ;
}



#define MARGIN_W it->itbox.margin_w
#define MARGIN_H it->itbox.margin_h
#define SEL_LINE it->itbox.select_line_w
#define SEL_MARGIN it->itbox.select_line_margin
#define TXT_SPC it->itbox.text_spacing

void GetIconXY(Widget w, XmNlItBoxInfo * data, int x, int y, int * x1, int * y1, int * x2, int * y2)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	unsigned char align;
	unsigned int height, width;

	if (data->alignment == XmALIGNMENT_UNSPECIFIED)
		align = it->itbox.alignment;
	else
		align = data->alignment;

	if (data->icon)
	{
		height = data->icon->height;
		width = data->icon->width;
	}
	else
	{
		height = 0;
		width = 0;
	}

	if (it->itbox.viewtype == XmLARGE_ICON)
	{
		*y1 = y + it->itbox.base_y - height;
		*y2 = y + it->itbox.base_y;
	}
	else
	{
		*y1 = y + it->itbox.cell_height - MARGIN_H - SEL_MARGIN - SEL_LINE - height;
		*y2 = y + it->itbox.cell_height - MARGIN_H - SEL_MARGIN - SEL_LINE;
	}

/***************************************************/
/****				LEFT ALIGNED				****/
/***************************************************/

	if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
		(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
	{
		*x1 = x + MARGIN_W + SEL_MARGIN + SEL_LINE;
		*x2 = *x1 + width;
	}

/***************************************************/
/****				RIGHT ALIGNED				****/
/***************************************************/

	if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
		(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
	{
		*x2 = x + it->itbox.cell_width - MARGIN_W - SEL_LINE - SEL_MARGIN;
		*x1 = *x2 - width;
	}

/***************************************************/
/****				CENTER ALIGNED				****/
/***************************************************/

	if (align == XmALIGNMENT_CENTER)
	{

		if (it->itbox.viewtype == XmLARGE_ICON)
		{
			*x1 = x + it->itbox.cell_width/2 - width/2;
			*x2 = *x1 + width;
		}
		else
		{
			*x1 = x + MARGIN_W + SEL_MARGIN + SEL_LINE;
			*x2 = *x1 + width;
		}
	}
}


void GetTextXY(Widget w, XmNlItBoxInfo * data, int x, int y, int * x1, int * y1, int * x2, int * y2)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	unsigned char align;
	unsigned int iheight, iwidth;

	if (data->alignment == XmALIGNMENT_UNSPECIFIED)
		align = it->itbox.alignment;
	else
		align = data->alignment;

	if (data->icon)
	{
		iheight = data->icon->height;
		iwidth = data->icon->width;
	}

	else
	{
		iheight = 0;
		iwidth = 0;
	}

	if (it->itbox.viewtype == XmLARGE_ICON)
	{
		*y1 = y + it->itbox.base_y + SEL_MARGIN +TXT_SPC;
		*y2 = *y1 + data->label_height;
	}
	else
	{
		*y1 = y + it->itbox.cell_height - MARGIN_H - SEL_MARGIN - SEL_LINE - TXT_SPC - data->label_height;
		*y2 = *y1 + data->label_height;
	}

/***************************************************/
/****				LEFT ALIGNED				****/
/***************************************************/

	if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
		(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
	{
		if (it->itbox.viewtype == XmLARGE_ICON)
		{
			*x1 = x + MARGIN_W + SEL_MARGIN + SEL_LINE + TXT_SPC;
			*x2 = *x1 + data->label_width;
		}
		else
		{
			*x1 = x + MARGIN_W + 2*SEL_MARGIN + SEL_LINE + TXT_SPC + iwidth;
			*x2 = *x1 + data->label_width;
		}
	}

/***************************************************/
/****				RIGHT ALIGNED				****/
/***************************************************/

	if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
		(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
	{
		if (it->itbox.viewtype == XmLARGE_ICON)
		{
			*x1 = x + it->itbox.cell_width - MARGIN_W - SEL_MARGIN - SEL_LINE - TXT_SPC - data->label_width;
			*x2 = *x1 + data->label_width;
		}
		else
		{
			*x1 = x + it->itbox.cell_width - MARGIN_W - 2*SEL_MARGIN - SEL_LINE - iwidth - TXT_SPC - data->label_width;
			*x2 = *x1 + data->label_width;
		}
	}

/***************************************************/
/****				CENTER ALIGNED				****/
/***************************************************/

	if (align == XmALIGNMENT_CENTER)
	{

		if (it->itbox.viewtype == XmLARGE_ICON)
		{
			*x1 = x + it->itbox.cell_width/2 - data->label_width/2;
			*x2 = *x1 + data->label_width;
		}
		else
		{
			*x1 = x + MARGIN_W + SEL_MARGIN + SEL_LINE;
			*x2 = *x1 + data->label_width;
		}
	}
}




void HighLightItem(Widget w, XmNlItBoxInfo * data, int x, int y)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	XGCValues values;
	unsigned long mask;
	int x1, x2, x3, x4, y1, y2, y3;
	int ix1, ix2, iy1, iy2, lx1, lx2, ly1, ly2;
	XPoint points[9];
	Display *dpy = XtDisplay(w);
	unsigned char align;
	unsigned int iheight, iwidth;

	if (it->itbox.HasFocus && data == it->itbox.item_data[it->itbox.current_item])
		XSetForeground(dpy, it->itbox.normalGC, it->primitive.highlight_color);
	if (!it->itbox.HasFocus || data != it->itbox.item_data[it->itbox.current_item])
		XSetForeground(dpy, it->itbox.normalGC, it->itbox.background_pixel);

	mask = GCLineStyle | GCLineWidth | GCFillStyle;

	XSetBackground(dpy, it->itbox.normalGC, it->itbox.background_pixel);

	if (it->itbox.select_line_style==XmNlLINE_SOLID) values.line_style = LineSolid;
	if (it->itbox.select_line_style==XmNlLINE_DASH) values.line_style = LineDoubleDash;
	if (it->itbox.select_line_style==XmNlLINE_OFDASH) values.line_style = LineOnOffDash;
	values.line_width = it->itbox.select_line_w;
	values.fill_style =   FillOpaqueStippled;

	XChangeGC(dpy, it->itbox.normalGC, mask, &values);


	GetIconXY(w, data, x, y, &ix1, &iy1, &ix2, &iy2);
	GetTextXY(w, data, x, y, &lx1, &ly1, &lx2, &ly2);

	if (data->icon)
	{
		iheight = data->icon->height;
		iwidth = data->icon->width;
	}
	else
	{
		iheight = 0;
		iwidth = 0;
	}

	if (data->alignment == XmALIGNMENT_UNSPECIFIED)
		align = it->itbox.alignment;
	else
		align = data->alignment;

	if (it->itbox.viewtype == XmLARGE_ICON)
	{
		y1 = iy1 - SEL_MARGIN - SEL_LINE/2;
		y2 = (iwidth >= data->label_width + 2*TXT_SPC) ? iy2 + SEL_MARGIN + SEL_LINE/2 : ly1 - TXT_SPC - SEL_MARGIN - SEL_LINE/2;
		y3 = ly2 + TXT_SPC + SEL_MARGIN + SEL_LINE/2;
	}
	else
	{
		y3 = iy2 + SEL_MARGIN + SEL_LINE/2;
		y2 = ly1 - TXT_SPC - SEL_MARGIN - SEL_LINE/2;
		y1 = iy1 - SEL_MARGIN - SEL_LINE/2;
	}

/***************************************************/
/****				LEFT ALIGNED				****/
/***************************************************/

	if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
		(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
	{
		if (it->itbox.viewtype == XmLARGE_ICON)
		{
			x1 = ix1 - SEL_MARGIN - SEL_LINE/2;
			x2 = ix2 + SEL_MARGIN + SEL_LINE/2;
			x3 = lx2 + TXT_SPC + SEL_MARGIN + SEL_LINE/2;
		}
		else
		{
			x1 = ix1 - SEL_MARGIN - SEL_LINE/2;
			x3 = lx2 + SEL_MARGIN + TXT_SPC + SEL_LINE/2;
			x2 = (iheight >= data->label_height + 2*TXT_SPC) ? ix2 + SEL_MARGIN + SEL_LINE/2 : lx1 - TXT_SPC - SEL_MARGIN - SEL_LINE/2;
		}

		points[0].x=x1;
		points[0].y=y1;
		points[1].x=x2;
		points[1].y=y1;
		points[2].x=x2;
		points[2].y=y2;
		points[3].x=x3;
		points[3].y=y2;
		points[4].x=x3;
		points[4].y=y3;
		points[5].x=x1;
		points[5].y=y3;
		points[6].x=x1;
		points[6].y=y1;

		XDrawLines(dpy, XtWindow(w), it->itbox.normalGC, points, 7, CoordModeOrigin);
	}

/***************************************************/
/****				RIGHT ALIGNED				****/
/***************************************************/

	if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
		(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
	{
		if (it->itbox.viewtype == XmLARGE_ICON)
		{
			x1 = ix1 - SEL_MARGIN - SEL_LINE/2;
			x2 = ix2 + SEL_MARGIN + SEL_LINE/2;
			x3 = lx1 - TXT_SPC - SEL_MARGIN - SEL_LINE/2;
		}
		else
		{
			x3 = lx1 - TXT_SPC - SEL_MARGIN - SEL_LINE/2;
			x2 = ix2 + SEL_MARGIN + SEL_LINE/2;
			x1 = (iheight >= data->label_height + 2*TXT_SPC) ? ix1 - SEL_MARGIN - SEL_LINE/2 : lx2 + TXT_SPC + SEL_MARGIN + SEL_LINE/2;
		}

		points[0].x=x1;
		points[0].y=y1;
		points[1].x=x2;
		points[1].y=y1;
		points[2].x=x2;
		points[2].y=y3;
		points[3].x=x3;
		points[3].y=y3;
		points[4].x=x3;
		points[4].y=y2;
		points[5].x=x1;
		points[5].y=y2;
		points[6].x=x1;
		points[6].y=y1;
		XDrawLines(dpy, XtWindow(w), it->itbox.normalGC, points, 7, CoordModeOrigin);
	}

/***************************************************/
/****				CENTER ALIGNED				****/
/***************************************************/

	if (align == XmALIGNMENT_CENTER)
	{

		if (it->itbox.viewtype == XmLARGE_ICON)
		{
			x1 = lx1 - TXT_SPC - SEL_MARGIN - SEL_LINE/2;
			x2 = ix1 - SEL_MARGIN - SEL_LINE/2;
			x3 = ix2 + SEL_MARGIN + SEL_LINE/2;
			x4 = lx2 + TXT_SPC + SEL_MARGIN + SEL_LINE/2;

			if (iwidth <= (data->label_width + 2*it->itbox.text_spacing))
					y2 = ly1 - TXT_SPC - SEL_MARGIN - SEL_LINE/2;
			else
					y2 = iy2 + SEL_MARGIN + SEL_LINE/2;
		}
		points[0].x=x1;
		points[0].y=y2;
		points[1].x=x2;
		points[1].y=y2;
		points[2].x=x2;
		points[2].y=y1;
		points[3].x=x3;
		points[3].y=y1;
		points[4].x=x3;
		points[4].y=y2;
		points[5].x=x4;
		points[5].y=y2;
		points[6].x=x4;
		points[6].y=y3;
		points[7].x=x1;
		points[7].y=y3;
		points[8].x=x1;
		points[8].y=y2;
		if  (it->itbox.viewtype == XmLARGE_ICON) XDrawLines(dpy, XtWindow(w), it->itbox.normalGC, points, 9, CoordModeOrigin);
	}

	values.line_style = LineSolid;
	values.line_width = 1;
	values.fill_style = FillSolid;
	XChangeGC(dpy, it->itbox.normalGC, mask, &values);
	XSetForeground(dpy, it->itbox.normalGC, it->itbox.foreground_pixel);

}


#undef MARGIN_W
#undef MARGIN_H
#undef SEL_LINE
#undef SEL_MARGIN
#undef TXT_SPC



void DrawTextSmall(Widget w, XmNlItBoxInfo * data, GC gc, int x, int y, int number, int direction, unsigned char align, Boolean redraw)
{
#define w_label  data->label_width
#define h_label  data->label_height
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	Display *dpy;
	Drawable drw;

	CacheBufElement* CachePtr;
	Pixmap pbuf;

	if (y > it->itbox.viewHeight) return;

	dpy = XtDisplay(w);

	if (it->itbox.buffering)
	{
		if (data->buf)
		{
			pbuf = (((CacheBufElement*) (data->buf))->id);
		}
		else
		{
			CachePtr = GetPixBufNew(w, data, number, direction);
			if (!CachePtr)
			{
				return ;
			}
			pbuf = CachePtr->id;
			data->buf = CachePtr;
		}

		if (PIX_FOUND(pbuf))
		{
			if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
				(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
				XCopyArea(dpy, pbuf, XtWindow(w), it->itbox.normalGC,
							0, 0, w_label, h_label,
							x + it->itbox.text_spacing,
							y + it->itbox.text_spacing);
			if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
				(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
				XCopyArea(dpy, pbuf, XtWindow(w), it->itbox.normalGC,
							0, 0, w_label, h_label,
							x + it->itbox.text_spacing,
							y + it->itbox.text_spacing);
			if (align == XmALIGNMENT_CENTER)
				XCopyArea(dpy, pbuf, XtWindow(w), it->itbox.normalGC,
							0, 0, w_label, h_label,
							x + it->itbox.text_spacing,
							y + it->itbox.text_spacing);
		}
	}
	else
	{
		if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
				(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
			XmStringDraw(dpy, XtWindow(w), it->itbox.font_list, data->xmlabel, gc,
				x + it->itbox.text_spacing,
				y + it->itbox.text_spacing,
				w_label, XmALIGNMENT_BEGINNING,
				XmSTRING_DIRECTION_DEFAULT, NULL);
		if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
				(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
			XmStringDraw(dpy, XtWindow(w), it->itbox.font_list, data->xmlabel, gc,
				x + it->itbox.text_spacing,
				y + it->itbox.text_spacing,
				w_label, XmALIGNMENT_END,
				XmSTRING_DIRECTION_DEFAULT, NULL);
		if (align == XmALIGNMENT_CENTER)
			XmStringDraw(dpy, XtWindow(w), it->itbox.font_list, data->xmlabel, gc,
				x + it->itbox.text_spacing,
				y + it->itbox.text_spacing,
				w_label, XmALIGNMENT_BEGINNING,
				XmSTRING_DIRECTION_DEFAULT, NULL);
	}

#undef w_label
#undef h_label
}



void DrawItemSmall(Widget w, XmNlItBoxInfo * data, int x, int y, int number, int direciton)
{

    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int j,k=0;
	int last_shift;
	int b_row, b_y, e_y;
	int x1, x2, x3, y1, y2, y3, delta;
	Display *dpy;
	Drawable drw;
	Boolean redraw = FALSE;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;
	unsigned char align;
	unsigned int iwidth, iheight;
	Position base_y, base_x;


//	ptr=it->itbox.item_data;
	drw=XtWindow(w);
	background_color=it->itbox.background_pixel;
	foreground_color=it->itbox.foreground_pixel;
	if (it->itbox.select_background_pixel == XmREVERSED_GROUND_COLORS)
			sel_bg_color=it->primitive.foreground;
	else
			sel_bg_color=it->itbox.select_background_pixel;
	sel_fg_color=it->itbox.select_foreground_pixel;
#ifdef DEBUG
	printf("\nDrawItemSmall: color=%d", background_color);
#endif

	if (data==NULL || it->itbox.num_items==0) return;
#ifdef DEBUG
	printf("\n DrawItemSmall starting\n");
#endif

	dpy=XtDisplay(w);
#ifdef DEBUG
	if (dpy==NULL) printf("\n display not found\n");
#endif


#ifdef DEBUG
	printf("\n DrawItem: %s x= %d y= %d w= %d h= %d\n", data->name, x+it->itbox.margin_w+it->itbox.select_line_w+it->itbox.select_line_margin,
	y+it->itbox.margin_h+it->itbox.select_line_w+it->itbox.select_line_margin, it->itbox.max_icon_width, it->itbox.max_icon_height);
#endif


	if (data->alignment == XmALIGNMENT_UNSPECIFIED)
		align = it->itbox.alignment;
	else
		align = data->alignment;

	if (data->icon)
	{
		iwidth = data->icon->width;
		iheight = data->icon->height;
		if (PIX_FOUND(data->icon->pix))
		{
			base_y = y + it->itbox.cell_height - it->itbox.margin_h - it->itbox.select_line_w -
					it->itbox.select_line_margin - data->icon->height;

			if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
				(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
				XCopyArea(dpy, data->icon->pix, drw, it->itbox.normalGC,
						0, 0, data->icon->width, data->icon->height,
						x+it->itbox.margin_w+it->itbox.select_line_w+it->itbox.select_line_margin,
						base_y);

			if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
				(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
				XCopyArea(dpy, data->icon->pix, drw, it->itbox.normalGC,
						0, 0, data->icon->width, data->icon->height,
						x+it->itbox.cell_width - it->itbox.margin_w - it->itbox.select_line_w - it->itbox.select_line_margin - data->icon->width,
						base_y);

			if (align == XmALIGNMENT_CENTER)
				XCopyArea(dpy, data->icon->pix, drw, it->itbox.normalGC,
						0, 0, data->icon->width, data->icon->height,
						x+it->itbox.margin_w+it->itbox.select_line_w+it->itbox.select_line_margin,
						base_y);
		}
	}
	else
	{
		iwidth = 0;
		iheight = 0;
	}

	base_y = y + it->itbox.cell_height - it->itbox.margin_h - it->itbox.select_line_w -
			it->itbox.select_line_margin - 2*it->itbox.text_spacing - data->label_height;

	if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
		(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
			base_x = x + it->itbox.margin_w + it->itbox.select_line_w + 2*it->itbox.select_line_margin +
					iwidth;

	if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
		(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
			base_x = x + it->itbox.cell_width - it->itbox.margin_w - it->itbox.select_line_w -
				2*it->itbox.select_line_margin - iwidth - data->label_width - 2*it->itbox.text_spacing;

	if (align == XmALIGNMENT_CENTER)
			base_x = x + it->itbox.margin_w + it->itbox.select_line_w + 2*it->itbox.select_line_margin +
					iwidth;


	if (data->selected==True)
	{
		XSetForeground(dpy, it->itbox.normalGC, sel_bg_color);
		XSetBackground(dpy, it->itbox.normalGC, sel_fg_color);

		XFillRectangle(dpy, drw, it->itbox.normalGC,
						base_x, base_y,
						data->label_width + 2 * it->itbox.text_spacing,
						data->label_height + 2 * it->itbox.text_spacing);

		XSetForeground(dpy, it->itbox.normalGC, foreground_color);
		XSetBackground(dpy, it->itbox.normalGC, background_color);

//		DrawText(w, gc, x, y, data, buffering);
		DrawTextSmall(w, data, it->itbox.highlightGC, base_x, base_y, number, direciton, align, redraw);
	}
	else
	{
		XSetBackground(dpy, it->itbox.normalGC, background_color);
		XSetForeground(dpy, it->itbox.normalGC, foreground_color);

		DrawTextSmall(w, data, it->itbox.normalGC, base_x, base_y, number, direciton, align, redraw);
	}

	if (data==it->itbox.item_data[it->itbox.current_item] && it->itbox.HasFocus)
	{
		HighLightItem(w, data, x, y);
	}

#ifdef DEBUG
	printf("DrawItem=OK\n");
#endif
}




void DrawText(Widget w, XmNlItBoxInfo * data, GC gc, int x, int y, int number, int direction, unsigned char align, Boolean redraw)
{
#define w_label  data->label_width
#define h_label  data->label_height
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	Display *dpy;
	Drawable drw;
	CacheBufElement* CachePtr;

	Pixmap pbuf;


	if (y > it->itbox.viewHeight) return;

	dpy=XtDisplay(w);


	if (it->itbox.buffering)
	{
		if (data->buf)
		{
			pbuf = (((CacheBufElement*) (data->buf))->id);
		}
		else
		{

			CachePtr = GetPixBufNew(w, data, number, direction);
			if (!CachePtr)
			{
				return ;
			}
			pbuf = CachePtr->id;
			data->buf = CachePtr;
		}

		if (PIX_FOUND(pbuf))
		{
			if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
				(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
				XCopyArea(dpy, pbuf, XtWindow(w), it->itbox.normalGC,
							0, 0, w_label, h_label,
							x+it->itbox.margin_w+it->itbox.select_line_w+it->itbox.select_line_margin+it->itbox.text_spacing,
							y + it->itbox.base_y + it->itbox.select_line_margin + it->itbox.text_spacing);
			if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
				(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
				XCopyArea(dpy, pbuf, XtWindow(w), it->itbox.normalGC,
							0, 0, w_label, h_label,
							x + it->itbox.cell_width - it->itbox.margin_w - it->itbox.select_line_w - it->itbox.select_line_margin -
							it->itbox.text_spacing - w_label,
							y + it->itbox.base_y + it->itbox.select_line_margin + it->itbox.text_spacing);
			if (align == XmALIGNMENT_CENTER)
				XCopyArea(dpy, pbuf, XtWindow(w), it->itbox.normalGC,
							0, 0, w_label, h_label,
							x + it->itbox.cell_width/2 - data->label_width/2,
							y + it->itbox.base_y + it->itbox.select_line_margin + it->itbox.text_spacing);
		}
	}
	else
	{
		if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
				(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
			XmStringDraw(dpy, XtWindow(w), it->itbox.font_list, data->xmlabel, gc,
				x + it->itbox.margin_w + it->itbox.select_line_w + it->itbox.select_line_margin+it->itbox.text_spacing,
				y + it->itbox.base_y + it->itbox.select_line_margin + it->itbox.text_spacing,
				w_label, XmALIGNMENT_BEGINNING,
				XmSTRING_DIRECTION_DEFAULT, NULL);
		if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
				(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
			XmStringDraw(dpy, XtWindow(w), it->itbox.font_list, data->xmlabel, gc,
				x + it->itbox.cell_width - it->itbox.margin_w - it->itbox.select_line_w - it->itbox.select_line_margin - it->itbox.text_spacing - w_label,
				y + it->itbox.base_y + it->itbox.select_line_margin + it->itbox.text_spacing,
				w_label, XmALIGNMENT_END,
				XmSTRING_DIRECTION_DEFAULT, NULL);
		if (align == XmALIGNMENT_CENTER)
		{
			XmStringDraw(dpy, XtWindow(w), it->itbox.font_list, data->xmlabel, gc,
				x + it->itbox.cell_width/2 - data->label_width/2,
				y + it->itbox.base_y + it->itbox.select_line_margin + it->itbox.text_spacing,
				w_label, XmALIGNMENT_CENTER,
				XmSTRING_DIRECTION_DEFAULT, NULL);
			}
	}

#undef w_label
#undef h_label
}




void DrawItem(Widget w, XmNlItBoxInfo * data, int x, int y, int number, int direction)
{

    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int j,k=0;
	int last_shift;
	int b_row, b_y, e_y;
	int x1, x2, x3, y1, y2, y3, delta;
	Display *dpy;
	Drawable drw;
	Boolean redraw = FALSE;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;
	unsigned char align;

	assert(data != NULL);

	if (it->itbox.viewtype != XmLARGE_ICON)
	{
		DrawItemSmall(w, data, x, y, number, direction);
		return ;
	}

//	ptr=it->itbox.item_data;
/*	if (buffering) drw=it->itbox.pix;
	else drw=XtWindow(w);*/
	drw=XtWindow(w);
//	background_color=((XmPrimitiveWidget)it)->primitive.background;
//	background_color=w->core.background_pixel;
	background_color=it->itbox.background_pixel;
	foreground_color=it->itbox.foreground_pixel;
	if (it->itbox.select_background_pixel == XmREVERSED_GROUND_COLORS)
			sel_bg_color=it->primitive.foreground;
	else
			sel_bg_color=it->itbox.select_background_pixel;
	sel_fg_color=it->itbox.select_foreground_pixel;
#ifdef DEBUG
	printf("\nDrawItem: color=%d", background_color);
#endif

	if (data==NULL || it->itbox.num_items==0) return;
#ifdef DEBUG
	printf("\n DrawItem starting\n");
#endif

	dpy=XtDisplay(w);
#ifdef DEBUG
	if (dpy==NULL) printf("\n display not found\n");
#endif

#ifdef DEBUG
	printf("\n DrawItem: %s x= %d y= %d w= %d h= %d\n", data->name, x+it->itbox.margin_w+it->itbox.select_line_w+it->itbox.select_line_margin,
	y+it->itbox.margin_h+it->itbox.select_line_w+it->itbox.select_line_margin, it->itbox.max_icon_width, it->itbox.max_icon_height);
#endif



	if (data->alignment == XmALIGNMENT_UNSPECIFIED)
		align = it->itbox.alignment;
	else
		align = data->alignment;

	if (data->icon)
	{
		if (PIX_FOUND(data->icon->pix))
		{
			if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
				(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
				XCopyArea(dpy, data->icon->pix, drw, it->itbox.normalGC,
						0, 0, data->icon->width, data->icon->height,
						x+it->itbox.margin_w+it->itbox.select_line_w+it->itbox.select_line_margin,
						y + it->itbox.base_y - data->icon->height);

			if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
				(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
				XCopyArea(dpy, data->icon->pix, drw, it->itbox.normalGC,
						0, 0, data->icon->width, data->icon->height,
						x+it->itbox.cell_width - it->itbox.margin_w - it->itbox.select_line_w - it->itbox.select_line_margin - data->icon->width,
						y + it->itbox.base_y - data->icon->height);

			if (align == XmALIGNMENT_CENTER)
				XCopyArea(dpy, data->icon->pix, drw, it->itbox.normalGC,
						0, 0, data->icon->width, data->icon->height,
						x + it->itbox.cell_width/2 - data->icon->width/2,
						y + it->itbox.base_y - data->icon->height);
		}
	}

	if (data->selected==True)
	{
		XSetForeground(dpy, it->itbox.normalGC, sel_bg_color);
		XSetBackground(dpy, it->itbox.normalGC, sel_fg_color);

			if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == LtoR_render) ||
				(align == XmALIGNMENT_END && it->itbox.render_order == RtoL_render))
					XFillRectangle(dpy, drw, it->itbox.normalGC,
							x + it->itbox.margin_w + it->itbox.select_line_w + it->itbox.select_line_margin,
							y + it->itbox.base_y + it->itbox.select_line_margin,
							data->label_width + 2 * it->itbox.text_spacing,
							data->label_height + 2 * it->itbox.text_spacing);

			if ((align == XmALIGNMENT_BEGINNING && it->itbox.render_order == RtoL_render) ||
				(align == XmALIGNMENT_END && it->itbox.render_order == LtoR_render))
					XFillRectangle(dpy, drw, it->itbox.normalGC,
							x + it->itbox.cell_width - it->itbox.margin_w - it->itbox.select_line_w - it->itbox.select_line_margin - 2*it->itbox.text_spacing - data->label_width,
							y + it->itbox.base_y + it->itbox.select_line_margin,
							data->label_width + 2 * it->itbox.text_spacing,
							data->label_height + 2 * it->itbox.text_spacing);

			if (align == XmALIGNMENT_CENTER)
					XFillRectangle(dpy, drw, it->itbox.normalGC,
							x + it->itbox.cell_width/2 - data->label_width/2 - it->itbox.select_line_margin,
							y + it->itbox.base_y + it->itbox.select_line_margin,
							data->label_width + 2 * it->itbox.text_spacing,
							data->label_height + 2 * it->itbox.text_spacing);


		XSetForeground(dpy, it->itbox.normalGC, foreground_color);
		XSetBackground(dpy, it->itbox.normalGC, background_color);

//		DrawText(w, gc, x, y, data, buffering);
		DrawText(w, data, it->itbox.highlightGC, x, y, number, direction, align, redraw);
	}
	else
	{
		XSetBackground(dpy, it->itbox.normalGC, background_color);
		XSetForeground(dpy, it->itbox.normalGC, foreground_color);

		DrawText(w, data, it->itbox.normalGC, x, y, number, direction, align, redraw);
	}

	if (data==it->itbox.item_data[it->itbox.current_item] && it->itbox.HasFocus)
	{
		HighLightItem(w, data, x, y);
	}

#ifdef DEBUG
	printf("DrawItem=OK\n");
#endif
}

void PosToXY(XmNlItemBoxWidget it, int num, int * x, int * y)
{
    if (it->itbox.render_order == LtoR_render) *x = (num - (num/it->itbox.col_num)*it->itbox.col_num) * it->itbox.cell_width;
    else *x = it->itbox.viewWidth - it->itbox.cell_width - (num - (num/it->itbox.col_num)*it->itbox.col_num) * it->itbox.cell_width;
    *y = (num/it->itbox.col_num) * it->itbox.cell_height - it->itbox.global_shift;
}

static void DeleteCell(XmNlItemBoxWidget it, XmNlItBoxInfo * cell)
{
	IconInfo * ptr1, * ptr2;
	CacheBufElement * pp1;

	if (cell->xmlabel) XmStringFree(cell->xmlabel);

/** Clear text pixbuf **/
	if (cell->buf)
	{
		pp1 = (CacheBufElement *) cell->buf;
		pp1->cell = NULL;
	}

/** Clear icon **/
	if (cell->icon)
		DelIconFromList((Widget) it, cell->icon);
}

void XmNlItBoxDeleteItems(Widget w, int * positions, int count)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
    int i, k, deleted = 0;
	Boolean refreshBuf, SelectionChanged;
	XmNlItBoxInfo ** tmp_buf, * cell;
	int last_items;

	if (it->itbox.num_items == 0 || it->itbox.item_data == NULL)
	{
		return ;
	}

	if (count > it->itbox.num_items)
		return ;

	if (count == it->itbox.num_items)
	{
		XmNlItBoxDeleteAllItems(w);
		return ;
	}


	tmp_buf = it->itbox.item_data;

	for (i = 0; i < count; i++)
	{
		k = positions[i];
		if (k >= 0 && k < it->itbox.num_items)
		{
			if (tmp_buf[k])
			{
				if (k == it->itbox.current_item || k < it->itbox.current_item) it->itbox.current_item--;
				DeleteCell(it, tmp_buf[k]);
				FreeCacheNode(it, tmp_buf[k]);
				tmp_buf[k] = NULL;
				deleted++;
			}
		}
	}

	if (it->itbox.current_item < 0) it->itbox.current_item = -1;

	it->itbox.item_data = (XmNlItBoxInfo **) XtMalloc((it->itbox.num_items - deleted) * sizeof(XmNlItBoxInfo *));


	for (i = 0, k = 0; i < it->itbox.num_items; i++)
	{
		if (tmp_buf[i])
		{
			it->itbox.item_data[k] = tmp_buf[i];
			k++;
		}
	}

	XtFree((char *) tmp_buf);

	it->itbox.num_items = it->itbox.num_items - deleted;


#ifdef DEBUG_CACHE_ICON
	IconCacheInfo(it);
#endif



	SelectionChanged = SelectChanged(it);

   	it->itbox.cell_height=0;
	it->itbox.cell_width=0;
	it->itbox.max_icon_height=0;
	it->itbox.max_icon_width=0;


	it->itbox.PublicItemCount = it->itbox.num_items;

#ifdef DEBUG
	if (it->itbox.SelectedPositionsCount)
	{
		for (i = 0; i < it->itbox.SelectedPositionsCount; i++)
		{
			printf("Selected %d\t", it->itbox.SelectedPositions[i]);
		}
		printf("\n");
	}
#endif

   	if (it->itbox.viewtype == XmLARGE_ICON)
		RecalcParamLarge(w, 0, it->itbox.num_items);
	else
		RecalcParamSmall(w, 0, it->itbox.num_items);

	ResizeStuff(it);
   	refreshBuf = CalcGeom(w);
   	CorrectGlobalShift(w);
    RecalcRegions(w);
	if (XtIsRealized(w))
	{
		if (it->itbox.num_items==0) return;
		RedrawAllDirect(w);
		ResizeSliders(w);
	}

	if (SelectionChanged && it->itbox.select_notify)
		HighlightDoCallback(w, XmNlCR_DELETE_SELECT, NULL);
}

void XmNlItBoxDeleteAllItems(Widget w)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
    int x, y, i;
	Boolean refreshBuf;
	XmNlItBoxInfo * tmp_buf;

	for (i = 0; i < it->itbox.num_items; i++)
	{
		tmp_buf = it->itbox.item_data[i];
		DeleteCell(it, tmp_buf);
		FreeCacheNode(it, tmp_buf);
#ifdef DEBUG
	printf("XmNlItBoxDeleteAllItems: xmstring free for item %s\n", tmp_buf->name);
#endif
	}
//printf("After del cells IconList = %p\n", it->itbox.IconList);
//	ClearIconList(it);

//	DeletePixBufCache(it);

	if (it->itbox.item_data != NULL) XtFree((char *)it->itbox.item_data);
	if (it->itbox.SelectedPositions != NULL) 
	{
		XtFree((char *)it->itbox.SelectedPositions);
		it->itbox.SelectedPositions = NULL;
	}

	if (it->itbox.SelectedPositionsCount)
	{
		it->itbox.SelectedPositionsCount = 0;
		if (it->itbox.select_notify)
			HighlightDoCallback(w, XmNlCR_DELETE_SELECT, NULL);
	}

	it->itbox.current_item = -1;

	it->itbox.num_items = 0;
	it->itbox.item_data = NULL;

	it->itbox.DblClicked=False;

   	it->itbox.cell_height = 0;
	it->itbox.cell_width = 0;
	it->itbox.max_icon_height = 0;
	it->itbox.max_icon_width = 0;
	RecalcParamLarge(w, 0, it->itbox.num_items);
	it->itbox.global_shift=0;
//	it->itbox.shift_in_pix=0;
//	it->itbox.pix_shift=0;

	it->itbox.col_num = 0;
	it->itbox.row_num = 0;

	it->itbox.PublicItemCount = 0;
	it->itbox.TopItemPosition = 0;
	it->itbox.VisibleItemCount = 0;



	ResizeStuff(it);

	it->itbox.full_height = it->itbox.viewHeight;

   	CorrectGlobalShift(w);
//    if (!it->itbox.buffering) RecalcRegions( w );
	if (!it->itbox.DestroyPhase) ResizeSliders(w);

	if (XtIsRealized(w))
	{
		XClearArea(XtDisplay(w), XtWindow(w), it->itbox.viewX, it->itbox.viewY, it->itbox.viewWidth, it->itbox.viewHeight, FALSE);

/*		XmeDrawShadows (XtDisplay (w), XtWindow (w),
                it->primitive.top_shadow_GC,
                it->primitive.bottom_shadow_GC,
                it->primitive.highlight_thickness,
                it->primitive.highlight_thickness,
				it->core.width - (2 * it->primitive.highlight_thickness),
				it->core.height - (2 * it->primitive.highlight_thickness),
				it->primitive.shadow_thickness,
				XmSHADOW_IN);*/
	}
}



static int AddCells(XmNlItemBoxWidget it, int count)
{
	XmNlItBoxInfo ** data;
	int new_num, i;

	new_num = it->itbox.num_items + count;
	data = (XmNlItBoxInfo **) XtMalloc(new_num * sizeof(XmNlItBoxInfo *));
	if (!data) return 0;
	memcpy((void *) data, (void *) it->itbox.item_data, sizeof(XmNlItBoxInfo *) * it->itbox.num_items);
	XtFree((char *) it->itbox.item_data);
	it->itbox.item_data = data;
	for (i = it->itbox.num_items; i < new_num; i++)
	{
		data[i] = (XmNlItBoxInfo *) XtCalloc(1, sizeof(XmNlItBoxInfo));
	}
	it->itbox.num_items = new_num;
	return 1;
}

static int InsertCells(XmNlItemBoxWidget it, int pos, int count)
{
	XmNlItBoxInfo ** data;
	int new_num, i;

	new_num = it->itbox.num_items + count;


/*	for (i = 0; i < it->itbox.num_items; i++)
	{
		printf("Pointer %d before insertion %p\n", i, it->itbox.item_data[i]);
	}
*/

	data = (XmNlItBoxInfo **) XtMalloc(new_num * sizeof(XmNlItBoxInfo *));
	if (!data) return 0;

	if (pos > 0)
		memcpy((void *) data, (void *) it->itbox.item_data, sizeof(XmNlItBoxInfo *) * pos);

/*
	for (i = 0; i < pos; i++)
	{
		printf("Pointer %d after insertion --- %p\n", i, data[i]);
	}
*/

	if (pos < it->itbox.num_items)
		memcpy((void *) (data + pos + count),
				(void *) (it->itbox.item_data + pos),
				sizeof(XmNlItBoxInfo *) * (it->itbox.num_items - pos));

#ifdef DEBUG
	for (i = 0; i < new_num; i++)
	{
		if (i < it->itbox.num_items) printf("Pointer %d\t%p\t%p\n", i, it->itbox.item_data[i], data[i]);
		else printf("Pointer %d\t\t\t%p\n", i, data[i]);
	}
#endif

	XtFree((char *) it->itbox.item_data);
	it->itbox.item_data = data;
	for (i = pos; i < pos + count; i++)
	{
		data[i] = (XmNlItBoxInfo *) XtCalloc(1, sizeof(XmNlItBoxInfo));
	}
	it->itbox.num_items = new_num;

#ifdef DEBUG
	for (i = 0; i < it->itbox.num_items; i++)
	{
		printf("Pointer after insertio %d\t\t\t%p\n", i,it->itbox.item_data[i]);
	}
#endif

	return 1;
}

static void SetCells(XmNlItemBoxWidget it, int pos, XmNlCell *items, int count, unsigned char valuemask)
{
	int i, j;
	XmNlItBoxInfo * ItemsData;
	IconInfo * icon;

	for (i=0, j=pos; i<count; i++, j++)
	{
		ItemsData = it->itbox.item_data[j];
		if ((valuemask & CellPixmap) && PIX_FOUND(items[i].pixmap))
		{
			if (valuemask & CellMask) icon = AddIconToList((Widget) it, items[i].pixmap, items[i].mask);
			else icon = AddIconToList((Widget) it, items[i].pixmap, XmUNSPECIFIED_PIXMAP);
			if (icon)
			{
				ItemsData->icon = icon;
				icon->use_counter ++;
			}
			else ItemsData->icon = NULL;
		}
		else 
			ItemsData->icon = NULL;

		if (valuemask & CellCharString) 
			ItemsData->name = items[i].text;
		else 
			ItemsData->name = NULL;

		if (valuemask & CellXmString)
		{
			ItemsData->xmlabel = XmStringCopy(items[i].xmlabel);
			ItemsData->label_height = XmStringHeight(it->itbox.font_list, ItemsData->xmlabel);
			ItemsData->label_width = XmStringWidth(it->itbox.font_list, ItemsData->xmlabel);
		}
		else
		{
			ItemsData->xmlabel = NULL;
			ItemsData->label_height = 0;
			ItemsData->label_width = 0;
		}

		if (valuemask & CellSelection)
		{
			ItemsData->selected = items[i].selected;
		}
		else
			ItemsData->selected = False;
		ItemsData->buf=NULL;

		if (valuemask & CellAlignment) ItemsData->alignment = items[i].alignment;
		else ItemsData->alignment = XmALIGNMENT_UNSPECIFIED;

		if (valuemask & CellUserData) ItemsData->UserDataPointer=items[i].UserDataPointer;
		else ItemsData->UserDataPointer = NULL;
	}
}


void XmNlItBoxAddItems(Widget w, XmNlCell *items, int count, unsigned char valuemask)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int i, j, last_col, last_height;;
    int x, y, FirstPosition;
	Boolean refreshBuf, AddToEmty, CellSizeChanged, SelectionChanged;
	int FirstVisibleItem, LastVisibleItem, FirstRow, LastRow;
	XmNlItBoxInfo ** ItemsData;
	IconInfo * icon;


	if (it->itbox.num_items == 0 || it->itbox.item_data == NULL)
	{
		AddToEmty = True;
		FirstPosition = 0;
		it->itbox.item_data = (XmNlItBoxInfo **) XtMalloc(count * sizeof(XmNlItBoxInfo *));
		if (!it->itbox.item_data) return ;
		ItemsData=it->itbox.item_data;
		it->itbox.num_items = count;
		for (i = 0; i < count; i++)
		{
			it->itbox.item_data[i] = (XmNlItBoxInfo *) XtCalloc(1, sizeof(XmNlItBoxInfo));
		}
	}
	else
	{
		AddToEmty = False;
		FirstPosition = it->itbox.num_items;
		if ((AddCells(it, count)) == 0 ) return ;
	}

	SetCells(it, FirstPosition, items, count, valuemask);

#ifdef DEBUG_CACHE_ICON
	IconCacheInfo(it);
#endif


	it->itbox.PublicItemCount = it->itbox.num_items;

   	if (it->itbox.viewtype == XmLARGE_ICON) CellSizeChanged = RecalcParamLarge( w, FirstPosition, count);
   	else CellSizeChanged = RecalcParamSmall( w, FirstPosition, count);

	ResizeStuff(it);
	last_col = it->itbox.col_num;
	last_height = it->itbox.full_height;
    refreshBuf = CalcGeom(w);

    if (AddToEmty && it->itbox.HasFocus) it->itbox.current_item = 0;

	SelectionChanged = SelectChanged(it);

	it->itbox.CacheBufLimit = it->itbox.VisibleCount + 2 * it->itbox.col_num;

//	printf("Adding -> cache limit %d\n", it->itbox.CacheBufLimit);

	if (XtIsRealized(w))
	{

		if (it->itbox.num_items == 0) 
			return;
		if (last_height != it->itbox.full_height) ResizeSliders(w);
		if (CellSizeChanged || last_col != it->itbox.col_num)
		{
			RedrawAllDirect(w);
			if (SelectionChanged && it->itbox.select_notify)
				HighlightDoCallback(w, XmNlCR_ADD_SELECT, NULL);
#ifdef DEBUG
			printf("XmItemBox: all items added sucsefull %d %p\n", it->itbox.num_items, it->itbox.item_data);
#endif
			return ;
		}

		j = FirstPosition;
		for (i = 0; i<count; i++, j++)
		{
			if (j >= it->itbox.firstViewItem && j <= it->itbox.lastViewItem)
				RedrawItemDirect(w, j, 0);
		}

		if (SelectionChanged && it->itbox.select_notify)
			HighlightDoCallback(w, XmNlCR_ADD_SELECT, NULL);
#ifdef DEBUG
	printf("XmItemBox: all items added sucsefull %d %p\n", it->itbox.num_items, it->itbox.item_data);
#endif
	}
}

void XmNlItBoxInsertItems(Widget w, XmNlCell *items, int first_pos, int count, unsigned char valuemask)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int i, last_col, last_height;;
    int FirstPosition;
	Boolean refreshBuf, AddToEmty, CellSizeChanged, SelectionChanged;
	XmNlItBoxInfo ** ItemsData;

#ifdef DEBUG
	printf("XmlItBoxInsert  %d %p\n", it->itbox.num_items, it->itbox.item_data);
#endif

	if (it->itbox.num_items == 0 || it->itbox.item_data == NULL)
	{
#ifdef DEBUG
		printf("XmlItBoxInsert  1\n");
#endif
		AddToEmty = True;
		FirstPosition = 0;
		it->itbox.item_data = (XmNlItBoxInfo **) XtMalloc(count * sizeof(XmNlItBoxInfo *));
		if (!it->itbox.item_data) return ;
		ItemsData=it->itbox.item_data;
		it->itbox.num_items = count;
		for (i = 0; i < count; i++)
		{
			it->itbox.item_data[i] = (XmNlItBoxInfo *) XtCalloc(1, sizeof(XmNlItBoxInfo));
		}
	}
	else
	{
#ifdef DEBUG
		printf("XmlItBoxInsert  2\n");
#endif
		AddToEmty = False;
		FirstPosition = first_pos;
		if ((InsertCells(it, first_pos, count)) == 0 ) return ;
	}

	SetCells(it, FirstPosition, items, count, valuemask);

	it->itbox.PublicItemCount = it->itbox.num_items;

   	if (it->itbox.viewtype == XmLARGE_ICON) CellSizeChanged = RecalcParamLarge( w, FirstPosition, count);
   	else CellSizeChanged = RecalcParamSmall( w, FirstPosition, count);
#ifdef DEBUG
	printf("XmlItemBox insert items: recalc param sucsefull\n");
#endif

	ResizeStuff(it);
#ifdef DEBUG
	printf("XmlItemBox insert items: resizestuff sucsefull\n");
#endif
	last_col = it->itbox.col_num;
	last_height = it->itbox.full_height;
    refreshBuf = CalcGeom(w);

    RecalcRegions(w);

    if (AddToEmty && it->itbox.HasFocus) it->itbox.current_item = 0;
#ifdef DEBUG
	printf("XmlItemBox inset tems: calc geom sucsefull\n");
	printf("Layout direction %hhx\n", ((XmPrimitiveWidget)(it))->primitive.layout_direction);
#endif

	if (it->itbox.num_items==0) return;

	SelectionChanged = SelectChanged(it);

	if (XtIsRealized(w))
	{

		if (last_height != it->itbox.full_height) ResizeSliders(w);
		if (CellSizeChanged || last_col != it->itbox.col_num)
		{
			RedrawAllDirect(w);
			if (SelectionChanged && it->itbox.select_notify)
				HighlightDoCallback(w, XmNlCR_ADD_SELECT, NULL);
			return ;
		}

		for (i = FirstPosition; i <= it->itbox.lastViewItem; i++)
		{
			RedrawItemDirect(w, i, 0);
		}

		if (SelectionChanged && it->itbox.select_notify)
			HighlightDoCallback(w, XmNlCR_ADD_SELECT, NULL);
#ifdef DEBUG
	printf("XmlItemBox: all items added sucsefull\n");
#endif
	}
}

void XmNlItBoxGetSelectedItems(Widget w, int * count, int ** select_numbers)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int i, *selected;

	if (it->itbox.SelectedPositionsCount == 0)
	{
		if (count)
			*count = 0;
		if (select_numbers)
			*select_numbers = NULL;
		return ;
	}

	if (select_numbers)
	{
		selected = malloc(sizeof(int) * it->itbox.SelectedPositionsCount);

		for (i=0; i < it->itbox.SelectedPositionsCount; i++)
		{
			selected[i] = it->itbox.SelectedPositions[i];
		}

		*select_numbers = selected;
	}
	if (count)
		*count = it->itbox.SelectedPositionsCount;
	return ;
}

void XmNlItBoxSetItem(Widget w, XmNlCell *item, unsigned char valuemask, int position)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	XmNlItBoxInfo * data;
	int FirstRow, LastRow, FirstVisibleItem, LastVisibleItem;
	int string_w, string_h, cell_height, cell_width, x, y;
	unsigned int width=0, height=0, bw, depth;
	Display *dpy;
	Boolean CellSizeChanged = False, GeomChanged = False, refreshBuf = False, SelectionChanged = False;
	Window root;
	IconInfo * icon = NULL;

	if (it->itbox.num_items==0 || it->itbox.item_data==NULL ||
		position >= it->itbox.num_items || position < 0) return;

	dpy=XtDisplay(w);
	data = it->itbox.item_data[position];

	if (valuemask & CellPixmap)
	{
		if (data->icon)
		{
			if (data->icon->parent != item->pixmap)
			{
				data->icon->use_counter--;
				if (data->icon->use_counter <= 0)
				{
					DelIconFromList((Widget) it, data->icon);
				}
				data->icon = NULL;
				if (PIX_FOUND(item->pixmap))
				{
					if (valuemask & CellMask) icon = AddIconToList((Widget) it, item->pixmap, item->mask);
					else icon = AddIconToList((Widget) it, item->pixmap, XmUNSPECIFIED_PIXMAP);
				}
			}
//			else goto icon_ready ;
		}
		else
		{
			if (PIX_FOUND(item->pixmap))
			{
				if (valuemask & CellMask) icon = AddIconToList((Widget) it, item->pixmap, item->mask);
				else icon = AddIconToList((Widget) it, item->pixmap, XmUNSPECIFIED_PIXMAP);
			}
		}

		if (icon)
		{
			data->icon = icon;
			icon->use_counter++;
		}
//		else data->icon = NULL;
	}

//icon_ready:

#ifdef DEBUG_CACHE_ICON
	IconCacheInfo(it);
#endif

	if (valuemask & CellCharString) data->name = item->text;
	if (valuemask & CellXmString)
	{
		if (data->xmlabel) XmStringFree(data->xmlabel);
		data->xmlabel = XmStringCopy(item->xmlabel);
		data->label_height = XmStringHeight(it->itbox.font_list, data->xmlabel);
		data->label_width = XmStringWidth(it->itbox.font_list, data->xmlabel);
	}

	if (valuemask & CellSelection)
	{
		data->selected = item->selected;
		SelectionChanged = SelectChanged(it);
	}
	data->buf=NULL;

	if (valuemask & CellAlignment) data->alignment = item->alignment;
//	else data->alignment = XmALIGNMENT_UNSPECIFIED;

	if (valuemask & CellUserData) data->UserDataPointer = item->UserDataPointer;
//	else data->UserDataPointer = NULL;

/*** Calc new size of changed cell ***/
   	it->itbox.cell_height=0;
	it->itbox.cell_width=0;
	it->itbox.max_icon_height=0;
	it->itbox.max_icon_width=0;

   	if (it->itbox.viewtype == XmLARGE_ICON) CellSizeChanged = RecalcParamLarge( w, 0, it->itbox.num_items);
   	else CellSizeChanged = RecalcParamSmall( w, 0, it->itbox.num_items);
#ifdef DEBUG
	printf("XmItemBox SetCell: recalc param sucsefull\n");
#endif

	ResizeStuff(it);
#ifdef DEBUG
	printf("XmItemBox SetCell: resizestuff sucsefull\n");
#endif

    refreshBuf = CalcGeom(w);

#ifdef DEBUG
	printf("XmItemBox SetCell: calc geom sucsefull\n");
#endif

	if (XtIsRealized(w))
	{

		if (it->itbox.num_items==0) return;
		CorrectGlobalShift(w);
		RecalcRegions(w);
		ResizeSliders(w);
		RedrawAllDirect(w);
#ifdef DEBUG
	printf("XmItemBox: SetCell sucsefull\n");
#endif
	}
	return;
}

void XmNlItBoxSort(Widget w, int start, int lenght, int (*comparer)(const void *, const void *))
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	XmNlItBoxInfo * data, * current_cell;
//	Boolean * tmp_current;
	int i;
	
		
	if (it->itbox.num_items == 0 || it->itbox.item_data == NULL) 
		return ;
	if (start >= it->itbox.num_items || (start + lenght) > it->itbox.num_items)
		return ;
	
	if (it->itbox.current_item >= 0 && it->itbox.current_item < it->itbox.num_items)
	{
		current_cell = it->itbox.item_data[it->itbox.current_item];
	}
	
	
	qsort(it->itbox.item_data + start, lenght, sizeof(XmNlItBoxInfo *), comparer);

	for (i = 0; i < it->itbox.num_items; i++)
	{
		data = it->itbox.item_data[i];
		
		if (data == current_cell)
			it->itbox.current_item = i;
	}

	if (XtIsRealized(w))
	{
		RedrawAllDirect(w);
//		if (SelectionChanged && it->itbox.select_notify)
//			HighlightDoCallback(w, XmNlCR_ADD_SELECT, NULL);
	}
}

Boolean XmNlItBoxGetItemAtPointer(Widget w, XmNlCell *item, unsigned char valuemask, const void * pointer)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	XmNlItBoxInfo * data;

	if (it->itbox.num_items==0 || it->itbox.item_data==NULL) 
		return False;

	data = *((XmNlItBoxInfo **) pointer);

	if (valuemask & CellCharString) item->text = data->name;
	if (valuemask & CellXmString)
	{
		if (data->xmlabel)
			item->xmlabel = XmStringCopy(data->xmlabel);
	}

	if (valuemask & CellSelection)
	{
		item->selected = data->selected;
	}

	if (valuemask & CellAlignment) item->alignment = data->alignment;

	if (valuemask & CellUserData) item->UserDataPointer = data->UserDataPointer;

	return True;
}




Boolean XmNlItBoxGetItem(Widget w, XmNlCell *item, unsigned char valuemask, int position)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	XmNlItBoxInfo * data;

	if (it->itbox.num_items==0 || it->itbox.item_data==NULL ||
		position >= it->itbox.num_items || position < 0) return False;

	data = it->itbox.item_data[position];

	if (valuemask & CellCharString) item->text = data->name;
	if (valuemask & CellXmString)
	{
		if (data->xmlabel)
			item->xmlabel = XmStringCopy(data->xmlabel);
	}

	if (valuemask & CellSelection)
	{
		item->selected = data->selected;
	}

	if (valuemask & CellAlignment) item->alignment = data->alignment;

	if (valuemask & CellUserData) item->UserDataPointer = data->UserDataPointer;

	return True;
}


/************************************************************
 *
 * Callbacks and Action Routines.
 *
 ************************************************************/




/************************************************************
 *
 * Internal routines.
 *
 ************************************************************/

int SetVerShift (Widget w, int newshift, Boolean change_select)
{
	int limit_up, limit_down, rw, last_pix_shift;
	int last_shift, delta;
	int b_row, e_row, i, n, n_lines;
	Boolean freshed=False;
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;

	if (newshift+it->itbox.viewHeight > it->itbox.full_height)
		newshift=it->itbox.full_height-it->itbox.viewHeight;
	if (newshift < 0) newshift=0;

	limit_up=newshift;
	limit_down=newshift+it->itbox.viewHeight;

	/* tmp hack */
	last_shift=it->itbox.global_shift;
	it->itbox.global_shift=newshift;


/**********************************************************************/
/*						Temp hack!								      */
/**********************************************************************/


    delta = newshift - last_shift;

	b_row=it->itbox.global_shift/it->itbox.cell_height;
	e_row=(it->itbox.global_shift+it->itbox.viewHeight)/it->itbox.cell_height;
	if (e_row * it->itbox.cell_height < it->itbox.global_shift + it->itbox.viewHeight)
		e_row++;
	if (b_row != it->itbox.TopVisibleRow || e_row != it->itbox.BotVisibleRow)
	{

		n=(e_row - b_row) * it->itbox.col_num;
		n_lines=e_row - b_row;

		it->itbox.TopVisibleRow=b_row;
		it->itbox.BotVisibleRow=e_row;

		it->itbox.firstVisibleItem = b_row * it->itbox.col_num;
		it->itbox.firstVisibleY = b_row * it->itbox.cell_height - it->itbox.global_shift;

		it->itbox.VisibleCount=n;

		it->itbox.firstViewItem = it->itbox.firstVisibleItem;
		it->itbox.lastViewItem = it->itbox.firstViewItem + n_lines * it->itbox.col_num;

	}
	else
	{
		it->itbox.firstVisibleY = b_row * it->itbox.cell_height - it->itbox.global_shift;
	}

    if (it->itbox.VisibilityState == VisibilityUnobscured)
	{
//	RecalcRegions(w);
	if (delta < 0)
		{
		XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), it->itbox.normalGC,
			0, 0, it->itbox.viewWidth, it->itbox.viewHeight + delta,
			0, 0-delta);
		XClearArea(XtDisplay(w), XtWindow(w), 0, 0, it->itbox.viewWidth, 0-delta, FALSE);
		RedrawRegion(w, 0, 0, (int) it->itbox.viewWidth, 0-delta, -1);
		}
	if (delta > 0)
		{
		XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), it->itbox.normalGC,
			0, 0+delta, it->itbox.viewWidth, it->itbox.viewHeight - delta,
			0, 0);
		XClearArea(XtDisplay(w), XtWindow(w), 0, it->itbox.viewHeight - delta, it->itbox.viewWidth, delta, FALSE);
		RedrawRegion(w, 0, (int) it->itbox.viewHeight - delta, it->itbox.viewWidth, delta, 1);
		}
	}
    else
	{
//	RecalcRegions(w);
	RedrawAllDirect(w);
	}
//}
	return 0;
}


static void
VScrollCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) client_data;
    XmScrollBarCallbackStruct * scroll_info;
    int newshift;

	printf("\n Vscrolled\n ");
    scroll_info = (XmScrollBarCallbackStruct *) call_data;

    newshift = (int) scroll_info->value;
    SetVerShift ((Widget) it, newshift, False);
//    RecalcRegions((Widget) it);
//    RedrawAllDirect((Widget) it);
//#ifdef DEBUG
	printf("\n Vscrolled\n ");
//#endif
}

static void
HScrollCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
    XmScrollBarCallbackStruct * scroll_info;

    scroll_info = (XmScrollBarCallbackStruct *) call_data;

//    VScroll((Widget) ilist, (short) (scroll_info->value -
//				     XmI18List_first_row(ilist)));
}

/*	Function Name: ResizeSliders
 *	Description:   Resizes the thumbs of the v and h scrollbars.
 *	Arguments:     w - the ilist widget.
 *	Returns:       none
 *
 */

static void
ResizeSliders(Widget w)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
    Arg args[5];
    Cardinal num_args=0;
    register int i, height, max_width, rows_per_screen;
    register int slide_pos, slide_size, col_width=0, min=0;
    Widget scroll;
    scroll = it->itbox.v_bar;
    if (scroll != NULL)
    {
		if (it->itbox.full_height > it->itbox.viewHeight)
		XtVaSetValues(scroll, XmNmaximum, it->itbox.full_height,
		XmNsliderSize, it->itbox.viewHeight, XmNvalue, it->itbox.global_shift, NULL);
		else
//		XtVaSetValues(scroll, XmNmaximum, it->itbox.full_height,
//		XmNsliderSize, it->itbox.full_height, XmNvalue, it->itbox.global_shift, NULL);

		XtVaSetValues(scroll, XmNmaximum, 1,
		XmNsliderSize, 1, XmNvalue, it->itbox.global_shift, NULL);

#ifdef DEBUG
		printf("\n !! maximum1=%d \n !! sliderSize1=%d !! value=%d\n",
				it->itbox.full_height, it->itbox.viewHeight, it->itbox.global_shift);
#endif
    }

}

/* Return number of clicked item */

static int ClickInItem(unsigned long x, unsigned long y, Widget w)
{
	int res, cur_row, cur_col, y_in_cell, x_in_cell, tmp_w;
	unsigned long global_y;
	int xx1, xx2, yy1, yy2, cell_x, cell_y;
	int string_h;
	String tmp_str;
	XmNlItBoxInfo * data;
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
    unsigned char align;
    Boolean InIcon, InLabel, horiz, vert;
	int spc = it->itbox.margin_w+it->itbox.select_line_w+it->itbox.select_line_margin+it->itbox.text_spacing;
//		x=x-it->primitive.highlight_thickness-it->primitive.shadow_thickness;
//		y=y-it->primitive.highlight_thickness-it->primitive.shadow_thickness;

	global_y=y+it->itbox.global_shift;
	cur_row=global_y/it->itbox.cell_height;
	y_in_cell=global_y-cur_row*it->itbox.cell_height;
	if (it->itbox.render_order == LtoR_render)
	{
		cur_col = x/it->itbox.cell_width;
		if (cur_col >= it->itbox.col_num) return -1;
		x_in_cell = x - cur_col * it->itbox.cell_width;
		res = it->itbox.col_num * cur_row + cur_col;
		if (res >= it->itbox.num_items) return -1;
		cell_y = cur_row * it->itbox.cell_height - it->itbox.global_shift;
		cell_x = cur_col * it->itbox.cell_width;
	}
	else
	{
		cur_col = (it->itbox.viewWidth - x) / it->itbox.cell_width;
		if (cur_col >= it->itbox.col_num) return -1;
		x_in_cell = x - (it->itbox.viewWidth - it->itbox.cell_width - cur_col * it->itbox.cell_width);
		res = it->itbox.col_num * cur_row + cur_col;
		if (res >= it->itbox.num_items) return -1;
		cell_y = cur_row * it->itbox.cell_height - it->itbox.global_shift;
		cell_x = it->itbox.viewWidth - it->itbox.cell_width - cur_col * it->itbox.cell_width;
	}

	data = it->itbox.item_data[res];

	if (data->alignment == XmALIGNMENT_UNSPECIFIED)
		align = it->itbox.alignment;
	else
		align = data->alignment;



	InIcon = False;
	InLabel = False;

	GetIconXY(w, data, cell_x, cell_y, &xx1, &yy1, &xx2, &yy2);

	horiz = TRUE;
	vert = TRUE;
	if ((x < xx1) || (x > xx2)) horiz = FALSE;
	if ((y < yy1) || (y > yy2)) vert = FALSE;
	if (horiz==True && vert==True)
					InIcon = True;

	GetTextXY(w, data, cell_x, cell_y, &xx1, &yy1, &xx2, &yy2);

	horiz = TRUE;
	vert = TRUE;
	if ((x < xx1) || (x > xx2)) horiz = FALSE;
	if ((y < yy1) || (y > yy2)) vert = FALSE;
	if (horiz==True && vert==True)
				InLabel = True;


	if ( InIcon || InLabel)
		return res;
	else
		return -1;


		return res;

}

int XmNlItBoxXYtoPos(Widget w, unsigned long x, unsigned long y)
{
	return ClickInItem(x, y, w);
}

void * XmNlItBoxGetUserDataFromPos(Widget w, int number)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	XmNlItBoxInfo * data;
	data = it->itbox.item_data[number];
	return data->UserDataPointer;

}

static void DeselctAll(Widget w)
{
	int i, x, y, row, col;
	XmNlItBoxInfo * data;
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	for (i=0; i < it->itbox.num_items; i++)
	{
		data = it->itbox.item_data[i];
		if (data->selected)
		{
			ChangeCellSelection(w, data, False);
			row = i/it->itbox.col_num;
			col = i - row*it->itbox.col_num;
			y = row * it->itbox.cell_height - it->itbox.global_shift;
			x = col * it->itbox.cell_width;
			if ((y + it->itbox.cell_height) > it->itbox.viewY && y < (it->itbox.viewY + it->itbox.viewHeight))
				RedrawItemDirect(w, i, 0);
		}
	}

}

static Boolean AdjustGlobalShift(Widget w)
{

	int limit_up, limit_down, rw, newshift;
	Boolean freshed=False;
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;

	newshift=it->itbox.global_shift;
	if (it->itbox.num_items==0) return freshed;
/***************************************************************/
/* Проверяется только следующее событие :                      */
/*- размер видимой области увеличился;                         */
/*- сдвиг должен быть уменьшен (прежде                         */
/* чем это событие произошло, список был смещен вниз до конца).*/
/* Only the following event is checked:                        */
/*- the size of visible area increased;                        */
/*- shift shall be reduced (before this event                  */
/* the list was shifted down to the end).                      */
/***************************************************************/

	if (newshift+it->itbox.viewHeight > it->itbox.full_height)
		{
			newshift=it->itbox.full_height-it->itbox.viewHeight;
			if (newshift > 0)
			{
				it->itbox.DownShift = True;
				it->itbox.DeltaShift = it->itbox.DeltaShift + (it->itbox.global_shift - newshift);
			}
		}
//	else
//		if (newshift >= 0) return freshed;
	if (newshift < 0)
		{
		newshift=0;
//		freshed=True;
		}
		if (it->itbox.global_shift!=newshift) freshed=True;
	it->itbox.global_shift=newshift;

#ifdef DEBUG
	printf("global_shift=%d\n", it->itbox.global_shift);
#endif
/*	it->itbox.firstViewItem = (it->itbox.global_shift/it->itbox.cell_height) * it->itbox.col_num;
	it->itbox.lastViewItem = it->itbox.firstViewItem + (it->itbox.viewHeight/it->itbox.cell_height + 1) * it->itbox.col_num;
*/
	return freshed;
}

static void CorrectGlobalShift(Widget w)
{
	int newshift;
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;

	newshift = it->itbox.global_shift;
	if (it->itbox.num_items == 0) return ;

	if (newshift + it->itbox.viewHeight > it->itbox.full_height)
	{
		newshift = it->itbox.full_height - it->itbox.viewHeight;
		if (newshift < 0)
			newshift = 0;
	}

	it->itbox.global_shift = newshift;

	return ;
}


static void ButtonDownAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    static Position x, y;
    int res, x1, y1, num, multi_click_time;
    XButtonEvent * bevent = (XButtonEvent *) event;
    XmNlItBoxInfo * data;
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	Time click_time;

	if (!it->itbox.HasFocus)
	{
//    XtCallActionProc(w, "PrimitiveFocusIn", event, params, *num_params);
//	_XmPrimitiveFocusIn(w, event, NULL, 0);
//	_XmWidgetFocusChange(w, XmFOCUS_IN);
		XmProcessTraversal(w, XmTRAVERSE_CURRENT);
		it->itbox.HasFocus = True;
	}
	
	if (!it->itbox.item_data || it->itbox.num_items == 0)
	{
		it->itbox.current_item = -1;
		return ;
	}

	x = bevent->x - it->itbox.viewX;
	y = bevent->y - it->itbox.viewY;
	if (x<0 || y<0) return;

	click_time = event->xbutton.time;
	res = ClickInItem((unsigned long) x, (unsigned long) y, w);

	if (it->itbox.current_item >= 0 && res >= 0 && it->itbox.current_item != res && res < it->itbox.num_items)
	{
		num = it->itbox.current_item;
		PosToXY(it, num, &x1, &y1);
		it->itbox.current_item=res;
		HighLightItem(w, it->itbox.item_data[num], x1, y1);
	}

		//it->itbox.sm_m_select=1;
	it->itbox.b_col=0;
	it->itbox.e_col=0;
	it->itbox.b_row=0;
	it->itbox.e_row=0;

	it->itbox.select_start_point_x=x;
	it->itbox.select_start_point_y=y+it->itbox.global_shift;

	it->itbox.select_end_point_x=x;
	it->itbox.select_end_point_y=y+it->itbox.global_shift;


	multi_click_time = XtGetMultiClickTime(XtDisplay(w));
	if (it->itbox.last_click_item == res && res >= 0)
	{
		if (click_time - it->itbox.last_click_time < multi_click_time)
			it->itbox.DblClicked = True;
        else
            it->itbox.last_click_time = click_time;
	}
	else
	{
		it->itbox.last_click_item = res;
		it->itbox.last_click_time = click_time;
	}

	DeselctAll(w);
	if (res != -1)
	{
		ChangeCellSelection(w, it->itbox.item_data[res], True);
	}

	it->itbox.clicked_item = res;
	if (res != -1)
	{
		RedrawItemDirect(w, res, 0);
	}
	if (SelectChanged(it))
	{
//		RedrawAllDirect(w);
		HighlightDoCallback(w, XmNlCR_SINGLE_SELECT, event);
	}
	return;
}


static void SelectExtendedAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    static Position x, y;
    int res, x1, y1, num;
    XButtonEvent * bevent = (XButtonEvent *) event;
    XmNlItBoxInfo * data;
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
    Boolean SelectWithCtrl = False;
	Time tm;

	if (!it->itbox.HasFocus)
	{
//    XtCallActionProc(w, "PrimitiveFocusIn", event, params, *num_params);
//	_XmPrimitiveFocusIn(w, event, NULL, 0);
//	_XmWidgetFocusChange(w, XmFOCUS_IN);
		XmProcessTraversal(w, XmTRAVERSE_CURRENT);
		it->itbox.HasFocus = True;
	}

//    if (*num_params > 1) return;

	x = bevent->x - it->itbox.viewX;
	y = bevent->y - it->itbox.viewY;
	if (x<0 || y<0) return;

	res = ClickInItem((unsigned long) x, (unsigned long) y, w);

	if (res < 0) return ;
	if (it->itbox.current_item >= 0 && it->itbox.current_item != res)
	{
		num = it->itbox.current_item;
		PosToXY(it, num, &x1, &y1);
		it->itbox.current_item = res;
		HighLightItem(w, it->itbox.item_data[num], x1, y1);
	}
		//it->itbox.sm_m_select=1;
/*	it->itbox.b_col=0;
	it->itbox.e_col=0;
	it->itbox.b_row=0;
	it->itbox.e_row=0;

		it->itbox.select_start_point_x=x;
		it->itbox.select_start_point_y=y+it->itbox.global_shift;

		it->itbox.select_end_point_x=x;
		it->itbox.select_end_point_y=y+it->itbox.global_shift;*/

/*		it->itbox.m_x1=x;
		it->itbox.m_x2=x;
		it->itbox.m_y1=y+it->itbox.global_shift;
		it->itbox.m_y2=y+it->itbox.global_shift;
		it->itbox.m_last_x1=x;
		it->itbox.m_last_x2=x;
		it->itbox.m_last_y1=it->itbox.m_y1+it->itbox.global_shift;
		it->itbox.m_last_y2=it->itbox.m_y2+it->itbox.global_shift;
		it->itbox.m_cur_x=x;
		it->itbox.m_cur_y=y;
		it->itbox.m_b_x=x;
		it->itbox.m_b_y=y+it->itbox.global_shift;*/


	ChangeCellSelection(w, it->itbox.item_data[res], True); /*data[res].selected=True;*/

	RedrawItemDirect(w, res, 0);
	if (SelectChanged(it))
	{
		HighlightDoCallback(w, XmNlCR_EXTENDED_SELECT, event);
	}
	return;
}

static void ButtonUpAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XButtonEvent * bevent = (XButtonEvent *) event;
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
    Position x, y;
    int res, multi_click_time;
	Time click_time;

	if (bevent->button != 1)
		return;

	if (it->itbox.m_select==1)
	{
		it->itbox.b_col=0;
		it->itbox.e_col=0;
		it->itbox.b_row=0;
		it->itbox.e_row=0;
		it->itbox.m_select=0;

		it->itbox.select_start_point_x=0;
		it->itbox.select_start_point_y=0;

		it->itbox.select_end_point_x=0;
		it->itbox.select_end_point_y=0;

/*		it->itbox.m_x1=0;
		it->itbox.m_x2=0;
		it->itbox.m_y1=0;
		it->itbox.m_y2=0;
		it->itbox.m_last_x1=0;
		it->itbox.m_last_x2=0;
		it->itbox.m_last_y1=0;
		it->itbox.m_last_y2=0;
		it->itbox.m_cur_x=0;
		it->itbox.m_cur_y=0;*/
		RedrawAllDirect(w);
		HighlightDoCallback(w, XmNlCR_COMPLETED_SELECT, event);
	}

	if (it->itbox.motion_timer_found) 
	{
		XtRemoveTimeOut(it->itbox.motion_timer);
		it->itbox.motion_timer_found = 0;
	}
		it->itbox.auto_scroll = 0;

	if (it->itbox.DblClicked == True)
	{
		multi_click_time = XtGetMultiClickTime(XtDisplay(w));
		it->itbox.DblClicked = False;
		x = bevent->x;
		y = bevent->y;
		click_time = event->xbutton.time;
		res = ClickInItem((unsigned long)x, (unsigned long)y, w);
//			DoubleClickDoCallback(w, res);
		if (res == it->itbox.last_click_item && res >= 0 /*&&
				click_time - it->itbox.last_click_time < multi_click_time*/)
			DoubleClickDoCallback(w, res);
		it->itbox.last_click_time = 0;
		it->itbox.last_click_item = -1;
	}
	return;
}

static void MotionAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int res, n;
	int xx1, yy1, xx2, yy2;
	static Position x, y, tmp_x, tmp_y;
	XMotionEvent *bevent=(XMotionEvent *)event;

    int line_style;
    unsigned int line_width = 1;
    int cap_style = CapRound;
    int join_style = JoinRound;
    int delta;



	x=bevent->x;
	y=bevent->y;
//		x=x-it->primitive.highlight_thickness-it->primitive.shadow_thickness;
//		y=y-it->primitive.highlight_thickness-it->primitive.shadow_thickness;
		x=x-it->itbox.viewX;
		y=y-it->itbox.viewY;

    if (*num_params > 1) return;

//return;
	it->itbox.m_cur_x=x;
	it->itbox.m_cur_y=y;

#ifdef MOTION_DEBUG
		printf("\n Motion action: autoscroll= %d\n", it->itbox.auto_scroll);
#endif


	if (it->itbox.m_select==1 && (it->itbox.select_start_point_x != it->itbox.select_end_point_x ||
					it->itbox.select_start_point_y != it->itbox.select_end_point_y) )
	{
/* Selection in action & selected item not changed */
/* Nedd to erase last selection box                */
		XSetClipMask(bevent->display, it->itbox.eorGC, None);

		XSetFunction(bevent->display, it->itbox.normalGC, GXinvert);
		tmp_x=it->itbox.viewX;
		tmp_y=it->itbox.viewY;

        xx1=it->itbox.select_start_point_x+tmp_x;
	    xx2=it->itbox.select_end_point_x+tmp_x;

	    yy1=it->itbox.select_start_point_y-it->itbox.global_shift+tmp_y;
	    if (yy1 < 0) yy1=-1;
	    if (yy1 > (it->itbox.viewHeight+tmp_y)) yy1=it->itbox.viewHeight+1;

	    yy2=it->itbox.select_end_point_y-it->itbox.global_shift+tmp_y;

	    if (yy2 < 0) yy2=-1;
	    if (yy2 > (it->itbox.viewHeight+tmp_y)) yy2=it->itbox.viewHeight+1;


		if ( yy1 >= 0 || yy1 <= (it->itbox.viewHeight+tmp_y)) XDrawLine(bevent->display, bevent->window, it->itbox.eorGC,
                      xx1, yy1, xx2, yy1);
		XDrawLine(bevent->display, bevent->window, it->itbox.eorGC,
                      xx1, yy1, xx1, yy2);
		if (yy2 >= 0 || yy2 <= (it->itbox.viewHeight+tmp_y)) XDrawLine(bevent->display, bevent->window, it->itbox.eorGC,
                      xx1, yy2, xx2, yy2);
		XDrawLine(bevent->display, bevent->window, it->itbox.eorGC,
                      xx2, yy1, xx2, yy2);
		XSetFunction(bevent->display, it->itbox.normalGC, GXcopy);
	}

/* Save last selection frame */

	it->itbox.last_select_end_point_x=it->itbox.select_end_point_x;
	it->itbox.last_select_end_point_y=it->itbox.select_end_point_y;

	it->itbox.select_end_point_x=x;
	it->itbox.select_end_point_y=y+it->itbox.global_shift;


/*	it->itbox.m_last_x1=it->itbox.m_x1;
	it->itbox.m_last_x2=it->itbox.m_x2;
	it->itbox.m_last_y1=it->itbox.m_y1;
	it->itbox.m_last_y2=it->itbox.m_y2;

		if (it->itbox.m_cur_x>=it->itbox.m_b_x)
		{
			it->itbox.m_x2=it->itbox.m_cur_x;
		}
			else
			{
				it->itbox.m_x2=it->itbox.m_b_x;
				it->itbox.m_x1=it->itbox.m_cur_x;
			}

		if (it->itbox.m_cur_y+it->itbox.global_shift>=it->itbox.m_b_y)
		{
			it->itbox.m_y2=it->itbox.m_cur_y+it->itbox.global_shift;
			it->itbox.m_y1=it->itbox.m_b_y;
		}
		else
		{
			it->itbox.m_y2=it->itbox.m_b_y;
			it->itbox.m_y1=it->itbox.m_cur_y+it->itbox.global_shift;
			if (it->itbox.m_y1<0) it->itbox.m_y1=0;
		}
*/

//printf("\n gy1=%d", sm_m_global_y1);
//printf("\n gy2=%d\n", sm_m_global_y2);
//  line_style = LineOnOffDash;

             /* set line attributes */

//             XSetLineAttributes(bevent->display, it->itbox.normalGC, line_width,
//                                line_style, cap_style, join_style);

//             gcv.foreground = WhitePixelOfScreen(XtScreen(w));
//             XSetForeground(event->display, gc, gcv.foreground);
 	XSetForeground(bevent->display, it->itbox.normalGC, it->itbox.foreground_pixel);
	res = ReBoundSelect(w);
//	res=BoundSelect(w);
	if (it->itbox.SelectedPositionsCount > 0 && it->itbox.current_item != it->itbox.SelectedPositions[0])
	{
		n = it->itbox.current_item;
		it->itbox.current_item = it->itbox.SelectedPositions[0];
		PosToXY(it, n, &xx1, &yy1);
		HighLightItem(w, it->itbox.item_data[n], xx1, yy1);
		PosToXY(it, it->itbox.SelectedPositions[0], &xx1, &yy1);
		HighLightItem(w, it->itbox.item_data[it->itbox.SelectedPositions[0]], xx1, yy1);
	}
//if (it->itbox.m_select==1 /*&& res==0*/)
//{
/* Selection in action & selected item not changed */
/* Nedd to erase last selection box                */

//	XSetFunction(bevent->display, it->itbox.normalGC, GXinvert);
//	printf("\nMotion x=%d y=%d\n", bevent->x, bevent->y);
//		tmp_x=it->primitive.highlight_thickness+it->primitive.shadow_thickness;
//		tmp_y=it->primitive.highlight_thickness+it->primitive.shadow_thickness;
/*		tmp_x=it->itbox.viewX;
		tmp_y=it->itbox.viewY;

            xx1=it->itbox.m_last_x1+tmp_x;
	    xx2=it->itbox.m_last_x2+tmp_x;
	    yy1=it->itbox.m_last_y1-it->itbox.global_shift+tmp_y;
	    if (yy1<0) yy1=0;
	    yy2=it->itbox.m_last_y2-it->itbox.global_shift+tmp_y;
	    if (yy2>(it->itbox.viewHeight+tmp_y)) yy2=it->itbox.viewHeight+tmp_y;


            if (it->itbox.m_last_y1-it->itbox.global_shift >= 0) XDrawLine(bevent->display, bevent->window, it->itbox.normalGC,
                      xx1, yy1, xx2, yy1);
            XDrawLine(bevent->display, bevent->window, it->itbox.normalGC,
                      xx1, yy1, xx1, yy2);
            if (it->itbox.m_last_y2-it->itbox.global_shift < it->itbox.viewHeight) XDrawLine(bevent->display, bevent->window, it->itbox.normalGC,
                      xx1, yy2, xx2, yy2);
            XDrawLine(bevent->display, bevent->window, it->itbox.normalGC,
                      xx2, yy1, xx2, yy2);
	XSetFunction(bevent->display, it->itbox.normalGC, GXcopy);
}*/
	if (res!=0)
	{
		HighlightDoCallback(w, XmNlCR_MULTPLE_SELECT, event);
	}
            /* Draw New Box */
    XSetFunction(bevent->display, it->itbox.normalGC, GXinvert);
//			XSetFunction(bevent->display, it->itbox.normalGC, GXcopy);





/*            xx1=it->itbox.m_x1+tmp_x;
	    xx2=it->itbox.m_x2+tmp_x;
	    yy1=it->itbox.m_y1-it->itbox.global_shift+tmp_y;
	    if (yy1<0) yy1=0;
	    yy2=it->itbox.m_y2-it->itbox.global_shift+tmp_y;
	    if (yy2>it->itbox.viewHeight) yy2=it->itbox.viewHeight;


            if (it->itbox.m_y1-it->itbox.global_shift >= 0) XDrawLine(bevent->display, bevent->window, it->itbox.normalGC,
                      xx1, yy1, xx2, yy1);
            XDrawLine(bevent->display, bevent->window, it->itbox.normalGC,
                      xx1, yy1, xx1, yy2);
            if (it->itbox.m_y2-it->itbox.global_shift < it->itbox.viewHeight) XDrawLine(bevent->display, bevent->window, it->itbox.normalGC,
                      xx1, yy2, xx2, yy2);
            XDrawLine(bevent->display, bevent->window, it->itbox.normalGC,
                      xx2, yy1, xx2, yy2);
*/

		xx1=it->itbox.select_start_point_x+tmp_x;
	    xx2=it->itbox.select_end_point_x+tmp_x;

	    yy1=it->itbox.select_start_point_y-it->itbox.global_shift+tmp_y;
	    if (yy1 < 0) yy1=-1;
	    if (yy1 > (it->itbox.viewHeight+tmp_y)) yy1=it->itbox.viewHeight+1;

	    yy2=it->itbox.select_end_point_y-it->itbox.global_shift+tmp_y;

	    if (yy2 < 0) yy2=-1;
	    if (yy2 > (it->itbox.viewHeight+tmp_y)) yy2=it->itbox.viewHeight+1;


//            if ( yy1 >= 0 || yy1 <= (it->itbox.viewHeight+tmp_y)) XDrawLine(bevent->display, bevent->window, it->itbox.eorGC,
//                      xx1, yy1, xx2, yy1);
            if ( yy1 >= 0 || yy1 <= (it->itbox.viewHeight+tmp_y)) XDrawLine(bevent->display, XtWindow(w), it->itbox.eorGC,
                      xx1, yy1, xx2, yy1);
//            XDrawLine(bevent->display, bevent->window, it->itbox.eorGC,
//                      xx1, yy1, xx1, yy2);
            XDrawLine(bevent->display, XtWindow(w), it->itbox.eorGC,
                      xx1, yy1, xx1, yy2);
//            if (yy2 >= 0 || yy2 <= (it->itbox.viewHeight+tmp_y)) XDrawLine(bevent->display, bevent->window, it->itbox.eorGC,
//                      xx1, yy2, xx2, yy2);
            if (yy2 >= 0 || yy2 <= (it->itbox.viewHeight+tmp_y)) XDrawLine(bevent->display, XtWindow(w), it->itbox.eorGC,
                      xx1, yy2, xx2, yy2);
//            XDrawLine(bevent->display, bevent->window, it->itbox.eorGC,
//                      xx2, yy1, xx2, yy2);
            XDrawLine(bevent->display, XtWindow(w), it->itbox.eorGC,
                      xx2, yy1, xx2, yy2);

			XSetFunction(bevent->display, it->itbox.normalGC, GXcopy);

		it->itbox.m_select=1;



/* Down auto scrolling  ***************************************/

		if (y>it->itbox.viewHeight)
		{
#ifdef MOTION_DEBUG
		printf("\n Pointer out of widget\n");
#endif
		delta=y-it->itbox.viewHeight;
		it->itbox.delta_shift=8;
		if (delta < 10)
			{
			it->itbox.interval=100;
			it->itbox.delta_shift=8;
			}
		if (delta >= 10 && delta < 20)
			{
			it->itbox.interval=70;
			it->itbox.delta_shift=8;
			}
		if (delta >= 20 && delta < 30)
			{
			it->itbox.interval=40;
			it->itbox.delta_shift=8;
			}
		if (delta >= 30 && delta < 40)
			{
			it->itbox.interval=40;
			it->itbox.delta_shift=12;
			}
		if (delta >= 40 && delta < 50)
			{
			it->itbox.interval=40;
			it->itbox.delta_shift=18;
			}
		if (delta >= 50 && delta < 60)
			{
			it->itbox.interval=40;
			it->itbox.delta_shift=24;
			}
		if (delta >= 60)
			{
			it->itbox.interval=40;
			it->itbox.delta_shift=30;
			}
		if (it->itbox.auto_scroll==0)
			{
				it->itbox.motion_timer=XtAppAddTimeOut(XtWidgetToApplicationContext(w), 100, SelectDownScroll, w);
				it->itbox.auto_scroll=1;
				it->itbox.motion_timer_found = 1;
#ifdef MOTION_DEBUG
				printf("\n  Auto Scroll timeout added\n");
#endif
			}
		}




/* Up auto scrolling  ***************************************/

		if (y<0)
		{
		delta=abs(y);
		it->itbox.delta_shift=8;
		if (it->itbox.auto_scroll==0)
			{
				it->itbox.motion_timer=XtAppAddTimeOut(XtWidgetToApplicationContext(w), 100, SelectUpScroll, w);
				it->itbox.auto_scroll=1;
				it->itbox.motion_timer_found = 1;
#ifdef MOTION_DEBUG
		printf("\n  Auto Scroll timeout added\n");
#endif
			}
		if (delta < 10)
			{
			it->itbox.interval=100;
			it->itbox.delta_shift=8;
			}
		if (delta >= 10 && delta < 20)
			{
			it->itbox.interval=70;
			it->itbox.delta_shift=8;
			}
		if (delta >= 20 && delta < 30)
			{
			it->itbox.interval=40;
			it->itbox.delta_shift=8;
			}
		if (delta >= 30 && delta < 40)
			{
			it->itbox.interval=40;
			it->itbox.delta_shift=12;
			}
		if (delta >= 40 && delta < 50)
			{
			it->itbox.interval=40;
			it->itbox.delta_shift=18;
			}
		if (delta >= 50 && delta < 60)
			{
			it->itbox.interval=40;
			it->itbox.delta_shift=24;
			}
		if (delta >= 60)
			{
			it->itbox.interval=40;
			it->itbox.delta_shift=30;
			}

		}



/* Auto scrolling to OFF ***************************************/
		if (y<=it->itbox.viewHeight && y>=0)
		{
			it->itbox.auto_scroll=0;
			if (it->itbox.motion_timer_found)
			{
				XtRemoveTimeOut(it->itbox.motion_timer);
				it->itbox.motion_timer_found = 0;
			}

		}
}

static void ScrollAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XButtonEvent * bevent = (XButtonEvent *) event;
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
    int shift=it->itbox.global_shift;
    static Time last_time_up = 0, last_time_down = 0;
#ifdef DEBUG
    printf("\n  Scroll action\n");
#endif
    if (*num_params > 1) 
		return;

	if (it->itbox.num_items == 0) 
		return;


//    printf("\n  Scroll action\n");

	if (*num_params == 1) {
	    switch (params[0][0]) {
	    case 'u':
	    case 'U':
#ifdef DEBUG
			printf("\n  Scroll up\n");
#endif
//			shift=shift-SM_SCROLLING_SHIFT;
			if (bevent->time - last_time_up > 500)
				shift = shift - it->itbox.cell_height/2;
			else
				shift = shift - it->itbox.cell_height;
			
			last_time_up = bevent->time;
			
			SetVerShift(w, shift, False);
			ResizeSliders(w);
			break;

	    case 'd':
	    case 'D':
#ifdef DEBUG
			printf("\n  Scroll down\n");
#endif
//			shift=shift+SM_SCROLLING_SHIFT;
			if (bevent->time - last_time_down > 500)
				shift = shift + it->itbox.cell_height/2;
			else
				shift = shift + it->itbox.cell_height;
			
			last_time_down = bevent->time;
			SetVerShift (w, shift, False);
			ResizeSliders(w);
			break;

	    default:
	    {
			return;
		}
	    }
	}
}


static Boolean
SelectChanged(XmNlItemBoxWidget it)
{
	int i, j, counter;
	XmNlItBoxInfo * data;
	Boolean ret = FALSE;
	int * new_selected;

	counter = 0;

#ifdef DEBUG
	printf("\n SelectChanged called\n");
#endif

	for (i = 0, j = 0; i < it->itbox.num_items; i++)
	{
		data = it->itbox.item_data[i];
		if (data->selected == TRUE)
		{
			counter++;
			if (j < it->itbox.SelectedPositionsCount && it->itbox.SelectedPositions)
			{
				if (it->itbox.SelectedPositions[j] != i)
					ret = True;
			}
			j++;
		}
	}
#ifdef DEBUG
	printf("\nSelectChanged: Counter=%d\n", counter);
#endif
	if (ret || it->itbox.SelectedPositionsCount != counter)
	{
		ret = True;
		it->itbox.SelectedPositionsCount = counter;
		if (it->itbox.SelectedPositions)
		{
			XtFree((char *) it->itbox.SelectedPositions);
			it->itbox.SelectedPositions = NULL;
		}
		if (counter != 0)
		{
			it->itbox.SelectedPositions=(int *)XtMalloc(counter * sizeof(int));
			counter = 0;
			for (i=0; i<it->itbox.num_items; i++)
			{
				data=it->itbox.item_data[i];
				if (data->selected==TRUE)
				{
					it->itbox.SelectedPositions[counter]=i;
#ifdef DEBUG
					printf("\n SelectChanged: Item_number=%d\n", it->itbox.SelectedPositions[counter]);
#endif
					counter++;
				}
			}
		}
	}

#ifdef DEBUG_CALLBACK
	printf("\nSelectChanged result:\n ");
	for (i=0; i<it->itbox.SelectedPositionsCount; i++)
	{
		printf("\n Item_number=%d\t%d\n", i, it->itbox.SelectedPositions[i]);
	}
#endif

	return ret;
}

static void
MakeHighlightCallbackStruct(XmNlItemBoxWidget it, ListItemReturnStruct * ret, int reason, XEvent *event)
{
	int i, counter;
	XmNlItBoxInfo * data;

#ifdef DEBUG
	printf("\nMakeHighlightCallbackStruct: Counter=%d\n", it->itbox.SelectedPositionsCount);
#endif
	ret->count = it->itbox.SelectedPositionsCount;
	ret->reason = reason;
	ret->event = event;
	if (it->itbox.SelectedPositionsCount == 0) return;
	ret->number = (int *)XtRealloc((char *) ret->number, ret->count*sizeof(int));
	ret->pointers = (void *)XtRealloc((char *) ret->pointers, ret->count*sizeof(void *));
	counter=0;
	for (i=0; i<it->itbox.num_items; i++)
	{
		data = it->itbox.item_data[i];
		if (data->selected == True)
		{
			ret->number[counter] = i;
			ret->pointers[counter] = data->UserDataPointer;
#ifdef DEBUG
			printf("\nItem_number=%d\n", ret->number[counter]);
#endif
			counter++;
		}
	}
}

static void
DoubleClickDoCallback(Widget w, int number)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
    ItemActivateReturnStruct ret;
    XmNlItBoxInfo * data;
    data=it->itbox.item_data[number];

  if (it->itbox.double_click) {
    ret.item_number=number;
    ret.pointer=data->UserDataPointer;
    XtCallCallbacks(w, XmNdoubleClickCallback, (XtPointer) &ret);
  }
}

static void
HighlightDoCallback(Widget w, int reason, XEvent *event)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	static ListItemReturnStruct ret;
#ifdef DEBUG
	printf("\n HighlightDoCallback called\n");
#endif

	if (it->itbox.highlightCallback) {
		MakeHighlightCallbackStruct(it, &ret, reason, event);
		XtCallCallbacks(w, XtNhighlightCallback, (XtPointer) &ret);
#ifdef DEBUG
		printf("\n HighlightDoCallback: callbacks transfered\n");
#endif
	}

	if (ret.number)
	{
		XtFree((char *) ret.number);
		ret.number = NULL;
	}
    if (ret.pointers)
    {
		XtFree((char *) ret.pointers);
		ret.pointers = NULL;
	}
#ifdef DEBUG
	printf("\n HighlightDoCallback complet\n");
#endif
}

#define MARGIN_W it->itbox.margin_w
#define MARGIN_H it->itbox.margin_h
#define SEL_LINE it->itbox.select_line_w
#define SEL_MARGIN it->itbox.select_line_margin
#define TXT_SPC it->itbox.text_spacing


static int ReBoundSelect(Widget w)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int res, b_row, e_row, b_col, e_col;
	int col, row;
	unsigned char align;
	int i, j, k;
	int x1, x2, y1, y2;
	int xx, yy;
	int sm_new_select_massiv[1000];
	int rx1, rx2, ry1, ry2;			/* rectangle coordinates	*/
	Boolean icon_in_bound=False;
	Boolean label_in_bound=False;

	Boolean last_icon_in_bound=False;
	Boolean last_label_in_bound=False;

	Boolean last_item_selected;
	Boolean item_selected;

	Boolean horiz=False;
	Boolean vert=False;

	res=0;
	if (it->itbox.select_start_point_x <= it->itbox.select_end_point_x)
		{
		x1=it->itbox.select_start_point_x;
		x2=it->itbox.select_end_point_x;
		}
	else
		{
		x1=it->itbox.select_end_point_x;
		x2=it->itbox.select_start_point_x;
		}

	if (it->itbox.select_start_point_y <= it->itbox.select_end_point_y)
		{
		y1=it->itbox.select_start_point_y;
		y2=it->itbox.select_end_point_y;
		}
	else
		{
		y1=it->itbox.select_end_point_y;
		y2=it->itbox.select_start_point_y;
		}

	if (x1 < 0) x1 = 0;
	if (x2 > it->itbox.viewWidth) x2 = it->itbox.viewWidth;

	if (y1 < 0) y1 = 0;
	if (y2 > it->itbox.full_height) y2 = it->itbox.full_height;


	if (it->itbox.render_order == LtoR_render) b_col = x1/it->itbox.cell_width - 1;
	else b_col = (it->itbox.viewWidth - x1) / it->itbox.cell_width - 1;
	if (b_col < 0) b_col = 0;
	if (it->itbox.render_order == LtoR_render) e_col = x2/it->itbox.cell_width + 1;
	else e_col = (it->itbox.viewWidth - x2) / it->itbox.cell_width + 1;
	if (e_col >= it->itbox.col_num) e_col = it->itbox.col_num - 1;
	b_row = y1/it->itbox.cell_height - 1;
	e_row = y2/it->itbox.cell_height + 1;
	if (b_row < 0) b_row = 0;
	if (e_row >= it->itbox.row_num) e_row = it->itbox.row_num - 1;


	if (b_col > it->itbox.b_col) b_col = it->itbox.b_col;
	if (b_row > it->itbox.b_row) b_row = it->itbox.b_row;
	if (e_col < it->itbox.e_col) e_col = it->itbox.e_col;
	if (e_row < it->itbox.e_row) e_row = it->itbox.e_row;



    for (row = b_row; row <= e_row; row++)
	{
		for (col = b_col; col <= e_col; col++)
		{
			k=row*it->itbox.col_num+col;
			if (k < it->itbox.num_items)
			{

				PosToXY(it, k, &xx, &yy);
				yy = (k/it->itbox.col_num) * it->itbox.cell_height;

				/* check for icon region */
				GetIconXY(w, it->itbox.item_data[k], xx, yy, &rx1, &ry1, &rx2, &ry2);
				horiz=TRUE;
				vert=TRUE;


				icon_in_bound=False;

				if ((x2 < rx1) || (x1 > rx2)) horiz = FALSE;
				if ((y2 < ry1) || (y1 > ry2)) vert = FALSE;
				if (horiz==True && vert==True)
					icon_in_bound=True;

				/* check for label region	*/

				GetTextXY(w, it->itbox.item_data[k], xx, yy, &rx1, &ry1, &rx2, &ry2);
				horiz=TRUE;
				vert=TRUE;
				label_in_bound=False;
				if ((x2 < rx1) || (x1 > rx2)) horiz = FALSE;
				if ((y2 < ry1) || (y1 > ry2)) vert = FALSE;

				if (horiz==True && vert==True)
					label_in_bound=True;

				/* check for last label region	*/

				if (it->itbox.item_data[k]->selected==True && icon_in_bound==False && label_in_bound==False)
				{
					ChangeCellSelection(w, it->itbox.item_data[k], False);

					if (k >= it->itbox.firstViewItem && k <= it->itbox.lastViewItem)
					{
						XClearArea(XtDisplay(w), XtWindow(w), xx, yy - it->itbox.global_shift, it->itbox.cell_width, it->itbox.cell_height, False);
						DrawItem(w, it->itbox.item_data[k], xx, yy - it->itbox.global_shift, k, 0);
					}
					continue ;
				}
//				else
//				{

					if (it->itbox.item_data[k]->selected==False && (icon_in_bound==True || label_in_bound==True))
					{
						ChangeCellSelection(w, it->itbox.item_data[k], True);
/*						data[k].selected=True;
						if (it->itbox.buffering && data[k].buftext)
						{
							XFreePixmap(XtDisplay(w), data[k].buftext);
							data[k].buftext = NULL;
						}*/
						if (k >= it->itbox.firstViewItem && k <= it->itbox.lastViewItem)
						{
							XClearArea(XtDisplay(w), XtWindow(w), xx, yy - it->itbox.global_shift, it->itbox.cell_width, it->itbox.cell_height, False);
							DrawItem(w, it->itbox.item_data[k], xx, yy - it->itbox.global_shift, k, 0);
						}
					}
//				}
			}
		}
	}

	if (it->itbox.render_order == LtoR_render) b_col = x1/it->itbox.cell_width - 1;
	else b_col = (it->itbox.viewWidth - x1) / it->itbox.cell_width - 1;
	if (b_col < 0) b_col = 0;
	if (it->itbox.render_order == LtoR_render) e_col = x2/it->itbox.cell_width + 1;
	else e_col = (it->itbox.viewWidth - x2) / it->itbox.cell_width + 1;
	if (e_col >= it->itbox.col_num) e_col = it->itbox.col_num - 1;
	b_row = y1/it->itbox.cell_height - 1;
	e_row = y2/it->itbox.cell_height + 1;
	if (b_row < 0) b_row = 0;
	if (e_row >= it->itbox.row_num) e_row = it->itbox.row_num - 1;


	it->itbox.b_col = b_col;
	it->itbox.b_row = b_row;
	it->itbox.e_col = e_col;
	it->itbox.e_row = e_row;

	if (SelectChanged(it)==True) res=1;

	return res;

}




#undef MARGIN_W
#undef MARGIN_H
#undef SEL_LINE
#undef SEL_MARGIN
#undef TXT_SPC



static void SelectUpScroll(XtPointer client_data, XtIntervalId *timer)
{
	int res, rw;
	int xx1, yy1, xx2, yy2;
	int cur_y, delta, new_shift;
	int tmp_y, tmp_x;
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) client_data;
	Widget w = (Widget) client_data;
    XmNlItBoxInfo * data;

	it->itbox.motion_timer_found = 0;

	tmp_x=it->itbox.viewX;
	tmp_y=it->itbox.viewY;

	xx1=it->itbox.select_start_point_x+tmp_x;
	xx2=it->itbox.select_end_point_x+tmp_x;
	yy1=it->itbox.select_start_point_y-it->itbox.global_shift+tmp_y;
	if (yy1 < 0) yy1=-1;
	if (yy1 > (it->itbox.viewHeight+tmp_y)) yy1=it->itbox.viewHeight+1;

	yy2=it->itbox.select_end_point_y-it->itbox.global_shift+tmp_y;

	if (yy2 < 0) yy2=-1;
	if (yy2 > (it->itbox.viewHeight+tmp_y)) yy2=it->itbox.viewHeight+1;


    if ( yy1 >= 0 || yy1 <= (it->itbox.viewHeight+tmp_y)) XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx1, yy1, xx2, yy1);
            XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx1, yy1, xx1, yy2);
    if (yy2 >= 0 || yy2 <= (it->itbox.viewHeight+tmp_y)) XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx1, yy2, xx2, yy2);
            XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx2, yy1, xx2, yy2);





/*	it->itbox.global_shift=it->itbox.global_shift-it->itbox.delta_shift;
	if (it->itbox.global_shift < 0)
		{
		delta=it->itbox.delta_shift - (0 - it->itbox.global_shift);
		it->itbox.global_shift=0;
		}
	else delta =it->itbox.delta_shift;

 	it->itbox.select_end_point_y=it->itbox.select_end_point_y-delta;*/


	new_shift=it->itbox.global_shift-it->itbox.delta_shift;
	if (new_shift < 0)
		{
		delta=it->itbox.delta_shift - (0 - new_shift);
		new_shift=0;
		}
	else delta =it->itbox.delta_shift;

 	it->itbox.select_end_point_y=it->itbox.select_end_point_y-delta;


#ifdef DEBUG
	printf("Autoscroll Y=%d\n", it->itbox.select_end_point_y);
#endif

/*	cur_y=it->itbox.m_cur_y-it->itbox.delta_shift+it->itbox.global_shift;
	if (cur_y < 0) cur_y=0;


		if (cur_y>=it->itbox.m_b_y)
		{
			it->itbox.m_y2=cur_y;
			it->itbox.m_y1=it->itbox.m_b_y;
		}
		else
		{
			it->itbox.m_y2=it->itbox.m_b_y;
			it->itbox.m_y1=cur_y;
			if (it->itbox.m_y1<0) it->itbox.m_y1=0;
		}
*/

//	res=BoundSelect(w);
	res=ReBoundSelect(w);
	if (res==1) HighlightDoCallback(w, XmNlCR_MULTPLE_SELECT, NULL);


//	if (it->itbox.global_shift+it->itbox.viewHeight > it->itbox.full_height) it->itbox.global_shift=it->itbox.full_height-it->itbox.viewHeight;
	SetVerShift(w, new_shift, FALSE);
	XtVaSetValues(it->itbox.v_bar, XmNvalue, it->itbox.global_shift, NULL);
/*	if (it->itbox.buffering)
	{
		PutToPixLarge(w);
	it->itbox.shift_in_pix=it->itbox.global_shift-it->itbox.pix_shift;
 	XCopyArea(XtDisplay(w), it->itbox.pix, XtWindow(w), it->itbox.normalGC,
		0, it->itbox.shift_in_pix, it->itbox.viewWidth, it->itbox.viewHeight,
		it->itbox.viewX,
		it->itbox.viewY);
	}*/
//	RecalcRegions(w);
//	RedrawAllDirect(w);
/* 	XCopyArea(XtDisplay(w), it->itbox.pix, XtWindow(w), it->itbox.normalGC,
		0, it->itbox.shift_in_pix, it->itbox.viewWidth, it->itbox.viewHeight,
		it->primitive.highlight_thickness+it->primitive.shadow_thickness,
		it->primitive.highlight_thickness+it->primitive.shadow_thickness);*/


             XSetFunction(XtDisplay(w), it->itbox.normalGC, GXinvert);
//			XSetFunction(display, sm_gc, GXcopy);


		tmp_x=it->itbox.viewX;
		tmp_y=it->itbox.viewY;

            xx1=it->itbox.select_start_point_x+tmp_x;
	    xx2=it->itbox.select_end_point_x+tmp_x;
	    yy1=it->itbox.select_start_point_y-it->itbox.global_shift+tmp_y;
	    if (yy1 < 0) yy1=-1;
	    if (yy1 > (it->itbox.viewHeight+tmp_y)) yy1=it->itbox.viewHeight+1;

	    yy2=it->itbox.select_end_point_y-it->itbox.global_shift+tmp_y;

	    if (yy2 < 0) yy2=-1;
	    if (yy2 > (it->itbox.viewHeight+tmp_y)) yy2=it->itbox.viewHeight+1;


            if ( yy1 >= 0 || yy1 <= (it->itbox.viewHeight+tmp_y)) XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx1, yy1, xx2, yy1);
            XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx1, yy1, xx1, yy2);
            if (yy2 >= 0 || yy2 <= (it->itbox.viewHeight+tmp_y)) XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx1, yy2, xx2, yy2);
            XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx2, yy1, xx2, yy2);
#ifdef DEBUG
	printf("Autoselection y1=%d y2=%d\n", yy1, yy2);
#endif

/*


            xx1=it->itbox.m_x1;
	    xx2=it->itbox.m_x2;
	    yy1=it->itbox.m_y1-it->itbox.global_shift;
	    if (yy1<0) yy1=0;
	    yy2=it->itbox.m_y2-it->itbox.global_shift;
	    if (yy2>it->itbox.viewHeight) yy2=it->itbox.viewHeight;


            if (it->itbox.m_y1-it->itbox.global_shift >= 0) XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.normalGC,
                      xx1, yy1, xx2, yy1);
            XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.normalGC,
                      xx1, yy1, xx1, yy2);
            if (it->itbox.m_y2-it->itbox.global_shift < it->itbox.viewHeight) XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.normalGC,
                      xx1, yy2, xx2, yy2);
            XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.normalGC,
                      xx2, yy1, xx2, yy2);*/

			XSetFunction(XtDisplay(w), it->itbox.normalGC, GXcopy);
	if (it->itbox.global_shift > 0 && it->itbox.auto_scroll == 1)
	{
		it->itbox.motion_timer=XtAppAddTimeOut(XtWidgetToApplicationContext(w), it->itbox.interval, SelectUpScroll, it);
		it->itbox.motion_timer_found = 1;
	}


#ifdef DEBUG
		printf("\n Up AutoSelect Scroll\n");
#endif
}


static void SelectDownScroll(XtPointer client_data, XtIntervalId *timer)
{
	int res, rw;
	int xx1, yy1, xx2, yy2;
	int cur_y, tmp_x, tmp_y, delta, new_shift;
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) client_data;
	Widget w = (Widget) client_data;
    XmNlItBoxInfo * data;



	it->itbox.motion_timer_found = 0;

/* Erase bound lines before redrawing changed items and shifting */
		tmp_x=it->itbox.viewX;
		tmp_y=it->itbox.viewY;

            xx1=it->itbox.select_start_point_x+tmp_x;
	    xx2=it->itbox.select_end_point_x+tmp_x;

	    yy1=it->itbox.select_start_point_y-it->itbox.global_shift+tmp_y;
	    if (yy1 < 0) yy1=-1;
	    if (yy1 > (it->itbox.viewHeight+tmp_y)) yy1=it->itbox.viewHeight+1;

	    yy2=it->itbox.select_end_point_y-it->itbox.global_shift+tmp_y;

	    if (yy2 < 0) yy2=-1;
	    if (yy2 > (it->itbox.viewHeight+tmp_y)) yy2=it->itbox.viewHeight+1;


            if ( yy1 >= 0 || yy1 <= (it->itbox.viewHeight+tmp_y)) XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx1, yy1, xx2, yy1);
            XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx1, yy1, xx1, yy2);
            if (yy2 >= 0 || yy2 <= (it->itbox.viewHeight+tmp_y)) XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx1, yy2, xx2, yy2);
            XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx2, yy1, xx2, yy2);



/**************/
/*	it->itbox.global_shift=it->itbox.global_shift+it->itbox.delta_shift;
	if ((it->itbox.global_shift + it->itbox.viewHeight) > it->itbox.full_height)
		{
		delta=it->itbox.delta_shift - ((it->itbox.global_shift + it->itbox.viewHeight) - it->itbox.full_height);
		it->itbox.global_shift = it->itbox.full_height - it->itbox.viewHeight;
		}
	else
	delta=it->itbox.delta_shift;

	it->itbox.select_end_point_y= it->itbox.select_end_point_y + delta;
*/
/************/

	new_shift=it->itbox.global_shift+it->itbox.delta_shift;
	if ((new_shift + it->itbox.viewHeight) > it->itbox.full_height)
		{
		delta=it->itbox.delta_shift - ((new_shift + it->itbox.viewHeight) - it->itbox.full_height);
		new_shift = it->itbox.full_height - it->itbox.viewHeight;
		}
	else
	delta=it->itbox.delta_shift;

	it->itbox.select_end_point_y= it->itbox.select_end_point_y + delta;



/*	cur_y=it->itbox.m_cur_y+it->itbox.delta_shift+it->itbox.global_shift;
	if (cur_y > it->itbox.full_height) cur_y=it->itbox.full_height;


		if (cur_y>=it->itbox.m_b_y)
		{
			it->itbox.m_y2=cur_y;
			it->itbox.m_y1=it->itbox.m_b_y;
		}
		else
		{
			it->itbox.m_y2=it->itbox.m_b_y;
			it->itbox.m_y1=cur_y;
			if (it->itbox.m_y1<0) it->itbox.m_y1=0;
		}
*/

//	res=BoundSelect(w);
	res=ReBoundSelect(w);
	if (res==1) HighlightDoCallback(w, XmNlCR_MULTPLE_SELECT, NULL);

//		if (it->itbox.global_shift+it->itbox.viewHeight > it->itbox.pix_shift+it->itbox.pix_buf_h)
//		{
//			it->itbox.pix_shift=it->itbox.global_shift-it->itbox.cell_height*2;
//			rw=it->itbox.pix_shift/it->itbox.cell_height;
//			it->itbox.pix_shift=rw*it->itbox.cell_height;






/*			sm_pix_shift=sm_global_shift-sm_cell_height*2;
			if (sm_pix_shift < 0)
			{
				sm_pix_shift=0;*/
//				sm_put_to_pix(dir, sm_col_num, sm_pix_buf_shift_row);
/*			}*/
/*			rw=sm_pix_shift/sm_cell_height;
			sm_pix_shift=rw*sm_cell_height;*/
//			sm_put_to_pix(dir, sm_col_num, sm_pix_buf_shift_row);
//		}

/***********/
/*	if (it->itbox.global_shift+it->itbox.viewHeight > it->itbox.full_height) it->itbox.global_shift=it->itbox.full_height-it->itbox.viewHeight;
	XtVaSetValues(it->itbox.v_bar, XmNvalue, it->itbox.global_shift, NULL);
*/

	SetVerShift(w, new_shift, FALSE);
	XtVaSetValues(it->itbox.v_bar, XmNvalue, it->itbox.global_shift, NULL);

/*	if (it->itbox.buffering)
	{
	PutToPixLarge(w);
	it->itbox.shift_in_pix=it->itbox.global_shift-it->itbox.pix_shift;
 	XCopyArea(XtDisplay(w), it->itbox.pix, XtWindow(w), it->itbox.normalGC,
		0, it->itbox.shift_in_pix, it->itbox.viewWidth, it->itbox.viewHeight,
		it->itbox.viewX,
		it->itbox.viewY);
	}*/
//	RecalcRegions(w);
//	RedrawAllDirect(w);
/* 	XCopyArea(XtDisplay(w), it->itbox.pix, XtWindow(w), it->itbox.normalGC,
		0, it->itbox.shift_in_pix, it->itbox.viewWidth, it->itbox.viewHeight,
		it->primitive.highlight_thickness+it->primitive.shadow_thickness,
		it->primitive.highlight_thickness+it->primitive.shadow_thickness);*/


             XSetFunction(XtDisplay(w), it->itbox.normalGC, GXinvert);
//			XSetFunction(display, sm_gc, GXcopy);


		tmp_x=it->itbox.viewX;
		tmp_y=it->itbox.viewY;

            xx1=it->itbox.select_start_point_x+tmp_x;
	    xx2=it->itbox.select_end_point_x+tmp_x;

	    yy1=it->itbox.select_start_point_y-it->itbox.global_shift+tmp_y;
	    if (yy1 < 0) yy1=-1;
	    if (yy1 > (it->itbox.viewHeight+tmp_y)) yy1=it->itbox.viewHeight+1;

	    yy2=it->itbox.select_end_point_y-it->itbox.global_shift+tmp_y;

	    if (yy2 < 0) yy2=-1;
	    if (yy2 > (it->itbox.viewHeight+tmp_y)) yy2=it->itbox.viewHeight+1;


            if ( yy1 >= 0 || yy1 <= (it->itbox.viewHeight+tmp_y)) XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx1, yy1, xx2, yy1);
            XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx1, yy1, xx1, yy2);
            if (yy2 >= 0 || yy2 <= (it->itbox.viewHeight+tmp_y)) XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx1, yy2, xx2, yy2);
            XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.eorGC,
                      xx2, yy1, xx2, yy2);


/*
            xx1=it->itbox.m_x1;
	    xx2=it->itbox.m_x2;
	    yy1=it->itbox.m_y1-it->itbox.global_shift;
	    if (yy1<0) yy1=0;
	    yy2=it->itbox.m_y2-it->itbox.global_shift;
	    if (yy2>it->itbox.viewHeight) yy2=it->itbox.viewHeight;


            if (it->itbox.m_y1-it->itbox.global_shift >= 0) XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.normalGC,
                      xx1, yy1, xx2, yy1);
            XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.normalGC,
                      xx1, yy1, xx1, yy2);
            if (it->itbox.m_y2-it->itbox.global_shift < it->itbox.viewHeight) XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.normalGC,
                      xx1, yy2, xx2, yy2);
            XDrawLine(XtDisplay(w), XtWindow(w), it->itbox.normalGC,
                      xx2, yy1, xx2, yy2);*/

			XSetFunction(XtDisplay(w), it->itbox.normalGC, GXcopy);

	if (it->itbox.global_shift+it->itbox.viewHeight < it->itbox.full_height && it->itbox.auto_scroll == 1)
	{
		it->itbox.motion_timer=XtAppAddTimeOut(XtWidgetToApplicationContext(w), it->itbox.interval, SelectDownScroll, it);
		it->itbox.motion_timer_found = 1;
	}

#ifdef DEBUG
		printf("\n Down AutoSelect Scroll\n");
#endif
}


static void UpMoveAction(Widget w, XEvent *event)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int k, n, SelectedRow, y1, y2, newshift;

	if (it->itbox.num_items==0) return;

	n=it->itbox.current_item;
	k=it->itbox.current_item-it->itbox.col_num;
	if (k<0) return;

	it->itbox.current_item=k;
	DeselctAll(w);
	ChangeCellSelection(w, it->itbox.item_data[k], True);
 	RedrawItemDirect(w, n, 0);
	if (SelectChanged(it))
		HighlightDoCallback(w, XmNlCR_SINGLE_SELECT, event);
	SelectedRow=it->itbox.current_item/it->itbox.col_num;
	y1=SelectedRow * it->itbox.cell_height;
	y2=(SelectedRow +1) * it->itbox.cell_height;

	if (y1 >= it->itbox.global_shift && y2 <= it->itbox.global_shift+it->itbox.viewHeight)
	{

		RedrawItemDirect(w, it->itbox.current_item, 0);
		return;
	}

		  newshift=it->itbox.global_shift - it->itbox.cell_height;
	if (newshift + it->itbox.viewHeight < y1 || newshift > y2 ) newshift=y1-it->itbox.viewHeight/2;
	SetVerShift(w, newshift, TRUE);
	ResizeSliders(w);

	return;
}



static void DownMoveAction(Widget w, XEvent *event)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int n, k, SelectedRow, y1, y2, newshift;
	Boolean SimpleIncrement=TRUE;


	if (it->itbox.num_items==0) return;

/*******************/


	n=it->itbox.current_item;
	k=it->itbox.current_item+it->itbox.col_num;
	if (k>=it->itbox.num_items) return;
	it->itbox.current_item=k;

	DeselctAll(w);
	ChangeCellSelection(w, it->itbox.item_data[k], True);

	RedrawItemDirect(w, n, 0);

	if (SelectChanged(it))
		HighlightDoCallback(w, XmNlCR_SINGLE_SELECT, event);

	SelectedRow=it->itbox.current_item/it->itbox.col_num;
	y1=SelectedRow * it->itbox.cell_height;
	y2=(SelectedRow +1) * it->itbox.cell_height;

	if (y1 >= it->itbox.global_shift && y2 <= it->itbox.global_shift+it->itbox.viewHeight)
	{

		RedrawItemDirect(w, it->itbox.current_item, 0); //RedrawAllDirect(w);
		return;
	}

	newshift=it->itbox.global_shift + it->itbox.cell_height;
//	if (newshift + it->itbox.viewHeight < y2) newshift=y2-it->itbox.viewHeight;
	if (newshift + it->itbox.viewHeight < y1 || newshift > y2 ) newshift=y1-it->itbox.viewHeight/2;
	SetVerShift(w, newshift, TRUE);
	ResizeSliders(w);
	return;
}

static void LeftMoveAction(Widget w, XEvent *event)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int n, SelectedRow, y1, y2, newshift;
	Boolean SimpleIncrement=TRUE;


	if (it->itbox.num_items==0 || it->itbox.current_item<=0) return;

/*******************/

	n=it->itbox.current_item;
	it->itbox.current_item--;

	DeselctAll(w);
	ChangeCellSelection(w, it->itbox.item_data[it->itbox.current_item], True);
/*	it->itbox.item_data[it->itbox.current_item].selected=TRUE;*/

 	RedrawItemDirect(w, n, 0);
// 	RedrawItemDirect(w, it->itbox.current_item);

	if (SelectChanged(it))
		HighlightDoCallback(w, XmNlCR_SINGLE_SELECT, event);
	SelectedRow=it->itbox.current_item/it->itbox.col_num;
	y1=SelectedRow * it->itbox.cell_height;
	y2=(SelectedRow +1) * it->itbox.cell_height;

/*	if (it->itbox.buffering && it->itbox.item_data[it->itbox.current_item].buftext)
	{
			XFreePixmap(XtDisplay(w), it->itbox.item_data[it->itbox.current_item].buftext);
			it->itbox.item_data[it->itbox.current_item].buftext = NULL;
	}
*/
	if (y1 >= it->itbox.global_shift && y2 <= it->itbox.global_shift+it->itbox.viewHeight)
	{

		RedrawItemDirect(w, it->itbox.current_item, 0);

		return;
	}

	if (y1 < it->itbox.global_shift) newshift=y1;
	if (y2 > it->itbox.global_shift+it->itbox.viewHeight) newshift=y2 - it->itbox.viewHeight;

	SetVerShift(w, newshift, TRUE);
	ResizeSliders(w);
	return;
}

static void RightMoveAction(Widget w, XEvent *event)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int n, SelectedRow, y1, y2, newshift;
	Boolean SimpleIncrement=TRUE;


	if (it->itbox.num_items==0 || it->itbox.current_item>=(it->itbox.num_items-1)) return;

/*******************/

	n=it->itbox.current_item;
	it->itbox.current_item++;

	DeselctAll(w);
	ChangeCellSelection(w, it->itbox.item_data[it->itbox.current_item], True);
/*	it->itbox.item_data[it->itbox.current_item].selected=TRUE;*/

 	RedrawItemDirect(w, n, 0);

	if (SelectChanged(it))
		HighlightDoCallback(w, XmNlCR_SINGLE_SELECT, event);

	SelectedRow=it->itbox.current_item/it->itbox.col_num;
	y1=SelectedRow * it->itbox.cell_height;
	y2=(SelectedRow +1) * it->itbox.cell_height;

/*	if (it->itbox.buffering && it->itbox.item_data[it->itbox.current_item].buftext)
	{
			XFreePixmap(XtDisplay(w), it->itbox.item_data[it->itbox.current_item].buftext);
			it->itbox.item_data[it->itbox.current_item].buftext = NULL;
	}
*/
	if (y1 >= it->itbox.global_shift && y2 <= it->itbox.global_shift+it->itbox.viewHeight)
	{


		RedrawItemDirect(w, it->itbox.current_item, 0);

		return;
	}

	if (y1 < it->itbox.global_shift) newshift=y1;
	if (y2 > it->itbox.global_shift+it->itbox.viewHeight) newshift=y2 - it->itbox.viewHeight;

//	newshift=newshift=it->itbox.global_shift + it->itbox.cell_height;
//	if (newshift + it->itbox.viewHeight < y2) newshift=y2-it->itbox.viewHeight;
	SetVerShift(w, newshift, TRUE);
	ResizeSliders(w);
	return;

}

static void ActivateKeyAction(Widget w, XEvent *event)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int SelectedRow, y1, y2, newshift;
	Boolean NeedRefresh=FALSE;


	if (it->itbox.num_items==0) return;

/*******************/

	if (!it->itbox.item_data[it->itbox.current_item]->selected)
	{
		DeselctAll(w);
		ChangeCellSelection(w, it->itbox.item_data[it->itbox.current_item], True);
/*		it->itbox.item_data[it->itbox.current_item].selected=TRUE;*/
		if (SelectChanged(it)) HighlightDoCallback(w, XmNlCR_SINGLE_SELECT, event);
		NeedRefresh=TRUE;
	}

	SelectedRow=it->itbox.current_item/it->itbox.col_num;
	y1=SelectedRow * it->itbox.cell_height;
	y2=(SelectedRow +1) * it->itbox.cell_height;

	if (y2 < it->itbox.global_shift || y1 > it->itbox.global_shift+it->itbox.viewHeight)
	{
		newshift=y1;
		SetVerShift(w, newshift, TRUE);
		ResizeSliders(w);
	}
	else
	{
		if (NeedRefresh)
		{
			RecalcRegions(w);
			RedrawAllDirect(w);
		}
	}
	DoubleClickDoCallback(w, it->itbox.current_item);
	return;
}



static void KeyPressAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    KeySym keysym;
    unsigned char c;
	int res;
	int rw, shift;
	int a;
	Boolean fresh_need=True;
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;

#ifdef DEBUG_CALLBACK
	printf("\n KeyPressed\n");
#endif

	if (*num_params == 1) {
	    switch (params[0][0]) {
	    case 'e': a=1;
	    case 'E': ActivateKeyAction(w, event);
#ifdef DEBUG_CALLBACK
		printf("\n KeyPressAction: Return\n");
#endif
		break;
	    case 'u': UpMoveAction(w, event);
	    case 'U': UpMoveAction(w, event);
#ifdef DEBUG_CALLBACK
		printf("\n KeyPressAction: Up\n");
#endif
		break;
	    case 'd': DownMoveAction(w, event);
	    case 'D': DownMoveAction(w, event);
#ifdef DEBUG_CALLBACK
		printf("\n KeyPressAction: Down\n");
#endif
		break;
	    case 'l': LeftMoveAction(w, event);
	    case 'L': LeftMoveAction(w, event);
#ifdef DEBUG_CALLBACK
		printf("\n KeyPressAction: Left\n");
#endif
		break;
	    case 'r': RightMoveAction(w, event);
	    case 'R': RightMoveAction(w, event);
#ifdef DEBUG_CALLBACK
		printf("\n KeyPressAction: Right\n");
#endif
		break;
	    case 's': a=1;
	    case 'S':
#ifdef DEBUG_CALLBACK
		printf("\n KeyPressAction: Space\n");
#endif
		break;
	    case 'p': a=1;
	    case 'P':
#ifdef DEBUG_CALLBACK
		printf("\n KeyPressAction: Prev Tab\n");
#endif
		XtCallActionProc(w, "PrimitivePrevTabGroup", event, params, *num_params);
		break;
	    case 'n': a=1;
	    case 'N':
#ifdef DEBUG_CALLBACK
		printf("\n KeyPressAction: Next Tab\n");
#endif
		XtCallActionProc(w, "PrimitiveNextTabGroup", event, params, *num_params);
		break;
	    default:
	    {
			return;
		}
	    }
	}
	return;
}

static void
FocusInAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int SelectedRow, y1, y2, num, x, y;

#ifdef DEBUG_CALLBACK
	printf("\nFOCUS IN\n");
#endif
	if (!event->xfocus.send_event)
		return;

	it->itbox.HasFocus = TRUE;
	if (!it->itbox.item_data) return;
	if (it->itbox.current_item < 0) it->itbox.current_item = 0;
	num = it->itbox.current_item;
    if (it->itbox.render_order == LtoR_render) x = (num - (num/it->itbox.col_num)*it->itbox.col_num) * it->itbox.cell_width;
    else x = it->itbox.viewWidth - it->itbox.cell_width - (num - (num/it->itbox.col_num) * it->itbox.col_num) * it->itbox.cell_width;
    y = (num/it->itbox.col_num) * it->itbox.cell_height - it->itbox.global_shift;

	if (y > it->itbox.viewX && y < it->itbox.viewX+it->itbox.viewHeight ||
		y+it->itbox.cell_height > it->itbox.viewX && y+it->itbox.cell_height < it->itbox.viewX+it->itbox.viewHeight ||
		y < it->itbox.viewX && y+it->itbox.cell_height > it->itbox.viewX+it->itbox.viewHeight)
			HighLightItem(w, it->itbox.item_data[num], x, y);

	return ;

}

static void
FocusOutAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
	XmNlItemBoxWidget it = (XmNlItemBoxWidget) w;
	int SelectedRow, y1, y2, num, x, y;
#ifdef DEBUG_CALLBACK
	printf("\nFOCUS OUT\n");
#endif
	if (!event->xfocus.send_event)
		return;

	it->itbox.HasFocus = FALSE;

	if (!it->itbox.item_data) return;
	if (it->itbox.current_item < 0) it->itbox.current_item = 0;
	num=it->itbox.current_item;
    if (it->itbox.render_order == LtoR_render) x = (num - (num/it->itbox.col_num)*it->itbox.col_num) * it->itbox.cell_width;
    else x = it->itbox.viewWidth - it->itbox.cell_width - (num - (num/it->itbox.col_num) * it->itbox.col_num) * it->itbox.cell_width;
    y=(num/it->itbox.col_num) * it->itbox.cell_height - it->itbox.global_shift;

	if (y > it->itbox.viewX && y < it->itbox.viewX+it->itbox.viewHeight ||
		y+it->itbox.cell_height > it->itbox.viewX && y+it->itbox.cell_height < it->itbox.viewX+it->itbox.viewHeight ||
		y < it->itbox.viewX && y+it->itbox.cell_height > it->itbox.viewX+it->itbox.viewHeight)
			HighLightItem(w, it->itbox.item_data[num], x, y);

	return ;
}

