/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */

#ifndef _XmNlCompResource_h
#define _XmNlCompResource_h

#if defined(VMS) || defined(__VMS)
#include <X11/apienvset.h>
#endif

/************************************************************
*	INCLUDE FILES
*************************************************************/
//#include <Xm/ManagerP.h>
//#include <Xm/PrimitiveP.h>

//#include "XmNlList.h"
//#include "XmNlPartRes.h"
//#include "XmNlResColList.h"

/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif


#define XmCTileType			"TileType"
#define XmNtileType			"tileType"

#define XmCPixmapTextPadding			"PixmapTextPadding"

#define XtNtilePixmap		"tilePixmap"
#define XtNtilePixmapMask	"tilePixmapMask"



#define XmCColType			"ColType"
#define XmNcolType			"colType"


#define XmNtileAlignment	"tileAlignment"
#define XmCTileAlignment	"TileAlignment"


#define XmNtileForeground 	"tileForeground"
#define XmCTileForeground	"TileForeground"

#define	XmNtileBackground	"tileBackground"
#define XmCTileBackground	"TileBackground"

#define XmCColSpecTable			"ColSpecTable"
#define XmNcolSpecTable			"colSpecTable"
#define XmRColSpecTable			"ColSpecTablePointer"


#define XmCColSpec			"ColSpec"
#define XmNcolSpec			"colSpec"
#define XmRColSpec			"ColSpecPointer"


#define _MOTIF_DEFAULT_TILEAPPEARANCE_TAG "_MOTIF_DEFAULT_TILEAPPEARANCE_TAG"
#define _MOTIF_DEFAULT_COLDESCRIPTOR_TAG "_MOTIF_DEFAULT_COLDESCRIPTOR_TAG"
/************************************************************
*	MACROS
*************************************************************/



/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/


typedef struct _XmNlColSpecRec
{
	XmStringTag	tag;
	Display	* display;	
	GC gc;
	unsigned int count;
	XmString xmstringTb;
	Pixmap icon;
	Pixmap iconMask;
	Pixel backgroundTb;
	Pixel foregroundTb;
	unsigned char alignmentTb;
	unsigned char typeTb;
	unsigned int pixmapPlacementTb;
	Pixel backgroundCol;
	Pixel foregroundCol;
	unsigned char alignmentCol;
	unsigned char typeCol;
} XmNlColSpecRec;


typedef struct _XmNlColSpecTableRec
{
	  unsigned short pointer_count;
	  unsigned short colspec_count;
	  Display *display;
	  XmNlColSpecRec  ** col_spec;
} XmNlColSpecTableRec;


typedef struct _XmNlColSpecRec * XmNlColSpec;
typedef struct _XmNlColSpecTableRec * XmNlColSpecTable;

/************************************************************
*	EXTERNAL DECLARATIONS
*************************************************************/


XmNlColSpecRec * XmNlColSpecCreate(Display *display, Widget widget, XmStringTag tag, ArgList arglist, Cardinal argcount);
XmNlColSpecTableRec * XmNlColSpecTableAddItem(XmNlColSpecTableRec * tb, XmNlColSpecRec * item);
void XmNlColSpecTableFree(XmNlColSpecTable tb);
XmNlColSpecTableRec * XmNlColSpecTableCreateEmpty(unsigned int num);
void XmNlColSpecFree (XmNlColSpecRec * rec);

Boolean ColSpecConverter(Display *dpy, XrmValue *args, Cardinal *num_args, XrmValue *from, XrmValue *to, XtPointer *cvt_data);
void ColSpecDestroy(XtAppContext app,	XrmValue *to, XtPointer converter_data, XrmValue *args, Cardinal *num_args);




#ifdef DEBUG
void _XmNlColSpecTablePrint(int num, XmNlColSpecTable cst);
void _XmNlColSpecPrint(XmNlColSpecRec * rec);
#endif

#if defined(__cplusplus)
}
#endif

/************************************************************
*	STATIC DECLARATIONS
*************************************************************/

#if defined(VMS) || defined(__VMS)
#include <X11/apienvrst.h>
#endif

#endif /* _XmNlCompResource_h */
