/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */

/************************************************************
*	INCLUDE FILES
*************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <X11/X.h> 
#include <Xm/XmP.h>
#include <Xm/ExtP.h>
#include <X11/ShellP.h>


#include "XmNlCompResource.h"



/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/
#define DEFAULT_tag		XmS
#define DEFAULT_TEXT_IN_TILE "o"


/************************************************************
*	MACROS
*************************************************************/
#define streq(a, b) (((a) != NULL) && ((b) != NULL) && (strcmp((a), (b)) == 0))

/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/

/************************************************************
*	STATIC FUNCTION DECLARATIONS
*************************************************************/
/************************************************************
*	STATIC DECLARATIONS
*************************************************************/


static XtResource _XmNlColSpecResources[] = {
	{ 
		XmNtag, XmCTag, XmRString,
		sizeof(XmStringTag), XtOffsetOf(XmNlColSpecRec, tag),
		XmRImmediate, (XtPointer) DEFAULT_tag
	},
	{
		XmNtileAlignment, XmCTileAlignment, XmRAlignment, 
		sizeof(unsigned char), XtOffsetOf(XmNlColSpecRec, alignmentTb),
		XmRImmediate, (XtPointer) XmALIGNMENT_BEGINNING
	},
	{
        XmNtileType, XmCTileType, XmRLabelType,
        sizeof(unsigned char), XtOffsetOf(XmNlColSpecRec, typeTb),
        XmRImmediate, (XtPointer) XmSTRING
	},
	{
		XmNpixmapPlacement, XmCPixmapPlacement, XmRPixmapPlacement,
		sizeof(XmPixmapPlacement), XtOffsetOf(XmNlColSpecRec, pixmapPlacementTb),
		XmRImmediate, (XtPointer) XmPIXMAP_LEFT
    },
    {
		XmNlabelString, XmCXmString, XmRXmString,
		sizeof(XmString), XtOffsetOf(XmNlColSpecRec, xmstringTb),
		XmRImmediate, (XtPointer) NULL
	},
	{
		XtNtilePixmap, XtCPixmap, XtRPixmap, 
		sizeof(Pixmap), XtOffsetOf(XmNlColSpecRec, icon), 
		XmRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP
	},
	{
		XtNtilePixmapMask, XtCPixmap, XmRPixmap, 
		sizeof(Pixmap), XtOffsetOf(XmNlColSpecRec, iconMask), 
		XmRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP
	},
	{
		XmNtileForeground, XmCTileForeground, XmRPixel, 
		sizeof(Pixel), XtOffsetOf(XmNlColSpecRec, foregroundTb), 
		XmRImmediate, (XtPointer) XmUNSPECIFIED_PIXEL
	},
	{
		XmNtileBackground, XmCTileBackground, XmRPixel,
		sizeof(Pixel), XtOffsetOf(XmNlColSpecRec, backgroundTb),
		XmRImmediate, (XtPointer) XmUNSPECIFIED_PIXEL
	},
	{
		XmNalignment, XmCAlignment, XmRAlignment, 
		sizeof(unsigned char), XtOffsetOf(XmNlColSpecRec, alignmentCol),
		XmRImmediate, (XtPointer) XmALIGNMENT_BEGINNING
	},
	{
		XmNforeground, XmCForeground, XmRPixel, 
		sizeof(Pixel), XtOffsetOf(XmNlColSpecRec, foregroundCol), 
		XmRImmediate, (XtPointer) XmUNSPECIFIED_PIXEL
	},
	{
		XmNbackground, XmCBackground, XmRPixel, 
		sizeof(Pixel), XtOffsetOf(XmNlColSpecRec, backgroundCol), 
		XmRImmediate, (XtPointer) XmUNSPECIFIED_PIXEL
	},
	{
        XmNcolType, XmCColType, XmRLabelType,
        sizeof(unsigned char), XtOffsetOf(XmNlColSpecRec, typeCol),
        XmRImmediate, (XtPointer) XmSTRING
	},
};



/************************************************************
*	STATIC CODE
*************************************************************/

static void CopyFromArg(XtArgVal src, char *dst, unsigned int size)
{
	if (size > sizeof(XtArgVal))
		memcpy((char *)dst, (char *)src, (size_t)size);
	else {
		union {
				long longval;
				int intval;
				short	shortval;
				char	charval;
				char *	charptr;
				XtPointer	ptr;
		} u;
		char *p = (char*)&u;
		if (size == sizeof(long)) u.longval = (long)src;
		else if (size == sizeof(int)) u.intval = (int) src;
		else if (size == sizeof(short))	u.shortval = (short)src;
		else if (size == sizeof(char)) u.charval = (char)src;
		else if (size == sizeof(XtPointer))	u.ptr = (XtPointer)src;
		else if (size == sizeof(char*))	u.charptr = (char*)src;
		else p = (char*)&src;

		memcpy((char *)dst, p, (size_t)size);
	}
}

/* Converts resource list to quarkified list. */
static XrmResourceList CompileResourceTable(XtResourceList resources,
											Cardinal num_resources)
{
	Cardinal		count;
	XrmResourceList	table, tPtr;
	XtResourceList	rPtr;
  
	tPtr = table = (XrmResourceList) XtMalloc(num_resources * sizeof(XrmResource));
	rPtr = resources;
  
	for (count = 0; count < num_resources; count++, tPtr++, rPtr++)
	{
		tPtr->xrm_name 		= XrmPermStringToQuark(rPtr->resource_name);
		tPtr->xrm_class 		= XrmPermStringToQuark(rPtr->resource_class);
		tPtr->xrm_type 		= XrmPermStringToQuark(rPtr->resource_type);
		tPtr->xrm_size		= rPtr->resource_size;
		tPtr->xrm_offset		= rPtr->resource_offset;
		tPtr->xrm_default_type 	= XrmPermStringToQuark(rPtr->default_type);
		tPtr->xrm_default_addr	= rPtr->default_addr;
	}
	return table;
}

/* Searches up widget hierarchy, quarkifying ancestor names and */
/* classes. */
static Cardinal GetNamesAndClasses(Widget w, XrmNameList names, XrmClassList classes)
{
	Cardinal length, j;
	XrmQuark t;
	WidgetClass wc;

/* Return null-terminated quark arrays, with length the number of
quarks (not including NULL) */

	for (length = 0; w != NULL; w = (Widget)w->core.parent)
	{
		names[length] = w->core.xrm_name;
		wc = XtClass(w);
		if (w->core.parent == NULL && XtIsApplicationShell(w)) {
			classes[length] = ((ApplicationShellWidget) w)->application.xrm_class;
		} else 
			classes[length] = wc->core_class.xrm_class;
		length++;
	}
/* They're in backwards order, flop them around */
	for (j = 0; j < length/2; j++)
	{
		t = names[j];
		names[j] = names[length - j - 1];
		names[length - j - 1] = t;
		t = classes[j];
		classes[j] = classes[length - j - 1];
		classes[length - j - 1] = t;
	}
	names[length] = NULLQUARK;
	classes[length] = NULLQUARK;
	return length;
}




static Boolean GetColSpecResources(XmNlColSpecRec * csr,
										Display *dsp,
										Widget wid,
										String resname,
										String resclass,
										XmStringTag tag,
										ArgList arglist,
										Cardinal argcount)
{
	XrmName	names[100];
	XrmClass classes[100];
	Cardinal length = 0;
	static XrmQuarkList	quarks = NULL;
	static Cardinal	num_quarks = 0;
	static Boolean *found = NULL;
	int	i, j;
	static XrmResourceList table = NULL;
	static XrmQuark	QString;
	Arg	*arg;
	XrmName	argName;
	XrmResource	*res;
	XrmDatabase	db = NULL;
	XrmHashTable stackSearchList[100];
	XrmHashTable *searchList = stackSearchList;
	unsigned int searchListSize = 100;
	Boolean	got_one = False;
	XrmValue value;
	XrmQuark rawType;
	XrmValue convValue;
	Boolean	have_value, copied;


#ifdef XTHREADS
	XtAppContext		app = NULL;

	if (wid)
		app = XtWidgetToApplicationContext(wid);
	else if (dsp)
		app = XtDisplayToApplicationContext(dsp);
	if (app) {
		_XmAppLock(app);
	}
	_XmProcessLock();
#endif

#ifdef DEBUG
	printf(">>>>>>>>>>>>>> GetColSpecResources started\n");
#endif

/* Initialize quark cache */
	if (quarks == NULL)
	{
		quarks = (XrmQuark *) XtMalloc(XtNumber(_XmNlColSpecResources) * sizeof(XrmQuark));
		num_quarks = XtNumber(_XmNlColSpecResources);
	}

/* Initialize found */
	if (found == NULL)
		found = (Boolean *) XtMalloc(XtNumber(_XmNlColSpecResources) * sizeof(Boolean));

	bzero(found, XtNumber(_XmNlColSpecResources) * sizeof(Boolean));

/* Compile names and classes. */
	if (wid != NULL)
		length = GetNamesAndClasses(wid, names, classes);
  
	names[length] = XrmStringToQuark(resname);
	classes[length] = XrmStringToQuark(resclass);
	length++;
  
	if (tag != NULL)
	{
		names[length] = XrmStringToQuark(tag);
		classes[length] = XrmPermStringToQuark(XmCColSpec);
		length++;
	}      

	names[length] = NULLQUARK;
	classes[length] = NULLQUARK;


#ifdef DEBUG
	for (i = 0; i < length; i++)
	{
		printf(">>>>> GetColSpecResources: names %s, class %s\n", XrmQuarkToString(names[i]), XrmQuarkToString(classes[i]));
	}
#endif

/* Cache arglist */
	if (num_quarks < argcount)
	{
		quarks = (XrmQuark *)XtRealloc((char *)quarks, argcount * sizeof(XrmQuark));
		num_quarks = argcount;
	}

	for (i = 0; i < argcount; i++)
		quarks[i] = XrmStringToQuark(arglist[i].name);

/* Compile resource description into XrmResourceList if not already done. */
	if (table == NULL)
	{
		table = CompileResourceTable(_XmNlColSpecResources, XtNumber(_XmNlColSpecResources));
		QString = XrmPermStringToQuark(XtCString);
//		Qfont = XrmPermStringToQuark(XmNfont);
	}
  
#ifdef DEBUG
	printf(">>>>> GetColSpecResources: argcount %d\n", argcount);
#endif

/* Set resources from arglist. */
	for (arg = arglist, i = 0; i < argcount; arg++, i++)
	{
		argName = quarks[i];
      
		for (j = 0, res = table; j < XtNumber(_XmNlColSpecResources); j++, res++)
		{
			if (res->xrm_name == argName)
			{
				CopyFromArg((arg->value),
							((char *) csr + res->xrm_offset),
							res->xrm_size);
				found[j] = TRUE;
#ifdef DEBUG
				printf(">>>>> GetColSpecResources: copyed from arg %d value at %p with size %d to %p\n", 
						i, (arg->value), res->xrm_size, ((char *) csr + res->xrm_offset));
#endif
				break;
			}
		}
	}
  
/* DB query */
/* Get database */
	if ((wid != NULL) || (dsp != NULL))
	{
		if (wid != NULL)
		db = XtScreenDatabase(XtScreenOfObject(wid));
		else db = XtScreenDatabase(DefaultScreenOfDisplay(dsp));

#ifdef DEBUG
		if (db)
			printf(">>>>>>> GetColSpecResources: db found\n");
#endif

/* Get searchlist */
		while (!XrmQGetSearchList(db, names, classes, searchList, searchListSize))
		{
			if (searchList == stackSearchList)
				searchList = NULL;
			searchList = (XrmHashTable *)XtRealloc((char*)searchList,
							sizeof(XrmHashTable) * (searchListSize *= 2));
		}
	}

/* Loop over table */
	for (j = 0, res = table; j < XtNumber(_XmNlColSpecResources); j++, res++)
	{
		if (!found[j])
		{
			copied = False;
			have_value = False;
	  
			if ((db != NULL) && (XrmQGetSearchResource(searchList, res->xrm_name, res->xrm_class, &rawType, &value)))
			{
/* convert if necessary */
	      
#ifdef DEBUG
				printf(">>>>> GetColSpecResources: finded res %s for %s\n", XrmQuarkToString(rawType), XrmQuarkToString(res->xrm_type));
				if (0 == strcmp(XrmQuarkToString(rawType), "String"))
					printf("|- value %s\n", value.addr);
#endif
				if (rawType != res->xrm_type)
				{
					if (wid != NULL)
					{
						convValue.size = res->xrm_size;
						convValue.addr = (char *) csr + res->xrm_offset;

						copied = have_value = XtConvertAndStore(wid, XrmQuarkToString(rawType), &value, 
																	XrmQuarkToString(res->xrm_type), &convValue);
					}
					else have_value = False;
				} 
				else have_value = True;
		  
			}
	      
			if (!got_one && have_value) 
				got_one = True;

/* Set defaults */
			if (!have_value)
			{
				CopyFromArg((XtArgVal)(res->xrm_default_addr),
							((char *) csr + res->xrm_offset),
							res->xrm_size);
				copied = True;
			}

/* Copy if needed */
			if (!copied)
			{
				if (res->xrm_type == QString)
					*((String *)((char *) csr + res->xrm_offset)) = value.addr;
				else if (value.addr != NULL)
					memcpy(((char *) csr + res->xrm_offset), value.addr, res->xrm_size);
					else 
						bzero(((char *) csr + res->xrm_offset), res->xrm_size);
			}
		}
	}

	if (searchList != stackSearchList) XtFree((char *)searchList);

#ifdef DEBUG
	printf(">>>>>>>>>>>>>> GetAppearanceResources completed\n");
#endif

#ifdef XTHREADS
	_XmProcessUnlock();
	if (app) {
		_XmAppUnlock(app);
	}
#endif

	return got_one;
}



XmNlColSpecRec * _XmNlColSpecRecCreate(Display *display,
											   Widget widget,
											   String resname,
											   String resclass,
											   XmStringTag tag,
											   ArgList arglist,
											   Cardinal argcount,
											   Boolean *in_db)
{
	XmNlColSpecRec * rec;
	Boolean 	result;
  
#ifdef DEBUG
	printf(">>>>>>>>>>>>>> _XmNlColSpecRecCreate started\n");
#endif

	if ((display == NULL) && (widget != NULL))
		display = XtDisplayOfObject(widget);


/* Allocate appearance. */
	rec = (XmNlColSpecRec *) XtMalloc(sizeof(XmNlColSpecRec));
	bzero((char*)rec, sizeof(XmNlColSpecRec));

#ifdef DEBUG
	printf(">>>>>>>>>>>>>> _XmNlColSpecRecCreate created\n");
#endif 
  

/* X resource DB query */
	result = GetColSpecResources(rec, display, widget, resname, resclass, tag, arglist, argcount);
  
	if (in_db != NULL) *in_db = result;
  
	if (tag == NULL)
	{
		tag = _MOTIF_DEFAULT_TILEAPPEARANCE_TAG;
	}

	if (tag)
	{
		rec->tag = strdup(tag);
	}
	
#ifdef DEBUG
	printf(">>>>>>>> _XmNlColSpecRecCreate: tag %s alignment %hhx\n", rec->tag, rec->alignmentCol);
#endif
	
  
/* Cleanup and validate resources. */

	return rec;
}


#ifdef DEBUG
void _XmNlColSpecPrint(XmNlColSpecRec * rec)
{
	
	if (!rec)
		return ;
		
	printf("ColSpec RESOURCES PRINT\n");
		
			
	printf("__________tag for is %s\n", rec->tag);

	printf("__________tile background for is %ld\n", rec->backgroundTb);
	printf("__________tile foreground for is %ld\n", rec->foregroundTb);

	printf("__________col background for is %ld\n", rec->backgroundCol);
	printf("__________col foreground for is %ld\n", rec->foregroundCol);
	printf("__________icon for is %ld\n", rec->icon);
	printf("__________iconMask for is %ld\n", rec->iconMask);

	switch (rec->alignmentTb) {
		case XmALIGNMENT_BEGINNING :
			printf("__________tile alignment for is BEGIN\n");
			break ;
		case XmALIGNMENT_CENTER :
			printf("__________tile alignment for is CENTER\n");
			break ;
		case XmALIGNMENT_END :
			printf("__________tile alignment for is END\n");
			break ;
		default:
			break ;
	}

	switch (rec->alignmentCol) {
		case XmALIGNMENT_BEGINNING :
			printf("__________col alignment for is BEGIN\n");
			break ;
		case XmALIGNMENT_CENTER :
			printf("__________col alignment for is CENTER\n");
			break ;
		case XmALIGNMENT_END :
			printf("__________col alignment for is END\n");
			break ;
		default:
			break ;
	}

	switch (rec->typeTb) {
		case XmSTRING :
			printf("__________tile type for is STRING\n");
			break ;
		case XmPIXMAP_AND_STRING :
			printf("__________tile type for is PIXMAP_AND_STRING\n");
			break ;
		case XmPIXMAP :
			printf("__________tile type for is PIXMAP\n");
			break ;
		default:
			break ;
	}

	switch (rec->typeCol) {
		case XmSTRING :
			printf("__________col type for is STRING\n");
			break ;
		case XmPIXMAP_AND_STRING :
			printf("__________col type for is PIXMAP_AND_STRING\n");
			break ;
		case XmPIXMAP :
			printf("__________col type for is PIXMAP\n");
			break ;
		default:
			break ;
	}

	switch (rec->pixmapPlacementTb) {
		case XmPIXMAP_TOP :
			printf("__________pixmapPlacement for is TOP\n");
			break ;
		case XmPIXMAP_BOTTOM :
			printf("__________pixmapPlacement for is BOTTOM\n");
			break ;
		case XmPIXMAP_LEFT :
			printf("__________pixmapPlacement for is LEFT\n");
			break ;
		case XmPIXMAP_RIGHT :
			printf("__________pixmapPlacement for is RIGHT\n");
			break ;
		default:
			break ;
		}
			

	return ;	
}
#endif

#ifdef DEBUG
void _XmNlColSpecTablePrint(int num, XmNlColSpecTable cst)
{
	XmNlColSpecRec * rec;
	int i;
	
	if (num <= 0 || !cst)
		return ;
		
	printf("ColSpec RESOURCES PRINT %i\n", num);
		
	for (i = 0; i < num; i++)
	{
		rec = cst->col_spec[i];
			
		printf("__________tag for %i is %s\n", i, rec->tag);

		printf("__________tile background for %i is %ld\n", i, rec->backgroundTb);
		printf("__________tile foreground for %i is %ld\n", i, rec->foregroundTb);

		printf("__________col background for %i is %ld\n", i, rec->backgroundCol);
		printf("__________col foreground for %i is %ld\n", i, rec->foregroundCol);
		printf("__________icon for %i is %ld\n", i, rec->icon);
		printf("__________iconMask for %i is %ld\n", i, rec->iconMask);

		switch (rec->alignmentTb) {
			case XmALIGNMENT_BEGINNING :
				printf("__________tile alignment for %i is BEGIN\n", i);
				break ;
			case XmALIGNMENT_CENTER :
				printf("__________tile alignment for %i is CENTER\n", i);
				break ;
			case XmALIGNMENT_END :
				printf("__________tile alignment for %i is END\n", i);
				break ;
			default:
				break ;
		}

		switch (rec->alignmentCol) {
			case XmALIGNMENT_BEGINNING :
				printf("__________col alignment for %i is BEGIN\n", i);
				break ;
			case XmALIGNMENT_CENTER :
				printf("__________col alignment for %i is CENTER\n", i);
				break ;
			case XmALIGNMENT_END :
				printf("__________col alignment for %i is END\n", i);
				break ;
			default:
				break ;
		}

		switch (rec->typeTb) {
			case XmSTRING :
				printf("__________tile type for %i is STRING\n", i);
				break ;
			case XmPIXMAP_AND_STRING :
				printf("__________tile type for %i is PIXMAP_AND_STRING\n", i);
				break ;
			case XmPIXMAP :
				printf("__________tile type for %i is PIXMAP\n", i);
				break ;
			default:
				break ;
		}

		switch (rec->typeCol) {
			case XmSTRING :
				printf("__________col type for %i is STRING\n", i);
				break ;
			case XmPIXMAP_AND_STRING :
				printf("__________col type for %i is PIXMAP_AND_STRING\n", i);
				break ;
			case XmPIXMAP :
				printf("__________col type for %i is PIXMAP\n", i);
				break ;
			default:
				break ;
		}

		switch (rec->pixmapPlacementTb) {
			case XmPIXMAP_TOP :
				printf("__________pixmapPlacement for %i is TOP\n", i);
				break ;
			case XmPIXMAP_BOTTOM :
				printf("__________pixmapPlacement for %i is BOTTOM\n", i);
				break ;
			case XmPIXMAP_LEFT :
				printf("__________pixmapPlacement for %i is LEFT\n", i);
				break ;
			case XmPIXMAP_RIGHT :
				printf("__________pixmapPlacement for %i is RIGHT\n", i);
				break ;
			default:
				break ;
			}
			
		}
	return ;	
}
#endif



/************************************************************
 *
 * Public Functions.
 *
 ************************************************************/


Boolean ColSpecConverter(Display *dpy, XrmValue *args, Cardinal *num_args, XrmValue *from, XrmValue *to, XtPointer *cvt_data)
{
	char *s;
	char *tag;
	Boolean	has_default = FALSE, in_db = FALSE;
	XmNlColSpecRec * rec;
	XmNlColSpecTableRec * cst;
	Widget widget;

	widget = *(Widget *)args[0].addr;

#ifdef DEBUG
	printf("++++++++Convert from: %s\n num args %d arg0 %p\n", (char *) from->addr, *num_args, widget);
#endif

	if (from->addr)
	{  
		s = XtNewString((char *)from->addr);
		has_default = FALSE;

/* Try to get first tag. */
		if ((tag = strtok(s, " \t\r\n\v\f,")) != NULL)
		{
	      
#ifdef DEBUG
			printf("+Converted first: %s\n", tag);
#endif
			rec = _XmNlColSpecRecCreate(dpy, widget, XmNcolSpecTable, XmCColSpecTable, 
												tag, NULL, 0, &in_db); 
			cst = XmNlColSpecTableAddItem(cst, rec);
			
	    }
	}
	else 
	{
		XtFree(s);
		return FALSE;
	}


	while ((tag = strtok(NULL, " \t\r\n\v\f,")) != NULL)
	{
#ifdef DEBUG
		printf("+Converted: %s\n", tag);
#endif

		rec = _XmNlColSpecRecCreate(dpy, widget, XmNcolSpecTable, XmCColSpecTable, 
									tag, NULL, 0, &in_db); 
		cst = XmNlColSpecTableAddItem(cst, rec);
		
	}

	XtFree(s);
	_XM_CONVERTER_DONE(to, XmNlColSpecTableRec *, cst, XmNlColSpecTableFree(cst);)
//	return FALSE;
}

//static void
void
ColSpecDestroy(
        XtAppContext app,	/* unused */
        XrmValue *to,
        XtPointer converter_data, /* unused */
        XrmValue *args,		/* unused */
        Cardinal *num_args)	/* unused */
{   
    
    XmNlColSpecTableFree(* ((XmNlColSpecTable *) to->addr));

    return ;
}



XmNlColSpecRec * XmNlColSpecCreate(Display *display,
											Widget widget,
											XmStringTag tag,
											ArgList arglist,
											Cardinal argcount)
{
	XmNlColSpecRec * rec;
	Boolean 	* result;
  
#ifdef DEBUG
	printf("<<<<<<< XmNlColSpecCreate started\n");
#endif
	rec = _XmNlColSpecRecCreate(display, widget, XmNcolSpec, XmCColSpec, tag, arglist, argcount, result);

#ifdef DEBUG
	printf("<<<<<<< XmNlColSpecCreate completed %p\n", rec);
#endif

	return rec;
}

void XmNlColSpecFree (XmNlColSpecRec * rec)
{
	XtFree((char *) rec);
}

XmNlColSpecTableRec * XmNlColSpecTableAddItem(XmNlColSpecTableRec * tb, XmNlColSpecRec * item)
{
	if (tb == NULL)
	{
		tb = (XmNlColSpecTableRec *) XtMalloc(sizeof(XmNlColSpecTableRec));
		if (!tb)
			return NULL;
		bzero(tb, sizeof(XmNlColSpecTableRec));
		tb->col_spec = (XmNlColSpecRec **) XtMalloc(10 * sizeof(XmNlColSpecRec *));
		if (!tb->col_spec)
		{
			XtFree((char *) tb);
			return NULL;
		}
		tb->pointer_count = 10;
	}
	
	if (tb->colspec_count >= tb->pointer_count)
	{
		tb->col_spec = (XmNlColSpecRec **) XtRealloc((char *) tb->col_spec, tb->pointer_count + 10);
		tb->pointer_count += 10;
	}
	
	tb->col_spec[tb->colspec_count] = item;
	
	tb->colspec_count++;
	
	return tb;
}


XmNlColSpecTableRec * XmNlColSpecTableCreateEmpty(unsigned int num)
{
	XmNlColSpecTableRec * tb;
	int i;
	
	if (num == 0)
		return NULL;

	tb = (XmNlColSpecTableRec *) XtMalloc(sizeof(XmNlColSpecTableRec));
	if (!tb)
		return NULL;
	bzero(tb, sizeof(XmNlColSpecTableRec));
	tb->col_spec = (XmNlColSpecRec **) XtMalloc(num * sizeof(XmNlColSpecRec *));
	if (!tb->col_spec)
	{
		XtFree((char *) tb);
		return NULL;
	}
	tb->pointer_count = 10;
	
	tb->pointer_count = num;

	for (i = 0; i < num; i++)
	{
		tb->col_spec[i] = (XmNlColSpecRec *) XtMalloc(sizeof(XmNlColSpecRec));
		bzero(tb->col_spec[i], sizeof(XmNlColSpecRec));
	}
	
	return tb;
}



void XmNlColSpecTableFree(XmNlColSpecTable tb)
{
	if (tb != NULL)
	{
		if (tb->pointer_count && tb->col_spec)
		XtFree((char *) tb->col_spec);
		XtFree((char *) tb);
	}
	
	return ;
}

