/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */

#ifndef _XmNl_h
#define _XmNl_h

#if defined(VMS) || defined(__VMS)
#include <X11/apienvset.h>
#endif

//#include <Xm/Ext.h>

/************************************************************
*	INCLUDE FILES
*************************************************************/
//#include "XmItemBox.h"

/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

//#define XmCViewListType		"ViewType"
//#define XmNViewListType		"view_type"


#define XmRAlignmentList "AlignmentListPointer"
#define XmRNlString "NlString"

#define XmNmps "mps"
#define XmCMps "Mps"
#define XmRMpsPointer "MpsPointer"

#define XmNalignmentList "alignmentList"
#define XmCAlignmentList "AlignmentList"

#define XmNnumCols		"numCols"
#define XmCNumCols		"NumCols"

#define XmNautoResCol	"autoResizeColumn"
#define XmCAutoResCol	"AutoResizeColumn"

#define XmNlayoutFrozen	"layoutFrozen"
#define XmCLayoutFrozen	"LayoutFrozen"


#define XmNnumItems		"num_items"
//#define XmNentryData		"entry_data"
#define XmCNumItems		"NumItems"
//#define XmCEntryData		"EntryData"
//#define XmCScrollBar		"ScrollBar"
//#define XmNBackground		"Background"
//#define XmNselectBackground	"selectBackground"
//#define XmCSelectBackground	"SelectBackground"
//#define XmNForeground		"Foreground"
#define XmNselectForeground	"selectForeground"
#define XmCSelectForeground	"SelectForeground"
//#define XmNfontlist		"fontlist"
#define XtNhighlightCallback	"highlightCallback"

#define XmNtitleShadowThickness "titleShadowThickness"
#define XmCTitleShadowThickness "TitleShadowThickness"

#define	XmNmarginTitle "marginTitle"
#define XmCMarginTitle "MarginTitle" 



#define XmNselectLineStyle	"selectLineStyle" 
#define XmNlRLineStyle		"mNlLineStyle"

#define XmNselectLineWidth	"selectLineWidth"
#define XmCSelectLineWidth	"SelectLineWdth"

#define XmNselectLineMargin	"selectLineMargin"
#define XmCSelectLineMargin	"SelectLineMargin"

#define XmNlTextSpacing		"textSpacing"
#define XmCTextSpacing		"TextSpacing"

#define XmNlBufferingOn		"bufferingOn"
#define XmCbufferingOn		"BufferingOn"

#define XmNlAutoMarkerPlacement		"autoMarkerPlacement"
#define XmCAutoMarkerPlacement		"AutoMarkerPlacement"

#define XmNlMarkedColumnNum		"markedColumnNum"
#define XmCMarkedColumnNum		"MarkedColumnNum"


#define XmNlmarkUpPixmap	"markUpPixmap"
#define XmNlmarkUpPixmapMask		"markUpPixmapMask" 
#define XmNlmarkDownPixmap		"markDownPixmap"
#define XmNlmarkDownPixmapMask		"markDownPixmapMask"

//#define XmNdoubleClickCallback	"doubleClickCallback"
//typedef struct _XmNlListClassRec	*XmNlListWidgetClass;
//typedef struct _XmNlListRec		*XmNlListWidget;

/* Cell attribute value mask bits */

/*#define CellPixmap		(1L<<0)
#define CellMask		(1L<<1)
#define CellXmString	(1L<<2)
#define CellUserData	(1L<<3)
#define CellCharString	(1L<<4)
#define CellAlignment	(1L<<5)*/

#define CellPixmap		0x01
#define CellMask		0x02
#define CellXmString	0x04
#define CellUserData	0x08
#define CellCharString	0x10
#define CellAlignment	0x20
#define CellSelection	0x40
#define CellPriority	0x80

#define XmNlSizeChange		1
#define XmNlContentChange	2
#define XmNlTreeSizeChange	3
#define XmNlConsistencyChange	4

#define XmNlItemsFound	1
#define XmNlEmpty		2
#define XmNlPropertyConsistency	4
#define XmNlPropertyInconsistency		8

#define XmNlTileClicked		1

#define XmNlastColumn -1

/************************************************************
*	MACROS
*************************************************************/

/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/


/*typedef struct _XmNl_Cell {*/

/* Public elements */
/*Pixmap pixmap;
Pixmap mask;
String text;
XmString xmlabel;*/

/* Private elements */

/*Dimension pix_w;
Dimension pix_h;
Dimension label_w;
Dimension label_h;
} XmNl_Cell;*/


enum {	XmNlCR_SINGLE_SELECT, 	XmNlCR_EXTENDED_SELECT, 
		XmNlCR_MULTPLE_SELECT, 	XmNlCR_COMPLETED_SELECT,
		XmNlCR_ADD_SELECT,		XmNlCR_DELETE_SELECT
};

typedef struct _XmNlCell {
/* Public elements */
	Pixmap pixmap;
	Pixmap mask;
	String text;
	XmString xmlabel;
	unsigned char element_type;
	unsigned char alignment;
	unsigned char priority;
	Boolean resizeble;
	Boolean selected;
	void * UserDataPointer;
/* Private elements */
} XmNlCell; 


typedef struct _ListItemReturnStruct {
	int		reason;
	XEvent	*event;
	int		*number;
	void	**pointers;
	int		count;
} ListItemReturnStruct;


typedef struct _ItemActivateReturnStruct {
	int		reason;
	XEvent	*event;
	int		item_number;
	void	*pointer;
} ItemActivateReturnStruct;


typedef struct _ListResizeReturnStruct {

/* Type of event source 									*/	
/*XmNlSizeChange - size of widget changed 					*/
/*XmNlContentChange	- content of widget changed 			*/
/*XmNlTreeSizeChange	- size of column with tree changed 	*/
	int		reason;
	XEvent	*event;				/* Noot used */
	int		wid_width;			/* Widget width: widget -> callback function */
	int		last_wid_width;		/* Last widget width: widget -> callback function */
	int 	cols_num;			/* Number of columns in list: widget -> callback function */
	int		*col_sharp_width;	/* Vector of columns real sizes: widget -> callback function */
	int		*col_cur_width;		/* Vector of columns current sizes: widget -> callback function */
	int		*col_new_width;		/* Vector of columns new sizes: callback function return to widget */
	int		list_full_width;	/* Full width of list: callback function <-> widget */
	int 	cur_h_shift;		/* Current horizontal shift: widget -> callback function */
	int		new_h_shift;		/* New horizontal shift: callback function return to widget */
	char	state;				/* Found item(s) in widget (XmNlItemsFound) or not found (XmNlEmpty) */
} ListResizeReturnStruct;

typedef struct _ListTileActivateReturnStruct {
	int		reason;
	XEvent	*event;
	int		col_number;
	unsigned char status;
} ListTileActivateReturnStruct;


/************************************************************
* Public function declarations
*************************************************************/

//extern WidgetClass xmNlListWidgetClass;

#if defined(__cplusplus)
}
#endif

#if defined(VMS) || defined(__VMS)
#include <X11/apienvrst.h>
#endif

#endif /* _XmNl_h */
