#include <Xm/XmAll.h>
#include <pwd.h>
#include <Xm/PushB.h>
#include <Xm/Form.h>
#include "XmNlPartRes.h"
#include "XmNlResColList.h"
#include "XmNl.h"
#include "XmNlList.h"
#include <string.h>
#include <X11/cursorfont.h>
#include <X11/xpm.h>
#include <stdlib.h>



#define icon_big_n 293
#define icon_small_n 14

static char *big_names[] = {
"acroread.xpm",       "fonts.xpm",         "kruler.xpm",         "pysol.xpm",
"applications.xpm",   "font.xpm",          "ksame.xpm",          "raster.xpm",
"app_link.xpm",       "framemaker.xpm",    "kscd.xpm",           "rc.xpm",
"app_plain.xpm",      "games_arcade.xpm",  "kscreensaver.xpm",   "readme.xpm",
"app.xpm",            "games_board.xpm",   "kshisen.xpm",        "realplayer.xpm",
"ark.xpm",            "games_card.xpm",    "ksirtet.xpm",        "recycle.xpm",
"blender.xpm",        "games.xpm",         "ksmiletris.xpm",     "redhat.xpm",
"bluelogo.xpm",       "gears2.xpm",        "ksnake.xpm",         "res.xpm",
"bookshelf.xpm",      "gears.xpm",         "ksnapshot.xpm",      "samba.xpm",
"book.xpm",           "ghostview.xpm",     "ksokoban.xpm",       "script_file.xpm",
"bug.xpm",            "ghost.xpm",         "kspread.xpm",        "script_link.xpm",
"calc2.xpm",          "gif.xpm",           "ksysguard.xpm",      "script_plain.xpm",
"calc.xpm",           "gimp.xpm",          "ksysv.xpm",          "script.xpm",
"camera.xpm",         "gnorpm.xpm",        "kthememgr.xpm",      "scsi.xpm",
"cdrom.xpm",          "gnu.xpm",           "ktron.xpm",          
"cervisia.xpm",       "graph.xpm",         "kuickshow.xpm",      "sounds2.xpm",
"chess2.xpm",         "gvim.xpm",          "kuser.xpm",          "sounds.xpm",
"chess3.xpm",         "gv.xpm",            "kviewshell.xpm",     "sound.xpm",
"chess.xpm",          "hammer.xpm",        "kwin.xpm",           "stuff.xpm",
"chip.xpm",           "harddrive.xpm",     "kword.xpm",          "stylesheet.xpm",
"circuit2.xpm",       "helpme.xpm",        "licq.xpm",           "style.xpm",
"circuit.xpm",        "hex.xpm",           "link_shadow.xpm",    "suitcase.xpm",
"clip_file.xpm",      "home2.xpm",         "link.xpm",           "susehelpcenter.xpm",
"clip_folder.xpm",    "home.xpm",          "lisp.xpm",           "system.xpm",
"clip.xpm",           "html.xpm",          "list.xpm",           "tape_net.xpm",
"compressed.xpm",     "hwinfo.xpm",        "lnxzip.xpm",         "tape.xpm",
"compress.xpm",       "icons.xpm",         "locale.xpm",         "tar.xpm",
"cookie.xpm",         "icon.xpm",          "lyx.xpm",            "teddy.xpm",
"core.xpm",           "iff.xpm",           "mag_glass.xpm",      "term.xpm",
"cycle.xpm",          "info.xpm",          "magic.xpm",          "text.xpm",
"data.xpm",           "jpeg.xpm",          "mailfolder.xpm",     "tex.xpm",
"date.xpm",           "kaboodle.xpm",      "mail.xpm",           "tiff.xpm",
"debug.xpm",          "kalarm.xpm",        "makefile.xpm",       "tmpfile.xpm",
"designer.xpm",       "karm.xpm",          "make.xpm",           "tools.xpm",
"dev_cdrom.xpm",      "kasteroids.xpm",    "manpage.xpm",        "trash_empty.xpm",
"dev_floppy.xpm",     "kbackgammon.xpm",   "manual.xpm",         "trash_full.xpm",
"dev_harddrive.xpm",  "kcalc.xpm",         "mathematica.xpm",    "typewriter.xpm",
"diff.xpm",           "kchart.xpm",        "memory.xpm",         "url.xpm",
"dlgedit.xpm",        "kcoloredit.xpm",    "midi.xpm",           "usb.xpm",
"dot_a.xpm",          "kcontrol.xpm",      "modem.xpm",          "uu.xpm",
"dot_cc.xpm",         "kcron.xpm",         "mouse.xpm",          "video.xpm",
"dot_c.xpm",          "kdat.xpm",          "movies.xpm",         "wabi.xpm",
"dot_h.xpm",          "kdf.xpm",           "mozilla.xpm",        "windows.xpm",
"dot_o.xpm",          "kdict.xpm",         "multimedia.xpm",     "winprops.xpm",
"dot_sa.xpm",         "kdmconfig.xpm",     "music.xpm",          "winzip.xpm",
"dot_so.xpm",         "kedit.xpm",         "nedit.xpm",          "wizard.xpm",
"draw2.xpm",          "kenolaba.xpm",      "netscape.xpm",       "wp.xpm",
"draw.xpm",           "kfax.xpm",          "news.xpm",           "write.xpm",
"dvi.xpm",            "kfloppy.xpm",       "noatun.xpm",         "writings.xpm",
"editor.xpm",         "kfm.xpm",           "opera.xpm",          "xapp.xpm",
"editres.xpm",        "kfract.xpm",        "paint2.xpm",         "xbm.xpm",
"edit.xpm",           "khelpcenter.xpm",   "paintings.xpm",      "xclipboard.xpm",
"ee.xpm",             "khexedit.xpm",      "paint.xpm",          "xclock.xpm",
"emacs.xpm",          "kicker.xpm",        "paragraphs.xpm",     "xeyes.xpm",
"email.xpm",          "kiconedit.xpm",     "password.xpm",       "xfig2.xpm",
"empty.xpm",          "kjots.xpm",         "pbm.xpm",            "xfig.xpm",
"exec2.xpm",          "kjumpingcube.xpm",  "pci.xpm",            "xfmail.xpm",
"exec.xpm",           "klines.xpm",        "pdf.xpm",            "xload.xpm",
"fig.xpm",            "klipper.xpm",       "penguin.xpm",        "xlogo.xpm",
"file_bad.xpm",       "kljettool.xpm",     "pgm.xpm",            "xmag.xpm",
"file_link_bad.xpm",  "klpq.xpm",          "pharmacy.xpm",       "xmcd.xpm",
"file_link.xpm",      "kmahjongg.xpm",     "pictures.xpm",       "xmms.xpm",
"fileman.xpm",        "kmidi.xpm",         "plan.xpm",           "xosview.xpm",
"fileserver.xpm",     "kmid.xpm",          "plaster.xpm",        "xpaint.xpm",
"files.xpm",          "kmines.xpm",        "ppm.xpm",            "xplate.xpm",
"filetypes.xpm",      "knotes.xpm",        "printer2.xpm",       "xrolodex.xpm",
"file.xpm",           "korn.xpm",          "printer3.xpm",       "xterm.xpm",
"find.xpm",           "kpackage.xpm",      "printer.xpm",        "xv2.xpm",
"fish.xpm",           "kpaint.xpm",        "printmgr.xpm",       "xv.xpm",
"floppy.xpm",         "kpat.xpm",          "processor.xpm",      "x.xpm",
"folder_bad.xpm",     "kpoker.xpm",        "proxy.xpm",          "zip.xpm",
"folder_link.xpm",    "kppp.xpm",          "ps2.xpm",            "zoo.xpm",
"folder_up.xpm",      "kpresenter.xpm",    "ps.xpm",
"folder.xpm",         "kreversi.xpm",      "pybliographic.xpm",  NULL,
};	

static char *small_names[] = {
	"app_link_small.xpm",  "bookshelf_small.xpm",  "file_link_bad_small.xpm",  "file_small.xpm",
	"folder_link_small.xpm",  "folder_up_small.xpm",  "link_shadow_small.xpm", "app_small.xpm",
	"file_bad_small.xpm",   "file_link_small.xpm",      "folder_bad_small.xpm",  "folder_small.xpm",
	"home_small.xpm",       "link_small.xpm", NULL,
};

/*static char *small_names[] = {

    "file_small.xpm", "file_bad_small.xpm", "file_link_small.xpm",
    "file_link_bad_small.xpm",
    "folder_small.xpm", "folder_bad_small.xpm", "folder_up_small.xpm",
    "folder_link_small.xpm",
    "app_small.xpm", "app_link_small.xpm",

    NULL,
};*/


Widget        toplevel, form, prs, ibox, rclist, mlist, button1, button2, button3, button4, button5, button6;
	XtAppContext app;


const char tstring1[]="String1";
const char tstring2[]="String2";
const char tstring3[]="String3";
const char tstring4[]="String4";
const char tstring5[]="String5";
const char tstring6[]="String6";
const char tstring7[]="i";

int string_count=7;

XmNlCell * data_massiv;
XmNlCell *MyItem;

int item_num=50;
int shift=20;

const char MyString[20]="my_string";
const char MyStringOther[20]="my_string_number_2";
const char icon_prefix[30]="./icons/";
char icon_name[100];
Pixmap small_pix[icon_small_n];
Pixmap small_mask[icon_small_n];
Pixmap big_pix[icon_big_n];
Pixmap big_mask[icon_big_n];
String sstr1;
String sstr2;
String sstr3;
String sstr4;

String str1[100];
String str2[100];
String str3[100];

Dimension col_size[4];

int Width[6], f_width;;
int col_count=6, row_count=500;


void CreatePixmaps(void)
{

	int i;
	for (i=0; i<icon_small_n; i++)
	{
		sprintf(icon_name, "%s%s", icon_prefix, small_names[i]);
		XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), icon_name,
			      &(small_pix[i]), &(small_mask[i]), (XpmAttributes *) NULL);
		}

	for (i=0; i<icon_big_n; i++)
	{
		sprintf(icon_name, "%s%s", icon_prefix, big_names[i]);
		XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), icon_name,
			      &(big_pix[i]), &(big_mask[i]), (XpmAttributes *) NULL);
		}
	
}

	

void CreateIcons(void)
{
	int k, i;
	MyItem=malloc(item_num*sizeof(XmNlCell));
	k=0;
	for (i=0; i<item_num; i++)
	{
		if (k>=icon_big_n) k=0;
		MyItem[i].text=calloc(strlen(MyString)+5, 1);
		sprintf(MyItem[i].text, "%s %d", MyString, i);
		MyItem[i].pixmap=big_pix[k];
		MyItem[i].mask=big_mask[k];
		MyItem[i].xmlabel = XmStringCreateLocalized(MyItem[i].text);
//		MyItem[i].selected=False;
//		Select= !Select;
		k++;
	}
}

void CreateRows(void)
{
	int i, j, k, n;
	data_massiv=(XmNlCell *) XtMalloc(col_count*row_count*sizeof(XmNlCell));
	k=0;
	n=0;
	for (i=0; i<row_count; i++)
	{
		if (k>=icon_small_n) k=0;
			for (j=0; j<col_count; j++)
			{
		data_massiv[n].text=(char *)calloc(strlen(MyString)+15, 1);
		sprintf(data_massiv[n].text, "%s col %d row %d", MyString, j, i);
		if (j == col_count - 1)
			data_massiv[n].xmlabel = NULL;
		else
			data_massiv[n].xmlabel = XmStringCreateLocalized(data_massiv[n].text);

		if (j==1)
			{
			data_massiv[n].pixmap=small_pix[k];
			data_massiv[n].mask=small_mask[k];
			k++;
			}
		else
			{
			data_massiv[n].pixmap=XmUNSPECIFIED_PIXMAP;
			data_massiv[n].mask=XmUNSPECIFIED_PIXMAP;
			}
			n++;
			}
		}
}


void Btn1Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	printf("To BigList\n");
	XtVaSetValues(mlist,
			XmNViewListType, XmNlList_Big,
			NULL);
	printf("Big List ok\n");
}

void Btn2Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	int i;
	Widget rc;
	XmNlColSpecRec * colspec;
	XmString motif_string = NULL;
	Arg           args[10];
	int           n;
	char tmpstring[50];
	
	XtVaSetValues(mlist, XmNViewListType, XmNlList_Detail, NULL);
//	XmNlListSetAutoresCol(mlist, 1);
//return ;

	rc = XmNlListGetRCWidget(mlist);
//	XmNlRCTreeDeleteAllItems(rc);

	for (i = 0; i < col_count; i++)
	{
		n = 0;
		XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
		if (i == 0) 
		{
//			XtSetArg( args[n], XmNcolType, XmPIXMAP); n++;
			XtSetArg( args[n], XmNcolType, XmSTRING); n++;
			XtSetArg( args[n], XmNtileType, XmPIXMAP); n++;
			XtSetArg( args[n], XtNtilePixmap, small_pix[i]); n++;
			XtSetArg( args[n], XtNtilePixmapMask, small_mask[i]); n++;

		}
		if (i == 1)
		{
			XtSetArg( args[n], XmNcolType, XmPIXMAP); n++;
//			XtSetArg( args[n], XmNcolType, XmSTRING); n++;
			XtSetArg( args[n], XmNtileType, XmSTRING); n++;
//			XtSetArg( args[n], XtNtilePixmap, small_pix[i]); n++;
//			XtSetArg( args[n], XtNtilePixmapMask, small_mask[i]); n++;

			tmpstring[0] = '\0';
			sprintf(tmpstring, "Column %d", i);
			motif_string = XmStringCreateLocalized(tmpstring);
			XtSetArg( args[n], XmNlabelString, motif_string); n++;
			XtSetArg( args[n], XmNpixmapPlacement,  XmPIXMAP_LEFT); n++;
		} 
		if (i == 2)
		{
//			XtSetArg( args[n], XmNcolType, XmPIXMAP); n++;
			XtSetArg( args[n], XmNcolType, XmSTRING); n++;
			XtSetArg( args[n], XmNtileType, XmPIXMAP_AND_STRING); n++;
			XtSetArg( args[n], XtNtilePixmap, small_pix[i]); n++;
			XtSetArg( args[n], XtNtilePixmapMask, small_mask[i]); n++;

			tmpstring[0] = '\0';
			sprintf(tmpstring, "Column %d", i);
			motif_string = XmStringCreateLocalized(tmpstring);
			XtSetArg( args[n], XmNlabelString, motif_string); n++;
			XtSetArg( args[n], XmNpixmapPlacement,  XmPIXMAP_LEFT); n++;
		} 
		if (i != 0 && i != 1 && i != 2)
		{
			XtSetArg( args[n], XmNcolType, XmSTRING); n++;
			XtSetArg( args[n], XmNtileType, XmSTRING); n++;
			tmpstring[0] = '\0';
			sprintf(tmpstring, "Column %d", i);
			motif_string = XmStringCreateLocalized(tmpstring);
			XtSetArg( args[n], XmNlabelString, motif_string); n++;
		}

		colspec = XmNlColSpecCreate(XtDisplay(form), NULL, tmpstring, args, n);
		printf("********************************** Append column %d\n", i);
		XmNlResColAppendColumn(rc, colspec);
		if (motif_string)
		{
			XmStringFree(motif_string);
			motif_string = NULL;
		}
		XmNlColSpecFree(colspec);
	}

//	XmNlListSetAutoresCol(mlist, 1);
}

void Btn3Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	unsigned char mask = 0 | CellXmString | CellPixmap | CellMask | CellCharString | CellUserData ;
	XmNlListAddItems(mlist, MyItem, item_num, mask);

//	XmNlListAddCells(mlist, item_num, MyItem);
	
}

void Btn4Callback(Widget w, XtPointer client_data, XtPointer call_data)
{

	unsigned char mask = 0 | CellXmString | CellPixmap | CellMask | CellCharString | CellUserData ;

//	XmNlListSetProperty(mlist, col_count, record);
//	printf("xmlist1: Set property succes\n");				
//	XmNlListSetAutoresCol(mlist, 2);
//	printf("xmlist1: Set AutoresCol succes\n");				
	XmNlListAddRows(mlist, data_massiv, row_count, mask);
	printf("xmlist1: Add Rows succes\n");				
	
}

void Btn5Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	Widget rc;
	XmNlColSpecRec * colspec;
	XmString motif_string;

	Arg           args[10];
	int           n;

	XtVaSetValues(mlist,
			XmNViewListType, XmNlList_TreeCol,
			NULL);
	rc = XmNlListGetRCWidget(mlist);



	n = 0;
	XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
	XtSetArg( args[n], XmNcolType, XmSTRING); n++;
	XtSetArg( args[n], XmNtileType, XmSTRING); n++;
	motif_string = XmStringCreateLocalized("Column1");

	colspec = XmNlColSpecCreate(XtDisplay(form), NULL, "col1", args, n);
	XmNlResColAppendColumn(rc, colspec);
/********************************************/
	motif_string = XmStringCreateLocalized("Column2");
	n = 0;
	XtSetArg( args[n], XmNalignment, XmALIGNMENT_END); n++;
	XtSetArg( args[n], XmNcolType, XmSTRING); n++;
	XtSetArg( args[n], XmNtileType, XmSTRING); n++;
	XtSetArg( args[n], XmNlabelString, motif_string); n++;

	colspec = XmNlColSpecCreate(XtDisplay(form), NULL, "col2", args, n);
	XmNlResColAppendColumn(rc, colspec);
/********************************************/
	n = 0;
	XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
	XtSetArg( args[n], XmNcolType, XmSTRING); n++;
	XtSetArg( args[n], XmNtileType, XmSTRING); n++;

	colspec = XmNlColSpecCreate(XtDisplay(form), NULL, "col3", args, n);
	XmNlResColAppendColumn(rc, colspec);
/********************************************/
	n = 0;
	XtSetArg( args[n], XmNalignment, XmALIGNMENT_END); n++;
	XtSetArg( args[n], XmNcolType, XmSTRING); n++;
	XtSetArg( args[n], XmNtileType, XmSTRING); n++;

	colspec = XmNlColSpecCreate(XtDisplay(form), NULL, "col4", args, n);
	XmNlResColAppendColumn(rc, colspec);
/********************************************/
	n = 0;
	XtSetArg( args[n], XmNalignment, XmALIGNMENT_END); n++;
	XtSetArg( args[n], XmNcolType, XmSTRING); n++;
	XtSetArg( args[n], XmNtileType, XmSTRING); n++;

	colspec = XmNlColSpecCreate(XtDisplay(form), NULL, "col5", args, n);
	XmNlResColAppendColumn(rc, colspec);
/********************************************/

	motif_string = XmStringCreateLocalized("Column6");
	n = 0;
	XtSetArg( args[n], XmNalignment, XmALIGNMENT_END); n++;
	XtSetArg( args[n], XmNcolType, XmSTRING); n++;
	XtSetArg( args[n], XmNtileType, XmSTRING); n++;
	XtSetArg( args[n], XmNlabelString, motif_string); n++;

	colspec = XmNlColSpecCreate(XtDisplay(form), NULL, "col6", args, n);
	XmNlResColAppendColumn(rc, colspec);
/********************************************/



/*	XmNlListSetColNum(mlist, col_count);
	XmNlListSetProperty(mlist, col_count, record);
	printf("xmlist1: Set property succes\n");				
	XmNlListSetAutoresCol(mlist, 1);
	printf("xmlist1: Set AutoresCol succes\n");				
	XmNlListAddRows(mlist, row_count, data_massiv);
	printf("xmlist1: Add Rows succes\n");		*/		
	
}

void Btn6Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	unsigned char mask = 0 | CellXmString | CellPixmap | CellMask | CellCharString | CellUserData ;

char test[64];
XmNlListTreeItem *level1,*level2,*level3,*level4;
int i,j,k,l, n;

printf("example col count %d\n", col_count);

n = 0;

	for (i=0; i<5; i++) {
		sprintf(test,"%c Level #1, entry #%d",
			(char)('Z'-i),i);
		level1=XmNlListTreeAddBranch(mlist, NULL, &(data_massiv[n]), mask);
		n=n+col_count;
		for (j=0; j<i; j++) {
			sprintf(test,"%c Level #2, entry #%d",
				(char)('Z'-j),j);
			level2=XmNlListTreeAddBranch(mlist, level1, &(data_massiv[n]),mask);
			n=n+col_count;
			for (k=0; k<i; k++) {
				sprintf(test,"%c Level #3, entry #%d",
					(char)('Z'-k),k);
				level3=XmNlListTreeAddBranch(mlist, level2, &(data_massiv[n]), mask);
				n=n+col_count;
				for (l=0; l<i; l++) {
					sprintf(test,"%c Level #4, entry #%d",
						(char)('Z'-l),l);
					level4=XmNlListTreeAddLeaf(mlist, level3, &(data_massiv[n]), mask);
					n=n+col_count;
				}
			}
		}
	}


/*	XmNlListSetColNum(mlist, col_count);
	XmNlListSetProperty(mlist, col_count, record);
	printf("xmlist1: Set property succes\n");				
	XmNlListSetAutoresCol(mlist, 1);
	printf("xmlist1: Set AutoresCol succes\n");				
	XmNlListAddRows(mlist, row_count, data_massiv);
	printf("xmlist1: Add Rows succes\n");		*/		
XmNlListTreeRefresh(mlist);	
}

void hgl_callback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ListItemReturnStruct * rez = (ListItemReturnStruct *) call_data;
	int i;
	for (i=0; i<rez->count; i++)
	{
		printf("xmnllist4: selected item=%d\n", rez->number[i]);
	}
}


void dblclk_callback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ItemActivateReturnStruct * rez = (ItemActivateReturnStruct *) call_data;

	printf("xmnllist4: activated item=%d\n", rez->item_number);
}


int main(int argc, char **argv)
{
	Arg args[10];
	int n;

	XtSetLanguageProc (NULL, NULL, NULL);
	toplevel = XtVaOpenApplication (&app, "Demos", NULL, 0, &argc, argv,
                             NULL, sessionShellWidgetClass, NULL);
//	toplevel = XtVaOpenApplication (&app, "Demos", NULL, 0, &argc, argv,
//                             NULL, sessionShellWidgetClass, XmNlayoutDirection, XmRIGHT_TO_LEFT_BOTTOM_TO_TOP, NULL);

	n = 0;
//	XtSetArg (args[n], XmNwidth, 500); n++;
//	XtSetArg (args[n], XmNheight, 300); n++;
//	XtSetArg (args[n], XmNscrollingPolicy, XmAPPLICATION_DEFINED); n++;

	CreatePixmaps();
	CreateIcons();
	CreateRows();

	n=0;
	form = XmCreateForm (toplevel, "Form",   args, n);
	
	printf("xmlist1: Form Created\n");

	mlist = XtVaCreateWidget ("xmnllist", xmNlListWidgetClass, form, NULL);
//	mlist = XtVaCreateWidget ("xmnllist", xmNlListWidgetClass, form, XmNViewListType, XmNlList_TreeCol, NULL);

	printf("xmlist1: Mlist Created\n");


	printf("xmlist1: Mlist Configured\n");

	button1 = XmCreatePushButton(form, "Big Mode", NULL, 0);
	button2 = XmCreatePushButton(form, "List Mode", NULL, 0);
	button3 = XmCreatePushButton(form, "Add Big Icons", NULL, 0);
	button4 = XmCreatePushButton(form, "Add List Rows", NULL, 0);
	button5 = XmCreatePushButton(form, "Tree Mode", NULL, 0);
	button6 = XmCreatePushButton(form, "Add Tree", NULL, 0);

	XtVaSetValues(mlist,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button1,
//			XmNheight, 300,
			NULL);

	XtAddCallback(button1, XmNactivateCallback, Btn1Callback, (XtPointer) NULL);
	XtAddCallback(button2, XmNactivateCallback, Btn2Callback, (XtPointer) NULL);
	XtAddCallback(button3, XmNactivateCallback, Btn3Callback, (XtPointer) NULL);
	XtAddCallback(button4, XmNactivateCallback, Btn4Callback, (XtPointer) NULL);
	XtAddCallback(button5, XmNactivateCallback, Btn5Callback, (XtPointer) NULL);
	XtAddCallback(button6, XmNactivateCallback, Btn6Callback, (XtPointer) NULL);
	XtAddCallback(mlist, XtNhighlightCallback, hgl_callback, (XtPointer) NULL); 
	XtAddCallback(mlist, XmNdoubleClickCallback, dblclk_callback, (XtPointer) NULL); 
	XtVaSetValues(button1,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, mlist,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button2,
//			XmNbottomAttachment, XmATTACH_FORM,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(button2,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button1,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button3,
//			XmNbottomAttachment, XmATTACH_FORM,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(button3,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button2,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button4,
//			XmNbottomAttachment, XmATTACH_FORM,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(button4,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button3,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
//			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomWidget, button5,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(button5,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button3,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
//			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomWidget, button6,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(button6,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button3,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_FORM,
//			XmNbottomWidget, button,
//			XmNheight, 300,
			NULL);


  XtManageChild (form);
  XtManageChild (mlist);
  XtManageChild (button1);
  XtManageChild (button2);
  XtManageChild (button3);
  XtManageChild (button4);
  XtManageChild (button5);
  XtManageChild (button6);
  XtRealizeWidget (toplevel);
  
  XtAppMainLoop (app);
  return 0;
}
