#include <Xm/XmAll.h>
#include <pwd.h>
#include <Xm/PushB.h>
#include <Xm/Form.h>
#include "XmNlPartRes.h"
#include "XmNlResColList.h"
#include "XmNl.h"
#include "XmNlList.h"
#include <string.h>
#include <X11/cursorfont.h>
#include <X11/xpm.h>
#include <stdlib.h>


#define icon_big_n 293
#define icon_small_n 14
#define CompareFromBigToSmall 1
#define CompareFromSmallToBig 2


static char *big_names[] = {
"acroread.xpm",       "fonts.xpm",         "kruler.xpm",         "pysol.xpm",
"applications.xpm",   "font.xpm",          "ksame.xpm",          "raster.xpm",
"app_link.xpm",       "framemaker.xpm",    "kscd.xpm",           "rc.xpm",
"app_plain.xpm",      "games_arcade.xpm",  "kscreensaver.xpm",   "readme.xpm",
"app.xpm",            "games_board.xpm",   "kshisen.xpm",        "realplayer.xpm",
"ark.xpm",            "games_card.xpm",    "ksirtet.xpm",        "recycle.xpm",
"blender.xpm",        "games.xpm",         "ksmiletris.xpm",     "redhat.xpm",
"bluelogo.xpm",       "gears2.xpm",        "ksnake.xpm",         "res.xpm",
"bookshelf.xpm",      "gears.xpm",         "ksnapshot.xpm",      "samba.xpm",
"book.xpm",           "ghostview.xpm",     "ksokoban.xpm",       "script_file.xpm",
"bug.xpm",            "ghost.xpm",         "kspread.xpm",        "script_link.xpm",
"calc2.xpm",          "gif.xpm",           "ksysguard.xpm",      "script_plain.xpm",
"calc.xpm",           "gimp.xpm",          "ksysv.xpm",          "script.xpm",
"camera.xpm",         "gnorpm.xpm",        "kthememgr.xpm",      "scsi.xpm",
"cdrom.xpm",          "gnu.xpm",           "ktron.xpm",          
"cervisia.xpm",       "graph.xpm",         "kuickshow.xpm",      "sounds2.xpm",
"chess2.xpm",         "gvim.xpm",          "kuser.xpm",          "sounds.xpm",
"chess3.xpm",         "gv.xpm",            "kviewshell.xpm",     "sound.xpm",
"chess.xpm",          "hammer.xpm",        "kwin.xpm",           "stuff.xpm",
"chip.xpm",           "harddrive.xpm",     "kword.xpm",          "stylesheet.xpm",
"circuit2.xpm",       "helpme.xpm",        "licq.xpm",           "style.xpm",
"circuit.xpm",        "hex.xpm",           "link_shadow.xpm",    "suitcase.xpm",
"clip_file.xpm",      "home2.xpm",         "link.xpm",           "susehelpcenter.xpm",
"clip_folder.xpm",    "home.xpm",          "lisp.xpm",           "system.xpm",
"clip.xpm",           "html.xpm",          "list.xpm",           "tape_net.xpm",
"compressed.xpm",     "hwinfo.xpm",        "lnxzip.xpm",         "tape.xpm",
"compress.xpm",       "icons.xpm",         "locale.xpm",         "tar.xpm",
"cookie.xpm",         "icon.xpm",          "lyx.xpm",            "teddy.xpm",
"core.xpm",           "iff.xpm",           "mag_glass.xpm",      "term.xpm",
"cycle.xpm",          "info.xpm",          "magic.xpm",          "text.xpm",
"data.xpm",           "jpeg.xpm",          "mailfolder.xpm",     "tex.xpm",
"date.xpm",           "kaboodle.xpm",      "mail.xpm",           "tiff.xpm",
"debug.xpm",          "kalarm.xpm",        "makefile.xpm",       "tmpfile.xpm",
"designer.xpm",       "karm.xpm",          "make.xpm",           "tools.xpm",
"dev_cdrom.xpm",      "kasteroids.xpm",    "manpage.xpm",        "trash_empty.xpm",
"dev_floppy.xpm",     "kbackgammon.xpm",   "manual.xpm",         "trash_full.xpm",
"dev_harddrive.xpm",  "kcalc.xpm",         "mathematica.xpm",    "typewriter.xpm",
"diff.xpm",           "kchart.xpm",        "memory.xpm",         "url.xpm",
"dlgedit.xpm",        "kcoloredit.xpm",    "midi.xpm",           "usb.xpm",
"dot_a.xpm",          "kcontrol.xpm",      "modem.xpm",          "uu.xpm",
"dot_cc.xpm",         "kcron.xpm",         "mouse.xpm",          "video.xpm",
"dot_c.xpm",          "kdat.xpm",          "movies.xpm",         "wabi.xpm",
"dot_h.xpm",          "kdf.xpm",           "mozilla.xpm",        "windows.xpm",
"dot_o.xpm",          "kdict.xpm",         "multimedia.xpm",     "winprops.xpm",
"dot_sa.xpm",         "kdmconfig.xpm",     "music.xpm",          "winzip.xpm",
"dot_so.xpm",         "kedit.xpm",         "nedit.xpm",          "wizard.xpm",
"draw2.xpm",          "kenolaba.xpm",      "netscape.xpm",       "wp.xpm",
"draw.xpm",           "kfax.xpm",          "news.xpm",           "write.xpm",
"dvi.xpm",            "kfloppy.xpm",       "noatun.xpm",         "writings.xpm",
"editor.xpm",         "kfm.xpm",           "opera.xpm",          "xapp.xpm",
"editres.xpm",        "kfract.xpm",        "paint2.xpm",         "xbm.xpm",
"edit.xpm",           "khelpcenter.xpm",   "paintings.xpm",      "xclipboard.xpm",
"ee.xpm",             "khexedit.xpm",      "paint.xpm",          "xclock.xpm",
"emacs.xpm",          "kicker.xpm",        "paragraphs.xpm",     "xeyes.xpm",
"email.xpm",          "kiconedit.xpm",     "password.xpm",       "xfig2.xpm",
"empty.xpm",          "kjots.xpm",         "pbm.xpm",            "xfig.xpm",
"exec2.xpm",          "kjumpingcube.xpm",  "pci.xpm",            "xfmail.xpm",
"exec.xpm",           "klines.xpm",        "pdf.xpm",            "xload.xpm",
"fig.xpm",            "klipper.xpm",       "penguin.xpm",        "xlogo.xpm",
"file_bad.xpm",       "kljettool.xpm",     "pgm.xpm",            "xmag.xpm",
"file_link_bad.xpm",  "klpq.xpm",          "pharmacy.xpm",       "xmcd.xpm",
"file_link.xpm",      "kmahjongg.xpm",     "pictures.xpm",       "xmms.xpm",
"fileman.xpm",        "kmidi.xpm",         "plan.xpm",           "xosview.xpm",
"fileserver.xpm",     "kmid.xpm",          "plaster.xpm",        "xpaint.xpm",
"files.xpm",          "kmines.xpm",        "ppm.xpm",            "xplate.xpm",
"filetypes.xpm",      "knotes.xpm",        "printer2.xpm",       "xrolodex.xpm",
"file.xpm",           "korn.xpm",          "printer3.xpm",       "xterm.xpm",
"find.xpm",           "kpackage.xpm",      "printer.xpm",        "xv2.xpm",
"fish.xpm",           "kpaint.xpm",        "printmgr.xpm",       "xv.xpm",
"floppy.xpm",         "kpat.xpm",          "processor.xpm",      "x.xpm",
"folder_bad.xpm",     "kpoker.xpm",        "proxy.xpm",          "zip.xpm",
"folder_link.xpm",    "kppp.xpm",          "ps2.xpm",            "zoo.xpm",
"folder_up.xpm",      "kpresenter.xpm",    "ps.xpm",
"folder.xpm",         "kreversi.xpm",      "pybliographic.xpm",  NULL,
};	

static char *small_names[] = {
	"app_link_small.xpm",  "bookshelf_small.xpm",  "file_link_bad_small.xpm",  "file_small.xpm",
	"folder_link_small.xpm",  "folder_up_small.xpm",  "link_shadow_small.xpm", "app_small.xpm",
	"file_bad_small.xpm",   "file_link_small.xpm",      "folder_bad_small.xpm",  "folder_small.xpm",
	"home_small.xpm",       "link_small.xpm", NULL,
};

static char *names[] = {

    "file_small.xpm", "file_bad_small.xpm", "file_link_small.xpm",
    "file_link_bad_small.xpm",
    "folder_small.xpm", "folder_bad_small.xpm", "folder_up_small.xpm",
    "folder_link_small.xpm",
    "app_small.xpm", "app_link_small.xpm",

    NULL,
};

	Widget toplevel, form, prs, ibox, rclist, mlist, button1, button2, button3, button4, button5;
	Widget button6, button7, button8, button9, button10, button11, button12, button13;
	Widget spin_del, spin_mvfrom, spin_mvto, spin_set, button_del, button_move, button_set;
	Widget label_from, label_to, form_del, form_move, form_set;
	XtAppContext app;


const char tstring1[]="String1";
const char tstring2[]="String2";
const char tstring3[]="String3";
const char tstring4[]="String4";
const char tstring5[]="String5";
const char tstring6[]="String6";

const char titlestring1[]="Column 1";
const char titlestring2[]="Column 2";
const char titlestring3[]="Column 3";
const char titlestring4[]="Column 4";
const char titlestring5[]="Column 5";
const char titlestring6[]="Column 6";

int string_count=6;

XmNlCell * data_massiv;
XmNlCell * MyItem;
XmNlCell * MyItemSmall;
int * CountNumber;

int icon_n = 10;
//int item_num = 100;
int item_num = 50;


const char MyString[20]="my_string";
const char MyStringOther[20]="my_string_number_2";
const char icon_prefix[30]="./icons/";
char icon_name[100];
//XmItBoxInfo *MyItem;
Pixmap small_pix[icon_small_n];
Pixmap small_mask[icon_small_n];
Pixmap big_pix[icon_big_n];
Pixmap big_mask[icon_big_n];

Pixmap arrow_icon, arrow_mask;



Dimension col_size[4];

int Width[5], f_width;;
int col_count = 5, row_count = 10, row_in_list = 0;

int SortMode = CompareFromBigToSmall;
XmString BtSlabel, StBlabel;


void CreateArrowIcon(void)
{
	XPoint xpt1[4], xpt2[4], xpt3[4];
	XGCValues values;
	unsigned long mask;
	GC Pix_gc1, Pix_gc2, Pix_gc3, mask_gc;
	Pixel topShadow, bottomShadow, background_pixel;

	XtVaGetValues(mlist, XmNtopShadowColor, &topShadow, XmNbottomShadowColor, &bottomShadow, 
					XmNbackground, &background_pixel,NULL);

	arrow_icon = XCreatePixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), 
						20, 20, XDefaultDepthOfScreen(XtScreen(toplevel)));

	arrow_mask = XCreatePixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), 
						20, 20, 1);
	
	values.line_style = LineSolid;
	values.line_width = 1;
	values.fill_style = FillSolid;
	values.background = background_pixel;
	values.foreground = topShadow;
	values.function = GXcopy;

//	mask = GCFunction;
	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground | GCFunction;
	Pix_gc1 = XCreateGC(XtDisplay(toplevel), arrow_icon, mask, &values);
//	Pix_gc1 = XCreateGC(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), mask, &values);

	values.foreground = bottomShadow;

	Pix_gc2 = XCreateGC(XtDisplay(toplevel), arrow_icon, mask, &values);

	values.foreground = background_pixel;

	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCFunction;
	Pix_gc3 = XCreateGC(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), mask, &values);

	values.foreground = BlackPixelOfScreen(XtScreen(toplevel));
	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCFunction;

	mask_gc = XCreateGC(XtDisplay(toplevel), arrow_mask, mask, &values);

	XFillRectangle(XtDisplay(toplevel), arrow_mask, mask_gc, 0, 0, 20, 20);	

	values.function = GXinvert;
	XChangeGC(XtDisplay(toplevel), mask_gc, mask, &values);

	xpt1[0].x = 2;
	xpt1[0].y = 2;
	xpt1[1].x = 19;
	xpt1[1].y = 2;
	xpt1[2].x = 17;
	xpt1[2].y = 4;
	xpt1[3].x = 4;
	xpt1[3].y = 4;

	xpt2[0].x = 2;
	xpt2[0].y = 2;
	xpt2[1].x = 4;
	xpt2[1].y = 4;
	xpt2[2].x = 10;
	xpt2[2].y = 17;
	xpt2[3].x = 10;
	xpt2[3].y = 19;

	xpt3[0].x = 19;
	xpt3[0].y = 2;
	xpt3[1].x = 10;
	xpt3[1].y = 19;
	xpt3[2].x = 10;
	xpt3[2].y = 17;
	xpt3[3].x = 17;
	xpt3[3].y = 2;

/*	arrow_icon = XCreatePixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), 
						20, 20, XDefaultDepthOfScreen(XtScreen(toplevel)));

	arrow_mask = XCreatePixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), 
						20, 20, 1);
*/
	XFillRectangle(XtDisplay(toplevel), arrow_icon, Pix_gc3, 0, 0, 20, 20);	


	XFillPolygon(XtDisplay(toplevel), arrow_icon, Pix_gc1, xpt1, 4, Nonconvex, CoordModeOrigin);
	XFillPolygon(XtDisplay(toplevel), arrow_icon, Pix_gc1, xpt2, 4, Nonconvex, CoordModeOrigin);
	XFillPolygon(XtDisplay(toplevel), arrow_icon, Pix_gc2, xpt3, 4, Nonconvex, CoordModeOrigin);
	
	XFillPolygon(XtDisplay(toplevel), arrow_mask, mask_gc, xpt1, 4, Nonconvex, CoordModeOrigin);
	XFillPolygon(XtDisplay(toplevel), arrow_mask, mask_gc, xpt2, 4, Nonconvex, CoordModeOrigin);
	XFillPolygon(XtDisplay(toplevel), arrow_mask, mask_gc, xpt3, 4, Nonconvex, CoordModeOrigin);
}

void CreatePixmaps(void)
{
	int i;
	
	for (i=0; i<icon_small_n; i++)
	{
		sprintf(icon_name, "%s%s", icon_prefix, small_names[i]);
		XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), icon_name,
			      &(small_pix[i]), &(small_mask[i]), (XpmAttributes *) NULL);
		}

	for (i=0; i<icon_big_n; i++)
	{
		sprintf(icon_name, "%s%s", icon_prefix, big_names[i]);
		XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), icon_name,
			      &(big_pix[i]), &(big_mask[i]), (XpmAttributes *) NULL);
		}
}

	

void CreateIcons(void)
{
	int k, i;
	MyItem=malloc(item_num*sizeof(XmNlCell));
	k=0;
	for (i=0; i<item_num; i++)
	{
		if (k>=icon_big_n) k=0;
		MyItem[i].text=calloc(strlen(MyString)+5, 1);
		sprintf(MyItem[i].text, "%s %d", MyString, i);
		MyItem[i].pixmap=big_pix[k];
		MyItem[i].mask=big_mask[k];
		MyItem[i].xmlabel = XmStringCreateLocalized(MyItem[i].text);
		MyItem[i].UserDataPointer = MyItem[i].text;
//		MyItem[i].selected=False;
		k++;
	}
}

void CreateIconsSmall(void)
{
	int k, i;
	MyItemSmall=malloc(item_num*sizeof(XmNlCell));
	k=0;
	for (i=0; i<item_num; i++)
	{
		if (k>=icon_small_n) k=0;
		MyItemSmall[i].text=calloc(strlen(MyString)+5, 1);
		sprintf(MyItemSmall[i].text, "%s %d", MyString, i);
		MyItemSmall[i].pixmap=small_pix[k];
		MyItemSmall[i].mask=small_mask[k];
		MyItemSmall[i].xmlabel = XmStringCreateLocalized(MyItemSmall[i].text);
		MyItemSmall[i].UserDataPointer = MyItemSmall[i].text;
//		MyItem[i].selected=False;
		k++;
	}

}

void CreateRows(void)
{
	int i, j, k, n;
	data_massiv = (XmNlCell *) XtMalloc(col_count*row_count*sizeof(XmNlCell));
	CountNumber = (int *) XtMalloc(row_count*sizeof(int));
	k = 0;
	n = 0;
	for (i = 0; i < row_count; i++)
	{
		CountNumber[i] = i;
		if (k >= icon_small_n) k =0;

		for (j = 0; j < col_count; j++)
		{
			data_massiv[n].text = (char *) calloc(strlen(MyString) + 15, 1);
			if (j == 2)
			{
				sprintf(data_massiv[n].text, "%d", i);
//				CountNumber[i] = i;
			}
			else
			{
				sprintf(data_massiv[n].text, "%s col %d row %d", MyString, j, i);
//				CountNumber[i] = i;
			}
//			data_massiv[n].xmlabel = XmStringCreateLocalized(data_massiv[n].text);
			data_massiv[n].xmlabel = XmStringGenerate((XtPointer) data_massiv[n].text, NULL, XmMULTIBYTE_TEXT, 
														"rendition1");
			if (j == 2)
				data_massiv[n].UserDataPointer = (void *) (CountNumber + i);
			else
				data_massiv[n].UserDataPointer = data_massiv[n].text;

			if (j==0)
			{	
				data_massiv[n].pixmap=small_pix[k];
				data_massiv[n].mask=small_mask[k];
				k++;
			}
			else
			{
				data_massiv[n].pixmap= (Pixmap)NULL;
				data_massiv[n].mask=(Pixmap)NULL;
			}
			data_massiv[n].selected = False;
			n++;
		}
	}
}


int comparerRC(const void * ptr1, const void * ptr2)
{
	Widget rc;
	XmNlCell cell1, cell2;


	printf("UP\n");

	rc = XmNlListGetRCWidget(mlist);

	XmNlResColGetCellAtPointer(rc, &cell1, CellUserData, ptr1, 2);
	XmNlResColGetCellAtPointer(rc, &cell2, CellUserData, ptr2, 2);
	
	printf("1 arg = %d\n", *((int *) (cell1.UserDataPointer)));
	printf("2 arg = %d\n", *((int *) (cell2.UserDataPointer)));
	
	if (SortMode == CompareFromBigToSmall)
	{
		if (cell1.UserDataPointer > cell2.UserDataPointer)
			return -1;
		if (cell1.UserDataPointer == cell2.UserDataPointer)
			return 0;
		if (cell1.UserDataPointer < cell2.UserDataPointer)
			return 1;
	}
	else
	{
		if (cell1.UserDataPointer < cell2.UserDataPointer)
			return -1;
		if (cell1.UserDataPointer == cell2.UserDataPointer)
			return 0;
		if (cell1.UserDataPointer > cell2.UserDataPointer)
			return 1;
	}
}

int comparerIB(const void * ptr1, const void * ptr2)
{
	Widget ib;
	XmNlCell cell1, cell2;


	printf("UP\n");

	ib = XmNlListGetIBWidget(mlist);

	XmNlItBoxGetItemAtPointer(ib, &cell1, CellUserData, ptr1);
	XmNlItBoxGetItemAtPointer(ib, &cell2, CellUserData, ptr2);
	
	printf("1 arg = %s\n", (char *) (cell1.UserDataPointer));
	printf("2 arg = %s\n", (char *) (cell2.UserDataPointer));
	
	if (SortMode == CompareFromBigToSmall)
	{
		return strcmp((char *)(cell2.UserDataPointer), (char *)(cell1.UserDataPointer));
	}
	else
	{
		return strcmp((char *)(cell1.UserDataPointer), (char *)(cell2.UserDataPointer));
	}
}

/** Set big mode **/
void Btn1Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	XtVaSetValues(mlist,
			XmNViewListType, XmNlList_Big,
			NULL);
	row_in_list = 0;
}

/** Set Small icon Mode **/
void Btn2Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	XtVaSetValues(mlist,
			XmNViewListType, XmNlList_Small,
			NULL);
	row_in_list = 0;
}

/** Set List mode **/
void Btn3Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	int i;
	Widget rc;
	XmNlColSpecRec * colspec;
	XmString motif_string = NULL;
	Arg           args[10];
	int           n;
	char tmpstring[50], * tag;
	
	XtVaSetValues(mlist, XmNViewListType, XmNlList_Detail, NULL);
	XmNlListSetAutoresCol(mlist, 1);

	rc = XmNlListGetRCWidget(mlist);

	for (i = 0; i < col_count; i++)
	{
		n = 0;
		XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
//		XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_END); n++;
		if (i == 0) 
		{
			XtSetArg( args[n], XmNcolType, XmPIXMAP); n++;
//			XtSetArg( args[n], XmNcolType, XmSTRING); n++;
			XtSetArg( args[n], XmNtileType, XmPIXMAP); n++;
			XtSetArg( args[n], XtNtilePixmap, small_pix[i]); n++;
			XtSetArg( args[n], XtNtilePixmapMask, small_mask[i]); n++;
			tmpstring[0] = '\0';

//			XtSetArg( args[n], XmNtileType, XmSTRING); n++;
//			tmpstring[0] = '\0';
//			sprintf(tmpstring, "Column %d", i);
//			motif_string = XmStringCreateLocalized(tmpstring);
//			XtSetArg( args[n], XmNlabelString, motif_string); n++;
		}
		else
		{
			XtSetArg( args[n], XmNcolType, XmSTRING); n++;
			XtSetArg( args[n], XmNtileType, XmPIXMAP_AND_STRING); n++;
//			XtSetArg( args[n], XmNtileType, XmPIXMAP); n++;
//			XtSetArg( args[n], XmNtileType, XmSTRING); n++;
//			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_CENTER); n++;
//			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
//			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_END); n++;
			XtSetArg( args[n], XmNpixmapPlacement, XmPIXMAP_LEFT); n++;
//			XtSetArg( args[n], XmNpixmapPlacement, XmPIXMAP_RIGHT); n++;
			tmpstring[0] = '\0';
//			sprintf(tmpstring, "colspec%d", i);
			sprintf(tmpstring, "ColumnQ %d", i);
			motif_string = XmStringCreateLocalized(tmpstring);
			XtSetArg( args[n], XmNlabelString, motif_string); n++;
//			XtSetArg( args[n], XtNtilePixmap, arrow_icon); n++;
//			XtSetArg( args[n], XtNtilePixmapMask, arrow_mask); n++;
/*			XtSetArg( args[n], XtNtilePixmap, small_pix[i]); n++;
			XtSetArg( args[n], XtNtilePixmapMask, small_mask[i]); n++;*/
/*
			XtSetArg( args[n], XmNcolType, XmSTRING); n++;
			XtSetArg( args[n], XmNtileType, XmSTRING); n++;
			tmpstring[0] = '\0';
			sprintf(tmpstring, "Column %d", i);
			motif_string = XmStringCreateLocalized(tmpstring);
			XtSetArg( args[n], XmNlabelString, motif_string); n++;
*/
		}

		colspec = XmNlColSpecCreate(XtDisplay(form), rc, tmpstring, args, n);
		printf("********************************** Append column %d\n", i);
		XmNlResColAppendColumn(rc, colspec);
		if (motif_string)
		{
			XmStringFree(motif_string);
			motif_string = NULL;
		}
		XmNlColSpecFree(colspec);
	}

	for (i = 0; i < col_count; i++)
	{
		tag = XmNlResColGetColumnTag(rc, i);
		if (tag)
		{
			printf("Column %d with tag %s\n", i, tag);
			free(tag);
		}
	}

	row_in_list = 0;
//	XmNlListSetAutoresCol(mlist, 1);
}

/** Add Big Icons **/
void Btn4Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	unsigned char mask = 0 | CellXmString | CellPixmap | CellMask | CellCharString | CellUserData ;

	XmNlListAddItems(mlist, MyItem, item_num, mask);

//	XmNlListAddCells(mlist, item_num, MyItem);
}

/** Add Small Icons **/
void Btn5Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	unsigned char mask = 0 | CellXmString | CellPixmap | CellMask | CellCharString | CellUserData ;

	XmNlListAddItems(mlist, MyItemSmall, item_num, mask);

//	XmNlListAddCells(mlist, item_num, MyItem);
}

/** Add Rows **/
void Btn6Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	unsigned char mask = 0 | CellXmString | CellPixmap | CellMask | CellCharString | CellUserData ;
//	XmNlCell *cell = data_massiv;

//	printf("1 arg = %d\n", *((int *) ((cell + 2)->UserDataPointer)));
//	printf("2 arg = %d\n", *((int *) ((cell + 7)->UserDataPointer)));


//	XmNlListSetColNum(mlist, col_count);
	XmNlListAddRows(mlist, data_massiv, row_count, mask);
	row_in_list = row_in_list + row_count;
}


/** Get Selected Items **/
void Btn7Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	unsigned char mask = 0 | CellUserData ;
	Widget ib, rc;
	char mode;
	int i, *pos, count, item_num;
	Boolean ret;
	XmNlCell item;
	
	XtVaGetValues(mlist, XmNViewListType, &mode, NULL);
	
	if (mode == XmNlList_Big || mode == XmNlList_Small)
	{
		ib = XmNlListGetIBWidget(mlist);
		
		XtVaGetValues(ib, XmNitemCount, &item_num, NULL);
		printf("Item in list %d\n", item_num);
	}
	else
	{
		rc = XmNlListGetRCWidget(mlist);
		XtVaGetValues(rc, XmNitemCount, &item_num, NULL);
		printf("Item in list %d\n", item_num);
	}

	XtVaGetValues(mlist, XmNselectedPositionCount, &count, XmNselectedPositions, &pos, NULL);
	printf("Selected %d items\n", count);
		
	for (i = 0; i < count; i++)
	{
		ret = XmNlListGetItem(mlist, &item, mask, pos[i]);
		if (ret)
			printf("Selected %d position: %s\n", pos[i], (char *) item.UserDataPointer);
	}


/*	if (mode == XmNlList_Big || mode == XmNlList_Small)
	{
		printf("Get items from icon box\n");
		ib = XmNlListGetIBWidget(mlist);
		
		XtVaGetValues(ib, XmNselectedItemCount, &count, XmNselectedPositions, &pos, NULL);
		printf("Selected %d items\n", count);
		
		for (i = 0; i < count; i++)
		{
			ret = XmNlItBoxGetItem(ib, &item, mask, pos[i]);
			if (ret)
				printf("Selected %d position: %s\n", pos[i], item.UserDataPointer);
		}
		
	}
	else
	{
		printf("Get items from res col list\n");
		rc = XmNlListGetRCWidget(mlist);
		
		XtVaGetValues(rc, XmNselectedPositionCount, &count, XmNselectedPositions, &pos, NULL);
		printf("Selected %d rows\n", count);
		if (count == 1)
		{
			printf("Row %d\n", pos[0]);
		}
		for (i = 0; i < count; i++)
		{
			printf("Selected %d position\n", pos[i]);
		}
	}
*/
}

/** Set Selected Items **/
void Btn8Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	unsigned char mask = 0 | CellUserData ;
	Widget ib, rc;
	char mode;
	int i, pos[5], count;
	Boolean ret;
	XmNlCell item;

	count = 5;

	pos[0] = 1;
	pos[1] = 2;
	pos[2] = 3;
	pos[3] = 4;
	pos[4] = 5;
	
	XtVaSetValues(mlist, XmNselectedPositionCount, count, XmNselectedPositions, pos, NULL);

return;
	XtVaGetValues(mlist, XmNViewListType, &mode, NULL);

/*	XtVaGetValues(mlist, XmNselectedItemCount, &count, XmNselectedPositions, &pos, NULL);
	printf("Selected %d items\n", count);
		
	for (i = 0; i < count; i++)
	{
		ret = XmNlListGetItem(mlist, &item, mask, pos[i]);
		if (ret)
			printf("Selected %d position: %s\n", pos[i], (char *) item.UserDataPointer);
	}
*/

	if (mode == XmNlList_Big || mode == XmNlList_Small)
	{
		printf("Set selected items for icon box\n");
		ib = XmNlListGetIBWidget(mlist);
		
		XtVaSetValues(ib, XmNselectedPositionCount, count, XmNselectedPositions, pos, NULL);
		
	}
	else
	{
		printf("Set selected for res col list\n");
		rc = XmNlListGetRCWidget(mlist);
		
		XtVaSetValues(rc, XmNselectedPositionCount, count, XmNselectedPositions, pos, NULL);
	}

}


void Btn9Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	Widget rc, itbox;
	unsigned char c_mode;
	
	XtVaGetValues(mlist, XmNViewListType, &c_mode, NULL);

	if (c_mode == XmNlList_Detail)
	{
		rc = XmNlListGetRCWidget(mlist);

		XmNlResColSort(rc, 0, row_count, comparerRC);

		printf("SortMode == %d\n", SortMode);
	}
	else
	{
		itbox = XmNlListGetIBWidget(mlist);
		XmNlItBoxSort(itbox, 0, item_num, comparerIB);
	}

	if (SortMode == CompareFromBigToSmall)
	{
		SortMode = CompareFromSmallToBig;
		XtVaSetValues(button8, XmNlabelString, StBlabel, NULL);
	}
	else
	{
		SortMode = CompareFromBigToSmall;
		XtVaSetValues(button8, XmNlabelString, BtSlabel, NULL);
	}

}

/*** Move Column ***/
void Btn10Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	Widget rc;
	unsigned char c_mode;
	char * pname1 = XtName(spin_mvfrom);
	char * pname2 = XtName(spin_mvto);
	char * tname;
	char * value, * tag;
	int n, k, i;
	Widget textf;
	
	XtVaGetValues(mlist, XmNViewListType, &c_mode, NULL);

	if (c_mode == XmNlList_Detail)
	{
		rc = XmNlListGetRCWidget(mlist);
		
		tname = XtMalloc ((unsigned) strlen (pname1) + 4);
		sprintf (tname, "%s_TF", pname1);

		textf = XtNameToWidget(spin_mvfrom, tname);
		XtFree (tname);
		value = XmTextFieldGetString (textf); /* Caller frees */

		sscanf(value, "%d", &n);
		XtFree(value);

		tname = XtMalloc ((unsigned) strlen (pname2) + 4);
		sprintf (tname, "%s_TF", pname2);

		textf = XtNameToWidget(spin_mvto, tname);
		XtFree (tname);
		value = XmTextFieldGetString (textf); /* Caller frees */

		sscanf(value, "%d", &k);
		XtFree(value);

		XmNlResColMoveColumnTo(rc, n, k);


		printf("Move %d col to %d col\n", n, k);

		for (i = 0; i < col_count; i++)
		{
			tag = XmNlResColGetColumnTag(rc, i);
			if (tag)
			{
				printf("Column %d with tag %s\n", i, tag);
				n = XmNlResColGetColumnNum(rc, tag);
				printf("Column with tag %s found with num = %d\n", tag, n);
				free(tag);
			}
		}
	}
	else
		return ;
}

/*** Set Column ***/
void Btn11Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	unsigned char mask = 0 | CellXmString | CellUserData ;
	Widget rc;
	unsigned char c_mode;
	char * pname = XtName(spin_set);
	char * tname = XtMalloc ((unsigned) strlen (pname) + 4);
	char * value;
	Widget textf;
	int n, i;
	XmNlCell * col_data_massiv;
	
	XtVaGetValues(mlist, XmNViewListType, &c_mode, NULL);

	if (c_mode == XmNlList_Detail)
	{
		rc = XmNlListGetRCWidget(mlist);

		sprintf (tname, "%s_TF", pname);
		textf = XtNameToWidget(spin_set, tname);
		XtFree (tname);
		value = XmTextFieldGetString (textf); /* Caller frees */
		sscanf(value, "%d", &n);
		XtFree(value);
		
		col_data_massiv = (XmNlCell *) XtMalloc(row_in_list * sizeof(XmNlCell));
		for (i = 0; i < row_in_list; i++)
		{
			col_data_massiv[i].text = (char *)calloc(strlen(MyString) + 25, 1);
			sprintf(col_data_massiv[i].text, "%s new col %d row %d", MyString, n, i);
			col_data_massiv[i].xmlabel = XmStringCreateLocalized(col_data_massiv[i].text);
			col_data_massiv[i].pixmap = XmUNSPECIFIED_PIXMAP;
			col_data_massiv[i].mask = XmUNSPECIFIED_PIXMAP;
		}

		XmNlResColSetCol(rc, col_data_massiv, n, mask);

		printf("Set column %d\n", n);
	}
	else
		return ;
}

/*** Delete column ***/
void Btn12Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	Widget rc;
	unsigned char c_mode;
	int n;
	char * pname = XtName(spin_del);
	char * tname = XtMalloc ((unsigned) strlen (pname) + 4);
	char * value;
	Widget textf;
	
	XtVaGetValues(mlist, XmNViewListType, &c_mode, NULL);

	if (c_mode == XmNlList_Detail)
	{
		rc = XmNlListGetRCWidget(mlist);
		
		sprintf (tname, "%s_TF", pname);

		textf = XtNameToWidget(spin_del, tname);
		XtFree (tname);
		value = XmTextFieldGetString (textf); /* Caller frees */

		sscanf(value, "%d", &n);
	
		XtFree(value);

		XmNlResColDeleteColumn(rc, n);

		printf("Delete %d column\n", n);
	}
	else
		return ;
}

void Btn13Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	XtDestroyWidget(toplevel);
	XtAppSetExitFlag(app);
}


void hgl_callback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ListItemReturnStruct * rez = (ListItemReturnStruct *) call_data;
	int i;
	printf("xmnllist2 highlight callback\n");
	for (i=0; i<rez->count; i++)
	{
		printf("\txmnllist2 selected item=%d\n", rez->number[i]);
	}
}


void dblclk_callback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ItemActivateReturnStruct * rez = (ItemActivateReturnStruct *) call_data;

	printf("xmnllist1 activated item=%d\n", rez->item_number);
}

void title_clk_callback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ListTileActivateReturnStruct * rez = (ListTileActivateReturnStruct *) call_data;
	int column;
	

	printf("xmnllist1 title clicked to column %d\n", rez->col_number);
	XtVaGetValues(w, XmNlMarkedColumnNum, &column, NULL);
	printf("xmnllist1 current marked column %d\n", column);
	if (column != rez->col_number && rez->col_number != 0)
	{
		XtVaSetValues(w, XmNlMarkedColumnNum, rez->col_number, NULL);
	}
	
}

int main(int argc, char **argv)
{
	Arg           args[10];
	int           n;


	XtSetLanguageProc (NULL, NULL, NULL);
	toplevel = XtVaOpenApplication (&app, "Demos", NULL, 0, &argc, argv,
                             NULL, sessionShellWidgetClass, NULL);
//	toplevel = XtVaOpenApplication (&app, "Demos", NULL, 0, &argc, argv,
//                             NULL, sessionShellWidgetClass, XmNlayoutDirection, XmRIGHT_TO_LEFT_BOTTOM_TO_TOP, NULL);
	n = 0;
//	XtSetArg (args[n], XmNwidth, 500); n++;
//	XtSetArg (args[n], XmNheight, 300); n++;
//	XtSetArg (args[n], XmNscrollingPolicy, XmAPPLICATION_DEFINED); n++;

	CreatePixmaps();
	CreateIcons();
	CreateIconsSmall();
	CreateRows();
	StBlabel = XmStringCreateLocalized("Sort In Ascending Order");
	BtSlabel = XmStringCreateLocalized("Sort In Descending Order");



	n=0;
	form = XmCreateForm (toplevel, "Form",   args, n);
	
	printf("Form Created\n");

	n=0;
	XtSetArg (args[n], XmNlAutoMarkerPlacement, True); n++;
	XtSetArg (args[n], XmNlMarkedColumnNum, 1); n++;
	XtSetArg (args[n], XmNarrowDirection, XmARROW_DOWN); n++;

	mlist = XtCreateWidget ("xmnllist", xmNlListWidgetClass, form, args, n);
//	mlist = XtVaCreateWidget ("xmnllist", xmNlListWidgetClass, form, NULL);



	printf("Mlist Configured\n");

	CreateArrowIcon();

	n = 0;
	XtSetArg (args[n], XmNlabelString, BtSlabel); n++;

	button1 = XmCreatePushButton(form, "Big Icon Mode", NULL, 0);
	button2 = XmCreatePushButton(form, "Small Icon Mode", NULL, 0);
	button3 = XmCreatePushButton(form, "List Mode", NULL, 0);
	button4 = XmCreatePushButton(form, "Add Big Icons", NULL, 0);
	button5 = XmCreatePushButton(form, "Add Small Icons", NULL, 0);
	button6 = XmCreatePushButton(form, "Add Rows", NULL, 0);
	button7 = XmCreatePushButton(form, "Get Selected Items", NULL, 0);
	button8 = XmCreatePushButton(form, "Set Selected Items", NULL, 0);
	button9 = XmCreatePushButton(form, "Sort", args, n);

/**********************************************************/
	form_move = XmCreateForm (form, "FormMove", NULL, 0);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNspinBoxChildType, XmNUMERIC); n++;
	XtSetArg (args[n], XmNminimumValue, 0); n++;
	XtSetArg (args[n], XmNmaximumValue, col_count - 1); n++;
	XtSetArg (args[n], XmNincrementValue, 1); n++;
	XtSetArg (args[n], XmNeditable, TRUE); n++;
	XtSetArg (args[n], XmNcolumns, 5); n++;
	XtSetArg (args[n], XmNwrap, FALSE); n++;

	spin_mvto = XmCreateSimpleSpinBox(form_move, "spinto", args, n);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNrightWidget, spin_mvto); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;

	label_to = XmCreateLabel(form_move, "To", args, n);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNrightWidget, label_to); n++;
//	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
//	XtSetArg (args[n], XmNleftWidget, button_move); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNspinBoxChildType, XmNUMERIC); n++;
	XtSetArg (args[n], XmNminimumValue, 0); n++;
	XtSetArg (args[n], XmNmaximumValue, col_count - 1); n++;
	XtSetArg (args[n], XmNincrementValue, 1); n++;
	XtSetArg (args[n], XmNeditable, TRUE); n++;
	XtSetArg (args[n], XmNcolumns, 5); n++;
	XtSetArg (args[n], XmNwrap, FALSE); n++;

	spin_mvfrom = XmCreateSimpleSpinBox(form_move, "spinfrom", args, n);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNrightWidget, spin_mvfrom); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;

	button10 = XmCreatePushButton(form_move, "Move column", args, n);

/**************************************************************/

	form_set = XmCreateForm (form, "FormSet", NULL, 0);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNspinBoxChildType, XmNUMERIC); n++;
	XtSetArg (args[n], XmNminimumValue, 0); n++;
	XtSetArg (args[n], XmNmaximumValue, col_count - 1); n++;
	XtSetArg (args[n], XmNincrementValue, 1); n++;
	XtSetArg (args[n], XmNeditable, TRUE); n++;
	XtSetArg (args[n], XmNcolumns, 5); n++;
	XtSetArg (args[n], XmNwrap, FALSE); n++;

	spin_set = XmCreateSimpleSpinBox(form_set, "spinset", args, n);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNrightWidget, spin_set); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;

	button11 = XmCreatePushButton(form_set, "Set column", args, n);

/*******************************************************************/

	form_del = XmCreateForm (form, "FormDel", NULL, 0);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
//	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
//	XtSetArg (args[n], XmNleftWidget, button_del); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNspinBoxChildType, XmNUMERIC); n++;
	XtSetArg (args[n], XmNminimumValue, 0); n++;
	XtSetArg (args[n], XmNmaximumValue, col_count - 1); n++;
	XtSetArg (args[n], XmNincrementValue, 1); n++;
	XtSetArg (args[n], XmNeditable, TRUE); n++;
	XtSetArg (args[n], XmNcolumns, 5); n++;
	XtSetArg (args[n], XmNwrap, FALSE); n++;

	spin_del = XmCreateSimpleSpinBox(form_del, "spindel", args, n);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNrightWidget, spin_del); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;

	button12 = XmCreatePushButton(form_del, "Delete column", args, n);

/*********************************************************************/

	button13 = XmCreatePushButton(form, "Exit", NULL, 0);

	XtVaSetValues(mlist,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button1,
//			XmNheight, 300,
			NULL);

	XtAddCallback(button1, XmNactivateCallback, Btn1Callback, (XtPointer) NULL);
	XtAddCallback(button2, XmNactivateCallback, Btn2Callback, (XtPointer) NULL);
	XtAddCallback(button3, XmNactivateCallback, Btn3Callback, (XtPointer) NULL);
	XtAddCallback(button4, XmNactivateCallback, Btn4Callback, (XtPointer) NULL);
	XtAddCallback(button5, XmNactivateCallback, Btn5Callback, (XtPointer) NULL);
	XtAddCallback(button6, XmNactivateCallback, Btn6Callback, (XtPointer) NULL);
	XtAddCallback(button7, XmNactivateCallback, Btn7Callback, (XtPointer) NULL);
	XtAddCallback(button8, XmNactivateCallback, Btn8Callback, (XtPointer) NULL);
	XtAddCallback(button9, XmNactivateCallback, Btn9Callback, (XtPointer) NULL);
	XtAddCallback(button10, XmNactivateCallback, Btn10Callback, (XtPointer) NULL);
	XtAddCallback(button11, XmNactivateCallback, Btn11Callback, (XtPointer) NULL);
	XtAddCallback(button12, XmNactivateCallback, Btn12Callback, (XtPointer) NULL);
	XtAddCallback(button13, XmNactivateCallback, Btn13Callback, (XtPointer) NULL);

	XtAddCallback(mlist, XtNhighlightCallback, hgl_callback, (XtPointer) NULL); 
	XtAddCallback(mlist, XmNdoubleClickCallback, dblclk_callback, (XtPointer) NULL); 
	XtAddCallback(mlist, XmNlTileClickedCallback, title_clk_callback, (XtPointer) NULL); 
	XtVaSetValues(button1,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, mlist,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button2,
//			XmNbottomAttachment, XmATTACH_FORM,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(button2,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button1,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button3,
//			XmNbottomAttachment, XmATTACH_FORM,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(button3,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button2,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button4,
//			XmNbottomAttachment, XmATTACH_FORM,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(button4,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button2,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button5,
//			XmNbottomAttachment, XmATTACH_FORM,
//			XmNheight, 300,
			NULL);
	XtVaSetValues(button5,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button2,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button6,
//			XmNbottomAttachment, XmATTACH_FORM,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(button6,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button2,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button7,
//			XmNbottomAttachment, XmATTACH_FORM,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(button7,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button3,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
//			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button8,
//			XmNbottomWidget, button,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(button8,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button3,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
//			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button9,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(button9,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button3,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
//			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button10,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(form_move,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button3,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
//			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, form_set,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(form_set,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button3,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
//			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, form_del,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(form_del,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button3,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
//			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button13,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(button13,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, button3,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_FORM,
//			XmNbottomWidget, button,
//			XmNheight, 300,
			NULL);







	XtManageChild (form);
	XtManageChild (mlist);
	XtManageChild (form_del);
	XtManageChild (form_move);
	XtManageChild (form_set);
	XtManageChild (button1);
	XtManageChild (button2);
	XtManageChild (button3);
	XtManageChild (button4);
	XtManageChild (button5);
	XtManageChild (button6);
	XtManageChild (button7);
	XtManageChild (button8);
	XtManageChild (button9);
	XtManageChild (spin_mvto);
	XtManageChild (spin_mvfrom);
	XtManageChild (label_to);
	XtManageChild (button10);
	XtManageChild (spin_set);

	XtManageChild (button11);
	XtManageChild (spin_del);

	XtManageChild (button12);
	XtManageChild (button13);

	XtRealizeWidget (toplevel);
  
	XtAppMainLoop (app);
  
	printf("TERMINATED\n");
	return 0;
}
