#include <Xm/XmAll.h>
#include <pwd.h>
#include <Xm/PushB.h>
#include <Xm/SpinB.h>
#include "XmNlResColList.h"
#include "XmNl.h"
#include <string.h>
#include <X11/cursorfont.h>
#include <X11/xpm.h>
#include <stdlib.h>

static char *names[] = {
	"app_link_small.xpm",  "bookshelf_small.xpm",  "file_link_bad_small.xpm",  "file_small.xpm",
	"folder_link_small.xpm",  "folder_up_small.xpm",  "link_shadow_small.xpm", "app_small.xpm",
	"file_bad_small.xpm",   "file_link_small.xpm",      "folder_bad_small.xpm",  "folder_small.xpm",
	"home_small.xpm",       "link_small.xpm", NULL,
};

;

	Widget toplevel, form, sw, rclist, form_del, form_move, form_set, label1, vsb, hsb;
	Widget edit1, button1, button2;
	Widget spin_del, spin_mvfrom, spin_mvto, spin_set, button_app_s, button_app_p, button_del, button_move, button_set;
	Widget label_from, label_to;
	XtAppContext app;

int icon_n = 14;
int item_num = 250;

const char MyString[20]="my_string";
const char MyStringOther[20]="my_string_number_2";
const char icon_prefix[30]="./icons/";
char icon_name[100];
Pixmap pix[100];
Pixmap mask[100];
String str1[100];
String str2[100];
String str3[100];

unsigned char column_type[100];
int GlobalRowNumber=0;

XmNlCell * data_massiv;

int col_count = 5, row_count = 50;


void CreateIcons(void)
{
	int i, j, k, n;
	for (i = 0; i < icon_n; i++)
	{
		sprintf(icon_name, "%s%s", icon_prefix, names[i]);
		XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), icon_name,
							&(pix[i]), &(mask[i]), (XpmAttributes *) NULL);
	}
}

void CreateMassive(void)
{
	int i, j, k, n;
	data_massiv = (XmNlCell *) XtMalloc(col_count*row_count*sizeof(XmNlCell));
	k = 0;
	n = 0;
	for (i = 0; i < row_count; i++)
	{
		if (k >= icon_n) 
			k = 0;

		for (j = 0; j < col_count; j++)
		{
			data_massiv[n].text = (char *)calloc(strlen(MyString)+15, 1);
			sprintf(data_massiv[n].text, "%s col %d row %d", MyString, j, i);
			data_massiv[n].xmlabel = XmStringCreateLocalized(data_massiv[n].text);
			data_massiv[n].UserDataPointer = (void *) data_massiv[n].text;
			if (j == 0)
			{	
				data_massiv[n].pixmap = pix[k];
				data_massiv[n].mask = mask[k];
				k++;
			}
			else
			{
				data_massiv[n].pixmap = XmUNSPECIFIED_PIXMAP;
				data_massiv[n].mask = XmUNSPECIFIED_PIXMAP;
			}
			n++;
		}
	}
}


void DblClCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ItemActivateReturnStruct *data;
    data=(ItemActivateReturnStruct *)call_data;
    printf("\n--------- rescoltest3: Callback called 1 ---------\n");
    printf("\nrescoltest3: item=%d \t name=%s", data->item_number, (char *)data->pointer);

}

void HlgCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ListItemReturnStruct *data;
    int i;
    data=(ListItemReturnStruct *)call_data;

printf("\n+++++ rescoltest3: Callback clled 2 +++++++++\n");
printf("\nrescoltest3:  Num_item=%d ", data->count);
if (data->count==0) return;
for (i=0; i<data->count; i++)
	{
	printf("\nrescoltest3: Item_number=%d \t name=%s", data->number[i], (char *) data->pointers[i]);
	printf("\n");

	}
printf("\n+++++ rescoltest3: Callback complet 2 +++++++++\n");
printf("\n");
}

void ChangeCell(Widget w, XtPointer client_data, XtPointer call_data)
{
	unsigned char valuemask = CellXmString | CellCharString | CellUserData | CellPixmap | CellMask;

	
	XmNlResColInsertRow(rclist, data_massiv, 3, valuemask);
		printf("rescoltest3: Pushed\n");

}

void DeleteCells(Widget w, XtPointer client_data, XtPointer call_data)
{
	int count, *numbers;
	
	XmNlresColGetSelectedRows(rclist, &count, &numbers);
	
	printf("rescoltest3: selected %d rows with top number %d\n", count, numbers[0]);
	
	if (!count)
		return ;
		
	XmNlResColDeleteRows(rclist, numbers[0], count);
	

}


void NumberRow(Widget w, XtPointer client_data, XtPointer call_data)
{
	char * mptr;

	mptr = XmTextFieldGetString(w);
	
	sscanf( mptr, "%d", &GlobalRowNumber);
	
	XtFree(mptr);

}

void AppendColumnString(Widget w, XtPointer client_data, XtPointer call_data)
{
	XmNlColSpecRec * colspec;
	XmString motif_string = NULL;
	Arg           args[10];
	int           n;
	char tmpstring[50];
	
/*********** column 1 **********/
	n = 0;
	XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n], XmNcolType, XmSTRING); n++;
	XtSetArg(args[n], XmNtileType, XmSTRING); n++;
	sprintf(tmpstring, "Column New");
	motif_string = XmStringCreateLocalized(tmpstring);
	XtSetArg(args[n], XmNlabelString, motif_string); n++;

	colspec = XmNlColSpecCreate(XtDisplay(rclist), NULL, "col1", args, n);
	printf("********************************** Append column 1\n");
	XmNlResColAppendColumn(rclist, colspec);

	if (motif_string)
	{
		XmStringFree(motif_string);
		motif_string = NULL;
	}
	XmNlColSpecFree(colspec);

	column_type[col_count] = XmSTRING;
	col_count++;
	XtVaSetValues(spin_del, XmNmaximumValue, col_count - 1, 
			NULL);
	XtVaSetValues(spin_mvfrom, XmNmaximumValue, col_count - 1, 
			NULL);
	XtVaSetValues(spin_mvto, XmNmaximumValue, col_count - 1, 
			NULL);
	XtVaSetValues(spin_set, XmNmaximumValue, col_count - 1, 
			NULL);
//	appended_column++;
}

void AppendColumnIcon(Widget w, XtPointer client_data, XtPointer call_data)
{
	XmNlColSpecRec * colspec;
	XmString motif_string = NULL;
	Arg           args[10];
	int           n;
	char tmpstring[50];
	


/*********** column 0 **********/
	n = 0;
	XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
	XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
	XtSetArg( args[n], XmNcolType, XmPIXMAP); n++;
	XtSetArg( args[n], XmNtileType, XmPIXMAP); n++;
	XtSetArg( args[n], XtNtilePixmap, pix[0]); n++;
	XtSetArg( args[n], XtNtilePixmapMask, mask[0]); n++;

	colspec = XmNlColSpecCreate(XtDisplay(form), NULL, "colX", args, n);
	printf("********************************** Append column 0\n");
	XmNlResColAppendColumn(rclist, colspec);

	XmNlColSpecFree(colspec);


	column_type[col_count] = XmPIXMAP;
	col_count++;
	XtVaSetValues(spin_del, XmNmaximumValue, col_count - 1, 
			NULL);
	XtVaSetValues(spin_mvfrom, XmNmaximumValue, col_count - 1, 
			NULL);
	XtVaSetValues(spin_mvto, XmNmaximumValue, col_count - 1, 
			NULL);
	XtVaSetValues(spin_set, XmNmaximumValue, col_count - 1, 
			NULL);
//	appended_column++;
}


void DeleteColumn(Widget w, XtPointer client_data, XtPointer call_data)
{
	int n;
	char * pname = XtName(spin_del);
	char * tname = XtMalloc ((unsigned) strlen (pname) + 4);
	char * value;
	Widget textf;

	sprintf (tname, "%s_TF", pname);

	textf = XtNameToWidget(spin_del, tname);
	XtFree (tname);
	value = XmTextFieldGetString (textf); /* Caller frees */

	sscanf(value, "%d", &n);
	
	XtFree(value);

//	XtVaGetValues(spin_set,  XmNnumValues, &n, NULL);

printf("+++++++++++++++++++++\n++++++++++++++++++++\n");
	printf("Delete %d column\n", n);

	XmNlResColDeleteColumn(rclist, n);
	memmove((void *) (column_type + n), (void *) (column_type + n + 1), sizeof(unsigned char) * col_count - n); 
	col_count--;
	XtVaSetValues(spin_del, XmNmaximumValue, col_count - 1, 
			NULL);
	XtVaSetValues(spin_mvfrom, XmNmaximumValue, col_count - 1, 
			NULL);
	XtVaSetValues(spin_mvto, XmNmaximumValue, col_count - 1, 
			NULL);
	XtVaSetValues(spin_set, XmNmaximumValue, col_count - 1, 
			NULL);
}

void MoveColumn(Widget w, XtPointer client_data, XtPointer call_data)
{
	int n, k;
	char * pname1 = XtName(spin_mvfrom);
	char * pname2 = XtName(spin_mvto);
	char * tname;
	char * value;
	unsigned char sv;
	Widget textf;

	tname = XtMalloc ((unsigned) strlen (pname1) + 4);
	sprintf (tname, "%s_TF", pname1);

	textf = XtNameToWidget(spin_mvfrom, tname);
	XtFree (tname);
	value = XmTextFieldGetString (textf); /* Caller frees */

	sscanf(value, "%d", &n);
	
	XtFree(value);



	tname = XtMalloc ((unsigned) strlen (pname2) + 4);
	sprintf (tname, "%s_TF", pname2);

	textf = XtNameToWidget(spin_mvto, tname);
	XtFree (tname);
	value = XmTextFieldGetString (textf); /* Caller frees */

	sscanf(value, "%d", &k);
	
	XtFree(value);




//	XtVaGetValues(spin_set,  XmNnumValues, &n, NULL);

printf("+++++++++++++++++++++\n++++++++++++++++++++\n");
	printf("Move from %d to %d column\n", n, k);
	XmNlResColMoveColumnTo(rclist, n, k);
	
	sv = column_type[n];
	if (n < k)
	{
		memmove((void *) (column_type + n), (void *) (column_type + n + 1), sizeof(unsigned char) * k - n);
		column_type[k] = sv;
	}
	else
	{
		memmove((void *) (column_type + k), (void *) (column_type + k + 1), sizeof(unsigned char) * n - k);
		column_type[k] = sv;
	}
}

void SetColumn(Widget w, XtPointer client_data, XtPointer call_data)
{
	unsigned char mask_value = 0;
	int i, j, k, n;
	char * pname = XtName(spin_set);
	char * tname = XtMalloc ((unsigned) strlen (pname) + 4);
	XmNlCell * dt_massiv;
	char * value;
	Widget textf;

	sprintf (tname, "%s_TF", pname);

	textf = XtNameToWidget(spin_set, tname);
	XtFree (tname);
	value = XmTextFieldGetString (textf); /* Caller frees */

	sscanf(value, "%d", &n);
	
	XtFree(value);

//	XtVaGetValues(spin_set,  XmNnumValues, &n, NULL);

printf("+++++++++++++++++++++\n++++++++++++++++++++\n");
	printf("Set %d column\n", n);

	dt_massiv = (XmNlCell *) XtMalloc(row_count * sizeof(XmNlCell));
	k = 0;
	for (i = 0; i < row_count; i++)
	{
		dt_massiv[i].text = (char *) calloc(strlen(MyString) + 25, 1);
		sprintf(dt_massiv[i].text, "%s new col %d row %d", MyString, n, i);
		if (k >= icon_n) 
			k = 0;
		if (column_type[n] == XmSTRING)
		{
			printf("Set string\n");
			dt_massiv[i].xmlabel = XmStringCreateLocalized(dt_massiv[i].text);
			dt_massiv[i].pixmap = XmUNSPECIFIED_PIXMAP;
			dt_massiv[i].mask = XmUNSPECIFIED_PIXMAP;
		}
		else
		{
			printf("Set pixmap\n");
			dt_massiv[i].xmlabel = NULL;
			dt_massiv[i].pixmap = pix[k];
			dt_massiv[i].mask = mask[k];
		}
		k++;
	}

	if (column_type[n] == XmSTRING) 
		mask_value = 0 | CellXmString | CellUserData;
	else
		mask_value = 0 | CellPixmap | CellMask | CellUserData;
	
	XmNlResColSetCol(rclist, dt_massiv, n, mask_value);
	printf("xmlist3: set column succes\n");				

	for (i = 0; i < row_count; i++)
	{
		free(dt_massiv[i].text);
		XmStringFree(dt_massiv[i].xmlabel);
	}
	free(dt_massiv);
}


int main(int argc, char **argv)
{
	Arg           args[10];
	int           n, i;
	unsigned char valuemask = CellXmString | CellCharString | CellUserData | CellPixmap | CellMask;
	XmNlColSpecRec * colspec;
	XmString motif_string = NULL;
	char tmpstring[50];

	XtSetLanguageProc (NULL, NULL, NULL);
	toplevel = XtVaOpenApplication (&app, "Demos", NULL, 0, &argc, argv,
                             NULL, sessionShellWidgetClass, NULL);
/* Create a 500x300 scrolled window. This value is arbitrary,
** but happens to look good initially. It is resizable by the user.
*/
//	wait_cursor = XCreateFontCursor(XtDisplay(toplevel), XC_watch);
//	waited=False;
	form = XmCreateForm (toplevel, "Form",   args, 0);

	
	label1 = XmCreateLabel(form, "Row", NULL, 0);
	edit1 = XmCreateTextField(form, "row", NULL, 0);
	button1 = XmCreatePushButton(form, "Insert", NULL, 0);
	button2 = XmCreatePushButton(form, "Delete selected rows", NULL, 0);
	button_app_s = XmCreatePushButton(form, "Append string column", NULL, 0);
	button_app_p = XmCreatePushButton(form, "Append icon column", NULL, 0);

	XtAddCallback(edit1, XmNactivateCallback, NumberRow, (XtPointer)10);
	
	XtAddCallback(button1, XmNactivateCallback, ChangeCell, (XtPointer) NULL);
	
	XtAddCallback(button2, XmNactivateCallback, DeleteCells, (XtPointer) NULL);

	XtAddCallback(button_app_s, XmNactivateCallback, AppendColumnString, (XtPointer) NULL);
	XtAddCallback(button_app_p, XmNactivateCallback, AppendColumnIcon, (XtPointer) NULL);
/***************************/
	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, button_app_p); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;

	form_del = XmCreateForm (form, "FormDel", args, n);

	
	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
//	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
//	XtSetArg (args[n], XmNleftWidget, button_del); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNspinBoxChildType, XmNUMERIC); n++;
	XtSetArg (args[n], XmNminimumValue, 0); n++;
	XtSetArg (args[n], XmNmaximumValue, col_count - 1); n++;
	XtSetArg (args[n], XmNincrementValue, 1); n++;
	XtSetArg (args[n], XmNeditable, TRUE); n++;
	XtSetArg (args[n], XmNcolumns, 5); n++;
	XtSetArg (args[n], XmNwrap, FALSE); n++;

	spin_del = XmCreateSimpleSpinBox(form_del, "spindel", args, n);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNrightWidget, spin_del); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;

	button_del = XmCreatePushButton(form_del, "Delete column", args, n);
	XtAddCallback(button_del, XmNactivateCallback, DeleteColumn, (XtPointer) NULL);

/***************************/
	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, form_del); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;

	form_move = XmCreateForm (form, "FormMove", args, n);


	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNspinBoxChildType, XmNUMERIC); n++;
	XtSetArg (args[n], XmNminimumValue, 0); n++;
	XtSetArg (args[n], XmNmaximumValue, col_count - 1); n++;
	XtSetArg (args[n], XmNincrementValue, 1); n++;
	XtSetArg (args[n], XmNeditable, TRUE); n++;
	XtSetArg (args[n], XmNcolumns, 5); n++;
	XtSetArg (args[n], XmNwrap, FALSE); n++;

	spin_mvto = XmCreateSimpleSpinBox(form_move, "spinto", args, n);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNrightWidget, spin_mvto); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;

	label_to = XmCreateLabel(form_move, "To", args, n);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNrightWidget, label_to); n++;
//	XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
//	XtSetArg (args[n], XmNleftWidget, button_move); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNspinBoxChildType, XmNUMERIC); n++;
	XtSetArg (args[n], XmNminimumValue, 0); n++;
	XtSetArg (args[n], XmNmaximumValue, col_count - 1); n++;
	XtSetArg (args[n], XmNincrementValue, 1); n++;
	XtSetArg (args[n], XmNeditable, TRUE); n++;
	XtSetArg (args[n], XmNcolumns, 5); n++;
	XtSetArg (args[n], XmNwrap, FALSE); n++;

	spin_mvfrom = XmCreateSimpleSpinBox(form_move, "spinfrom", args, n);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNrightWidget, spin_mvfrom); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;

	button_move = XmCreatePushButton(form_move, "Move column", args, n);
	XtAddCallback(button_move, XmNactivateCallback, MoveColumn, (XtPointer) NULL);

/***************************/
	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNtopWidget, form_move); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;

	form_set = XmCreateForm (form, "FormSet", args, n);

	
	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNspinBoxChildType, XmNUMERIC); n++;
	XtSetArg (args[n], XmNminimumValue, 0); n++;
	XtSetArg (args[n], XmNmaximumValue, col_count - 1); n++;
	XtSetArg (args[n], XmNincrementValue, 1); n++;
	XtSetArg (args[n], XmNeditable, TRUE); n++;
	XtSetArg (args[n], XmNcolumns, 5); n++;
	XtSetArg (args[n], XmNwrap, FALSE); n++;

	spin_set = XmCreateSimpleSpinBox(form_set, "spinset", args, n);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNrightWidget, spin_set); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;

	button_set = XmCreatePushButton(form_set, "Set column", args, n);
	XtAddCallback(button_set, XmNactivateCallback, SetColumn, (XtPointer) NULL);



	n = 0;
	XtSetArg (args[n], XmNwidth, 500); n++;
	XtSetArg (args[n], XmNheight, 300); n++;
	XtSetArg (args[n], XmNscrollingPolicy, XmAPPLICATION_DEFINED); n++;
	sw = XmCreateScrolledWindow (form, "scrolled_w",   args, n);

	n = 0;
	XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
	XtSetArg(args[n], XmNmaximum, 1); n++;
	XtSetArg(args[n], XmNsliderSize, 1); n++;
	vsb=XmCreateScrollBar(sw, "vsb", args, n);

	n = 0;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg(args[n], XmNmaximum, 1); n++;
	XtSetArg(args[n], XmNsliderSize, 1); n++;
	hsb=XmCreateScrollBar(sw, "hsb", args, n);

	XtManageChild(vsb);
	XtManageChild(hsb);

	XtVaSetValues(label1,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(edit1,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, label1,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(button1,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, edit1,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(button2,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, button1,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(button_app_s,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, button2,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(button_app_p,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, button_app_s,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(sw,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, form_set,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_FORM,
			NULL);

	CreateIcons();
	CreateMassive();

	rclist = XtVaCreateWidget ("MyList", xmNlResColListWidgetClass, sw, NULL);
	for (i = 0; i < col_count; i++)
	{
		n = 0;
		XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
		if (i == 0) 
		{
			XtSetArg( args[n], XmNcolType, XmPIXMAP); n++;
//			XtSetArg( args[n], XmNcolType, XmSTRING); n++;
			XtSetArg( args[n], XmNtileType, XmPIXMAP); n++;
			XtSetArg( args[n], XtNtilePixmap, pix[i]); n++;
			XtSetArg( args[n], XtNtilePixmapMask, mask[i]); n++;
			column_type[i] = XmPIXMAP;
		}
		if (i == 1)
		{
			XtSetArg( args[n], XmNcolType, XmSTRING); n++;
			XtSetArg( args[n], XmNtileType, XmPIXMAP_AND_STRING); n++;
			XtSetArg( args[n], XtNtilePixmap, pix[i]); n++;
			XtSetArg( args[n], XtNtilePixmapMask, mask[i]); n++;

			tmpstring[0] = '\0';
			sprintf(tmpstring, "Column %d", i);
			motif_string = XmStringCreateLocalized(tmpstring);
			XtSetArg( args[n], XmNlabelString, motif_string); n++;
			XtSetArg( args[n], XmNpixmapPlacement,  XmPIXMAP_LEFT); n++;
			column_type[i] = XmSTRING;
		} 
		if (i != 0 && i != 1)
		{
			XtSetArg( args[n], XmNcolType, XmSTRING); n++;
			XtSetArg( args[n], XmNtileType, XmSTRING); n++;
			tmpstring[0] = '\0';
			sprintf(tmpstring, "Column %d", i);
			motif_string = XmStringCreateLocalized(tmpstring);
			XtSetArg( args[n], XmNlabelString, motif_string); n++;
			column_type[i] = XmSTRING;
		}

		printf("********************************** Create column %d\n", i);
		colspec = XmNlColSpecCreate(XtDisplay(rclist), NULL, tmpstring, args, n);
		printf("********************************** Append column %d\n", i);
		XmNlResColAppendColumn(rclist, colspec);
		if (motif_string)
		{
			XmStringFree(motif_string);
			motif_string = NULL;
		}
		XmNlColSpecFree(colspec);
	}
	XmNlResColAddRows(rclist, data_massiv, row_count, valuemask);
	RCSetAutoresCol(rclist, 2);
	printf("\n rescoltest3: RCAddRows complet\n");
	XtVaSetValues(rclist, XmNverticalScrollBar, vsb, XmNhorizontalScrollBar, hsb, NULL);
	XtAddCallback(rclist, XtNhighlightCallback, HlgCallback, (XtPointer) NULL);
	XtAddCallback(rclist, XmNdoubleClickCallback, DblClCallback, (XtPointer) NULL);

	XtManageChild(form);
	XtManageChild(edit1);
	XtManageChild(label1);
	XtManageChild(button_app_s);
	XtManageChild(button_app_p);
	
	XtManageChild(button1);
	XtManageChild(button2);
	XtManageChild(form_del);
	XtManageChild(form_move);
	XtManageChild(form_set);
	XtManageChild(button_del);
	XtManageChild(button_move);
	XtManageChild(spin_del);
	XtManageChild(spin_mvfrom);
	XtManageChild(label_to);
	XtManageChild(spin_mvto);
	XtManageChild(spin_set);
	XtManageChild(button_set);
	XtManageChild(rclist);
	XtManageChild(sw);
	XtRealizeWidget(toplevel);
	XtAppMainLoop(app);
	return 0;
}
