#include <Xm/XmAll.h>
#include <pwd.h>
#include <Xm/PushB.h>
#include "XmNlResColList.h"
 #include "XmNl.h"
#include <string.h>
#include <X11/cursorfont.h>
#include <X11/xpm.h>
#include <stdlib.h>


static char *names[] = {
	"app_link_small.xpm",  "bookshelf_small.xpm",  "file_link_bad_small.xpm",  "file_small.xpm",
	"folder_link_small.xpm",  "folder_up_small.xpm",  "link_shadow_small.xpm", "app_small.xpm",
	"file_bad_small.xpm",   "file_link_small.xpm",      "folder_bad_small.xpm",  "folder_small.xpm",
	"home_small.xpm",       "link_small.xpm", NULL,
};

	Widget toplevel, form, sw, rclist, form, label1, label2, label3, vsb, hsb;
	Widget edit1, edit2, edit3, button1;
	XtAppContext app;

int icon_n=14;
int item_num=250;

const char MyString[20]="my_string";
const char MyStringOther[20]="my_string_number_2";
const char icon_prefix[30]="./icons/";
char icon_name[100];
Pixmap pix[100];
Pixmap mask[100];
String str1[100];
String str2[100];
String str3[100];

int GlobalRowNumber=0, GlobalColNumber=0;
char * GlobalCellText = NULL;

XmNlCell * data_massiv;

int col_count=5, row_count=50;

void CreateMassive(void)
{
	int i, j, k, n;
	data_massiv=(XmNlCell *) XtMalloc(col_count*row_count*sizeof(XmNlCell));
	k=0;
	n=0;
	for (i=0; i<row_count; i++)
	{
		if (k>=icon_n) k=0;
			for (j=0; j<col_count; j++)
			{
		data_massiv[n].text=(char *)calloc(strlen(MyString)+15, 1);
		sprintf(data_massiv[n].text, "%s col %d row %d", MyString, j, i);
		data_massiv[n].xmlabel = XmStringCreateLocalized(data_massiv[n].text);
		data_massiv[n].UserDataPointer=(void *) data_massiv[n].text;
		sprintf(icon_name, "%s%s", icon_prefix, names[k]);
		XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), icon_name,
			      &(pix[k]), &(mask[k]), (XpmAttributes *)NULL);
		if (j==0)
			{	
			data_massiv[n].pixmap=pix[k];
			data_massiv[n].mask=mask[k];
			k++;
			}
		else
			{
			data_massiv[n].pixmap= (Pixmap)NULL;
			data_massiv[n].mask=(Pixmap)NULL;
			}
				n++;
			}
		}
	
}


void DblClCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ItemActivateReturnStruct *data;
    data=(ItemActivateReturnStruct *)call_data;
    printf("\n--------- rescoltest2: Callback called 1 ---------\n");
    printf("\nrescoltest2: item=%d \t name=%s", data->item_number, (char *)data->pointer);

}

void HlgCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ListItemReturnStruct *data;
    int i;
    data=(ListItemReturnStruct *)call_data;

printf("\n+++++ rescoltest2: Callback clled 2 +++++++++\n");
printf("\n rescoltest2: Num_item=%d ", data->count);
if (data->count==0) return;
for (i=0; i<data->count; i++)
	{
	printf("\nrescoltest2: Item_number=%d \t name=%s", data->number[i], (char *) data->pointers[i]);
	printf("\n");

	}
printf("\n+++++ rescoltest2: Callback complet 2 +++++++++\n");
printf("\n");
}

void ChangeCell(Widget w, XtPointer client_data, XtPointer call_data)
{
	char * mptr;
	char icon_nm[1024];
	Pixmap pix, mask;
	int n;
	XmNlCell data;
	unsigned char valuemask;

	mptr = XmTextFieldGetString(edit2);
	sscanf( mptr, "%d", &GlobalColNumber);
	if (mptr) XtFree(mptr);

	mptr = XmTextFieldGetString(edit1);
	sscanf( mptr, "%d", &GlobalRowNumber);
	if (mptr) XtFree(mptr);


	if (!GlobalCellText) 
	{
		mptr = XmTextFieldGetString(edit3);
		GlobalCellText = calloc(strlen(mptr)+1, sizeof(char));
		strcpy(GlobalCellText, mptr);
		XtFree(mptr);
	}

	data.text = calloc(strlen(GlobalCellText)+1, 1);
	strcpy(data.text, GlobalCellText);
	
	if (GlobalColNumber > 0)
	{
		valuemask = 0 | CellXmString | CellCharString;
		data.xmlabel = XmStringCreateLocalized(GlobalCellText);
		XmNlResColSetCell(rclist, &data, valuemask, GlobalColNumber, GlobalRowNumber);
	}
	else
	{
		sprintf(icon_nm, "%s%s", icon_prefix, "zoo.xpm");
		XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), icon_nm,
			      &pix, &mask, (XpmAttributes *)NULL);
		valuemask = 0 | CellPixmap | CellMask;
		data.pixmap = pix;
		data.mask = mask;
		XmNlResColSetCell(rclist, &data, valuemask, GlobalColNumber, GlobalRowNumber);
	}
		printf("rescoltest2: Pushed\n");

}

void NumberRow(Widget w, XtPointer client_data, XtPointer call_data)
{
	char * mptr;

	mptr = XmTextFieldGetString(w);
	
	sscanf( mptr, "%d", &GlobalRowNumber);
	
	XtFree(mptr);

}

void NumberCol(Widget w, XtPointer client_data, XtPointer call_data)
{
	char * mptr;

	mptr = XmTextFieldGetString(w);
	
	sscanf( mptr, "%d", &GlobalColNumber);
	
	XtFree(mptr);

}

void TextCell(Widget w, XtPointer client_data, XtPointer call_data)
{
	char * mptr;

	mptr = XmTextFieldGetString(w);


	if (GlobalCellText) free((void *)GlobalCellText);
	GlobalCellText = calloc(strlen(mptr)+1, sizeof(char));
	strcpy(GlobalCellText, mptr);
	XtFree(mptr);

}


int main(int argc, char **argv)
{
	Arg           args[10];
	int           n, i;
	unsigned char valuemask = CellXmString | CellCharString | CellUserData | CellPixmap | CellMask;
	XmNlColSpecRec * colspec;
	XmString motif_string = NULL;
	char tmpstring[50];

	XtSetLanguageProc (NULL, NULL, NULL);
	toplevel = XtVaOpenApplication (&app, "Demos", NULL, 0, &argc, argv,
                             NULL, sessionShellWidgetClass, NULL);
/* Create a 500x300 scrolled window. This value is arbitrary,
** but happens to look good initially. It is resizable by the user.
*/
//	wait_cursor = XCreateFontCursor(XtDisplay(toplevel), XC_watch);
//	waited=False;
	form = XmCreateForm (toplevel, "Form",   args, 0);

	label1 = XmCreateLabel(form, "Row", NULL, 0);
	label2 = XmCreateLabel(form, "Column", NULL, 0);
	label3 = XmCreateLabel(form, "String", NULL, 0);
	
	edit1 = XmCreateTextField(form, "row", NULL, 0);
	edit2 = XmCreateTextField(form, "col", NULL, 0);
	edit3 = XmCreateTextField(form, "text", NULL, 0);
	button1=XmCreatePushButton(form, "Change", NULL, 0);

	XtAddCallback(edit1, XmNactivateCallback, NumberRow, (XtPointer)10);
	XtAddCallback(edit2, XmNactivateCallback, NumberCol, (XtPointer)10);
	
	XtAddCallback(edit3, XmNactivateCallback, TextCell, (XtPointer)10);
	
	XtAddCallback(button1, XmNactivateCallback, ChangeCell, (XtPointer) NULL);
	
	
	n = 0;
	XtSetArg (args[n], XmNwidth, 500); n++;
	XtSetArg (args[n], XmNheight, 300); n++;
	XtSetArg (args[n], XmNscrollingPolicy, XmAPPLICATION_DEFINED); n++;
	sw = XmCreateScrolledWindow (form, "scrolled_w",   args, n);

	i=0;
	XtSetArg(args[i], XmNorientation, XmVERTICAL); i++;
	XtSetArg(args[i], XmNmaximum, 1); i++;
	XtSetArg(args[i], XmNsliderSize, 1); i++;
	vsb=XmCreateScrollBar(sw, "vsb", args, i);
	i=0;
	XtSetArg(args[i], XmNorientation, XmHORIZONTAL); i++;
	XtSetArg(args[i], XmNmaximum, 1); i++;
	XtSetArg(args[i], XmNsliderSize, 1); i++;
	hsb=XmCreateScrollBar(sw, "hsb", args, i);
	XtManageChild(vsb);
	XtManageChild(hsb);

	XtVaSetValues(label1,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(edit1,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, label1,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(label2,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, edit1,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(edit2,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, label2,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(label3,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, edit2,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(edit3,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, label3,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(button1,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, edit3,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);


	XtVaSetValues(sw,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, button1,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_FORM,
			NULL);

	CreateMassive();


	rclist = XtVaCreateWidget ("MyList", xmNlResColListWidgetClass, sw, NULL);
//	XtVaSetValues(main_rc, XmNlayoutFrozen, True, NULL);
	for (i=0; i<col_count; i++)
	{
		n = 0;
		XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
		if (i == 0) 
		{
			XtSetArg( args[n], XmNcolType, XmPIXMAP); n++;
//			XtSetArg( args[n], XmNcolType, XmSTRING); n++;
			XtSetArg( args[n], XmNtileType, XmPIXMAP); n++;
			XtSetArg( args[n], XtNtilePixmap, pix[i]); n++;
			XtSetArg( args[n], XtNtilePixmapMask, mask[i]); n++;

		}
		if (i == 1)
		{
			XtSetArg( args[n], XmNcolType, XmSTRING); n++;
			XtSetArg( args[n], XmNtileType, XmPIXMAP_AND_STRING); n++;
			XtSetArg( args[n], XtNtilePixmap, pix[i]); n++;
			XtSetArg( args[n], XtNtilePixmapMask, mask[i]); n++;

			tmpstring[0] = '\0';
			sprintf(tmpstring, "Column %d", i);
			motif_string = XmStringCreateLocalized(tmpstring);
			XtSetArg( args[n], XmNlabelString, motif_string); n++;
			XtSetArg( args[n], XmNpixmapPlacement,  XmPIXMAP_LEFT); n++;
		} 
		if (i != 0 && i != 1)
		{
			XtSetArg( args[n], XmNcolType, XmSTRING); n++;
			XtSetArg( args[n], XmNtileType, XmSTRING); n++;
			tmpstring[0] = '\0';
			sprintf(tmpstring, "Column %d", i);
			motif_string = XmStringCreateLocalized(tmpstring);
			XtSetArg( args[n], XmNlabelString, motif_string); n++;
		}

		printf("********************************** Create column %d\n", i);
		colspec = XmNlColSpecCreate(XtDisplay(rclist), NULL, tmpstring, args, n);
		printf("********************************** Append column %d\n", i);
		XmNlResColAppendColumn(rclist, colspec);
		if (motif_string)
		{
			XmStringFree(motif_string);
			motif_string = NULL;
		}
		XmNlColSpecFree(colspec);
	}
	printf("\n rescoltest2: Next RCSetPropertyRow\n");
	XmNlResColAddRows(rclist, data_massiv, row_count, valuemask);
	RCSetAutoresCol(rclist, 2);
	printf("\n rescoltest2: RCAddRows complet\n");
	XtVaSetValues(rclist, XmNverticalScrollBar, vsb, XmNhorizontalScrollBar, hsb, NULL);
	XtAddCallback(rclist, XtNhighlightCallback, HlgCallback, (XtPointer) NULL);
	XtAddCallback(rclist, XmNdoubleClickCallback, DblClCallback, (XtPointer) NULL);

  XtManageChild(form);
  XtManageChild(edit1);
  XtManageChild(edit2);
  XtManageChild(edit3);

  XtManageChild(label1);
  XtManageChild(label2);
  XtManageChild(label3);
	
  XtManageChild(button1);
  XtManageChild (rclist);
  XtManageChild (sw);
  XtRealizeWidget (toplevel);
  XtAppMainLoop (app);
  return 0;
}
