#include <Xm/XmAll.h>
#include <pwd.h>
#include <Xm/PushB.h>
#include <Xm/Form.h>
#include "XmNlPartRes.h"
#include "XmNl.h"
#include <string.h>
#include <malloc.h>
#include <X11/cursorfont.h>
#include <Xm/XmP.h>


#define MAX_COL_NUM 20

static char *names[] = {
"acroread.xpm",       "fonts.xpm",         "kruler.xpm",         "pysol.xpm",
"applications.xpm",   "font.xpm",          "ksame.xpm",          "raster.xpm",
"app_link.xpm",       "framemaker.xpm",    "kscd.xpm",           "rc.xpm",
"app_plain.xpm",      "games_arcade.xpm",  "kscreensaver.xpm",   "readme.xpm",
"app.xpm",            "games_board.xpm",   "kshisen.xpm",        "realplayer.xpm",
"ark.xpm",            "games_card.xpm",    "ksirtet.xpm",        "recycle.xpm",
"blender.xpm",        "games.xpm",         "ksmiletris.xpm",     "redhat.xpm",
"bluelogo.xpm",       "gears2.xpm",        "ksnake.xpm",         "res.xpm",
"bookshelf.xpm",      "gears.xpm",         "ksnapshot.xpm",      "samba.xpm",
"book.xpm",           "ghostview.xpm",     "ksokoban.xpm",       "script_file.xpm",
"bug.xpm",            "ghost.xpm",         "kspread.xpm",        "script_link.xpm",
"calc2.xpm",          "gif.xpm",           "ksysguard.xpm",      "script_plain.xpm",
"calc.xpm",           "gimp.xpm",          "ksysv.xpm",          "script.xpm",
"camera.xpm",         "gnorpm.xpm",        "kthememgr.xpm",      "scsi.xpm",
"cdrom.xpm",          "gnu.xpm",           "ktron.xpm",          
"cervisia.xpm",       "graph.xpm",         "kuickshow.xpm",      "sounds2.xpm",
"chess2.xpm",         "gvim.xpm",          "kuser.xpm",          "sounds.xpm",
"chess3.xpm",         "gv.xpm",            "kviewshell.xpm",     "sound.xpm",
"chess.xpm",          "hammer.xpm",        "kwin.xpm",           "stuff.xpm",
"chip.xpm",           "harddrive.xpm",     "kword.xpm",          "stylesheet.xpm",
"circuit2.xpm",       "helpme.xpm",        "licq.xpm",           "style.xpm",
"circuit.xpm",        "hex.xpm",           "link_shadow.xpm",    "suitcase.xpm",
"clip_file.xpm",      "home2.xpm",         "link.xpm",           "susehelpcenter.xpm",
"clip_folder.xpm",    "home.xpm",          "lisp.xpm",           "system.xpm",
"clip.xpm",           "html.xpm",          "list.xpm",           "tape_net.xpm",
"compressed.xpm",     "hwinfo.xpm",        "lnxzip.xpm",         "tape.xpm",
"compress.xpm",       "icons.xpm",         "locale.xpm",         "tar.xpm",
"cookie.xpm",         "icon.xpm",          "lyx.xpm",            "teddy.xpm",
"core.xpm",           "iff.xpm",           "mag_glass.xpm",      "term.xpm",
"cycle.xpm",          "info.xpm",          "magic.xpm",          "text.xpm",
"data.xpm",           "jpeg.xpm",          "mailfolder.xpm",     "tex.xpm",
"date.xpm",           "kaboodle.xpm",      "mail.xpm",           "tiff.xpm",
"debug.xpm",          "kalarm.xpm",        "makefile.xpm",       "tmpfile.xpm",
"designer.xpm",       "karm.xpm",          "make.xpm",           "tools.xpm",
"dev_cdrom.xpm",      "kasteroids.xpm",    "manpage.xpm",        "trash_empty.xpm",
"dev_floppy.xpm",     "kbackgammon.xpm",   "manual.xpm",         "trash_full.xpm",
"dev_harddrive.xpm",  "kcalc.xpm",         "mathematica.xpm",    "typewriter.xpm",
"diff.xpm",           "kchart.xpm",        "memory.xpm",         "url.xpm",
"dlgedit.xpm",        "kcoloredit.xpm",    "midi.xpm",           "usb.xpm",
"dot_a.xpm",          "kcontrol.xpm",      "modem.xpm",          "uu.xpm",
"dot_cc.xpm",         "kcron.xpm",         "mouse.xpm",          "video.xpm",
"dot_c.xpm",          "kdat.xpm",          "movies.xpm",         "wabi.xpm",
"dot_h.xpm",          "kdf.xpm",           "mozilla.xpm",        "windows.xpm",
"dot_o.xpm",          "kdict.xpm",         "multimedia.xpm",     "winprops.xpm",
"dot_sa.xpm",         "kdmconfig.xpm",     "music.xpm",          "winzip.xpm",
"dot_so.xpm",         "kedit.xpm",         "nedit.xpm",          "wizard.xpm",
"draw2.xpm",          "kenolaba.xpm",      "netscape.xpm",       "wp.xpm",
"draw.xpm",           "kfax.xpm",          "news.xpm",           "write.xpm",
"dvi.xpm",            "kfloppy.xpm",       "noatun.xpm",         "writings.xpm",
"editor.xpm",         "kfm.xpm",           "opera.xpm",          "xapp.xpm",
"editres.xpm",        "kfract.xpm",        "paint2.xpm",         "xbm.xpm",
"edit.xpm",           "khelpcenter.xpm",   "paintings.xpm",      "xclipboard.xpm",
"ee.xpm",             "khexedit.xpm",      "paint.xpm",          "xclock.xpm",
"emacs.xpm",          "kicker.xpm",        "paragraphs.xpm",     "xeyes.xpm",
"email.xpm",          "kiconedit.xpm",     "password.xpm",       "xfig2.xpm",
"empty.xpm",          "kjots.xpm",         "pbm.xpm",            "xfig.xpm",
"exec2.xpm",          "kjumpingcube.xpm",  "pci.xpm",            "xfmail.xpm",
"exec.xpm",           "klines.xpm",        "pdf.xpm",            "xload.xpm",
"fig.xpm",            "klipper.xpm",       "penguin.xpm",        "xlogo.xpm",
"file_bad.xpm",       "kljettool.xpm",     "pgm.xpm",            "xmag.xpm",
"file_link_bad.xpm",  "klpq.xpm",          "pharmacy.xpm",       "xmcd.xpm",
"file_link.xpm",      "kmahjongg.xpm",     "pictures.xpm",       "xmms.xpm",
"fileman.xpm",        "kmidi.xpm",         "plan.xpm",           "xosview.xpm",
"fileserver.xpm",     "kmid.xpm",          "plaster.xpm",        "xpaint.xpm",
"files.xpm",          "kmines.xpm",        "ppm.xpm",            "xplate.xpm",
"filetypes.xpm",      "knotes.xpm",        "printer2.xpm",       "xrolodex.xpm",
"file.xpm",           "korn.xpm",          "printer3.xpm",       "xterm.xpm",
"find.xpm",           "kpackage.xpm",      "printer.xpm",        "xv2.xpm",
"fish.xpm",           "kpaint.xpm",        "printmgr.xpm",       "xv.xpm",
"floppy.xpm",         "kpat.xpm",          "processor.xpm",      "x.xpm",
"folder_bad.xpm",     "kpoker.xpm",        "proxy.xpm",          "zip.xpm",
"folder_link.xpm",    "kppp.xpm",          "ps2.xpm",            "zoo.xpm",
"folder_up.xpm",      "kpresenter.xpm",    "ps.xpm",
"folder.xpm",         "kreversi.xpm",      "pybliographic.xpm",  NULL,
};	

/*static char *names[] = {
	"app_link_small.xpm",  "bookshelf_small.xpm",  "file_link_bad_small.xpm",  "file_small.xpm",
	"folder_link_small.xpm",  "folder_up_small.xpm",  "link_shadow_small.xpm", "app_small.xpm",
	"file_bad_small.xpm",   "file_link_small.xpm",      "folder_bad_small.xpm",  "folder_small.xpm",
	"home_small.xpm",       "link_small.xpm", NULL,
};*/

Widget toplevel, form, prs, button1, button2;
XtAppContext app;


const char tstring1[]="String1";
const char tstring2[]="String2";
const char tstring3[]="String3";
const char tstring4[]="String4";
const char tstring5[]="String5";
const char tstring6[]="String6";

int string_count=6;

PartResElement * record;

int icon_n=293;
int item_num=50;
int shift=20;

const char MyString[20]="my_string";
const char MyStringOther[20]="my_string_number_2";
const char icon_prefix[30]="./icons/";
char icon_name[100];
Pixmap pix[100];
Pixmap mask[100];
String sstr1;
String sstr2;
String sstr3;
String sstr4;

String str1[100];
String str2[100];
String str3[100];

Dimension col_size[4];

int Width[5], f_width;;

XmNlCell cell;
XmNlCell cells[MAX_COL_NUM];
unsigned char valuemask = CellXmString | CellPixmap | CellAlignment | CellPriority;

int PartSize[MAX_COL_NUM];

int CurrentColNum = 4;


void Btn1Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	int i, n;

	if (CurrentColNum == 4)
	{
		PartSize[0] = 10;
		PartSize[1] = 25;
		PartSize[2] = 10;
		PartSize[3] = 55;

		XtVaSetValues(prs, XmNpartitionsSize, PartSize,
						NULL);
	}
	else
	{
		int n;
		n = 100 / CurrentColNum;
		
		for (i = 0; i < CurrentColNum; i++)
		{
			PartSize[i] = n;
		}
		
		PartSize[0] = n - 5;
		PartSize[CurrentColNum - 1] = n + 5;
		
		n = 0;
		for (i = 0; i < CurrentColNum; i++)
		{
			n = n + PartSize;
		}
		
		if (n < 100)
			PartSize[CurrentColNum - 1] = PartSize[CurrentColNum - 1] + (100 - n);
		
		XtVaSetValues(prs, XmNpartitionsSize, PartSize,
						NULL);
		SetRow(NULL);
	}
}

void Btn2Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	PartSize[0] = 10;
	PartSize[1] = 25;
	PartSize[2] = 10;
	PartSize[3] = 10;
	PartSize[4] = 10;
	PartSize[5] = 10;
	PartSize[6] = 10;
	PartSize[7] = 5;
	PartSize[8] = 5;
	PartSize[9] = 5;

	XtVaSetValues(prs, XmNnumCols, 10,
						XmNpartitionsSize, PartSize,
						NULL);
	CurrentColNum = 10;
	SetRow(NULL);
}

void CreateIcons(void)
{

	int i, k;
	k=0;
	for (i=0; i<item_num; i++)
	{
		if (k>=icon_n) k=0;
		sprintf(icon_name, "%s%s", icon_prefix, names[k]);
		XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), icon_name,
			      &(pix[i]), &(mask[i]), NULL);
		k++;
		}
	
}


void CreateCells(void)
{
	int i;
	char string[100];
	
	for (i = 0; i < MAX_COL_NUM; i++)
	{
		memset(string, 0, 100);
		sprintf(string, "Partition %d", i);
		printf("%s\n", string);
		cells[i].xmlabel = XmStringCreateLocalized(string);
		cells[i].pixmap = pix[i];
		cells[i].mask = mask[i];
		cells[i].alignment = XmALIGNMENT_BEGINNING;
//		cells[i].alignment = XmALIGNMENT_END;
		cells[i].element_type = XmPIXMAP_AND_STRING;
//		cells[i].priority = XmPIXMAP;
		cells[i].priority = XmSTRING;
	}

}


void ChangeColNum2(XtPointer data);


void SetCell4(XtPointer data)
{
	cell.xmlabel = NULL;
	cell.pixmap = pix[1];
	cell.mask = mask[1];
	cell.alignment = XmALIGNMENT_BEGINNING;
	cell.element_type = XmPIXMAP;
	cell.priority = XmPIXMAP;
	
	XmNlPartResSetCell(prs, &cell, valuemask, 3);
//	UpdateScrollBar();

//	XtAppAddTimeOut(app, 5000, (XtTimerCallbackProc) SetCell4, NULL);

//	XtVaSetValues(prs, XmNnumColumns, 3, NULL);
	XtAppAddTimeOut(app, 10000, (XtTimerCallbackProc) ChangeColNum2, NULL);
}

void SetCell3(XtPointer data)
{
	cell.xmlabel = XmStringCreateLocalized("Partition 3");
	cell.pixmap = pix[0];
	cell.mask = mask[0];
	cell.alignment = XmALIGNMENT_END;
	cell.element_type = XmPIXMAP_AND_STRING;
	cell.priority = XmSTRING;
	
	XmNlPartResSetCell(prs, &cell, valuemask, 2);
//	UpdateScrollBar();

	XtAppAddTimeOut(app, 5000, (XtTimerCallbackProc) SetCell4, NULL);

//	XtVaSetValues(prs, XmNnumColumns, 3, NULL);
//	XtAppAddTimeOut(app, 10000, (XtTimerCallbackProc) ChangeColNum2, NULL);
}


void SetCell2(XtPointer data)
{
	cell.xmlabel = XmStringCreateLocalized("---Partition 2----");
	cell.pixmap = XmUNSPECIFIED_PIXMAP;
	cell.mask = XmUNSPECIFIED_PIXMAP;
	cell.alignment = XmALIGNMENT_END;
	cell.element_type = XmSTRING;
	cell.priority = XmSTRING;
	
	XmNlPartResSetCell(prs, &cell, valuemask, 1);
//	UpdateScrollBar();

	XtAppAddTimeOut(app, 5000, (XtTimerCallbackProc) SetCell3, NULL);

//	XtVaSetValues(prs, XmNnumColumns, 3, NULL);
//	XtAppAddTimeOut(app, 10000, (XtTimerCallbackProc) ChangeColNum2, NULL);
}


void SetCell1(XtPointer data)
{
	cell.xmlabel = XmStringCreateLocalized("Partition 1");
	cell.pixmap = XmUNSPECIFIED_PIXMAP;
	cell.mask = XmUNSPECIFIED_PIXMAP;
	cell.alignment = XmALIGNMENT_BEGINNING;
	cell.element_type = XmSTRING;
	cell.priority = XmSTRING;
	
	XmNlPartResSetCell(prs, &cell, valuemask, 0);
//	UpdateScrollBar();

	XtAppAddTimeOut(app, 5000, (XtTimerCallbackProc) SetCell2, NULL);

//	XtVaSetValues(prs, XmNnumColumns, 3, NULL);
//	XtAppAddTimeOut(app, 10000, (XtTimerCallbackProc) ChangeColNum2, NULL);
}

void SetRow(XtPointer data)
{
	XmNlPartResSetRow(prs, cells, valuemask);
//	UpdateScrollBar();

//	XtAppAddTimeOut(app, 5000, (XtTimerCallbackProc) SetCell2, NULL);

//	XtVaSetValues(prs, XmNnumColumns, 3, NULL);
//	XtAppAddTimeOut(app, 10000, (XtTimerCallbackProc) ChangeColNum2, NULL);
}

void ChangeColNum2(XtPointer data)
{
//	XtVaSetValues(prs, XmNnumColumns, 3, NULL);
//	XtAppAddTimeOut(app, 10000, (XtTimerCallbackProc) ChangeColNum2, NULL);
	XtVaSetValues(prs, XmNnumCols, 3, NULL);
	CurrentColNum = 3;
//	UpdateScrollBar();
}


void ChangeColNum(XtPointer data)
{
	XtVaSetValues(prs, XmNnumCols, MAX_COL_NUM, NULL);
	CurrentColNum = MAX_COL_NUM;
//	UpdateScrollBar();
//	XtVaSetValues(prs, XmNnumCols, 4, NULL);
//	XtAppAddTimeOut(app, 5000, (XtTimerCallbackProc) SetCell1, NULL);
	XtAppAddTimeOut(app, 5000, (XtTimerCallbackProc) SetRow, NULL);
}

void resize_cb(Widget wid, XtPointer client_data, XEvent *event)
{
	Widget clip;
	Dimension * Width;
	int view_w, full_w, shift;

//#ifdef DEBUG
	printf("----- Start resize \n");
//#endif
//return;


	if (event->type == ConfigureNotify)
	{
		XConfigureEvent * cevent = (XConfigureEvent *) event;


      /*
       * If the incoming size is different than the current size of the
       * scrolled window, then ignore this event, since it means that our
       * size has changed since this configure notify event was generated;
       * we'll wait for the next one to arrive, and try again.
       */
/*		if ((XtHeight(button) != cevent->height) ||
			(XtWidth(button) != cevent->width))
		{
			printf("Missed event\n");
			return;
		}
*/		
//		UpdateScrollBar();
	}
}

int main(int argc, char **argv)
{
	Arg           args[10];
	int           n, i, c1, c2, c3, c4;
	XtSetLanguageProc (NULL, NULL, NULL);
	toplevel = XtVaOpenApplication (&app, "Demos", NULL, 0, &argc, argv,
                             NULL, sessionShellWidgetClass, NULL);
//	toplevel = XtVaOpenApplication (&app, "Demos", NULL, 0, &argc, argv,
//                             NULL, sessionShellWidgetClass, XmNlayoutDirection, XmRIGHT_TO_LEFT_BOTTOM_TO_TOP, NULL);
	c1=1;
	c2=2;
	c3=3;
	c4=4;
	n = 0;

	CreateIcons();
	CreateCells();
	
	PartSize[0] = 50;
	PartSize[1] = 25;
	PartSize[2] = 10;
	PartSize[3] = 15;

	form = XmCreateForm (toplevel, "Form",   args, n);

	prs = XtVaCreateWidget ("partres", xmNlPartResWidgetClass, form, 
							XmNnumCols, CurrentColNum, XmNPRmod, XmNPR_Proportional, 
							XmNpartitionsSize, PartSize, NULL);
//	prs = XtVaCreateWidget ("partres", xmNlPartResWidgetClass, form, NULL);

	XtVaSetValues(prs,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
//			XmNheight, 60,
			NULL);

	button1 = XmCreatePushButton(form, "Change proportions type 1", NULL, 0);
	button2 = XmCreatePushButton(form, "Change proportions type 2", NULL, 0);

	XtAddCallback(button1, XmNactivateCallback, Btn1Callback, (XtPointer) NULL);
	XtAddCallback(button2, XmNactivateCallback, Btn2Callback, (XtPointer) NULL);

	XtVaSetValues(button2,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, button1,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_FORM,
//			XmNheight, 300,
			NULL);

	XtVaSetValues(button1,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, prs,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
//			XmNbottomAttachment, XmATTACH_WIDGET,
//			XmNbottomWidget, button,
//			XmNheight, 300,
			NULL);

//	XtVaSetValues(prs,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, prs,
//			XmNleftAttachment, XmATTACH_FORM,
//			XmNrightAttachment, XmATTACH_FORM,
//			XmNbottomAttachment, XmATTACH_WIDGET,
//			XmNbottomWidget, hsb,
//			XmNheight, 300,
//			NULL);


  XtManageChild (form);
  XtManageChild (button1);
  XtManageChild (button2);
  XtManageChild (prs);
//  XtVaSetValues(prs,
//			XmNPRmod, XmNPR_Manual,
//			NULL);
//  PRSetElements(prs, string_count, record);

	SetRow(NULL);
	XtRealizeWidget (toplevel);
  

//	XtAddEventHandler(button, StructureNotifyMask,
//                      False, (XtEventHandler)resize_cb,
//                      NULL);
//  XtAppAddTimeOut(app, 5000, (XtTimerCallbackProc) SetRow, NULL);

//  XtAppAddTimeOut(app, 5000, (XtTimerCallbackProc) ChangeColNum, NULL);
  
	XtAppMainLoop (app);
	return 0;
}
