
#include <stdlib.h>
#include <stdio.h>

#include <Xm/XmAll.h>
#include <X11/xpm.h>

//#include "XmNlListTree.h"
#include "XmNlResColList.h"


Widget toplevel, paned, form, tree, list, sw, sm_vsb, sm_hsb;
Widget form, button1, button2, button3, button4, button5, button6;
XtAppContext app_con;
Pixmap icon1, icon2, icon3;
Pixmap mask1, mask2, mask3;





void Init(Widget tree)
{
int i,j,k,l;
char test[64];
XmNlCell * cell;

XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), "./icons/mailfolder.xpm",
		      &icon1, &mask1, (XpmAttributes *) NULL);
XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), "./icons/music.xpm",
		      &icon2, &mask2, (XpmAttributes *) NULL);
XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), "./icons/sounds.xpm",
		      &icon3, &mask3, (XpmAttributes *) NULL);
unsigned char valuemask = CellXmString | CellCharString | CellUserData;
	
XmNlListTreeItem *node1, *node2, *node3, *node4;
	for (i=0; i<5; i++) {
	  	sprintf(test,"Node %d", i);

		cell = (XmNlCell *) calloc(1, sizeof(XmNlCell));

		cell->text=(char *)calloc(strlen(test), 1);
		strcpy(cell->text, test);
		printf("listtreetset: %s\n", cell->text);
		cell->xmlabel = XmStringCreateLocalized(cell->text);
		cell->UserDataPointer=(void *) NULL;
		cell->pixmap= XmUNSPECIFIED_PIXMAP;
		cell->mask=XmUNSPECIFIED_PIXMAP;

		node1=XmNlRCTreeAdd(tree, NULL, cell, valuemask);
		XmNlTreeSetItemPixmaps (tree, node1, icon1, icon1, mask1, mask1);
		for (j=0; j<i; j++) {
			sprintf(test,"Node %d, Subnode a%d, level 1", i, j);

			cell = (XmNlCell *) calloc(1, sizeof(XmNlCell));

			cell->text=(char *)calloc(strlen(test), 1);
			strcpy(cell->text, test);
			printf("listtreetset: %s\n", cell->text);
			cell->xmlabel = XmStringCreateLocalized(cell->text);
			cell->UserDataPointer=(void *) NULL;
			cell->pixmap= XmUNSPECIFIED_PIXMAP;
			cell->mask=XmUNSPECIFIED_PIXMAP;


			node2=XmNlRCTreeAdd(tree, node1, cell, valuemask);
			XmNlTreeSetItemPixmaps (tree, node2, icon2, icon2, mask2, mask2);
			for (k=0; k<i; k++) {
				sprintf(test,"Node %d, Subnode b%d, level 2", i, k);

				cell = (XmNlCell *) calloc(1, sizeof(XmNlCell));

				cell->text=(char *)calloc(strlen(test), 1);
				strcpy(cell->text, test);
				printf("listtreetset: %s\n", cell->text);
				cell->xmlabel = XmStringCreateLocalized(cell->text);
				cell->UserDataPointer=(void *) NULL;
				cell->pixmap= XmUNSPECIFIED_PIXMAP;
				cell->mask=XmUNSPECIFIED_PIXMAP;


				node3=XmNlRCTreeAdd(tree, node2, cell, valuemask);
//				XmNlTreeSetItemPixmaps (tree, node3, icon3, icon3, mask3, mask3);
				for (l=0; l<i; l++) {
					sprintf(test,"Node %d, Subnode c%d, level 3",i, l);

					cell = (XmNlCell *) calloc(1, sizeof(XmNlCell));

					cell->text=(char *)calloc(strlen(test), 1);
					strcpy(cell->text, test);
					printf("listtreetset: %s\n", cell->text);
					cell->xmlabel = XmStringCreateLocalized(cell->text);
					cell->UserDataPointer=(void *) NULL;
					cell->pixmap= XmUNSPECIFIED_PIXMAP;
					cell->mask=XmUNSPECIFIED_PIXMAP;


					node4=XmNlRCTreeAdd(tree, node3, cell, valuemask);
				}
			}
		}
	}

}







void Btn1Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	int count;
	int * rows;
	XmNlListTreeItem *node;
		
	XtVaGetValues(tree, XmNselectedItemCount, &count, XmNselectedPositions, &rows, NULL);

	if (count > 0)
	{
		printf("Selected %d items\n", count);

		node = XmNlRCTreeGetItemByRow(tree, *rows);

		XmNlRCTreeDeleteItem(tree, node);
	}
}


void Btn2Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	unsigned char valuemask = 0 | CellXmString | CellPixmap | CellMask | CellCharString | CellUserData ;
	int count;
	int * rows;
	XmNlCell cell;
	char test[64];
	XmNlListTreeItem *node;
		
	XtVaGetValues(tree, XmNselectedItemCount, &count, XmNselectedPositions, &rows, NULL);

	if (count > 0)
	{
		printf("Selected %d items\n", count);

		node = XmNlRCTreeGetItemByRow(tree, *rows);

	  	sprintf(test,"Node added to %d row", *rows);


		cell.text = (char *)calloc(strlen(test), 1);
		strcpy(cell.text, test);
		cell.xmlabel = XmStringCreateLocalized(cell.text);
		cell.UserDataPointer = (void *) NULL;
		cell.pixmap = XmUNSPECIFIED_PIXMAP;
		cell.mask = XmUNSPECIFIED_PIXMAP;

		XmNlRCTreeAdd(tree, node, &cell, valuemask);
		XmNlRCTreeRefresh(tree);
	}
}

void Btn3Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	unsigned char valuemask = 0 | CellXmString | CellPixmap | CellMask | CellCharString | CellUserData ;
	int count;
	int * rows;
	XmNlCell cell;
	char test[64];
	XmNlListTreeItem *node;
		
	XtVaGetValues(tree, XmNselectedItemCount, &count, XmNselectedPositions, &rows, NULL);

	if (count > 0)
	{
		printf("Selected %d items\n", count);

		node = XmNlRCTreeGetItemByRow(tree, *rows);

	  	sprintf(test,"Node added to %d row", *rows);


		cell.text = (char *)calloc(strlen(test), 1);
		strcpy(cell.text, test);
		cell.xmlabel = XmStringCreateLocalized(cell.text);
		cell.UserDataPointer = (void *) NULL;
		cell.pixmap = XmUNSPECIFIED_PIXMAP;
		cell.mask = XmUNSPECIFIED_PIXMAP;

		XmNlRCTreeInsert(tree, node, &cell, valuemask);
		XmNlRCTreeRefresh(tree);
	}
}

void Btn4Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	unsigned char valuemask = 0 | CellXmString | CellPixmap | CellMask | CellCharString | CellUserData ;
	int count;
	int * rows;
	XmNlCell cell;
	char test[64];
	XmNlListTreeItem *node;
		
	XtVaGetValues(tree, XmNselectedItemCount, &count, XmNselectedPositions, &rows, NULL);

	if (count > 0)
	{
		printf("Selected %d items\n", count);

		node = XmNlRCTreeGetItemByRow(tree, *rows);

	  	sprintf(test,"Node inserted before %d row", *rows);


		cell.text = (char *)calloc(strlen(test), 1);
		strcpy(cell.text, test);
		cell.xmlabel = XmStringCreateLocalized(cell.text);
		cell.UserDataPointer = (void *) NULL;
		cell.pixmap = XmUNSPECIFIED_PIXMAP;
		cell.mask = XmUNSPECIFIED_PIXMAP;

		XmNlRCTreeInsertBeforeItem(tree, node, &cell, valuemask);
		XmNlRCTreeRefresh(tree);
	}
}

void Btn5Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	unsigned char valuemask = 0 | CellXmString | CellPixmap | CellMask | CellCharString | CellUserData ;
	int count;
	int * rows;
	XmNlCell cell;
	char test[64];
	XmNlListTreeItem *node;
		
	XtVaGetValues(tree, XmNselectedItemCount, &count, XmNselectedPositions, &rows, NULL);

	if (count > 0)
	{
		printf("Selected %d items\n", count);

		node = XmNlRCTreeGetItemByRow(tree, *rows);

	  	sprintf(test,"Node added after %d row", *rows);


		cell.text = (char *)calloc(strlen(test), 1);
		strcpy(cell.text, test);
		cell.xmlabel = XmStringCreateLocalized(cell.text);
		cell.UserDataPointer = (void *) NULL;
		cell.pixmap = XmUNSPECIFIED_PIXMAP;
		cell.mask = XmUNSPECIFIED_PIXMAP;

		XmNlRCTreeAddAfterItem(tree, node, &cell, valuemask);
		XmNlRCTreeRefresh(tree);
	}
}


void Btn6Callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	Init(tree);
	XmNlRCTreeRefresh(tree);
}


void hgl_callback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ListItemReturnStruct * rez = (ListItemReturnStruct *) call_data;
	int i;
	XmNlListTreeItem * item;

	printf("listtreetest3: selected %d items\n", rez->count);
	for (i = 0; i < rez->count; i++)
	{
		printf("listtreetest3: selected item at row %d\n", rez->number[i]);
	}

	if (rez->count > 0)
	{
		item = XmNlRCTreeGetItemByRow(w, rez->number[0]);
	}
}




int main (int argc, char **argv)
{
	Pixmap open,closed, file_open, file_closed; 
	Pixmap openMask,closedMask, file_openMask, file_closedMask; 
	Pixel bg;
	Arg           args[10];
	int           n;
	XmNlColSpecRec * colspec;


	toplevel = XtAppInitialize(&app_con,"TreeDemo",NULL,0,
				&argc,argv,NULL,NULL,0);

	XtVaGetValues(toplevel, XtNbackground, &bg, NULL);

	XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), "./icons/folder_up_small.xpm",
			      &open,&openMask, (XpmAttributes *) NULL);
	XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), "./icons/folder_small.xpm",
			      &closed,&closedMask, (XpmAttributes *) NULL);
	XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), "./icons/file_small.xpm",
			      &file_open,&file_openMask, (XpmAttributes *) NULL);
	XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), "./icons/file_small.xpm",
			      &file_closed,&file_closedMask, (XpmAttributes *) NULL);





	form = XmCreateForm (toplevel, "Form",   args, n);
	
	printf("xmlist1: Form Created\n");


	button1 = XmCreatePushButton(form, "Delete selected item", NULL, 0);
	button2 = XmCreatePushButton(form, "Add to Parent", NULL, 0);
	button3 = XmCreatePushButton(form, "Insert to Parent", NULL, 0);
	button4 = XmCreatePushButton(form, "Insert before Position", NULL, 0);
	button5 = XmCreatePushButton(form, "Add after position", NULL, 0);
	button6 = XmCreatePushButton(form, "Add tree", NULL, 0);

	XtAddCallback(button1, XmNactivateCallback, Btn1Callback, (XtPointer) NULL);
	XtAddCallback(button2, XmNactivateCallback, Btn2Callback, (XtPointer) NULL);
	XtAddCallback(button3, XmNactivateCallback, Btn3Callback, (XtPointer) NULL);
	XtAddCallback(button4, XmNactivateCallback, Btn4Callback, (XtPointer) NULL);
	XtAddCallback(button5, XmNactivateCallback, Btn5Callback, (XtPointer) NULL);
	XtAddCallback(button6, XmNactivateCallback, Btn6Callback, (XtPointer) NULL);


	XtVaSetValues(button1,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button2,
			NULL);

	XtVaSetValues(button2,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button3,
			NULL);

	XtVaSetValues(button3,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button4,
			NULL);

	XtVaSetValues(button4,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button5,
			NULL);

	XtVaSetValues(button5,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, button6,
			NULL);

	XtVaSetValues(button6,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_FORM,
			NULL);



	n = 0;
	XtSetArg (args[n], XmNwidth, 500); n++;
	XtSetArg (args[n], XmNheight, 300); n++;
	XtSetArg (args[n], XmNscrollingPolicy, XmAPPLICATION_DEFINED); n++;
	XtSetArg (args[n], XmNshadowThickness, 2); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNbottomWidget, button1); n++;
	sw = XmCreateScrolledWindow (form, "scrolled_w",   args, n);

	n = 0;
	XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
	XtSetArg(args[n], XmNmaximum, 1); n++;
	XtSetArg(args[n], XmNsliderSize, 1); n++;
	sm_vsb = XmCreateScrollBar(sw, "sm_vsb", args, n);
	XtManageChild(sm_vsb);
	
	n = 0;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg(args[n], XmNmaximum, 1); n++;
	XtSetArg(args[n], XmNsliderSize, 1); n++;
	sm_hsb = XmCreateScrollBar(sw, "sm_hsb", args, n);
	XtManageChild(sm_vsb);
	XtManageChild(sm_hsb);

	tree = XtVaCreateManagedWidget("tree", xmNlResColListWidgetClass, sw,
          XmNlNhorizontalSpacing,   5,
          XmNlNverticalSpacing,     5,
		XmNverticalScrollBar, sm_vsb, 
		XmNhorizontalScrollBar, sm_hsb,
          XtNbranchPixmap,	closed,
          XtNbranchPixmapMask,	closedMask,
          XtNbranchOpenPixmap,	open,
           XtNbranchOpenPixmapMask,	openMask,
         XtNleafPixmap,		file_closed,
         XtNleafPixmapMask,		file_closedMask,
          XtNleafOpenPixmap,	file_open,
          XtNleafOpenPixmapMask,	file_openMask,
		XmNlTreeMode, True,
          NULL);
        XtManageChild(tree);

	n = 0;
	XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
	XtSetArg( args[n], XmNcolType, XmSTRING); n++;
	colspec = XmNlColSpecCreate(XtDisplay(tree), NULL, "0", args, n);
	printf("********************************** Append column 0\n");
	XmNlResColAppendColumn(tree, colspec);
	XmNlColSpecFree(colspec);

	XtAddCallback(tree, XtNhighlightCallback, hgl_callback, (XtPointer) NULL); 
        
	XtManageChild (form);
	XtManageChild (button1);
	XtManageChild (button2);
	XtManageChild (button3);
	XtManageChild (button4);
	XtManageChild (button5);
	XtManageChild (button6);
	XtManageChild (sw);
	Init(tree);
	printf("listtreetest3: next XmNlRCTreeRefresh\n");
	XmNlRCTreeRefresh(tree);
/*	XtAddCallback(tree,XmNlNhighlightCallback, HighlightCallback, (XtPointer) NULL);
	XtAddCallback(tree,XmNlNactivateCallback, ActivateCallback, (XtPointer) NULL);
	XtAddCallback(tree,XmNlNmenuCallback, MenuCallback, (XtPointer) NULL);
*/
	XtRealizeWidget(toplevel);

	XtAppMainLoop(app_con);
	return(0);
}
