#include <Xm/XmAll.h>
#include <pwd.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include "XmNlItemBox.h"
#include "XmNl.h"
#include <string.h>
#include <X11/cursorfont.h>
#include <X11/xpm.h>
#include <stdlib.h>

static char *names[] = {
"acroread.xpm",       "fonts.xpm",         "kruler.xpm",         "pysol.xpm",
"applications.xpm",   "font.xpm",          "ksame.xpm",          "raster.xpm",
"app_link.xpm",       "framemaker.xpm",    "kscd.xpm",           "rc.xpm",
"app_plain.xpm",      "games_arcade.xpm",  "kscreensaver.xpm",   "readme.xpm",
"app.xpm",            "games_board.xpm",   "kshisen.xpm",        "realplayer.xpm",
"ark.xpm",            "games_card.xpm",    "ksirtet.xpm",        "recycle.xpm",
"blender.xpm",        "games.xpm",         "ksmiletris.xpm",     "redhat.xpm",
"bluelogo.xpm",       "gears2.xpm",        "ksnake.xpm",         "res.xpm",
"bookshelf.xpm",      "gears.xpm",         "ksnapshot.xpm",      "samba.xpm",
"book.xpm",           "ghostview.xpm",     "ksokoban.xpm",       "script_file.xpm",
"bug.xpm",            "ghost.xpm",         "kspread.xpm",        "script_link.xpm",
"calc2.xpm",          "gif.xpm",           "ksysguard.xpm",      "script_plain.xpm",
"calc.xpm",           "gimp.xpm",          "ksysv.xpm",          "script.xpm",
"camera.xpm",         "gnorpm.xpm",        "kthememgr.xpm",      "scsi.xpm",
"cdrom.xpm",          "gnu.xpm",           "ktron.xpm",          
"cervisia.xpm",       "graph.xpm",         "kuickshow.xpm",      "sounds2.xpm",
"chess2.xpm",         "gvim.xpm",          "kuser.xpm",          "sounds.xpm",
"chess3.xpm",         "gv.xpm",            "kviewshell.xpm",     "sound.xpm",
"chess.xpm",          "hammer.xpm",        "kwin.xpm",           "stuff.xpm",
"chip.xpm",           "harddrive.xpm",     "kword.xpm",          "stylesheet.xpm",
"circuit2.xpm",       "helpme.xpm",        "licq.xpm",           "style.xpm",
"circuit.xpm",        "hex.xpm",           "link_shadow.xpm",    "suitcase.xpm",
"clip_file.xpm",      "home2.xpm",         "link.xpm",           "susehelpcenter.xpm",
"clip_folder.xpm",    "home.xpm",          "lisp.xpm",           "system.xpm",
"clip.xpm",           "html.xpm",          "list.xpm",           "tape_net.xpm",
"compressed.xpm",     "hwinfo.xpm",        "lnxzip.xpm",         "tape.xpm",
"compress.xpm",       "icons.xpm",         "locale.xpm",         "tar.xpm",
"cookie.xpm",         "icon.xpm",          "lyx.xpm",            "teddy.xpm",
"core.xpm",           "iff.xpm",           "mag_glass.xpm",      "term.xpm",
"cycle.xpm",          "info.xpm",          "magic.xpm",          "text.xpm",
"data.xpm",           "jpeg.xpm",          "mailfolder.xpm",     "tex.xpm",
"date.xpm",           "kaboodle.xpm",      "mail.xpm",           "tiff.xpm",
"debug.xpm",          "kalarm.xpm",        "makefile.xpm",       "tmpfile.xpm",
"designer.xpm",       "karm.xpm",          "make.xpm",           "tools.xpm",
"dev_cdrom.xpm",      "kasteroids.xpm",    "manpage.xpm",        "trash_empty.xpm",
"dev_floppy.xpm",     "kbackgammon.xpm",   "manual.xpm",         "trash_full.xpm",
"dev_harddrive.xpm",  "kcalc.xpm",         "mathematica.xpm",    "typewriter.xpm",
"diff.xpm",           "kchart.xpm",        "memory.xpm",         "url.xpm",
"dlgedit.xpm",        "kcoloredit.xpm",    "midi.xpm",           "usb.xpm",
"dot_a.xpm",          "kcontrol.xpm",      "modem.xpm",          "uu.xpm",
"dot_cc.xpm",         "kcron.xpm",         "mouse.xpm",          "video.xpm",
"dot_c.xpm",          "kdat.xpm",          "movies.xpm",         "wabi.xpm",
"dot_h.xpm",          "kdf.xpm",           "mozilla.xpm",        "windows.xpm",
"dot_o.xpm",          "kdict.xpm",         "multimedia.xpm",     "winprops.xpm",
"dot_sa.xpm",         "kdmconfig.xpm",     "music.xpm",          "winzip.xpm",
"dot_so.xpm",         "kedit.xpm",         "nedit.xpm",          "wizard.xpm",
"draw2.xpm",          "kenolaba.xpm",      "netscape.xpm",       "wp.xpm",
"draw.xpm",           "kfax.xpm",          "news.xpm",           "write.xpm",
"dvi.xpm",            "kfloppy.xpm",       "noatun.xpm",         "writings.xpm",
"editor.xpm",         "kfm.xpm",           "opera.xpm",          "xapp.xpm",
"editres.xpm",        "kfract.xpm",        "paint2.xpm",         "xbm.xpm",
"edit.xpm",           "khelpcenter.xpm",   "paintings.xpm",      "xclipboard.xpm",
"ee.xpm",             "khexedit.xpm",      "paint.xpm",          "xclock.xpm",
"emacs.xpm",          "kicker.xpm",        "paragraphs.xpm",     "xeyes.xpm",
"email.xpm",          "kiconedit.xpm",     "password.xpm",       "xfig2.xpm",
"empty.xpm",          "kjots.xpm",         "pbm.xpm",            "xfig.xpm",
"exec2.xpm",          "kjumpingcube.xpm",  "pci.xpm",            "xfmail.xpm",
"exec.xpm",           "klines.xpm",        "pdf.xpm",            "xload.xpm",
"fig.xpm",            "klipper.xpm",       "penguin.xpm",        "xlogo.xpm",
"file_bad.xpm",       "kljettool.xpm",     "pgm.xpm",            "xmag.xpm",
"file_link_bad.xpm",  "klpq.xpm",          "pharmacy.xpm",       "xmcd.xpm",
"file_link.xpm",      "kmahjongg.xpm",     "pictures.xpm",       "xmms.xpm",
"fileman.xpm",        "kmidi.xpm",         "plan.xpm",           "xosview.xpm",
"fileserver.xpm",     "kmid.xpm",          "plaster.xpm",        "xpaint.xpm",
"files.xpm",          "kmines.xpm",        "ppm.xpm",            "xplate.xpm",
"filetypes.xpm",      "knotes.xpm",        "printer2.xpm",       "xrolodex.xpm",
"file.xpm",           "korn.xpm",          "printer3.xpm",       "xterm.xpm",
"find.xpm",           "kpackage.xpm",      "printer.xpm",        "xv2.xpm",
"fish.xpm",           "kpaint.xpm",        "printmgr.xpm",       "xv.xpm",
"floppy.xpm",         "kpat.xpm",          "processor.xpm",      "x.xpm",
"folder_bad.xpm",     "kpoker.xpm",        "proxy.xpm",          "zip.xpm",
"folder_link.xpm",    "kppp.xpm",          "ps2.xpm",            "zoo.xpm",
"folder_up.xpm",      "kpresenter.xpm",    "ps.xpm",
"folder.xpm",         "kreversi.xpm",      "pybliographic.xpm",  NULL,
};



	Widget        toplevel, sw, iconbox, form, label1, label2, vsb, hsb;
	Widget edit1, edit2, button1;
    XtAppContext app;

int icon_n=23;
int item_num=100;

const char MyString[20]="my_string";
const char MyStringOther[20]="my_string_number_2";
const char icon_prefix[30]="./icons/";
char icon_name[100];
XmNlCell *Cells;

int GlobalCellNumber;
char * GlobalCellText = NULL;
Pixmap ChPix, ChMask;

void ChangeCell(Widget w, XtPointer client_data, XtPointer call_data)
{
	char * mptr;
	XmString mstring;
	unsigned char mask = CellXmString | CellCharString | CellPixmap | CellMask;
	XmNlCell cell;

	if (!GlobalCellText) 
	{
		mptr = XmTextFieldGetString(edit2);
		GlobalCellText = calloc(strlen(mptr)+1, sizeof(char));
		strcpy(GlobalCellText, mptr);
		XtFree(mptr);
	}

	mptr = XmTextFieldGetString(edit1);
	
	sscanf( mptr, "%d", &GlobalCellNumber);
	
	XtFree(mptr);

	cell.text = GlobalCellText;

	cell.xmlabel = XmStringCreateLocalized(GlobalCellText);
	
	cell.pixmap = ChPix;
	
	cell.mask = ChMask;
	
	XmNlItBoxSetItem(iconbox, &cell, mask, GlobalCellNumber);

	XmStringFree(cell.xmlabel);
}

void NumberCell(Widget w, XtPointer client_data, XtPointer call_data)
{
	char * mptr;

	mptr = XmTextFieldGetString(w);
	
	sscanf( mptr, "%d", &GlobalCellNumber);
	
	XtFree(mptr);

}

void TextCell(Widget w, XtPointer client_data, XtPointer call_data)
{
	char * mptr;

	mptr = XmTextFieldGetString(edit2);


	if (GlobalCellText) free(GlobalCellText);
	GlobalCellText = calloc(strlen(mptr)+1, sizeof(char));
	strcpy(GlobalCellText, mptr);
	XtFree(mptr);

}

void DblClCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ItemActivateReturnStruct *data;
	XmNlCell CellItem;
	XmString str;
	Boolean ok;
	unsigned char * string;
	unsigned int len;


    data=(ItemActivateReturnStruct *)call_data;
    printf("\n--------- iboxtest3: Callback called 1 ---------\n");
    printf("\niboxtest3: item=%d \t name=%s", data->item_number, (char *) data->pointer);

    ok = XmNlItBoxGetItem(iconbox, &CellItem, CellXmString | CellUserData | CellCharString | CellAlignment | CellSelection, data->item_number+1);
	if (ok)
	{
		printf("Properties for item %d\n", data->item_number+1);
		len = XmCvtXmStringToByteStream(CellItem.xmlabel, &string);
		XmStringFree(CellItem.xmlabel);
		printf("Retrieved from XmStringq %s\n", string);
		printf("Text %s\n", CellItem.text);
		printf("UserData %s\n", CellItem.UserDataPointer);
		if (CellItem.selected) printf("Item is selected\n");
		else printf("Item is not selected\n");
		if (CellItem.alignment == XmALIGNMENT_UNSPECIFIED) printf("Not aligned \n");
		if (CellItem.alignment == XmALIGNMENT_BEGINNING) printf("Aligned to begin\n");
		if (CellItem.alignment == XmALIGNMENT_END) printf("Aligned to end\n");
	}

 
}

void HlgCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ListItemReturnStruct *data;
    int i;
    data=(ListItemReturnStruct *)call_data;

printf("\n+++++ iboxtest3: Callback clled 2 +++++++++\n");
printf("\n iboxtest3: Num_item=%d ", data->count);
if (data->count==0) return;
for (i=0; i<data->count; i++)
	{
	printf("\niboxtest3: item=%d \t name=%s", data->number[i], (char *) data->pointers[i]);
//	printf("\nTest: Item_number=%d", data->number[i]);
	printf("\n");

	}
printf("\n+++++ iboxtest3: Callback complet 2 +++++++++\n");
printf("\n");
}



int main(int argc, char **argv)
{
	Arg           args[10];
	int           n, i, k;
	Colormap colmap;
	XColor col_1, col_2;
	XmString mstring;
	unsigned char mask = CellPixmap | CellMask | CellXmString | CellCharString | CellUserData;
	
	XtSetLanguageProc (NULL, NULL, NULL);
	toplevel = XtVaOpenApplication (&app, "Demos", NULL, 0, &argc, argv,
                             NULL, sessionShellWidgetClass, NULL);
/* Create a 500x300 scrolled window. This value is arbitrary,
** but happens to look good initially. It is resizable by the user.
*/

	
	form = XmCreateForm (toplevel, "Form",   args, 0);

	label1 = XmCreateLabel(form, "Number", NULL, 0);

	edit1 = XmCreateTextField(form, "number", NULL, 0);

	label2 = XmCreateLabel(form, "String", NULL, 0);

	edit2 = XmCreateTextField(form, "string", NULL, 0);

	button1=XmCreatePushButton(form, "Change", NULL, 0);

	XtAddCallback(edit1, XmNactivateCallback, NumberCell, (XtPointer)10);
	XtAddCallback(edit2, XmNactivateCallback, TextCell, (XtPointer)10);

	n = 0;
	XtSetArg (args[n], XmNwidth, 500); n++;
	XtSetArg (args[n], XmNheight, 300); n++;
	XtSetArg (args[n], XmNscrollingPolicy, XmAPPLICATION_DEFINED); n++;
	sw = XmCreateScrolledWindow (form, "scrolled_w",   args, n);

	n=0;
	XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
	XtSetArg(args[n], XmNmaximum, 1); n++;
	XtSetArg(args[n], XmNsliderSize, 1); n++;
	vsb=XmCreateScrollBar(sw, "sm_vsb", args, n);

	n=0;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg(args[n], XmNmaximum, 1); n++;
	XtSetArg(args[n], XmNsliderSize, 1); n++;
	hsb=XmCreateScrollBar(sw, "sm_hsb", args, n);

	XtManageChild(vsb);
	XtManageChild(hsb);

	XtVaSetValues(label1,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(edit1,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, label1,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(label2,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, edit1,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(edit2,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, label2,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);


	XtVaSetValues(button1,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, edit2,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);


	XtVaSetValues(sw,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, button1,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_FORM,
			NULL);



	XtAddCallback(button1, XmNactivateCallback, ChangeCell, (XtPointer) NULL);

	iconbox = XtVaCreateWidget ("my button", xmNlItemBoxWidgetClass, sw, NULL);
	Cells=malloc(item_num*sizeof(XmNlCell));
	k=0;
	for (i=0; i<item_num; i++)
	{
		if (k>=icon_n) k=0;
		Cells[i].text=calloc(strlen(MyString)+5, 1);
		sprintf(Cells[i].text, "%s %d", MyString, i);
		Cells[i].UserDataPointer=(void *)Cells[i].text;
		mstring = XmStringCreateLocalized(Cells[i].text);
		
		Cells[i].xmlabel = mstring;
		
		sprintf(icon_name, "%s%s", icon_prefix, names[k]);
		XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), icon_name,
			      &(Cells[i].pixmap), &(Cells[i].mask), (XpmAttributes *) NULL);
			      
		if (k == 0)
		{
			ChPix =Cells[i].pixmap;
			ChMask = Cells[i].mask;
		}
//		Cells[i].selected=Select;
//		Select= !Select;
//		printf("\n name=%s \n",MyItem[i].name );
		k++;
	}
      	k=2;
	XmNlItBoxAddItems(iconbox, Cells, item_num, mask);
	for (i=0; i<item_num; i++)
	{
		XmStringFree(Cells[i].xmlabel);
	}
	

	XtVaSetValues(iconbox, XmNverticalScrollBar, vsb, XmNhorizontalScrollBar, hsb, NULL);
	colmap=DefaultColormapOfScreen(XtScreen(iconbox));
	XAllocNamedColor(XtDisplay(toplevel), colmap, "darkred", &col_1, &col_2);
	XtVaSetValues(iconbox, XmNselectColor, col_2.pixel, NULL);
	XAllocNamedColor(XtDisplay(toplevel), colmap, "white", &col_1, &col_2);
	XtVaSetValues(iconbox, XmNselectForeground, col_2.pixel, NULL);
	XtAddCallback(iconbox, XtNhighlightCallback, HlgCallback, (XtPointer) NULL);
	XtAddCallback(iconbox, XmNdoubleClickCallback, DblClCallback, (XtPointer) NULL);
  
	
  XtManageChild(form);
  XtManageChild(edit1);
  XtManageChild(edit2);
  XtManageChild(label1);
  XtManageChild(label2);
	
  XtManageChild(button1);
  XtManageChild (iconbox);
  XtManageChild (sw);
  XtRealizeWidget (toplevel);
  XtAppMainLoop (app);
  return 0;
}
