#include <Xm/XmAll.h>
#include <pwd.h>
#include <Xm/PushB.h>
#include "XmNlItemBox.h"
#include "XmNl.h"
#include <string.h>
#include <X11/cursorfont.h>
#include <X11/xpm.h>
#include <stdlib.h>

static char *names[] = {
"acroread.xpm",	"applications.xpm",	"app_link_small.xpm",	"app_link.xpm",	"app_plain.xpm",	"app_small.xpm",
"app.xpm",	"ark.xpm",	"blender.xpm",	"bluelogo.xpm",	"bookshelf_small.xpm",	"bookshelf.xpm",
"book.xpm",	"bug.xpm",	"calc2.xpm",	"calc.xpm",	"camera.xpm",	"cdrom.xpm",
"cervisia.xpm",	"chess2.xpm",	"chess3.xpm",	"chess.xpm",	"chip.xpm",	"circuit2.xpm",
"circuit.xpm",	"clip_file.xpm",	"clip_folder.xpm",	"clip.xpm",	"compressed.xpm",	"compress.xpm",
"cookie.xpm",	"core.xpm",	"cycle.xpm",	"data.xpm",	"date.xpm",	"debug.xpm",
"designer.xpm",	"dev_cdrom.xpm",	"dev_floppy.xpm",	"dev_harddrive.xpm",	"diff.xpm",	"dlgedit.xpm",
"dot_a.xpm",	"dot_cc.xpm",	"dot_c.xpm",	"dot_h.xpm",	"dot_o.xpm",	"dot_sa.xpm",
"dot_so.xpm",	"draw2.xpm",	"draw.xpm",	"dvi.xpm",	"editor.xpm",	"editres.xpm",
"edit.xpm",	"ee.xpm",	"emacs.xpm",	"email.xpm",	"empty.xpm",	"exec2.xpm",
"exec.xpm",	"fig.xpm",	"file_bad_small.xpm",	"file_bad.xpm",	"file_link_bad_small.xpm",	"file_link_bad.xpm",
"file_link_small.xpm",	"file_link.xpm",	"fileman.xpm",	"fileserver.xpm",	"file_small.xpm",	"files.xpm",
"filetypes.xpm",	"file.xpm",	"find.xpm",	"fish.xpm",	"floppy.xpm",	"folder_bad_small.xpm",
"folder_bad.xpm",	"folder_link_small.xpm",	"folder_link.xpm",	"folder_small.xpm",	"folder_up_small.xpm",	"folder_up.xpm",
"folder.xpm",	"fonts.xpm",	"font.xpm",	"framemaker.xpm",	"games_arcade.xpm",	"games_board.xpm",
"games_card.xpm",	"games.xpm",	"gears2.xpm",	"gears.xpm",	"ghostview.xpm",	"ghost.xpm",
"gif.xpm",	"gimp.xpm",	"gnorpm.xpm",	"gnu.xpm",	"graph.xpm",	"gvim.xpm",
"gv.xpm",	"hammer.xpm",	"harddrive.xpm",	"helpme.xpm",	"hex.xpm",	"home2.xpm",
"home_small.xpm",	"home.xpm",	"html.xpm",	"hwinfo.xpm",	"icons.xpm",	"icon.xpm",
"iff.xpm",	"info.xpm",	"jpeg.xpm",	"kaboodle.xpm",	"kalarm.xpm",	"karm.xpm",
"kasteroids.xpm",	"kbackgammon.xpm",	"kcalc.xpm",	"kchart.xpm",	"kcoloredit.xpm",	"kcontrol.xpm",
"kcron.xpm",	"kdat.xpm",	"kdf.xpm",	"kdict.xpm",	"kdmconfig.xpm",	"kedit.xpm",
"kenolaba.xpm",	"kfax.xpm",	"kfloppy.xpm",	"kfm.xpm",	"kfract.xpm",	"khelpcenter.xpm",
"khexedit.xpm",	"kicker.xpm",	"kiconedit.xpm",	"kjots.xpm",	"kjumpingcube.xpm",	"klines.xpm",
"klipper.xpm",	"kljettool.xpm",	"klpq.xpm",	"kmahjongg.xpm",	"kmidi.xpm",	"kmid.xpm",
"kmines.xpm",	"knotes.xpm",	"korn.xpm",	"kpackage.xpm",	"kpaint.xpm",	"kpat.xpm",
"kpoker.xpm",	"kppp.xpm",	"kpresenter.xpm",	"kreversi.xpm",	"kruler.xpm",	"ksame.xpm",
"kscd.xpm",	"kscreensaver.xpm",	"kshisen.xpm",	"ksirtet.xpm",	"ksmiletris.xpm",	"ksnake.xpm",
"ksnapshot.xpm",	"ksokoban.xpm",	"kspread.xpm",	"ksysguard.xpm",	"ksysv.xpm",	"kthememgr.xpm",
"ktron.xpm",	"kuickshow.xpm",	"kuser.xpm",	"kviewshell.xpm",	"kwin.xpm",	"kword.xpm",
"licq.xpm",	"link_shadow_small.xpm",	"link_shadow.xpm",	"link_small.xpm",	"link.xpm",	"lisp.xpm",
"list.xpm",	"lnxzip.xpm",	"locale.xpm",	"lyx.xpm",	"mag_glass.xpm",	"magic.xpm",
"mailfolder.xpm",	"mail.xpm",	"makefile.xpm",	"make.xpm",	"manpage.xpm",
"manual.xpm",	"mathematica.xpm",	"memory.xpm",	"midi.xpm",	"modem.xpm",
"mouse.xpm",	"movies.xpm",	"mozilla.xpm",	"multimedia.xpm",	"music.xpm",	"nedit.xpm",
"netscape.xpm",	"news.xpm",	"noatun.xpm",	"opera.xpm",	"paint2.xpm",	"paintings.xpm",
"paint.xpm",	"paragraphs.xpm",	"password.xpm",	"pbm.xpm",	"pci.xpm",	"pdf.xpm",
"penguin.xpm",	"pgm.xpm",	"pharmacy.xpm",	"pictures.xpm",	"plan.xpm",	"plaster.xpm",
"ppm.xpm",	"printer2.xpm",	"printer3.xpm",	"printer.xpm",	"printmgr.xpm",	"processor.xpm",
"proxy.xpm",	"ps2.xpm",	"ps.xpm",	"pybliographic.xpm",	"pysol.xpm",	"raster.xpm",
"rc.xpm",	"readme.xpm",	"realplayer.xpm",	"recycle.xpm",	"redhat.xpm",	"res.xpm",
"samba.xpm",	"script_file.xpm",	"script_link.xpm",	"script_plain.xpm",	"script.xpm",	"scsi.xpm",
"sounds2.xpm",	"sounds.xpm",	"sound.xpm",	"stuff.xpm",	"stylesheet.xpm",	"style.xpm",
"suitcase.xpm",	"susehelpcenter.xpm",	"system.xpm",	"tape_net.xpm",	"tape.xpm",	"tar.xpm",
"teddy.xpm",	"term.xpm",	"text.xpm",	"tex.xpm",	"tiff.xpm",	"tmpfile.xpm",
"tools.xpm",	"trash_empty.xpm",	"trash_full.xpm",	"typewriter.xpm",	"url.xpm",	"usb.xpm",
"uu.xpm",	"video.xpm",	"wabi.xpm",	"windows.xpm",	"winprops.xpm",	"winzip.xpm",
"wizard.xpm",	"wp.xpm",	"write.xpm",	"writings.xpm",	"xapp.xpm",	"xbm.xpm",
"xclipboard.xpm",	"xclock.xpm",	"xeyes.xpm",	"xfig2.xpm",	"xfig.xpm",	"xfmail.xpm",
"xload.xpm",	"xlogo.xpm",	"xmag.xpm",	"xmcd.xpm",	"xmms.xpm",	"xosview.xpm",
"xpaint.xpm",	"xplate.xpm",	"xrolodex.xpm",	"xterm.xpm",	"xv2.xpm",	"xv.xpm",
"x.xpm",	"zip.xpm",	"zoo.xpm",  NULL,
};

	Widget        toplevel, sw, iconbox, form, vsb, hsb;
	Widget    form, add_b, ins_b, del_b, label;
	XtAppContext app;

int icon_n=293;
int item_num=100;

const char MyString[20]="string";
const char MyStringOther[20]="my_string_number_2";
const char icon_prefix[30]="./icons/";
char icon_name[100];
XmNlCell *Cells;

Pixmap SmallPix, SmallMask, BigPix, BigMask;

Cursor wait_cursor;
Boolean waited;


/** DoubleClickDoCallback function **/

void DblClCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ItemActivateReturnStruct *data;
    data=(ItemActivateReturnStruct *)call_data;
    printf("\n--------- iboxtest2: Callback called 1 ---------\n");
    printf("\niboxtest2: item=%d \t name=%s", data->item_number, (char *) data->pointer);

/** Toggle cursor state **/
	
    if (!waited)
    {
        XDefineCursor(XtDisplay(toplevel), XtWindow(toplevel), wait_cursor);
    XmUpdateDisplay(toplevel);
    waited = True;
    printf("\nWait\n");

    }
    else
    {
        XUndefineCursor(XtDisplay(toplevel), XtWindow(toplevel));
    XmUpdateDisplay(toplevel);
    waited = False;
    printf("\nNot Wait\n");

    }

}

/** HighlightCallback function **/

void HlgCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ListItemReturnStruct *data;
    int i;
    data = (ListItemReturnStruct *)call_data;

	printf("\n+++++ iboxtest2: HighlightCallback clled +++++++++\n");
	if (data->reason == XmNlCR_SINGLE_SELECT)
		printf("\tiboxtest2: Single select \n");
	else
		if (data->reason == XmNlCR_EXTENDED_SELECT)
			printf("\tiboxtest2: Extended select \n");
		else
			if (data->reason == XmNlCR_MULTPLE_SELECT)
				printf("\tiboxtest2: Motion select started \n");
			else
				if (data->reason == XmNlCR_COMPLETED_SELECT)
					printf("\tiboxtest2: Motion select comleted\n");
				else
					if (data->reason == XmNlCR_ADD_SELECT)
						printf("\tiboxtest2: Added selected items \n");
					else
						if (data->reason == XmNlCR_DELETE_SELECT)
								printf("\tiboxtest2: Deleted selected items \n");

	printf("\tiboxtest2:  Select %d items\n", data->count);
	if (data->count==0) return;
	for (i=0; i<data->count; i++)
	{
		printf("\t\tiboxtest2: item=%d \t name=%s\n", data->number[i], (char *) data->pointers[i]);
//	printf("\nTest: Item_number=%d", data->number[i]);
//		printf("\n");
	}
	printf("\n+++++ iboxtest2: Callback completed +++++++++\n");
}

void SetCellSmall(Widget w, XtPointer client_data, XtPointer call_data)
{
	int i, k;
	XmNlCell cell;
    int * numbers, * nmbs2, count;

	printf("\n+++++ iboxtest2: Callback set small icon for cell +++++++++\n");

	cell.pixmap = SmallPix;
	cell.mask = SmallMask;

	XtVaGetValues(iconbox, XmNselectedItemCount, &count, XmNselectedPositions, &numbers, NULL);

	printf("\n+++++ iboxtest2: selected %d\n", count);

	if (count == 0) return ;
	
	nmbs2 = malloc(sizeof(int) * count);
	memcpy(nmbs2, numbers, sizeof(int) * count);
	for (i = 0; i < count; i++)
	{
		XmNlItBoxSetItem(iconbox, &cell, CellPixmap | CellMask, nmbs2[i]);
	}
	
	free(nmbs2);
}

void SetCellBig(Widget w, XtPointer client_data, XtPointer call_data)
{
	int i, k;
	XmNlCell cell;
    int * numbers, * nmbs2, count;
	unsigned char mask = 0;
	
	printf("\n+++++ iboxtest2: Callback set big icon for cell +++++++++\n");

	cell.pixmap = BigPix;
	cell.mask = BigMask;

	XtVaGetValues(iconbox, XmNselectedItemCount, &count, XmNselectedPositions, &numbers, NULL);

	printf("\n+++++ iboxtest2: selected %d\n", count);

	if (count == 0) return ;
	
	nmbs2 = malloc(sizeof(int) * count);
	memcpy(nmbs2, numbers, sizeof(int) * count);
	mask = mask | CellPixmap | CellMask;
	for (i = 0; i < count; i++)
	{
		XmNlItBoxSetItem(iconbox, &cell, mask, nmbs2[i]);
	}
	
	free(nmbs2);
}
void DelCells(Widget w, XtPointer client_data, XtPointer call_data)
{
    int * numbers, * nmbs2, count;
	XmNlCell *SelectedCells;
    int i;
	int ms[2] = {2, 3};

	printf("\n+++++ iboxtest2: Callback delete cells +++++++++\n");



	XtVaGetValues(iconbox, XmNselectedItemCount, &count, XmNselectedPositions, &numbers, NULL);

	printf("\n+++++ iboxtest2: Callback delete: selected %d\n", count);

	if (count == 0) return ;
	
	nmbs2 = malloc(sizeof(int) * count);
	memcpy(nmbs2, numbers, sizeof(int) * count);
	for (i = 0; i < count; i++)
	{
		printf("\niboxtest2: item for delete = %d\n", nmbs2[i]);
	}
	
	XmNlItBoxDeleteItems(iconbox, nmbs2, count);
//	XmNlItBoxDeleteItems(iconbox, ms, 2);
	free(nmbs2);

	printf("\n+++++ iboxtest2: Callback del cells completed +++++++++\n");
}


int main(int argc, char **argv)
{
	Arg           args[10];
	int           n, i, k;
	Colormap colmap;
	XColor col_1, col_2;




	XtSetLanguageProc (NULL, NULL, NULL);
	toplevel = XtVaOpenApplication (&app, "Demos", NULL, 0, &argc, argv,
                             NULL, sessionShellWidgetClass, NULL);
/* Create a 500x300 scrolled window. This value is arbitrary,
** but happens to look good initially. It is resizable by the user.
*/
	wait_cursor = XCreateFontCursor(XtDisplay(toplevel), XC_watch);
	waited=False;

	form = XmCreateForm (toplevel, "Form",   args, 0);

	add_b = XmCreatePushButton(form, "Set small icon in selected position", args, n);
	ins_b = XmCreatePushButton(form, "Set big icon in  selected pisition", args, n);
	del_b = XmCreatePushButton(form, "Delete selected items", args, n);


	n = 0;
	XtSetArg (args[n], XmNwidth, 500); n++;
	XtSetArg (args[n], XmNheight, 300); n++;
	XtSetArg (args[n], XmNscrollingPolicy, XmAPPLICATION_DEFINED); n++;
	sw = XmCreateScrolledWindow (form, "scrolled_w",   args, n);

	i=0;
	XtSetArg(args[i], XmNorientation, XmVERTICAL); i++;
	XtSetArg(args[i], XmNmaximum, 1); i++;
	XtSetArg(args[i], XmNsliderSize, 1); i++;
	vsb=XmCreateScrollBar(sw, "vsb", args, i);
	XtManageChild(vsb);
	i=0;
	XtSetArg(args[i], XmNorientation, XmHORIZONTAL); i++;
	XtSetArg(args[i], XmNmaximum, 1); i++;
	XtSetArg(args[i], XmNsliderSize, 1); i++;
	hsb=XmCreateScrollBar(sw, "hsb", args, i);
	XtManageChild(vsb);
	XtManageChild(hsb);
	iconbox = XtVaCreateWidget ("iconbox", xmNlItemBoxWidgetClass, sw, NULL);

	label = XmCreateLabel(form, "iboxtest2 running in buffering mode", args, n);

	XtAddCallback(add_b, XmNactivateCallback, SetCellSmall, (XtPointer) NULL);

	XtAddCallback(ins_b, XmNactivateCallback, SetCellBig, (XtPointer) NULL);

	XtAddCallback(del_b, XmNactivateCallback, DelCells, (XtPointer) NULL);


	sprintf(icon_name, "%s%s", icon_prefix, "dev_floppy.xpm");
	XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), icon_name,
			      &(SmallPix), &(SmallMask), (XpmAttributes *) NULL);

//	printf("===name %s pix %ld mask %ld\n", icon_name, SmallPix, SmallMask);

	sprintf(icon_name, "%s%s", icon_prefix, "folder.xpm");
	XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), icon_name,
			      &(BigPix), &(BigMask), (XpmAttributes *) NULL);

	Cells=malloc(item_num*sizeof(XmNlCell));
	k=0;
	for (i=0; i<item_num; i++)
	{
		if (k>=icon_n) k=0;
//		if (k>=39) k=0;
		Cells[i].text=calloc(strlen(MyString)+5, 1);
		sprintf(Cells[i].text, "%s %d", MyString, i);
		Cells[i].UserDataPointer=(void *)Cells[i].text;
		sprintf(icon_name, "%s%s", icon_prefix, names[k]);
		XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), icon_name,
			      &(Cells[i].pixmap), &(Cells[i].mask), (XpmAttributes *) NULL);
//		printf("number %d name %s pix %ld mask %ld\n", k, icon_name, Cells[i].pixmap, Cells[i].mask);
		Cells[i].xmlabel = XmStringCreateLocalized(Cells[i].text);
//		Cells[i].selected=Select;
//		Select= !Select;
//		printf("\n name=%s \n",MyItem[i].name );
		k++;
	}
      	k=2;
	XmNlItBoxAddItems(iconbox, Cells, item_num, CellXmString | CellCharString | CellUserData | CellPixmap | CellMask);
	XtVaSetValues(iconbox, XmNverticalScrollBar, vsb, XmNhorizontalScrollBar, hsb, NULL);
	colmap=DefaultColormapOfScreen(XtScreen(iconbox));
	XAllocNamedColor(XtDisplay(toplevel), colmap, "orange", &col_1, &col_2);
//	XtVaSetValues(iconbox, XmNSelectBackground, col_2.pixel, NULL);
	XtVaSetValues(iconbox, XmNselectColor, col_2.pixel, NULL);
//	XtVaSetValues(iconbox, XmNlBufferingOn, True, NULL);
	XAllocNamedColor(XtDisplay(toplevel), colmap, "blue", &col_1, &col_2);
	XtVaSetValues(iconbox, XmNselectForeground, col_2.pixel, NULL);
//	XtVaSetValues(iconbox, XmNselectForeground, col_2.pixel, NULL);
	XtAddCallback(iconbox, XtNhighlightCallback, HlgCallback, (XtPointer) NULL);
	XtAddCallback(iconbox, XmNdoubleClickCallback, DblClCallback, (XtPointer) NULL);

     n = 0;

	XtVaSetValues(iconbox, XmNlBufferingOn, TRUE, XmNlSelectAutoNotify, True, NULL);

	XtVaSetValues(add_b,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(ins_b,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, add_b,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(del_b,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, ins_b,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(label,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(sw,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, del_b,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, label,
			NULL);

  XtManageChild (iconbox);
  XtManageChild (sw);

	XtManageChild (form);
	XtManageChild (add_b);
	XtManageChild (ins_b);
	XtManageChild (del_b);
	XtManageChild (label);


  XtRealizeWidget (toplevel);
  XtAppMainLoop (app);
  return 0;
}
