#include <Xm/XmAll.h>
#include <pwd.h>
#include <Xm/PushB.h>
#include "XmNlItemBox.h"
#include "XmNl.h"
#include <string.h>
#include <X11/cursorfont.h>
#include <X11/xpm.h>
#include <stdlib.h>
#include <Xm/ToggleBG.h>
#include <Xm/RowColumn.h>


static char *names[] = {
"acroread.xpm",       "fonts.xpm",         "kruler.xpm",         "pysol.xpm",
"applications.xpm",   "font.xpm",          "ksame.xpm",          "raster.xpm",
"app_link.xpm",       "framemaker.xpm",    "kscd.xpm",           "rc.xpm",
"app_plain.xpm",      "games_arcade.xpm",  "kscreensaver.xpm",   "readme.xpm",
"app.xpm",            "games_board.xpm",   "kshisen.xpm",        "realplayer.xpm",
"ark.xpm",            "games_card.xpm",    "ksirtet.xpm",        "recycle.xpm",
"blender.xpm",        "games.xpm",         "ksmiletris.xpm",     "redhat.xpm",
"bluelogo.xpm",       "gears2.xpm",        "ksnake.xpm",         "res.xpm",
"bookshelf.xpm",      "gears.xpm",         "ksnapshot.xpm",      "samba.xpm",
"book.xpm",           "ghostview.xpm",     "ksokoban.xpm",       "script_file.xpm",
"bug.xpm",            "ghost.xpm",         "kspread.xpm",        "script_link.xpm",
"calc2.xpm",          "gif.xpm",           "ksysguard.xpm",      "script_plain.xpm",
"calc.xpm",           "gimp.xpm",          "ksysv.xpm",          "script.xpm",
"camera.xpm",         "gnorpm.xpm",        "kthememgr.xpm",      "scsi.xpm",
"cdrom.xpm",          "gnu.xpm",           "ktron.xpm",          
"cervisia.xpm",       "graph.xpm",         "kuickshow.xpm",      "sounds2.xpm",
"chess2.xpm",         "gvim.xpm",          "kuser.xpm",          "sounds.xpm",
"chess3.xpm",         "gv.xpm",            "kviewshell.xpm",     "sound.xpm",
"chess.xpm",          "hammer.xpm",        "kwin.xpm",           "stuff.xpm",
"chip.xpm",           "harddrive.xpm",     "kword.xpm",          "stylesheet.xpm",
"circuit2.xpm",       "helpme.xpm",        "licq.xpm",           "style.xpm",
"circuit.xpm",        "hex.xpm",           "link_shadow.xpm",    "suitcase.xpm",
"clip_file.xpm",      "home2.xpm",         "link.xpm",           "susehelpcenter.xpm",
"clip_folder.xpm",    "home.xpm",          "lisp.xpm",           "system.xpm",
"clip.xpm",           "html.xpm",          "list.xpm",           "tape_net.xpm",
"compressed.xpm",     "hwinfo.xpm",        "lnxzip.xpm",         "tape.xpm",
"compress.xpm",       "icons.xpm",         "locale.xpm",         "tar.xpm",
"cookie.xpm",         "icon.xpm",          "lyx.xpm",            "teddy.xpm",
"core.xpm",           "iff.xpm",           "mag_glass.xpm",      "term.xpm",
"cycle.xpm",          "info.xpm",          "magic.xpm",          "text.xpm",
"data.xpm",           "jpeg.xpm",          "mailfolder.xpm",     "tex.xpm",
"date.xpm",           "kaboodle.xpm",      "mail.xpm",           "tiff.xpm",
"debug.xpm",          "kalarm.xpm",        "makefile.xpm",       "tmpfile.xpm",
"designer.xpm",       "karm.xpm",          "make.xpm",           "tools.xpm",
"dev_cdrom.xpm",      "kasteroids.xpm",    "manpage.xpm",        "trash_empty.xpm",
"dev_floppy.xpm",     "kbackgammon.xpm",   "manual.xpm",         "trash_full.xpm",
"dev_harddrive.xpm",  "kcalc.xpm",         "mathematica.xpm",    "typewriter.xpm",
"diff.xpm",           "kchart.xpm",        "memory.xpm",         "url.xpm",
"dlgedit.xpm",        "kcoloredit.xpm",    "midi.xpm",           "usb.xpm",
"dot_a.xpm",          "kcontrol.xpm",      "modem.xpm",          "uu.xpm",
"dot_cc.xpm",         "kcron.xpm",         "mouse.xpm",          "video.xpm",
"dot_c.xpm",          "kdat.xpm",          "movies.xpm",         "wabi.xpm",
"dot_h.xpm",          "kdf.xpm",           "mozilla.xpm",        "windows.xpm",
"dot_o.xpm",          "kdict.xpm",         "multimedia.xpm",     "winprops.xpm",
"dot_sa.xpm",         "kdmconfig.xpm",     "music.xpm",          "winzip.xpm",
"dot_so.xpm",         "kedit.xpm",         "nedit.xpm",          "wizard.xpm",
"draw2.xpm",          "kenolaba.xpm",      "netscape.xpm",       "wp.xpm",
"draw.xpm",           "kfax.xpm",          "news.xpm",           "write.xpm",
"dvi.xpm",            "kfloppy.xpm",       "noatun.xpm",         "writings.xpm",
"editor.xpm",         "kfm.xpm",           "opera.xpm",          "xapp.xpm",
"editres.xpm",        "kfract.xpm",        "paint2.xpm",         "xbm.xpm",
"edit.xpm",           "khelpcenter.xpm",   "paintings.xpm",      "xclipboard.xpm",
"ee.xpm",             "khexedit.xpm",      "paint.xpm",          "xclock.xpm",
"emacs.xpm",          "kicker.xpm",        "paragraphs.xpm",     "xeyes.xpm",
"email.xpm",          "kiconedit.xpm",     "password.xpm",       "xfig2.xpm",
"empty.xpm",          "kjots.xpm",         "pbm.xpm",            "xfig.xpm",
"exec2.xpm",          "kjumpingcube.xpm",  "pci.xpm",            "xfmail.xpm",
"exec.xpm",           "klines.xpm",        "pdf.xpm",            "xload.xpm",
"fig.xpm",            "klipper.xpm",       "penguin.xpm",        "xlogo.xpm",
"file_bad.xpm",       "kljettool.xpm",     "pgm.xpm",            "xmag.xpm",
"file_link_bad.xpm",  "klpq.xpm",          "pharmacy.xpm",       "xmcd.xpm",
"file_link.xpm",      "kmahjongg.xpm",     "pictures.xpm",       "xmms.xpm",
"fileman.xpm",        "kmidi.xpm",         "plan.xpm",           "xosview.xpm",
"fileserver.xpm",     "kmid.xpm",          "plaster.xpm",        "xpaint.xpm",
"files.xpm",          "kmines.xpm",        "ppm.xpm",            "xplate.xpm",
"filetypes.xpm",      "knotes.xpm",        "printer2.xpm",       "xrolodex.xpm",
"file.xpm",           "korn.xpm",          "printer3.xpm",       "xterm.xpm",
"find.xpm",           "kpackage.xpm",      "printer.xpm",        "xv2.xpm",
"fish.xpm",           "kpaint.xpm",        "printmgr.xpm",       "xv.xpm",
"floppy.xpm",         "kpat.xpm",          "processor.xpm",      "x.xpm",
"folder_bad.xpm",     "kpoker.xpm",        "proxy.xpm",          "zip.xpm",
"folder_link.xpm",    "kppp.xpm",          "ps2.xpm",            "zoo.xpm",
"folder_up.xpm",      "kpresenter.xpm",    "ps.xpm",
"folder.xpm",         "kreversi.xpm",      "pybliographic.xpm",  NULL,
};	


Widget    form, add_b, ins_b, del_b, del_a_b, toplevel, sw, iconbox, form, vsb, hsb, label;
Widget check_form, frame;
Widget check_small, check_large, rbsize;
Widget check_left, check_right, check_centre, rbalign;
XtAppContext app;

Boolean type_switch_activ = True;


int icon_n=293;
int item_num=40;

const char MyString[20]="my_string";
const char MyStringOther[20]="s";
const char icon_prefix[30]="./icons/";
char icon_name[100];
XmNlCell *MyItem;
XmString motif_string1, motif_string2, motif_string3;
unsigned char cell_mask;
char * str1, * str2;

void DblClCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ItemActivateReturnStruct *data;
	XmNlCell CellItem;
	Boolean ok;
	unsigned char * string;
	unsigned int len;

    data=(ItemActivateReturnStruct *)call_data;
    printf("\n--------- iboxtest1: Activate Callback called ---------\n");
    printf("\n iboxtest1: item=%d \t name=%s", data->item_number, (char *) data->pointer);
    
    ok = XmNlItBoxGetItem(iconbox, &CellItem, CellUserData | CellCharString | CellAlignment | CellSelection, data->item_number);
	if (ok)
	{
		printf("Properties\n");
		printf("Text \t%s\n", CellItem.text);
		printf("UserData \t%s\n", CellItem.UserDataPointer);
		if (CellItem.selected) printf("Item is selected\n");
		else printf("Item is not selected\n");
		if (CellItem.alignment == XmALIGNMENT_UNSPECIFIED) printf("Not aligned \n");
		if (CellItem.alignment == XmALIGNMENT_BEGINNING) printf("Aligned to begin\n");
		if (CellItem.alignment == XmALIGNMENT_END) printf("Aligned to end\n");
	}
}

void HlgCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    ListItemReturnStruct *data;
    int i;
    data=(ListItemReturnStruct *)call_data;

printf("\n+++++ iboxtest1: Callback highlight clled +++++++++\n");
printf("\n iboxtest1: Num_item=%d ", data->count);
if (data->count==0) return;
for (i=0; i<data->count; i++)
	{
	printf("\niboxtest1: item=%d \t name=%s", data->number[i], (char *) data->pointers[i]);
//	printf("\nTest: Item_number=%d", data->number[i]);
	printf("\n");

	}
printf("\n+++++ iboxtest1: Callback highlight completed +++++++++\n");
printf("\n");
}

void AddCells(Widget w, XtPointer client_data, XtPointer call_data)
{
	int i, k;
	unsigned char setting, left, right;

	XtVaGetValues(check_small, XmNset, &setting, NULL);
	XtVaGetValues(check_left, XmNset, &left, NULL);
	XtVaGetValues(check_right, XmNset, &right, NULL);

	if(type_switch_activ)
	{
		if (setting == XmSET)
		{
			XtVaSetValues(iconbox, XmNviewType, XmSMALL_ICON, NULL);
		}
		else
		{
			XtVaSetValues(iconbox, XmNviewType, XmLARGE_ICON, NULL);
		}
	}
	
	MyItem=(XmNlCell *)malloc(item_num*sizeof(XmNlCell));
	k=0;
	for (i=0; i<item_num; i++)
	{
		if (k>=icon_n) k=0;
		MyItem[i].text=calloc(strlen(MyString)+20, 1);
		if (i==0) 
		{
			sprintf(MyItem[i].text, "%s", "line1\nline2");
			motif_string1 = XmStringCreateLocalized("Very long line1");
			motif_string2 = XmStringComponentCreate( XmSTRING_COMPONENT_SEPARATOR, 0, NULL);
			motif_string3 = XmStringConcat(motif_string1, motif_string2);
			XmStringFree(motif_string1);
			XmStringFree(motif_string2);
			motif_string1 = XmStringCreateLocalized("continue line2");
			MyItem[i].xmlabel = XmStringConcat(motif_string3, motif_string1);
			XmStringFree(motif_string1);
			XmStringFree(motif_string3);
		}
		else
		{
			sprintf(MyItem[i].text, "%d", i);
			MyItem[i].xmlabel = XmStringCreateLocalized(MyItem[i].text);
		}

		MyItem[i].UserDataPointer=(void *)MyItem[i].text;


		if (left == XmSET)
			MyItem[i].alignment = XmALIGNMENT_BEGINNING;
		else
			if (right == XmSET)
				MyItem[i].alignment = XmALIGNMENT_END;
			else 
				MyItem[i].alignment = XmALIGNMENT_CENTER;
		
		if (setting == XmSET && (left == XmUNSET && right == XmUNSET))
			MyItem[i].alignment = XmALIGNMENT_BEGINNING;


		sprintf(icon_name, "%s%s", icon_prefix, names[k]);
		XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), (char *)icon_name,
			      &(MyItem[i].pixmap), &(MyItem[i].mask), (XpmAttributes *) NULL);
		k++;
	}
    cell_mask = 0;
    cell_mask = cell_mask | CellXmString | CellPixmap | CellMask | CellCharString | CellUserData | CellAlignment;
	XmNlItBoxAddItems(iconbox, MyItem, item_num, cell_mask);

	type_switch_activ = False;
	XtVaSetValues(check_small, XmNsensitive, False, NULL);
	XtVaSetValues(check_large, XmNsensitive, False, NULL);
}

void InsCells(Widget w, XtPointer client_data, XtPointer call_data)
{
	int i, k;
    int * numbers = NULL, count;

	unsigned char left, right, setting;

	XtVaGetValues(check_left,  XmNset, &left, NULL);
	XtVaGetValues(check_right,  XmNset, &right, NULL);
	XtVaGetValues(check_small,  XmNset, &setting, NULL);

	if(type_switch_activ)
	{
		if (setting == XmSET)
		{
			XtVaSetValues(iconbox, XmNviewType, XmSMALL_ICON, NULL);
		}
		else
		{
			XtVaSetValues(iconbox, XmNviewType, XmLARGE_ICON, NULL);
		}
	}


	XmNlItBoxGetSelectedItems(iconbox, &count, &numbers);
	printf("\n+++++ iboxtest1: Callback InsCells: selected get %d\n", count);
	
	if (numbers) 
	{
		count = numbers[0];
		free(numbers);
	}
	else count = 10;



	
	MyItem=(XmNlCell *)malloc(item_num*sizeof(XmNlCell));
	k=0;
	for (i=0; i<item_num; i++)
	{
		if (k>=icon_n) k=0;
		MyItem[i].text=calloc(strlen(MyString)+20, 1);
		if (i==0) 
		{
			sprintf(MyItem[i].text, "%s", "line1\nline2");
			motif_string1 = XmStringCreateLocalized("Very long line1");
			motif_string2 = XmStringComponentCreate( XmSTRING_COMPONENT_SEPARATOR, 0, NULL);
			motif_string3 = XmStringConcat(motif_string1, motif_string2);
			XmStringFree(motif_string1);
			XmStringFree(motif_string2);
			motif_string1 = XmStringCreateLocalized("continue line2");
			MyItem[i].xmlabel = XmStringConcat(motif_string3, motif_string1);
			XmStringFree(motif_string1);
			XmStringFree(motif_string3);
		}
		else
		{
			sprintf(MyItem[i].text, "%d", i);
			MyItem[i].xmlabel = XmStringCreateLocalized(MyItem[i].text);
		}

		MyItem[i].UserDataPointer=(void *)MyItem[i].text;
		
		MyItem[i].selected = True;
		
		if (left == XmSET)
			MyItem[i].alignment = XmALIGNMENT_BEGINNING;
		else
			if (right == XmSET)
				MyItem[i].alignment = XmALIGNMENT_END;
			else 
				MyItem[i].alignment = XmALIGNMENT_CENTER;
		
		if (setting == XmSET && (left == XmUNSET && right == XmUNSET))
			MyItem[i].alignment = XmALIGNMENT_BEGINNING;
		
		sprintf(icon_name, "%s%s", icon_prefix, names[k]);
		XpmReadFileToPixmap(XtDisplay(toplevel), XRootWindowOfScreen(XtScreen(toplevel)), (char *)icon_name,
			      &(MyItem[i].pixmap), &(MyItem[i].mask), (XpmAttributes *) NULL);
		k++;
	}
    cell_mask = 0;
    cell_mask = cell_mask | CellXmString | CellCharString | CellUserData | CellPixmap | CellMask | CellAlignment | CellSelection;
	XmNlItBoxInsertItems(iconbox, MyItem, count, item_num, cell_mask);

	type_switch_activ = False;
	XtVaSetValues(check_small, XmNsensitive, False, NULL);
	XtVaSetValues(check_large, XmNsensitive, False, NULL);
}

void DelCells(Widget w, XtPointer client_data, XtPointer call_data)
{
    int * numbers, * nmbs2, count;
	XmNlCell *SelectedCells;
    int i;
	int ms[2] = {2, 3};

	printf("\n+++++ iboxtest1: Callback delete cells +++++++++\n");



	XtVaGetValues(iconbox, XmNselectedItemCount, &count, XmNselectedPositions, &numbers, NULL);

	printf("\n+++++ iboxtest1: Callback delete: selected %d\n", count);

	if (count == 0) return ;
	
	nmbs2 = malloc(sizeof(int) * count);
	memcpy(nmbs2, numbers, sizeof(int) * count);
	for (i = 0; i < count; i++)
	{
		printf("\niboxtest1: item for delete = %d\n", nmbs2[i]);
	}
	
	XmNlItBoxDeleteItems(iconbox, nmbs2, count);
//	XmNlItBoxDeleteItems(iconbox, ms, 2);
	free(nmbs2);

	printf("\n+++++ iboxtest1: Callback del cells completed +++++++++\n");
}

void DelAllCells(Widget w, XtPointer client_data, XtPointer call_data)
{
    int * numbers, count;
	XmNlCell *SelectedCells;
    int i;

	printf("\n+++++ iboxtest1: Callback delete all cells +++++++++\n");

	XmNlItBoxDeleteAllItems(iconbox);

	printf("\n+++++ iboxtest1: Callback del all cells completed +++++++++\n");

	type_switch_activ = True;
	XtVaSetValues(check_small, XmNsensitive, True, NULL);
	XtVaSetValues(check_large, XmNsensitive, True, NULL);

}


int main(int argc, char **argv)
{
	Arg           args[10];
	int           n, i, k, direction = 0;
	Colormap colmap;
	XColor col_1, col_2;

	Boolean Select=False;
	
	
	if (argc > 1)
	{
		for (i = 1; i < argc; i++)
		{
			if (strcmp(argv[i], "-h") == 0)
				printf("iboxtest1 opttion\nOptions:\n-h\tprint this help\n-r\tright to left direction\n-l\tleft to right direction\n");
			if (strcmp(argv[i], "-r") == 0)
				direction = 2;
			if (strcmp(argv[i], "-l") == 0)
				direction = 1;
		}
	}
	
	XtSetLanguageProc (NULL, NULL, NULL);

	if (direction == 0)
		toplevel = XtVaOpenApplication (&app, "Demos", NULL, 0, &argc, argv,
								NULL, sessionShellWidgetClass, NULL);
	else if (direction == 1)
			toplevel = XtVaOpenApplication (&app, "Demos", NULL, 0, &argc, argv,
                             NULL, sessionShellWidgetClass, XmNlayoutDirection, XmLEFT_TO_RIGHT_BOTTOM_TO_TOP, NULL);
		else if (direction == 2)
				toplevel = XtVaOpenApplication (&app, "Demos", NULL, 0, &argc, argv,
                             NULL, sessionShellWidgetClass, XmNlayoutDirection, XmRIGHT_TO_LEFT_BOTTOM_TO_TOP, NULL);

/* Create a 500x300 scrolled window. This value is arbitrary,
** but happens to look good initially. It is resizable by the user.
*/
	form = XmCreateForm (toplevel, "Form",   args, 0);

	n = 0;
//	XtSetArg (args[n], XmNborderWidth, 10); n++;
	frame = XmCreateFrame(form, "frame1", args, n);

	n = 0;
	XtSetArg (args[n], XmNlayoutDirection, XmLEFT_TO_RIGHT_BOTTOM_TO_TOP); n++;
	XtSetArg (args[n], XmNfractionBase, 2); n++;
	check_form = XmCreateForm (frame, "Form2", args, n);


	n = 0;
	XtSetArg (args[n], XmNlayoutDirection, XmSTRING_DIRECTION_L_TO_R); n++;
	add_b = XmCreatePushButton(form, "Add items", args, n);
	ins_b = XmCreatePushButton(form, "Insert items at selected pisition", args, n);
	del_b = XmCreatePushButton(form, "Delete selected items", args, n);
	del_a_b = XmCreatePushButton(form, "Delete all items", args, n);


	rbsize = XmCreateRadioBox (check_form, "Layout", args, n);
	rbalign = XmCreateRadioBox (check_form, "Align", args, n);

	check_large = XmCreateToggleButtonGadget (rbsize, "Large", args, n);
//	check_large = XmCreateToggleButtonGadget (frame, "Large", args, n);

//	XtAddCallback (one, XmNvalueChangedCallback, toggled, (XtPointer) 1);

	check_small = XmCreateToggleButtonGadget (rbsize, "Small", args, n);
//	check_small = XmCreateToggleButtonGadget (frame, "Small", args, n);

//	XtAddCallback (two, XmNvalueChangedCallback, toggled, (XtPointer) 2);

	check_left = XmCreateToggleButtonGadget (rbalign, "Beginning alignement", args, n);
	check_right = XmCreateToggleButtonGadget (rbalign, "End alignement", args, n);
	check_centre = XmCreateToggleButtonGadget (rbalign, "Centre alignement", args, n);


	label = XmCreateLabel(form, "Run iboxtest1 with option -r or -l to change default direction", args, n);

	XtAddCallback(add_b, XmNactivateCallback, AddCells, (XtPointer) NULL);

	XtAddCallback(ins_b, XmNactivateCallback, InsCells, (XtPointer) NULL);

	XtAddCallback(del_b, XmNactivateCallback, DelCells, (XtPointer) NULL);

	XtAddCallback(del_a_b, XmNactivateCallback, DelAllCells, (XtPointer) NULL);

	n = 0;
	XtSetArg (args[n], XmNwidth, 500); n++;
	XtSetArg (args[n], XmNheight, 300); n++;
	XtSetArg (args[n], XmNscrollingPolicy, XmAPPLICATION_DEFINED); n++;
/*	if (direction == 1)
	{
		XtSetArg (args[n], XmNlayoutDirection, XmLEFT_TO_RIGHT_BOTTOM_TO_TOP); n++;
	}
	else if (direction == 2)
		{
			XtSetArg (args[n], XmNlayoutDirection, XmRIGHT_TO_LEFT_BOTTOM_TO_TOP); n++;
		}
*/
	sw = XmCreateScrolledWindow (form, "scrolled_w",   args, n);

//	XtVaSetValues(sw, XmNlayoutDirection, XmRIGHT_TO_LEFT_BOTTOM_TO_TOP, NULL);
	i=0;
	XtSetArg(args[i], XmNorientation, XmVERTICAL); i++;
	XtSetArg(args[i], XmNmaximum, 1); i++;
	XtSetArg(args[i], XmNsliderSize, 1); i++;
	vsb=XmCreateScrollBar(sw, "vsb", args, i);
	XtManageChild(vsb);

	i=0;
	XtSetArg(args[i], XmNorientation, XmHORIZONTAL); i++;
	XtSetArg(args[i], XmNmaximum, 1); i++;
	XtSetArg(args[i], XmNsliderSize, 1); i++;
	hsb=XmCreateScrollBar(sw, "hsb", args, i);
	XtManageChild(hsb);


//	iconbox = XtVaCreateWidget ("iconbox", xmNlItemBoxWidgetClass, sw, XmNviewType, XmSMALL_ICON, NULL);
	iconbox = XtVaCreateWidget ("iconbox", xmNlItemBoxWidgetClass, sw, NULL);

	XtVaSetValues(add_b,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(ins_b,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, add_b,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(del_b,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, ins_b,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(del_a_b,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, del_b,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(frame,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, del_a_b,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			NULL);




	XtVaSetValues(rbsize,
			XmNtopAttachment, XmATTACH_POSITION,
			XmNtopPosition, 0,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNleftPosition, 0,
			XmNrightAttachment, XmATTACH_POSITION,
			XmNrightPosition, 1,
			XmNbottomAttachment, XmATTACH_POSITION,
			XmNbottomPosition, 2,
//			XmNtopAttachment, XmATTACH_FORM,
//			XmNtopWidget, del_a_b,
//			XmNbottomAttachment, XmATTACH_FORM,
//			XmNleftAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(rbalign,
			XmNtopAttachment, XmATTACH_POSITION,
			XmNtopPosition, 0,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNleftPosition, 1,
			XmNrightAttachment, XmATTACH_POSITION,
			XmNrightPosition, 2,
			XmNbottomAttachment, XmATTACH_POSITION,
			XmNbottomPosition, 2,
//			XmNtopAttachment, XmATTACH_FORM,
//			XmNleftAttachment, XmATTACH_WIDGET,
//			XmNleftWidget, rbsize,
//			XmNbottomAttachment, XmATTACH_FORM,
//			XmNrightAttachment, XmATTACH_FORM,
			NULL);





	XtVaSetValues(label,
//			XmNtopAttachment, XmATTACH_WIDGET,
//			XmNtopWidget, del_a_b,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_FORM,
			NULL);

	XtVaSetValues(sw,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, rbsize,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
//			XmNbottomAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, label,
			NULL);



	
	
//	XtVaSetValues(iconbox, XmNentryData, MyItem, XmNnumItems, item_num, NULL);
//	XtVaSetValues(iconbox, XmNverticalScrollBar, vsb, XmNhorizontalScrollBar, hsb, XmNlBufferingOn, TRUE, NULL);
	XtVaSetValues(iconbox, XmNverticalScrollBar, vsb, XmNhorizontalScrollBar, hsb, NULL);
	colmap=DefaultColormapOfScreen(XtScreen(iconbox));
	XAllocNamedColor(XtDisplay(toplevel), colmap, "darkred", &col_1, &col_2);
//	XtVaSetValues(iconbox, XmNBackground, WhitePixelOfScreen(XtScreen(iconbox)), NULL);
//	XtVaSetValues(iconbox, XmNBackground, col_2.pixel, NULL);
	XAllocNamedColor(XtDisplay(toplevel), colmap, "white", &col_1, &col_2);
//	XtVaSetValues(iconbox, XmNForeground, col_2.pixel, NULL);
	XAllocNamedColor(XtDisplay(toplevel), colmap, "blue", &col_1, &col_2);
//	XtVaSetValues(iconbox, XmNSelectBackground, col_2.pixel, NULL);
	XAllocNamedColor(XtDisplay(toplevel), colmap, "black", &col_1, &col_2);
//	XtVaSetValues(iconbox, XmNSelectForeground, col_2.pixel, NULL);
	XtAddCallback(iconbox, XtNhighlightCallback, HlgCallback, (XtPointer) NULL);
	XtAddCallback(iconbox, XmNdoubleClickCallback, DblClCallback, (XtPointer) NULL);

	XtManageChild (form);
	XtManageChild (add_b);
	XtManageChild (ins_b);
	XtManageChild (del_b);
	XtManageChild (del_a_b);
	XtManageChild (label);
	XtManageChild (rbsize);
	XtManageChild (check_large);
	XtManageChild (check_small);

	XtManageChild (check_form);
	XtManageChild (rbalign);
	XtManageChild (check_left);
	XtManageChild (check_right);
	XtManageChild (check_centre);
	XtManageChild (frame);

	XtVaSetValues(check_small,  XmNset, XmSET, NULL);
	XtVaSetValues(check_left,  XmNset, XmSET, NULL);


  XtManageChild (iconbox);
  XtManageChild (sw);
  XtRealizeWidget (toplevel);
  XtAppMainLoop (app);
		return 0;
}
