#include "qtip.h"
/*
 *  Qtip - function for quick/bubble help
 *
 *  RCS:
 *      $Revision$
 *      $Date$
 *
 *  Functions
 *      public  function (for users)
 *          void Qtip(Widget widget,char *text) 
 *      
 *      private functions (for developers only)
 *          static void PopQtip(XtPointer client_data)
 *          static void PopQtip _Declare ((XtPointer));
 *          static Widget GetTopShell _Declare ((Widget));
 *
 *  Development History:
 *      who                  when       why
 *      ma_muquit@fccc.edu   Oct-06-96  first cut
 *                           Oct-22-96  fixed several bugs. 
 *                                        * label was not static
 *                                        * obtaining flist all the time
 *                           Feb-02-97  was not working properly with fvwm95
 *                                      added XRaiseWindow() after managing.
 *                                      
 */

typedef struct _QtipData
{
	char	*text;          /* help text */
	Widget	widget;         /* widget to bind help for */

} QtipData;

static XtIntervalId	s_timerid;
static int	timeout;
static Widget	ShelpShellW=(Widget) NULL;
static Widget	SlabelW=(Widget) NULL;
/*
** private function prototypes
*/
static void		QtipCb _Declare ((Widget,XtPointer,XEvent *));
static void		PopQtip _Declare ((XtPointer));
static Widget	GetTopShell _Declare ((Widget));

#if __STDC__ || defined(sgi) || defined(_AIX)
void Qtip(Widget widget,char *text)
#else
void Qtip(widget,text)
Widget	widget;
char	*text;
#endif
{
	QtipData *data=(QtipData *) XtNew(QtipData);
	if (text != (char *) NULL)
	data->text=XtNewString(text);
	else
		data->text=(char *) NULL;

	data->widget=widget;

	/*
	** check if the widget is a subclass of Core Widget class
	*/
	if (XtIsWidget(widget) == False)
	{
		return;
	}
	XtAddEventHandler(widget,
		EnterWindowMask | LeaveWindowMask,
		False,
		(XtEventHandler) QtipCb,
		(XtPointer) data);
}

#if __STDC__ || defined(sgi) || defined(_AIX)
	static void QtipCb(Widget widget,XtPointer client_data,XEvent *event)
#else
	static void QtipCb(widget,client_data,event)
	Widget		widget;
	XtPointer	client_data;
	XEvent		*event;
#endif
{
/*
    QtipData
        *data;

   data=(QtipData *) client_data;
*/
   switch(event->type)
   {
        case EnterNotify:
        {
#ifdef DEBUG
            (void) fprintf (stderr," EnterNotify Event!\n");
#endif
            if (!s_timerid)
            {
#ifdef DEBUG
                (void) fprintf (stderr," Starting..timer...\n");
#endif
                timeout=1;
                s_timerid=XtAppAddTimeOut(
                    XtWidgetToApplicationContext(widget),
                    QTIP_HELP_DELAY,
                    (XtTimerCallbackProc) PopQtip,
                    client_data);
            }
            break;
        }

        case LeaveNotify:
        {
#ifdef DEBUG
            (void) fprintf (stderr," LeaveNotify Event!\n");
#endif
            if (timeout == 1)
            {
#ifdef DEBUG
                (void) fprintf (stderr," Removing timeout\n");
#endif
                timeout=0;
                XtRemoveTimeOut(s_timerid);
                s_timerid=0L;
            }
            if (ShelpShellW != (Widget) NULL)
            {
                if (XtIsManaged(ShelpShellW))
                {
#ifdef DEBUG
                    (void) fprintf (stderr," Unmanaging...\n");
#endif
                    XtUnmanageChild(ShelpShellW);
                }
            }
            /*
            if (data->text != (char *) NULL)
                XtFree(data->text);
            XtFree(data);
            data=NULL;
            */
            break;
        }
   }
}

#if __STDC__ || defined(sgi) || defined(_AIX)
static void PopQtip(XtPointer client_data)
#else
static void PopQtip(client_data)
XtPointer
    client_data;
#endif
{
	static XmFontList	flist= NULL;
	XmString	lab_str;
	Dimension	lab_w,lab_h,w,h;
	Position	rx,ry;
	QtipData	*data;

#ifdef DEBUG
    (void) fprintf (stderr," TImeout Reached...\n");
#endif

    data=(QtipData *) client_data;

    s_timerid=0L;
    timeout=0;

    /*
    ** it's possible, a time consuming call was made and mouse moved
    ** out of the window, but the event is lost, so the help window
    ** might still be up..bring it down, # Oct-22-96 
    */
    if (ShelpShellW != (Widget) NULL)
    {
        if (XtIsManaged(ShelpShellW))
            XtUnmanageChild(ShelpShellW);
    }

    /*
    ** first time
    */
    if (ShelpShellW == (Widget) NULL)
    {
        /*
        ** create the shell, set the XmNoverrideRedirect to True, so that
        ** the window manger won't intervene
        */
        ShelpShellW=XtVaCreatePopupShell("tipShell",
            topLevelShellWidgetClass,GetTopShell(data->widget),
            XmNoverrideRedirect, True,
            XmNresizePolicy,XmRESIZE_ANY,
            NULL);

        /*
        ** create the label
        ** we must make the label widget static.
        */
        SlabelW=XtVaCreateManagedWidget("tipLabel",
            xmLabelWidgetClass, ShelpShellW,
            NULL);
    }

    if (flist == NULL)
    {
        XtVaGetValues(SlabelW,
            XmNfontList,&flist,
            NULL);
    }

    if (data->text != (char *) NULL)
    {
        lab_str=XmStringCreateSimple(data->text);
    }
    else
	{
        XtVaGetValues(data->widget,XmNlabelString,&lab_str,NULL);
	}

	lab_w=0;
	lab_h=0;
    if (flist)
    {
        lab_w=XmStringWidth(flist,lab_str)+6;
        lab_h=XmStringHeight(flist,lab_str)+6;
    }

    /*
    ** determine widgets width & height
    */
    XtVaGetValues(data->widget,
        XmNwidth,&w,
        XmNheight,&h,
        NULL);

    /*
    ** we will pop the qtip window 2 pixels below the widgets edge and
    ** halfway from the widget's left edge. So, we will translate these
    ** coordinate from widget coordinates to root window coordinates
    */
    XtTranslateCoords(data->widget,
        (Position) (w/2),
        (Position) (h+2),
        &rx,&ry);
		
		rx=rx-10;
		ry=ry-10;

    XtVaSetValues(ShelpShellW,
        XmNx,rx,
        XmNy,ry,
        XmNwidth,lab_w,
        XmNheight,lab_h,
        NULL);
    XtVaSetValues(SlabelW,
        XmNlabelString,lab_str,
        NULL);

    /*
    ** don't need the string, free it
    */
    XmStringFree(lab_str);

    if (ShelpShellW != (Widget) NULL)
    {
        XtManageChild(ShelpShellW);
        /*
        ** was not working properly with fvwm95
        ** Raising it at the top each time fixed it
        */
        XRaiseWindow(XtDisplay(ShelpShellW),XtWindow(ShelpShellW));
    }
}

/*
** from Dan H's Motif book from O'Rielly
*/
#if __STDC__ || defined(sgi) || defined(_AIX)
static Widget GetTopShell(Widget w)
#else
static Widget GetTopShell(w)
Widget
    w;
#endif
{
    while ((w != (Widget) NULL) && (XtIsWMShell(w) == False))
        w=XtParent(w);

return (w);
}
