/*
 * main.c
 *
 * main() and global variables
 *
*/

#include "dtpower.h"

XtAppContext	app;
Widget 		button, popup_menu;
int 		first_expose, status, gauge, threshold, popup_is_open;
char		command[1024];
int             arm;
XColor          green, orange, red, gray, blue;
Widget          toplevel;
int 		decor;
Position	old_rootx, old_rooty;
Pixel 		pbg;
int		in_fp;
Pixmap		battery_pix, power_pix, battery_select_pix, power_select_pix;
Pixel           fg, bg, sc;


#ifdef ENABLE_NLS
#include <locale.h>
#include <nl_types.h>
nl_catd msg_cat_desc;
#endif

char *fallback[] = {
    /* too bad there is no real converter for that stuff! */
/*
  "*mwmDecorations:  0",
  "*XmDialogShell*mwmDecorations: 1",
    "dtpower*background: gray",
*/
    "dtpower*keyboardFocusPolicy: pointer",
    "dtpower*tipLabel*fontList:-*-helvetica-medium-r-*-*-*-120-*-*-*-*-iso8859-*",
    "dtpower*tipShell.borderWidth: 1",
    "dtpower*tipShell.borderColor: red",
    "dtpower*tipLabel.background: #FFFFCC",
    "dtpower*tipLabel.foreground: black",

  NULL
};


/*
 * main()
 */
int main (int argc, char *argv[])
{
	int 			mwm_decor;

	in_fp=0;
	arm = 0;
	status = 0;
	popup_is_open = 0;
	gauge = 100;
	first_expose = 0;

	XtSetLanguageProc (NULL, NULL, NULL);

#ifdef ENABLE_NLS
	setlocale(LC_ALL, "");
	msg_cat_desc=catopen("dtpower.cat",NL_CAT_LOCALE);
	if((long)msg_cat_desc== -1)
		perror("Couldn't open  dtpower  message catalog");
#endif


	toplevel = XtVaOpenApplication (&app, "dtpower", NULL, 0, 
					&argc, argv, fallback,
					sessionShellWidgetClass, 
/*
					XmNtoolTipEnable, False,
					XmNtoolTipPostDelay, 0,
					XmNtoolTipPostDuration, 0,
*/
					XmNwidth, 60, XmNheight, 60,
        				NULL,
					NULL);

	read_config();
	initialize(toplevel);

	Widget bb;

	bb = XtVaCreateWidget("frame", compositeWidgetClass, toplevel,
			XmNx, 4, XmNwidth, 60, XmNheight, 60, NULL);

	button = XmCreatePushButton(bb, "button", NULL, 0);
	XtManageChild(button);

	XtVaGetValues (button, 
			XmNforeground, &fg, 
			XmNbackground, &bg,
			XmNarmColor, &sc, 
			NULL);

	XtDestroyWidget(button);
	button = XmCreateDrawnButton(bb, "button", NULL, 0);
	XtManageChild(button);


	XtManageChild (bb);


	XtVaSetValues (button, XmNlabelType, XmPIXMAP, NULL);
	XtVaSetValues (button, XmNmultiClick, XmMULTICLICK_DISCARD, NULL);
	XtVaSetValues (button, XmNpushButtonEnabled, FALSE, NULL);
	XtVaSetValues (button, XmNx, 0, XmNy, 0, XmNwidth, 60,
					XmNheight, 60, NULL);

/*
    XtVaSetValues (button, XmNpushButtonEnabled, True, NULL );
	XtAddCallback (button, XmNactivateCallback, activate_callback, popup_menu);
*/
	XtAddCallback (button, XmNarmCallback, arm_callback, NULL);
	XtAddCallback (button, XmNdisarmCallback, arm_callback, NULL);
	XtAddCallback (button, XmNexposeCallback, my_callback, NULL);


	XtAppAddTimeOut(app, 400,
        	(XtTimerCallbackProc)timer_callback, NULL);

	XtRealizeWidget (toplevel);


	XtVaGetValues (toplevel, XmNmwmDecorations, &mwm_decor, NULL);
	if ( decor == 0 ) 
	{
/*
		mwm_decor &= ~MWM_DECOR_BORDER;
		XtVaSetValues (toplevel, XmNmwmDecorations, mwm_decor, NULL);

*/
		XtVaSetValues(toplevel, XmNmwmDecorations,
               	MWM_DECOR_ALL |
               	MWM_DECOR_BORDER |
	   	MWM_DECOR_RESIZEH |
		MWM_DECOR_TITLE |
               	MWM_DECOR_MENU |
               	MWM_DECOR_MINIMIZE |
               	MWM_DECOR_MAXIMIZE,
               	NULL );

	}

	XtAppMainLoop (app);
}

