#include "dtpower.h"

/*
 * initialize some global variables
 */
void initialize(Widget w)
{
	Display*	display;
	Colormap	cmap;
	XColor		ignore;

	display = XtDisplay(w);
	cmap = DefaultColormap (display, DefaultScreen(display));

	char*           colorname_green = "green";
	char*           colorname_orange = "orange";
	char*           colorname_red = "red";
	char*           colorname_blue = "blue";
	char*           colorname_gray = "Web Gray";

	XAllocNamedColor (display, cmap, colorname_green, &green, &ignore);
	XAllocNamedColor (display, cmap, colorname_orange, &orange, &ignore);
	XAllocNamedColor (display, cmap, colorname_red, &red, &ignore);
	XAllocNamedColor (display, cmap, colorname_blue, &blue, &ignore);
	XAllocNamedColor (display, cmap, colorname_gray, &gray, &ignore);

	XtTranslateCoords(w, 0, 0, &old_rootx, &old_rooty);

}

/* findWindow
 *  - Fenster zu Root-Koordinate zurueckliefern
 */
Window findWindow (display, x, y)
Display* display;       /* Display */
int x, y;               /* Root-Koordinaten */
{
    XWindowAttributes attr;
    Window findW;
    Window childW, newChildW;
	XClassHint class_hint;

    /* bei Root gehts los */
    findW = DefaultRootWindow(display);

    /* evtl. Child-Window fuer den Punkt ermitteln
     */
    XTranslateCoordinates (display, findW, findW,
                           x, y, &x, &y, &childW);

    /* solange Child-Window, in dem sich der Punkt befindet, existiert
     */
    while (childW != None) {
        /* Koordinaten-Transformation nach Child-Window
         * (dabei evtl. neues Child-Window ermitteln)
         */
        XTranslateCoordinates (display, findW, childW,
                               x, y, &x, &y, &newChildW);

        /* InputOnly-Fenster zaehlen nicht
         */
        if (newChildW != None) {
			if(XGetClassHint(display,childW,&class_hint))
			{
				if(strcmp(class_hint.res_name,"FrontPanel") == 0 )
				{
					in_fp = 1;
				}
				XFree(class_hint.res_name);  
				XFree(class_hint.res_class);    
			}

            XGetWindowAttributes (display, childW, &attr);
            if (attr.class != InputOutput) {
                return childW;
            }
        }

        /* fuer den naechsten Durchgang
         */
        findW = childW;
        childW = newChildW;
    }

    /* das ist es */
    return findW;
}


/*
 * chack wether we are positioned in the frontpanel and decide afterwards 
 * wether to use xshape (as desklet) or not (in frontpanel)
 */
int in_frontpanel(Widget w)
{
	Position x, y;
	XtTranslateCoords(w, 0, 0, &x, &y);

#ifdef DEBUG
	printf( "in_frontpanel: %d %d\n", x, y );
#endif

	findWindow(XtDisplay(w), x, y );

#ifdef DEBUG
	printf( "in_frontpanel: %d\n", in_fp );
#endif

	return 0;
}


