/*
 * image.c
 *
 * Helper functions to draw some images
*/
#include "dtpower.h"
#include <X11/xpm.h>
#include <X11/extensions/shape.h>

/*
 * prints the image gray for the use as desklet
 */
void xshape_gray_image(  char* name[] )
{
	XImage *img, *clp;
	Pixmap pmap;
	GC shape_gc, win_gc;
	XGCValues xgcv;
	Display *dpy;
	Window win;

	dpy = XtDisplay(button);
	win = XtWindow(button);

	xgcv.foreground = gray.pixel;
	xgcv.line_width = 1;
	xgcv.line_style = LineSolid;

	win_gc = XCreateGC(dpy, win,
	        GCForeground | GCLineWidth | GCLineStyle, &xgcv);


	/* create the pixmap that we'll use for shaping the window */
	pmap = XCreatePixmap(dpy, win, W_WIDTH, W_HEIGHT, 1);

	shape_gc = XCreateGC(dpy, pmap, 0, &xgcv);

	XpmCreateImageFromData( dpy, name, &img, &clp, NULL );

	XSetForeground(dpy, shape_gc, 1);
	XFillRectangle(dpy, pmap, shape_gc, 0, 0, W_WIDTH,
	        W_HEIGHT);

	XSetForeground(dpy, shape_gc, 0);
/*
	XPutImage(dpy, pmap, shape_gc, clp,
		0, 0, 4, 4, clp->width, clp->height);
*/
	
	XSetForeground(dpy, win_gc, WhitePixel(dpy,
	            DefaultScreen(dpy)));
	XPutImage(dpy, win, win_gc, img,
	    0, 0, 6, 6, img->width, img->height);

	XShapeCombineMask (dpy, win, ShapeBounding,
	        0, 0, pmap, ShapeSet);
	XSync(dpy, False);

	XSetForeground(dpy, shape_gc, 1);
	XFillRectangle(dpy, pmap, shape_gc, 0, 0, W_WIDTH, W_HEIGHT);

	XSetForeground(dpy, shape_gc, 0);
	XPutImage(dpy, pmap, shape_gc, clp,
	    0, 0, 6, 6, clp->width, clp->height);

	XSetForeground(dpy, win_gc, WhitePixel(dpy,
	            DefaultScreen(XtDisplay(button))));
	XPutImage(dpy, win, win_gc, img,
	    0, 0, 6, 6, img->width, img->height);

	XShapeCombineMask (dpy, win,
	                    ShapeBounding,
	                    0, 0, pmap, ShapeSet);

	XSync(dpy, False);

	XFreeGC(dpy, win_gc);
	XFreeGC(dpy, shape_gc);
	XDestroyImage(img);
	XDestroyImage(clp);
	XFreePixmap(dpy, pmap);

}


/*
 * prints the image transparent for the use as desklet
 */
void xshape_transp_image(  char* name[] )
{
	XImage *img, *clp;
	Pixmap pmap;
	GC shape_gc, win_gc;
	XGCValues xgcv;
	Display *dpy;
	Window win;

	dpy = XtDisplay(toplevel);
	win = XtWindow(toplevel);
	/* create a graphics context for drawing on the window */
	xgcv.foreground = WhitePixel(dpy, DefaultScreen(dpy));
	xgcv.line_width = 1;
	xgcv.line_style = LineSolid;

	win_gc = XCreateGC(dpy, win,
	        GCForeground | GCLineWidth | GCLineStyle, &xgcv);

	/* create the pixmap that we'll use for shaping the window */
	pmap = XCreatePixmap(dpy, win, W_WIDTH, W_HEIGHT, 1);

	shape_gc = XCreateGC(dpy, pmap, 0, &xgcv);

    XpmCreateImageFromData( dpy, name, &img, &clp, NULL );

	XSetForeground(dpy, shape_gc, 0);
	XFillRectangle(dpy, pmap, shape_gc, 0, 0, W_WIDTH,
	        W_HEIGHT);

	XSetForeground(dpy, shape_gc, 1);
	XPutImage(dpy, pmap, shape_gc, clp,
	    0, 0, 6, 6, clp->width, clp->height);

	XSetForeground(dpy, win_gc, WhitePixel(dpy,
	            DefaultScreen(dpy)));
	XPutImage(dpy, win, win_gc, img,
	    0, 0, 6, 6, img->width, img->height);

	XShapeCombineMask (dpy, win, ShapeBounding,
	        0, 0, pmap, ShapeSet);
	XSync(dpy, False);


	XSetForeground(dpy, shape_gc, 0);
	XFillRectangle(dpy, pmap, shape_gc, 0, 0, W_WIDTH, W_HEIGHT);

	XSetForeground(dpy, shape_gc, 1);
	XPutImage(dpy, pmap, shape_gc, clp,
	    0, 0, 6, 6, clp->width, clp->height);

	XSetForeground(dpy, win_gc, WhitePixel(dpy,
	            DefaultScreen(dpy)));
	XPutImage(XtDisplay(button), XtWindow(button), win_gc, img,
	    0, 0, 6, 6, img->width, img->height);

	XShapeCombineMask (dpy, win, 
						ShapeBounding,
	        			0, 0, pmap, ShapeSet);

	XSync(dpy, False);

	XFreeGC(dpy, win_gc );
	XFreeGC(dpy, shape_gc );

	XDestroyImage( img );
	XDestroyImage( clp );

	XFreePixmap(XtDisplay(button), pmap);
}

/*
 * prints the gauge as characters in both xpm's for the symbol icon
 */
void print_new_icon ( char* power[], char* battery[], Pixel col )
{

    /* get XPM definitions for power */
#ifdef DEBUG
	printf ("power-definitions: %s\n", power[0] );
#endif
	const char empty[2]=" ";
	char *token;
	char buf[20];
	char dummy[100];

	strcpy ( buf, power[0] );
	token = strtok(buf, empty);
        
	int count=0;
	int xpm_width=0;
#ifdef DEBUG
	int xpm_height=0;
#endif
	int xpm_colors=0;
		
    while(token != NULL) 
    {
		strcpy( dummy, token);
		if ( count == 0 ) 
		{
			xpm_width = atoi( dummy );		
		}
#ifdef DEBUG
		if ( count == 1 ) 
		{
			xpm_height = atoi( dummy );		
		}
#endif
		if ( count == 2 ) 
		{
			xpm_colors = atoi( dummy );		
		}
		token = strtok(NULL, " ");
		count++;
	}
	
#ifdef DEBUG
	printf( "xpm_width=%d, xpm_height=%d, xpm_colors=%d\n", 
			xpm_width, xpm_height, xpm_colors );
#endif

	char line[100];
	line[0] = '\0';

	int barline = xpm_width + xpm_colors - 3;			
    int i=0;
    int charcount = gauge/2;

    if ( charcount > xpm_width )
    {
        charcount = xpm_width;
    }

    for ( i=0; i<xpm_width; i++ )
    {
        if( i < charcount )
        {
            line[i] = 'G';
            if ( gauge < 50 )
            {
                line[i] = 'O';
            }
            if ( gauge < 20 )
            {
                line[i] = 'R';
            }
        }
        else
        {
            line[i] = ' ';
        }
		line[i+1] = '\0';
    }

	
	power[barline] = line;
	barline++;
	power[barline] = line;
	barline++;
	power[barline] = line;


    /* get XPM definitions for battery */
#ifdef DEBUG
	printf ("battery-definitions: %s\n", battery[0] );
#endif	
	strcpy ( buf, battery[0] );
	token = strtok(buf, empty);
        
	count=0;
	xpm_width=0;
	/*
	xpm_height=0;
	*/
	xpm_colors=0;
		
    while(token != NULL) 
    {
		strcpy( dummy, token);
		if ( count == 0 ) 
		{
			xpm_width = atoi( dummy );		
		}
		/*
		if ( count == 1 ) 
		{
			xpm_height = atoi( dummy );		
		}
		*/
		if ( count == 2 ) 
		{
			xpm_colors = atoi( dummy );		
		}
		token = strtok(NULL, " ");
		count++;
}
#ifdef DEBUG	
	printf( "xpm_width=%d, xpm_colors=%d\n", 
			xpm_width, xpm_colors );
	printf( "LINE %s\n", 
			line );
#endif
	barline = xpm_width + xpm_colors - 3;			



	battery[barline] = line;
	barline++;
	battery[barline] = line;
	barline++;
	battery[barline] = line;


	Pixmap pixmap, mask;

	if ( status == 0 ) 
	{
#ifdef DEBUG
		printf( "status.0\n");
#endif		
		XpmCreatePixmapFromData( XtDisplay(button), 
			DefaultRootWindow(XtDisplay(button)), 
			power, &pixmap, &mask, NULL );

		if ( arm == 0 )
		{
			if( in_fp == 0 )
			{
				xshape_transp_image( power );
			}
			else
			{
				XpmAttributes attrib;
				int Depth;                                                                                                          
				XpmColorSymbol XpmTransparentColor[1] = {{ NULL, "none", 0 }};
				XtVaGetValues(button, XmNdepth,&Depth, NULL);
				XpmTransparentColor[0].pixel = col;
				attrib.valuemask    = XpmColorSymbols | XpmCloseness | XpmDepth;
				attrib.colorsymbols = XpmTransparentColor;
				attrib.numsymbols   = 1;
				attrib.closeness    = 65535;
				attrib.depth        = Depth;

				XpmCreatePixmapFromData( XtDisplay(button), 
						DefaultRootWindow(XtDisplay(button)), 
						power, &power_pix, NULL, &attrib );                                                                                                                 
				XCopyArea (XtDisplay (button), power_pix, XtWindow (button),
                        XDefaultGCOfScreen (XtScreen (button)), 0, 0,
                        48, 48, 6,6);
			}
		}
		else 
		{
			if( in_fp == 0 )
			{
				xshape_gray_image( power );
			}
			else
			{
				XpmAttributes attrib;
				int Depth;                                                                                                          
				XpmColorSymbol XpmTransparentColor[1] = {{ NULL, "none", 0 }};
				XtVaGetValues(button, XmNdepth,&Depth, NULL);
				XpmTransparentColor[0].pixel = col;
				attrib.valuemask    = XpmColorSymbols | XpmCloseness | XpmDepth;
				attrib.colorsymbols = XpmTransparentColor;
				attrib.numsymbols   = 1;
				attrib.closeness    = 65535;
				attrib.depth        = Depth; 

				XpmCreatePixmapFromData( XtDisplay(button), 
							DefaultRootWindow(XtDisplay(button)), 
							power, &power_select_pix, NULL, &attrib );                                                                                                          
				XCopyArea (XtDisplay (button), power_select_pix, XtWindow (button),
                        XDefaultGCOfScreen (XtScreen (button)), 0, 0,
                        48, 48, 6,6);
			}
			XtVaSetValues (XtParent(button), XmNbackground, gray.pixel, NULL);
		}
	} 
	else 
	{
#ifdef DEBUG
		printf( "status.1\n");
#endif
		
		XpmCreatePixmapFromData( XtDisplay(button), 
			DefaultRootWindow(XtDisplay(button)), 
			battery, &pixmap, &mask, NULL );

		if ( arm == 0 ) 
		{
			if( in_fp == 0 )
			{
				xshape_transp_image( battery );
			}
			else
			{
				XpmAttributes attrib; 
				int Depth;                                                                                                          
				XpmColorSymbol XpmTransparentColor[1] = {{ NULL, "none", 0 }};  
				XtVaGetValues(button, XmNdepth,&Depth, NULL);  
				XpmTransparentColor[0].pixel = col; 
				attrib.valuemask    = XpmColorSymbols | XpmCloseness | XpmDepth; 
				attrib.colorsymbols = XpmTransparentColor; 
				attrib.numsymbols   = 1;
				attrib.closeness    = 65535; 
				attrib.depth        = Depth;

				XpmCreatePixmapFromData( XtDisplay(button), 
						DefaultRootWindow(XtDisplay(button)), 
						battery, &battery_pix, NULL, &attrib );                                                                                                                 
				XCopyArea (XtDisplay (button), battery_pix, XtWindow (button),
                        XDefaultGCOfScreen (XtScreen (button)), 0, 0,
                        48, 48, 6,6);
			}
		} 
		else 
		{
			if( in_fp == 0 )
			{
				xshape_gray_image( battery);
			}
			else
			{
				XpmAttributes attrib;
				int Depth;                                                                                                          
				XpmColorSymbol XpmTransparentColor[1] = {{ NULL, "none", 0 }};
				XtVaGetValues(button, XmNdepth,&Depth, NULL);
				XpmTransparentColor[0].pixel = col;
				attrib.valuemask    = XpmColorSymbols | XpmCloseness | XpmDepth;
				attrib.colorsymbols = XpmTransparentColor;
				attrib.numsymbols   = 1;
				attrib.closeness    = 65535;
				attrib.depth        = Depth;

				XpmCreatePixmapFromData( XtDisplay(button), 
							DefaultRootWindow(XtDisplay(button)), 
							battery, &battery_select_pix, NULL, &attrib );                                                                                                          
				XCopyArea (XtDisplay (button), battery_select_pix, 
						XtWindow (button),
                        XDefaultGCOfScreen (XtScreen (button)), 0, 0,
                        48, 48, 6,6);
			}
			XtVaSetValues (button, XmNbackground, col, NULL);
		}
	}

	XtVaSetValues( toplevel, XmNiconPixmap, pixmap, NULL);
	XtVaSetValues( toplevel, XmNiconMask, mask, NULL);
}


