/*
 * dtpower.h
*/


#include <stdlib.h>
#include <Xm/XmAll.h>


#define BUFSIZE 128
#define MAXLINE 1024
#define CONFIGDIR ".dt"
#define CONFIGFILE "dtpower.conf"

/* size of the window */
#define W_WIDTH 60
#define W_HEIGHT 60


typedef struct {
	char        *label;
	void        (*callback)();
	XtPointer   data;
} ActionAreaItem;


#ifdef ENABLE_NLS
#include <locale.h>
#include <nl_types.h>
extern nl_catd msg_cat_desc;
#endif


/* Global variables */
extern Widget		toplevel;
extern XtAppContext	app;
extern Widget      	button, popup_menu;
extern int         	status, gauge, threshold, popup_is_open;
extern char        	command[1024];
extern int         	arm;
extern XColor		green, orange, red, gray, blue;
extern int 			decor;
extern Pixmap 		pix;
extern Position 	old_rootx, old_rooty;
extern Pixel 		pbg;
extern int			first_expose, in_fp;
extern Pixmap		battery_pix, power_pix, battery_select_pix, power_select_pix;
extern     Pixel           fg, bg, sc;


/* forward declarations */

/* in dialog.c */
Widget CreateActionArea (Widget parent, ActionAreaItem *actions, int num_actions);
int timer_callback(XtPointer client_data, XtIntervalId *timer);
int read_config() ;
int write_config() ;
int do_dialog( Widget w, Position x, Position y) ;
void help_callback (Widget parent, XtPointer client_data, XtPointer call_data);
int do_info (Widget w, Position x, Position y);
void popup_cb (Widget menu_item, XtPointer client_data, XtPointer call_data);
void do_info_done (Widget dialog, XtPointer client_data, XtPointer call_data);
void help_done (Widget dialog, XtPointer client_data, XtPointer call_data);
void close_dialog (Widget w, XtPointer client_data, XtPointer call_data);
void ok_pushed (Widget w, XtPointer client_data, XtPointer call_data);
void activate_cb (Widget text_w, XtPointer client_data, XtPointer call_data);

/* in functions.c */
int acpi_a();


/* in callbacks.c */
void PostIt(Widget pb, XtPointer client_data, XEvent *event, Boolean* p);
void my_callback (Widget menu_item, XtPointer client_data, XtPointer call_data);
void activate_callback (Widget w, XtPointer client_data, XtPointer call_data);
void arm_callback (Widget w, XtPointer client_data, XtPointer call_data);

/* in init.c */
void initialize( Widget w );
int in_frontpanel( Widget w );

/* in image.c */
void print_new_icon ( char* power[], char* battery[], Pixel col );



