/*
 * dialog.c
 *
 * Motif dialogs and their callbacks
 *
*/

#include "dtpower.h"

#include <Xm/DialogS.h>
#include <Xm/RowColumn.h>

Widget	text_w,spinBox,toggle_button;


/* +++ modified by bb +++ */
#include <ctype.h>

/*
 * treshHoldMod() -- invoked when the user changes the threshold
 */
void treshHoldMod(Widget wgt, XtPointer clientData, XtPointer callData){
	XmTextVerifyCallbackStruct* cbStruct = (XmTextVerifyCallbackStruct*) callData;

	if (cbStruct && cbStruct->text->ptr)
	{
		char* pPtr=cbStruct->text->ptr;
		while (*pPtr)
		{
			if (!isdigit(*pPtr))
				cbStruct->doit=False;
			pPtr++;
		}
		if (False == cbStruct->doit)
			XBell(XtDisplay(wgt), 100);
	}
}

void handleInput(Widget scText, XtPointer clientData, XtPointer cld){
    Arg args[20];
    int ac=0;

    Widget spinBox = (Widget)clientData;

    XmTextVerifyCallbackStruct *cd = (XmTextVerifyCallbackStruct*) cld;

    unsigned char spct=0;
    int minVal=0;
    int maxVal=0;

    XtSetArg (args[ac], XmNspinBoxChildType, &spct); ac++;
    XtSetArg (args[ac], XmNmaximumValue, &maxVal); ac++;
    XtSetArg (args[ac], XmNminimumValue, &minVal); ac++;

    XtGetValues(spinBox, args, ac);

    ac=0;

    if (cd && cd->reason == XmCR_LOSING_FOCUS){

        if (scText){
            char* sText;
            XtSetArg (args[ac], XmNvalue, &sText); ac++;
            XtGetValues(scText, args, ac);

            ac=0;

            int i=0;
            int l=strlen(sText);
            cd->doit=True;
            for (i=0; i<l; i++){
                if (! (sText[i] >= '0' && sText[i] <= '9')){
                    cd->doit=False;
                }
            }
            int pos=0;
            XtSetArg (args[ac], XmNposition, &pos); ac++;

            XtGetValues(spinBox, args, ac);

            ac=0;

            if(!cd->doit){
                char szBuf[5] = {0,0,0,0,0};
                snprintf(szBuf, 4, "%d", pos);
                XtSetArg (args[ac], XmNvalue, (XtArgVal)szBuf); ac++;
                XtSetValues(scText, args, ac);
                ac=0;
                cd->doit = True;
            } else {
                sscanf(sText, "%d", &pos);
            }
            if (pos < minVal)
                pos = minVal;
            if (pos > maxVal)
                pos = maxVal;

            XtSetArg (args[ac], XmNposition, (XtArgVal)pos); ac++;
            XtSetValues(spinBox, args, ac);

            XtFree(sText);
        }
    }
}


/* --- modified by bb --- */





/*
 * popup_cb() -- invoked when the user selects an item in the popup menu
 */
void popup_cb (Widget menu_item, XtPointer client_data, XtPointer call_data)
{
	long item_no = (long) client_data;
	Position	rootx, rooty;
	XmDrawnButtonCallbackStruct *cbs =
		(XmDrawnButtonCallbackStruct *) call_data;
	Widget w = XtParent( XtParent(menu_item));

	XButtonPressedEvent *bp = (XButtonPressedEvent *) cbs->event ;
	XtTranslateCoords(menu_item, bp->x, bp->y, &rootx, &rooty);

/*
	puts (XtName (menu_item));                                                  	printf( "Item: %d\n", item_no );
*/

	if (item_no == 0)
	{
		popup_is_open = 0;
		do_dialog(w, rootx-200, rooty-200 );
	}
	if (item_no == 1)
	{
		popup_is_open = 0;
		do_info(w, rootx-200, rooty-350 );
	}
	if (item_no == 2)
	{
		exit(0);
	}
}


/* do_info_done() -- called when user presses "OK" in dialogs. */
void do_info_done (Widget dialog, XtPointer client_data, XtPointer call_data)
{
	popup_is_open = 0;
	XtDestroyWidget (XtParent (dialog));
}
/* help_done() -- called when user presses "OK" in dialogs. */
void help_done (Widget dialog, XtPointer client_data, XtPointer call_data)
{
	XtDestroyWidget (XtParent (dialog));
}

void toggle1_cbk(Widget widget, XtPointer client_data,
XmToggleButtonCallbackStruct *state)

{
	printf("%s: %s\n", XtName(widget),
            state->set? "on" : "off");


	XtVaGetValues (toplevel, XmNmwmDecorations, &decor, NULL);
	decor &= ~MWM_DECOR_BORDER;
	XtVaSetValues (toplevel, XmNmwmDecorations, decor, NULL);

}


/* callback routine for "Push Me" button. Actually, this represents 
** a function that could be invoked by any arbitrary callback. Here, 
** we demonstrate how one can build a standard customized dialog box. 
** The control area is created here and the action area is created in 
** a separate, generic routine: CreateActionArea(). 
*/
int do_dialog (Widget w, Position x, Position y)
{
	/* +++ modified by bb +++ */
	Widget             spinText;
	/* --- modified by bb --- */

	Widget             dialog, pane, rc, action_a, label_g;
	XmString           string;
	Arg                args[20];
	int                n;
	Widget             CreateActionArea(Widget, ActionAreaItem *, int);
	static ActionAreaItem   action_items[] = {
		{"OK",ok_pushed,NULL},
		{"Cancel", close_dialog, NULL},
/*
		{"Clear", clear_pushed, NULL},
*/
		{"Help",help_callback, "Help Button"}, 
	};

        popup_is_open = 1;
	/* The DialogShell is the Shell for this dialog. Set it up so
	** that the "Close" button in the window manager's system menu
	** destroys the shell (it only unmaps it by default). 
	*/
	n = 0;
	/* give arbitrary title in wm */
	XtSetArg (args[n], XmNtitle, catgets( msg_cat_desc, 1,16,"Command and Threshold")); n++;
	XtSetArg (args[n], XmNx, x); n++;
	XtSetArg (args[n], XmNy, y); n++;
	/* system menu "Close" action */ 
	XtSetArg (args[n], XmNdeleteResponse, XmDESTROY); n++;
	dialog = XmCreateDialogShell (XtParent (w), "dialog", args, n);    
	/* now that the dialog is created, set the Cancel button's 
	** client data, so close_dialog() will know what to destroy. 
	*/
	action_items[2].data = (XtPointer) dialog;

	/* Create the paned window as a child of the dialog. This will
	** contain the control area and the action area 
	** (created by CreateActionArea() using the action_items above). 
	*/
	n = 0;
	XtSetArg (args[n], XmNsashWidth, 1); n++;
	XtSetArg (args[n], XmNsashHeight, 1); n++;
	pane = XmCreatePanedWindow (dialog, "pane", args, n);
	/* create the control area which contains a 
	** Label gadget and a TextField widget. 
	*/
	rc = XmCreateRowColumn (pane, "control_area", NULL, 0);


	string = XmStringCreateLocalized (catgets( msg_cat_desc, 1,8,"Command to be executed when battery goes under threshold:"));
	n = 0;
	XtSetArg (args[n], XmNlabelString, string); n++;
	label_g = XmCreateLabelGadget (rc, "label", args, n);
	XmStringFree (string);
	XtManageChild (label_g);


	string = XmStringCreateSimple(command);
	n = 0;
	XtSetArg(args[n], XmNvalue, command); n++;
	text_w = XmCreateTextField (rc, "text-field", args, n);
	XmStringFree (string);
	XtManageChild (text_w);


	string = XmStringCreateLocalized (catgets( msg_cat_desc, 1,12,"Threshold:"));
	n = 0;
	XtSetArg (args[n], XmNlabelString, string); n++;
	label_g = XmCreateLabelGadget (rc, "label", args, n);
	XtManageChild (label_g);
	XmStringFree (string);

	/*
	 * Create a SpinBox containing numeric values to 3 decimal places.
	 * Position the arrows on the right of the displayed value.
	 */

	n = 0;
	XtSetArg(args[n], XmNspinBoxChildType, XmNUMERIC); n++;
	XtSetArg(args[n], XmNminimumValue, 1); n++;
	XtSetArg(args[n], XmNmaximumValue, 100); n++;
	XtSetArg(args[n], XmNincrementValue,1); n++;
	XtSetArg(args[n], XmNdecimalPoints,0); n++;
/*
	XtSetArg(args[n], XmNeditable,FALSE); n++;
*/
	XtSetArg(args[n], XmNposition,threshold); n++;
	XtSetArg(args[n], XmNarrowLayout, XmARROWS_FLAT_END); n++;
	XtSetArg(args[n], XmNcolumns, 10); n++;
	spinBox = XmCreateSimpleSpinBox(rc, "spinBox5", args, n);
	XtManageChild(spinBox);

	/* +++ modified by bb +++ */
	n=0;
	XtSetArg(args[n], XmNtextField, &spinText); n++;
	XtGetValues(spinBox, args, n);

	XtAddCallback(spinText, XmNmodifyVerifyCallback, treshHoldMod, (XtPointer)spinBox);
	XtAddCallback(spinText, XmNlosingFocusCallback, handleInput, (XtPointer)spinBox);
	/* --- modified by bb --- */


    toggle_button = XtVaCreateManagedWidget(catgets( msg_cat_desc, 1,20,"Window Decorations ON/OFF for use as desklet (requires dtpower restart)"),
        xmToggleButtonWidgetClass, rc, NULL);
	XtManageChild(toggle_button);
	XmToggleButtonSetState(toggle_button, (Boolean) decor, FALSE );
        
/*
    XtAddCallback(toggle_button, XmNvalueChangedCallback, 
                  toggle1_cbk, NULL);
*/


	/* RowColumn is full -- now manage */
	XtManageChild (rc);


	/* Set the client data for the "OK" and "Cancel" buttons */
	action_items[0].data = (XtPointer) text_w;
	action_items[1].data = (XtPointer) text_w;
	/* Create the action area. */
	action_a = CreateActionArea (pane, action_items,
	XtNumber (action_items));
	/* callback for Return in TextField. Use action_a as client data */
	XtAddCallback (text_w, XmNactivateCallback, activate_cb,
		(XtPointer) action_a);
		XtManageChild (pane);
	return 0;
}


/* The next four functions are the callback routines for the buttons 
** in the action area for the dialog created above. Again, they are 
** simple examples, yet they demonstrate the fundamental design approach. 
*/
void close_dialog (Widget w, XtPointer client_data, XtPointer call_data)
{
	XtDestroyWidget (XtParent (XtParent(XtParent(w))));
	popup_is_open = 0;
}

/* The "ok" button was pushed or the user pressed Return */
void ok_pushed (Widget w, XtPointer client_data, XtPointer call_data)
{

	text_w = (Widget) client_data;
	char		*command_text = XmTextFieldGetString (text_w);
	int			threshold_int;


	XtVaGetValues (spinBox, XmNposition, &threshold_int, NULL);

	strcpy ( command, command_text );
	threshold = threshold_int;
	
	XtFree (command_text);

	decor = XmToggleButtonGetState(toggle_button);


	if ( decor == 0 )
	{
		XtVaSetValues(toplevel, XmNmwmDecorations,
			MWM_DECOR_ALL |
			MWM_DECOR_BORDER |
			MWM_DECOR_RESIZEH |
			MWM_DECOR_TITLE |
			MWM_DECOR_MENU |
			MWM_DECOR_MINIMIZE |
			MWM_DECOR_MAXIMIZE,
			NULL );
	}
	else
	{
		XtVaSetValues(toplevel, XmNmwmDecorations,
			MWM_DECOR_BORDER ,
			NULL );
	}
	
	XtDestroyWidget (XtParent (XtParent(XtParent(w))));
	write_config();
	popup_is_open = 0;
}

int do_info (Widget w, Position x, Position y)
{
	Widget		dialog;
	XmString	text;
	void		help_done(Widget, XtPointer, XtPointer);
	Arg			args[5];
	int			n;
	char 		about[100];

	popup_is_open = 1;
	n = 0;
	text = XmStringGenerate ((XtPointer) catgets( msg_cat_desc, 3,1,"dtpower was brought to you by\n\n \
				Juergen Mayerhofer <juergen_mayerhofer@yahoo.de>\n\n \
				and is licensed under LGPL. \n\n \
				Please send me msg-files with translations to other languages.\n \
				You can find existing translations in git or ask me via mail.\n"),
	                            XmFONTLIST_DEFAULT_TAG,
	                            XmCHARSET_TEXT,
	                            NULL);

	sprintf( about, "%s-%s", catgets( msg_cat_desc, 2,2,"About dtpower"), VERSION );
	XtSetArg (args[n], XmNtitle, about); n++;
	XtSetArg (args[n], XmNmessageString, text); n++;
	XtSetArg (args[n], XmNautoUnmanage, False); n++;
	XtSetArg (args[n], XmNx, x); n++;
	XtSetArg (args[n], XmNy, y); n++;
	dialog = XmCreateInformationDialog (XtParent(w), "About dtpower", args, n);
	XmStringFree (text);

	XtUnmanageChild (XtNameToWidget (dialog, "Cancel"));
	XtSetSensitive (XtNameToWidget (dialog, "Help"), False);
	/* the OK button will call help_done() below */
	XtAddCallback (dialog, XmNokCallback, do_info_done, NULL);
	/* display the help text */
	XtManageChild (dialog);
	return 0;
}

/* help_callback() -- callback routine for the Help button in the
** original dialog box that displays an InformationDialog based on the 
** help_text parameter.
*/

void help_callback (Widget parent, XtPointer client_data, XtPointer call_data)
{
	Widget     dialog;
	XmString   text;
	void       help_done(Widget, XtPointer, XtPointer);
	Arg        args[5];
	int        n;

	n = 0;
	text = XmStringGenerate ((XtPointer) catgets( msg_cat_desc, 4,2,"sudo needs to be configured in /etc/sudoers,  \
				this ist usually done with \n\n  sudo visudo \n\n \
				Consult your operating system documentation.\n\n") ,
	                            XmFONTLIST_DEFAULT_TAG,
	                            XmCHARSET_TEXT,
	                            NULL);
	XtSetArg (args[n], XmNtitle, catgets( msg_cat_desc, 4,1,"Help")); n++;
	XtSetArg (args[n], XmNmessageString, text); n++;
	XtSetArg (args[n], XmNautoUnmanage, False); n++;
	dialog = XmCreateInformationDialog (parent, "About dtpower", args, n);
	XmStringFree (text);

	XtUnmanageChild (XtNameToWidget (dialog, "Cancel"));
	XtSetSensitive (XtNameToWidget (dialog, "Help"), False);
	/* the OK button will call help_done() below */
	XtAddCallback (dialog, XmNokCallback, help_done, NULL);
	/* display the help text */
	XtManageChild (dialog);
}

void activate_cb (Widget text_widget, XtPointer client_data, XtPointer call_data)
{
	XmAnyCallbackStruct *cbs = (XmAnyCallbackStruct *) call_data;
	Widget              dflt, action_area = (Widget) client_data;

	/* get the "default button" from the action area... */
	XtVaGetValues (action_area, XmNdefaultButton, &dflt, NULL);
	if (dflt) /* sanity check -- this better work */
		/* make the default button think it got pushed using
		** XtCallActionProc(). This function causes the button
		** to appear to be activated as if the user pressed it.
		*/
	        XtCallActionProc (dflt, "ArmAndActivate", cbs->event, NULL, 0);
}

#define TIGHTNESS 20
Widget CreateActionArea (Widget parent, ActionAreaItem *actions,
                         int num_actions)
{
	Widget       action_area, widget;
	int          i;
	action_area = XmCreateForm (parent, "action_area", NULL, 0);
	XtVaSetValues (action_area,
		XmNfractionBase, TIGHTNESS*num_actions - 1,
		XmNleftOffset,   10,
		XmNrightOffset,  10,
		NULL);

	for (i = 0; i < num_actions; i++) 
	{
		widget = XmCreatePushButton (action_area, catgets( msg_cat_desc, 1,i+1,actions[i].label),
					NULL, 0);
		XtVaSetValues (widget, 
			XmNleftAttachment,
				i? XmATTACH_POSITION: XmATTACH_FORM, 
				XmNleftPosition,TIGHTNESS*i,
				XmNtopAttachment,XmATTACH_FORM,
				XmNbottomAttachment,XmATTACH_FORM,
				XmNrightAttachment, 
				i != num_actions - 1 ?
				XmATTACH_POSITION :
					XmATTACH_FORM,
				XmNrightPosition, TIGHTNESS * i + (TIGHTNESS - 1),
				XmNshowAsDefault,i == 0, 
				XmNdefaultButtonShadowThickness, 1, 
				NULL); 
		if (actions[i].callback)
			XtAddCallback (widget, XmNactivateCallback, actions[i].callback, 
				(XtPointer) actions[i].data);
		XtManageChild (widget);
		if (i == 0) 
		{
			/* Set the action_area's default button to the first widget 
			** created (or, make the index a parameter to the function
			** or have it be part of the data structure). Also, set the
			** pane window constraint for max and min heights so this
			** particular pane in the PanedWindow is not resizable.
			*/
			Dimension height, h;
			XtVaGetValues (action_area, XmNmarginHeight, &h, NULL);
			XtVaGetValues (widget, XmNheight, &height, NULL);
			height += 2 * h; 
			XtVaSetValues (action_area, 
				XmNdefaultButton, widget, 
				XmNpaneMaximum,   height, 
				XmNpaneMinimum,   height,
				NULL);
		}
	}
	XtManageChild (action_area);
	return action_area;
}

