/*
 * configfile.c
 *
 * Read and write the configfiles
 *
 */

#include "dtpower.h"
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h> 
#include <unistd.h>

/*
 * read the configfile
 */
int read_config() {
	FILE *fp;
	char *home;
	char bufr[MAXLINE];
	char configdir[1024];
	char configfile[1024];
	char *token1, *token2, *str;

	struct stat st = {0};

	home = getenv("HOME");
	if (home == NULL)
		return 1;

	sprintf(configdir, "%s/%s", home, CONFIGDIR );
	sprintf(configfile, "%s/%s/%s", home, CONFIGDIR, CONFIGFILE );

	if( stat(configdir, &st) == -1 ) 
	{
		printf("configdir %s missing, creating it...\n", configdir);
		mkdir(configdir, 0755);
	}
	
	
	if ((fp = fopen(configfile, "r")) == NULL) 
	{
		printf("failed, file not found!\n");
		return(1);
	}

	while (fgets(bufr, MAXLINE, fp) != NULL) 
	{
		if (bufr[0] == '#' || bufr[0] == '\n')
			continue;

		token2 = "";
		for (str = bufr; (token1 = strtok(str, "=\n\t")) != 0; str = NULL) 
		{
			if (strcmp(token2, "threshold") == 0) 
			{
				threshold = atoi(token1);
			}
			if (strcmp(token2, "command") == 0) 
			{
				strcpy( command, token1 );
			}
			if (strcmp(token2, "decor") == 0) 
			{
				decor = atoi(token1);
			}
			token2 = token1;
			if (str == NULL)    /* Terminate after name/value */
				break;
		}
	}
	fclose(fp);
	return 0;
}

/*
 * write the config file
 */
int write_config() 
{
	FILE *fp;
	char *home;
	char configfile[1024];

	home = getenv("HOME");
	if (home == NULL)
		return 1;

	sprintf(configfile, "%s/%s/%s", home, CONFIGDIR, CONFIGFILE );
	
	if ((fp = fopen(configfile, "w")) == NULL) 
	{
		printf("failed, file not found!\n");
		return(1);
	}
	fprintf( fp, "threshold=%d\n", threshold );
	fprintf( fp, "command=%s\n", command );
	fprintf( fp, "decor=%d\n", decor );
	fclose(fp);
	return 0;
}
