/*
 * callbacks.c
 *
 * This is for callbacks that are called directly from main() and 
 * some auxilliary funcions.
 '
*/

#include "dtpower.h"
#include "qtip.h"

#include <Xm/DialogS.h>
#include <unistd.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>
#include <X11/cursorfont.h>


#include "batac.xpm"
#include "bat100.xpm"

const XmStringCharSet unicodeCharset = "UTF-8";

/* PostIt() -- event handler for the 3rd mouse button on the
 * PushButton widget's window.
 */
void PostIt(Widget pb, XtPointer client_data, XEvent *event, Boolean* p)
{
    Widget popup = (Widget) client_data;
    XButtonPressedEvent *bevent = (XButtonPressedEvent *) event;


/*
	if(bevent->type==ButtonRelease){

		XtVaSetValues (pb, XmNbackground, pbg, NULL);
		XtVaSetValues (pb, XmNtopShadowColor, pbg, NULL);
		XtVaSetValues (pb, XmNbottomShadowColor, pbg, NULL);

		XmMenuPosition (popup, bevent);
 		XtManageChild (popup);
	}
*/



	if ( in_fp == 0 )
	{
/*
		printf("PostIt without FP: Right mouse button pressed %d\n", bevent->button);
	    if (bevent->button != 3)
           return;
*/
		XmMenuPosition (popup, bevent);
		XtManageChild (popup);
	}
	else
	{
/*
		printf("PostIt in FP: Left mouse button pressed %d\n",  bevent->button);
*/
	Position x, y;
	Position mrootx, mrooty;
	x = event->xbutton.x;
	y = event->xbutton.y;
	XtTranslateCoords(pb, x, y, &mrootx, &mrooty);
/*
	printf( "x: %d, y: %d, mrootx: %d, mrooty: %d\n",
			x, y, mrootx, mrooty );


	XtVaSetValues (pb, XmNtopShadowColor, blue.pixel, NULL);
	XtVaSetValues (pb, XmNbottomShadowColor, blue.pixel, NULL);
*/
	XtVaSetValues (pb, XmNbackground, gray.pixel, NULL);

	XtVaSetValues (popup, 
			XmNx, mrootx,
			XmNy, mrooty,
			NULL);
    XtManageChild (popup);
/*
	    if (bevent->button != 1)
           return;
*/
	}

    /* position the menu at the location of the button press.  If we wanted
    * to position it elsewhere, we could change the x,y fields of the
    * event structure.
    */

}


/*
 * callback for pressed button
 */
void arm_callback (Widget w, XtPointer client_data, XtPointer call_data)
{
	XmDrawnButtonCallbackStruct *cbs =
		(XmDrawnButtonCallbackStruct *) call_data;
	XEvent		*event = cbs->event;

	Position x, y;
	Position mrootx, mrooty;
	x = event->xbutton.x;
	y = event->xbutton.y;
	XtTranslateCoords(w, x, y, &mrootx, &mrooty);


	if (cbs->reason == XmCR_ARM) 
	{
		arm = 1;

		if ( in_fp == 0 ) 
		{
			Cursor cursor;
			cursor = XCreateFontCursor (XtDisplay(w), XC_fleur);
			XDefineCursor(XtDisplay(w),XtWindow(w),cursor);
			XFreeCursor(XtDisplay(w),cursor);
		}
		else
		{
/*
			XtVaSetValues (w, XmNtopShadowColor, blue.pixel, NULL);
			XtVaSetValues (w, XmNbottomShadowColor, blue.pixel, NULL);
			XtVaSetValues (w, XmNbackground, gray.pixel, NULL);
*/
			XtVaSetValues (w, XmNbackground, sc, NULL);
		}
	}
	if (cbs->reason == XmCR_DISARM) 
	{
		old_rootx = mrootx;
		old_rooty = mrooty;

		arm = 0;
		if ( in_fp == 0 ) 
		{
			Cursor cursor;
			cursor = XCreateFontCursor (XtDisplay(w), XC_left_ptr);
			XDefineCursor(XtDisplay(w),XtWindow(w),cursor);
			XFreeCursor(XtDisplay(w),cursor);
			if ( (mrootx - W_WIDTH/2) > 0 )
			{
				mrootx = mrootx - W_WIDTH/2;
			}
			if ( (mrooty - W_HEIGHT/2) > 0 )
			{
				mrooty = mrooty - W_HEIGHT/2;
			}
			if ( mrootx > (DisplayWidth(XtDisplay(button), DefaultScreen(XtDisplay(button)))-W_WIDTH))
			{
				mrootx = (DisplayWidth(XtDisplay(button), DefaultScreen(XtDisplay(button)))-W_WIDTH);
			}
			if ( mrooty > (DisplayHeight(XtDisplay(button), DefaultScreen(XtDisplay(button)))-W_HEIGHT))
			{
				mrooty = (DisplayHeight(XtDisplay(button), DefaultScreen(XtDisplay(button)))-W_HEIGHT);
			}
			XtVaSetValues (toplevel, XmNx, mrootx, XmNy, mrooty, NULL);
			XtVaSetValues (w, XmNtopShadowColor, pbg, NULL);
			XtVaSetValues (w, XmNbottomShadowColor, pbg, NULL);
		}
		else
		{
			XtVaSetValues (w, XmNtopShadowColor, pbg, NULL);
			XtVaSetValues (w, XmNbottomShadowColor, pbg, NULL);
			XtVaSetValues (w, XmNbackground, pbg, NULL);
		}
	}
}

/*
 * callback for pressed button
 */
void activate_callback (Widget w, XtPointer client_data, XtPointer call_data)
{
	XmDrawnButtonCallbackStruct *cbs =
		(XmDrawnButtonCallbackStruct *) call_data;
	XEvent		*event = cbs->event;


#ifdef DEBUG
	if ( event->xbutton.button == 1 )
	{
		printf("Left mouse button pressed\n");
	}
	if ( event->xbutton.button == 3 )
	{
		printf("Right mouse button pressed\n");
	}

	printf( "Activate Callback event: %d\n", event->xbutton.button );
#endif
	Position x, y;
	Position mrootx, mrooty;
	x = event->xbutton.x;
	y = event->xbutton.y;
	XtTranslateCoords(w, x, y, &mrootx, &mrooty);

#ifdef DEBUG
	printf( "x: %d, y: %d, mrootx: %d, mrooty: %d\n",
			x, y, mrootx, mrooty );
#endif

/*
	XtVaSetValues (w, XmNtopShadowColor, blue.pixel, NULL);
	XtVaSetValues (w, XmNbottomShadowColor, blue.pixel, NULL);
	XtVaSetValues (w, XmNbackground, gray.pixel, NULL);
*/

	Widget popup = (Widget) client_data;
	XtVaSetValues (popup, 
			XmNx, mrootx,
			XmNy, mrooty,
			NULL);


/*
    XmMenuPosition (popup, event);
*/
    XtManageChild (popup);

}

/*
 * callback for pressed buttons and expose
 */
void my_callback (Widget w, XtPointer client_data, XtPointer call_data)
{
	XmDrawnButtonCallbackStruct *cbs =
		(XmDrawnButtonCallbackStruct *) call_data;
	XEvent		*event = cbs->event;



	if ( event->xbutton.button == 3 ||  event->xbutton.button == 4 )
	{
#ifdef DEBUG
		printf("button release\n");
#endif
				XtVaSetValues (w, XmNtopShadowColor, pbg, NULL);
				XtVaSetValues (w, XmNbottomShadowColor, pbg, NULL);
				XtVaSetValues (w, XmNbackground, pbg, NULL);
	}
	

#ifdef DEBUG
	printf( "Eevent: %d\n", event->xbutton.button );
#endif
	if (cbs->reason == XmCR_EXPOSE) 
	{
		Position rootx, rooty;
		XtTranslateCoords(w, 0, 0, &rootx, &rooty);

		if ( rootx != old_rootx )
		{
			old_rootx = rootx;
			old_rooty = rooty;
		}

#ifdef DEBUG
		puts( XtName(w));
		printf( "EXPOSE \n");
#endif
		if( first_expose == 0 ) 
		{
#ifdef DEBUG
		printf( "FIRST EXPOSE \n");
#endif
			first_expose++;
			in_frontpanel(w);
		
			if ( in_fp == 1 ) 
			{
				XImage *xim;

#ifdef DEBUG
				printf( "rootx: %d, rooty: %d\n", rootx, rooty );
#endif
				Display *display;
				Window  win;
				display = XtDisplay(w);
				win = DefaultRootWindow(display);

				XUnmapWindow(XtDisplay(toplevel), XtWindow(toplevel));
				XSync(XtDisplay(toplevel), False);

				usleep( 100000);

				xim = XGetImage(display,  win, rootx, rooty, 4,6, AllPlanes, ZPixmap);
	
				pbg =  XGetPixel (xim, 1, 1);

				XMapRaised(XtDisplay(toplevel),  XtWindow(toplevel));
				XSync(display, False); 
				XDestroyImage(xim);

				XtVaSetValues (w, XmNtopShadowColor, pbg, NULL);
				XtVaSetValues (w, XmNbottomShadowColor, pbg, NULL);
				XtVaSetValues (w, XmNselectColor, gray.pixel, NULL);


				XmString       configure, about, quit;
				configure = XmStringCreateLocalized (catgets( msg_cat_desc,
						2, 1,"Configure dtpower"));
				about = XmStringCreateLocalized (catgets( msg_cat_desc,
						2, 2,"About dtpower"));
				quit = XmStringCreateLocalized (catgets( msg_cat_desc,
						2, 3,"Quit"));


				popup_menu = XmVaCreateSimplePopupMenu (XtParent(button), 
					"popup", popup_cb,
                    XmVaPUSHBUTTON, configure, 'C', NULL, NULL,
                    XmVaSEPARATOR,
                    XmVaPUSHBUTTON, about, 'A', NULL, NULL,
                    XmVaPUSHBUTTON, quit, 'Q', NULL, NULL,
                    NULL);
				XmStringFree (configure);
				XmStringFree (about);

				/* the 1st mouse button */
				XtAddCallback (button, XmNactivateCallback, 
					activate_callback, popup_menu);

			}
			else
			{
 				XmString	configure, about, quit;
				configure = XmStringCreateLocalized (catgets( msg_cat_desc,
						2, 1,"Configure dtpower"));
				about = XmStringCreateLocalized (catgets( msg_cat_desc,
						2, 2,"About dtpower"));
				quit = XmStringCreateLocalized (catgets( msg_cat_desc,
						2, 3,"Quit"));

				popup_menu = XmVaCreateSimplePopupMenu (button, 
					"popup", popup_cb,
                    XmVaPUSHBUTTON, configure, 'C', NULL, NULL,
                    XmVaSEPARATOR,
                    XmVaPUSHBUTTON, about, 'A', NULL, NULL,
                    XmVaPUSHBUTTON, quit, 'Q', NULL, NULL,
                    NULL);
				XmStringFree (configure);
				XmStringFree (about);
				XmStringFree (quit);

				/* for the 3rd mouse button */
				XtAddEventHandler (button, 
					ButtonPressMask, False, PostIt, popup_menu);
				XtAddEventHandler (button, 
					ButtonReleaseMask, False, PostIt, popup_menu);

			}
		}

		if ( arm == 0 ) 
		{
			XtVaSetValues (w, XmNtopShadowColor, pbg, NULL);
			XtVaSetValues (w, XmNbottomShadowColor, pbg, NULL);
			XtVaSetValues (w, XmNbackground, pbg, NULL);
			print_new_icon( batac, bat100, pbg  );
		}
		else
		{
			print_new_icon( batac, bat100, sc  );
		}
	}
}

/*
 * update the icon, gauge, tooltip every 4 seconds
 */
int timer_callback(XtPointer client_data, XtIntervalId *timer)
{
	XmString	tooltipString;
	char *cmd2 = "acpi -b | grep -v unavail";

	char buf[BUFSIZE];
	FILE *fp;

#ifdef DEBUG
	printf("TIMER, arm: %d\n ", arm);
#endif

	acpi_a();

	if ((fp = popen(cmd2, "r")) == NULL) 
	{
		printf("Error opening pipe!\n");
	}

	while (fgets(buf, BUFSIZE, fp) != NULL) 
	{
	#ifdef DEBUG
	        printf("OUTPUT: %s", buf);
	#endif
	}


	if(pclose(fp))  
	{
		printf("Command not found or exited with error status\n");
	}

	strtok(buf, "\n");

	tooltipString = XmStringCreate(buf, unicodeCharset);
	XtVaSetValues(button,XmNlabelString,tooltipString, NULL);
	Qtip(button, (char *) NULL);
	XmStringFree(tooltipString);
/*
	XtVaSetValues(button,XmNtoolTipString,tooltipString,NULL);
	        printf("OUTPUT: %s", buf);
*/


	XtVaSetValues(toplevel,XmNiconName,buf,NULL);

	/* get the value before the percent sign: thats the gauge */
	const char percent[2] = "%";
	char *token;
	char dummy[100];

	token = strtok(buf, percent);
	token = strtok(token, ",");
	while(token != NULL) 
	{
		strcpy( dummy, token);
		token = strtok(NULL, ",");
	}

	gauge = atoi( dummy );

	if ( gauge < threshold ) 
	{
		if ((fp = popen(command, "r")) == NULL) 
		{
			printf("Error opening pipe!\n");
			return -1;
		}

		while (fgets(buf, BUFSIZE, fp) != NULL) 
		{
			#ifdef DEBUG
			printf("OUTPUT: %s", buf);
			#endif
		}

		if(pclose(fp))  
		{
			printf("Command not found or exited with error status\n");
			return -1;
		}
	}


	if ( first_expose == 1 )
	{
/*
			arm = 0;
*/
			if( arm == 0) 
			{
				print_new_icon( batac, bat100, pbg  );
			}
			else
			{
				print_new_icon( batac, bat100, sc  );
			}
	}
	else
	{
		if( first_expose == 0 )
		{
			first_expose=1;
		}
	}

	XtAppAddTimeOut(app, 4000,
		(XtTimerCallbackProc)timer_callback, NULL);

	return 0;
}

