#include <pwd.h>
#include <grp.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <dirent.h>
#include <X11/Xlib.h>
#include <X11/X.h>
#include <Xm/Xm.h>
#include <Xm/ToggleB.h>

#include "defines.h"
#include "core.h"


int create_pattern_list(PatternList * head, char * in_text)
{
	char * ptr1, * ptr2;
	int len;
	int offset = 0;
	int prev_is_asterisk = 0, prev_is_reg_symbol = 0;
	int asterisk_counter = 0, text_segment_counter = 0;
	int i = 0, first_time;

#ifdef DEBUG
	printf("Start:%s\n", in_text);
#endif
	ptr2 = ptr1 = in_text;
	
	while(*ptr1 != '\0')
	{
		if (*ptr1 != '*')
		{
			ptr2[offset] = *ptr1;
			offset++;
			ptr1++;
			prev_is_asterisk = 0;
			if (!prev_is_reg_symbol)
				text_segment_counter++;
			prev_is_reg_symbol = 1;
		}
		else
		{
			prev_is_reg_symbol = 0;
			if (prev_is_asterisk)
			{
				ptr1++;
			}
			else
			{
				ptr2[offset] = *ptr1;
				offset++;
				ptr1++;
				prev_is_asterisk = 1;
				asterisk_counter++;
			}
		}
	}
	in_text[offset] = '\0';

#ifdef DEBUG
	printf("Pattern after prescan:%s\nasterisk counter=%d\ntext segment counter=%d\n", 
			in_text, asterisk_counter, text_segment_counter);
#endif

	len = strlen(in_text);
	
	if (*in_text == '*')
		head->asterisk_start = 1;
		
	if (in_text[len - 1] == '*')
		head->asterisk_end = 1;
		
	head->text_segment_count = text_segment_counter;

	if (!text_segment_counter)
		return 0;

	if (NULL == (ptr1 = calloc(text_segment_counter * (len + 2), sizeof(char))))
		return 0;

	if (NULL == (head->text = calloc(text_segment_counter, sizeof(char *))))
	{
		free(ptr1);
		return 0;
	}
	
	for (i = 0; i < text_segment_counter; i++)
	{
		head->text[i] = ptr1 + i * (len + 2);
	}
	
	
	ptr2 = ptr1 = in_text;
	offset = 0;
	i = 0;
	first_time = 1;
	
	while(*ptr1 != '\0')
	{
		if (*ptr1 != '*')
		{
			head->text[i][offset] = *ptr1;
			offset++;
			ptr1++;
		}
		else
		{
			if (first_time)
			{
				ptr1++;
				first_time = 0;
			}
			else
			{
				i++;
				offset = 0;
				ptr1++;
			}
		}
	}
	return text_segment_counter;
}

#ifdef DEBUG
void print_pattern_list(PatternList * head)
{
	int i;
	
	printf("** Pattern list **\n");
	printf("Text segment:%d\n", head->text_segment_count);
	if (head->asterisk_start)
		printf("Asterisk at start found\n");
	if (head->asterisk_end)
		printf("Asterisk at end found\n");
	
	if (!head->text_segment_count)
		return ;
	
	for (i = 0; i < head->text_segment_count; i++)
	{
		if (head->text)
		{
			if (head->text[i])
				printf("Text segment number %d is:%s\n", i, head->text[i]);
		}
	}
}
#endif

int check_pattern_list(PatternList * head, char * text)
{
	int i, pattern_end_is_end_oftext = 0;
	char * ptr1, * ptr2;

	if (head->asterisk_start && !head->text_segment_count)
		return 1;

	if (!head->asterisk_start)
	{
		if (head->text_segment_count && head->text)
		{
			ptr1 = strstr(text, head->text[0]);
			if (!ptr1 || (ptr1 && ptr1 > text))
				return 0;
		}
	}

	ptr1 = text;
	
	for (i = 0; i < head->text_segment_count; i++)
	{
		ptr2 = strstr(ptr1, head->text[i]);
		if (ptr2)
		{
			ptr1 = ptr2 + strlen(head->text[i]);
			if (*ptr1 == '\0' && i < (head->text_segment_count - 1))
				return 0;
				
			if (*ptr1 == '\0' && (i == (head->text_segment_count - 1)))
				pattern_end_is_end_oftext = 1;
		}
		else
			return 0;
	}

	if (i < head->text_segment_count)
		return 0;

	if (!head->asterisk_end)
		if (!pattern_end_is_end_oftext)
			return 0;

	return 1;
}

void clean_pattern_list(PatternList * head)
{
	if (head->text_segment_count)
	{
		if (head->text[0])
			free(head->text[0]);
			
		if (head->text)
			free(head->text);
	}
}


void copy_filedata(struct filedata * dst, struct filedata * src)
{
	struct fileinfo * ptrd, * ptrs;

	if (!dst || !src)
		return ;
	
	if (src->name)
	{
		dst->name = calloc(strlen(src->name) + 1, sizeof(char));
		strcpy(dst->name, src->name);
	}
	
	if (src->linkto)
	{
		dst->linkto = calloc(strlen(src->linkto) + 1, sizeof(char));
		strcpy(dst->linkto, src->linkto);
	}
	
	dst->filetype = src->filetype;
	dst->magic = src->magic;
	
	if (src->info)
	{
		ptrd = calloc(1, sizeof(struct fileinfo));
		ptrs = src->info;

		ptrd->f_size = ptrs->f_size;
		ptrd->f_atime = ptrs->f_atime;
		ptrd->f_mtime = ptrs->f_mtime;
		ptrd->f_ctime = ptrs->f_ctime;
		ptrd->f_perm = ptrs->f_perm;	
		ptrd->f_owner = ptrs->f_owner;
		ptrd->f_owngrp = ptrs->f_owngrp;
		ptrd->magic = ptrs->magic;
		
		dst->info = ptrd;
	}
}

char * get_path_from_full_name(char * full_name)
{
	int x;
	char * to_return;

	if (full_name == NULL)
		return NULL;

	if (full_name[0] == '\0')
		return NULL;

	for (x = strlen(full_name) - 1; x > 0; x--)
		if (full_name[x] == '/')
			break;

	if (0 == x)
		return NULL;
		
	to_return = calloc(x + 1, sizeof(char));
	
	if (to_return)
		strncpy(to_return, full_name, x);
		
	return to_return ;
} 

char * get_last_name_from_path(char * path) 
{
	int x;
	char * to_return;

	if (path == NULL)
		return NULL;

	if (path[0] == '\0')
		return NULL;


	for (x = strlen(path); x > 0; x--)
		if (path[x] == '/')
			break;

	if (x == 0)
	{
		if (path[x] != '/') 
			return NULL;

		if (path[1] == '\0')
		{
			return strdup(path);
		}
	}
	
	x++;
/*	to_return = calloc(strlen(path + x) + 2, sizeof(char));
	if (to_return)
		strncpy(to_return, path + x, strlen(path) - x);*/
//	to_return = strdup(path + x);

	to_return = calloc(strlen(path + x) + 1, sizeof(char));
	if (to_return)
		strcpy(to_return, path + x);

#ifdef DEBUG
	printf("get_last_name_from_path -> %d:%s|\n", x, to_return);
#endif

	return to_return;
}


void free_string_table(XmStringTable str_list, int n)
{
	int i;

	for (i = 0; i < n; i++)
	{
		XmStringFree(str_list[i]);
	}
	if (str_list)
		free(str_list);
}

Widget CreatePermToggle(Widget parent, char * name, void * user_data, char * label, char set, Boolean sensitive)
{
	XmString str;
	Arg args[5];
	int n = 0;
	Widget w;

	str = XmStringCreateLocalized(label);

	if (str)
	{
		XtSetArg(args[n], XmNlabelString, str);
		n++;
	}

	XtSetArg(args[n], XmNsensitive, sensitive);
	n++;
	XtSetArg(args[n], XmNset, set);
	n++;

	if (user_data)
	{
		XtSetArg(args[n], XmNuserData, user_data);
		n++;
	}
	
	w = XmCreateToggleButton(parent, name, args, n);

	XtManageChild(w);

	if (str)
		XmStringFree(str);
		
	return w;
}

Widget find_child(Widget top_point, const char ** path)
{
	Widget w = top_point;
	int n = 0;
	
	while (w && path[n] != NULL)
	{
		w = XtNameToWidget(w, path[n]);
		n++;
	}
	return w;
}

static int compare_name (char ** n1, char ** n2)
{
	return strcmp(*n1, *n2);
}

void sort_name(char ** names, int count)
{
	int (*func)();

	func = compare_name;

	qsort(names, count, sizeof (char **), func);
}

int user_in_group(char * user_name, struct group * grp)
{
	char * member;
	int i;
	
	if (grp->gr_mem)
	{
		for (i = 0; grp->gr_mem[i] != NULL; i++)
		{
			member = grp->gr_mem[i];
			if (!strcmp(member, user_name))
				return 1;
		}
	}
	return 0;
}

char ** get_grp_list_for_user(gid_t native_group, char * user_name, char * current_grp_name, int * ngrps)
{
	char * grp_name, ** ret, ** buf;
	char * member;
	struct group * grp;
	int n = 20, i = 0, k;

	ret = (char **) calloc(n, sizeof(char *));
	
	if (!ret)
		return NULL;

	grp_name = calloc(strlen(current_grp_name) + 1, sizeof(char));

	if (!grp_name)
	{
		if (ret)
			free(ret);
		
		*ngrps = 0;
		return NULL;
	}

	strcpy(grp_name, current_grp_name);
		
	ret[i] = grp_name;
	i++;


	setgrent();

	while ((grp = getgrent()) != NULL)
	{
		if (0 == user_in_group(user_name, grp) && grp->gr_gid != native_group)
			continue;

		if (0 == strcmp(grp->gr_name, current_grp_name))
			continue;
		
		grp_name = calloc(strlen(grp->gr_name) + 1, sizeof(char));
		if (!grp_name)
		{
			for (n = 0; n < i; n++)
			{
				if (ret[n])
					free(ret[n]);
			}
			if (ret)
				free(ret);
			return NULL;
		}
		strcpy(grp_name, grp->gr_name);
		if (i >= n - 1)
		{
			n+=10;
			buf = realloc(ret, sizeof(char *) * n);
			if (!buf)
			{
				for (n = 0; n < i; n++)
				{
					if (ret[n])
						free(ret[n]);
				}
				if (grp_name)
					free(grp_name);
				free(ret);
				return NULL;
			}
			ret = buf;
		}
		
		ret[i] = grp_name;
		i++;
	}

	endgrent();
	
	if (i == 0)
	{
		free(ret);
		ret = NULL;
	}
	
	*ngrps = i;
	return ret;
}



char ** get_grp_list(int * ngrps)
{
	char * grp_name, ** ret, ** buf;
	struct group * grp;
	int n = 20, i = 0;
	
	ret = (char **) calloc(n, sizeof(char *));
	
	if (!ret)
		return NULL;

	setgrent();

	while ((grp = getgrent()) != NULL)
	{
		grp_name = calloc(strlen(grp->gr_name) + 1, sizeof(char));
		if (!grp_name)
		{
			for (n = 0; n < i; n++)
			{
				if (ret[n])
					free(ret[n]);
			}
			if (ret)
				free(ret);
			return NULL;
		}
		strcpy(grp_name, grp->gr_name);
		if (i >= n - 1)
		{
			n+=10;
			buf = realloc(ret, sizeof(char *) * n);
			if (!buf)
			{
				for (n = 0; n < i; n++)
				{
					if (ret[n])
						free(ret[n]);
				}
				if (grp_name)
					free(grp_name);
				free(ret);
				return NULL;
			}
			ret = buf;
		}
		ret[i] = grp_name;
		i++;
	}

	endgrent();
	
	*ngrps = i;
	return ret;
}

char ** get_user_list(int * nusers)
{
	char * user_name, ** ret, ** buf;
	struct passwd * psw;
	int n = 20, i = 0;
	
	ret = (char **) calloc(n, sizeof(char *));
	
	if (!ret)
		return NULL;
	
	setpwent();
	
	while ((psw = getpwent()) != NULL)
	{
		user_name = calloc(strlen(psw->pw_name) + 1, sizeof(char));
		if (!user_name)
		{
			for (n = 0; n < i; n++)
			{
				if (ret[n])
					free(ret[n]);
			}
			if (ret)
				free(ret);
			return NULL;
		}
		strcpy(user_name, psw->pw_name);
		if (i >= n - 1)
		{
			n+=10;
			buf = realloc(ret, sizeof(char *) * n);
			if (!buf)
			{
				for (n = 0; n < i; n++)
				{
					if (ret[n])
						free(ret[n]);
				}
				if (user_name)
					free(user_name);
				free(ret);
				return NULL;
			}
			ret = buf;
		}
		ret[i] = user_name;
		i++;
	}
	endpwent();
	
	*nusers = i;
	return ret;
}

char * get_human_readable_permission(mode_t mode, char * ext_buf)
{
	char buf[100];
	char *ret;

	if (ext_buf)
	{
		ext_buf[0] = 0;
		ext_buf[9] = 0;
		ext_buf[10] = 0;
		ext_buf[11] = 0;
		
		sprintf(ext_buf, "%c%c%c%c%c%c%c%c%c%c",
				S_ISLNK(mode) ? 'l' :
				S_ISDIR(mode) ? 'd' : '-',
				(S_IRUSR & mode) ? 'r' : '-',
				(S_IWUSR & mode) ? 'w' : '-',
				(S_IXUSR & mode) ? 'x' : '-',
				(S_IRGRP & mode) ? 'r' : '-',
				(S_IWGRP & mode) ? 'w' : '-',
				(S_IXGRP & mode) ? 'x' : '-',
				(S_IROTH & mode) ? 'r' : '-',
				(S_IWOTH & mode) ? 'w' : '-',
				(S_IXOTH & mode) ? 'x' : '-');

		if (S_ISUID & mode)
			ext_buf[3] = (ext_buf[3] == 'x')?'s':'S';
		if (S_ISGID & mode)
			ext_buf[6] = (ext_buf[6] == 'x')?'s':'S';
		if (S_ISVTX & mode)
			ext_buf[9] = (ext_buf[9] == 'x')?'t':'T';
			
		return ext_buf;
	}

	buf[0] = 0;
	
	sprintf(buf, "%c%c%c%c%c%c%c%c%c%c",
			S_ISLNK(mode) ? 'l' :
			S_ISDIR(mode) ? 'd' : '-',
			(S_IRUSR & mode) ? 'r' : '-',
			(S_IWUSR & mode) ? 'w' : '-',
			(S_IXUSR & mode) ? 'x' : '-',
			(S_IRGRP & mode) ? 'r' : '-',
			(S_IWGRP & mode) ? 'w' : '-',
			(S_IXGRP & mode) ? 'x' : '-',
			(S_IROTH & mode) ? 'r' : '-',
			(S_IWOTH & mode) ? 'w' : '-',
			(S_IXOTH & mode) ? 'x' : '-');

	if (S_ISUID & mode)
		buf[3] = (buf[3] == 'x')?'s':'S';
	if (S_ISGID & mode)
		buf[6] = (buf[6] == 'x')?'s':'S';
	if (S_ISVTX & mode)
		buf[9] = (buf[9] == 'x')?'t':'T';

	if (buf[0] != 0)
	{
		ret = (char *) calloc(strlen(buf) + 1, sizeof(char));
		if (ret)
		{
			strcpy(ret, buf);
			ret[strlen(ret) - 1] = '\0';
			return ret;
		}
		else
			return NULL;
	}
	else
		return NULL;
}


char * get_human_readable_owner(uid_t uid, char * ext_buf)
{
	char * ret_str;

	struct passwd pswd;
	struct passwd *result;
	char *buf;
	size_t bufsize;
	int s;


	bufsize = sysconf(_SC_GETPW_R_SIZE_MAX);
	if (bufsize == -1)          /* Value was indeterminate */
		bufsize = 16384;        /* Should be more than enough */

	buf = malloc(bufsize);

	if (buf == NULL) 
		return NULL;

	s = getpwuid_r(uid, &pswd, buf, bufsize, &result);

		
	if (result != NULL)
	{
		if (!ext_buf)
		{
			ret_str = calloc(strlen(pswd.pw_name) + 1, sizeof(char));
			if (ret_str)
			{
				sprintf(ret_str, "%s", pswd.pw_name);
				free(buf);
				return ret_str;
			}
			else
			{
				free(buf);
				return NULL;
			}
		}
		else
		{
				sprintf(ext_buf, "%s", pswd.pw_name);
				free(buf);
				return ext_buf;
		}
	}
	else
	{
		if (!ext_buf)
		{
			ret_str = calloc(128, sizeof(char));
			if (ret_str)
			{
				sprintf(ret_str, "Owner's UID %d", uid);
				free(buf);
				return ret_str;
			}
			else
			{
				free(buf);
				return NULL;
			}
		}
		else
		{
			sprintf(ext_buf, "Owner's UID %d", uid);
			free(buf);
			return ext_buf;
		}	
	}

/*	struct passwd * pswd;
	char * ret_str;

	pswd = getpwuid(uid);

	if (pswd != NULL)
	{
		if (!ext_buf)
		{
			ret_str = calloc(strlen(pswd->pw_name) + 1, sizeof(char));
			if (ret_str)
			{
				sprintf(ret_str, "%s", pswd->pw_name);
				return ret_str;
			}
			else
				return NULL;
		}
		else
		{
				sprintf(ext_buf, "%s", pswd->pw_name);
				return ext_buf;
		}
	}
	else
	{
		if (!ext_buf)
		{
			ret_str = calloc(128, sizeof(char));
			if (ret_str)
			{
				sprintf(ret_str, "Owner's UID %d", uid);
				return ret_str;
			}
			else
				return NULL;
		}
		else
		{
			sprintf(ext_buf, "Owner's UID %d", uid);
			return ext_buf;
		}	
	}
*/	
}

char * get_human_readable_ownergr(gid_t gid, char * ext_buf)
{
	char * ret_str;

	struct group grp;
	struct group *result;
	char *buf;
	size_t bufsize;
	int s;


	bufsize = sysconf(_SC_GETGR_R_SIZE_MAX);
	if (bufsize == -1)          /* Value was indeterminate */
		bufsize = 16384;        /* Should be more than enough */

	buf = malloc(bufsize);

	if (buf == NULL) 
		return NULL;

	s = getgrgid_r(gid, &grp, buf, bufsize, &result);

		
	if (result != NULL)
	{
		if (!ext_buf)
		{
			ret_str = calloc(strlen(grp.gr_name) + 1, sizeof(char));
			if (ret_str)
			{
				sprintf(ret_str, "%s", grp.gr_name);
				free(buf);
				return ret_str;
			}
			else
			{
				free(buf);
				return NULL;
			}
		}
		else
		{
				sprintf(ext_buf, "%s", grp.gr_name);
				free(buf);
				return ext_buf;
		}
	}
	else
	{
		if (!ext_buf)
		{
			ret_str = calloc(128, sizeof(char));
			if (ret_str)
			{
				sprintf(ret_str, "Owner's GID %d", gid);
				free(buf);
				return ret_str;
			}
			else
			{
				free(buf);
				return NULL;
			}
		}
		else
		{
			sprintf(ext_buf, "Owner's GID %d", gid);
			free(buf);
			return ext_buf;
		}	
	}

}


char * get_human_readable_time(time_t * tm, char * ext_buf)
{
	char buf[1024];
	char *ret;

	buf[0] = 0;
	
	if (ext_buf)
	{
		ret = ctime_r(tm, ext_buf);
		ret[strlen(ret) - 1] = '\0';
		return ret;
	}
		
	ctime_r(tm, buf);
	if (buf[0] != 0)
	{
		ret = (char *) calloc(strlen(buf) + 1, sizeof(char));
		if (ret)
		{
			strcpy(ret, buf);
			ret[strlen(ret) - 1] = '\0';
			return ret;
		}
		else
			return NULL;
	}
	else
		return NULL;
}

char * get_human_readable_size(off_t size, char * ext_buf, int long_form)
{
	long long k, m, g, n;
	char buf[1024];
	char *ret;

	buf[0] = 0;
	
	
	if (!ext_buf && (128 + strlen(resdata.KBytesNameString) + strlen(resdata.BytesNameString) > 1024))
	{
		sprintf(buf, "%ld bytes", size);
		ret = calloc(strlen(buf) + 1, sizeof(char));
		if (ret)
		{
			strcpy(ret, buf);
			return ret;
		}
		else
			return NULL;
	}

	k = size / 1024;
	if (k == 0)
	{
		if (ext_buf)
		{
			sprintf(ext_buf, "%ld %s", size, resdata.BytesNameString);
			return ext_buf;
		}
		
		sprintf(buf, "%ld %s", size, resdata.BytesNameString);
		ret = calloc(strlen(buf) + 1, sizeof(char));
		if (ret)
		{
			strcpy(ret, buf);
			return ret;
		}
		else
			return NULL;
	}
	else
	{
		m = size / (1024 * 1024);
		if (m == 0)
		{
			n = size % 1024;
			n = n / 100;
			if (long_form)
			{
				if (ext_buf)
				{
					sprintf(ext_buf, "%lld.%lld %s (%ld %s)", k, n, resdata.KBytesNameString, size, resdata.BytesNameString);
					return ext_buf;
				}
				sprintf(buf, "%lld.%lld %s (%ld %s)", k, n, resdata.KBytesNameString, size, resdata.BytesNameString);
			}
			else
			{
				if (ext_buf)
				{
					sprintf(ext_buf, "%lld.%lld %s", k, n, resdata.KBytesNameString);
					return ext_buf;
				}
				sprintf(buf, "%lld.%lld %s", k, n, resdata.KBytesNameString);
			}
			ret = calloc(strlen(buf) + 1, sizeof(char));
			if (ret)
			{
				strcpy(ret, buf);
				return ret;
			}
			else
				return NULL;
		}
		else
		{
			g = size / (1024 * 1024 * 1024);
			if (g == 0)
			{
				n = size % (1024 * 1024);
				n = n/(100 * 1024);
				if (long_form)
				{
					if (ext_buf)
					{
						sprintf(ext_buf, "%lld.%lld %s (%ld %s)", m, n, resdata.MBytesNameString, size, resdata.BytesNameString);
						return ext_buf;
					}
					sprintf(buf, "%lld.%lld %s (%ld %s)", m, n, resdata.MBytesNameString, size, resdata.BytesNameString);
				}
				else
				{
					if (ext_buf)
					{
						sprintf(ext_buf, "%lld.%lld %s", m, n, resdata.MBytesNameString);
						return ext_buf;
					}
					sprintf(buf, "%lld.%lld %s", m, n, resdata.MBytesNameString);
				}
				ret = calloc(strlen(buf) + 1, sizeof(char));
				if (ret)
				{
					strcpy(ret, buf);
					return ret;
				}
				else
					return NULL;
			}
			else
			{
				n = size % (1024 * 1024 * 1024);
				n = n/(100 * 1024 * 1024);
				if (long_form)
				{
					if (ext_buf)
					{
						sprintf(ext_buf, "%lld.%lld %s (%ld %s)", g, n, resdata.GBytesNameString, size, resdata.BytesNameString);
						return ext_buf;
					}
					sprintf(buf, "%lld.%lld %s (%ld %s)", g, n, resdata.GBytesNameString, size, resdata.BytesNameString);
				}
				else
				{
					if (ext_buf)
					{
						sprintf(ext_buf, "%lld.%lld %s", g, n, resdata.GBytesNameString);
						return ext_buf;
					}
					sprintf(buf, "%lld.%lld %s", g, n, resdata.GBytesNameString);
				}
				ret = calloc(strlen(buf) + 1, sizeof(char));
				if (ret)
				{
					strcpy(ret, buf);
					return ret;
				}
				else
					return NULL;
			}
		}
	}
	return NULL;
}
