#include <stdlib.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/SelectioB.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>
#include <Xm/BulletinB.h>
#include <Xm/MessageB.h>
#include <Xm/Notebook.h>

#include "core.h"
#include "smbconfig.h"
#include "smbfield.h"
/*#include "errormsg.h"*/
#include "defines.h"

//extern Widget top_level;
extern struct smb_share smb_tmp_dir, *smb_all_shares;
extern int smb_is_running, tmp_is_shared, smb_n_shares;

/* These widgets hold data for new share. */
Widget smb_new_share_name, smb_new_comment, smb_new_path, smb_new_valid_users,
       smb_new_write_list, smb_new_printer, smb_new_browseable,
       smb_new_bpublic, smb_new_writable, smb_new_printable, smb_new_read_only,
       smb_new_create_mode;
/* This is the list widget for SMB_list_shares(). */
Widget list_list;

Boolean SMB_is_shared(char *fn) {
  int x;
  
  if ((strcmp(fn, "/tmp") == 0) && tmp_is_shared)
    return True;
  for (x=0; x<smb_n_shares; x++)
    if (strncmp(fn,smb_all_shares[x].path,strlen(smb_all_shares[x].path)-1)==0)
      return True;
  return False;
}

void local_add_CB(Widget w, XtPointer client_data, XtPointer call_data)
{
  int entry_n = 0;

  /* Allocate new entry and read the data from the widgets */
  smb_n_shares++;
  smb_all_shares = realloc(smb_all_shares, 
			   sizeof(struct smb_share) * smb_n_shares);
  entry_n = smb_n_shares-1;
  smb_all_shares[entry_n].share_name = malloc(sizeof(char) * 20);
  XtVaGetValues(smb_new_share_name, XmNvalue, 
		&smb_all_shares[entry_n].share_name, NULL);
  smb_all_shares[entry_n].comment = malloc(sizeof(char) * 40);
  XtVaGetValues(smb_new_comment, XmNvalue, 
		&smb_all_shares[entry_n].comment, NULL);
  strcat(smb_all_shares[entry_n].comment, "\n");
  smb_all_shares[entry_n].path = malloc(sizeof(char) * 90);
  XtVaGetValues(smb_new_path, XmNvalue, &smb_all_shares[entry_n].path, NULL);
  strcat(smb_all_shares[entry_n].path, "\n");
  smb_all_shares[entry_n].valid_users = malloc(sizeof(char) * 40);
  XtVaGetValues(smb_new_valid_users, XmNvalue, 
		&smb_all_shares[entry_n].valid_users, NULL);
  strcat(smb_all_shares[entry_n].valid_users, "\n");
  smb_all_shares[entry_n].write_list = malloc(sizeof(char) * 40);
  XtVaGetValues(smb_new_write_list, XmNvalue, 
		&smb_all_shares[entry_n].write_list, NULL);
  strcat(smb_all_shares[entry_n].write_list, "\n");
  smb_all_shares[entry_n].create_mode = malloc(sizeof(char) * 10);
  smb_all_shares[entry_n].create_mode[0] = '\0';
  /* XtVaGetValues(smb_new_create_mode, XmNvalue, 
		&smb_all_shares[entry_n].create_mode, NULL); */
  XtVaGetValues(smb_new_printer, XmNvalue, 
		&smb_all_shares[entry_n].printer, NULL);
  XtVaGetValues(smb_new_browseable, XmNset, 
		&smb_all_shares[entry_n].browseable, NULL);
  XtVaGetValues(smb_new_bpublic, XmNset, 
		&smb_all_shares[entry_n].bpublic, NULL);
  XtVaGetValues(smb_new_writable, XmNset, 
		&smb_all_shares[entry_n].writable, NULL);
  XtVaGetValues(smb_new_printable, XmNset, 
		&smb_all_shares[entry_n].printable, NULL);
  XtVaGetValues(smb_new_read_only, XmNset, 
		&smb_all_shares[entry_n].read_only, NULL);

  /* Having gotten all the data, destroy the widgets */ 
  XtDestroyWidget((Widget)client_data);
  write_smb_config(1);
}

void local_cancel_CB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XtDestroyWidget((Widget)client_data);
}

void SMB_add_share(char *selected_dir) {
  Widget smb_add_shell, smb_add_bb, smb_add_ok, smb_add_cancel, smb_add_help;
  Widget labelw1, labelw2, labelw3, labelw4, labelw5, labelw6, labelw7,
         labelw8;
  XmString add_label1, add_label2, add_label3, add_label4, add_label5,
           add_label6, add_label7, add_label8, add_label9, add_label10, 
           add_label11, add_label12, add_label13, add_label14;
  /*
  if (!smb_is_running) {
    NoCanDo(SMB_NOT_RUNNING);
    return;
  }
  */
//  smb_add_shell = XtVaCreatePopupShell("SMB_add_share_popup",
//				       vendorShellWidgetClass, top_level,
//				       XmNtitle, "Add New SMB Share",
//				       XmNwidth, 480, XmNheight, 360, NULL);

  smb_add_bb=XtVaCreateManagedWidget("SMB_add_bb", xmBulletinBoardWidgetClass,
				     smb_add_shell, XmNwidth, 480,
				     XmNheight, 360, NULL);
  add_label1 = XmStringCreateSimple("Path:");
  labelw1 = XtVaCreateManagedWidget("labelw1", xmLabelWidgetClass, smb_add_bb,
				    XmNlabelString, add_label1,
				    XmNx, 20, XmNy, 15, NULL);
  smb_new_path = XtVaCreateManagedWidget("smb_add", xmTextFieldWidgetClass,
					 smb_add_bb, XmNx, 120, XmNy, 10,
					 XmNvalue, selected_dir,
					 NULL);
  add_label2 = XmStringCreateSimple("Share name:");
  labelw2 = XtVaCreateManagedWidget("labelw2", xmLabelWidgetClass, smb_add_bb,
				    XmNlabelString, add_label2,
				    XmNx, 20, XmNy, 56, NULL);
  smb_new_share_name = XtVaCreateManagedWidget("smb_add", 
					       xmTextFieldWidgetClass,
					       smb_add_bb, XmNx, 120, XmNy, 
					       50, NULL);
  add_label3 = XmStringCreateSimple("Comment:");
  labelw3 = XtVaCreateManagedWidget("labelw3", xmLabelWidgetClass, smb_add_bb,
				    XmNlabelString, add_label3,
				    XmNx, 20, XmNy, 97, NULL);
  smb_new_comment = XtVaCreateManagedWidget("smb_add", xmTextFieldWidgetClass,
					    smb_add_bb, XmNx, 120, XmNy, 90, 
					    NULL);
  add_label4 = XmStringCreateSimple("Browseable");
  smb_new_browseable = XtVaCreateManagedWidget("browseable", 
					       xmToggleButtonWidgetClass,
					       smb_add_bb, XmNx, 20, XmNy, 125,
					       XmNlabelString, add_label4,
					       NULL);
  add_label5 = XmStringCreateSimple("Public");
  smb_new_bpublic = XtVaCreateManagedWidget("public", 
					    xmToggleButtonWidgetClass,
					    smb_add_bb, XmNx, 180, XmNy, 125,
					    XmNlabelString, add_label5,
					    NULL);
  add_label6 = XmStringCreateSimple("Read only");
  smb_new_read_only = XtVaCreateManagedWidget("read only", 
					       xmToggleButtonWidgetClass,
					       smb_add_bb, XmNx, 20, XmNy, 153,
					       XmNlabelString, add_label6,
					       NULL);
  add_label7 = XmStringCreateSimple("Writable");
  smb_new_writable = XtVaCreateManagedWidget("writable", 
					     xmToggleButtonWidgetClass,
					     smb_add_bb, XmNx, 180, XmNy, 153,
					     XmNlabelString, add_label7,
					     NULL);
  add_label8 = XmStringCreateSimple("Printable");
  smb_new_printable = XtVaCreateManagedWidget("printable", 
					      xmToggleButtonWidgetClass,
					      smb_add_bb, XmNx, 20, XmNy, 185,
					      XmNlabelString, add_label8,
					      NULL);
  add_label9 = XmStringCreateSimple("Printer:");
  labelw4 = XtVaCreateManagedWidget("labelw4", xmLabelWidgetClass, smb_add_bb,
				    XmNlabelString, add_label9,
				    XmNx, 130, XmNy, 189, NULL);
  smb_new_printer = XtVaCreateManagedWidget("smb_add", 
					    xmTextFieldWidgetClass,
					    smb_add_bb, XmNx, 205, 
					    XmNy, 183, NULL);
  add_label10 = XmStringCreateSimple("Valid users:");
  labelw5 = XtVaCreateManagedWidget("labelw4", xmLabelWidgetClass, smb_add_bb,
				    XmNlabelString, add_label10,
				    XmNx, 20, XmNy, 228, NULL);
  smb_new_valid_users = XtVaCreateManagedWidget("smb_add", 
						xmTextFieldWidgetClass,
						smb_add_bb, XmNx, 120, 
						XmNy, 223, NULL);
  add_label11 = XmStringCreateSimple("Write list:");
  labelw6 = XtVaCreateManagedWidget("labelw6", xmLabelWidgetClass, smb_add_bb,
				    XmNlabelString, add_label11,
				    XmNx, 20, XmNy, 268, NULL);
  smb_new_write_list=XtVaCreateManagedWidget("smb_add", 
					     xmTextFieldWidgetClass,
					     smb_add_bb, XmNx, 120,
					     XmNy, 263, NULL);
  add_label12 = XmStringCreateSimple("Add share");
  smb_add_ok = XtVaCreateManagedWidget("smb_add_ok", xmPushButtonWidgetClass,
				       smb_add_bb, XmNx, 20, XmNy, 310,
				       XmNwidth, 120, XmNheight, 30,
				       XmNlabelString, add_label12, NULL);
  XtAddCallback(smb_add_ok, XmNactivateCallback, local_add_CB, 
		(XtPointer)smb_add_shell);
  add_label13 = XmStringCreateSimple("Cancel");
  smb_add_cancel = XtVaCreateManagedWidget("smb_add_cancel", 
					   xmPushButtonWidgetClass,
					   smb_add_bb, XmNx, 180, XmNy, 310,
					   XmNwidth, 120, XmNheight, 30,
					   XmNlabelString, add_label13, NULL);
  XtAddCallback(smb_add_cancel, XmNactivateCallback, local_cancel_CB, 
		(XtPointer)smb_add_shell);
  add_label14 = XmStringCreateSimple("Help");
  smb_add_help = XtVaCreateManagedWidget("smb_add_help", 
					 xmPushButtonWidgetClass,
					 smb_add_bb, XmNx, 340, XmNy, 310,
					 XmNwidth, 120, XmNheight, 30,
					 XmNlabelString, add_label14, NULL);
  XtAddCallback(smb_add_help, XmNactivateCallback, local_cancel_CB, 
		(XtPointer)smb_add_shell);

  XtPopup(smb_add_shell, XtGrabNone);

  XmStringFree(add_label1);
  XmStringFree(add_label2);
  XmStringFree(add_label3);
  XmStringFree(add_label4);
  XmStringFree(add_label5);
  XmStringFree(add_label6);
  XmStringFree(add_label7);
  XmStringFree(add_label8);
  XmStringFree(add_label9);
  XmStringFree(add_label10);
  XmStringFree(add_label11);
  XmStringFree(add_label12);
  XmStringFree(add_label13);
  XmStringFree(add_label14);
}

/* This function removes a share. */
void local_remove_CB(Widget w, XtPointer client_data, XtPointer call_data) {
  int x, *y, z;

  XtDestroyWidget((Widget)client_data);
  XmListGetSelectedPos(list_list, &y, &x);
  z = y[0]-tmp_is_shared-1;
#ifdef DEBUG
  printf("Selected: %d  Shares: %d\n", z, smb_n_shares);
#endif
  if ((y[0] == 1) && (tmp_is_shared == 1)) {
#ifdef DEBUG
    printf("/tmp\n");
#endif
    tmp_is_shared = 0;
    write_smb_config(1);
    return;
  }
  smb_n_shares--;
  if (smb_n_shares == 0) {
#ifdef DEBUG
    printf("No shares\n");
#endif
    write_smb_config(1);
    return;
  }
  if (z == smb_n_shares) {
#ifdef DEBUG
    printf("bottom of list\n");
#endif
    smb_all_shares = realloc(smb_all_shares, sizeof(struct smb_share) *
			     smb_n_shares);
    write_smb_config(1);
    return;
  }
  smb_all_shares[z].share_name = realloc(smb_all_shares[z].share_name, sizeof(char) * strlen(smb_all_shares[smb_n_shares].share_name));
  strcpy(smb_all_shares[z].share_name, smb_all_shares[smb_n_shares].share_name);
  smb_all_shares[z].path = realloc(smb_all_shares[z].path, sizeof(char) * strlen(smb_all_shares[smb_n_shares].path));
  strcpy(smb_all_shares[z].path, smb_all_shares[smb_n_shares].path);
  smb_all_shares[z].comment = realloc(smb_all_shares[z].comment, sizeof(char) * strlen(smb_all_shares[smb_n_shares].comment));
  strcpy(smb_all_shares[z].comment, smb_all_shares[smb_n_shares].comment);
  smb_all_shares[z].printer = realloc(smb_all_shares[z].printer, sizeof(char) * strlen(smb_all_shares[smb_n_shares].printer));
  strcpy(smb_all_shares[z].printer, smb_all_shares[smb_n_shares].printer);
  smb_all_shares[z].valid_users = realloc(smb_all_shares[z].valid_users, sizeof(char) * strlen(smb_all_shares[smb_n_shares].valid_users));
  strcpy(smb_all_shares[z].valid_users, smb_all_shares[smb_n_shares].valid_users);
  smb_all_shares[z].write_list = realloc(smb_all_shares[z].write_list, sizeof(char) * strlen(smb_all_shares[smb_n_shares].write_list));
  strcpy(smb_all_shares[z].write_list, smb_all_shares[smb_n_shares].write_list);
  smb_all_shares[z].create_mode = realloc(smb_all_shares[z].create_mode, sizeof(char) * strlen(smb_all_shares[smb_n_shares].create_mode));
  strcpy(smb_all_shares[z].create_mode, smb_all_shares[smb_n_shares].create_mode);
  smb_all_shares[z].browseable = smb_all_shares[smb_n_shares].browseable;
  smb_all_shares[z].bpublic = smb_all_shares[smb_n_shares].bpublic;
  smb_all_shares[z].printable = smb_all_shares[smb_n_shares].printable;
  smb_all_shares[z].writable = smb_all_shares[smb_n_shares].writable;
  smb_all_shares[z].read_only = smb_all_shares[smb_n_shares].read_only;

  smb_all_shares = realloc(smb_all_shares, 
			   sizeof(struct smb_share) * smb_n_shares);
  write_smb_config(1);
}

/* SMB_list_shares:  List active shares, with option to edit or delete them. */
void SMB_list_shares() {
  Widget list_label, list_shell, list_bb, list_remove, list_cancel;
  XmString list_label_s, list_entry, list_remove_s, list_cancel_s;
  Arg args[10];
  int x;

//  list_shell = XtVaCreatePopupShell("smb_list_shell", vendorShellWidgetClass,
//				    top_level, XmNtitle, 
//				    "List SMB Shares", NULL);
  list_bb = XtVaCreateManagedWidget("smb_list_bb", xmBulletinBoardWidgetClass,
				    list_shell, XmNwidth, 320, XmNheight,
				    240, NULL);
  list_label_s = XmStringCreateSimple("Remove which share?");
  list_label = XtVaCreateManagedWidget("list_label", xmLabelWidgetClass,
				       list_bb, XmNx, 10, XmNy, 1, 
				       XmNlabelString, list_label_s, NULL);
  XtSetArg(args[0], XmNselectionPolicy, XmSINGLE_SELECT);
  XtSetArg(args[1], XmNscrollingPolicy, XmAUTOMATIC);
  XtSetArg(args[2], XmNwidth, 160);
  XtSetArg(args[3], XmNheight, 200);
  XtSetArg(args[4], XmNx, 10);
  XtSetArg(args[5], XmNy, 30);
  list_list = XmCreateScrolledList(list_bb, "smb_list", args, 6);
  XtManageChild(list_list);
  if (tmp_is_shared) {
    list_entry = XmStringCreateSimple("tmp");
    XmListAddItem(list_list, list_entry, 0);
    XmStringFree(list_entry);
  }
  for (x=0; x<smb_n_shares; x++) {
    list_entry = XmStringCreateSimple(smb_all_shares[x].share_name);
    XmListAddItem(list_list, list_entry, 0);
    XmStringFree(list_entry);
  }
  list_remove=XtVaCreateManagedWidget("Remove share", xmPushButtonWidgetClass,
				      list_bb, XmNx, 190, XmNy, 80,
				      XmNwidth, 110, XmNheight, 30, NULL);
  XtAddCallback(list_remove, XmNactivateCallback, local_remove_CB,
		(XtPointer)list_shell);
  list_cancel=XtVaCreateManagedWidget("Cancel", xmPushButtonWidgetClass,
				      list_bb, XmNx, 190, XmNy, 130,
				      XmNwidth, 110, XmNheight, 30, NULL);
  XtAddCallback(list_cancel, XmNactivateCallback, local_cancel_CB, 
		(XtPointer)list_shell);

  XtPopup(list_shell, XtGrabNone);
}
