#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

#include "permission.h"

uid_t your_uid;
gid_t your_gid;







void GetUserInfo(void) {
  your_uid = getuid();
  your_gid = getgid();
}

int IsReadable(struct stat buf) {
  if (your_uid == 0)  /* root can read anything, right? */
    return 1;
  if ((your_uid == buf.st_uid) && (buf.st_mode & S_IRUSR))
    return 1;  
  if ((your_gid == buf.st_gid) && (buf.st_mode & S_IRGRP))
    return 1;
  if (buf.st_mode & S_IROTH)
    return 1;

  return 0;
}

int IsWritable(struct stat buf) {
  if (your_uid == 0)  /* root can write anything, right? */
    return 1;
  if ((your_uid == buf.st_uid) && (buf.st_mode & S_IWUSR))
    return 1;  
  if ((your_gid == buf.st_gid) && (buf.st_mode & S_IWGRP))
    return 1;
  if (buf.st_mode & S_IWOTH)
    return 1;

  return 0;
}

int IsExecutable(struct stat buf) {
  if (!IsReadable(buf))  /* Assumption:  you must be able to read it, too */
    return 0;
  if (your_uid == 0)  /* root can execute anything, right? */
    return 1;
  if ((your_uid == buf.st_uid) && (buf.st_mode & S_IXUSR))
    return 1;  
  if ((your_gid == buf.st_gid) && (buf.st_mode & S_IXGRP))
    return 1;
  if (buf.st_mode & S_IXOTH)
    return 1;

  return 0;
}

/*-----------------------------------------------------------------------------
  Check permission for an operation, equivalent to UNIX access()
-----------------------------------------------------------------------------*/

/* From moxfm*/


int permission(struct stat *stats, int perms)
{
  int mode = stats->st_mode;
  int result = 0;
	GetUserInfo();
  if (your_uid == 0 || your_uid == stats->st_uid) {
    if (mode & S_IRUSR)
      result |= P_READ;
    if (mode & S_IWUSR)
      result |= P_WRITE;
    if (mode & S_IXUSR)
      result |= P_EXECUTE;
  } 

  else if (your_uid == 0 || your_gid == stats->st_gid) {
    if (mode & S_IRGRP)
      result |= P_READ;
    if (mode & S_IWGRP)
      result |= P_WRITE;
    if (mode & S_IXGRP)
      result |= P_EXECUTE;
  } 

  else {
    if (mode & S_IROTH)
      result |= P_READ;
    if (mode & S_IWOTH)
      result |= P_WRITE;
    if (mode & S_IXOTH)
      result |= P_EXECUTE;
  } 

  return (result & perms) == perms;
}

