#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>

#include <Xm/Xm.h>
#include <Xm/TextF.h>

#include "core.h"
/*#include "errormsg.h"*/
#include "getdir.h"
#include "defines.h"
#include "filearea.h"
#include "permission.h"
//#include "openfile.h"



#include "XmNl/XmNl.h"
#include "XmNl/XmNlList.h"

//#define DEBUG 1

//#include "XmItemBox.h"

extern Widget fm_container, fm_textfield;
extern char current_wd[120];
extern char * terminal_command;

#define SKIP_SPACES(p) { for (; *p != 0 && isspace((int) *p); p++); }
#define CHECK_IS_DIR_LNK(mode) 	((mode & S_IFMT) == (S_IFDIR | S_IFLNK))


void go_to_dir(IfaceBranche * IbPtr, const char * name)
{
	struct stat buf;

#ifdef USE_INOTIFY
//	if (IbPtr->i_fd != -1 && IbPtr->i_wd != -1)
//		inotify_rm_watch(IbPtr->i_fd, IbPtr->i_wd);
		
	PutWatchCommand(IbPtr, COMMAND_DEL_WATCH);
#endif

	if ((stat(name, &buf)) != 0) 
	{
		NoCanDo(DIR_NOT_EXIST, IbPtr);
		return;
	}
	if (S_ISDIR(buf.st_mode)) 
	{
		if (IsReadable(buf) && IsExecutable(buf)) 
		{
#ifdef DEBUG
			printf("opening directory...\n");
#endif
//			load_dir(IbPtr, name);
			if (IbPtr->current_wd)
				free(IbPtr->current_wd);
				
			IbPtr->current_wd = strdup(name);
#ifdef DEBUG
			printf("drawing directory...\n");
#endif
			DrawFileArea(IbPtr);
			XtVaSetValues(IbPtr->fm_textfield, XmNvalue, IbPtr->current_wd, NULL);
			XtVaSetValues(IbPtr->top_level, XmNtitle, IbPtr->current_wd, NULL);
		}
		else
			NoCanDo(CANT_READ_DIR, IbPtr, NULL, NULL);
		return;
	}
}


void default_action(IfaceBranche * IbPtr, char * name)
{
	struct stat buf;
	char * exec_this;

	if ((stat(name, &buf)) != 0) 
	{
		NoCanDo(DIR_NOT_EXIST, IbPtr, NULL, NULL);
		return;
	}

	if (IsExecutable(buf)) 
	{
		exec_this = calloc(strlen(name) + 10, sizeof(char));
		if (exec_this) 
		{
			sprintf(exec_this, "%s &", name);
#ifdef DEBUG
			printf("Exec %s\n", exec_this);
#endif
//			system(exec_this);
			free((void *) exec_this);
			return;
		}
	}
	if (buf.st_mode & 73) 
	{
		NoCanDo(CANT_EXECUTE, IbPtr, NULL, NULL);
		return;
	}
}


void exec_in_xterm_action(char * name)
{
	char ** argv;
	char * p1, * p2, * filename;
	int l, index, segment_l, allocated = 10;
	char * tmp;
	pid_t child;
	int ret;

#ifdef DEBUG
	printf("!!!!!!exec_in_xterm_action:%s\n", name);
#endif


	if (!(child = fork()))
	{
/* In children */
		argv = calloc(allocated, sizeof(char *));

		l = strlen(terminal_command);

		p1 = terminal_command;
		p2 = NULL;

		index = 0;
			
		while ((p2 = strchr(p1, ' ')) != NULL)
		{
			segment_l = p2 - p1;

			tmp = calloc(segment_l + 1, sizeof(char));
			strncpy(tmp, p1, segment_l);
			argv[index] = tmp;
			if (index == 0)
				filename = tmp;

			index++;
			if (index >= allocated)
			{
				allocated+=5;
				argv = realloc(argv, allocated * sizeof(char *));
			}
			p1 = p2 + 1;
			
			if ((p1 - terminal_command) == (l - 1))
				break ;
			SKIP_SPACES(p1);
			if ((p1 - terminal_command) == (l - 1))
				break ;
		}

		if ((p1 - terminal_command) < (l - 1))
		{
			tmp = calloc(terminal_command + l - p1 + 1, sizeof(char));
			strncpy(tmp, p1, terminal_command + l - p1);
			argv[index] = tmp;
			if (index == 0)
					filename = tmp;

			index++;
			if (index >= allocated)
			{
				allocated+=10;
				argv = realloc(argv, allocated * sizeof(char *));
			}
		}


		tmp = calloc(strlen(name) + 1, sizeof(char));
		strcpy(tmp, name);
		argv[index] = tmp;

		index++;

		if (index >= allocated)
		{
			allocated++;
			argv = realloc(argv, allocated * sizeof(char *));
		}

		argv[index] = NULL;

#ifdef DEBUG
		for (index = 0; argv[index] != NULL; index++)
		{
			printf("%s\n", argv[index]);
		}
#endif

		ret = execvp("xterm", argv);
		if (ret < 0) 
			exit(0);
	}
}

void exec_xterm_action(	IfaceBranche * IbPtr)
{
	char ** argv;
	char * p1, * p2, * filename;
	int l, index, segment_l, allocated = 10;
	char * tmp;
	pid_t child;
	int ret;

	if (!(child = fork()))
	{
/* In children */
		chdir(IbPtr->current_wd);
		argv = calloc(allocated, sizeof(char *));

		l = strlen(terminal_command);

		p1 = terminal_command;
		p2 = NULL;

		index = 0;
			
		while ((p2 = strchr(p1, ' ')) != NULL)
		{
			segment_l = p2 - p1;

			tmp = calloc(segment_l + 1, sizeof(char));
			strncpy(tmp, p1, segment_l);
			argv[index] = tmp;
			if (index == 0)
				filename = tmp;

			index++;
			if (index >= allocated)
			{
				allocated+=5;
				argv = realloc(argv, allocated * sizeof(char *));
			}
			p1 = p2 + 1;
			
			if ((p1 - terminal_command) == (l - 1))
				break ;
			SKIP_SPACES(p1);
			if ((p1 - terminal_command) == (l - 1))
				break ;
		}

		if ((p1 - terminal_command) < (l - 1))
		{
			tmp = calloc(terminal_command + l - p1 + 1, sizeof(char));
			strncpy(tmp, p1, terminal_command + l - p1);
			argv[index] = tmp;
			if (index == 0)
					filename = tmp;

			index++;
			if (index >= allocated)
			{
				allocated+=10;
				argv = realloc(argv, allocated * sizeof(char *));
			}
		}

		argv[index] = NULL;

#ifdef DEBUG
		for (index = 0; argv[index] != NULL; index++)
		{
			printf("%s\n", argv[index]);
		}
#endif

		ret = execvp("xterm", argv);
		if (ret < 0) 
			exit(0);
	}
}


void exec_action(char * name, char * action)
{
	char tmp_name[4096];
	char * full_string;
	int ret;
	
	if (strstr(action, "\%s"))
	{
		full_string = calloc(strlen(name) + strlen(action) + 7, sizeof(char));
		if (full_string)
		{
			sprintf(tmp_name, "\'%s\'", name);
			sprintf(full_string, action, tmp_name);
			strcat(full_string, " &");
#ifdef DEBUG
			printf("Exec %s\n", full_string);
#endif
			ret = system(full_string);
			free(full_string);
		}
	}
	else
	{
		full_string = calloc(strlen(name) + strlen(action) + 7, sizeof(char));
		if (full_string)
		{
			sprintf(tmp_name, "\'%s\'", name);
			sprintf(full_string, "%s %s &", action, tmp_name);
#ifdef DEBUG
			printf("Exec %s\n", full_string);
#endif
			ret = system(full_string);
			free(full_string);
		}
	}
}

/* Open file triggered by double-click or activate in text field. */
void fm_openitem(Widget w, XtPointer client_data, XtPointer call_data)
{
	char *work_dir;
	IfaceBranche * IbPtr;
	char * exec_this, *mptr;
	char * full_name, * parent;
	WidgetList sel_wid;
	int sel_wid_count, t1;
	struct stat buf;
	struct filedata * file_ptr = NULL;

	ItemActivateReturnStruct *data;
  

	XtVaGetValues(w, XmNuserData, &IbPtr, NULL);
#ifdef DEBUG
	printf("fm_openitem: %s\n", IbPtr->current_wd);
#endif

	if (!IbPtr->load_dir_joined)
	{
		return ;
	}

	if ((int)client_data == 10 || (int)client_data == 11) 
	{
		mptr = XmTextFieldGetString(IbPtr->fm_textfield);
		full_name = calloc(strlen(mptr) + 1, sizeof(char));
		if (full_name) 
		{
			strcpy(full_name, mptr);
			go_to_dir(IbPtr, full_name);
			free((void *)full_name);
		}
		XtFree(mptr);
		return ;
	}
	else
	{
		data = (ItemActivateReturnStruct *)call_data;
		file_ptr = (struct filedata *) data->pointer;
#ifdef DEBUG
		printf("fm_open file:%s\n", file_ptr->name);    
#endif
		if (strcmp(file_ptr->name, ".") == 0)
			return;
		if (strcmp(file_ptr->name, "..") == 0)
		{
			parent = getparent(IbPtr);
			full_name = calloc(strlen(parent) + 1, sizeof(char));
			sprintf(full_name, "%s", parent);
			if (parent) free(parent);
		}
		else
			if (strcmp(IbPtr->current_wd, "/"))
			{
				full_name = calloc(strlen(IbPtr->current_wd) + 3 + strlen(file_ptr->name), sizeof(char));
				sprintf(full_name, "%s/%s", IbPtr->current_wd, file_ptr->name);
			}
			else
			{
				full_name = calloc(3 + strlen(file_ptr->name), sizeof(char));
				sprintf(full_name, "/%s", file_ptr->name);
			}
	}

	     
#ifdef DEBUG
	printf("Full name: %s\n", full_name);
#endif
	if(file_ptr->magic)
	{
#ifdef DEBUG
		printf("fm_openitem: magic found\n");
#endif
		if (file_ptr->magic->action)
		{
#ifdef DEBUG
			printf("fm_openitem: magic action found %p\n", file_ptr->magic->action);
#endif
			exec_action(full_name, file_ptr->magic->action);
//				exec_this = calloc(strlen(full_name) + 10 + strlen(file_ptr->magic->action), sizeof(char));
//				if (exec_this)
//				{
//					sprintf(exec_this, "%s %s &", file_ptr->magic->action, full_name);
//					printf("Exec %s\n", exec_this);
//					system(exec_this);
//					free((void *)exec_this);
//				}
//				free((void *) full_name);
				return;
		}
	}

	if (S_ISDIR(file_ptr->filetype) || CHECK_IS_DIR_LNK(file_ptr->filetype)) 
	{
		go_to_dir(IbPtr, full_name);
	}
	else 
		default_action(IbPtr, full_name);

	free((void *) full_name);
	return ;
}
