#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/SelectioB.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>
#include <Xm/BulletinB.h>
#include <Xm/MessageB.h>
#include <Xm/Notebook.h>

#include <stdio.h>

//extern Widget top_level;

Boolean nfs_is_running;

/* Check for the presence of NFS by looking for a lock file.  This expects
 * to find /var/lock/subsys, which is a RedHat-ism to the best of my
 * knowledge.  The provided scripts will work properly if you don't have
 * RedHat but do create /var/lock/subsys.  The global variable nfs_is_running
 * holds the state in convenient Boolean type */
void scan_for_nfs() {
  FILE *testf;

  testf = fopen("/var/lock/subsys/nfs","r");
  if (testf != NULL)
    nfs_is_running = True;
  else
    nfs_is_running = False;
  fclose(testf);
}

Widget nfs_shell, nfs_t1;

/* Toggle the state of the NFS server if needed and close the config window. */
void nfs_generalCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  Boolean temp1;

  XtDestroyWidget(nfs_shell);

  if ((int)client_data == 1)
    return;
  XtVaGetValues(nfs_t1, XmNset, &temp1, NULL);
  if (temp1 != nfs_is_running) {
    switch (temp1) {
    case True:
      system("/etc/rc.d/init.d/nfs start");
      break;
    case False:
      system("/etc/rc.d/init.d/nfs stop");
      break;
    }
    nfs_is_running = temp1;
  }
}

/* Configure the NFS server.  That is, enable or disable it.  Still have to
 * do /etc/exports by hand. */
void nfs_server_config()
{
  Widget nfs_form, nfs_rc, nfs_t2, nfs_ok, nfs_cancel, nfs_help;

  /* Probably ought to do this in main() so other functions have this info. */
  scan_for_nfs();

//  nfs_shell = XtVaCreatePopupShell("NFS_server_config_popup",
//				   vendorShellWidgetClass, top_level,
//				   XmNtitle, "Configure NFS Server", NULL);
  nfs_form = XtVaCreateManagedWidget("NFS_form", xmFormWidgetClass, nfs_shell,
				     XmNwidth, 240, NULL);
  nfs_rc = XtVaCreateManagedWidget("NFS_rc", xmRowColumnWidgetClass, nfs_form,
				   XmNorientation, XmVERTICAL,
				   XmNradioBehavior, True,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_FORM,
				   NULL);				   
  nfs_t1 = XtVaCreateManagedWidget("Enable NFS server", 
				   xmToggleButtonWidgetClass, nfs_rc,
				   XmNset, nfs_is_running, NULL);
  nfs_t2 = XtVaCreateManagedWidget("Disable NFS server", 
				   xmToggleButtonWidgetClass, nfs_rc,
				   XmNset, !nfs_is_running, NULL);
  nfs_ok = XtVaCreateManagedWidget("OK", xmPushButtonWidgetClass, nfs_form,
				   XmNwidth, 80,
				   XmNtopAttachment, XmATTACH_WIDGET,
				   XmNtopWidget, nfs_rc,
				   XmNleftAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM, NULL);
  nfs_cancel = XtVaCreateManagedWidget("Cancel", xmPushButtonWidgetClass, 
				       nfs_form, XmNwidth, 80,
				       XmNtopAttachment, XmATTACH_WIDGET,
				       XmNtopWidget, nfs_rc,
				       XmNleftAttachment, XmATTACH_WIDGET,
				       XmNleftWidget, nfs_ok,
				       XmNbottomAttachment, XmATTACH_FORM, 
				       NULL);
  nfs_help = XtVaCreateManagedWidget("Help", xmPushButtonWidgetClass, 
				     nfs_form,
				     XmNtopAttachment, XmATTACH_WIDGET,
				     XmNtopWidget, nfs_rc,
				     XmNleftAttachment, XmATTACH_WIDGET,
				     XmNleftWidget, nfs_cancel,
				     XmNrightAttachment, XmATTACH_FORM,
				     XmNbottomAttachment, XmATTACH_FORM, 
				     NULL);
  XtAddCallback(nfs_ok, XmNactivateCallback, nfs_generalCB, 
		(XtPointer)0);
  XtAddCallback(nfs_cancel, XmNactivateCallback, nfs_generalCB, 
		(XtPointer)1);

  XtPopup(nfs_shell, XtGrabNone);
}
