#include <sys/stat.h>
#include <sys/types.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#include <Xm/Xm.h>
#include <Xm/ToggleB.h>
#include <Xm/SelectioB.h>

#include "XmNl/XmNl.h"
#include "XmNl/XmNlList.h"

#include "defines.h"
#include "core.h"
#include "dircmd.h"
#include "getinfo.h"
#include "filecmd.h"
#include "findfile.h"
#include "helpsys.h"
#include "nfs.h"
#include "smbconfig.h"
#include "smbshare.h"
#include "getdir.h"
#include "filearea.h"
#include "errormsg.h"
#include "utils.h"

//#define DEBUG 1

//extern Widget fm_container, fm_scroll1;
//extern Widget large_bt, small_bt, detail_bt;
//extern char current_wd[120];
//extern int CurrentViewType;
//extern XtAppContext app;

/**** Switch: copy to current or selected dir ****/
extern int _CopyToCurrentDir;
extern int _CopyToSelectedDir;


extern int iface_thread_counter;

//extern void CleanIconsSet1(IfaceBranche *);
extern void CleanIconsSet2(IfaceBranche *);
extern void RenameFileDialog(IfaceBranche * IbPtr, char * name);
extern void SymlinkFileDialog(IfaceBranche * IbPtr, char * name);

extern void *NewIfaceWindowThread(void * arg);
extern IfaceBranche * StartNewIfaceBranche(const char * start_here);
extern pthread_mutex_t iface_mutex;

void select_by_pattern_func(IfaceBranche * IbPtr);

/********************************/
/** listtype 1 copy *************/
/** listtype 2 cut  *************/
/** listtype 3 delete ***********/
/********************************/

char * MakeSelectList(int listtype, IfaceBranche * IbPtr)
{
	XmNlCell SelectedCells;
	char * ListString = NULL;
	int i, item_num, item_count, *numbers;
	struct filedata * file_ptr = NULL;
	Boolean ok;

	item_num = 0;
	XtVaGetValues(IbPtr->fm_scroll_win, XmNselectedPositionCount, &item_num, XmNselectedPositions, &numbers, NULL);
		

#ifdef DEBUG
printf("MakeSelectList: selected %d current wd = %s\n", item_num, IbPtr->current_wd);
#endif

	if (item_num == 0) return NULL;
	
	if (listtype == 1) 
	{
		ListString = (char *) calloc(strlen("copy\n") + 1, sizeof(char));
		sprintf(ListString, "%s", "copy\n");
	}
	else 
		if (listtype == 2)
		{
			ListString = (char *) calloc(strlen("cut\n") + 1, sizeof(char));
			sprintf(ListString, "%s", "cut\n");
		}
		else
			if (listtype == 3) ListString = NULL;
			else return NULL;
			
	for (i=0; i<item_num; i++ )
	{
		ok = XmNlListGetItem(IbPtr->fm_scroll_win, &SelectedCells, CellUserData, numbers[i]);
		if (ok)
		{
#ifdef DEBUG
			printf("Item %d\n", numbers[i]);
#endif
			file_ptr = (struct filedata *) SelectedCells.UserDataPointer;
			if ((0==strcmp(file_ptr->name, "..")) || (0==strcmp(file_ptr->name, ".")))
					continue;

			if (listtype < 3)
			{
				ListString = realloc(ListString, strlen(ListString) + strlen("file://") + strlen(IbPtr->current_wd) 
											+ 4 + strlen(file_ptr->name));
				strcat(ListString, "file://");
				strcat(ListString, IbPtr->current_wd);
				strcat(ListString, "/");
				strcat(ListString, file_ptr->name);
			}
			else
			{
				if (ListString) ListString = realloc(ListString, strlen(ListString) + strlen(IbPtr->current_wd) 
											+ 4 + strlen(file_ptr->name));
				else ListString = calloc(strlen(IbPtr->current_wd) + 4 
													+ strlen(file_ptr->name), sizeof(char));
				strcat(ListString, IbPtr->current_wd);
				strcat(ListString, "/");
				strcat(ListString, file_ptr->name);
			}
			if (i+1 < item_num) strcat(ListString, "\n");
		}

#ifdef DEBUG
			printf("........bxfm selected: %s\n", file_ptr->name);
#endif
		item_count++;
	}
	return ListString;
}

/*
char * GetSelectedItem(IfaceBranche * IbPtr)
{
	XmNlCell SelectedCells;
	char * returnedString = NULL;
	int item_num, item_count, *numbers;
	struct filedata * file_ptr = NULL;
	Boolean ok;

	item_num = 0;
	XtVaGetValues(IbPtr->fm_scroll_win, XmNselectedItemCount, &item_num, XmNselectedPositions, &numbers, NULL);
		

#ifdef DEBUG
	printf("GetSelectedItem: selected %d current wd = %s\n", item_num, IbPtr->current_wd);
#endif

	if (item_num != 0) 
		return NULL;
	
			
	ok = XmNlListGetItem(IbPtr->fm_scroll_win, &SelectedCells, CellUserData, numbers[0]);
	if (ok)
	{
#ifdef DEBUG
		printf("Item %d\n", numbers[0]);
#endif
		file_ptr = (struct filedata *) SelectedCells.UserDataPointer;
		if ((0 == strcmp(file_ptr->name, "..")) || (0 == strcmp(file_ptr->name, ".")))
			return NULL;

		returnedString = calloc(strlen(file_ptr->name) + 1, sizeof(char));
		strcpy(returnedString, file_ptr->name);


#ifdef DEBUG
		printf("........bxfm selected: %s\n", file_ptr->name);
#endif
	}
	return returnedString;
}
*/


/*
char * MakeSampleSelectList(int listtype, IfaceBranche * IbPtr)
{
	XmNlCell SelectedCells;
	char * ListString = NULL;
	int i, item_num, item_count, *numbers;
	struct filedata * file_ptr = NULL;
	Boolean ok;

	item_num = 0;
	XtVaGetValues(IbPtr->fm_scroll_win, XmNselectedItemCount, &item_num, XmNselectedPositions, &numbers, NULL);
		

#ifdef DEBUG
	printf("MakeSelectList: selected %d current wd = %s\n", item_num, IbPtr->current_wd);
#endif

	if (item_num == 0) return NULL;
	
			
	for (i=0; i<item_num; i++ )
	{
		ok = XmNlListGetItem(IbPtr->fm_scroll_win, &SelectedCells, CellUserData, numbers[i]);
		if (ok)
		{
#ifdef DEBUG
			printf("Item %d\n", numbers[i]);
#endif
			file_ptr = (struct filedata *) SelectedCells.UserDataPointer;
			if ((0==strcmp(file_ptr->name, "..")) || (0==strcmp(file_ptr->name, ".")))
					continue;

				if (ListString) ListString = realloc(ListString, strlen(ListString) + strlen(IbPtr->current_wd) 
											+ 4 + strlen(file_ptr->name));
				else ListString = calloc(strlen(IbPtr->current_wd) + 4 
													+ strlen(file_ptr->name), sizeof(char));
				strcat(ListString, IbPtr->current_wd);
				strcat(ListString, "/");
				strcat(ListString, file_ptr->name);
				strcat(ListString, "\n");
		}

#ifdef DEBUG
			printf("........bxfm selected: %s\n", file_ptr->name);
#endif
		item_count++;
	}
	return ListString;
}
*/


void ExitFromApp(IfaceBranche * IbPtr)
{
	IfaceBranche * ptr;
	int found_copy_move_thread = 0;
	

	pthread_mutex_lock(&iface_mutex);
	ptr = AllIfaceBranches;
	while (ptr)
	{
		if (ptr->copy_move_thread_count)
		{
			found_copy_move_thread = 1;
			break;
		}
		ptr = ptr->next_branche;
	}
	pthread_mutex_unlock(&iface_mutex);


	if (found_copy_move_thread)
	{
		if (ptr)
			ConfirmCloseDialog(ptr);
		return ;
	}
	

	pthread_mutex_lock(&iface_mutex);
	ptr = AllIfaceBranches;
	while (ptr)
	{
		if (ptr->DialPixLarge > XmUNSPECIFIED_PIXMAP)
		{
			XFreePixmap(XtDisplay(ptr->top_level), ptr->DialPixLarge);
			ptr->DialPixLarge = XmUNSPECIFIED_PIXMAP;
		}
			
		if (ptr->DialPixSmall > XmUNSPECIFIED_PIXMAP)
		{
			XFreePixmap(XtDisplay(ptr->top_level), ptr->DialPixSmall);
			ptr->DialPixSmall = XmUNSPECIFIED_PIXMAP;
		}

#ifdef USE_INOTIFY
		PutWatchCommand(ptr, COMMAND_DETACH_IFACE);
#endif
		XtAppSetExitFlag(ptr->app);
		ptr = ptr->next_branche;
	}
	pthread_mutex_unlock(&iface_mutex);
}

extern void SaveSetting(Widget w, XtPointer client_data, XtPointer call_data);

void MenuCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
	char *thisfile, *fullpath, * CutString, * CopyString, * p;
	int i;
//	WidgetList sel_wid;
	Widget file_view_wid;
	int sel_count, sel_item_count = 0, * numbers;
	IfaceBranche * IbPtr, * new_win;
	XmNlCell SelectedCell;
	struct filedata * file_ptr = NULL;
	Boolean ok;
	int window_is_last = 0;
	int item_count;
	int first_selected = 0, last_selected;

	XtVaGetValues(w, XmNuserData, &IbPtr, NULL);

	XtVaGetValues(IbPtr->fm_scroll_win, XmNselectedPositionCount, &sel_count, 
					XmNselectedPositions, &numbers, NULL);


#ifdef DEBUG
	printf("MenuCallback, selected %d current wd = %s\n", sel_count, IbPtr->current_wd);
#endif


	switch ((int) client_data) 
	{
/*-----------------------------*/
	case FILE_MENU_NEW:
#ifdef DEBUG
		printf("MenuCallback: FileNewWindow\n");
#endif
		pthread_mutex_lock(&iface_mutex);
		new_win = StartNewIfaceBranche(IbPtr->current_wd);
		pthread_mutex_unlock(&iface_mutex);
		if (new_win)
				pthread_create(&(new_win->thread_id), NULL, NewIfaceWindowThread, (void *) new_win);
		break;
/*-----------------------------*/
	case FILE_MENU_PASTE:
		if (sel_count == 0)
		{
#ifdef DEBUG
			printf("MenuCallback: PasteFile, selected 0 current wd = %s\n", IbPtr->current_wd);
#endif
			PasteFile(IbPtr, &_CopyToCurrentDir);
			break;
		}
		else break;
/*-----------------------------*/
	case FILE_MENU_INFO:
		if (sel_count == 1)
		{
			ok = XmNlListGetItem(IbPtr->fm_scroll_win, &SelectedCell, CellUserData, numbers[0]);
			if (ok)
			{
				file_ptr = (struct filedata *) SelectedCell.UserDataPointer;
				display_info(file_ptr, IbPtr, NULL);
/*				thisfile =  file_ptr->name;
				fullpath = (char *) calloc( (strlen(IbPtr->current_wd) + 2 + strlen(thisfile)), sizeof(char));
				sprintf(fullpath, "%s/%s", IbPtr->current_wd, thisfile);
#ifdef DEBUG
				printf("Info %s\n", fullpath);
#endif
				display_info(fullpath, IbPtr);
				free(fullpath);*/
			}
			break;
		}
		else break;
/*-----------------------------*/
	case FILE_MENU_FIND:
		FindFileDialog(IbPtr);
		break;
/*-----------------------------*/
	case FILE_MENU_CLOSE:
		if (IbPtr->copy_move_thread_count)
		{
			ConfirmCloseDialog(IbPtr);
			break;
		}

		pthread_mutex_lock(&iface_mutex);
		if (iface_thread_counter == 1)
			window_is_last = 1;
		else
			iface_thread_counter--;
		pthread_mutex_unlock(&iface_mutex);
		
		if (window_is_last)
		{
			ConfirmCloseDialog2(IbPtr);
			break ;
		}
#ifdef USE_INOTIFY
		PutWatchCommand(IbPtr, COMMAND_DETACH_IFACE);
#endif
		XtAppSetExitFlag(IbPtr->app);
#ifdef DEBUG
		printf("AppSetExitFlag \n");
#endif
		break;
/*-----------------------------*/
	case FILE_MENU_EXIT:
		ExitFromApp(IbPtr);

#ifdef DEBUG
		printf("Exit for all app\n");
#endif
		break;
/*-----------------------------*/
	case DIR_CREATE:
		dir_create_func(IbPtr);
		break;
/*-----------------------------*/
	case DIR_GOTO:
		chdir_goto(IbPtr);
		break;
/*-----------------------------*/
	case DIR_HOME:
		chdir_home(IbPtr);
		break;
/*-----------------------------*/
	case DIR_UPONE:
		chdir_up(IbPtr);
		break;
/*-----------------------------*/
	case SHARE_SMB_ADDSHARE:
/*		if (sel_wid_count > 0) 
		{
			file_ptr = (struct filedata *) SelectedCells[0].UserDataPointer;
			thisfile =  file_ptr->name;;
			fullpath = (char *) calloc( (strlen(current_wd) + 2 + strlen(thisfile)), sizeof(char));
			sprintf(fullpath, "%s/%s", current_wd, thisfile);
			SMB_add_share(fullpath);
			free(fullpath);
			break;
		}
		else
		{
			SMB_add_share(NULL);
			break;
		}*/
		break;
/*-----------------------------*/
	case SHARE_SMB_LISTSHARES:
//		SMB_list_shares();
		break;
/*-----------------------------*/
	case SHARE_SMB_CONFIG:
//		SMB_server_config();
		break;
/*-----------------------------*/
	case SHARE_NFS_CONFIG:
//		nfs_server_config();
		break;
/*-----------------------------*/
	case FILE_MENU_RUN:
		if (sel_count == 1)
		{

			ok = XmNlListGetItem(IbPtr->fm_scroll_win, &SelectedCell, CellUserData, numbers[0]);
			if (ok)
			{
				file_ptr = (struct filedata *) SelectedCell.UserDataPointer;
				thisfile =  file_ptr->name;
				fullpath = (char *) calloc( (strlen(IbPtr->current_wd) + 2 + strlen(thisfile)), sizeof(char));
				sprintf(fullpath, "%s/%s", IbPtr->current_wd, thisfile);
				RunSelectedFile(fullpath, IbPtr);
				free(fullpath);
			}
			break;
		}
		else
			if (sel_count == 0)
			{
				RunUnselectedFile(IbPtr);
				break;
			}
			else break;
/*-----------------------------*/
	case OPTION_MENU_SAVE:
//		SaveSetting(IbPtr);
		ConfirmAction(IbPtr, "Save current configuration owerwrite?", SaveSetting);
		break;
/*-----------------------------*/
	case HELP_MENU_GENERAL:
		GeneralHelp(IbPtr);
		break;
/*-----------------------------*/
	case HELP_MENU_ABOUT:
		HelpAbout(IbPtr);
		break;
/*-----------------------------*/
	case FILE_MENU_CUT:
		if (sel_count > 0)
		{
			CutString = MakeSelectList(2, IbPtr);
			if (CutString) 
			{
				CutFile(CutString, IbPtr);
				free(CutString);
				break;
			}
			else break;
		}
		else break;
/*-----------------------------*/
	case FILE_MENU_COPY:
		if (sel_count > 0)
		{
			CopyString = MakeSelectList(1, IbPtr);
/*			CopyString = MakeSampleSelectList(1, IbPtr);*/
			if (CopyString)
			{
				CopyFile(CopyString, IbPtr);
#ifdef DEBUG
				printf("CopyFile\n");
#endif
				free(CopyString);
				break;
			}
			else break;
		}
		else break;
/*-----------------------------*/
	case FILE_MENU_RENAME:
		if (sel_count == 1)
		{
			ok = XmNlListGetItem(IbPtr->fm_scroll_win, &SelectedCell, CellUserData, numbers[0]);
			if (ok)
			{
				file_ptr = (struct filedata *) SelectedCell.UserDataPointer;
				thisfile =  file_ptr->name;
				RenameFileDialog(IbPtr, thisfile);
			}
			break;
		}
		else break;
/*-----------------------------*/
	case FILE_MENU_SYMLINK:
		if (sel_count == 1)
		{
			ok = XmNlListGetItem(IbPtr->fm_scroll_win, &SelectedCell, CellUserData, numbers[0]);
			if (ok)
			{
				file_ptr = (struct filedata *) SelectedCell.UserDataPointer;
				thisfile =  file_ptr->name;
				SymlinkFileDialog(IbPtr, thisfile);
			}
			break;
		}
		else break;
/*-----------------------------*/
	case FILE_MENU_SELECT_ALL:
		{
			int count, *pos, all_item_num;
			Widget ib, rc;
			char mode;
	
			XtVaGetValues(IbPtr->fm_scroll_win, XmNViewListType, &mode, NULL);
	
			if (mode == XmNlList_Big || mode == XmNlList_Small)
			{
				ib = XmNlListGetIBWidget(IbPtr->fm_scroll_win);
				
				XtVaGetValues(ib, XmNitemCount, &all_item_num, NULL);
#ifdef DEBUG
				printf("Item in list %d\n", all_item_num);
#endif
			}
			else
			{
				rc = XmNlListGetRCWidget(IbPtr->fm_scroll_win);
				XtVaGetValues(rc, XmNitemCount, &all_item_num, NULL);
#ifdef DEBUG
				printf("Item in list %d\n", all_item_num);
#endif
			}

			if (all_item_num)
			{
				pos = malloc(sizeof(int) * all_item_num);
				if (!pos)
					break ;
				
				for (i = 0; i < all_item_num; i++)
				{
					pos[i] = i;
				}
				XtVaSetValues(IbPtr->fm_scroll_win, XmNselectedPositionCount, all_item_num, 
								XmNselectedPositions, pos, NULL);
				if (pos)
					free(pos);
			}
		}

#ifdef DEBUG
			printf("MenuCallback, selected %d items after FILE_MENU_SELECT_ALL\n", item_num);
#endif
		break;
/*-----------------------------*/
	case FILE_MENU_DESELECT_ALL:
		XtVaSetValues(IbPtr->fm_scroll_win, XmNselectedPositionCount, 0, NULL);
		break;
/*-----------------------------*/
	case FILE_MENU_SELECT_INVERT:
		{
			int count, *pos, *pos2, all_item_num;
			Widget ib, rc;
			char mode;
			int k, l;
	
			XtVaGetValues(IbPtr->fm_scroll_win, XmNViewListType, &mode, NULL);
	
			if (mode == XmNlList_Big || mode == XmNlList_Small)
			{
				ib = XmNlListGetIBWidget(IbPtr->fm_scroll_win);
				
				XtVaGetValues(ib, XmNitemCount, &all_item_num, NULL);
#ifdef DEBUG
				printf("Item in list %d\n", all_item_num);
#endif
			}
			else
			{
				rc = XmNlListGetRCWidget(IbPtr->fm_scroll_win);
				XtVaGetValues(rc, XmNitemCount, &all_item_num, NULL);
#ifdef DEBUG
				printf("Item in list %d\n", all_item_num);
#endif
			}
			XtVaGetValues(IbPtr->fm_scroll_win, XmNselectedPositionCount, &count, 
							XmNselectedPositions, &pos, NULL);

#ifdef DEBUG
			printf("Current selected %d\n", count);
#endif
			
			pos2 = malloc(sizeof(int) * (all_item_num - count));
			if (!pos2)
				break ;
			
			k = l = 0;
			
			for (i = 0; i < all_item_num; i++)
			{
				if (i == pos[k])
				{
					k++;
				}
				else
				{
					pos2[l] = i;
					l++;
				}
			}

#ifdef DEBUG
			printf("Selected to set %d\n", l);
#endif

			XtVaSetValues(IbPtr->fm_scroll_win, XmNselectedPositionCount, all_item_num - count, 
							XmNselectedPositions, pos2, NULL);
							
			if (pos2)
				free(pos2);
		}
		break;
/*-----------------------------*/
	case FILE_MENU_SELECT_PATTERN:
		select_by_pattern_func(IbPtr);	
		break;
/*-----------------------------*/
	case FILE_MENU_DELETE:
#ifdef DEBUG
		printf("DeleteFile, selected \n");
#endif
		if (sel_count > 0)
		{
			CopyString = MakeSelectList(3, IbPtr);
#ifdef DEBUG
		printf("DeleteFile, CopyString %s \n", CopyString);
#endif
			if (CopyString) 
			{
				DeleteFile(CopyString, IbPtr);
				free(CopyString);
				break;
			}
			else break;
		}
		else break;
		
	}

#ifdef DEBUG
	printf("MenuCallback: ok\n");
#endif
}


void ChangeViewCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
	IfaceBranche * IbPtr;
	XmToggleButtonCallbackStruct *toggle_data = (XmToggleButtonCallbackStruct *) call_data;
	int n = (int) client_data;

	XtVaGetValues(w, XmNuserData, (IfaceBranche *) &IbPtr, NULL);

	if (n == OPTION_DETAIL)
	{
#ifdef DEBUG
		printf("\nView changed from detail button\n");
#endif
		if (toggle_data->set == XmSET)
		{
			XmToggleButtonSetState(IbPtr->large_bt, FALSE, FALSE);
			XmToggleButtonSetState(IbPtr->small_bt, FALSE, FALSE);
			IbPtr->CurrentViewType = DETAIL_VIEW;
			ChangeViewDo(IbPtr);
		}
		else
		{
			XmToggleButtonSetState(IbPtr->large_bt, TRUE, FALSE);
			XmToggleButtonSetState(IbPtr->small_bt, FALSE, FALSE);
			IbPtr->CurrentViewType = LARGE_VIEW;
			ChangeViewDo(IbPtr);
		}
	}
	else if (n == OPTION_LARGE)
	{
#ifdef DEBUG
		printf("\nView changed from large button\n");
#endif
		if (toggle_data->set == XmSET)
		{
			XmToggleButtonSetState(IbPtr->detail_bt, FALSE, FALSE);
			XmToggleButtonSetState(IbPtr->small_bt, FALSE, FALSE);
			IbPtr->CurrentViewType = LARGE_VIEW;
			ChangeViewDo(IbPtr);
		}
		else
		{
			XmToggleButtonSetState(IbPtr->detail_bt, TRUE, FALSE);
			XmToggleButtonSetState(IbPtr->small_bt, FALSE, FALSE);
			IbPtr->CurrentViewType = DETAIL_VIEW;
			ChangeViewDo(IbPtr);
		}
	}
	else if (n == OPTION_SMALL)
	{
#ifdef DEBUG
		printf("\nView changed from small button\n");
#endif
		if (toggle_data->set == XmSET)
		{
			XmToggleButtonSetState(IbPtr->detail_bt, FALSE, FALSE);
			XmToggleButtonSetState(IbPtr->large_bt, FALSE, FALSE);
			IbPtr->CurrentViewType = SMALL_VIEW;
			ChangeViewDo(IbPtr);
		}
		else
		{
			XmToggleButtonSetState(IbPtr->large_bt, TRUE, FALSE);
			XmToggleButtonSetState(IbPtr->detail_bt, FALSE, FALSE);
			XmToggleButtonSetState(IbPtr->large_bt, FALSE, FALSE);
			IbPtr->CurrentViewType = LARGE_VIEW;
			ChangeViewDo(IbPtr);
		}
	}

}

void ChangeSortCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
	IfaceBranche * IbPtr;
	XmToggleButtonCallbackStruct *toggle_data = (XmToggleButtonCallbackStruct *) call_data;
	int n = (int) client_data;

	XtVaGetValues(w, XmNuserData, (IfaceBranche *) &IbPtr, NULL);

	if (n == OPTION_CASE_SENSITIVE)
	{
#ifdef DEBUG
		printf("\nChanged from case sensitive button\n");
#endif
		if (0 == IbPtr->CaseSensitiveSorting)
		{
			XmToggleButtonSetState(IbPtr->case_sensitive_bt, True, FALSE);
			IbPtr->CaseSensitiveSorting = 1;
		}
		else
		{
			XmToggleButtonSetState(IbPtr->case_sensitive_bt, FALSE, FALSE);
			IbPtr->CaseSensitiveSorting = 0;
		}
	}
	ReSort(IbPtr);
}



void ChangeShowCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
	IfaceBranche * IbPtr;
	XmToggleButtonCallbackStruct *toggle_data = (XmToggleButtonCallbackStruct *) call_data;
	int n = (int) client_data;

	XtVaGetValues(w, XmNuserData, (IfaceBranche *) &IbPtr, NULL);

	if (n == OPTION_HIDDEN_DIR)
	{
#ifdef DEBUG
		printf("\nShow changed from hidden dir button\n");
#endif
		if (0 == IbPtr->HiddenDirShow)
		{
			XmToggleButtonSetState(IbPtr->hid_dir_bt, True, FALSE);
			IbPtr->HiddenDirShow = 1;
		}
		else
		{
			XmToggleButtonSetState(IbPtr->hid_dir_bt, FALSE, FALSE);
			IbPtr->HiddenDirShow = 0;
		}
	}

	if (n == OPTION_HIDDEN_FILE)
	{
#ifdef DEBUG
		printf("\nShow changed from hidden file button\n");
#endif
		if (0 == IbPtr->HiddenFileShow)
		{
			XmToggleButtonSetState(IbPtr->hid_file_bt, True, FALSE);
			IbPtr->HiddenFileShow = 1;
		}
		else
		{
			XmToggleButtonSetState(IbPtr->hid_file_bt, FALSE, FALSE);
			IbPtr->HiddenFileShow = 0;
		}
	}
	
	if (n == OPTION_PARENT_DIR)
	{
#ifdef DEBUG
		printf("\nShow changed from parent dir button\n");
#endif
		if (0 == IbPtr->ParentDirShow)
		{
			XmToggleButtonSetState(IbPtr->par_dir_bt, True, FALSE);
			IbPtr->ParentDirShow = 1;
		}
		else
		{
			XmToggleButtonSetState(IbPtr->par_dir_bt, FALSE, FALSE);
			IbPtr->ParentDirShow = 0;
		}
	}

	if (n == OPTION_CURRENT_DIR)
	{
#ifdef DEBUG
		printf("\nShow changed from current dir button\n");
#endif
		if (0 == IbPtr->CurrentDirShow)
		{
			XmToggleButtonSetState(IbPtr->cur_dir_bt, True, FALSE);
			IbPtr->CurrentDirShow = 1;
		}
		else
		{
			XmToggleButtonSetState(IbPtr->cur_dir_bt, FALSE, FALSE);
			IbPtr->CurrentDirShow = 0;
		}
	}
	DrawFileArea(IbPtr);

}

void pattern_cancelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
#ifdef DEBUG
	printf("pattern_cancelCB\n");
#endif

	XtDestroyWidget(w);
}


/* Pattern apply to selection. */
void pattern_applyCB(Widget w, XtPointer client_data, XtPointer call_data)
{
	char * pattern = NULL;
	IfaceBranche * IbPtr;
	Widget text_f, ib, rc;
	int all_item_count;
	char mode;
	XmNlCell Cell;
	struct filedata * file_ptr = NULL;
	Boolean ok;
	int i, filter_ok, ret;
	int * sel_pos, offset;
	

	XtVaGetValues(w, XmNuserData, &IbPtr, NULL);

	text_f = XtNameToWidget(w, "Text");
	
	if (text_f)
	{
		XtVaGetValues(text_f, XmNvalue, &pattern, NULL);

#ifdef DEBUG
			printf("Pattern: %s\n", pattern);
#endif
		if (!pattern)
		{
			XtDestroyWidget(w);
			return ;
		}
		
		ret = create_pattern_list(&(IbPtr->PatternRec), pattern);

#ifdef DEBUG
		print_pattern_list(&(IbPtr->PatternRec));
#endif

		XtDestroyWidget(w);

		XtVaGetValues(IbPtr->fm_scroll_win, XmNViewListType, &mode, NULL);
		if (mode == XmNlList_Big || mode == XmNlList_Small)
		{
			ib = XmNlListGetIBWidget(IbPtr->fm_scroll_win);
			XtVaGetValues(ib, XmNitemCount, &all_item_count, NULL);
		}
		else
		{
			rc = XmNlListGetRCWidget(IbPtr->fm_scroll_win);
			XtVaGetValues(rc, XmNitemCount, &all_item_count, NULL);
		}
			
		if (all_item_count)
		{
			sel_pos = calloc(all_item_count, sizeof(int));
			if (!sel_pos)
			{
				clean_pattern_list(&(IbPtr->PatternRec));
				return ;
			}
		}
			
		offset = 0;

		for (i = 0; i < all_item_count; i++)
		{
			ok = XmNlListGetItem(IbPtr->fm_scroll_win, &Cell, CellUserData, i);
			if (ok)
			{
				file_ptr = (struct filedata *) Cell.UserDataPointer;
				filter_ok = check_pattern_list(&(IbPtr->PatternRec), file_ptr->name);
				if (filter_ok)
				{
#ifdef DEBUG
					printf("Checking result ok for:%s\n", file_ptr->name);
#endif
					sel_pos[offset] = i;
					offset++;
				}
			}
		}
			
		if (offset)
		{
			XtVaSetValues(IbPtr->fm_scroll_win, XmNselectedPositionCount, offset, 
							XmNselectedPositions, sel_pos, NULL);
				
		}
			
		if (sel_pos)
			free(sel_pos);
			
		clean_pattern_list(&(IbPtr->PatternRec));
	}
	return ;
}


void select_by_pattern_func(IfaceBranche * IbPtr) 
{
	XmString info, name;
	char * string, * c;
	int i;
	Arg args[10];
	Cardinal n;
	Widget dialog, text, message, apply;

	name = XmStringCreateLocalized("Pattern:");
	n = 0;
	XtSetArg(args[n], XmNtitle, "Select by pattern");
	n++;
	XtSetArg(args[n], XmNautoUnmanage, False); 
	n++;
	XtSetArg(args[n], XmNselectionLabelString, name);
	n++;
	XtSetArg(args[n], XmNuserData, (XtPointer) IbPtr);
	n++;

	dialog = XmCreatePromptDialog(IbPtr->top_level, "SelectByPattern", args, n);

	XmStringFree(name);

	XtManageChild(dialog);

	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc) pattern_applyCB,
				(XtPointer) NULL);
	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc) pattern_cancelCB,
				(XtPointer) NULL);

	return ;
}
