/* menubars.c -- Functions which draw the menu bars for this program.
 *
 * Bryan Herger (hergeb@rpi.edu)
 * Part of my file manager.  Hacked from my Comp. Graphics term project.
 */

#include <stdio.h>
#include <unistd.h>
#include <pthread.h>

#include <X11/Xlib.h>
#include <X11/X.h>
#include <Xm/Xm.h>
#include <Xm/CascadeB.h> 
#include <Xm/ToggleB.h>
#include <Xm/Form.h>
#include <Xm/MainW.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/MessageB.h>
#include "defines.h"
#include "core.h"
#include "menucallback.h"

/* Why are these out here?... */
Widget share_pulldown, smb_config, smb_share, smb_listshares;
Widget dir_upone;

/* This struct define view ToggleButton state */
typedef struct _ToggleButtonState {
  Widget large_bt, small_bt, detail_bt;
  Boolean large;
  Boolean small;
  Boolean detail;
} ToggleButtonState;

int CurrentViewType;

/* Set in main.c, this is the uid and gid of the program. */
extern uid_t local_uid;
extern gid_t local_gid;

Widget view_pulldown, view_cascade, large_bt, small_bt, detail_bt;


/* Create that top menu bar.  Later I will add a toolbar and such.
 * This function creates the menu bar, all pulldowns, and sets callbacks
 * to menucallack.c */
void InitializeViewSwitch(Widget large, Widget small, Widget detail)
{
	IfaceBranche * IbPtr;
	
	XtVaGetValues(large, XmNuserData, &IbPtr, NULL);
//	CurrentViewType = LARGE_VIEW;
//	CurrentViewType = DETAIL_VIEW;
	if (IbPtr->CurrentViewType == DETAIL_VIEW)
	{
		XmToggleButtonSetState(large, FALSE, FALSE);
		XmToggleButtonSetState(small, FALSE, FALSE);
		XmToggleButtonSetState(detail, TRUE, FALSE);
	}
	else
		if (IbPtr->CurrentViewType == LARGE_VIEW)
		{
			XmToggleButtonSetState(large, TRUE, FALSE);
			XmToggleButtonSetState(small, FALSE, FALSE);
			XmToggleButtonSetState(detail, FALSE, FALSE);
		}
		else
		{
			XmToggleButtonSetState(large, FALSE, FALSE);
			XmToggleButtonSetState(small, TRUE, FALSE);
			XmToggleButtonSetState(detail, FALSE, FALSE);
		}
		
//	CurrentViewType = LARGE_VIEW;
//	ToggleButtonState.large_bt = large;
//	ToggleButtonState.detail_bt = detail;
//	ToggleButtonState.large = TRUE;
//	ToggleButtonState.detail = FALSE;
	
}

void InitializeCaseSensitiveSwitch(IfaceBranche * IbPtr)
{
	if (IbPtr->CaseSensitiveSorting)
		XmToggleButtonSetState(IbPtr->case_sensitive_bt, True, FALSE);
	else
		XmToggleButtonSetState(IbPtr->case_sensitive_bt, FALSE, FALSE);
}


void InitializeShowSwitch(IfaceBranche * IbPtr)
{
	if (HiddenDirShow)
		XmToggleButtonSetState(IbPtr->hid_dir_bt, True, FALSE);
	else
		XmToggleButtonSetState(IbPtr->hid_dir_bt, FALSE, FALSE);
		
	if (HiddenFileShow)
		XmToggleButtonSetState(IbPtr->hid_file_bt, True, FALSE);
	else
		XmToggleButtonSetState(IbPtr->hid_file_bt, FALSE, FALSE);

	if (ParentDirShow)
		XmToggleButtonSetState(IbPtr->par_dir_bt, True, FALSE);
	else
		XmToggleButtonSetState(IbPtr->par_dir_bt, FALSE, FALSE);

	if (CurrentDirShow)
		XmToggleButtonSetState(IbPtr->cur_dir_bt, True, FALSE);
	else
		XmToggleButtonSetState(IbPtr->cur_dir_bt, FALSE, FALSE);

}

static Widget CreateCascade(Widget parent, Widget submenu, char * name)
{
	Widget cascade;
	Arg args[7];
	int   n;

	n = 0;
	XtSetArg (args[n], XmNsubMenuId, submenu); n++;
	cascade = XmCreateCascadeButton(parent, name, args, n);
	XtManageChild(cascade);
	return cascade;
}

static Widget CreateItem(Widget parent, char * name, XtCallbackProc callback, XtPointer client_data, XtPointer user_data)
{
	Widget button;

	button = XtVaCreateManagedWidget(name, xmPushButtonWidgetClass, parent, NULL);
	XtAddCallback(button, XmNactivateCallback, callback, client_data);
	XtVaSetValues(button, XmNuserData, user_data, NULL);
	return button;
}



Widget CreateMenuBar(IfaceBranche * IbPtr)
{
	Widget menubar_widget, separator;
	Widget file_pulldown, dir_pulldown, edit_pulldown, show_pulldown;
	Widget file_cascade, dir_cascade, edit_cascade;
	Widget option_pulldown, toolbar_pulldown, help_pulldown;
	Widget option_cascade, toolbar_cascade, help_cascade;
	Widget file_new, file_run, file_cut, file_copy, file_paste, file_delete; 
	Widget file_info, file_close, file_exit, file_rename, file_symlink;
	Widget file_select_all, file_deselect_all, file_select_by_pattern, file_select_invert;
	Widget file_find;
	Widget dir_create, dir_goto, dir_home; 
	Widget smb_separator, share_nfs, save_setting;
	Widget toolbar_add, toolbar_remove;
	Widget help_button, help_general, help_index, help_about;
	Arg args[7];
	int   n;

	menubar_widget = XmCreateMenuBar(IbPtr->fm_main_window, "MenuBar", NULL, 0);

	XtManageChild(menubar_widget);
	
/***************************/
	file_pulldown = XmCreatePulldownMenu(menubar_widget, "FilePulldown", NULL, 0);
	IbPtr->file_pulldown = file_pulldown;

	dir_pulldown = XmCreatePulldownMenu(menubar_widget, "DirPulldown", NULL, 0);
	IbPtr->dir_pulldown = dir_pulldown;

	edit_pulldown = XmCreatePulldownMenu(menubar_widget, "EditPulldown", NULL, 0);
	IbPtr->edit_pulldown = edit_pulldown;

	view_pulldown = XmCreatePulldownMenu(menubar_widget, "ViewPulldown", NULL, 0);
	IbPtr->view_pulldown = view_pulldown;

	option_pulldown = XmCreatePulldownMenu(menubar_widget, "OptionPulldown", NULL, 0);

	help_pulldown = XmCreatePulldownMenu(menubar_widget, "HelpPulldown", NULL, 0);

/***************************/



	file_cascade = CreateCascade(menubar_widget, file_pulldown, "File");

	
	file_new = CreateItem(file_pulldown, "NewWindow", MenuCallback,
						(XtPointer) FILE_MENU_NEW, (XtPointer) IbPtr);


	file_run = CreateItem(file_pulldown, "Run", MenuCallback,
						(XtPointer) FILE_MENU_RUN, (XtPointer) IbPtr);

	file_find = CreateItem(file_pulldown, "Find", MenuCallback,
						(XtPointer) FILE_MENU_FIND, (XtPointer) IbPtr);


	file_close = CreateItem(file_pulldown, "Close", MenuCallback,
						(XtPointer) FILE_MENU_CLOSE, (XtPointer) IbPtr);
 
	file_exit = CreateItem(file_pulldown, "Exit", MenuCallback,
						(XtPointer) FILE_MENU_EXIT, (XtPointer) IbPtr);


/***************************/  

	dir_cascade = CreateCascade(menubar_widget, dir_pulldown, "Directory");
  
	dir_create = CreateItem(dir_pulldown, "Create", MenuCallback,
						(XtPointer) DIR_CREATE, (XtPointer) IbPtr);

	separator = XtVaCreateManagedWidget("DirSep_1",
					  xmSeparatorWidgetClass,
					  dir_pulldown, NULL);

	dir_goto = CreateItem(dir_pulldown, "Goto", MenuCallback,
						(XtPointer) DIR_GOTO, (XtPointer) IbPtr);


	dir_home = CreateItem(dir_pulldown, "Home", MenuCallback,
						(XtPointer) DIR_HOME, (XtPointer) IbPtr);


	dir_upone = CreateItem(dir_pulldown, "Up", MenuCallback,
						(XtPointer) DIR_UPONE, (XtPointer) IbPtr);

/****************/  

	edit_cascade = CreateCascade(menubar_widget, edit_pulldown, "Edit");
	 
	file_cut = CreateItem(edit_pulldown, "Cut", MenuCallback,
						(XtPointer) FILE_MENU_CUT, (XtPointer) IbPtr);

	file_copy = CreateItem(edit_pulldown, "Copy", MenuCallback,
						(XtPointer) FILE_MENU_COPY, (XtPointer) IbPtr);

	file_paste = CreateItem(edit_pulldown, "Paste", MenuCallback,
						(XtPointer) FILE_MENU_PASTE, (XtPointer) IbPtr);

	separator = XtVaCreateManagedWidget("EditSep_1",
					  xmSeparatorWidgetClass,
					  edit_pulldown, NULL);

	file_rename = CreateItem(edit_pulldown, "Rename", MenuCallback,
						(XtPointer) FILE_MENU_RENAME, (XtPointer) IbPtr);

	file_symlink = CreateItem(edit_pulldown, "Link", MenuCallback,
						(XtPointer) FILE_MENU_SYMLINK, (XtPointer) IbPtr);

	separator = XtVaCreateManagedWidget("EditSep_2",
					  xmSeparatorWidgetClass,
					  edit_pulldown, NULL);

	file_delete = CreateItem(edit_pulldown, "Delete", MenuCallback,
						(XtPointer) FILE_MENU_DELETE, (XtPointer) IbPtr);

	separator = XtVaCreateManagedWidget("EditSep_3",
					  xmSeparatorWidgetClass,
					  edit_pulldown, NULL);

	file_select_all = CreateItem(edit_pulldown, "Select All", MenuCallback,
						(XtPointer) FILE_MENU_SELECT_ALL, (XtPointer) IbPtr);

	file_select_by_pattern = CreateItem(edit_pulldown, "Select by pattern", MenuCallback,
						(XtPointer) FILE_MENU_SELECT_PATTERN, (XtPointer) IbPtr);

	file_select_invert = CreateItem(edit_pulldown, "Invert selectection", MenuCallback,
						(XtPointer) FILE_MENU_SELECT_INVERT, (XtPointer) IbPtr);

	file_deselect_all = CreateItem(edit_pulldown, "Deselect All", MenuCallback,
						(XtPointer) FILE_MENU_DESELECT_ALL, (XtPointer) IbPtr);

	separator = XtVaCreateManagedWidget("EditSep_4",
					  xmSeparatorWidgetClass,
					  edit_pulldown, NULL);

	file_info = CreateItem(edit_pulldown, "Information", MenuCallback,
						(XtPointer) FILE_MENU_INFO, (XtPointer) IbPtr);


/****************/  

	view_cascade = CreateCascade(menubar_widget, view_pulldown, "View");

	large_bt = XmCreateToggleButton(view_pulldown, "LargeView",
			       NULL, 0);

	XtVaSetValues(large_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmONE_OF_MANY_ROUND,
				XmNuserData, (XtPointer) IbPtr,
				NULL);
  
	XtAddCallback(large_bt, XmNvalueChangedCallback, ChangeViewCallback,
			(XtPointer) OPTION_LARGE);

	small_bt = XmCreateToggleButton(view_pulldown, "SmallView",
			       NULL, 0);

	XtVaSetValues(small_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmONE_OF_MANY_ROUND,
				XmNuserData, (XtPointer) IbPtr,
				NULL);
  
	XtAddCallback(small_bt, XmNvalueChangedCallback, ChangeViewCallback,
				(XtPointer) OPTION_SMALL);


	detail_bt = XmCreateToggleButton(view_pulldown, "DetailView",
									NULL, 0);
	XtVaSetValues(detail_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmONE_OF_MANY_ROUND,
				XmNuserData, (XtPointer) IbPtr,
				NULL);
	XtAddCallback(detail_bt, XmNvalueChangedCallback, ChangeViewCallback,
				(XtPointer) OPTION_DETAIL);

	IbPtr->small_bt = small_bt;
	IbPtr->large_bt = large_bt;
	IbPtr->detail_bt = detail_bt;

	XtManageChild (large_bt);
	XtManageChild (small_bt);
	XtManageChild (detail_bt);

	InitializeViewSwitch(large_bt, small_bt, detail_bt);

	separator = XtVaCreateManagedWidget("ViewSep_1",
					  xmSeparatorWidgetClass,
					  view_pulldown, NULL);

	IbPtr->case_sensitive_bt = XmCreateToggleButton(view_pulldown, "CaseSensitive",
			       NULL, 0);

	XtVaSetValues(IbPtr->case_sensitive_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmN_OF_MANY,
				XmNindicatorOn, XmINDICATOR_CHECK_BOX,
				XmNvisibleWhenOff, True,
				XmNuserData, (XtPointer) IbPtr,
				NULL);
  
	XtAddCallback(IbPtr->case_sensitive_bt, XmNvalueChangedCallback, ChangeSortCallback,
			(XtPointer) OPTION_CASE_SENSITIVE);

	separator = XtVaCreateManagedWidget("ViewSep_2",
					  xmSeparatorWidgetClass,
					  view_pulldown, NULL);


	IbPtr->hid_dir_bt = XmCreateToggleButton(view_pulldown, "ShowHiddenDirs",
			       NULL, 0);

	XtVaSetValues(IbPtr->hid_dir_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmN_OF_MANY,
				XmNindicatorOn, XmINDICATOR_CHECK_BOX,
				XmNvisibleWhenOff, True,
				XmNuserData, (XtPointer) IbPtr,
				NULL);
  
	XtAddCallback(IbPtr->hid_dir_bt, XmNvalueChangedCallback, ChangeShowCallback,
			(XtPointer) OPTION_HIDDEN_DIR);

	IbPtr->hid_file_bt = XmCreateToggleButton(view_pulldown, "ShowHiddenFiles",
			       NULL, 0);

	XtVaSetValues(IbPtr->hid_file_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmN_OF_MANY,
				XmNindicatorOn, XmINDICATOR_CHECK_BOX,
				XmNvisibleWhenOff, True,
				XmNuserData, (XtPointer) IbPtr,
				NULL);
  
	XtAddCallback(IbPtr->hid_file_bt, XmNvalueChangedCallback, ChangeShowCallback,
				(XtPointer) OPTION_HIDDEN_FILE);


	IbPtr->par_dir_bt = XmCreateToggleButton(view_pulldown, "ShowParentDir",
									NULL, 0);
	XtVaSetValues(IbPtr->par_dir_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmN_OF_MANY,
				XmNindicatorOn, XmINDICATOR_CHECK_BOX,
				XmNvisibleWhenOff, True,
				XmNuserData, (XtPointer) IbPtr,
				NULL);

	XtAddCallback(IbPtr->par_dir_bt, XmNvalueChangedCallback, ChangeShowCallback,
				(XtPointer) OPTION_PARENT_DIR);

	IbPtr->cur_dir_bt = XmCreateToggleButton(view_pulldown, "ShowCurrentDir",
									NULL, 0);
	XtVaSetValues(IbPtr->cur_dir_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmN_OF_MANY,
				XmNindicatorOn, XmINDICATOR_CHECK_BOX,
				XmNvisibleWhenOff, True,
				XmNuserData, (XtPointer) IbPtr,
				NULL);

	XtAddCallback(IbPtr->cur_dir_bt, XmNvalueChangedCallback, ChangeShowCallback,
				(XtPointer) OPTION_CURRENT_DIR);

	XtManageChild (IbPtr->case_sensitive_bt);
	XtManageChild (IbPtr->hid_file_bt);
	XtManageChild (IbPtr->hid_dir_bt);
	XtManageChild (IbPtr->par_dir_bt);
	XtManageChild (IbPtr->cur_dir_bt);
	InitializeCaseSensitiveSwitch(IbPtr);
	InitializeShowSwitch(IbPtr);


/****************/  
	option_cascade = CreateCascade(menubar_widget, option_pulldown, "Options");

	save_setting = CreateItem(option_pulldown, "SaveCurrentSetting",
									MenuCallback, (XtPointer) OPTION_MENU_SAVE,
									(XtPointer) IbPtr);

/****************/  

	help_cascade = CreateCascade(menubar_widget, help_pulldown, "Help");
  
	help_general = CreateItem(help_pulldown, "HelpItem",
									MenuCallback, (XtPointer) HELP_MENU_GENERAL,
									(XtPointer) IbPtr);
	
	separator = XtVaCreateManagedWidget("HelpSep1", xmSeparatorWidgetClass,
				     help_pulldown, NULL);

	help_about = CreateItem(help_pulldown, "About",
									MenuCallback, (XtPointer) HELP_MENU_ABOUT,
									(XtPointer) IbPtr);

	XtVaSetValues(menubar_widget, XmNmenuHelpWidget, help_cascade, NULL);

	return(menubar_widget);
}



Widget CreateMenuBarBack(IfaceBranche * IbPtr)
{
	Widget menubar_widget;
	Widget file_pulldown, dir_pulldown, edit_pulldown, show_pulldown;
	Widget file_cascade, dir_cascade, edit_cascade;
	Widget option_pulldown, toolbar_pulldown, help_pulldown;
	Widget option_cascade, toolbar_cascade, help_cascade;
	Widget file_new, file_run, file_cut, file_copy, file_paste, file_delete, file_info, file_close, file_exit;
	Widget file_sep1, file_sep2, file_sep3, file_find;
	Widget dir_create, dir_separator, dir_goto, dir_home; 
	Widget smb_separator, share_nfs, save_setting;
	Widget toolbar_add, toolbar_remove;
	Widget help_button, help_general, help_index, help_sep, help_about;
	XmString label_str;	
	Arg args[7];
	int   n;

	XmString copy_str, copy_as, move_str, move_as, delete_str, info_str, info_as, paste_str, paste_as;

	copy_str = XmStringCreateLocalized ("Copy");
	copy_as = XmStringCreateLocalized ("Ctrl+C");
	
	move_str = XmStringCreateLocalized ("Cut");
	move_as = XmStringCreateLocalized ("Ctl+X");

	delete_str = XmStringCreateLocalized ("Delete");

	info_str = XmStringCreateLocalized ("Info");
	info_as = XmStringCreateLocalized ("Ctrl+I");

	paste_str = XmStringCreateLocalized ("Paste");
	paste_as = XmStringCreateLocalized ("Ctrl+V");


	menubar_widget = XmCreateMenuBar(IbPtr->fm_main_window, "menubar", NULL, 0);

	XtManageChild(menubar_widget);
	
/***************************/
	file_pulldown = XmCreatePulldownMenu(menubar_widget, "file_pulldown", NULL, 0);
	IbPtr->file_pulldown = file_pulldown;

	label_str = XmStringCreateLocalized ("File");
	n = 0;
	XtSetArg (args[n], XmNmnemonic, 'F'); n++;
	XtSetArg (args[n], XmNlabelString, label_str); n++;
	XtSetArg (args[n], XmNsubMenuId, file_pulldown); n++;
	file_cascade = XmCreateCascadeButton (menubar_widget, "File", args, n);
	XtManageChild (file_cascade);
	XmStringFree (label_str);

	
	file_new = XtVaCreateManagedWidget("file_new", xmPushButtonWidgetClass,
										file_pulldown, NULL);
	XtAddCallback(file_new, XmNactivateCallback, MenuCallback,
					(XtPointer) FILE_MENU_NEW);
	XtVaSetValues(file_new, XmNlabelString, XmStringCreateLocalized("New window"),
					XmNuserData, (XtPointer) IbPtr, NULL);

	file_run = XtVaCreateManagedWidget("file_run", xmPushButtonWidgetClass,
										file_pulldown, NULL);
	XtAddCallback(file_run, XmNactivateCallback, MenuCallback,
					(XtPointer) FILE_MENU_RUN);
	XtVaSetValues(file_run, XmNlabelString, XmStringCreateLocalized("Run..."),
					XmNuserData, (XtPointer) IbPtr, NULL);

	file_find = XtVaCreateManagedWidget("file_find", xmPushButtonWidgetClass,
				     file_pulldown, XmNuserData, (XtPointer) IbPtr, NULL);
	XtAddCallback(file_find, XmNactivateCallback, MenuCallback,
				(XtPointer) FILE_MENU_FIND);
	XtVaSetValues(file_find, XmNlabelString, XmStringCreateLocalized("Find..."),
					NULL);

	file_close = XtVaCreateManagedWidget("file_close", xmPushButtonWidgetClass,
				     file_pulldown, XmNmnemonic, 'Q', NULL);
	XtAddCallback(file_close, XmNactivateCallback, MenuCallback,
					(XtPointer) FILE_MENU_CLOSE);
	XtVaSetValues(file_close, XmNlabelString, XmStringCreateLocalized("Close"),
					XmNuserData, (XtPointer) IbPtr, NULL);

	file_exit = XtVaCreateManagedWidget("file_exit", xmPushButtonWidgetClass,
				     file_pulldown, XmNmnemonic, 'X', NULL);
	XtAddCallback(file_exit, XmNactivateCallback, MenuCallback,
					(XtPointer) FILE_MENU_EXIT);
	XtVaSetValues(file_exit, XmNlabelString, XmStringCreateLocalized("Exit"),
					XmNuserData, (XtPointer) IbPtr, NULL);


/***************************/  

	dir_pulldown = XmCreatePulldownMenu(menubar_widget, "dir_pulldown", NULL, 0);

	IbPtr->dir_pulldown = dir_pulldown;

	label_str = XmStringCreateLocalized ("Directory");
	n = 0;
	XtSetArg (args[n], XmNmnemonic, 'D'); n++;
	XtSetArg (args[n], XmNlabelString, label_str); n++;
	XtSetArg (args[n], XmNsubMenuId, dir_pulldown); n++;
	dir_cascade = XmCreateCascadeButton (menubar_widget, "Directory", args, n);
	XtManageChild (dir_cascade);
	
	XmStringFree (label_str);
  
	dir_create = XtVaCreateManagedWidget("dir_create", 
				       xmPushButtonWidgetClass,
				       dir_pulldown, NULL);
	XtAddCallback(dir_create, XmNactivateCallback, MenuCallback, 
				(XtPointer) DIR_CREATE);
	XtVaSetValues(dir_create, XmNlabelString, 
				XmStringCreateLocalized("Create..."), XmNuserData, (XtPointer) IbPtr, NULL);

	dir_separator = XtVaCreateManagedWidget("dir_sep_1",
					  xmSeparatorWidgetClass,
					  dir_pulldown, NULL);
	dir_goto = XtVaCreateManagedWidget("dir_goto", 
				     xmPushButtonWidgetClass,
				     dir_pulldown, NULL);
	XtAddCallback(dir_goto, XmNactivateCallback, MenuCallback,
				(XtPointer) DIR_GOTO);
	XtVaSetValues(dir_goto, XmNlabelString, 
				XmStringCreateLocalized("Goto..."), XmNuserData, (XtPointer) IbPtr, NULL);

	dir_home = XtVaCreateManagedWidget("dir_home", 
				     xmPushButtonWidgetClass,
				     dir_pulldown, NULL);
	XtAddCallback(dir_home, XmNactivateCallback, MenuCallback, 
				(XtPointer) DIR_HOME);
	XtVaSetValues(dir_home, XmNlabelString, 
				XmStringCreateLocalized("Home"), XmNuserData, (XtPointer) IbPtr, NULL);

	dir_upone = XtVaCreateManagedWidget("dir_upone", 
				      xmPushButtonWidgetClass,
				      dir_pulldown, NULL);
	XtAddCallback(dir_upone, XmNactivateCallback, MenuCallback, 
				(XtPointer) DIR_UPONE);

	XtVaSetValues(dir_upone, XmNlabelString, 
				XmStringCreateLocalized("Up"), XmNuserData, (XtPointer) IbPtr, NULL);

/****************/  

	edit_pulldown = XmCreatePulldownMenu(menubar_widget, "edit_pulldown", NULL, 0);

	IbPtr->edit_pulldown = edit_pulldown;
	
	label_str = XmStringCreateLocalized ("Edit");
	n = 0;
	XtSetArg (args[n], XmNmnemonic, 'E'); n++;
	XtSetArg (args[n], XmNlabelString, label_str); n++;
	XtSetArg (args[n], XmNsubMenuId, edit_pulldown); n++;
	edit_cascade = XmCreateCascadeButton (menubar_widget, "Edit", args, n);
	XtManageChild (edit_cascade);
	XmStringFree (label_str);

	n=0;
	XtSetArg(args[n], XmNlabelString, move_str);
	n++;
	XtSetArg(args[n], XmNacceleratorText, move_as);
	n++;
	XtSetArg(args[n], XmNaccelerator, "Ctrl<Key>x");
	n++;
	XtSetArg(args[n], XmNmnemonic, 't');
	n++;
	XtSetArg(args[n], XmNuserData, (XtPointer) IbPtr);
	n++;
	 
//  file_cut = XtVaCreateManagedWidget("file_cut", xmPushButtonWidgetClass,
//				     edit_pulldown, NULL);
	file_cut = XtCreateManagedWidget("file_cut", xmPushButtonWidgetClass,
				     edit_pulldown, args, n);
	XtAddCallback(file_cut, XmNactivateCallback, MenuCallback,
				(XtPointer) FILE_MENU_CUT);
//  XtVaSetValues(file_cut, XmNlabelString, XmStringCreateLocalized("Cut"),
//		NULL);

	XmStringFree(move_str);
	XmStringFree(move_as);

	n=0;
	XtSetArg(args[n], XmNlabelString, copy_str);
	n++;
	XtSetArg(args[n], XmNacceleratorText, copy_as);
	n++;
	XtSetArg(args[n], XmNaccelerator, "Ctrl<Key>c");
	n++;
	XtSetArg(args[n], XmNmnemonic, 'C');
	n++;
	XtSetArg(args[n], XmNuserData, (XtPointer) IbPtr);
	n++;

//  file_copy = XtVaCreateManagedWidget("file_copy", xmPushButtonWidgetClass,
//				     edit_pulldown, NULL);
	file_copy = XtCreateManagedWidget("file_copy", xmPushButtonWidgetClass,
						edit_pulldown, args, n);
	XtAddCallback(file_copy, XmNactivateCallback, MenuCallback,
				(XtPointer) FILE_MENU_COPY);
//  XtVaSetValues(file_copy, XmNlabelString, XmStringCreateLocalized("Copy"),
//		NULL);

	XmStringFree(copy_str);
	XmStringFree(copy_as);

	n=0;
	XtSetArg(args[n], XmNlabelString, paste_str);
	n++;
	XtSetArg(args[n], XmNacceleratorText, paste_as);
	n++;
	XtSetArg(args[n], XmNaccelerator, "Ctrl<Key>v");
	n++;
	XtSetArg(args[n], XmNmnemonic, 'P');
	n++;
	XtSetArg(args[n], XmNuserData, (XtPointer) IbPtr);
	n++;

//  file_paste = XtVaCreateManagedWidget("file_paste", xmPushButtonWidgetClass,
//				     edit_pulldown, NULL);
	file_paste = XtCreateManagedWidget("file_paste", xmPushButtonWidgetClass,
									edit_pulldown, args, n);
	XtAddCallback(file_paste, XmNactivateCallback, MenuCallback,
						(XtPointer) FILE_MENU_PASTE);
//  XtVaSetValues(file_paste, XmNlabelString, XmStringCreateLocalized("Paste"),
//		NULL);

	XmStringFree(paste_str);
	XmStringFree(paste_as);


	n=0;
	XtSetArg(args[n], XmNlabelString, delete_str);
	n++;
/*	XtSetArg(args[n], XmNacceleratorText, cut_as);
	n++;
	XtSetArg(args[n], XmNaccelerator, "Ctrl<Key>x");
	n++;*/
	XtSetArg(args[n], XmNmnemonic, 'D');
	n++;
	XtSetArg(args[n], XmNuserData, (XtPointer) IbPtr);
	n++;

//  file_delete = XtVaCreateManagedWidget("file_delete", xmPushButtonWidgetClass,
//				     edit_pulldown, NULL);
	file_delete = XtCreateManagedWidget("file_delete", xmPushButtonWidgetClass,
										edit_pulldown, args, n);
	XtAddCallback(file_delete, XmNactivateCallback, MenuCallback,
					(XtPointer) FILE_MENU_DELETE);
//  XtVaSetValues(file_delete, XmNlabelString, XmStringCreateLocalized("Delete"),
//		NULL);
	XmStringFree(delete_str);

	n=0;
	XtSetArg(args[n], XmNlabelString, info_str);
	n++;
	XtSetArg(args[n], XmNacceleratorText, info_as);
	n++;
	XtSetArg(args[n], XmNaccelerator, "Ctrl<Key>i");
	n++;
	XtSetArg(args[n], XmNmnemonic, 'I');
	n++;
	XtSetArg(args[n], XmNuserData, (XtPointer) IbPtr);
	n++;


//  file_delete = XtVaCreateManagedWidget("file_delete", xmPushButtonWidgetClass,
//				     edit_pulldown, NULL);


	file_info = XtCreateManagedWidget("file_info", xmPushButtonWidgetClass,
									edit_pulldown, args, n);
	XtAddCallback(file_info, XmNactivateCallback, MenuCallback,
				(XtPointer) FILE_MENU_INFO);
//  XtVaSetValues(file_info, XmNlabelString, XmStringCreateLocalized("Info"),
//		NULL);
	XmStringFree(info_str);
	XmStringFree(info_as);

/****************/  

	option_pulldown = XmCreatePulldownMenu(menubar_widget, "option_pulldown", NULL, 0);

	
	label_str = XmStringCreateLocalized ("Option");

	n = 0;
	XtSetArg (args[n], XmNmnemonic, 'O'); n++;
	XtSetArg (args[n], XmNlabelString, label_str); n++;
	XtSetArg (args[n], XmNsubMenuId, option_pulldown); n++;
	option_cascade = XmCreateCascadeButton (menubar_widget, "Option", args, n);
	XtManageChild (option_cascade);
	XmStringFree (label_str);

  
	view_pulldown = XmCreatePulldownMenu(option_pulldown, "view_pulldown", NULL, 0);
//  printf("Pulldown created\n");

	IbPtr->view_pulldown = view_pulldown;

	label_str = XmStringCreateLocalized ("View");
	n = 0;
//  XtSetArg (args[n], XmNmnemonic, 'O'); n++;
	XtSetArg (args[n], XmNlabelString, label_str); n++;
	XtSetArg (args[n], XmNsubMenuId, view_pulldown); n++;
	view_cascade = XmCreateCascadeButton (option_pulldown, "View", args, n);
	XtManageChild (view_cascade);
	XmStringFree (label_str);
//    printf("Cascade created\n");

	large_bt = XmCreateToggleButton(view_pulldown, "LargeView",
			       NULL, 0);
	label_str = XmStringCreateLocalized ("LargeView");
	XtVaSetValues(large_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmONE_OF_MANY_ROUND,
				XmNlabelType, XmSTRING,
    			XmNlabelString, label_str,
//				XmNuserData, &ToggleButtonState,
				XmNuserData, (XtPointer) IbPtr,
				NULL);
	XmStringFree(label_str);
  
	XtAddCallback(large_bt, XmNvalueChangedCallback, ChangeViewCallback,
			(XtPointer) OPTION_LARGE);
//  printf("Large created\n");

	small_bt = XmCreateToggleButton(view_pulldown, "SmallView",
			       NULL, 0);
	label_str = XmStringCreateLocalized ("SmallView");
	XtVaSetValues(small_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmONE_OF_MANY_ROUND,
				XmNlabelType, XmSTRING,
    			XmNlabelString, label_str,
//				XmNuserData, &ToggleButtonState,
				XmNuserData, (XtPointer) IbPtr,
				NULL);
	XmStringFree (label_str);
  
	XtAddCallback(small_bt, XmNvalueChangedCallback, ChangeViewCallback,
				(XtPointer) OPTION_SMALL);

//  printf("Small created\n");

	detail_bt = XmCreateToggleButton(view_pulldown, "DetailView",
									NULL, 0);
	XtVaSetValues(detail_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmONE_OF_MANY_ROUND,
//				XmNuserData, ToggleButtonState,
				XmNuserData, (XtPointer) IbPtr,
				NULL);
	XtAddCallback(detail_bt, XmNvalueChangedCallback, ChangeViewCallback,
				(XtPointer) OPTION_DETAIL);
//    printf("Detail created\n");


	IbPtr->small_bt = small_bt;
	IbPtr->large_bt = large_bt;
	IbPtr->detail_bt = detail_bt;

	XtManageChild (large_bt);
	XtManageChild (small_bt);
	XtManageChild (detail_bt);
//  printf("View created\n");
	InitializeViewSwitch(large_bt, small_bt, detail_bt);
//  printf("View inited\n");

					
/*  large_bt = XtVaCreateManagedWidget("large_bt", xmPushButtonWidgetClass,
				     view_pulldown, NULL);
  XtVaSetValues(large_bt, XmNlabelString, XmStringCreateLocalized("LargeView"),
		NULL);
  detail_bt = XtVaCreateManagedWidget("detail_bt", xmPushButtonWidgetClass,
				     view_pulldown, NULL);
  XtVaSetValues(detail_bt, XmNlabelString, XmStringCreateLocalized("DetailView"),
		NULL);*/
/**************/
	show_pulldown = XmCreatePulldownMenu(option_pulldown, "show_pulldown", NULL, 0);
//  printf("Pulldown created\n");

	IbPtr->show_pulldown = show_pulldown;

	label_str = XmStringCreateLocalized ("Show");
	n = 0;
//  XtSetArg (args[n], XmNmnemonic, 'O'); n++;
	XtSetArg (args[n], XmNlabelString, label_str); n++;
	XtSetArg (args[n], XmNsubMenuId, show_pulldown); n++;
	view_cascade = XmCreateCascadeButton (option_pulldown, "Show", args, n);
	XtManageChild (view_cascade);
	XmStringFree (label_str);
//    printf("Cascade created\n");

	IbPtr->hid_dir_bt = XmCreateToggleButton(show_pulldown, "Hidden Dirs",
			       NULL, 0);
	label_str = XmStringCreateLocalized ("Hidden Dirs");
	XtVaSetValues(IbPtr->hid_dir_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmN_OF_MANY,
				XmNindicatorOn, XmINDICATOR_CHECK_BOX,
				XmNlabelType, XmSTRING,
    			XmNlabelString, label_str,
				XmNvisibleWhenOff, True,
//				XmNuserData, &ToggleButtonState,
				XmNuserData, (XtPointer) IbPtr,
				NULL);
	XmStringFree(label_str);
  
	XtAddCallback(IbPtr->hid_dir_bt, XmNvalueChangedCallback, ChangeShowCallback,
			(XtPointer) OPTION_HIDDEN_DIR);
//  printf("Large created\n");

	IbPtr->hid_file_bt = XmCreateToggleButton(show_pulldown, "Hidden Files",
			       NULL, 0);
	label_str = XmStringCreateLocalized ("Hidden Files");
	XtVaSetValues(IbPtr->hid_file_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmN_OF_MANY,
				XmNindicatorOn, XmINDICATOR_CHECK_BOX,
				XmNlabelType, XmSTRING,
    			XmNlabelString, label_str,
				XmNvisibleWhenOff, True,
//				XmNuserData, &ToggleButtonState,
				XmNuserData, (XtPointer) IbPtr,
				NULL);
	XmStringFree (label_str);
  
	XtAddCallback(IbPtr->hid_file_bt, XmNvalueChangedCallback, ChangeShowCallback,
				(XtPointer) OPTION_HIDDEN_FILE);

//  printf("Small created\n");

	IbPtr->par_dir_bt = XmCreateToggleButton(show_pulldown, "Parent Dir",
									NULL, 0);
	XtVaSetValues(IbPtr->par_dir_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmN_OF_MANY,
				XmNindicatorOn, XmINDICATOR_CHECK_BOX,
				XmNvisibleWhenOff, True,
//				XmNuserData, ToggleButtonState,
				XmNuserData, (XtPointer) IbPtr,
				NULL);
	XtAddCallback(IbPtr->par_dir_bt, XmNvalueChangedCallback, ChangeShowCallback,
				(XtPointer) OPTION_PARENT_DIR);
//    printf("Detail created\n");

	IbPtr->cur_dir_bt = XmCreateToggleButton(show_pulldown, "Current Dir",
									NULL, 0);
	XtVaSetValues(IbPtr->cur_dir_bt,
  				XmNtoggleMode, XmTOGGLE_BOOLEAN,
				XmNindicatorType, XmN_OF_MANY,
//				XmNindicatorOn, XmINDICATOR_CROSS,
				XmNindicatorOn, XmINDICATOR_CHECK_BOX,
				XmNvisibleWhenOff, True,
//				XmNuserData, ToggleButtonState,
				XmNuserData, (XtPointer) IbPtr,
				NULL);
	XtAddCallback(IbPtr->cur_dir_bt, XmNvalueChangedCallback, ChangeShowCallback,
				(XtPointer) OPTION_CURRENT_DIR);
//    printf("Detail created\n");


	XtManageChild (IbPtr->hid_file_bt);
	XtManageChild (IbPtr->hid_dir_bt);
	XtManageChild (IbPtr->par_dir_bt);
	XtManageChild (IbPtr->cur_dir_bt);
//  printf("View created\n");
	InitializeShowSwitch(IbPtr);

	save_setting = XtVaCreateManagedWidget("save_setting", xmPushButtonWidgetClass,
										option_pulldown, NULL);
	XtAddCallback(save_setting, XmNactivateCallback, MenuCallback,
					(XtPointer) OPTION_MENU_SAVE);
	XtVaSetValues(save_setting, XmNlabelString, XmStringCreateLocalized("Save current setting"),
					XmNuserData, (XtPointer) IbPtr, NULL);

/**************/
/*  share_pulldown = XmCreatePulldownMenu(menubar_widget, "share_pulldown", NULL, 0);
  smb_share = XtVaCreateManagedWidget("share_smb_addshare", 
				      xmPushButtonWidgetClass,
				      share_pulldown, NULL);
  XtAddCallback(smb_share, XmNactivateCallback, MenuCallback, 
		(XtPointer) SHARE_SMB_ADDSHARE);
  XtVaSetValues(smb_share, XmNlabelString, 
		XmStringCreateSimple("Add SMB share"), NULL);
  smb_listshares = XtVaCreateManagedWidget("share_smb_listshares", 
					   xmPushButtonWidgetClass,
					   share_pulldown, NULL);
  XtAddCallback(smb_listshares, XmNactivateCallback, MenuCallback,
		(XtPointer) SHARE_SMB_LISTSHARES);
  XtVaSetValues(smb_listshares, XmNlabelString, 
		XmStringCreateSimple("List SMB shares"), NULL);
  smb_separator = XtVaCreateManagedWidget("share_sep_1",
					 xmSeparatorWidgetClass,
					 share_pulldown, NULL);
  smb_config = XtVaCreateManagedWidget("share_smb_config", 
				       xmPushButtonWidgetClass,
				       share_pulldown, NULL);
  XtAddCallback(smb_config, XmNactivateCallback, MenuCallback, 
		(XtPointer) SHARE_SMB_CONFIG);
  XtVaSetValues(smb_config, XmNlabelString, 
		XmStringCreateSimple("SMB Server..."), NULL);
  share_nfs = XtVaCreateManagedWidget("share_nfs_config", 
				      xmPushButtonWidgetClass,
				      share_pulldown, NULL);
  XtAddCallback(share_nfs, XmNactivateCallback, MenuCallback, 
		(XtPointer) SHARE_NFS_CONFIG);
  XtVaSetValues(share_nfs, XmNlabelString, 
		XmStringCreateSimple("NFS Server..."), NULL);*/

/*************************/
  
  /*toolbar_pulldown = XmCreatePulldownMenu(menubar_widget, "toolbar_pulldown", NULL, 0);
  toolbar_add = XtVaCreateManagedWidget("toolbar_add", xmPushButtonWidgetClass,
					toolbar_pulldown, NULL);
  XtAddCallback(toolbar_add, XmNactivateCallback, MenuCallback,
		(XtPointer) TOOLBAR_MENU_ADD);
  XtVaSetValues(toolbar_add, XmNlabelString,
		XmStringCreateSimple("Add item"), NULL);
  toolbar_remove = XtVaCreateManagedWidget("toolbar_remove", xmPushButtonWidgetClass,
					toolbar_pulldown, NULL);
  XtAddCallback(toolbar_remove, XmNactivateCallback, MenuCallback,
		(XtPointer) TOOLBAR_MENU_REMOVE);
  XtVaSetValues(toolbar_remove, XmNlabelString,
		XmStringCreateSimple("Remove item..."), NULL);*/

/****************/  
  
	help_pulldown = XmCreatePulldownMenu(menubar_widget, "help_pulldown", NULL, 0);

	label_str = XmStringCreateLocalized ("Help");
	n = 0;
	XtSetArg (args[n], XmNmnemonic, 'H'); n++;
	XtSetArg (args[n], XmNlabelString, label_str); n++;
	XtSetArg (args[n], XmNsubMenuId, help_pulldown); n++;
	help_cascade = XmCreateCascadeButton (menubar_widget, "Help", args, n);
	XtManageChild (help_cascade);
	XmStringFree (label_str);
  
	help_general = XtVaCreateManagedWidget("help_general", 
					 xmPushButtonWidgetClass,
					 help_pulldown, NULL);
	XtAddCallback(help_general, XmNactivateCallback, MenuCallback,
		(XtPointer) HELP_MENU_GENERAL);
	XtVaSetValues(help_general, XmNlabelString,
		XmStringCreateLocalized("General Help"), XmNuserData, (XtPointer) IbPtr, NULL);
  /*  help_index = XtVaCreateManagedWidget("help_index", xmPushButtonWidgetClass,
				       help_pulldown, NULL);
  XtAddCallback(help_index, XmNactivateCallback, MenuCallback,
		(XtPointer) HELP_MENU_INDEX);
  XtVaSetValues(help_index, XmNlabelString,
		XmStringCreateSimple("Index"), NULL); */
	help_sep = XtVaCreateManagedWidget("help_sep", xmSeparatorWidgetClass,
				     help_pulldown, NULL);
	help_about = XtVaCreateManagedWidget("help_about", xmPushButtonWidgetClass,
				       help_pulldown, NULL);
	XtAddCallback(help_about, XmNactivateCallback, MenuCallback,
		(XtPointer) HELP_MENU_ABOUT);
	XtVaSetValues(help_about, XmNlabelString,
		XmStringCreateLocalized("About..."), XmNuserData, (XtPointer) IbPtr, NULL);

//  XtVaCreateManagedWidget("File", xmCascadeButtonWidgetClass, menubar_widget,
//			  XmNsubMenuId, file_pulldown, NULL);
//  XtVaCreateManagedWidget("Directory", xmCascadeButtonWidgetClass, 
//			  menubar_widget, XmNsubMenuId, dir_pulldown, NULL);
  /* We went through all that work to make the 'Share' pulldown, but only
   * root can use it, so don't display it for anyone else */
//  if (local_uid == 0 && local_gid ==0)
//    XtVaCreateManagedWidget("Share", xmCascadeButtonWidgetClass, 
//			    menubar_widget, XmNsubMenuId, share_pulldown, 
//			    NULL);
  /*  XtVaCreateManagedWidget("Applications", xmCascadeButtonWidgetClass,
			  menubar_widget, XmNsubMenuId, toolbar_pulldown,
			  NULL); */

//  help_button = XtVaCreateManagedWidget("Help", xmCascadeButtonWidgetClass,
//					menubar_widget, XmNsubMenuId,
//					help_pulldown, NULL);

	XtVaSetValues(menubar_widget, XmNmenuHelpWidget, help_cascade, NULL);

	return(menubar_widget);
}
