/* main.c -- Main function for Bryan's NEW file manager.
 *
 * Last revised:
 * Written by Bryan Herger
 *
 * Distributed under GNU Public License; see LICENSE for details
 */

#include <Xm/Xm.h>
#include <Xm/XmP.h>
#include <Xm/PushB.h>
#include <Xm/Container.h>
#include <Xm/IconG.h>
#include <Xm/ScrolledW.h>
#include <Xm/Form.h>
#include <Xm/TextF.h>
#include <Xm/AtomMgr.h>
#include <Xm/DragDrop.h>
#include <X11/Xos.h>
#include <Xm/MainW.h>
#include <Xm/Protocols.h>
#include <Xm/Label.h>
#include <Xm/DrawP.h>

#include <X11/xpm.h>

#include <dirent.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pthread.h>

#include "core.h"
#include "findfile.h"
#include "getdir.h"
#include "openfile.h"
#include "menubars.h"
#include "filearea.h"
#include "selection.h"
#include "permission.h"
#include "smbconfig.h"
#include "errormsg.h"
//#include "magic.h"
//#include "ftype.h"

#include "XmNl/XmNlPartRes.h"
#include "XmNl/XmNlResColList.h"
#include "XmNl/XmNlList.h"
#include "XmNl/XmNlItemBox.h"
#include "defines.h"


const char PredefinedTerminalString[] = "xterm";

extern int parse_config_start(char * fname);
extern bxfm_ftype ** ftype_list;
extern int count_all;
extern int count_current;
extern char * path_magic_file;
extern char * path_icons_set;
extern char * show_hidden_dir;
extern char * show_hidden_file;
extern char * show_parent_dir;
extern char * show_current_dir;
extern char * terminal_command;

extern alter_action * alter_action_list;
extern int alter_count_all;
extern int alter_count_current;

extern ext_ftype ** ext_ftype_list;
extern int ext_count_all;
extern int ext_count_current;

extern void InitCheckMoveArr(void);


void magic_parse_file(char * );
void magic_detach(void);


#ifdef USE_INOTIFY
//extern void InotifyInput(XtPointer client_data, int * fid, XtInputId *id);
extern void * WatchDirThread(void * arg);
#endif

//#define DEBUG 1
//#define DEBUG_WATCH_DIR 1

pthread_mutex_t iface_mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t config_mutex = PTHREAD_MUTEX_INITIALIZER;
int iface_thread_counter = 0;

int x_resources_activated;
int sort_icon_activated;


/* X stuff -- application context and top level shell */
/* Other modules need access to top_level and fm_container */
//XtAppContext app;
//Widget top_level, fm_container, fm_scroll1, fm_textfield;

/* User's home directory */
//char *home_dir;

/* User's UID and GID (Are you root?) */
//uid_t local_uid;
//gid_t local_gid;

/* Default resources -- no more app-defaults file */
char * fallback_resources[] = {
"XmBryanFM*fontList: -*-dejavu sans-bold-r-*-*-*-*-*-*-*-*-iso10646-*:",
"XmBryanFM*SMB_page*fontList: -*-helvetica-bold-r-*-*-12-*-*-*-*-*-*-*",
"XmBryanFM*ghelp*fontList: -*-helvetica-medium-r-*-*-14-*-*-*-*-*-*-*",
"XmBryanFM*fm_textfield*background: white",
"XmBryanFM*fm_textfield*foreground: black",
"XmBryanFM*fm_container*background: white",
"XmBryanFM*fm_container*foreground: black",
"XmBryanFM*source_tf*background: white",
"XmBryanFM*dest_tf*background: white",
"XmBryanFM*smb_g_t1*background: white",
"XmBryanFM*smb_add*background: white",
"XmBryanFM*smb_list*background: white",
"XmBryanFM*goto_tf*background: white",
"XmBryanFM*dir_c_tf*background: white",
"XmBryanFM*find_tf*background: white",
"XmBryanFM*f_slist*background: white",
"XmBryanFM*ghelp*background: white",
NULL};

void StartDrag(Widget, XEvent *, String *, Cardinal *);

/* translations and actions. Pressing mouse button 2 calls
** StartDrag to start a drag transaction
*/

static char dragTranslations[] = "<Btn2Down>: StartDrag()";
static XtActionsRec dragActions[] = {{"StartDrag", (XtActionProc) StartDrag}};


extern int CurrentViewType;

/* Atoms  */

Atom COPY_ATOM;
Atom FILE_NAME;
Atom WM_DELETE_WINDOW;
Atom UTF8_STRING;

void RemoveIfaceBranche(IfaceBranche * ptr)
{

	if (ptr->current_wd) 
		free(ptr->current_wd);
	

	clear_dir_list(ptr);
/*	for (i = 0; i < ptr->fileptr; i++)
	{
		free(files[i].name);
		if (files[i].info)
		{
			if (files[i].info->f_size) free(files[i].info->f_size);
			if (files[i].info->f_date) free (files[i].info->f_date);
			if (files[i].info->f_perm) free (files[i].info->f_perm);
		}
    }*/
	if (ptr->file_list)
		free(ptr->file_list);

#ifdef	USE_INOTIFY
	pthread_mutex_destroy(&(ptr->branch_mutex));
#endif

	return ;
}

IfaceBranche * StartNewIfaceBranche(const char * start_here)
{
	IfaceBranche * ptr, * ptr2 ;
	static int th_counter = 1;
	
	ptr = calloc(1, sizeof(IfaceBranche));
	if (!ptr)
		return ptr;

	ptr->next_branche = NULL;
//	ptr->CurrentViewType = LARGE_VIEW;
	ptr->CurrentViewType = DETAIL_VIEW;
	ptr->DropSiteRegisterNeedIbox = 1;
	ptr->DropSiteRegisterNeedDeatail = 1;
	ptr->HlgCallbackAttached = 0;
	ptr->current_wd = strdup(start_here);
//	ptr->nfiles = 100;
	ptr->thread_number = th_counter;
	ptr->first_time = 1;
	ptr->view_closed = 0;

	ptr->CaseSensitiveSorting = CaseSensitiveSorting;
	ptr->HiddenFileShow = HiddenFileShow;
	ptr->HiddenDirShow = HiddenDirShow;
	ptr->ParentDirShow = ParentDirShow;
	ptr->CurrentDirShow = CurrentDirShow;
	
	ptr->SortingCategory = SORTING_NAME;
	ptr->SortingType = SORTING_ASCEND;

	ptr->DialPixLarge = XmUNSPECIFIED_PIXMAP;
	ptr->DialPixSmall = XmUNSPECIFIED_PIXMAP;

#ifdef	USE_INOTIFY
	pthread_mutex_init(&(ptr->branch_mutex), NULL);
#endif
	th_counter++;

//	sem_init(&(ptr->files_sem), 0, 0);

	iface_thread_counter++;

	if (!AllIfaceBranches)
	{
		AllIfaceBranches = ptr;
		return ptr;
	}
	else
	{
		ptr2 = AllIfaceBranches;
		while(ptr2->next_branche)
		{
			ptr2 = ptr2->next_branche;
		}
		ptr2->next_branche = ptr;
		return ptr;
	}
	return ptr;
}

void CleanIconsSet2(Display * dpy)
{
	int i;
	appPixmapList *apPtr;
			
	if (!icon_loaded)
		return ;

	apPtr = globalPixmapList;
	
	if (!apPtr)
		return ;
			
	while(apPtr)
	{
		if (apPtr->icon > XmUNSPECIFIED_PIXMAP)
		{
#ifdef DEBUG
			printf("Free icon %s %lx %lx\n", apPtr->name, apPtr->icon, apPtr->mask);
#endif
			XFreePixmap(dpy, apPtr->icon);
		}
		
		if (apPtr->mask > XmUNSPECIFIED_PIXMAP)
			XFreePixmap(dpy, apPtr->mask);
			
		apPtr = apPtr->next;
	}

	icon_loaded = 0;


/*
	if (icon_loaded)
	{
		for (i = 0; i < count_current; i++)
		{
			if ((ftype_list[i])->big_pixmap >= XmUNSPECIFIED_PIXMAP)
				XFreePixmap(dpy, (ftype_list[i])->big_pixmap);
				
			if ((ftype_list[i])->big_icon_name)
				printf("Free big icon %s\n", (ftype_list[i])->big_icon_name);


			if ((ftype_list[i])->big_mask >= XmUNSPECIFIED_PIXMAP)
				XFreePixmap(dpy, (ftype_list[i])->big_mask);
						
			if ((ftype_list[i])->small_pixmap >= XmUNSPECIFIED_PIXMAP)
				XFreePixmap(dpy, (ftype_list[i])->small_pixmap);
				
			if ((ftype_list[i])->small_icon_name)
				printf("Free small icon %s\n", (ftype_list[i])->small_icon_name);

			if ((ftype_list[i])->small_mask >= XmUNSPECIFIED_PIXMAP)
				XFreePixmap(dpy, (ftype_list[i])->small_mask);
		}
		icon_loaded = 0;
	}	
*/ 
}

void CloseWindowCB (Widget menu_item, XtPointer client_data, XtPointer call_data)
{
	IfaceBranche * IbPtr = (IfaceBranche * ) client_data;
	int window_is_last = 0;

#ifdef DEBUG
	printf("--------CloseWindowCB %d\n", IbPtr->copy_move_thread_count);
#endif
	{
		char cc;
		XtVaGetValues(IbPtr->top_level, XmNdeleteResponse, &cc, NULL);
#ifdef DEBUG
		if (cc == XmDO_NOTHING)
			printf("Mode no\n");
		else 
			printf("Mode yes\n");
#endif
	}

	if (IbPtr->copy_move_thread_count)
	{
#ifdef DEBUG
		printf("--------CloseCB start dialog\n");
#endif
		ConfirmCloseDialog(IbPtr);
		return;
	}
		

	pthread_mutex_lock(&iface_mutex);
	if (iface_thread_counter == 1)
		window_is_last = 1;
	else
		iface_thread_counter--;
	pthread_mutex_unlock(&iface_mutex);
		
	if (window_is_last)
	{
		ConfirmCloseDialog2(IbPtr);
		return ;
	}
	
	if (IbPtr->DialPixLarge > XmUNSPECIFIED_PIXMAP)
	{
		XFreePixmap(XtDisplay(IbPtr->top_level), IbPtr->DialPixLarge);
		IbPtr->DialPixLarge = XmUNSPECIFIED_PIXMAP;
	}
		
	if (IbPtr->DialPixSmall > XmUNSPECIFIED_PIXMAP)
	{
		XFreePixmap(XtDisplay(IbPtr->top_level), IbPtr->DialPixSmall);
		IbPtr->DialPixSmall = XmUNSPECIFIED_PIXMAP;
	}
	
		
#ifdef USE_INOTIFY
		PutWatchCommand(IbPtr, COMMAND_DETACH_IFACE);
#endif
	XtAppSetExitFlag(IbPtr->app);
#ifdef DEBUG
	printf("Exit flag set \n");
#endif
	return ;
}


static void CreateIconsSet3(Display * dpy)
{
	char * config_fn = NULL, * ptr;
	appPixmapList *apPtr;
	int len = 0;

#ifdef DEBUG
	printf("CreateIconsSet3\n");
#endif

	apPtr = buildingIconNode;
	
	if (!apPtr)
	{
		fullIconComplect = 1;
		needAddIconToGlobalList = 0;
		return ;
	}
		
	if (apPtr->used == ICON_NODE_INITED || apPtr->icon > XmUNSPECIFIED_PIXMAP)
	{
		buildingIconNode = apPtr->next;
		return ;
	}

	if (NormalIconsSetPath[0] != 0)
	{
		len = strlen(NormalIconsSetPath) + 512;
		config_fn = calloc(len, sizeof(char));
	}
	else
		config_fn = NULL;

#ifdef DEBUG
		printf("Path to icon set %s\n", config_fn);
#endif

	if (config_fn)
	{
		strcpy(config_fn, NormalIconsSetPath);
		strcat(config_fn, apPtr->name);
#ifdef DEBUG
		printf("Icon = %s\n", config_fn);
#endif

		XpmReadFileToPixmap(dpy, DefaultRootWindow(dpy),
							config_fn, &(apPtr->icon), &(apPtr->mask), NULL);

#ifdef DEBUG
		printf("++++++> added %s %lx\n", apPtr->name, apPtr->icon);
#endif
		if (config_fn) free(config_fn);

		apPtr->used = ICON_NODE_INITED;
	}
	buildingIconNode = apPtr->next;
	return ;
}

void CreateIconsSet2(Display * dpy)
{
	char * config_fn = NULL, * ptr;
	int n, i, len;
	Window root;
	int x, y;
	unsigned int width, height, bw, depth;
	appPixmapList *apPtr;
	int bigFound, smallFound;
	
	if (!icon_loaded)
	{
		i = count_current - 1;
		if (NormalIconsSetPath[0] != 0)
		{
			len = strlen(NormalIconsSetPath) + 512;
			config_fn = calloc(len, sizeof(char));
		}
		else
			config_fn = NULL;

		while (i >= 0)
		{
			apPtr = globalPixmapList;
			bigFound = 0;
			smallFound = 0;
#ifdef DEBUG
			printf("Big name %s small name %s\n", 
					(ftype_list[i])->big_icon_name, (ftype_list[i])->small_icon_name);
#endif
			while(apPtr)
			{
				if ((ftype_list[i])->big_icon_name && (0 == strcmp(apPtr->name, (ftype_list[i])->big_icon_name)))
				{
					if (apPtr->used == ICON_NODE_NOT_INITED)
					{
						memset(config_fn, 0, len);
						strcpy(config_fn, NormalIconsSetPath);

						strcat(config_fn, (ftype_list[i])->big_icon_name);
#ifdef DEBUG
						printf("Big icon = %s\n", config_fn);
#endif
						XpmReadFileToPixmap(dpy, DefaultRootWindow(dpy),
											config_fn, &((ftype_list[i])->big_pixmap), &((ftype_list[i])->big_mask), NULL);

#ifdef DEBUG
						printf("big icon = %lx %lx %s\n", 
								(ftype_list[i])->big_pixmap, (ftype_list[i])->big_mask, config_fn);
#endif

						apPtr->icon = (ftype_list[i])->big_pixmap;
						apPtr->mask = (ftype_list[i])->big_mask;
						
						apPtr->used = ICON_NODE_INITED;
					}
					else
					{
						(ftype_list[i])->big_pixmap = apPtr->icon;
						(ftype_list[i])->big_mask = apPtr->mask;
					}
					bigFound = 1;
#ifdef DEBUG
					printf("-------> found %s\n", apPtr->name);
#endif
				}
				if ((ftype_list[i])->small_icon_name && (0 == strcmp(apPtr->name, (ftype_list[i])->small_icon_name)))
				{
					if (apPtr->used == ICON_NODE_NOT_INITED)
					{
						memset(config_fn, 0, len);
						strcpy(config_fn, NormalIconsSetPath);
						strcat(config_fn, (ftype_list[i])->small_icon_name);
#ifdef DEBUG
						printf("Small icon = %s\n", config_fn);
#endif
						XpmReadFileToPixmap(dpy, DefaultRootWindow(dpy),
											config_fn, &((ftype_list[i])->small_pixmap), &((ftype_list[i])->small_mask), NULL);
#ifdef DEBUG
						printf("Small icon = %lx %lx %s\n", (ftype_list[i])->small_pixmap, (ftype_list[i])->small_mask, config_fn);
#endif

						apPtr->icon = (ftype_list[i])->small_pixmap;
						apPtr->mask = (ftype_list[i])->small_mask;

						apPtr->used = ICON_NODE_INITED;
					}
					else
					{
						(ftype_list[i])->small_pixmap = apPtr->icon;
						(ftype_list[i])->small_mask = apPtr->mask;
					}
					smallFound = 1;
#ifdef DEBUG
					printf("-------> found %s\n", apPtr->name);
#endif
				}
				
				if (bigFound && smallFound)
					break;
					
				apPtr = apPtr->next;
			}

			if (!bigFound)
			{
				(ftype_list[i])->big_pixmap = XmUNSPECIFIED_PIXMAP;
				(ftype_list[i])->big_mask = XmUNSPECIFIED_PIXMAP;
			}
			if (!smallFound)
			{
				(ftype_list[i])->small_pixmap = XmUNSPECIFIED_PIXMAP;
				(ftype_list[i])->small_mask = XmUNSPECIFIED_PIXMAP;
			}


#ifdef DEBUG
			printf("Magic = %s\t%lx\t%lx\n", (ftype_list[i])->magic,  
				(ftype_list[i])->big_pixmap, (ftype_list[i])->small_pixmap); 
#endif
			i--;
		}
#ifdef DEBUG
		printf("All icons from config OK\n");
#endif
		icon_loaded = 1;
		if (config_fn) free(config_fn);
	}	
}

int glob_argc;
char **glob_argv;

/*
void CleanSortIconsSet(Display * dpy)
{
	if (sort_icon_activated)
	{
		XFreePixmap(dpy, upSortIcon);
		XFreePixmap(dpy, downSortIcon);
		
		sort_icon_activated = 0;
	}
}
*/

void CreateSortIcons(Widget w, Pixel background_pixel, Pixel top_pixel, Pixel bottom_pixel, unsigned int height, Dimension thickness)
{
	XGCValues values;
	unsigned long mask;
	GC fillGC, bottomGC, topGC, maskGC;
	XPoint xpt1[4], xpt2[4], xpt3[4];

	values.foreground = background_pixel;

	mask = GCForeground ;
	fillGC = XCreateGC(XtDisplay(w), XRootWindowOfScreen(XtScreen(w)), mask, &values);

	values.background = background_pixel;
	values.foreground = top_pixel;

	mask = GCForeground | GCBackground;
	topGC = XCreateGC(XtDisplay(w), XRootWindowOfScreen(XtScreen(w)), mask, &values);

	values.background = background_pixel;
	values.foreground = bottom_pixel;

	mask = GCForeground | GCBackground;
	bottomGC = XCreateGC(XtDisplay(w), XRootWindowOfScreen(XtScreen(w)), mask, &values);


	upSortIcon = XCreatePixmap(XtDisplay(w), DefaultRootWindow(XtDisplay(w)), 
								height, height, DefaultDepthOfScreen(XtScreen(w)));
	upSortMask = XCreatePixmap(XtDisplay(w), DefaultRootWindow(XtDisplay(w)), 
								height, height, 1);
	downSortIcon = XCreatePixmap(XtDisplay(w), DefaultRootWindow(XtDisplay(w)), 
								height, height, DefaultDepthOfScreen(XtScreen(w)));
	downSortMask = XCreatePixmap(XtDisplay(w), DefaultRootWindow(XtDisplay(w)), 
								height, height, 1);


	values.function = GXcopy;
	values.foreground = BlackPixelOfScreen(XtScreen(w));
	mask = GCForeground | GCFunction;

	maskGC = XCreateGC(XtDisplay(w), upSortMask, mask, &values);

	XFillRectangle(XtDisplay(w), upSortMask, maskGC, 0, 0, height, height);	
	XFillRectangle(XtDisplay(w), downSortMask, maskGC, 0, 0, height, height);	


	XFillRectangle(XtDisplay(w), upSortIcon, fillGC, 0, 0, height, height);	
	XFillRectangle(XtDisplay(w), downSortIcon, fillGC, 0, 0, height, height);	

	values.function = GXinvert;
	mask = GCFunction;
	XChangeGC(XtDisplay(w), maskGC, mask, &values);

/* Up line */

	xpt1[0].x = 1;
	xpt1[0].y = 1;
	xpt1[1].x = height - 1;
	xpt1[1].y = 1;
	xpt1[2].x = height - 1 - thickness;
	xpt1[2].y = 1 + thickness;
	xpt1[3].x = 1 + thickness;
	xpt1[3].y = 1 + thickness;

/* Top left to bottom center line */

	xpt2[0].x = 1;
	xpt2[0].y = 1;
	xpt2[1].x = 1 + thickness;
	xpt2[1].y = 1 + thickness;
	xpt2[2].x = height/2;
	xpt2[2].y = height - 1 - thickness;
	xpt2[3].x = height/2;
	xpt2[3].y = height - 1;

/* Top right to bottom center line */

	xpt3[0].x = height - 1;
	xpt3[0].y = 1;
	xpt3[1].x = height/2;
	xpt3[1].y = height - 1;
	xpt3[2].x = height/2;
	xpt3[2].y = height - 1 - thickness;
	xpt3[3].x = height - 1 - thickness;
	xpt3[3].y = 1 + thickness;

	XFillPolygon(XtDisplay(w), downSortMask, maskGC, xpt1, 4, Nonconvex, CoordModeOrigin);
	XFillPolygon(XtDisplay(w), downSortMask, maskGC, xpt2, 4, Nonconvex, CoordModeOrigin);
	XFillPolygon(XtDisplay(w), downSortMask, maskGC, xpt3, 4, Nonconvex, CoordModeOrigin);

	XFillPolygon(XtDisplay(w), downSortIcon, bottomGC, xpt1, 4, Nonconvex, CoordModeOrigin);
	XFillPolygon(XtDisplay(w), downSortIcon, bottomGC, xpt2, 4, Nonconvex, CoordModeOrigin);
	XFillPolygon(XtDisplay(w), downSortIcon, topGC, xpt3, 4, Nonconvex, CoordModeOrigin);

/* Bottom line */

	xpt1[0].x = 1;
	xpt1[0].y = height - 1;
	xpt1[1].x = height - 1;
	xpt1[1].y = height - 1;
	xpt1[2].x = height - 1 - thickness;
	xpt1[2].y = height - 1 - thickness;
	xpt1[3].x = 1 + thickness;
	xpt1[3].y = height - 1 - thickness;

/* Bottom left to top center line */

	xpt2[0].x = 1;
	xpt2[0].y = height - 1;
	xpt2[1].x = height/2;
	xpt2[1].y = 1;
	xpt2[2].x = height/2;
	xpt2[2].y = 1 + thickness;
	xpt2[3].x = 1 + thickness;
	xpt2[3].y = height - 1 - thickness;

/* Bottom right to to center line */

	xpt3[0].x = height - 1;
	xpt3[0].y = height - 1;
	xpt3[1].x = height/2;
	xpt3[1].y = 1;
	xpt3[2].x = height/2;
	xpt3[2].y = 1 + thickness;
	xpt3[3].x = height - 1 - thickness;
	xpt3[3].y = height - 1 - thickness;



	XFillPolygon(XtDisplay(w), upSortMask, maskGC, xpt1, 4, Nonconvex, CoordModeOrigin);
	XFillPolygon(XtDisplay(w), upSortMask, maskGC, xpt2, 4, Nonconvex, CoordModeOrigin);
	XFillPolygon(XtDisplay(w), upSortMask, maskGC, xpt3, 4, Nonconvex, CoordModeOrigin);

	XFillPolygon(XtDisplay(w), upSortIcon, topGC, xpt1, 4, Nonconvex, CoordModeOrigin);
	XFillPolygon(XtDisplay(w), upSortIcon, bottomGC, xpt2, 4, Nonconvex, CoordModeOrigin);
	XFillPolygon(XtDisplay(w), upSortIcon, topGC, xpt3, 4, Nonconvex, CoordModeOrigin);

/*	XmeDrawArrow(XtDisplay(w), upSortIcon, bottomGC, topGC, NULL, 0, 0, height, height, thickness, XmARROW_UP);
	XmeDrawArrow(XtDisplay(w), downSortIcon, bottomGC, topGC, NULL, 0, 0, height, height, thickness, XmARROW_DOWN);
*/	
//	XmeDrawArrow(XtDisplay(w), upSortIcon, topGC, bottomGC, NULL, 0, 0, height, height, thickness, XmARROW_UP);
//	XmeDrawArrow(XtDisplay(w), downSortIcon, topGC, bottomGC, NULL, 0, 0, height, height, thickness, XmARROW_DOWN);

	XFreeGC(XtDisplay(w), topGC);
	XFreeGC(XtDisplay(w), bottomGC);
	XFreeGC(XtDisplay(w), fillGC);
	XFreeGC(XtDisplay(w), maskGC);
#ifdef DEBUG
	printf("Created sorting icons %d x %d x %d\n", height, height, thickness);
#endif
}


void CreateSortIconsBack(Widget w, Pixel background_pixel, Pixel top_pixel, Pixel bottom_pixel, unsigned int height, Dimension thickness)
{
	XGCValues values;
	unsigned long mask;
	GC fillGC, bottomGC, topGC;

	values.foreground = background_pixel;

	mask = GCForeground ;
	fillGC = XCreateGC(XtDisplay(w), XRootWindowOfScreen(XtScreen(w)), mask, &values);

	values.background = background_pixel;
	values.foreground = top_pixel;

	mask = GCForeground | GCBackground;
	topGC = XCreateGC(XtDisplay(w), XRootWindowOfScreen(XtScreen(w)), mask, &values);

	values.background = background_pixel;
	values.foreground = bottom_pixel;

	mask = GCForeground | GCBackground;
	bottomGC = XCreateGC(XtDisplay(w), XRootWindowOfScreen(XtScreen(w)), mask, &values);

	upSortIcon = XCreatePixmap(XtDisplay(w), DefaultRootWindow(XtDisplay(w)), 
								height, height, DefaultDepthOfScreen(XtScreen(w)));
	upSortMask = XCreatePixmap(XtDisplay(w), DefaultRootWindow(XtDisplay(w)), 
								height, height, 1);
	downSortIcon = XCreatePixmap(XtDisplay(w), DefaultRootWindow(XtDisplay(w)), 
								height, height, DefaultDepthOfScreen(XtScreen(w)));
	downSortMask = XCreatePixmap(XtDisplay(w), DefaultRootWindow(XtDisplay(w)), 
								height, height, 1);



	XFillRectangle(XtDisplay(w), upSortIcon, fillGC, 0, 0, height, height);	
	XFillRectangle(XtDisplay(w), downSortIcon, fillGC, 0, 0, height, height);	


	XmeDrawArrow(XtDisplay(w), upSortIcon, bottomGC, topGC, NULL, 0, 0, height, height, thickness, XmARROW_UP);
	XmeDrawArrow(XtDisplay(w), downSortIcon, bottomGC, topGC, NULL, 0, 0, height, height, thickness, XmARROW_DOWN);
	
//	XmeDrawArrow(XtDisplay(w), upSortIcon, topGC, bottomGC, NULL, 0, 0, height, height, thickness, XmARROW_UP);
//	XmeDrawArrow(XtDisplay(w), downSortIcon, topGC, bottomGC, NULL, 0, 0, height, height, thickness, XmARROW_DOWN);

	XFreeGC(XtDisplay(w), topGC);
	XFreeGC(XtDisplay(w), bottomGC);
	XFreeGC(XtDisplay(w), fillGC);
#ifdef DEBUG
	printf("Created sorting icons %d x %d x %d\n", height, height, thickness);
#endif
}



void * NewIfaceWindowThread(void * arg)
{
	IfaceBranche * IbPtr;
	char * config_fn, * ptr;
	Arg args[10];
	int n, i;
	Widget form;
	Widget label;
	XmRenderTable listRt;
	Dimension titleHeight, shadowThickness;
	Pixel topShadow, bottomShadow, background_pixel;
	
	IbPtr = (IfaceBranche *) arg;
	
#ifdef DEBUG
	printf("!!!!!!!!Start Iface thread %d on %s address %p pid %d\n", IbPtr->thread_number, IbPtr->current_wd, IbPtr, getpid());
	printf("Id from IbPtr %ld Self Id %ld\n", IbPtr->thread_id, pthread_self());
			if (pthread_equal(IbPtr->thread_id, pthread_self()))
				printf("THREAD OK\n");
			else
				printf("THREAD WRONG\n");
				
#endif
	
//	XtToolkitThreadInitialize();  
//	XtSetLanguageProc(NULL, NULL, NULL);
//	IbPtr->top_level = XtVaAppInitialize(&(IbPtr->app), "XmBryanFM", NULL, 0, NULL, 0,
//				NULL, NULL, 0);

	
	IbPtr->top_level = XtVaOpenApplication (&(IbPtr->app), "XmBryanFM", NULL, 0, &glob_argc, glob_argv,
								NULL, sessionShellWidgetClass, NULL);
#ifdef DEBUG
	printf("Init app\n");
#endif


	XtVaSetValues(IbPtr->top_level, XmNdeleteResponse, XmDO_NOTHING, NULL);
	{
		char cc;
		XtVaGetValues(IbPtr->top_level, XmNdeleteResponse, &cc, NULL);
#ifdef DEBUG
		if (cc == XmDO_NOTHING)
			printf("Mode no\n");
		else 
			printf("Mode yes\n");
#endif
	}

	XmAddWMProtocolCallback(IbPtr->top_level, WM_DELETE_WINDOW, CloseWindowCB, (XtPointer) IbPtr);

#ifdef DEBUG
	printf("Init close window callback\n");
#endif


	pthread_mutex_lock(&iface_mutex);

	if (!x_resources_activated)
	{
		XtGetApplicationResources(IbPtr->top_level, &resdata, resources, XtNumber(resources), NULL, 0);

		XmIconTitleString = XmStringCreateLocalized(resdata.IconTitleString);
		
		XmNameTitleString = XmStringCreateLocalized(resdata.NameTitleString);

		XmSizeTitleString = XmStringCreateLocalized(resdata.SizeTitleString);

		XmDateTitleString = XmStringCreateLocalized(resdata.DateTitleString);

		XmPermTitleString = XmStringCreateLocalized(resdata.PermTitleString);

		XmOwnerTitleString = XmStringCreateLocalized(resdata.OwnerTitleString);

		XmOwnergrpTitleString = XmStringCreateLocalized(resdata.OwnergrpTitleString);
		

/*		XmIconTitleString = XmStringCreateLocalized("O");
		
		XmNameTitleString = XmStringCreateLocalized("O");

		XmSizeTitleString = XmStringCreateLocalized("O");

		XmDateTitleString = XmStringCreateLocalized("O");

		XmPermTitleString = XmStringCreateLocalized("O");

		XmOwnerTitleString = XmStringCreateLocalized("O");

		XmOwnergrpTitleString = XmStringCreateLocalized("O");*/

		x_resources_activated = 1;
	}
	pthread_mutex_unlock(&iface_mutex);


/*	if (!icon_loaded)
	{
		i = count_current - 1;
		if (home_dir && path_icons_set) 
			config_fn = calloc(strlen(home_dir) + strlen(path_icons_set) + 512, sizeof(char));

#ifdef DEBUG
		printf("Path to icon set %s\n", config_fn);
#endif

		while (i >= 0)
		{
			if ((ptr = strchr(path_icons_set, '~')) && ptr == &path_icons_set[0]) 
			{
				strcpy(config_fn, home_dir);
				strcat(config_fn, ptr+1);
			}
			else 
				strcpy(config_fn, path_icons_set);
			strcat(config_fn, (ftype_list + i)->big_icon_name);
#ifdef DEBUG
			printf("Big icon = %s\n", config_fn);
#endif
			XpmReadFileToPixmap(XtDisplay(IbPtr->top_level), DefaultRootWindow(XtDisplay(IbPtr->top_level)),
						config_fn, &((ftype_list + i)->big_pixmap), &((ftype_list + i)->big_mask), NULL);
						
			memset(config_fn, 0, strlen(path_icons_set) + 512);
			if ((ptr = strchr(path_icons_set, '~')) && ptr == &path_icons_set[0]) 
			{
				strcpy(config_fn, home_dir);
				strcat(config_fn, ptr+1);
			}
			else 
				strcpy(config_fn, path_icons_set);
			strcat(config_fn, (ftype_list + i)->small_icon_name);
#ifdef DEBUG
			printf("Small icon = %s\n", config_fn);
#endif
			XpmReadFileToPixmap(XtDisplay(IbPtr->top_level), DefaultRootWindow(XtDisplay(IbPtr->top_level)),
						config_fn, &((ftype_list + i)->small_pixmap), &((ftype_list + i)->small_mask), NULL);

			memset(config_fn, 0, strlen(path_icons_set) + 512);
#ifdef DEBUG
			printf("Magic = %s\t%lx\t%lx\n", (ftype_list + i)->magic,  
				(ftype_list + i)->big_pixmap, (ftype_list + i)->small_pixmap); 
#endif
			i--;
		}
#ifdef DEBUG
		printf("All icons from config OK\n");
#endif
		icon_loaded = 1;
		if (config_fn) free(config_fn);
	}
*/

	/* This block of code creates the main application window.  I will eventually
	* move this to an external function.  Eventually... */

	n = 0;
	XtSetArg(args[n], XmNwidth, 600);
	n++;
	XtSetArg(args[n], XmNheight, 450);
	n++;
	IbPtr->fm_main_window = XmCreateMainWindow(IbPtr->top_level, "fm_main_window", args, n);
/*****!!!!!*****/
//	XtAddCallback(IbPtr->fm_main_window, XmNdestroyCallback, MainWinDestroyCB, (XtPointer) NULL);

	XtManageChild(IbPtr->fm_main_window);

#ifdef DEBUG
	printf("Main wondow created\n");
#endif
	IbPtr->fm_menubar = CreateMenuBar(IbPtr);

#ifdef DEBUG
	printf("Menu bar created\n");
#endif

	IbPtr->parsed_trans = XtParseTranslationTable(dragTranslations);
	XtAppAddActions(IbPtr->app, dragActions, XtNumber(dragActions));


	IbPtr->fm_scroll_win = XtVaCreateWidget ("MainView", xmNlListWidgetClass, IbPtr->fm_main_window, 
											XmNuserData, (XtPointer) IbPtr, XmNlAutoAdjustLastCol, True, NULL);

	XtVaGetValues(IbPtr->fm_scroll_win, XmNrenderTable, &listRt, XmNtitleShadowThickness, &shadowThickness, XmNbackground, &background_pixel, NULL);
	
	titleHeight = XmStringHeight(listRt, XmNameTitleString);
	
	
	label = XmNlListGetRCWidget(IbPtr->fm_scroll_win);

	XtVaGetValues(label, XmNtopShadowColor, &topShadow, XmNbottomShadowColor, &bottomShadow, NULL);


	pthread_mutex_lock(&iface_mutex);
	if (!sort_icon_activated)
	{
		CreateSortIcons(IbPtr->fm_scroll_win, background_pixel, topShadow, bottomShadow, titleHeight, shadowThickness);
		sort_icon_activated = 1;
	}
	pthread_mutex_unlock(&iface_mutex);




//	XtAddCallback(IbPtr->fm_scroll_win, XmNdestroyCallback, ScrollWinDestroyCB, (XtPointer) NULL);
	SetFileViewAttributs(IbPtr);
//	IbPtr->menuA = CreateMenuA(IbPtr);

/*	if (!IbPtr->menuA)
		IbPtr->menuA = CreateMenuA(IbPtr, IbPtr->fm_scroll_win);

	if (!IbPtr->menuB)
		IbPtr->menuB = CreateMenuB(IbPtr, IbPtr->fm_scroll_win);

	if (!IbPtr->menuC)
		IbPtr->menuC = CreateMenuC(IbPtr, IbPtr->fm_scroll_win);
*/
	if (!IbPtr->menuAiconbox)
		IbPtr->menuAiconbox = CreateMenuA(IbPtr, XmNlListGetIBWidget(IbPtr->fm_scroll_win));

	if (!IbPtr->menuBiconbox)
		IbPtr->menuBiconbox = CreateMenuB(IbPtr, XmNlListGetIBWidget(IbPtr->fm_scroll_win));

	if (!IbPtr->menuCiconbox)
		IbPtr->menuCiconbox = CreateMenuC(IbPtr, XmNlListGetIBWidget(IbPtr->fm_scroll_win));

	if (!IbPtr->menuAdetail)
		IbPtr->menuAdetail = CreateMenuA(IbPtr, XmNlListGetRCWidget(IbPtr->fm_scroll_win));

	if (!IbPtr->menuBdetail)
		IbPtr->menuBdetail = CreateMenuB(IbPtr, XmNlListGetRCWidget(IbPtr->fm_scroll_win));


	XtAddCallback(XmNlListGetIBWidget(IbPtr->fm_scroll_win), XmNpopupHandlerCallback, FilePopupHandlerCB, (XtPointer) IbPtr);
	XtAddCallback(XmNlListGetRCWidget(IbPtr->fm_scroll_win), XmNpopupHandlerCallback, FilePopupHandlerCB, (XtPointer) IbPtr);


#ifdef DEBUG
	printf("OK+1\n");
#endif


	form = XmCreateForm(IbPtr->fm_main_window, "fm_command_form", NULL, 0);



	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNuserData, (XtPointer) IbPtr); n++;

	IbPtr->stop_load_dir = XmCreatePushButton(form, "Stop", args, n);

	XtAddCallback(IbPtr->stop_load_dir, XmNactivateCallback, StopLoadDir, (XtPointer) IbPtr);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNrightWidget, IbPtr->stop_load_dir); n++;
	XtSetArg(args[n], XmNuserData, (XtPointer) IbPtr); n++;

	IbPtr->go_up_dir = XmCreatePushButton(form, "Up", args, n);

	XtAddCallback(IbPtr->go_up_dir, XmNactivateCallback, GoUpDir, (XtPointer) IbPtr);

	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNrightWidget, IbPtr->go_up_dir); n++;
	XtSetArg(args[n], XmNuserData, (XtPointer) IbPtr); n++;

	IbPtr->go = XmCreatePushButton(form, "Go", args, n);

	XtAddCallback(IbPtr->go, XmNactivateCallback, fm_openitem, (XtPointer) 11);

	n = 0;
	XtSetArg(args[n], XmNuserData, (XtPointer) IbPtr); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNrightWidget, IbPtr->go); n++;



	IbPtr->fm_textfield = XmCreateTextField(form, "fm_textfield", args, n);
//	IbPtr->fm_textfield = XmCreateTextField(IbPtr->fm_main_window, "fm_textfield", args, n);
	XtAddCallback(IbPtr->fm_textfield, XmNactivateCallback, fm_openitem, (XtPointer)10);


	IbPtr->statusBar = XmCreateLabel(IbPtr->fm_main_window, "Selected: 0 items", NULL, 0);

#ifdef DEBUG
	printf("OK+2\n");
#endif


	XtManageChild(form);
	XtManageChild(IbPtr->go);
	XtManageChild(IbPtr->go_up_dir);
	XtManageChild(IbPtr->stop_load_dir);
	XtManageChild(IbPtr->fm_textfield);
	XtManageChild(IbPtr->fm_scroll_win);
	XtManageChild(IbPtr->statusBar);

	XtVaSetValues(IbPtr->stop_load_dir, XmNsensitive, False, NULL);

	XtAddCallback(IbPtr->fm_scroll_win, XmNdoubleClickCallback, fm_openitem, (XtPointer)20);
	XmMainWindowSetAreas(IbPtr->fm_main_window, IbPtr->fm_menubar, form, NULL, NULL,
							IbPtr->fm_scroll_win);
/*	XmMainWindowSetAreas(IbPtr->fm_main_window, IbPtr->fm_menubar, IbPtr->fm_textfield, NULL, NULL,
							IbPtr->fm_scroll_win);*/

	XtVaSetValues(IbPtr->fm_main_window, XmNmessageWindow, IbPtr->statusBar, XmNshowSeparator, True, NULL);

#ifdef DEBUG
	printf("OK+3\n");
#endif

//	IbPtr->files = malloc(sizeof(struct filedata) * IbPtr->nfiles);
#ifdef DEBUG
	printf("OK+4\n");
#endif
  
	GetUserInfo();
#ifdef DEBUG
	printf("OK+5\n");
#endif


/*	load_dir(IbPtr, IbPtr->current_wd);*/


#ifdef DEBUG
	printf("OK+6\n");
#endif

	XtVaSetValues(IbPtr->top_level, XmNtitle, IbPtr->current_wd, NULL);
	XtVaSetValues(IbPtr->fm_textfield, XmNvalue, IbPtr->current_wd, NULL);
#ifdef DEBUG
	printf("OK+7\n");
#endif

/*	WM_DELETE_WINDOW = XInternAtom(XtDisplay(IbPtr->top_level), "WM_DELETE_WINDOW", False);
	XmAddWMProtocolCallback(IbPtr->top_level, WM_DELETE_WINDOW, CloseWinCB, (XtPointer) IbPtr);
	XtVaSetValues(IbPtr->top_level, XmNdeleteResponse, XmDO_NOTHING, NULL);*/

	XtRealizeWidget(IbPtr->top_level);
#ifdef DEBUG
	printf("OK+8\n");
#endif
	DrawFileArea(IbPtr);

#ifdef DEBUG
	printf("OK+9\n");
#endif

	/* Learn some stuff about the system */
//	scan_for_smb();

#ifdef USE_INOTIFY
//	IbPtr->inp_id = XtAppAddInput(IbPtr->app, IbPtr->i_fd, (XtPointer) XtInputReadMask, InotifyInput, (XtPointer) IbPtr);
#endif

	XtAppMainLoop(IbPtr->app);
#ifdef DEBUG
	printf("AppMainLoop terminated\n");
#endif
	
	XtDestroyWidget(IbPtr->top_level);
//		XtDestroyWidget(IbPtr->fm_main_window);

#ifdef DEBUG
	printf("Top level destroyed\n");
#endif

	XtDestroyApplicationContext(IbPtr->app);

#ifdef DEBUG
	printf("App context destroyed\n");
#endif

	if (IbPtr->fops_allocated > 0)
		free(IbPtr->fops);
		
#ifdef USE_INOTIFY
//	close(IbPtr->i_fd);
	while(1)
	{
		usleep(IDL_TIMEOUT_MIN * 1000);
		pthread_mutex_lock(&(IbPtr->branch_mutex));
		if (IbPtr->WatchEventQueue)
		{
			if (IbPtr->WatchEventQueue->code == NOTIFY_WATCH_TERMINATED)
			{
				free(IbPtr->WatchEventQueue);
				pthread_mutex_unlock(&(IbPtr->branch_mutex));
				break ;
			}
		}
		pthread_mutex_unlock(&(IbPtr->branch_mutex));
	}
#endif
/*	magic_detach();
	exit(0);*/
#ifdef DEBUG
	printf("Next terminated\n");
#endif

	return NULL;
}

void SaveSetting(Widget w, XtPointer client_data, XtPointer call_data)
{
	int i;
	char * config_fn;
	FILE * fd;
	IfaceBranche * IbPtr = (IfaceBranche *) client_data;
	
	XtDestroyWidget(w);
	
	config_fn = calloc(strlen(home_dir) + strlen(CONFIG_FILE_NAME) + 1, sizeof(char));
//	config_fn = calloc(strlen(home_dir) + strlen("/a.cfg") + 1, sizeof(char));
	strcpy(config_fn, home_dir);
	strcat(config_fn, CONFIG_FILE_NAME);
//	strcat(config_fn, "/a.cfg");


	fd = fopen(config_fn, "w");

	if (!fd)
	{
		printf("Error opening config file\n");
		if (config_fn)
			free(config_fn);
		return ;
	}

	HiddenFileShow = IbPtr->HiddenFileShow;
	HiddenDirShow = IbPtr->HiddenDirShow;
	ParentDirShow = IbPtr->ParentDirShow;
	CurrentDirShow = IbPtr->CurrentDirShow;

	fprintf(fd, "IconPath \"%s\";\n", path_icons_set);
	if (path_magic_file)
		fprintf(fd, "MagicPath \"%s\";\n", path_magic_file);



	if (1 == HiddenDirShow)
		fprintf(fd, "ShowHiddenDir \"Yes\";\n");
	else
		fprintf(fd, "ShowHiddenDir \"No\";\n");
	
	if (1 == HiddenFileShow)
		fprintf(fd, "ShowHiddenFile \"Yes\";\n");
	else
		fprintf(fd, "ShowHiddenFile \"No\";\n");

	if (1 == ParentDirShow)
		fprintf(fd, "ShowParentDir \"Yes\";\n");
	else
		fprintf(fd, "ShowParentDir \"No\";\n");

	if (1 == CurrentDirShow)
		fprintf(fd, "ShowCurrentDir \"Yes\";\n");
	else
		fprintf(fd, "ShowCurrentDir \"No\";\n");

	if (terminal_command && terminal_command != PredefinedTerminalString)
		fprintf(fd, "TerminalCommand \"%s\";\n", terminal_command);

	for (i = 0; i < count_current; i++)
	{
//		if ((ftype_list[i])->big_icon_name == NULL || (ftype_list[i])->small_icon_name == NULL || (ftype_list[i])->action == NULL)
		if ((ftype_list[i])->big_icon_name == NULL && (ftype_list[i])->small_icon_name == NULL && (ftype_list[i])->action == NULL)
			continue;

//		fprintf(fd, "Type <%s> { LargeIcon \"%s\"; SmallIcon \"%s\"; Action \"%s\";", 
//				(ftype_list[i])->magic, (ftype_list[i])->big_icon_name, (ftype_list[i])->small_icon_name, (ftype_list[i])->action); 


		if ((ftype_list[i])->big_icon_name) 
			fprintf(fd, "Type <%s> { LargeIcon \"%s\";", (ftype_list[i])->magic, (ftype_list[i])->big_icon_name);
		else
			fprintf(fd, "Type <%s> {", (ftype_list[i])->magic);
		
		if ((ftype_list[i])->small_icon_name)
			fprintf(fd, " SmallIcon \"%s\";", (ftype_list[i])->small_icon_name); 

		if ((ftype_list[i])->action)
			fprintf(fd, " Action \"%s\";", (ftype_list[i])->action); 

		if ((ftype_list[i])->alter_name)
			fprintf(fd, " AlterName \"%s\";", (ftype_list[i])->alter_name); 
		fprintf(fd, "};\n");
	}

	for (i = 0; i < alter_count_current; i++)
	{
		fprintf(fd, "TypeAlternative \"%s\" {AlterLabel \"%s\"; AlterAction \"%s\";", (alter_action_list + i)->name, 
				(alter_action_list + i)->label1, (alter_action_list + i)->action1); 
		
		if ((alter_action_list + i)->label2)
			fprintf(fd, " AlterLabel \"%s\"; AlterAction \"%s\";", 
					(alter_action_list + i)->label2, (alter_action_list + i)->action2);
		
		if ((alter_action_list + i)->label3)
			fprintf(fd, " AlterLabel \"%s\"; AlterAction \"%s\";", 
					(alter_action_list + i)->label3, (alter_action_list + i)->action3); 
					
		fprintf(fd, "};\n");
	}


	for (i = 0; i < ext_count_current; i++)
	{
		if ((ext_ftype_list[i])->type_link && (ext_ftype_list[i])->pattern)
			fprintf(fd, "ExtType <%s> {TypeLink \"%s\"; TypePattern \"%s\";};\n", (ext_ftype_list[i])->magic, (ext_ftype_list[i])->type_link, (ext_ftype_list[i])->pattern); 
	}

	fclose(fd);
	
	if (config_fn)
		free(config_fn);
}


static int compare_name_func(const void *p1, const void *p2)
{
	return strcmp(* (char * const *) p1, * (char * const *) p2);
}

static void clean_file_list(char ** file_list, int used_n)
{
	int i;
	
	for (i = 0; i < used_n; i++)
	{
		if (file_list[i])
			free(file_list[i]);
	}
	
	free(file_list);
	return ;
}

static int CreateGlobalPixmapList(void)
{
	register DIR *reading;
	register struct dirent *next;
	char * fullpath, * ptr;
	char fullname[4096];
	int i, k, j, l, ret;
	
	char ** tmp_file_list = NULL, ** rptr = NULL;
	int allocated_n = 0;
	int used_n = 0;
	appPixmapList * Pptr;
	XpmImage xpmImage;


#ifdef DEBUG
	printf("LoadGlobalPixmapList\n");
#endif

	if (home_dir && path_icons_set) 
	{
		fullpath = calloc(strlen(home_dir) + strlen(path_icons_set) + 4, sizeof(char));
		if (!fullpath)
		{
			globalPixmapList = NULL;
			return 0;
		}
	}
	else
	{	
#ifdef DEBUG
		printf("LoadGlobalPixmapList: path not found\n");
#endif
		globalPixmapList = NULL;
		return 0;
	}

	if ((ptr = strchr(path_icons_set, '~')) && ptr == &path_icons_set[0]) 
	{
		strcpy(fullpath, home_dir);
		strcat(fullpath, ptr + 1);
	}
	else 
		strcpy(fullpath, path_icons_set);

	reading = opendir(fullpath);
	if (!reading)
	{
#ifdef DEBUG
		printf("LoadGlobalPixmapList: error openning dir %s\n", path_icons_set);
#endif
		globalPixmapList = NULL;
		if (fullpath)
			free(fullpath);
		return 0;
	}

	while ((next = readdir (reading)) != NULL) 
	{
		if (strstr(next->d_name, ".xpm") == NULL)
			continue;
		
		memset(fullname, 0, 4096);
		strcpy(fullname, fullpath);
		strcat(fullname, next->d_name);
		
		ret = XpmReadFileToXpmImage(fullname, &xpmImage, NULL);

		if (ret == XpmOpenFailed)
		{
			printf("Error open xpm file:%s\n", fullpath);
			continue ;
		}

		if (ret == XpmFileInvalid)
		{
			printf("Error file:%s is not xpm format\n", fullpath);
			continue ;
		}

		if (ret == XpmNoMemory)
		{
			printf("Error open xpm file:%s - no memory\n", fullpath);
			continue ;
		}

		if (xpmImage.width > MAX_ICON_SIZE_LIMIT || xpmImage.height > MAX_ICON_SIZE_LIMIT)
		{
			XpmFreeXpmImage(&xpmImage);
			continue ;
		}

#ifdef DEBUG
		printf("Xpm file: %s width %u height %u\n", next->d_name, xpmImage.width, xpmImage.height);
#endif

		if (xpmImage.width > maxIconWidth)
			maxIconWidth = xpmImage.width;
		if (xpmImage.height > maxIconHeight)
			maxIconHeight = xpmImage.height;

		XpmFreeXpmImage(&xpmImage);

		if (NULL == tmp_file_list)
		{
			tmp_file_list = calloc(20, sizeof(char *));
			if (!tmp_file_list)
			{
				globalPixmapList = NULL;
				return 0;
			}
			allocated_n = 20;
		}
		else
		{
			if (allocated_n == (used_n - 1))
			{
				rptr = tmp_file_list;
				tmp_file_list = realloc(tmp_file_list, allocated_n * sizeof(char *) + 20 * sizeof(char *));
				if (!tmp_file_list)
				{
					globalPixmapList = NULL;
					clean_file_list(rptr, used_n);
					return 0;
				}
				allocated_n+=20;
			}
		}
		
		tmp_file_list[used_n] = strdup(next->d_name);
		used_n++;
		
	}

	closedir(reading);

	qsort(tmp_file_list, used_n, sizeof(char *), compare_name_func);

#ifdef DEBUG
	for (i = 0; i < used_n; i++)
	{
		printf("File list for pixmap list = %s\n", tmp_file_list[i]); 
	}
	printf("===========\n");
#endif

	if (fullpath)
		free(fullpath);
		
	if (!used_n)
	{
		globalPixmapList = NULL;
		if (tmp_file_list)
			clean_file_list(tmp_file_list, used_n);
		return 0;
	}

	globalPixmapList = calloc(1, sizeof(appPixmapList));
	if (!globalPixmapList)
	{
		clean_file_list(tmp_file_list, used_n);
		return 0;
	}

	Pptr = globalPixmapList;
	Pptr->name = tmp_file_list[0];
	Pptr->icon = XmUNSPECIFIED_PIXMAP;
	Pptr->mask = XmUNSPECIFIED_PIXMAP;
	Pptr->next = NULL;
	Pptr->used = ICON_NODE_NOT_INITED;

	for (i = 1; i < used_n; i++)
	{
		Pptr->next = calloc(1, sizeof(appPixmapList));
		if (!Pptr->next)
		{
			for (j = i; j < used_n; j++)
			{
				if (tmp_file_list[j])
				 free(tmp_file_list[j]);
			}
			free(tmp_file_list);
			return i;
		}
		Pptr = Pptr->next;
		Pptr->name = tmp_file_list[i];
		Pptr->icon = XmUNSPECIFIED_PIXMAP;
		Pptr->mask = XmUNSPECIFIED_PIXMAP;
		Pptr->used = ICON_NODE_NOT_INITED;
	}

	Pptr = globalPixmapList;

#ifdef DEBUG
	while (Pptr)
	{
		printf("Global pixmap list = %s\n", Pptr->name);
		Pptr = Pptr->next; 
	}
	printf("===========\n");
#endif

	return used_n;
}

void main(int argc, char **argv)
{
	int x, n;
	Widget fm_main_window, fm_menubar, sm_vsb, sm_hsb;
	Dimension sx1, sy1, x1, y1;
	Arg args[10];
	int i, j;
	char * config_fn, * ptr;
	IfaceBranche * ifptr, * ptr2;
	Display * dpy;
//  XtTranslations parsed_trans;
	XEvent		ev;
	int IconSet1Ok = 0, IconSet2Ok = 0, OneIfaceStart = 0;

	AllIfaceBranches = NULL;
	icon_loaded = 0;
	sort_icon_activated = 0;
	fullIconComplect = 0;
	needAddIconToGlobalList = 0;
	memset(NormalIconsSetPath, 0, 4096);
	
	maxIconHeight = 0;
	maxIconWidth = 0;

	glob_argc = argc;
	glob_argv = argv;

	/* Learn some stuff about the user */
	home_dir = (char *)getenv("HOME");
	local_uid = getuid();
	local_gid = getgid();

	CursorCreated = False;
	CaseSensitiveSorting = 1;

	config_fn = calloc(strlen(home_dir) + strlen(CONFIG_FILE_NAME) + 1, sizeof(char));
	strcpy(config_fn, home_dir);
	strcat(config_fn, CONFIG_FILE_NAME);

#ifdef DEBUG
	printf("Config %s\n", config_fn);
#endif

/************************************/
	parse_config_start(config_fn);

	i = count_current - 2;
	while (i >= 0)
	{
		j = alter_count_current - 1;
		while (j >= 0)
		{
			if ((alter_action_list + j)->name && (ftype_list[i])->alter_name)
				if ((strcmp((alter_action_list + j)->name, (ftype_list[i])->alter_name)) == 0) //printf("Aaaaa = %s\n", (ftype_list + i)->alter_name); 
					(ftype_list[i])->alter_ptr = (alter_action_list + j);
			j--;
		}
		i--;
	}

#ifdef DEBUG
	printf("== show_parent_dir %s show_current_dir %s show_hidden_file %s show_hidden_dir %s\n", 
			show_parent_dir, show_current_dir, show_hidden_file, show_hidden_dir);
	printf("== icons set %s\t magic file %s count_current %d\n", path_icons_set, path_magic_file, count_current);
	printf("Count current %d\n", count_current);
	i = count_current - 1;
	while (i >= 0)
//	for (i = 0; i < count_current; i++)
	{
		printf("Magic = %s\t%s\t%s\t%s\t%s\n", (ftype_list[i])->magic, (ftype_list[i])->big_icon_name, (ftype_list[i])->small_icon_name, (ftype_list[i])->action, (ftype_list[i])->alter_name); 
		i--;
	}

	i = ext_count_current - 1;
	while (i >= 0)
	{
		printf("ExtTypeMagic = %s\t%s\t%s\n", (ext_ftype_list[i])->magic, (ext_ftype_list[i])->type_link, (ext_ftype_list[i])->pattern); 
		i--;
	}



	i = alter_count_current - 1;
	while (i >= 0)
	{
		printf("Alternative = %s\t%s\t%s\t%s\t%s\t%s\t%s\n", (alter_action_list + i)->name, 
				(alter_action_list + i)->label1, (alter_action_list + i)->action1, (alter_action_list + i)->label2, (alter_action_list + i)->action2, 
				(alter_action_list + i)->label3, (alter_action_list + i)->action3); 
		i--;
	}
#endif

	if (show_hidden_dir)
	{
		if (0 == strcmp("yes", show_hidden_dir) || 0 == strcmp("Yes", show_hidden_dir))
		{
			HiddenDirShow = 1;
#ifdef DEBUG
			printf("Hidden dir switched to ON\n");
#endif
		}
		else
		{
			HiddenDirShow = 0;
#ifdef DEBUG
			printf("Hidden dir switched to OFF\n");
#endif
		}
		free(show_hidden_dir);
	}
	else
	{
			HiddenDirShow = 0;
#ifdef DEBUG
			printf("Hidden dir set to OFF\n");
#endif
	}

	if (show_hidden_file)
	{
		if (0 == strcmp("yes", show_hidden_file) || 0 == strcmp("Yes", show_hidden_file))
		{
			HiddenFileShow = 1;
#ifdef DEBUG
			printf("Hidden file switched to ON\n");
#endif
		}
		else
		{
			HiddenFileShow = 0;
#ifdef DEBUG
			printf("Hidden file switched to OFF\n");
#endif
		}
		free(show_hidden_file);
	}
	else
	{
			HiddenFileShow = 0;
#ifdef DEBUG
			printf("Hidden file set to OFF\n");
#endif
	}

	if (show_parent_dir)
	{
		if (0 == strcmp("yes", show_parent_dir) || 0 == strcmp("Yes", show_parent_dir))
		{
			ParentDirShow = 1;
#ifdef DEBUG
			printf("Parent dir switched to ON\n");
#endif
		}
		else
		{
			ParentDirShow = 0;
#ifdef DEBUG
			printf("Parent dir switched to OFF\n");
#endif
		}
		free(show_parent_dir);
	}
	else
	{
			ParentDirShow = 0;
#ifdef DEBUG
			printf("Parent dir set to OFF\n");
#endif
	}

	if (show_current_dir)
	{
		if (0 == strcmp("yes", show_current_dir) || 0 == strcmp("Yes", show_current_dir))
		{
			CurrentDirShow = 1;
#ifdef DEBUG
			printf("Current dir switched to ON\n");
#endif
		}
		else
		{
			CurrentDirShow = 0;
#ifdef DEBUG
			printf("Current dir switched to OFF\n");
#endif
		}
		free(show_current_dir);
	}
	else
	{
			CurrentDirShow = 0;
#ifdef DEBUG
			printf("Current dir set to OFF\n");
#endif
	}



	if (!terminal_command)
	{
		terminal_command = PredefinedTerminalString;
	}
#ifdef DEBUG
			printf("Terminal command st to %s\n", terminal_command);
#endif

	if (home_dir && path_icons_set) 
	{
		if ((ptr = strchr(path_icons_set, '~')) && ptr == &path_icons_set[0]) 
		{
			strcpy(NormalIconsSetPath, home_dir);
			strcat(NormalIconsSetPath, ptr + 1);
		}
		else 
			strcpy(NormalIconsSetPath, path_icons_set);
	}

#ifdef DEBUG
		printf("Mormal Icons Set Path = %s\n", NormalIconsSetPath);
#endif

	free(config_fn);
	config_fn = NULL;
	
/*********************************/
	if (path_magic_file)
	{
		config_fn = calloc(strlen(home_dir) + strlen(path_magic_file) + 2, sizeof(char));

		if ((ptr = strchr(path_magic_file, '~')) && ptr == &path_magic_file[0]) 
		{
			strcpy(config_fn, home_dir);
			strcat(config_fn, ptr+1);
		}
		else strcpy(config_fn, path_magic_file);
	}

	magic_parse_file(config_fn);

	if (config_fn) 
	{
		free(config_fn);
		config_fn = NULL;
	}

/*************************************/
	CreateGlobalPixmapList();
	buildingIconNode = globalPixmapList;
	InitCheckMoveArr();

#ifdef USE_INOTIFY
	WatchCommandQueue = NULL;
	pthread_mutex_init(&watch_mutex, NULL);
	
	pthread_create(&notify_thread_id, NULL, WatchDirThread, NULL);
#endif

	XtToolkitThreadInitialize();  
	XtSetLanguageProc(NULL, NULL, NULL);
	
	dpy = XOpenDisplay(NULL);

	FILE_NAME = XInternAtom(dpy, "FILE_NAME", False);

/*		UTF8_STRING = XInternAtom (XtDisplay(IbPtr->top_level), "application/x-kde-cutselection", False);*/
		UTF8_STRING = XInternAtom (dpy, "UTF8_STRING", False);
/*		file_name_atom_ready = 1;
		file_name_atom_ready = 1;*/
	
	WM_DELETE_WINDOW = XInternAtom(dpy, "WM_DELETE_WINDOW", False);

	COPY_ATOM = XInternAtom(dpy, "x-special/gnome-copied-files", False);

	XFlush(dpy);

	while(1)
	{
//		sleep(2);
		while(XPending(dpy))
		{
			XNextEvent(dpy, &ev);
#ifdef DEBUG
			printf("!!!!!!!!!!!!!!!!!\n");
			printf("XEvent %d\n", ev.type);
#endif
		}
		
		if (!IconSet1Ok)
		{
			CreateIconsSet1(dpy);
			IconSet1Ok = 1;
			continue ;
		}
		
		if (!IconSet2Ok)
		{
			CreateIconsSet2(dpy);
			IconSet2Ok = 1;
			continue ;
		}
		if (needAddIconToGlobalList)
		{
			CreateIconsSet3(dpy);
			continue ;
		}

		if (!OneIfaceStart)
		{
			ifptr = StartNewIfaceBranche(home_dir);
//			ifptr = StartNewIfaceBranche("/home/gorgolion/5");
			
			if (!ifptr)
			{
#ifdef DEBUG
				printf("Cannot start new interface branch\n");
#endif
				XCloseDisplay(dpy);
				magic_detach();
				exit(1);
			}
			pthread_create(&(ifptr->thread_id), NULL, NewIfaceWindowThread, (void *) ifptr);
			OneIfaceStart = 1;
			continue ;
		}
		
		pthread_mutex_lock(&iface_mutex);
		ifptr = AllIfaceBranches;
		ptr2 = ifptr;
		if (!ifptr)
		{
			pthread_mutex_unlock(&iface_mutex);
			break;
		}
		while(ifptr)
		{
			if (0 == pthread_tryjoin_np(ifptr->thread_id, NULL))
			{
#ifdef DEBUG
				printf("MAIN: thread %d finished\n", ifptr->thread_number);
#endif
				RemoveIfaceBranche(ifptr);
				if (ptr2 == ifptr)
				{
					AllIfaceBranches = ifptr->next_branche;
					free(ifptr);
					ifptr = AllIfaceBranches;
					ptr2 = ifptr;
				}
				else
				{
					ptr2->next_branche = ifptr->next_branche;
					free(ifptr);
					ifptr = ptr2->next_branche;
				}
			}
			else
			{
				if (ifptr != AllIfaceBranches)
					ptr2 = ptr2->next_branche;
				ifptr = ifptr->next_branche;
			}	
		}
		pthread_mutex_unlock(&iface_mutex);
		usleep(200000);
	}

#ifdef DEBUG
	printf("------------OUT\n");
	for (i = 0; i < count_current; i++)
	{
		printf("Magic = %s\t%s\t%s\t%s\t%s\t%lx\n", (ftype_list[i])->magic, (ftype_list[i])->big_icon_name, (ftype_list[i])->small_icon_name, (ftype_list[i])->action, (ftype_list[i])->alter_name, (ftype_list[i])->big_pixmap); 
	}
#endif

	CleanIconsSet1(dpy);
	CleanIconsSet2(dpy);
//	CleanSortIconsSet(dpy);
	
	XCloseDisplay(dpy);

#ifdef USE_INOTIFY
	PutWatchCommand(NULL, COMMAND_TERMINATE_WATCH);
#endif

//	pthread_join(ifptr->thread_id, NULL);

//	XtAppMainLoop(app);
	pthread_mutex_destroy(&iface_mutex);
	magic_detach();

#ifdef USE_INOTIFY
	pthread_join(notify_thread_id, NULL);
#ifdef DEBUG_WATCH_DIR
	printf("Watch thread joined\n");
#endif
	pthread_mutex_destroy(&watch_mutex);
#endif

#ifdef DEBUG
	printf("!!! Exit !!!\n");
#endif
	exit(0);
}





Boolean ConvertProc(Widget, Atom *, Atom *, Atom *,	XtPointer *, unsigned long *, int *);
void DragDropFinish(Widget, XtPointer, XtPointer);

void StartDrag (Widget widget, XEvent *event, String *params,
		Cardinal *num_params)
{
    XButtonEvent * bevent = (XButtonEvent *) event;
	Position x, y;
	Arg args[10];
	int n, i;
	static int item;
	Display *dpy;
	Atom FILE_NAME;
	Atom exportList[1];
	Widget drag_icon, dc;
	Pixel fg, bg;
	Pixmap icon, iconmask;
	XtPointer ptr;
//	unsigned char valuemask = 0 | CellUserData;
//	XmNlCell item;

/* intern the Atoms for data targets */

#ifdef DEBUG
	printf("Start drag\n");
#endif

	x=bevent->x;
	y=bevent->y;
//	i = XYtoItem(widget, (unsigned long) x, (unsigned long) y);
	i = XmNlListXYtoPos(XtParent(widget), (unsigned long) x, (unsigned long) y);
//	printf("StartDrag w = %d h = %d\n", XtWidth(widget), XtHeight(widget));
	if (i == -1) return ;
	item = i;
	dpy = XtDisplay (widget);
//FILE_CONTENTS = XInternAtom (dpy, "FILE_CONTENTS", False);
	FILE_NAME = XInternAtom (dpy, "FILE_NAME", False);
//DIRECTORY = XInternAtom (dpy, "DIRECTORY", False);

/* get background and foreground colors and fetch index into file
** array from XmNuserData.
*/

	XtVaGetValues (widget, XmNbackground, &bg, XmNforeground, &fg, NULL);

	XtVaSetValues (widget, XmNuserData, &item, NULL);

/* create pixmaps for drag icon -- either file or directory */

/*i = (int) ptr;
if (files[i].is_directory) {
	icon = XmGetPixmapByDepth (XtScreen (widget), "folder_small.xpm",
	1, 0, 1);
	iconmask = XmGetPixmapByDepth (XtScreen (widget),
					"folder_small.xpm", 1, 0, 1);
	}
else {
	icon = XmGetPixmapByDepth (XtScreen (widget), "file_small.xpm",
					1, 0, 1);
	iconmask = XmGetPixmapByDepth (XtScreen (widget),
	"fil_small.xpm", 1, 0, 1);
	}
if (icon == XmUNSPECIFIED_PIXMAP ||

iconmask == XmUNSPECIFIED_PIXMAP) {
	puts ("Couldn't load pixmaps");
	exit (1);
	}

n = 0;
XtSetArg (args[n], XmNpixmap, icon); n++;
XtSetArg (args[n], XmNmask, iconmask); n++;
drag_icon = XmCreateDragIcon (widget, "drag_icon", args, n);
*/
/* specify resources for DragContext for the transfer */

	n = 0;
//XtSetArg (args[n], XmNblendModel, XmBLEND_ALL); n++;
	XtSetArg (args[n], XmNenableDragIcon, False); n++;
	XtSetArg (args[n], XmNcursorBackground, bg); n++;
	XtSetArg (args[n], XmNcursorForeground, fg); n++;
//XtSetArg (args[n], XmNsourceCursorIcon, drag_icon); n++;

/* establish the list of valid target types */

/*if (files[i].is_directory) {
	exportList[0] = DIRECTORY;
	XtSetArg (args[n], XmNexportTargets, exportList); n++;
	XtSetArg (args[n], XmNnumExportTargets, 1); n++;
	}
else {
	exportList[0] = FILE_CONTENTS;
	exportList[1] = FILE_NAME;
	XtSetArg (args[n], XmNexportTargets, exportList); n++;
	XtSetArg (args[n], XmNnumExportTargets, 2); n++;
	}
*/

	exportList[0] = FILE_NAME;
	XtSetArg (args[n], XmNexportTargets, exportList); n++;
	XtSetArg (args[n], XmNnumExportTargets, 1); n++;

	XtSetArg (args[n], XmNdragOperations, XmDROP_COPY); n++;
	XtSetArg (args[n], XmNconvertProc, ConvertProc); n++;
	XtSetArg (args[n], XmNclientData, widget); n++;

/* start the drag and register a callback to clean up when done */

	dc = XmDragStart (widget, event, args, n);
	XtAddCallback (dc, XmNdragDropFinishCallback, DragDropFinish, NULL);

}

Boolean ConvertProc ( Widget widget,
		Atom *selection,
		Atom *target,
		Atom *type_return,
		XtPointer *value_return,
		unsigned long *length_return,
		int *format_return)
{
	Display *dpy;
	Atom FILE_NAME, MOTIF_DROP;
	XtPointer ptr;
	Widget label;
	int i;
	char *text, viewtype;
	struct stat s_buf;
	FILE *fp;
	long length;
	String str1, str2;
	unsigned char valuemask = 0 | CellUserData;
	XmNlCell item;
	IfaceBranche * IbPtr;

/* intern the Atoms for data targets */

dpy = XtDisplay (widget);
//FILE_CONTENTS = XInternAtom (dpy, "FILE_CONTENTS", False);
FILE_NAME = XInternAtom(dpy, "FILE_NAME", False);
MOTIF_DROP = XInternAtom(dpy, "_MOTIF_DROP", False);

/* check if we are dealing with a drop */
if (*selection != MOTIF_DROP)
return False;

/* get the drag source widget */

XtVaGetValues(widget, XmNclientData, &ptr, NULL);
label = (Widget) ptr;
if (label == NULL)
return False;

XtVaGetValues(XtParent(label), XmNuserData, &IbPtr, NULL);

/* get the index into the file array from XmNuserData from the
** drag source widget.
*/

XtVaGetValues(label, XmNuserData, &ptr, NULL);
//i = (int) ptr;
i = *((int*) ptr);

/* this routine processes only file contents and file name */

if (*target == FILE_NAME) {
//	str = XtNewString (files[i].name);
	struct filedata * file_ptr;
//	file_ptr = XmNlItBoxGetUserData(label, i);

	XtVaGetValues(XtParent(label), XmNViewListType, &viewtype, NULL);
	if (viewtype == XmNlList_Detail) 
		XmNlResColGetItem(label, &item, valuemask, i);
	else
		XmNlItBoxGetItem(label, &item, valuemask, i);
	file_ptr = (struct filedata *) item.UserDataPointer;
	str1 = file_ptr->name;
  if (str1[0] != '/')
  {
  	  str2 = XtMalloc(strlen(IbPtr->current_wd) + strlen(str1) + 3); 
	  sprintf(str2, "%s/%s", IbPtr->current_wd, str1); 
  }
  else
    str2=str1;
	/* format the value for transfer */
	*type_return = FILE_NAME;
	*value_return = (XtPointer) str2;
	*length_return = strlen (str2) + 1;
	*format_return = 8;
	return True;
	}
else
return False;
}

/* DragDropFinish() -- clean up after a drag and drop transfer. */

void DragDropFinish (Widget widget, XtPointer client_data,
			XtPointer call_data)
{
	Widget source_icon = NULL;

	XtVaGetValues (widget, XmNsourceCursorIcon, &source_icon, NULL);
	if (source_icon)
		XtDestroyWidget (source_icon);
}
