#include <magic.h>
#include <stdio.h>
#include <string.h>

magic_t mg_tok;
static char magic_ok = 0;

void magic_detach(void)
{
	if (mg_tok) magic_close(mg_tok);
}

void magic_parse_file(char * name)
{
	const char * s;
	int ret;
	mg_tok = magic_open(MAGIC_MIME_TYPE);
	if (!mg_tok) 
	{
		s = magic_error(mg_tok);
#ifdef DEBUG
		printf("Error %s\n", s);
#endif
		return ;
	}
	ret = magic_load(mg_tok, name);
	if (ret == 0)
		magic_ok = 1;
#ifdef DEBUG
	printf("magic_load return code %d\n", ret);	
#endif
	return ;
}

void magic_get_type(char * name, char * buf)
{
    const char * s;
    
    if (!magic_ok) 
    {
		buf[0] = '\0';
		return ;
	}
    
    s = magic_file(mg_tok, name);
#ifdef DEBUG
    printf("=========== File:%s\t%s\n", name, s);
#endif

    if (s) 
		strcpy(buf, s);
	else 
		buf[0] = '\0';
	return ;
}

