/* helpsys.c -- Help system(s) for my file manager.
 *
 * Bryan Herger (hergeb@rpi.edu)
 * Partly hacked from my Comp. Graphics term project. */

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/ScrolledW.h>
#include <Xm/Text.h>
#include <X11/Shell.h>
#include <X11/xpm.h>
#include <stdlib.h>

#include "atomxpm.h"
#include "defines.h"
#include "core.h"
#include "config.h"

//extern Widget top_level;

/* General Help message. */
char ghelp[] = {
"How to use Bryan's X/Motif File Manager\n\nThe display\nThe top row is the menu bar.  In the \"File\" pulldown menu, these commands are available:  Run, Copy, Move, Delete, Info, Find, and Exit.  In the \"Directory\" menu, these commands are found:  Create (Directory), Goto, Up, and Home.  Under the \"Help\" menu are the About and General Help options.  If you are root, an additional menu, \"Share\", is available; this is discussed at the end of this display.\nBelow this is the directory text field.  This shows either the current directory, or if a file is selected, the full path of the selected file.\nThe bulk of the window is occupied by the file area.  This displays the contents of the current directory in alphabetical order, directories first.  Select an item by single clicking on it; deselect by clicking on the file again or by clicking in white space.  Directory folders displayed in blue are being shared over a network.\nTraversing through the file system\nDouble click on a directory to open it.  Double click on \"..\" or on Up in the Directory menu to go to the parent directory.  Click on Home in the Directory menu to return to your home directory.  Click on \"Goto\" to enter the name of a specific directory to go to.  Alternatively, you may click on the text field just below the menu bar, enter the name of the directory to go to, and press Enter to go to a specific directory.\nOperations\nExcept where note, Cancel cancels the current procedure.\nDouble-click on an executable file to run it.  At this point, it is unwise to run a non-X application in this manner.  Alternatively, you can type the full name of the application in the text field just under the menu bar and press Enter, or use Run in the File menu.\nIn the File menu, use the Copy and Move options in the File menu to perform these functions.  If a file is selected, the name of the file will be filled in to the source field; otherwise, you will have to specify a source file.  Enter the destination in the \"to:\" box and press Enter or select OK.\nUse Delete to delete a file.  Note that you must find and select the file or directory you want to delete.  Delete is a permanent operation; think before you click OK.\nUse Info to display information on the selected file.  If no file is selected, information on the current directory will be displayed.  Statistics such as size, creation date, and permissions are displayed here.\nExit is under the File menu; it exits the program and closes all associated windows.\nUnder the Directory menu, Create allows creation of a directory under the current directory.  You can set permissions on the new directory using the toggle buttons, but remember that Read and Execute permissions are needed to list a directory.\nFinding Files\nUse Find to locate files.  In the first box, enter a pattern to find.  You may use wildcards ? and *.  In the second box, enter a directory from which to start the search.  This directory and all its subdirectories will be searched.\nThe results are returned in another window.  This window has a File menu with the same options as the Main window (except Find).  Close closes the Find window.  You must select a file before using the operations in the File menu, except Close.\nYou can copy a file to the directory displayed in the main window by dragging the file from the Find window to the main window and dropping it in the file display.  Use the middle button to drag and drop.\nShare (root only)\nThe first two Share options, Add Share and List Shares, allow adding and display of shares.  Add Share shares a directory.  The fields and toggles exactly match Samba configuration options; refer to Samba's documentation for more information.  List Shares displays active shares and allows you to delete selected shares.\nThe SMB Server allows you to activate or deactivate Samba and set global configuration options.  The Load Defaults button loads default values for most fields.  As with Add Shares, the options here exactly match options in the Samba configuration file.  The tabs correspond to sections of smb.conf; click on the tab to view options for that section.  OK writes a new smb.conf, Cancel cancels the changes and reverts to prior settings."
};

/* Help 'OK' callback; destroy the calling widget.  Clear reason for call */
void GHelpOK_CB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XtDestroyWidget((Widget)client_data);
}

/* Help to display when 'Help' menu button is clicked. */
void GeneralHelp(IfaceBranche * IbPtr) {
  Widget ghelp_shell, ghelp_form, ghelp_stext, ghelp_ok;
  Arg args[10];
  XmString helpmsg, ok_s;

  XtSetArg(args[0], XmNtitle, "bxfm: Help!");

  ghelp_shell = XtCreatePopupShell("ghelp_shell", wmShellWidgetClass,
				   IbPtr->top_level, args, 1);
  ghelp_form = XtVaCreateManagedWidget("ghelp_form", xmFormWidgetClass,
				       ghelp_shell, XmNwidth, 400, 
				       XmNheight, 400, NULL);
  ok_s = XmStringCreate("Close", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[0], XmNeditable, False);
  XtSetArg(args[1], XmNtopAttachment, XmATTACH_FORM);
  XtSetArg(args[2], XmNleftAttachment, XmATTACH_FORM);
  XtSetArg(args[3], XmNrightAttachment, XmATTACH_FORM);
  XtSetArg(args[4], XmNvalue, ghelp);
  XtSetArg(args[5], XmNcursorPositionVisible, False);
  XtSetArg(args[6], XmNeditMode, XmMULTI_LINE_EDIT);
  XtSetArg(args[7], XmNheight, 375);
  XtSetArg(args[8], XmNwordWrap, True);
  XtSetArg(args[9], XmNscrollHorizontal, False);
  ghelp_stext = XmCreateScrolledText(ghelp_form, "ghelp", args, 10);
  XtManageChild(ghelp_stext);
  ghelp_ok = XtVaCreateManagedWidget("ghelp_ok", 
				     xmPushButtonWidgetClass, ghelp_form,
				     XmNlabelString, ok_s,
				     XmNtopAttachment, XmATTACH_WIDGET,
				     XmNtopWidget, ghelp_stext,
				     XmNwidth, 200,
				     XmNleftAttachment, XmATTACH_FORM,
				     XmNrightAttachment, XmATTACH_FORM,
				     XmNbottomAttachment, XmATTACH_FORM, NULL);
  XtAddCallback(ghelp_ok, XmNactivateCallback, GHelpOK_CB, ghelp_shell);
  XtPopup(ghelp_shell, XtGrabNone);
  XmStringFree(ok_s);
}

void HelpAbout(IfaceBranche * IbPtr)
{
  Widget about_shell, about_form, about_label, about_pb, about_l1, about_l2;
  XmString name_str, author_str, close_s;
  Arg args[2];
  XpmAttributes attribs;
  Pixmap atompix;
  Display *mydisplay = XtDisplay(IbPtr->top_level);
  char * text;

  XtSetArg(args[0], XmNtitle, "bxfm: About this program");
  about_shell = XtCreatePopupShell("about_shell", vendorShellWidgetClass,
				   IbPtr->top_level, args, 1);
  about_form = XtVaCreateManagedWidget("about_form", xmFormWidgetClass,
				       about_shell, NULL);

	text = calloc(strlen("Bryan's File Manager") + strlen(VERSION) + 3, sizeof(char));
	sprintf(text, "%s %s", "Bryan's File Manager", VERSION);
  name_str = XmStringCreate(text, XmSTRING_DEFAULT_CHARSET); 
	free(text);
//  name_str = XmStringCreate("Bryan's File Manager", XmSTRING_DEFAULT_CHARSET); 
  author_str = XmStringCreateLtoR("Written by Bryan Herger\nRensselaer Polytechnic Institute\nhergeb@rpi.edu\nhttp://www.rpi.edu/~hergeb/bxfm.html", XmSTRING_DEFAULT_CHARSET);
  close_s = XmStringCreate("Close", XmSTRING_DEFAULT_CHARSET);
  attribs.closeness=40000;
  attribs.valuemask=XpmSize | XpmCloseness;
  XpmCreatePixmapFromData(mydisplay, DefaultRootWindow(mydisplay),
			  atom_xpm, &atompix, NULL, &attribs);
  about_l1 = XtVaCreateManagedWidget("about_l1", xmLabelWidgetClass,
				     about_form, XmNlabelType, XmPIXMAP,
				     XmNlabelPixmap, atompix,
				     XmNlabelInsensitivePixmap, atompix,
				     XmNtopAttachment, XmATTACH_FORM,
				     XmNleftAttachment, XmATTACH_FORM, NULL);
  about_l2 = XtVaCreateManagedWidget("about_l2", xmLabelWidgetClass,
				     about_form, XmNlabelString, name_str,
				     XmNheight, 60,
				     XmNtopAttachment, XmATTACH_FORM,
				     XmNleftAttachment, XmATTACH_WIDGET,
				     XmNleftWidget, about_l1,
				     XmNrightAttachment, XmATTACH_FORM, NULL);
  about_label = XtVaCreateManagedWidget("about_l3", xmLabelWidgetClass,
					about_form, XmNlabelString, author_str,
					XmNtopAttachment, XmATTACH_WIDGET,
					XmNtopWidget, about_l1,
					XmNleftAttachment, XmATTACH_FORM,
					XmNrightAttachment, XmATTACH_FORM,
					NULL);
  about_pb = XtVaCreateManagedWidget("about_close", xmPushButtonWidgetClass,
				     about_form, XmNlabelString, close_s,
				     XmNtopAttachment, XmATTACH_WIDGET,
				     XmNtopWidget, about_label,
				     XmNleftAttachment, XmATTACH_FORM,
				     XmNrightAttachment, XmATTACH_FORM,
				     XmNbottomAttachment, XmATTACH_FORM,
				     NULL);
  XtAddCallback(about_pb, XmNactivateCallback, GHelpOK_CB, about_shell);
  XtPopup(about_shell, XtGrabNone);
  XmStringFree(author_str);
  XmStringFree(close_s);
}

/* Popup help topic (int)client_data in a scrolled text window. */
void HelpTopic(Widget w, XtPointer client_data, XtPointer call_data) {
  Widget help_shell, help_form, help_stext, help_ok, help_about;
  Arg args[10];
  XmString helpmsg, ok_s;
  char topic[750];
  int help_stat;
  IfaceBranche * IbPtr;
  printf("HELP\n");
  XtVaGetValues(w, XmNuserData, &IbPtr, NULL);

  help_stat = (int)client_data;

  if (help_stat == CANT_READ)
    strcpy(topic, "You don't have permission to read the specified file.  Check the permissions using 'Info'.  If you own the file, change the permissions to allow read.  Otherwise, ask the owner for read access.");
  if (help_stat == CANT_WRITE)
    strcpy(topic, "You don't have write permission for the specified file or directory.  If the file exists, change permission to allow writing.  If the file doesn't exist, then you do not have write permission on the directory.  Check the permissions on the directory the file is in.");
  if (help_stat == CANT_EXECUTE)
    strcpy(topic, "The execute bit is not set on the file.  Most likely this is because the file is not an executable.  Or, you may not have read access to the file.  Check the permissions; verify that the read and execute permissions are set.  Note that directories have the execute permission but you cannot run them.");
  if (help_stat == CANT_DELETE)
    strcpy(topic, "You can't delete a file unless you have write permission for that file.  It is also beneficial if you own the file, as it is impolite to delete other people's files without their knowledge.");
  if (help_stat == CANT_READ_DIR)
    strcpy(topic, "You don't have permission to list the contents of the specified directory.  You must have Read and Execute permission to list a directory.  Use \"File/Info\" to change the permissions if you own the directory, or ask the owner or administrator for permission.");
  if (help_stat == CANT_FIND)
    strcpy(topic, "That file or program could not be found in the location specified or in the path.  It is possible that the file doesn't exist or that you can't read the directory containing it.");
  if (help_stat == NOT_EXECUTABLE)
    strcpy(topic, "The file selected is not runnable.  If it really is something executable, like a script or program, set the execute permission on the file.  Note that directories have the execute permission set but are not really executable.");
  if (help_stat == CANT_ACCESS_SRC)
    strcpy(topic, "You don't have read permission for the file you are trying to copy or move, or you cannot read the directory containing it.  Check the permissions on the file and the directory it's in.");
  if (help_stat == CANT_ACCESS_DEST)
    strcpy(topic, "You don't have write permission for the file or directory you are trying to copy or move to, or you cannot read the directory containing the destination.  Check the permissions on the destination directory.");
  if (help_stat == OPERATION_FAILED)
    strcpy(topic, "This error is reported when the program has no idea what went wrong.  Something bad happened, probably in an external program that was called by system().  If you see this persistently, please e-mail hergeb@rpi.edu and describe exactly how to duplicate the problem and it will be put on the bug list.");
  if (help_stat == SMB_NOT_RUNNING)
    strcpy(topic, "The SMB server must be running before you add shares or change parameters.  Enable the server using the SMB server window under the Share menu.");
  if (help_stat == NOT_A_DIRECTORY)
    strcpy(topic, "The specified item is not a directory.  Check spelling and verify the path.");
  if (help_stat == DIR_NOT_EXIST)
    strcpy(topic, "The specified directory doesn't exist.  Double-check the path.  Use the Create option under the Directory menu to create it.");
  if (help_stat == CANT_WRITE_DIR)
    strcpy(topic, "You don't have permission to write to the specified directory.  Check the permissions.  This error may also occur if you can't access one of the parents of the specified directory.");
  if (help_stat == IT_ALREADY_EXISTS)
    strcpy(topic, "The specified destination file already exists.  Change the name of one of the files, or delete the existing file.");
  if (help_stat == DONT_HAVE_FIND)
    strcpy(topic, "The find command failed.  A POSIX-compliant find must be in your path for Find to work.  Ask your system administrator to install or reinstall GNU findutils.");

  if (help_stat == FILE_HELP_RUN)
    strcpy(topic, "Enter the full path of the program to run and press Enter.  You need only enter the name of the program if the program is in default search path.");
  if (help_stat == FILE_HELP_COPY)
    strcpy(topic, "Enter the file or directory to be copied or moved (the \"source\") in the top text field, and the place to which this item should be copied or moved (the \"destination\") in the next text field.  Click OK to complete the operation.");
  if (help_stat == FILE_HELP_DELETE)
    strcpy(topic, "Click \"OK\" to delete the named item.  If the item is a directory, all subdirectories will be removed as well.  Files which are deleted in this manner cannot be recovered.");
  if (help_stat == FILE_HELP_INFO)
    strcpy(topic, "Various information about a file or directory are displayed here.  The first two lines are the full path and size (or [Directory]).  The next three lines tell who owns the file.  The permissions shows the permissions on the file in octal; this is the value in the ST_MODE field after stat() of the file.  The permissions are translated into a more meaningful form in the toggle buttons.  Toggling the buttons has no effect.  Press \"OK\" to close this window.");
  if (help_stat == FILE_HELP_FIND)
    strcpy(topic, "Enter the pattern to search for in the top text field.  You may enter wildcards.  In the next text field, enter the directory to search; all subdirectories of this directory will also be searched if you have permission to read the directory.  Click \"/\" to start searching from the root directory; click \"Home\" to start searching from your home directory.  Click OK to search.  The results will appear in a new window.");
  if (help_stat == FIND_WINDOW)
    strcpy(topic, "Select files and use options in the File menu to run, copy, move, delete, or get info on the item.  You can copy a file or directory listed in the find window to the directory displayed in the main window by dragging the list item to the file display in the main window.  Use the middle button to darg and drop.");
  if (help_stat == DIRECTORY_HELP_CREATE)
    strcpy(topic, "This function creates a new subdirectory of the current directory.  Permissions can be set using the toggle buttons.  Remember that you must have Read and Execute permissions to list a directory.");

  XtSetArg(args[0], XmNtitle, "bxfm: Help!");
  help_shell = XtCreatePopupShell("help_shell", vendorShellWidgetClass,
				  IbPtr->top_level, args, 1);
  help_form = XtVaCreateManagedWidget("help_form", xmFormWidgetClass,
				      help_shell, XmNwidth, 400, 
				      XmNheight, 175, NULL);
  ok_s = XmStringCreate("Close", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[0], XmNeditable, False);
  XtSetArg(args[1], XmNtopAttachment, XmATTACH_FORM);
  XtSetArg(args[2], XmNleftAttachment, XmATTACH_FORM);
  XtSetArg(args[3], XmNrightAttachment, XmATTACH_FORM);
  XtSetArg(args[4], XmNvalue, topic);
  XtSetArg(args[5], XmNcursorPositionVisible, False);
  XtSetArg(args[6], XmNeditMode, XmMULTI_LINE_EDIT);
  XtSetArg(args[7], XmNheight, 150);
  XtSetArg(args[8], XmNwordWrap, True);
  XtSetArg(args[9], XmNscrollHorizontal, False);
  help_stext = XmCreateScrolledText(help_form, "ghelp", args, 10);
  XtManageChild(help_stext);
  help_ok = XtVaCreateManagedWidget("help_ok", 
				    xmPushButtonWidgetClass, help_form,
				    XmNlabelString, ok_s,
				    XmNtopAttachment, XmATTACH_WIDGET,
				    XmNtopWidget, help_stext,
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNrightAttachment, XmATTACH_FORM,
				    XmNbottomAttachment, XmATTACH_FORM, NULL);
  XtAddCallback(help_ok, XmNactivateCallback, GHelpOK_CB, help_shell);
  XtPopup(help_shell, XtGrabNone);
  XmStringFree(ok_s);
}






