/* getinfo.c -- Get and print information about a file.
 *
 * Ripped from my Comp. Graphics term project.
 */

#include <pwd.h>
#include <grp.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>

#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/cursorfont.h>
#include <X11/IntrinsicP.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/MessageB.h>
#include <Xm/Label.h>
#include <Xm/ToggleB.h>
#include <Xm/TextF.h>
#include <Xm/ComboBox.h>
#include <Xm/Frame.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/DialogS.h>
#include <Xm/GrabShell.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>

#include "Folder.h"
#include "XmNl/XmNlItemBox.h"
#include "XmNl/XmNl.h"

#include <dirent.h>
#include <X11/xpm.h>
#include "defines.h"
#include "core.h"
#include "helpsys.h"
#include "getdir.h"
#include "utils.h"
#include "errormsg.h"


#define CANCEL 0
#define OK 1

#define ICON_BIG_TYPE 1
#define ICON_SMALL_TYPE 2


const char ButtonBigIconName[] = "BigIconEdit";
const char ButtonSmallIconName[] = "SmallIconEdit";

struct InfoDialogProp
{
	IfaceBranche * IbPtr;
	struct filedata * fptr;
	char * full_name;
	char * path;
	int need_free;
	Widget iconList;
	Widget iconDialog;
	appPixmapList * startIconNode;
	appPixmapList * selectedLargeIconNode;
	appPixmapList * selectedSmallIconNode;
	int popupOn;
	int waitCursor;
	Widget lastFocusedButton;
	Widget labelIconDisplayed;
	XtWorkProcId addIconWorkProcId;
	char * selectedNameIcon;
	int iconType;
	Widget comboAction;
};

struct _ActionNode
{
	char * name;
	struct _ActionNode * next;
} typedef ActionNode;

ActionNode * ActionNodeList = NULL;

int ActionNumber = 0;

extern pthread_mutex_t iface_mutex;
extern pthread_mutex_t config_mutex;

extern bxfm_ftype ** ftype_list;
extern int count_all;
extern int count_current;
extern char * path_icons_set;

const char *path_to_textfield[] = {"folder", "form1", "frame_name", "name", "filename", NULL};
const char *path_to_filepath[] = {"folder", "form1", "frame_name", "name", "path_row_col", "path_info", NULL};
const char *path_to_owner[] = {"folder", "form2", "owner_form", "frame1", "owner_row_col", "owner_combo", NULL};
const char *path_to_group[] = {"folder", "form2", "owner_form", "frame1", "owner_row_col", "group_combo", NULL};

const char *path_to_time1[] = {"folder", "form1", "frame_time", "time", "time1_row_col", "time1_info", NULL};
const char *path_to_time2[] = {"folder", "form1", "frame_time", "time", "time2_row_col", "time2_info", NULL};
const char *path_to_time3[] = {"folder", "form1", "frame_time", "time", "time3_row_col", "time3_info", NULL};

const char *path_to_size[] = {"folder", "form1", "frame_type", "type", "size_row_col", "file_size_info", NULL};

const char *path_to_perms[] = {"folder", "form2", "frame3", "perm_ctl_form", NULL};

const char *path_to_user_read[] = {"folder", "form2", "frame3", "perm_ctl_form", "info_rc1", "read", NULL};
const char *path_to_user_write[] = {"folder", "form2", "frame3", "perm_ctl_form", "info_rc1", "write", NULL};
const char *path_to_user_execute[] = {"folder", "form2", "frame3", "perm_ctl_form", "info_rc1", "execute", NULL};

const char *path_to_group_read[] = {"folder", "form2", "frame3", "perm_ctl_form", "info_rc2", "read", NULL};
const char *path_to_group_write[] = {"folder", "form2", "frame3", "perm_ctl_form", "info_rc2", "write", NULL};
const char *path_to_group_execute[] = {"folder", "form2", "frame3", "perm_ctl_form", "info_rc2", "execute", NULL};

const char *path_to_other_read[] = {"folder", "form2", "frame3", "perm_ctl_form", "info_rc3", "read", NULL};
const char *path_to_other_write[] = {"folder", "form2", "frame3", "perm_ctl_form", "info_rc3", "write", NULL};
const char *path_to_other_execute[] = {"folder", "form2", "frame3", "perm_ctl_form", "info_rc3", "execute", NULL};

const char *path_to_spec_suid[] = {"folder", "form2", "frame3", "perm_ctl_form", "info_rc4", "suid", NULL};
const char *path_to_spec_sgid[] = {"folder", "form2", "frame3", "perm_ctl_form", "info_rc4", "sgid", NULL};
const char *path_to_spec_sticky[] = {"folder", "form2", "frame3", "perm_ctl_form", "info_rc4", "sticky", NULL};

const char **path_to_all_perms_and_grp[] = {path_to_user_read, path_to_user_write, path_to_user_execute,
									path_to_group_read, path_to_group_write, path_to_group_execute,
									path_to_other_read, path_to_other_write, path_to_other_execute,
									path_to_spec_suid, path_to_spec_sgid, path_to_spec_sticky, path_to_group, NULL};


extern void PutEvent(IfaceBranche * IbPtr, WatchEvent * Ev);
static int GetDialPix(IfaceBranche * IbPtr, int typeIcon, Widget w, Pixmap icon, Pixmap mask);


static void ChangeSensitive(Widget w, const char ***path, Boolean sense) 
{
	Widget child;
	int i = 0;
	
	while (path[i])
	{
		child = find_child(w, path[i]);
		if (child)
			XtVaSetValues(child, XmNsensitive, sense, NULL);
			
		i++;
	}
}



static void CleanWidgetUserDataCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	void * ptr;
	
	XtVaGetValues(w, XmNuserData, &ptr, NULL);
	if (ptr)
		free(ptr);
		
#ifdef DEBUG
	printf("Cleaned user data for widget \"%s\"\n", XtName(w));
#endif
}

static void DestroyDialogCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	IfaceBranche * IbPtr = (IfaceBranche *) client_data;
	struct filedata * fileptr;
	struct InfoDialogProp * InfDlgPrp;
	void * ptr;

	IbPtr->info_dialog = NULL;

#ifdef DEBUG
	printf("Destroy dialog callback %s\n", XtName(w));
#endif
	
	XtVaGetValues(w, XmNuserData, &ptr, NULL);
	
	InfDlgPrp = (struct InfoDialogProp *) ptr;

	if (!InfDlgPrp)
		return ;

	if (InfDlgPrp->addIconWorkProcId > 0)
	{
#ifdef DEBUG
		printf("addIconWorkProcId = %lu\n", InfDlgPrp->addIconWorkProcId);
#endif
		XtRemoveWorkProc(InfDlgPrp->addIconWorkProcId);
	}

	fileptr = InfDlgPrp->fptr;
	
	if (InfDlgPrp->need_free && fileptr && fileptr->name)
	{
		if (fileptr->name)
			free(fileptr->name);
		if (fileptr->info)
			free(fileptr->info);
		if (fileptr->linkto)
			free(fileptr->linkto);
				
		free(fileptr);
	}
	
	if (InfDlgPrp->full_name)
		free(InfDlgPrp->full_name);

	if (InfDlgPrp->path)
		free(InfDlgPrp->path);
		
	free(InfDlgPrp);
}



static int check_change_association(Widget w, IfaceBranche * IbPtr)
{
	Widget text = NULL;
	char * buf = NULL;
	char * src, * dst;
	int ret;
	struct filedata * fdp;
	struct InfoDialogProp * InfDlgPrp;
	bxfm_ftype * typePtr;
		
	XtVaGetValues(w, XmNuserData, &InfDlgPrp, NULL);

	if (!InfDlgPrp)
		return 1;

	if (!InfDlgPrp->comboAction)
		return 1;

	fdp = InfDlgPrp->fptr;

	if (!fdp)
		return 1;

	if (!fdp->magic)
		return 1;
		
	typePtr = (bxfm_ftype *) fdp->magic;

	XtVaGetValues(InfDlgPrp->comboAction, XmNtextField, &text, NULL);

	if (text)
		buf = XmTextFieldGetString(text);
	else
		printf("Text from combo box not found\n");


	pthread_mutex_lock(&config_mutex);
	if (typePtr->action)
	{
		if (buf && (0 != strcmp(buf, typePtr->action)))
		{
#ifdef DEBUG
			printf("New assotiation: %s last association: %s\n", buf, typePtr->action);
#endif
			free(typePtr->action);
			typePtr->action = NULL;
			if (0 != strcmp(buf, resdata.DialInfoEmptyItemString))
				typePtr->action = strdup(buf);
			pthread_mutex_unlock(&config_mutex);
			goto l1;
		}
		if (!buf)
		{
#ifdef DEBUG
			printf("New assotiation set empty\n");
#endif
			free(typePtr->action);
			pthread_mutex_unlock(&config_mutex);
			goto l1;
		}
		pthread_mutex_unlock(&config_mutex);
	}
	else
	{
		if (buf && (0 != strcmp(buf, resdata.DialInfoEmptyItemString)))
		{
#ifdef DEBUG
			printf("New assotiation: %s last association is empty\n", buf);
#endif
			typePtr->action = strdup(buf);
		}
		pthread_mutex_unlock(&config_mutex);
	}
		
l1:	

	if (buf)
		XtFree(buf);

	return 0;
}

static int check_change_icon(Widget w, IfaceBranche * IbPtr)
{
	struct filedata * fdp = NULL;
	struct InfoDialogProp * InfDlgPrp;
	bxfm_ftype * typePtr;

	XtVaGetValues(w, XmNuserData, &InfDlgPrp, NULL);

	if (!InfDlgPrp)
		return 1;

	if (!InfDlgPrp->selectedLargeIconNode && !InfDlgPrp->selectedSmallIconNode)
		return 1;

	fdp = InfDlgPrp->fptr;

	if (!fdp)
		return 1;

	if (!fdp->magic)
		return 1;
		
	typePtr = (bxfm_ftype *) fdp->magic;
	
#ifdef DEBUG
	if (typePtr->magic)
		printf("Change icon for type: %s\n", typePtr->magic);
#endif

	if (InfDlgPrp->selectedLargeIconNode)
	{
		if (InfDlgPrp->selectedLargeIconNode->icon > 2)
		{
			typePtr->big_pixmap = InfDlgPrp->selectedLargeIconNode->icon;
				if (InfDlgPrp->selectedLargeIconNode->mask > 2)
					typePtr->big_mask = InfDlgPrp->selectedLargeIconNode->mask;

#ifdef DEBUG
			printf("New icon: %s old icon: %s\n",InfDlgPrp->selectedLargeIconNode->name, typePtr->big_icon_name);
#endif
			if (typePtr->big_icon_name)
				free(typePtr->big_icon_name);
			
			typePtr->big_icon_name = calloc(strlen(InfDlgPrp->selectedLargeIconNode->name) + 1, sizeof(char));

			if (typePtr->big_icon_name)
				strcpy(typePtr->big_icon_name, InfDlgPrp->selectedLargeIconNode->name);
		}
	}

	if (InfDlgPrp->selectedSmallIconNode)
	{
		if (InfDlgPrp->selectedSmallIconNode->icon > 2)
		{
			typePtr->small_pixmap = InfDlgPrp->selectedSmallIconNode->icon;
				if (InfDlgPrp->selectedSmallIconNode->mask > 2)
					typePtr->small_mask = InfDlgPrp->selectedSmallIconNode->mask;

#ifdef DEBUG
			printf("New icon: %s old icon: %s\n",InfDlgPrp->selectedSmallIconNode->name, typePtr->small_icon_name);
#endif
			if (typePtr->small_icon_name)
				free(typePtr->small_icon_name);
			
			typePtr->small_icon_name = calloc(strlen(InfDlgPrp->selectedSmallIconNode->name) + 1, sizeof(char));

			if (typePtr->small_icon_name)
				strcpy(typePtr->small_icon_name, InfDlgPrp->selectedSmallIconNode->name);
		}
	}
	
	return 0;
}


static int check_change_owner(Widget w, IfaceBranche * IbPtr)
{
	Widget text = NULL, owner = NULL;
	char * buf = NULL;
	char * current_owner_name;
	char * src, * dst;
	struct passwd * pass;
	int ret;
	Boolean active;
	struct filedata * fdp = NULL;
	struct InfoDialogProp * InfDlgPrp;

	owner = find_child(w, path_to_owner);

	if (!owner)
		return 1;

	XtVaGetValues(owner, XmNsensitive, &active, NULL);
	
	if (!active)
	{
#ifdef DEBUG		
		printf("Not permissions\n");
#endif
		return 0 ;
	}

	XtVaGetValues(w, XmNuserData, &InfDlgPrp, NULL);

	if (!InfDlgPrp)
		return 1;

	fdp = InfDlgPrp->fptr;

	if (!fdp)
		return 1;

	if (!fdp->info)
		return 1;

	XtVaGetValues(owner, XmNtextField, &text, NULL);
	
	if (!text)
		return 1;

	buf = XmTextFieldGetString(text);
	
	if (!buf || 0 == strlen(buf))
	{
		if (buf)
			XtFree(buf);
		return 1;
	}

	pass = getpwuid(fdp->info->f_owner);
	if (pass != NULL)
		current_owner_name = strdup(pass->pw_name);

	if (0 == strcmp(buf, current_owner_name))
	{
		if (buf)
			XtFree(buf);
		if (current_owner_name)
			free(current_owner_name);
		return 0;
	}

	src = calloc(strlen(InfDlgPrp->full_name) + 1, sizeof(char));
//	src = calloc(strlen(IbPtr->current_wd) + strlen(fdp->name) + 3, sizeof(char));

	if (!src)
	{
		if (buf)
			XtFree(buf);
		if (current_owner_name)
			free(current_owner_name);
		return 1;
	}

	sprintf(src, "%s", InfDlgPrp->full_name);
//	sprintf(src, "%s/%s", IbPtr->current_wd, fdp->name);

	pass = getpwnam(buf);

	if (!pass)
	{
		if (src)
			free(src);
		if (buf)
			XtFree(buf);
		if (current_owner_name)
			free(current_owner_name);
				
		return 1;
	}

	ret = chown(src, pass->pw_uid, -1);

	if (src)
		free(src);

	if (buf)
		XtFree(buf);

	if (current_owner_name)
		free(current_owner_name);
				
	return ret;
}


static int check_change_group(Widget w, IfaceBranche * IbPtr)
{
	Widget text = NULL, group = NULL;
	char * buf = NULL;
	char * src, * dst;
	char * current_group_name;
	struct group * grp;
	int ret;
	Boolean active;
	struct filedata * fdp = NULL;
	struct InfoDialogProp * InfDlgPrp;


	group = find_child(w, path_to_group);

	if (!group)
		return 1;

	XtVaGetValues(group, XmNsensitive, &active, NULL);
	
	if (!active)
	{
#ifdef DEBUG		
		printf("Not permissions\n");
#endif
		return 0 ;
	}

	XtVaGetValues(w, XmNuserData, &InfDlgPrp, NULL);

	if (!InfDlgPrp)
		return 1;

	fdp = InfDlgPrp->fptr;

	if (!fdp)
		return 1;

	if (!fdp->info)
		return 1;
	
	XtVaGetValues(group, XmNtextField, &text, NULL);
	
	if (!text)
		return 1;

	buf = XmTextFieldGetString(text);
	
	if (!buf || 0 == strlen(buf))
	{
		if (buf)
			XtFree(buf);
		return 1;
	}

	grp = getgrgid(fdp->info->f_owngrp);
	if (grp != NULL)
		current_group_name = strdup(grp->gr_name);

	if (!current_group_name)
	{
		if (buf)
			XtFree(buf);
		return 1;
	}

	if (0 == strcmp(buf, current_group_name))
	{
		if (buf)
			XtFree(buf);
		if (current_group_name)
			free(current_group_name);
		return 0;
	}

	src = calloc(strlen(InfDlgPrp->full_name) + 1, sizeof(char));
//	src = calloc(strlen(IbPtr->current_wd) + strlen(fdp->name) + 3, sizeof(char));

	if (!src)
	{
		if (buf)
			XtFree(buf);
		if (current_group_name)
			free(current_group_name);
		return 1;
	}

	sprintf(src, "%s", InfDlgPrp->full_name);
//	sprintf(src, "%s/%s", IbPtr->current_wd, fdp->name);

	grp = getgrnam(buf);

	if (!grp)
	{
		if (src)
			free(src);

		if (buf)
			XtFree(buf);
				
		if (current_group_name)
			free(current_group_name);

		return 1;
	}

	
	ret = chown(src, -1, grp->gr_gid);

	if (src)
		free(src);

	if (buf)
		XtFree(buf);

	if (current_group_name)
		free(current_group_name);
				
	return ret;
}


static int check_change_perm(Widget w, IfaceBranche * IbPtr)
{
	Widget perm = NULL, toggle = NULL;
	char * src;
	mode_t current_mode, new_mode = 0;
	int ret;
	Boolean active;
	unsigned char state;
	struct filedata * fdp;
	struct InfoDialogProp * InfDlgPrp;

	perm = find_child(w, path_to_perms);

	if (!perm)
		return 1;

	XtVaGetValues(perm, XmNsensitive, &active, NULL);
	
	if (!active)
	{
#ifdef DEBUG		
		printf("Not permissions to change permissions\n");
#endif
		return 0 ;
	}
	
	XtVaGetValues(w, XmNuserData, &InfDlgPrp, NULL);

	if (!InfDlgPrp)
		return 1;

	fdp = InfDlgPrp->fptr;
	
	if (!fdp)
		return 1;

	if (!fdp->info)
		return 1;
	
	current_mode = fdp->info->f_perm;

/**** User perms ****/
	toggle = find_child(w, path_to_user_read);
	
	if (!toggle)
		return 1;
	
	XtVaGetValues(toggle, XmNset, &state, NULL);
	
	if (XmSET == state)
	{
		new_mode = new_mode | 256;
	}
	
	toggle = find_child(w, path_to_user_write);
	
	if (!toggle)
		return 1;

	XtVaGetValues(toggle, XmNset, &state, NULL);
	
	if (XmSET == state)
	{
		new_mode = new_mode | 128;
	}
	
	toggle = find_child(w, path_to_user_execute);
	
	if (!toggle)
		return 1;

	XtVaGetValues(toggle, XmNset, &state, NULL);
	
	if (XmSET == state)
	{
		new_mode = new_mode | 64;
	}


/**** Group perms ****/
	toggle = find_child(w, path_to_group_read);
	
	if (!toggle)
		return 1;
	
	XtVaGetValues(toggle, XmNset, &state, NULL);
	
	if (XmSET == state)
	{
		new_mode = new_mode | 32;
	}
	
	toggle = find_child(w, path_to_group_write);
	
	if (!toggle)
		return 1;

	XtVaGetValues(toggle, XmNset, &state, NULL);
	
	if (XmSET == state)
	{
		new_mode = new_mode | 16;
	}
	
	toggle = find_child(w, path_to_group_execute);
	
	if (!toggle)
		return 1;

	XtVaGetValues(toggle, XmNset, &state, NULL);
	
	if (XmSET == state)
	{
		new_mode = new_mode | 8;
	}


/**** Others perms ****/
	toggle = find_child(w, path_to_other_read);
	
	if (!toggle)
		return 1;
	
	XtVaGetValues(toggle, XmNset, &state, NULL);
	
	if (XmSET == state)
	{
		new_mode = new_mode | 4;
	}
	
	toggle = find_child(w, path_to_other_write);
	
	if (!toggle)
		return 1;

	XtVaGetValues(toggle, XmNset, &state, NULL);
	
	if (XmSET == state)
	{
		new_mode = new_mode | 2;
	}
	
	toggle = find_child(w, path_to_other_execute);
	
	if (!toggle)
		return 1;

	XtVaGetValues(toggle, XmNset, &state, NULL);
	
	if (XmSET == state)
	{
		new_mode = new_mode | 1;
	}


/**** Special perms ****/
	toggle = find_child(w, path_to_spec_suid);
	
	if (!toggle)
		return 1;
	
	XtVaGetValues(toggle, XmNset, &state, NULL);
	
	if (XmSET == state)
	{
		new_mode = new_mode | S_ISUID;
	}
	
	toggle = find_child(w, path_to_spec_sgid);
	
	if (!toggle)
		return 1;

	XtVaGetValues(toggle, XmNset, &state, NULL);
	
	if (XmSET == state)
	{
		new_mode = new_mode | S_ISGID;
	}
	
	toggle = find_child(w, path_to_spec_sticky);
	
	if (!toggle)
		return 1;

	XtVaGetValues(toggle, XmNset, &state, NULL);
	
	if (XmSET == state)
	{
		new_mode = new_mode | S_ISVTX;
	}

#ifdef DEBUG		
	printf("New permission %o orig permission %o cmp permission %o\n", new_mode, *current_mode,
		current_mode & (S_IXGRP | S_IRGRP | S_IWGRP | S_IXUSR | S_IRUSR | S_IWUSR | S_IXOTH | S_IROTH | S_IWOTH | S_ISUID | S_ISGID | S_ISVTX));
#endif

	if ((current_mode & (S_IXGRP | S_IRGRP | S_IWGRP | S_IXUSR | S_IRUSR | S_IWUSR | S_IXOTH | S_IROTH | S_IWOTH | S_ISUID | S_ISGID | S_ISVTX)) == new_mode)
	{
#ifdef DEBUG		
		printf("No need to change permission\n");
#endif
		return 0;
	}

	src = calloc(strlen(InfDlgPrp->full_name) + 1, sizeof(char));
//	src = calloc(strlen(IbPtr->current_wd) + strlen(fdp->name) + 3, sizeof(char));

	if (!src)
	{
		return 1;
	}

	sprintf(src, "%s", InfDlgPrp->full_name);
//	sprintf(src, "%s/%s", IbPtr->current_wd, fdp->name);


	ret = chmod(src, new_mode);

	if (src)
		free(src);
				
	return ret;
}


static int check_change_name(Widget w, IfaceBranche * IbPtr)
{
	Widget text = NULL;
	char * buf = NULL;
	char * src, * dst;
	int ret;
	struct filedata * fdp;
	struct InfoDialogProp * InfDlgPrp;
		
	XtVaGetValues(w, XmNuserData, &InfDlgPrp, NULL);

	if (!InfDlgPrp)
		return 1;

	fdp = InfDlgPrp->fptr;

	if (!fdp)
		return 1;

	if (!fdp->info)
		return 1;

	text = find_child(w, path_to_textfield);

	if (!text)
		return 1;

	buf = XmTextFieldGetString(text);
		
	if (!buf)
		return 1;

	if (0 == strlen(buf))
	{
		if (buf)
			XtFree(buf);
		return 2;
	}

	src = calloc(strlen(InfDlgPrp->full_name) + 1, sizeof(char));
//	src = calloc(strlen(IbPtr->current_wd) + strlen(fdp->name) + 3, sizeof(char));

	if (!src)
	{
		if (buf)
			XtFree(buf);
		return 1;
	}

	dst = calloc(strlen(InfDlgPrp->path) + strlen(buf) + 3, sizeof(char));
//	dst = calloc(strlen(IbPtr->current_wd) + strlen(buf) + 3, sizeof(char));

	if (!dst)
	{
		if (src)
			XtFree(src);

		if (buf)
			XtFree(buf);

		return 1;
	}

	sprintf(src, "%s", InfDlgPrp->full_name);
	sprintf(dst, "%s/%s", InfDlgPrp->path, buf);

/*	sprintf(src, "%s/%s", IbPtr->current_wd, fdp->name);
	sprintf(dst, "%s/%s", IbPtr->current_wd, buf);*/

	ret = rename(src, dst);

	if (src)
		XtFree(src);

	if (dst)
		XtFree(dst);

	if (-1 == ret)
	{
		if (buf)
			XtFree(buf);
	}

	return ret;
}

static void HlgCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
	struct InfoDialogProp * InfDlgPrp = (struct InfoDialogProp *) client_data; 
    ListItemReturnStruct * data = (ListItemReturnStruct *) call_data;
    int i;

#ifdef DEBUG		
	printf("HlgCb\n");
	printf("selected %d items \n", data->count);
#endif
	if (data->count == 0) 
		return;

	if (InfDlgPrp->iconType == ICON_BIG_TYPE)
		InfDlgPrp->selectedLargeIconNode =  data->pointers[0];
	else
		InfDlgPrp->selectedSmallIconNode =  data->pointers[0];
}

static void DialEnableWaitCursor(struct InfoDialogProp * InfDlgPrp)
{
	if (!CursorCreated)
	{
		WaithCursor = XCreateFontCursor(XtDisplay(InfDlgPrp->iconList), XC_watch);
		CursorCreated = True;
	}
	
	XDefineCursor(XtDisplay(InfDlgPrp->iconList), XtWindow(InfDlgPrp->iconList), WaithCursor);
	InfDlgPrp->waitCursor = 1;
}

static void DialDisableWaitCursor(struct InfoDialogProp * InfDlgPrp)
{
	if (InfDlgPrp->waitCursor)
	{
		XUndefineCursor(XtDisplay(InfDlgPrp->iconList), XtWindow(InfDlgPrp->iconList));
		InfDlgPrp->waitCursor = 0;
	}
}


Boolean WorkProcIconsProcessing(XtPointer client_data)
{
	struct InfoDialogProp * InfDlgPrp = (struct InfoDialogProp *) client_data; 
	appPixmapList * apPtr = NULL;
	XmNlCell item;
	unsigned char cell_mask;
	char * config_fn, * ptr;


	if (!fullIconComplect)
		return False;

	if (InfDlgPrp->startIconNode)
	{
#ifdef DEBUG
		printf("WorkProc node found: %s\n", InfDlgPrp->startIconNode->name);
#endif
		apPtr = InfDlgPrp->startIconNode;
	
		if (apPtr->icon <= 2)
		{
			InfDlgPrp->startIconNode = apPtr->next;
			if (InfDlgPrp->startIconNode)
				return False ;
			else
			{
				DialDisableWaitCursor(InfDlgPrp);
				return True ;
			}
		}

		if (apPtr->icon > 2 && apPtr->mask > 2)
		{
			item.xmlabel = XmStringCreateLocalized(apPtr->name);
			item.pixmap = apPtr->icon;
			item.mask = apPtr->mask;
			item.UserDataPointer = (void *) apPtr;
			cell_mask = 0;
			cell_mask = cell_mask | CellXmString | CellPixmap | CellMask | CellUserData;
			XmNlItBoxAddItems(InfDlgPrp->iconList, &item, 1, cell_mask);

			XmStringFree(item.xmlabel);
#ifdef DEBUG
			printf("++++++> added %s %lx\n", apPtr->name, apPtr->icon);
#endif
		}
		
		InfDlgPrp->startIconNode = apPtr->next;
		if (InfDlgPrp->startIconNode)
			return False;
	}

	DialDisableWaitCursor(InfDlgPrp);
	return True;
}

#ifdef DEBUG

static void CancelIconSelectCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	struct InfoDialogProp * InfDlgPrp = (struct InfoDialogProp *) client_data; 
	
	printf("CancelCB\n");
}

static void DestroyIconSelectCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	struct InfoDialogProp * InfDlgPrp = (struct InfoDialogProp *) client_data; 
	
	printf("DestroyCB\n");
}
#endif

static void OkIconSelectCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	struct InfoDialogProp * InfDlgPrp = (struct InfoDialogProp *) client_data; 
	Widget label;
	WidgetClass class;
	CoreClassPart core;
	XtExposeProc redisplay;
 
	if (InfDlgPrp)
	{
		if (InfDlgPrp->iconType == ICON_BIG_TYPE && InfDlgPrp->selectedLargeIconNode)
		{
#ifdef DEBUG
			printf("Selected large icon with name %s\n", InfDlgPrp->selectedLargeIconNode->name);
#endif
			GetDialPix(InfDlgPrp->IbPtr, ICON_BIG_TYPE, w, InfDlgPrp->selectedLargeIconNode->icon, 
						InfDlgPrp->selectedLargeIconNode->mask);
		}
		else
			if (InfDlgPrp->iconType == ICON_SMALL_TYPE && InfDlgPrp->selectedSmallIconNode)
			{
#ifdef DEBUG
				printf("Selected small icon with name %s\n", InfDlgPrp->selectedSmallIconNode->name);
#endif
				GetDialPix(InfDlgPrp->IbPtr, ICON_SMALL_TYPE, w, InfDlgPrp->selectedSmallIconNode->icon, 
							InfDlgPrp->selectedSmallIconNode->mask);
			}
			else
				return ;
	}
	
//	XmUpdateDisplay(InfDlgPrp->labelIconDisplayed);
	
	label = InfDlgPrp->labelIconDisplayed;
	if (label)
	{
		class = XtClass(label);
		core = (CoreClassPart) class->core_class;
		redisplay = core.expose;
		((*redisplay)) (label, NULL, NULL);
	}
	
	return ;
}



void SelectIconDialog(Widget w, struct InfoDialogProp * InfDlgPrp) 
{
	XmString info;
	Arg args[10];
	int n;
	Widget dialog, scroll_win, vsb, hsb, list;
	
#ifdef DEBUG
	printf("SelectIconDialog: start\n");
#endif

	if (InfDlgPrp->iconType == ICON_BIG_TYPE)
		info = XmStringCreateLocalized(resdata.DialIconSelectMessageStringLarge);
	else
		info = XmStringCreateLocalized(resdata.DialIconSelectMessageStringSmall);


	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, resdata.DialIconSelectTitleString);
	n++;
	XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); 
	n++;
	dialog = XmCreateWorkingDialog(XtParent(w), "IconSelect", args, n);

	if (info)
		XmStringFree(info);

	XtAddCallback(dialog, XmNokCallback, OkIconSelectCB, (XtPointer) InfDlgPrp);

#ifdef DEBUG
	XtAddCallback(dialog, XmNcancelCallback, CancelIconSelectCB, (XtPointer) InfDlgPrp);
	XtAddCallback(dialog, XmNdestroyCallback, DestroyIconSelectCB, (XtPointer) InfDlgPrp);
#endif

	scroll_win = XtVaCreateManagedWidget("IconSelectWin",
									xmScrolledWindowWidgetClass, dialog,
//									XmNspacing, 2,
									XmNshadowThickness, 2,
									XmNscrollingPolicy, XmAPPLICATION_DEFINED,
//									XmNscrollBarDisplayPolicy, XmSTATIC,
									NULL);

	n = 0;
	XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
	XtSetArg(args[n], XmNmaximum, 1); n++;
	XtSetArg(args[n], XmNsliderSize, 1); n++;
	vsb = XmCreateScrollBar(scroll_win, "vsb", args, n);
	XtManageChild(vsb);

	n = 0;
	XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
	XtSetArg(args[n], XmNmaximum, 1); n++;
	XtSetArg(args[n], XmNsliderSize, 1); n++;
	hsb = XmCreateScrollBar(scroll_win, "hsb", args, n);
	XtManageChild(hsb);


	list = XtVaCreateManagedWidget ("select_iconbox", xmNlItemBoxWidgetClass, scroll_win, 
									XmNviewType, XmLARGE_ICON, 
									XmNverticalScrollBar, vsb, XmNhorizontalScrollBar, hsb, XmNtraversalOn, True, NULL);


	InfDlgPrp->lastFocusedButton = w;
	InfDlgPrp->iconList = list;
	InfDlgPrp->iconDialog = dialog;
	InfDlgPrp->popupOn = 0;

	XtAddCallback(list, XtNhighlightCallback, HlgCallback, (XtPointer) InfDlgPrp);

	XtManageChild(dialog);

	return ;
}


static void button_icon_edit_cb(Widget w, XtPointer client_data, XtPointer widget_data)
{
	struct InfoDialogProp * InfDlgPrp = (struct InfoDialogProp *) client_data; 
	void * ptr;
	char * w_name;
	XmString info;

#ifdef DEBUG		
	printf("IconEditCb for widget %s\n", XtName(w));
#endif

	w_name = XtName(w);
	XtVaGetValues(w, XmNuserData, &ptr, NULL);

	InfDlgPrp->labelIconDisplayed = (Widget) ptr;

	if (0 == strcmp(w_name, ButtonBigIconName))
		InfDlgPrp->iconType = ICON_BIG_TYPE;
	else
		InfDlgPrp->iconType = ICON_SMALL_TYPE;

	if (InfDlgPrp->iconDialog)
	{
		if (InfDlgPrp->iconType == ICON_BIG_TYPE)
			info = XmStringCreateLocalized(resdata.DialIconSelectMessageStringLarge);
		else
			info = XmStringCreateLocalized(resdata.DialIconSelectMessageStringSmall);
	
		XtVaSetValues(InfDlgPrp->iconDialog, XmNmessageString, info, NULL); 
		XtManageChild(InfDlgPrp->iconDialog);
		
		XmStringFree(info);
		return ;
	}

	if (!fullIconComplect) 
		needAddIconToGlobalList = 1;

	SelectIconDialog(w, InfDlgPrp);
	InfDlgPrp->startIconNode = globalPixmapList;
		
	InfDlgPrp->addIconWorkProcId = XtAppAddWorkProc(InfDlgPrp->IbPtr->app, WorkProcIconsProcessing, (XtPointer) InfDlgPrp);

	DialEnableWaitCursor(InfDlgPrp);
	
	return ;
}




static void button_ok_cb(Widget w, XtPointer client_data, XtPointer widget_data)
{
	Widget text = NULL, path_label;
	char * buf1, * buf2, *buf3;
	int ret, i;
	IfaceBranche * ifptr, * IbPtr = (IfaceBranche *) client_data;
	WatchEvent * EvPtr;
	
	ret = check_change_name(w, IbPtr);
	
	if (0 != ret)
	{
#ifdef DEBUG		
		if (1 == ret)
			printf("Error: no enouth memory\n");
		else
			if (2 == ret)
				printf("Error: new file name empty\n");
			else
#endif
				if (-1 == ret)
				{
					perror("Rename error:");
					XtDestroyWidget(w);
					NoCanDo(OPERATION_FAILED, IbPtr, NULL, NULL);
					return ;
				}
	}
	
	ret = check_change_owner(w, IbPtr);

	if (0 != ret)
	{
#ifdef DEBUG		
		if (1 == ret)
			printf("Error: no enouth memory\n");
		else
#endif
			if (-1 == ret)
			{
				perror("Chown error:");
				XtDestroyWidget(w);
				NoCanDo(OPERATION_FAILED, IbPtr, NULL, NULL);
				return ;
			}
	}
	
	ret = check_change_group(w, IbPtr);

	if (0 != ret)
	{
#ifdef DEBUG		
		if (1 == ret)
			printf("Error: no enouth memory\n");
		else
#endif
			if (-1 == ret)
			{
				perror("Chown group error:");
				XtDestroyWidget(w);
				NoCanDo(OPERATION_FAILED, IbPtr, NULL, NULL);
				return ;
			}
	}

	ret = check_change_perm(w, IbPtr);

	if (0 != ret)
	{
#ifdef DEBUG	
		if (1 == ret)
			printf("Error: no enouth memory\n");
		else
#endif
			if (-1 == ret)
			{
				perror("Chmod error:");
				XtDestroyWidget(w);
				NoCanDo(OPERATION_FAILED, IbPtr, NULL, NULL);
				return ;
			}
	}

	ret = check_change_association(w, IbPtr);

#ifdef DEBUG	
	if (0 != ret)
	{
		if (1 == ret)
			printf("Error: no enouth memory\n");
	}
#endif

	ret = check_change_icon(w, IbPtr);

	if (ret == 0)
	{
		pthread_mutex_lock(&iface_mutex);
		ifptr = AllIfaceBranches;
		while(ifptr)
		{
			EvPtr = calloc(1, sizeof(WatchEvent));
			if (!EvPtr)
				break ;
				
			EvPtr->path = strdup(ifptr->current_wd);
			EvPtr->code = NOTIFY_NEED_REDISPLAY;
			EvPtr->next = NULL;
			EvPtr->file_ptr = NULL;
#ifdef DEBUG_WATCH_DIR
			printf("Watching: transmite redisplay event for path %s\n", ifptr->current_wd);
#endif
			PutEvent(ifptr, EvPtr);

			ifptr = ifptr->next_branche;
		}
		pthread_mutex_unlock(&iface_mutex);
	}

//		ReDrawFileArea(IbPtr);

	XtDestroyWidget(w);
	return ;

}

static void button_cancel_cb(Widget w, int button, XtPointer widget_data)
{
	XtDestroyWidget(w);
}


XmStringTable GetActionList(char * current_action_name, int * n_items, int * current_action_number)
{
	ActionNode * ptr, * ptr2;
	char ** user_names;
	int i, n;
	XmStringTable str_list = NULL;

	if (!ActionNodeList)
	{
		n = 0;
		for (i = 0; i < count_current; i++)
		{
			if ((ftype_list[i])->action)
			{
				if (!ActionNodeList)
				{
					ActionNodeList = calloc(1, sizeof(ActionNode));
					if (!ActionNodeList)
					{
						*n_items = 0;
						*current_action_number = 0;
						return NULL;
					}
					ActionNodeList->name = strdup((ftype_list[i])->action);
					ActionNodeList->next = NULL;
					ptr = ActionNodeList;
					ActionNumber++;
					continue ;
				}
				ptr2 = ActionNodeList;
				while (ptr2)
				{
					if (0 == strcmp((ftype_list[i])->action, ptr2->name))
						break ;
					else 
						ptr2 = ptr2->next;
				}
				if (ptr2 == NULL)
				{
					ptr->next = calloc(1, sizeof(ActionNode));
					if (ptr->next == NULL)
						break ;
						
					ptr->next->name = strdup((ftype_list[i])->action);
					ptr = ptr->next;
					ActionNumber++;
				}
			}
		}
	}

	if (!ActionNodeList)
	{
		*n_items = 0;
		*current_action_number = 0;
		return NULL;
	}

	ptr = ActionNodeList;

	*n_items = ActionNumber + 1;
	
	str_list = (XmStringTable) XtMalloc (*n_items * sizeof (XmString *));
	if (!str_list)
	{
		*n_items = 0;
		*current_action_number = 0;
		return NULL;
	}

	str_list[0] = XmStringCreateLocalized(resdata.DialInfoEmptyItemString);

	if (NULL == current_action_name)
		*current_action_number = n;

	n = 1;
	while(ptr)
	{
		if (NULL != current_action_name && *current_action_name != 0)
		{
			if (0 == strcmp(current_action_name, ptr->name))
				*current_action_number = n + 1;
		}
		
		str_list[n] = XmStringCreateLocalized(ptr->name);
		
		ptr = ptr->next;
		n++;
	}

	return str_list;
}



XmStringTable GetOwnerList(char * current_owner_name, int * n_items, int * current_owner_number)
{
	char ** user_names;
	int n;
	XmStringTable str_list = NULL;


	user_names = get_user_list(n_items);

	*current_owner_number = 0;

	if (user_names)
	{
		sort_name(user_names, *n_items);
		
		str_list = (XmStringTable) XtMalloc (*n_items * sizeof (XmString *));
		if (str_list)
		{
			for (n = 0; n < *n_items; n++)
			{
				str_list[n] = XmStringCreateLocalized(user_names[n]);
				if (current_owner_name)
					if (0 == strcmp(current_owner_name, user_names[n]))
						*current_owner_number = n + 1;
						
				if (user_names[n])
					free(user_names[n]);
			}
		}

		free(user_names);
	}

	return str_list;
}

XmStringTable GetGroupListAll(char * filename, int * n_items, int * current_group_number)
{
	char ** group_names;
	char * current_group_name;
	int ngroup, n;
	struct stat buf;
	struct group * grp;
	XmStringTable str_list = NULL;
	
	*n_items = 0;
	
	if (0 != lstat(filename, &buf))
		return NULL;


	grp = getgrgid(buf.st_gid);
	if (grp != NULL)
		current_group_name = strdup(grp->gr_name);

	group_names = get_grp_list(&ngroup);

	*n_items = ngroup;
	
	*current_group_number = 0;
	
	if (group_names)
	{
		sort_name(group_names, ngroup);
		
		str_list = (XmStringTable) XtMalloc (ngroup * sizeof (XmString *));
		if (str_list)
		{
			for (n = 0; n < ngroup; n++)
			{
				str_list[n] = XmStringCreateLocalized(group_names[n]);
				if (current_group_name)
					if (0 == strcmp(current_group_name, group_names[n]))
						*current_group_number = n + 1;
				if (group_names[n])
					free(group_names[n]);
			}
		}
		
		free(group_names);
	}
	return str_list ;
}


XmStringTable GetGroupListUser(char * filename, int * n_items, int * current_group_number)
{
	char ** group_names;
	char * current_group_name;
	int ngroup, n;
	struct stat buf;
	uid_t my_uid;
	struct passwd *pass;
	struct group * grp;
	XmStringTable str_list = NULL;
	
	*n_items = 0;
	
	if (0 != lstat(filename, &buf))
		return NULL;

	my_uid = getuid();
	pass = getpwuid(my_uid);

	grp = getgrgid(buf.st_gid);
	if (grp != NULL)
	{
		current_group_name = strdup(grp->gr_name);
	}
	else 
		return NULL;

	group_names = get_grp_list_for_user(pass->pw_gid, pass->pw_name, current_group_name, &ngroup);

	*n_items = ngroup;
	
	*current_group_number = 0;
	
	if (group_names)
	{
		sort_name(group_names, ngroup);
		
		str_list = (XmStringTable) XtMalloc (ngroup * sizeof (XmString *));
		if (str_list)
		{
			for (n = 0; n < ngroup; n++)
			{
				str_list[n] = XmStringCreateLocalized(group_names[n]);
				if (current_group_name)
				{
					if (0 == strcmp(current_group_name, group_names[n]))
						*current_group_number = n + 1;
				}
				if (group_names[n])
					free(group_names[n]);
			}
		}
		
		free(group_names);
	}
	return str_list ;
}

static int GetDialPix(IfaceBranche * IbPtr, int typeIcon, Widget w, Pixmap icon, Pixmap mask)
{
	Arg args[20];
	int n;
	Pixel background_pixel, foreground_pixel;
	GC gc;
	XGCValues values;
	unsigned long gc_mask;
	Window root;
	int x, y;
	unsigned int width, height, bw, depth;

	XtVaGetValues(w, XmNbackground, &background_pixel, NULL);

	values.foreground = background_pixel;
	values.function = GXcopy;

	gc_mask = GCForeground | GCFunction;
	gc = XCreateGC(XtDisplay(w), XRootWindowOfScreen(XtScreen(w)), gc_mask, &values);
	 
	if (typeIcon == ICON_BIG_TYPE)
	{
		if (IbPtr->DialPixLarge <= XmUNSPECIFIED_PIXMAP)
		{
#ifdef DEBUG	
			printf("Pix not found %lx\n", IbPtr->DialPixLarge);
#endif
			IbPtr->DialPixLarge = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)), 
									maxIconWidth, maxIconHeight, DefaultDepthOfScreen(XtScreen(w)));
			if (IbPtr->DialPixLarge == 0)
				return 0;
		}
#ifdef DEBUG	
		printf("Pix ok %lx\n", IbPtr->DialPixLarge);
#endif

		XFillRectangle(XtDisplay(w), IbPtr->DialPixLarge, gc, 0, 0, maxIconWidth, maxIconHeight);	
#ifdef DEBUG	
		printf("Pix filled\n");
		printf("Icon %lx\n", icon);
#endif

		if (icon > XmUNSPECIFIED_PIXMAP)
		{
			XGetGeometry(XtDisplay(w), icon, &root, &x, &y, &width, &height, &bw, &depth);
			XSetClipOrigin(XtDisplay(w), gc, (maxIconWidth - width) / 2, (maxIconHeight - height) / 2);
			XSetClipMask(XtDisplay(w), gc, mask);
			XCopyArea(XtDisplay(w), icon, IbPtr->DialPixLarge, gc, 0, 0, width, height, 
						(maxIconWidth - width) / 2, (maxIconHeight - height) / 2);
#ifdef DEBUG	
			printf("Icon copyed\n");
#endif
			XFreeGC(XtDisplay(w), gc);
			return 1;
		}
		else
		{
			values.foreground = BlackPixelOfScreen(XtScreen(w));
			gc_mask = GCForeground ;
			XChangeGC(XtDisplay(w), gc, gc_mask, &values);
			XDrawLine(XtDisplay(w), IbPtr->DialPixLarge, gc, 0, 0, maxIconWidth, maxIconHeight);
			XDrawLine(XtDisplay(w), IbPtr->DialPixLarge, gc, 0, maxIconHeight, maxIconWidth, 0);
			XFreeGC(XtDisplay(w), gc);
			return 1;
		}
	}
	else
	{
		if (IbPtr->DialPixSmall <= XmUNSPECIFIED_PIXMAP)
		{
			IbPtr->DialPixSmall = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)), 
									maxIconWidth, maxIconHeight, DefaultDepthOfScreen(XtScreen(w)));
			if (IbPtr->DialPixSmall == 0)
				return 0;
		}

		XFillRectangle(XtDisplay(w), IbPtr->DialPixSmall, gc, 0, 0, maxIconWidth, maxIconHeight);	

		if (icon > XmUNSPECIFIED_PIXMAP)
		{
			XGetGeometry(XtDisplay(w), icon, &root, &x, &y, &width, &height, &bw, &depth);
			XSetClipOrigin(XtDisplay(w), gc, (maxIconWidth - width) / 2, (maxIconHeight - height) / 2);
			XSetClipMask(XtDisplay(w), gc, mask);
			XCopyArea(XtDisplay(w), icon, IbPtr->DialPixSmall, gc, 0, 0, width, height, 
						(maxIconWidth - width) / 2, (maxIconHeight - height) / 2);
			XFreeGC(XtDisplay(w), gc);
			return 1;
		}
		else
		{
			values.foreground = BlackPixelOfScreen(XtScreen(w));
			gc_mask = GCForeground ;
			XChangeGC(XtDisplay(w), gc, gc_mask, &values);
			XDrawLine(XtDisplay(w), IbPtr->DialPixSmall, gc, 0, 0, maxIconWidth, maxIconHeight);
			XDrawLine(XtDisplay(w), IbPtr->DialPixSmall, gc, 0, maxIconHeight, maxIconWidth, 0);
			XFreeGC(XtDisplay(w), gc);
			return 1;
		}
	}
}

static void ChangeOwnToggle(Widget w, XtPointer client_data, XtPointer call_data) 
{
	Widget own, dialog = (Widget) client_data;
	Boolean active;
	unsigned char set;
	
	own = find_child(dialog, path_to_owner);

	if (own)
		XtVaGetValues(own, XmNsensitive, &active, NULL);

	XtVaGetValues(w, XmNset, &set, NULL);

	if (set == XmSET)
	{
		if (own)
		{
			if (!active)
				XtVaSetValues(own, XmNsensitive, TRUE, NULL);
		}
	}
	else
	{
		if (own)
		{
			if (active)
				XtVaSetValues(own, XmNsensitive, FALSE, NULL);
		}
	}
}


static void ChangeGrpToggle(Widget w, XtPointer client_data, XtPointer call_data) 
{
	Widget own, dialog = (Widget) client_data;
	unsigned char set;
	XmStringTable str_list = NULL;
	int n_items, current_item, i, n;
	char * filename;
	uid_t my_uid;
	struct filedata * fdp = NULL;
	IfaceBranche * IbPtr = NULL;
	struct InfoDialogProp * InfDlgPrp;


	XtVaGetValues(w, XmNuserData, (XtPointer) &IbPtr, NULL);

	if (!IbPtr)
		return ;

	own = find_child(dialog, path_to_group);

	if (!own)
		return ;

	XtVaGetValues(own, XmNitemCount, (XtPointer) &n, NULL);

	XtVaGetValues(dialog, XmNuserData, (XtPointer) &InfDlgPrp, NULL);

	if (!InfDlgPrp)
		return ;
		
	fdp = InfDlgPrp->fptr;
	
	if (!fdp)
		return ;

	if (!fdp->info)
		return ;

/*	filename = calloc(strlen(IbPtr->current_wd) + 3 + strlen(fdp->name), sizeof(char));

	if (!filename)
		return ;

	sprintf(filename, "%s/%s", IbPtr->current_wd, fdp->name);*/
	
	filename = InfDlgPrp->full_name;

	XtVaGetValues(w, XmNset, &set, NULL);

	if (set == XmSET)
	{
		str_list = GetGroupListAll(filename, &n_items, &current_item);
		if (str_list)
		{
			for (i = 0; i < n; i++)
			{
				XmComboBoxDeletePos(own, 0);
			}

			XtVaSetValues(own,
						XmNitems, str_list, 
						XmNitemCount, n_items,
//						XmNselectedPosition, current_item,
						XmNsensitive, TRUE, 
						NULL);

			free_string_table(str_list, n_items);

			XtVaSetValues(own,
						XmNselectedPosition, current_item,
						NULL);
			
			XmComboBoxUpdate(own);
		}
	}
	else
	{

		my_uid = getuid();
							
		if (my_uid != 0 && fdp->info->f_owner != my_uid)
		{
			XtVaSetValues(own, XmNsensitive, FALSE, NULL);

//			if (filename)
//				free(filename);
									
			return ;
		}

		str_list = GetGroupListUser(filename, &n_items, &current_item);
		if (str_list)
		{
			for (i = 0; i < n; i++)
			{
				XmComboBoxDeletePos(own, 0);
			}
			
			XtVaSetValues(own,
						XmNitems, str_list, 
						XmNitemCount, n_items,
//						XmNselectedPosition, current_item,
						XmNsensitive, TRUE, 
						NULL);

			free_string_table(str_list, n_items);
	
			XtVaSetValues(own,
						XmNselectedPosition, current_item,
						NULL);

			XmComboBoxUpdate(own);
		}
	}
//	if (filename)
//		free(filename);
}


void ApplyPermChanges(Widget dialog, struct filedata * fdp)
{
	Widget toggle = NULL;
	unsigned char state;
	struct fileinfo * info;
	mode_t new_mode;

	info = fdp->info;
	

	if (!info)
		return ;
		
	new_mode = info->f_perm;
	
/**** User perms ****/
	toggle = find_child(dialog, path_to_user_read);
	
	if (toggle)
	{
		XtVaGetValues(toggle, XmNset, &state, NULL);
	
		if ((XmSET == state && !(new_mode & 256)) || (XmUNSET == state && (new_mode & 256)))
		{
			if (new_mode & 256)
				XtVaSetValues(toggle, XmNset, XmSET, NULL);
			else
				XtVaSetValues(toggle, XmNset, XmUNSET, NULL);
		}
	}
	
	toggle = find_child(dialog, path_to_user_write);
	
	if (toggle)
	{
		XtVaGetValues(toggle, XmNset, &state, NULL);
	
		if ((XmSET == state && !(new_mode & 128)) || (XmUNSET == state && (new_mode & 128)))
		{
			if (new_mode & 128)
				XtVaSetValues(toggle, XmNset, XmSET, NULL);
			else
				XtVaSetValues(toggle, XmNset, XmUNSET, NULL);
		}
	}

	
	toggle = find_child(dialog, path_to_user_execute);
	
	if (toggle)
	{
		XtVaGetValues(toggle, XmNset, &state, NULL);
	
		if ((XmSET == state && !(new_mode & 64)) || (XmUNSET == state && (new_mode & 64)))
		{
			if (new_mode & 64)
				XtVaSetValues(toggle, XmNset, XmSET, NULL);
			else
				XtVaSetValues(toggle, XmNset, XmUNSET, NULL);
		}
	}


/**** Group perms ****/
	toggle = find_child(dialog, path_to_group_read);
	
	if (toggle)
	{
		XtVaGetValues(toggle, XmNset, &state, NULL);
	
		if ((XmSET == state && !(new_mode & 32)) || (XmUNSET == state && (new_mode & 32)))
		{
			if (new_mode & 32)
				XtVaSetValues(toggle, XmNset, XmSET, NULL);
			else
				XtVaSetValues(toggle, XmNset, XmUNSET, NULL);
		}
	}
	
	
	toggle = find_child(dialog, path_to_group_write);
	
	if (toggle)
	{
		XtVaGetValues(toggle, XmNset, &state, NULL);
	
		if ((XmSET == state && !(new_mode & 16)) || (XmUNSET == state && (new_mode & 16)))
		{
			if (new_mode & 16)
				XtVaSetValues(toggle, XmNset, XmSET, NULL);
			else
				XtVaSetValues(toggle, XmNset, XmUNSET, NULL);
		}
	}

	
	toggle = find_child(dialog, path_to_group_execute);
	
	if (toggle)
	{
		XtVaGetValues(toggle, XmNset, &state, NULL);
	
		if ((XmSET == state && !(new_mode & 8)) || (XmUNSET == state && (new_mode & 8)))
		{
			if (new_mode & 8)
				XtVaSetValues(toggle, XmNset, XmSET, NULL);
			else
				XtVaSetValues(toggle, XmNset, XmUNSET, NULL);
		}
	}


/**** Others perms ****/
	toggle = find_child(dialog, path_to_other_read);
	
	if (toggle)
	{
		XtVaGetValues(toggle, XmNset, &state, NULL);
	
		if ((XmSET == state && !(new_mode & 4)) || (XmUNSET == state && (new_mode & 4)))
		{
			if (new_mode & 4)
				XtVaSetValues(toggle, XmNset, XmSET, NULL);
			else
				XtVaSetValues(toggle, XmNset, XmUNSET, NULL);
		}
	}
	
	
	toggle = find_child(dialog, path_to_other_write);
	
	if (toggle)
	{
		XtVaGetValues(toggle, XmNset, &state, NULL);
	
		if ((XmSET == state && !(new_mode & 2)) || (XmUNSET == state && (new_mode & 2)))
		{
			if (new_mode & 2)
				XtVaSetValues(toggle, XmNset, XmSET, NULL);
			else
				XtVaSetValues(toggle, XmNset, XmUNSET, NULL);
		}
	}

	
	toggle = find_child(dialog, path_to_other_execute);
	
	if (toggle)
	{
		XtVaGetValues(toggle, XmNset, &state, NULL);
	
		if ((XmSET == state && !(new_mode & 1)) || (XmUNSET == state && (new_mode & 1)))
		{
			if (new_mode & 1)
				XtVaSetValues(toggle, XmNset, XmSET, NULL);
			else
				XtVaSetValues(toggle, XmNset, XmUNSET, NULL);
		}
	}


/**** Special perms ****/
	toggle = find_child(dialog, path_to_spec_suid);
	
	if (toggle)
	{
		XtVaGetValues(toggle, XmNset, &state, NULL);
	
		if ((XmSET == state && !(new_mode & S_ISUID)) || (XmUNSET == state && (new_mode & S_ISUID)))
		{
			if (new_mode & S_ISUID)
				XtVaSetValues(toggle, XmNset, XmSET, NULL);
			else
				XtVaSetValues(toggle, XmNset, XmUNSET, NULL);
		}
	}
	
	
	toggle = find_child(dialog, path_to_spec_sgid);
	
	if (toggle)
	{
		XtVaGetValues(toggle, XmNset, &state, NULL);
	
		if ((XmSET == state && !(new_mode & S_ISGID)) || (XmUNSET == state && (new_mode & S_ISGID)))
		{
			if (new_mode & S_ISGID)
				XtVaSetValues(toggle, XmNset, XmSET, NULL);
			else
				XtVaSetValues(toggle, XmNset, XmUNSET, NULL);
		}
	}

	
	toggle = find_child(dialog, path_to_spec_sticky);
	
	if (toggle)
	{
		XtVaGetValues(toggle, XmNset, &state, NULL);
	
		if ((XmSET == state && !(new_mode & S_ISVTX)) || (XmUNSET == state && (new_mode & S_ISVTX)))
		{
			if (new_mode & S_ISVTX)
				XtVaSetValues(toggle, XmNset, XmSET, NULL);
			else
				XtVaSetValues(toggle, XmNset, XmUNSET, NULL);
		}
	}
}

void ApplyDateChanges(Widget dialog, struct filedata * fdp, int type)
{
	Widget label = NULL;
	struct fileinfo * info;
	char str_buf[1024];
	XmString str;
	
	info = fdp->info;
	
	if (!info)
		return ;
	
	if (2 == type)
	{	
		if (!get_human_readable_time(&(info->f_mtime), str_buf))
			return ;
			
		label = find_child(dialog, path_to_time2);

		if (!label)
			return ;
			
		str = XmStringCreateLocalized(str_buf);
		
		if (!str)
			return ;
			
		XtVaSetValues(label, XmNlabelString, str, NULL);
		
		XmStringFree(str);
	}
}

void ApplySizeChanges(Widget dialog, struct filedata * fdp)
{
	Widget label = NULL;
	struct fileinfo * info;
	char str_buf[1024];
	XmString str;
	
	info = fdp->info;
	
	if (!info)
		return ;
	
	if (!get_human_readable_size(info->f_size, str_buf, 1))
		return ;
			
	label = find_child(dialog, path_to_size);

	if (!label)
		return ;
			
	str = XmStringCreateLocalized(str_buf);
		
	if (!str)
		return ;
			
	XtVaSetValues(label, XmNlabelString, str, NULL);
		
	XmStringFree(str);
}

void ApplyOwnerChanges(Widget dialog, struct filedata * fdp)
{
	struct passwd *pass;
	char * current_owner_name;
	Widget list = NULL, cbox = NULL;
	struct fileinfo * info;
	char str_buf[1024];
	XmString str;
	int * positions, pos_count = 0;
	Boolean ok;
	uid_t my_uid;

	info = fdp->info;
	
	if (!info)
		return ;

	pass = getpwuid(info->f_owner);
	if (pass != NULL)
		current_owner_name = strdup(pass->pw_name);
		
	if (!current_owner_name)
		return ;

	str = XmStringCreateLocalized(current_owner_name);
	
	free(current_owner_name);
		
	if (!str)
		return ;

	cbox = find_child(dialog, path_to_owner);

	if (!cbox)
		return ;

	XtVaGetValues(cbox, XmNlist, &list, NULL);
	
	if (!list)
	{
		XmStringFree(str);
		return ;
	}

	ok = XmListGetMatchPos(list, str, &positions, &pos_count);
	
	if (ok)
	{
		if (pos_count == 1)
		{
			XtVaSetValues(cbox, XmNselectedPosition, positions[0], NULL);
			my_uid = getuid();
			if (my_uid != info->f_owner)
			{
				ChangeSensitive(dialog, path_to_all_perms_and_grp, False);
			}
			else
			{
				ChangeSensitive(dialog, path_to_all_perms_and_grp, True);
			}
		}
	}
	XmStringFree(str);
}

void ApplyGrpChanges(Widget dialog, struct filedata * fdp)
{
	struct group * grp;
	char * current_group_name;
	Widget list = NULL, cbox = NULL;
	struct fileinfo * info;
	char str_buf[1024];
	XmString str;
	int * positions, pos_count = 0;
	Boolean ok;

	info = fdp->info;
	
	if (!info)
		return ;

	grp = getgrgid(info->f_owngrp);
	if (grp != NULL)
		current_group_name = strdup(grp->gr_name);
		
	if (!current_group_name)
		return ;

	str = XmStringCreateLocalized(current_group_name);
	
	free(current_group_name);
		
	if (!str)
		return ;

	cbox = find_child(dialog, path_to_group);

	if (!cbox)
		return ;

	XtVaGetValues(cbox, XmNlist, &list, NULL);
	
	if (!list)
	{
		XmStringFree(str);
		return ;
	}

	ok = XmListGetMatchPos(list, str, &positions, &pos_count);
	
	if (ok)
	{
		if (pos_count == 1)
		{
			XtVaSetValues(cbox, XmNselectedPosition, positions[0], NULL);
		}
	}
	XmStringFree(str);
}

Widget FindActiveInfoDialog(IfaceBranche * IbPtr, struct filedata * fileref)
{
	Widget dialog;
	struct filedata * fileptr;
	struct InfoDialogProp * InfDlgPrp;
	
	if (IbPtr->info_dialog)
	{
#ifdef DEBUG
		printf("FindActiveInfoDialog: dialog found\n");
#endif
		dialog = IbPtr->info_dialog;
		
//		XtVaGetValues(dialog, XmNuserData, &fileptr, NULL);
		XtVaGetValues(dialog, XmNuserData, &InfDlgPrp, NULL);

		if (!InfDlgPrp)
			return NULL;

		fileptr = InfDlgPrp->fptr;

		if (fileptr && fileptr->name)
		{
			if ((strcmp(fileptr->name, fileref->name)) == 0)
			{
				return dialog;
			}
			return NULL;
		}
		else
			return NULL;
	}
	else
		return NULL;
}


int get_attr(char * name, struct filedata * fileptr)
{
	int linkadjust = 0, x;
	struct stat buf, buf2;
	mode_t mode_info;
	char bumbuf[1024];
	char * tmp_str;
	char symlink_path[4096];
	ssize_t zt;
	int stat_res;


	lstat(name, &buf);
		
	mode_info = buf.st_mode;
		
	if (S_ISLNK(mode_info))
	{
		memset(symlink_path, 0, 4096);
		zt = readlink(name, symlink_path, 4096);
		if ((stat_res = stat(name, &buf2)) == 0)
		{
			if (S_ISDIR(buf2.st_mode))
			{
				mode_info = mode_info | (buf2.st_mode & S_IFMT);
			}
		}
	}
		

	fileptr->name = malloc(sizeof(char) * (strlen(name) + 1));
	strcpy(fileptr->name, name);
	fileptr->magic = NULL;

	fileptr->info = malloc(sizeof(struct fileinfo));
	if (fileptr->info)
	{
		fileptr->info->f_size = buf.st_size;
		fileptr->info->f_atime = buf.st_atime;
		fileptr->info->f_mtime = buf.st_mtime;
		fileptr->info->f_ctime = buf.st_ctime;
		fileptr->info->f_perm = buf.st_mode;
		fileptr->info->f_owner = buf.st_uid;
		fileptr->info->f_owngrp = buf.st_gid;
	}

	fileptr->filetype = mode_info;
	if (((fileptr->filetype & S_IFMT) == S_IFLNK) && !stat_res && zt > 0)
	{
		fileptr->linkto = calloc(zt + 1, sizeof(char));
		if (fileptr->linkto)
			strncpy(fileptr->linkto, symlink_path, zt);
	}
	
	return 1;
}


/* Create popup dialog to describe file.  Don't forget to read file info */
void display_info(struct filedata * fdp, IfaceBranche * IbPtr, char * full_name)
{
	Widget dialog;

	Widget folder, showInfo, showPerm, showAssoc;
	Widget frame1, frame2, frame3, form, text;
	Widget pathRC, pathLabel, pathInfo;
	Widget sizeRC, typeRC, time1RC, time2RC, time3RC;
	Widget sizeName, sizeInfo, typeName, typeInfo;
	Widget linkRC, linkLabel, linkInfo;
	Widget time1Name, time1Info, time2Name, time2Info, time3Name, time3Info;
	Widget ownerRC, ownerLabel, ownerList, ownTg, labelTry, ownerFR;
	Widget groupRC, groupLabel, groupList, grpTg;
	Widget permCtlForm, label ;
	Widget typeLabel, typeLabelInfo;
	Widget assocLabel, assocList, icons, labelIconB, labelIconS;

	Widget uperms;
	Widget gperms;
	Widget aperms;
	Widget sperms;

	XmStringTable str_list;
	
	Boolean editable;

	XmString str;
	
	char * file_location;
	char * current_owner_name;
	void * user_data;
	char * char_str;
	
	char ** user_names, ** group_names;
	int users_num, ngrps, nact;
	int current_owner;
	int current_group;
	int current_act;
	
	char * thisitem;
	char * short_name;
	struct passwd *pass;
	Arg args[20];
	uid_t my_uid;
	gid_t my_gid;
	long x;
	int n, m = 0;
	mode_t src_mode, mask_mode;

	struct filedata *fileptr;
	struct InfoDialogProp * InfDlgPrp;

	my_uid = getuid();
	my_gid = getgid();

	if (full_name)
		file_location = get_path_from_full_name(full_name);
	else
	{
		if (fdp)
			file_location = strdup(IbPtr->current_wd);
		else
			file_location = getparent(IbPtr);
	}

	if (!file_location)
		return ;

	if (full_name)
		thisitem = (char *) calloc(strlen(full_name) + 1, sizeof(char));
	else
	{
		if (fdp)
			thisitem = (char *) calloc(strlen(IbPtr->current_wd) + 3 + strlen(fdp->name), sizeof(char));
		else
			thisitem = (char *) calloc(strlen(IbPtr->current_wd) + 3, sizeof(char));
	}
	
	if (!thisitem)
	{
		if (file_location)
			free(file_location);
			
		return ;
	}
	
	InfDlgPrp = calloc(1, sizeof(struct InfoDialogProp));
	InfDlgPrp->IbPtr = IbPtr;
	InfDlgPrp->iconList = NULL;
	InfDlgPrp->iconDialog = NULL;
	InfDlgPrp->path = strdup(file_location);
	InfDlgPrp->popupOn = 0;
	InfDlgPrp->waitCursor = 0;
	InfDlgPrp->addIconWorkProcId = 0;
	InfDlgPrp->selectedLargeIconNode = NULL;
	InfDlgPrp->selectedSmallIconNode = NULL;
	InfDlgPrp->comboAction = NULL;

	if (full_name)
	{
		short_name = get_last_name_from_path(full_name);
		strcpy(thisitem, full_name);
		editable = True;
		fileptr = calloc(1, sizeof(struct filedata));
		InfDlgPrp->full_name = strdup(full_name);
		InfDlgPrp->need_free = 1;
	}
	else
	{
		if (fdp)
		{
			short_name = strdup(fdp->name);
			sprintf(thisitem, "%s/%s", IbPtr->current_wd, fdp->name);
			editable = True;
			if ((0 == strcmp(".", fdp->name)) || (0 == strcmp("..", fdp->name)))
				editable = False;
			InfDlgPrp->need_free = 0;
			InfDlgPrp->full_name = strdup(thisitem);
		}
		else
		{
			sprintf(thisitem, "%s", IbPtr->current_wd);
			short_name = get_last_name_from_path(IbPtr->current_wd);
			editable = False;
			fileptr = calloc(1, sizeof(struct filedata));
			InfDlgPrp->need_free = 1;
			InfDlgPrp->full_name = strdup(thisitem);
		}
	}

/*!!!!!!!!!!!!!!!!!!!!!!!!!*/	


	if (full_name)
	{
		copy_filedata(fileptr, fdp);
	}
	else
	{
		if (!fdp || !fdp->info)
		{
			get_attr(thisitem, fileptr);
		}
		else
			fileptr = fdp;
	}

	InfDlgPrp->fptr = fileptr;

	pass = getpwuid(fileptr->info->f_owner);
	if (pass != NULL)
		current_owner_name = strdup(pass->pw_name);


	m = S_ISDIR(fileptr->info->f_perm);
	src_mode = fileptr->info->f_perm;
	mask_mode = 0;
  
	mask_mode = src_mode & (S_ISUID | S_ISGID | S_ISVTX);

	char_str = calloc(strlen(resdata.DialInfoMessageString) + strlen(short_name) + 5, sizeof(char));

	if (char_str)
	{
		sprintf(char_str, "%s: %s", resdata.DialInfoMessageString, short_name);
		str = XmStringCreateLocalized(char_str);
	}
	
	n = 0;
	
	if (str)
	{
		XtSetArg(args[n], XmNmessageString, str);
		n++;
	}
	
	XtSetArg(args[n], XmNtitle, resdata.DialInfoTitleString);
	n++;
	XtSetArg(args[n], XmNautoUnmanage, True); 
	n++;
	XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); 
	n++;
	XtSetArg(args[n], XmNuserData, InfDlgPrp);
	n++;
	XtSetArg(args[n], XmNdeleteResponse, XmDESTROY);
	n++;


	dialog = XmCreateInformationDialog(IbPtr->top_level, "Properties", args, n);

	XtAddCallback(dialog, XmNdestroyCallback, DestroyDialogCB, (XtPointer) IbPtr);

	IbPtr->info_dialog = dialog;

	if (str)
		XmStringFree(str);

	if (char_str)
		free(char_str);

	folder = XtVaCreateManagedWidget("folder",
			xmlFolderWidgetClass, dialog,
			XmNtabsPerRow, 3,
			NULL);

	str = XmStringCreateLocalized(resdata.DialInfoFolderInfoString);
	showInfo = XmLFolderAddTabForm(folder, str);
	XmStringFree(str);

	str = XmStringCreateLocalized(resdata.DialInfoFolderPermString);
	showPerm = XmLFolderAddTabForm(folder, str);
	XmStringFree(str);

	str = XmStringCreateLocalized(resdata.DialInfoFolderAssociationString);
	showAssoc = XmLFolderAddTabForm(folder, str);
	XmStringFree(str);

	str = NULL;


	if (m || S_ISCHR(fileptr->info->f_perm) || S_ISBLK(fileptr->info->f_perm) || 
		S_ISFIFO(fileptr->info->f_perm) || S_ISLNK(fileptr->info->f_perm) || S_ISSOCK(fileptr->info->f_perm))
	{
		Widget tab = XtNameToWidget(folder, "tab2");
		printf("--------\n");
		if (tab)
			XtVaSetValues(tab, XmNsensitive, False, NULL);
	}


	XtVaSetValues(showInfo, XmNverticalSpacing, 10, NULL);


/* Display the name of the file, tell size or if it is a directory */

	frame1 = XtVaCreateManagedWidget("frame_name",
									xmFrameWidgetClass, showInfo,
									XmNtopAttachment, XmATTACH_FORM,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									NULL);

	frame3 = XtVaCreateManagedWidget("frame_time",
									xmFrameWidgetClass, showInfo,
									XmNbottomAttachment, XmATTACH_FORM,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									NULL);


	frame2 = XtVaCreateManagedWidget("frame_type",
									xmFrameWidgetClass, showInfo,
									XmNtopAttachment, XmATTACH_WIDGET,
									XmNtopWidget, frame1,
									XmNbottomAttachment, XmATTACH_WIDGET,
									XmNbottomWidget, frame3,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									NULL);


	form = XtVaCreateManagedWidget("name",
									xmFormWidgetClass, frame1,
									NULL);


	text = XtVaCreateManagedWidget("filename",
									xmTextFieldWidgetClass, form,
									XmNvalue, short_name,
									XmNeditable, editable,
									XmNtopAttachment, XmATTACH_FORM,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									XmNbottomOffset, 10,
									XmNtopOffset, 10,
									XmNleftOffset, 10,
									XmNrightOffset, 10,
									NULL);



/** Path field **/

	pathRC = XtVaCreateManagedWidget("path_row_col",
									xmFormWidgetClass, form,
									XmNorientation, XmHORIZONTAL,
									XmNtopAttachment, XmATTACH_WIDGET,
									XmNtopWidget, text,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									NULL);

	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);
	n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);
	n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);
	n++;

	pathLabel = XmCreateLabel(pathRC, "Location:", args, n);
	str = XmStringCreateLocalized(file_location);
		
	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING);
	n++;
	XtSetArg(args[n], XmNalignment,  XmALIGNMENT_BEGINNING);
	n++;
	XtSetArg(args[n], XmNrecomputeSize, FALSE);
	n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);
	n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);
	n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET);
	n++;
	XtSetArg(args[n], XmNleftWidget, pathLabel);
	n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);
	n++;
	pathInfo = XmCreateLabel(pathRC, "path_info", args, n);


	XtManageChild(pathLabel);
	XtManageChild(pathInfo);

	XtVaSetValues(pathInfo, XmNlabelString, str, NULL);

	if (str)
		XmStringFree(str);

/** Type field **/

	form = XtVaCreateManagedWidget("type",
									xmFormWidgetClass, frame2,
									NULL);

	typeRC = XtVaCreateManagedWidget("type_row_col",
									xmRowColumnWidgetClass, form,
									XmNorientation, XmHORIZONTAL,
									XmNtopAttachment, XmATTACH_WIDGET,
									XmNtopWidget, pathRC,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									NULL);


	str = XmStringCreateLocalized(resdata.DialInfoTypeString);
		
	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING);
	n++;
	XtSetArg(args[n], XmNlabelString, str);
	n++;

	typeName = XmCreateLabel(typeRC, "Type", args, n);

	if (str)
		XmStringFree(str);


	if (!m)
	{
		if (S_ISCHR(fileptr->info->f_perm))
			str = XmStringCreateLocalized(resdata.CharDevNameString);
		else
			if (S_ISBLK(fileptr->info->f_perm))
				str = XmStringCreateLocalized(resdata.BlockDevNameString);
			else
				if (S_ISFIFO(fileptr->info->f_perm))
					str = XmStringCreateLocalized(resdata.FifoNameString);
				else
					if (S_ISLNK(fileptr->info->f_perm))
						str = XmStringCreateLocalized(resdata.SymLinkNameString);
					else
						if (S_ISSOCK(fileptr->info->f_perm))
							str = XmStringCreateLocalized(resdata.SocketNameString);
						else
							if (fileptr && fileptr->magic)
							{
								if (fileptr->magic->magic)
									str = XmStringCreateLocalized(fileptr->magic->magic);
								else
									str = XmStringCreateLocalized("Unknown type");
							}
							else
								str = XmStringCreateLocalized("Unknown type");

	}
	else
		str = XmStringCreateLocalized(resdata.DirectoryNameString);
	
	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING);
	n++;
	XtSetArg(args[n], XmNlabelString, str);
	n++;
		
	typeInfo = XmCreateLabel(typeRC, "file_type_info", args, n);


	if (str)
		XmStringFree(str);

	XtManageChild(typeName);
	XtManageChild(typeInfo);
	
/** Link field **/

	if (S_ISLNK(fileptr->info->f_perm))
	{
		linkRC = XtVaCreateManagedWidget("link_row_col",
									xmRowColumnWidgetClass, form,
									XmNorientation, XmHORIZONTAL,
									XmNtopAttachment, XmATTACH_WIDGET,
									XmNtopWidget, typeRC,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									NULL);

		linkLabel = XmCreateLabel(linkRC, "LinkTo:", NULL, 0);
		if (fileptr && fileptr->linkto)
			str = XmStringCreateLocalized(fileptr->linkto);
		else
			str = XmStringCreateLocalized("-");
		
		n = 0;
		XtSetArg(args[n], XmNlabelType, XmSTRING);
		n++;
		XtSetArg(args[n], XmNlabelString, str);
		n++;
			
		linkInfo = XmCreateLabel(linkRC, "symlink_info", args, n);

		if (str)
			XmStringFree(str);

		XtManageChild(linkLabel);
		XtManageChild(linkInfo);
	}

/** Size field **/

	if (S_ISLNK(fileptr->info->f_perm))
		sizeRC = XtVaCreateManagedWidget("size_row_col",
										xmRowColumnWidgetClass, form,
										XmNorientation, XmHORIZONTAL,
										XmNtopAttachment, XmATTACH_WIDGET,
										XmNtopWidget, linkRC,
										XmNleftAttachment, XmATTACH_FORM,
										XmNrightAttachment, XmATTACH_FORM,
										NULL);
	else
		sizeRC = XtVaCreateManagedWidget("size_row_col",
										xmRowColumnWidgetClass, form,
										XmNorientation, XmHORIZONTAL,
										XmNtopAttachment, XmATTACH_WIDGET,
										XmNtopWidget, typeRC,
										XmNleftAttachment, XmATTACH_FORM,
										XmNrightAttachment, XmATTACH_FORM,
										NULL);


	sizeName = XmCreateLabel(sizeRC, "Size:", NULL, 0);

	if (!m)
	{
		char_str = get_human_readable_size(fileptr->info->f_size, NULL, 1);
		if (char_str)
		{
			str = XmStringCreateLocalized(char_str);
			free(char_str);
			char_str = NULL;
		}
	}
	else
		str = XmStringCreateLocalized(resdata.DirectoryNameString);

	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING);
	n++;
	XtSetArg(args[n], XmNlabelString, str);
	n++;
	sizeInfo = XmCreateLabel(sizeRC, "file_size_info", args, n);

	if (str)
		XmStringFree(str);

	XtManageChild(sizeName);
	XtManageChild(sizeInfo);

/** Time 1 field **/

	form = XtVaCreateManagedWidget("time",
									xmFormWidgetClass, frame3,
									NULL);

	time1RC = XtVaCreateManagedWidget("time1_row_col",
									xmRowColumnWidgetClass, form,
									XmNorientation, XmHORIZONTAL,
									XmNtopAttachment, XmATTACH_WIDGET,
									XmNtopWidget, sizeRC,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									NULL);

	str = XmStringCreateLocalized(resdata.TimeAccessNameString);

	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING);
	n++;
	XtSetArg(args[n], XmNlabelString, str);
	n++;
	
	time1Name = XmCreateLabel(time1RC, "Time1", args, n);

	if (str)
		XmStringFree(str);

	char_str = get_human_readable_time(&(fileptr->info->f_atime), NULL);
	str = XmStringCreateLocalized(char_str);

	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING);
	n++;
	XtSetArg(args[n], XmNlabelString, str);
	n++;

	time1Info = XmCreateLabel(time1RC, "time1_info", args, n);

	if (char_str)
		free(char_str);
	if (str)
		XmStringFree(str);

	XtManageChild(time1Name);
	XtManageChild(time1Info);

/** Time 2 field **/

	time2RC = XtVaCreateManagedWidget("time2_row_col",
									xmRowColumnWidgetClass, form,
									XmNorientation, XmHORIZONTAL,
									XmNtopAttachment, XmATTACH_WIDGET,
									XmNtopWidget, time1RC,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									NULL);

	str = XmStringCreateLocalized(resdata.TimeModifyNameString);

	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING);
	n++;
	XtSetArg(args[n], XmNlabelString, str);
	n++;
	
	time2Name = XmCreateLabel(time2RC, "Time2", args, n);

	if (str)
		XmStringFree(str);

	char_str = get_human_readable_time(&(fileptr->info->f_mtime), NULL);
	str = XmStringCreateLocalized(char_str);

	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING);
	n++;
	XtSetArg(args[n], XmNlabelString, str);
	n++;

	time2Info = XmCreateLabel(time2RC, "time2_info", args, n);

	if (char_str)
		free(char_str);
	if (str)
		XmStringFree(str);

	XtManageChild(time2Name);
	XtManageChild(time2Info);


/** Time 3 field **/

	time3RC = XtVaCreateManagedWidget("time3_row_col",
									xmRowColumnWidgetClass, form,
									XmNorientation, XmHORIZONTAL,
									XmNtopAttachment, XmATTACH_WIDGET,
									XmNtopWidget, time2RC,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									NULL);

	str = XmStringCreateLocalized(resdata.TimeChangeNameString);

	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING);
	n++;
	XtSetArg(args[n], XmNlabelString, str);
	n++;
	
	time3Name = XmCreateLabel(time3RC, "Time3", args, n);

	if (str)
		XmStringFree(str);

	char_str = get_human_readable_time(&(fileptr->info->f_ctime), NULL);
	str = XmStringCreateLocalized(char_str);

	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING);
	n++;
	XtSetArg(args[n], XmNlabelString, str);
	n++;

	time3Info = XmCreateLabel(time3RC, "time3_info", args, n);

	if (char_str)
		free(char_str);
	if (str)
		XmStringFree(str);

	XtManageChild(time3Name);
	XtManageChild(time3Info);

/** Owner & others **/

	str_list = NULL;


	ownerFR = XtVaCreateManagedWidget("owner_form",
									xmFormWidgetClass, showPerm,
									XmNtopAttachment, XmATTACH_FORM,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									XmNhorizontalSpacing, 5, 
									NULL);

	str_list = GetOwnerList(current_owner_name, &users_num, &current_owner);
	
	if (current_owner_name)
		free(current_owner_name);

	frame2 = XtVaCreateManagedWidget("frame2",
									xmFrameWidgetClass, ownerFR,
									XmNtopAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									XmNbottomAttachment, XmATTACH_FORM,
									NULL);


	frame1 = XtVaCreateManagedWidget("frame1",
									xmFrameWidgetClass, ownerFR,
									XmNtopAttachment, XmATTACH_FORM,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_WIDGET,
									XmNrightWidget, frame2,
									XmNbottomAttachment, XmATTACH_FORM,
									NULL);

	groupRC = XtVaCreateManagedWidget("owner_opt_row_col",
									xmRowColumnWidgetClass, frame2,
									XmNorientation, XmVERTICAL,
									NULL);


	ownerRC = XtVaCreateManagedWidget("owner_row_col",
									xmRowColumnWidgetClass, frame1,
									XmNorientation, XmVERTICAL,
									NULL);

	ownerLabel = XmCreateLabel(ownerRC, "Owner", NULL, 0);


	n = 0;
	XtSetArg(args[n], XmNitems, str_list); 
	n++;
	XtSetArg(args[n], XmNitemCount, users_num); 
	n++;
	XtSetArg(args[n], XmNpositionMode, XmONE_BASED); 
	n++;

	if (current_owner)
	{
		XtSetArg(args[n], XmNselectedPosition, current_owner);
		n++;
	}

	ownerList = XmCreateDropDownList(ownerRC, "owner_combo", args, n);
	

	if (my_uid != 0 || !fdp)
	{
		n = 0;
		XtSetArg(args[n], XmNsensitive, FALSE);
		n++;
		XtSetValues(ownerList, args, n);
	}


	str = XmStringCreateLocalized(resdata.DialInfoTryChownString);

	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING); 
	n++;
	XtSetArg(args[n], XmNlabelString, str); 
	n++;
	XtSetArg(args[n], XmNset, XmUNSET); 
	n++;
	XtSetArg(args[n], XmNsensitive, editable);
	n++;
	XtSetArg(args[n], XmNuserData, (XtPointer) IbPtr);
	n++;

	ownTg = XmCreateToggleButton(groupRC, "try_chown", args, n);

	XtAddCallback(ownTg, XmNvalueChangedCallback, ChangeOwnToggle,
			(XtPointer) dialog);

	if (str)
		XmStringFree(str);


	XtManageChild(ownerLabel);
	XtManageChild(ownerList);
	XtManageChild(ownTg);

	free_string_table(str_list, users_num);

	str_list = GetGroupListUser(thisitem, &ngrps, &current_group);



	groupLabel = XmCreateLabel(ownerRC, "Group", NULL, 0);

	n = 0;
	XtSetArg(args[n], XmNitems, str_list); 
	n++;
	XtSetArg(args[n], XmNitemCount, ngrps); 
	n++;
	XtSetArg(args[n], XmNpositionMode, XmONE_BASED); 
	n++;

	if (current_group)
	{
		XtSetArg(args[n], XmNselectedPosition, current_group);
		n++;
	}

	groupList = XmCreateDropDownList(ownerRC, "group_combo", args, n);

	if ((my_uid != 0 && fileptr->info->f_owner != my_uid) || !fdp)
	{
		XtSetArg(args[n], XmNsensitive, FALSE);
		n++;
		XtSetValues(groupList, args, n);
	}
	

	str = XmStringCreateLocalized(resdata.DialInfoTryChgrString);

	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING); 
	n++;
	XtSetArg(args[n], XmNlabelString, str); 
	n++;
	XtSetArg(args[n], XmNset, XmUNSET); 
	n++;
	XtSetArg(args[n], XmNsensitive, editable);
	n++;
	XtSetArg(args[n], XmNuserData, (XtPointer) IbPtr);
	n++;
	

	grpTg = XmCreateToggleButton(groupRC, "try_grpch", args, n);

	XtAddCallback(grpTg, XmNvalueChangedCallback, ChangeGrpToggle,
			(XtPointer) dialog);

	if (str)
		XmStringFree(str);

	XtManageChild(groupLabel);
	XtManageChild(groupList);
	XtManageChild(grpTg);

	if (str_list)
		free_string_table(str_list, ngrps);


/*	XtVaSetValues(showPerm, XmNmarginWidth, 10,	XmNmarginHeight, 10, NULL);*/


	frame1 = XtVaCreateManagedWidget("frame3", xmFrameWidgetClass, showPerm,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									XmNbottomAttachment, XmATTACH_FORM,
									XmNfractionBase, 4,
									NULL);



	permCtlForm = XtVaCreateManagedWidget("perm_ctl_form", xmFormWidgetClass, frame1,
									XmNfractionBase, 4,
									NULL);


/* Describe the permissions on the file/directory */

	char_str = calloc(strlen(resdata.PermTitleString) + 30, sizeof(char));
	
	if (char_str)
	{
		sprintf(char_str, "%s: %o", resdata.PermTitleString, fileptr->info->f_perm);
		str = XmStringCreateLocalized(char_str);
		free(char_str);
	}

	label = XtVaCreateManagedWidget("flags_w", xmLabelWidgetClass, showPerm,
									XmNlabelString, str,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									XmNtopAttachment, XmATTACH_WIDGET,
									XmNtopWidget, ownerFR,
									XmNbottomAttachment, XmATTACH_WIDGET,
									XmNbottomWidget, frame1,
									NULL);

	if (str)
		XmStringFree(str);

/* Display checkboxes to allow changing permissions. */

	XtAddCallback(permCtlForm, XmNdestroyCallback, CleanWidgetUserDataCB, NULL);


	n = 0;
	XtSetArg(args[n], XmNorientation, XmVERTICAL);
	n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNtopPosition, 0);
	n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNleftPosition, 0);
	n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNrightPosition, 1);
	n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNbottomPosition, 4);
	n++;


	uperms = XmCreateRowColumn(permCtlForm, "info_rc1", args, n);
	
	label = XmCreateLabel(uperms, "User", NULL, 0);


	CreatePermToggle(uperms, "read", NULL, resdata.DialInfoReadString, (fileptr->info->f_perm & 256) ? XmSET : XmUNSET, editable);


	CreatePermToggle(uperms, "write", NULL, resdata.DialInfoWriteString, (fileptr->info->f_perm & 128) ? XmSET : XmUNSET, editable);


	CreatePermToggle(uperms, "execute", NULL, resdata.DialInfoExecuteString, (fileptr->info->f_perm & 64) ? XmSET : XmUNSET, editable);

	XtManageChild(uperms);
	XtManageChild(label);


	n = 0;
	XtSetArg(args[n], XmNorientation, XmVERTICAL);
	n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNtopPosition, 0);
	n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNleftPosition, 1);
	n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNrightPosition, 2);
	n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNbottomPosition, 4);
	n++;

	gperms = XmCreateRowColumn(permCtlForm, "info_rc2", args, n);

	label = XmCreateLabel(gperms, "Group", NULL, 0);


	CreatePermToggle(gperms, "read", NULL, resdata.DialInfoReadString, (fileptr->info->f_perm & 32) ? XmSET : XmUNSET, editable);


	CreatePermToggle(gperms, "write", NULL, resdata.DialInfoWriteString, (fileptr->info->f_perm & 16) ? XmSET : XmUNSET, editable);


	CreatePermToggle(gperms, "execute", NULL, resdata.DialInfoExecuteString, (fileptr->info->f_perm & 8) ? XmSET : XmUNSET, editable);


	XtManageChild(gperms);
	XtManageChild(label);

	n = 0;
	XtSetArg(args[n], XmNorientation, XmVERTICAL);
	n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNtopPosition, 0);
	n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNleftPosition, 2);
	n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNrightPosition, 3);
	n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNbottomPosition, 4);
	n++;


	aperms = XmCreateRowColumn(permCtlForm, "info_rc3", args, n);

	label = XmCreateLabel(aperms, "Others", NULL, 0);

	CreatePermToggle(aperms, "read", NULL, resdata.DialInfoReadString, (fileptr->info->f_perm & 4) ? XmSET : XmUNSET, editable);


	CreatePermToggle(aperms, "write", NULL, resdata.DialInfoWriteString, (fileptr->info->f_perm & 2) ? XmSET : XmUNSET, editable);


	CreatePermToggle(aperms, "execute", NULL, resdata.DialInfoExecuteString, (fileptr->info->f_perm & 1) ? XmSET : XmUNSET, editable);

	XtManageChild(aperms);
	XtManageChild(label);

	n = 0;
	XtSetArg(args[n], XmNorientation, XmVERTICAL);
	n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNtopPosition, 0);
	n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNleftPosition, 3);
	n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNrightPosition, 4);
	n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNbottomPosition, 4);
	n++;

	sperms = XmCreateRowColumn(permCtlForm, "info_rc4", args, n);

	label = XmCreateLabel(sperms, "Specials", NULL, 0);


	CreatePermToggle(sperms, "suid", NULL, resdata.DialInfoSetuidString, (fileptr->info->f_perm & S_ISUID) ? XmSET : XmUNSET, editable);


	CreatePermToggle(sperms, "sgid", NULL, resdata.DialInfoSetgidString, (fileptr->info->f_perm & S_ISGID) ? XmSET : XmUNSET, editable);


	CreatePermToggle(sperms, "sticky", NULL, resdata.DialInfoStickyString, (fileptr->info->f_perm & S_ISVTX) ? XmSET : XmUNSET, editable);

	XtManageChild(sperms);
	XtManageChild(label);

	x = 0;
	if (my_uid != 0) 
	{
		if (fileptr->info->f_owner != my_uid) 
		{
		XtSetSensitive(uperms, False);
		XtSetSensitive(gperms, False);
		XtSetSensitive(sperms, False);
		}
		else
			x++;
		if (x == 0)
		XtSetSensitive(aperms, False);
	}

	if (!fdp) 
	{
		XtSetSensitive(uperms, False);
		XtSetSensitive(gperms, False);
		XtSetSensitive(sperms, False);
		XtSetSensitive(aperms, False);
	}



/* Association */


	frame3 = XtVaCreateManagedWidget("frame_icon",
									xmFrameWidgetClass, showAssoc,
									XmNbottomAttachment, XmATTACH_FORM,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									NULL);


	frame2 = XtVaCreateManagedWidget("frame_action",
									xmFrameWidgetClass, showAssoc,
//									XmNtopAttachment, XmATTACH_WIDGET,
//									XmNtopWidget, frame1,
									XmNbottomAttachment, XmATTACH_WIDGET,
									XmNbottomWidget, frame3,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									NULL);

	frame1 = XtVaCreateManagedWidget("frame_type",
									xmFrameWidgetClass, showAssoc,
									XmNtopAttachment, XmATTACH_FORM,
									XmNleftAttachment, XmATTACH_FORM,
									XmNrightAttachment, XmATTACH_FORM,
									XmNbottomAttachment, XmATTACH_WIDGET,
									XmNbottomWidget, frame2,
									NULL);

	form = XtVaCreateManagedWidget("type",
									xmFormWidgetClass, frame1,
									NULL);


	str = XmStringCreateLocalized(resdata.DialInfoTypeString);

	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING);
	n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);
	n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);
	n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);
	n++;
	XtSetArg(args[n], XmNlabelString, str);
	n++;

	typeLabel = XmCreateLabel(form, "Type2", args, n);

	if (str)
		XmStringFree(str);


	if (!m)
	{
		if (S_ISCHR(fileptr->info->f_perm))
			str = XmStringCreateLocalized(resdata.CharDevNameString);
		else
			if (S_ISBLK(fileptr->info->f_perm))
				str = XmStringCreateLocalized(resdata.BlockDevNameString);
			else
				if (S_ISFIFO(fileptr->info->f_perm))
					str = XmStringCreateLocalized(resdata.FifoNameString);
				else
					if (S_ISLNK(fileptr->info->f_perm))
						str = XmStringCreateLocalized(resdata.SymLinkNameString);
					else
						if (S_ISSOCK(fileptr->info->f_perm))
							str = XmStringCreateLocalized(resdata.SocketNameString);
						else
							if (fileptr && fileptr->magic)
							{
								if (fileptr->magic->magic)
								{
#ifdef DEBUG
									printf("%s\n", fileptr->magic->magic);
#endif
									str = XmStringCreateLocalized(fileptr->magic->magic);
								}
								else
								{
#ifdef DEBUG
									printf("Unknown type\n");
#endif
									str = XmStringCreateLocalized("Unknown type");
								}
							}
							else
								str = XmStringCreateLocalized("Unknown type");

	}
	else
		str = XmStringCreateLocalized(resdata.DirectoryNameString);


		
	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING);
	n++;
	XtSetArg(args[n], XmNalignment,  XmALIGNMENT_BEGINNING);
	n++;
	XtSetArg(args[n], XmNrecomputeSize, FALSE);
	n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);
	n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);
	n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET);
	n++;
	XtSetArg(args[n], XmNleftWidget, typeLabel);
	n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);
	n++;
	XtSetArg(args[n], XmNlabelString, str);
	n++;

	typeLabelInfo = XmCreateLabel(form, "type_info", args, n);


	XtManageChild(typeLabel);
	XtManageChild(typeLabelInfo);

	if (str)
		XmStringFree(str);


	form = XtVaCreateManagedWidget("association",
									xmFormWidgetClass, frame2,
									NULL);

	str = XmStringCreateLocalized(resdata.DialInfoOpenWithString);

	n = 0;
	XtSetArg(args[n], XmNlabelType, XmSTRING);
	n++;
	XtSetArg(args[n], XmNalignment,  XmALIGNMENT_BEGINNING);
	n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);
	n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);
	n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);
	n++;
//	XtSetArg(args[n], XmNleftWidget, typeLabel);
//	n++;
//	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);
//	n++;
	XtSetArg(args[n], XmNlabelString, str);
	n++;

	assocLabel = XmCreateLabel(form, "OpenWith", args, n);
	
	if (str)
		XmStringFree(str);

	current_act = 1;
	if (fileptr->magic)
		str_list = GetActionList(fileptr->magic->action, &nact, &current_act);
	else
		str_list = GetActionList(NULL, &nact, &current_act);
	
	n = 0;
	XtSetArg(args[n], XmNitems, str_list); 
	n++;
	XtSetArg(args[n], XmNitemCount, nact); 
	n++;
	XtSetArg(args[n], XmNvisibleItemCount, nact); 
	n++;
	XtSetArg(args[n], XmNpositionMode, XmONE_BASED); 
	n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);
	n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);
	n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET);
	n++;
	XtSetArg(args[n], XmNleftWidget, assocLabel);
	n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);
	n++;

	XtSetArg(args[n], XmNselectedPosition, current_act);
	n++;
	XtSetArg(args[n], XmNcomboBoxType, XmDROP_DOWN_COMBO_BOX);
	n++;
	
	assocList = XmCreateComboBox(form, "assoc_combo", args, n);
//	assocList = XmCreateDropDownList(form, "assoc_combo", args, n);
	
/*
	if (my_uid != 0 || !fdp)
	{
		n = 0;
		XtSetArg(args[n], XmNsensitive, FALSE);
		n++;
		XtSetValues(assocList, args, n);
	}
*/

	InfDlgPrp->comboAction = assocList;

	free_string_table(str_list, nact);


	XtManageChild(assocLabel);

	XtManageChild(assocList);


/*
	n = 0;
	XtSetArg(args[n], XmNpacking, XmPACK_COLUMN);
	n++;
	XtSetArg(args[n], XmNorientation, XmVERTICAL);
	n++;
	XtSetArg(args[n], XmNnumColumns, 3);
	n++;*/
//	XtSetArg(args[n], XmNorientation, XmHORIZONTAL);
//	n++;
//	XtSetArg(args[n], XmNisAligned, True);
//	n++;
//	XtSetArg(args[n], XmNentryAlignment, XmALIGNMENT_CENTER);
//	n++;
/*	XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNtopPosition, 0);
	n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNleftPosition, 0);
	n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNrightPosition, 1);
	n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNbottomPosition, 4);
	n++;*/

	n = 0;
	XtSetArg (args[n], XmNfractionBase, 7); n++;
	icons = XmCreateForm (frame3, "icons", args, n);
//	icons = XmCreateRowColumn(frame3, "icons", args, n);

	str = XmStringCreateLocalized(resdata.DialInfoLargeIconString);
	
	n = 0;
	XtSetArg(args[n], XmNlabelString, str);
	n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNtopPosition, 1); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNleftPosition, 1); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNrightPosition, 2); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNbottomPosition, 3); n++;	

	label = XmCreateLabel(icons, "BigIcon", args, n);

	if (str)
		XmStringFree(str);

	XtManageChild(label);

	str = XmStringCreateLocalized(resdata.DialInfoSmallIconString);

	n = 0;
	XtSetArg(args[n], XmNlabelString, str);
	n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNtopPosition, 4); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNleftPosition, 1); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNrightPosition, 2); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNbottomPosition, 6); n++;	

	label = XmCreateLabel(icons, "SmallIcon", args, n);

	if (str)
		XmStringFree(str);

	XtManageChild(label);

	n = 0;
	XtSetArg(args[n], XmNlabelType, XmPIXMAP);
	n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNtopPosition, 1); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNleftPosition, 3); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNrightPosition, 4); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNbottomPosition, 3); n++;	

	labelIconB = XmCreateLabel(icons, "IconB", args, n);
	if (fileptr && fileptr->magic)
	{
		GetDialPix(IbPtr, ICON_BIG_TYPE, labelIconB, fileptr->magic->big_pixmap, fileptr->magic->big_mask);
	}
	else
	{
		GetDialPix(IbPtr, ICON_BIG_TYPE, labelIconB, XmUNSPECIFIED_PIXMAP, XmUNSPECIFIED_PIXMAP);
	}
	XtVaSetValues(labelIconB, XmNlabelPixmap, IbPtr->DialPixLarge, NULL);
	XtManageChild(labelIconB);


	n = 0;
	XtSetArg(args[n], XmNlabelType, XmPIXMAP);
	n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNtopPosition, 4); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNleftPosition, 3); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNrightPosition, 4); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNbottomPosition, 6); n++;	


	labelIconS = XmCreateLabel(icons, "IconS", args, n);
	if (fileptr && fileptr->magic)
	{
		GetDialPix(IbPtr, ICON_SMALL_TYPE, labelIconS, fileptr->magic->small_pixmap, fileptr->magic->small_mask);
	}
	else
	{
		GetDialPix(IbPtr, ICON_SMALL_TYPE, labelIconS, XmUNSPECIFIED_PIXMAP, XmUNSPECIFIED_PIXMAP);
	}
	XtVaSetValues(labelIconS, XmNlabelPixmap, IbPtr->DialPixSmall, NULL);
	XtManageChild(labelIconS);

	str = XmStringCreateLocalized(resdata.DialInfoIconEditString);

	n = 0;
	XtSetArg(args[n], XmNlabelString, str);
	n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNtopPosition, 1); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNleftPosition, 5); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNrightPosition, 6); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNbottomPosition, 3); n++;	
	XtSetArg (args[n], XmNuserData, labelIconB); n++;	

	label = XmCreatePushButton(icons, ButtonBigIconName, args, n);

	XtAddCallback(label, XmNactivateCallback, (XtCallbackProc) button_icon_edit_cb,
				(XtPointer) InfDlgPrp);

	XtManageChild(label);

//	label = XmCreateLabel(icons, "SmallIcon", NULL, 0);

//	XtManageChild(label);
	
	
/*	n = 0;
	XtSetArg(args[n], XmNlabelType, XmPIXMAP);
	n++;
	label = XmCreateLabel(icons, "IconS", args, n);

	if (fileptr && fileptr->magic)
	{
		GetDialPix(IbPtr, ICON_SMALL_TYPE, label, fileptr->magic->small_pixmap, fileptr->magic->small_mask);
	}
	else
	{
		GetDialPix(IbPtr, ICON_SMALL_TYPE, label, 0, 0);
	}
	
	XtVaSetValues(label, XmNlabelPixmap, IbPtr->DialPixSmall, NULL);
	

	XtManageChild(label);
*/

	n = 0;
	XtSetArg(args[n], XmNlabelString, str);
	n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNtopPosition, 4); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNleftPosition, 5); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNrightPosition, 6); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNbottomPosition, 6); n++;	
	XtSetArg (args[n], XmNuserData, labelIconS); n++;	

	label = XmCreatePushButton(icons, ButtonSmallIconName, args, n);

	if (str)
		XmStringFree(str);

	XtAddCallback(label, XmNactivateCallback, (XtCallbackProc) button_icon_edit_cb,
				(XtPointer) InfDlgPrp);

	XtManageChild(label);


	XtManageChild(icons);


/*

	typeLabelInfo = XmCreateLabel(frame3, "type_3", NULL, 0);

	XtManageChild(typeLabelInfo);

*/



	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc) button_ok_cb,
				(XtPointer) IbPtr);
	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc) button_cancel_cb,
				(XtPointer) IbPtr);

	XtManageChild(dialog);

			
	if (thisitem)
		free(thisitem);

	if (file_location)
		free(file_location);
	
	return ;
}
