/* findfile.c -- Find and display files.  I cheated -- there is no find code
 * in this program at all.  Instead, I have popen() use the GNU (or POSIX)
 * find to do the dirty work for me.  You /do/ have GNU findutils on your
 * system (and in your PATH), right?  ;)
 * Search for sprintf(shellcmd to find the command line definition. */

#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
#include <Xm/Transfer.h>
#include <Xm/List.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "defines.h"
#include "core.h"
#include "errormsg.h"
#include "filecmd.h"
#include "getdir.h"
#include "getinfo.h"
#include "helpsys.h"
#include "menubars.h"
#include "permission.h"
#include "utils.h"



//#define DEBUG 1


struct optfileinfo {
	off_t f_size;
	time_t f_atime;
	time_t f_mtime;
	time_t f_ctime;
	mode_t f_perm;	
	uid_t f_owner;
	gid_t f_owngrp;
	void * magic;
	char name[4096];
};


struct OptAttrib
{
	Widget list;
	IfaceBranche * IbPtr;
	struct optfileinfo	* optinfo;
	int count;
};

struct FindRec
{
	Widget tf1;
	Widget tf2;
	IfaceBranche * IbPtr;
};

struct FindProc
{
	Widget list;
	IfaceBranche * IbPtr;
	XtInputId id;
	FILE * fp;
	struct OptAttrib * opt;
};


char * CreateList(char * prefix, char * name)
{
	char * str;
	str = calloc(strlen(prefix) + strlen(name) + 5, sizeof(char));
	strcpy(str, prefix);
	strcat(str, name);
	return str;
}

/* Text field for file search pattern. */
Widget find_tf1, find_tf2;

/* Find menu callback.  Special handling for things in Find window. */
void FindMenuCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
	XmStringTable selections;
	char * thisitem;
	int count = 0;
	int *selected;
	struct OptAttrib * optA;
	char thiscmd[4164];
	int ret;
	struct filedata fileDataRec;
	struct fileinfo fileInfoRec;
	int pos;
	
	XtVaGetValues(w, XmNuserData, &optA, NULL);
	if (!optA)
		return ;
	
	if (optA)
		XtVaGetValues(optA->list, XmNselectedPositionCount, &count, XmNselectedPositions, &selected, NULL);
	

	if (0 == count)
		return ;

	memset(thiscmd, 0, 4164);

	pos = *selected - 1;

	switch ((int) client_data)
	{
		case FILE_MENU_RUN:
			if (((optA->optinfo[*selected - 1].f_perm & S_IXUSR) || 
				(optA->optinfo[*selected - 1].f_perm & S_IXGRP) || 
				(optA->optinfo[*selected - 1].f_perm & S_IXOTH)) &&
				S_ISREG(optA->optinfo[*selected - 1].f_perm))
				{
					sprintf(thiscmd, "%s", optA->optinfo[pos].name);
					ret = system(thiscmd);
				}
			break;

		case FILE_MENU_COPY:
			thisitem = CreateList("copy\nfile://", optA->optinfo[pos].name);
			strcat(thisitem, "\n");
			CopyFile(thisitem, optA->IbPtr);
			if (thisitem)
				free(thisitem);
			break;

		case FILE_MENU_MOVE:
			thisitem = CreateList("cut\nfile://", optA->optinfo[pos].name);
			strcat(thisitem, "\n");
			CutFile(thisitem, optA->IbPtr);
			if (thisitem)
				free(thisitem);
			break;

		case FILE_MENU_DELETE:
			DeleteFile(optA->optinfo[pos].name, optA->IbPtr);
			break;

		case FILE_MENU_INFO:
			strcpy(thiscmd, (optA->optinfo + pos)->name);
			thisitem = get_last_name_from_path(thiscmd);

			
			fileDataRec.name = thisitem;
			fileDataRec.linkto = NULL;
			fileDataRec.magic = NULL;
			fileDataRec.filetype = optA->optinfo[pos].f_perm;
			fileDataRec.info = &fileInfoRec;
			
			fileInfoRec.f_size = optA->optinfo[pos].f_size;
			fileInfoRec.f_atime = optA->optinfo[pos].f_atime;
			fileInfoRec.f_mtime = optA->optinfo[pos].f_mtime;
			fileInfoRec.f_ctime = optA->optinfo[pos].f_ctime;
			fileInfoRec.f_perm = optA->optinfo[pos].f_perm;
			fileInfoRec.f_owner = optA->optinfo[pos].f_owner;
			fileInfoRec.f_owngrp = optA->optinfo[pos].f_owngrp;
			fileInfoRec.magic = NULL;
			
			display_info(&fileDataRec, optA->IbPtr, thiscmd);
			
			if (thisitem)
				free(thisitem);

			break;  

		default:
			printf("Menu option not available yet\n");
			break;
	}
}

void FindFileDialogClose(Widget w, XtPointer client_data, XtPointer call_data)
{
	struct OptAttrib * optA;
	
	XtVaGetValues(w, XmNuserData, &optA, NULL);
	
	if (optA->count)
		free(optA->optinfo);
	XtDestroyWidget((Widget)client_data);
}


/* General Cancel callback.  Destroy widget in client_data. */
void f_cancelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
	struct FindRec * frec;
	
	XtVaGetValues(w, XmNuserData, &frec, NULL);
	free(frec);
	XtDestroyWidget((Widget)client_data);
}

/* Load "/" into search directory field. */
void find_b1_CB(Widget w, XtPointer client_data, XtPointer call_data)
{
	struct FindRec * frec;
	
	XtVaGetValues(w, XmNuserData, &frec, NULL);
	XtVaSetValues(frec->tf2, XmNvalue, "/", NULL);
}

/* Load home directory into search directory field. */
void find_b2_CB(Widget w, XtPointer client_data, XtPointer call_data)
{
	struct FindRec * frec;
	
	XtVaGetValues(w, XmNuserData, &frec, NULL);
	XtVaSetValues(frec->tf2, XmNvalue, home_dir, NULL);
}

/* Prototype */
void find_CB(Widget, XtPointer, XtPointer);

void FindFileDialog(IfaceBranche * IbPtr)
{
	Widget find_shell, find_b1, find_b2, find_ok, find_cancel, 
			find_help, find_l1, find_l2, find_form, p_form, b_form;
	struct FindRec * frec;

	frec = (struct FindRec *) malloc(sizeof(struct FindRec));
	
	frec->IbPtr = IbPtr;

	find_shell = XtVaCreatePopupShell("find_qshell", vendorShellWidgetClass,
					IbPtr->top_level, XmNtitle, "Find file(s)", NULL);


	find_form = XtVaCreateManagedWidget("find_form", xmFormWidgetClass,
				    find_shell, NULL);


	find_l1 = XtVaCreateManagedWidget("find_l1", xmLabelWidgetClass, find_form,
										XmNlabelString, XmStringCreateSimple("Find this file or pattern:"),
										XmNtopAttachment, XmATTACH_FORM,
										XmNleftAttachment, XmATTACH_FORM,
										XmNrightAttachment, XmATTACH_FORM,
										NULL);
				    
	frec->tf1 = XtVaCreateManagedWidget("find_tf", xmTextFieldWidgetClass,
						find_form, XmNtopAttachment, XmATTACH_WIDGET, XmNtopWidget, find_l1,
						XmNleftAttachment, XmATTACH_FORM,
						XmNrightAttachment, XmATTACH_FORM,
						XmNvalue, "*", XmNuserData, frec, NULL);

	XtAddCallback(frec->tf1, XmNactivateCallback, find_CB, (XtPointer) find_shell);

	find_l2 = XtVaCreateManagedWidget("find_l2", xmLabelWidgetClass, find_form,
						XmNlabelString, XmStringCreateSimple("Start from this directory:"), 
						XmNtopAttachment, XmATTACH_WIDGET, XmNtopWidget, frec->tf1,
						XmNleftAttachment, XmATTACH_FORM,
						XmNrightAttachment, XmATTACH_FORM,
						NULL);

	p_form = XtVaCreateManagedWidget("p_form", xmFormWidgetClass,
				    find_form, 
					XmNtopAttachment, XmATTACH_WIDGET, XmNtopWidget, find_l2,
					XmNleftAttachment, XmATTACH_FORM,
					XmNrightAttachment, XmATTACH_FORM,
				    NULL);

	find_b2 = XtVaCreateManagedWidget("find_b2", xmPushButtonWidgetClass,
					p_form, XmNlabelString, XmStringCreateSimple("Home"), 
					XmNtopAttachment, XmATTACH_FORM,
					XmNrightAttachment, XmATTACH_FORM,
					XmNbottomAttachment, XmATTACH_FORM,
					XmNuserData, frec, NULL);

	XtAddCallback(find_b2, XmNactivateCallback, find_b2_CB, NULL);

	find_b1 = XtVaCreateManagedWidget("find_b1", xmPushButtonWidgetClass, 
				    p_form, XmNlabelString, XmStringCreateSimple("/"),
					XmNtopAttachment, XmATTACH_FORM,
					XmNrightAttachment, XmATTACH_WIDGET, XmNrightWidget, find_b2,
					XmNbottomAttachment, XmATTACH_FORM,
				    
				    XmNwidth, 50, XmNuserData, frec, NULL);
	XtAddCallback(find_b1, XmNactivateCallback, find_b1_CB, NULL);


	frec->tf2 = XtVaCreateManagedWidget("find_tf", xmTextFieldWidgetClass,
					p_form,  
					XmNtopAttachment, XmATTACH_FORM,
					XmNrightAttachment, XmATTACH_WIDGET, XmNrightWidget, find_b1,
					XmNleftAttachment, XmATTACH_FORM,
					XmNbottomAttachment, XmATTACH_FORM,
					XmNvalue, IbPtr->current_wd, XmNuserData, frec, NULL);
  
	XtAddCallback(frec->tf2, XmNactivateCallback, find_CB, (XtPointer) find_shell);


	b_form = XtVaCreateManagedWidget("b_form", xmFormWidgetClass,
				    find_form, 
					XmNtopAttachment, XmATTACH_WIDGET, XmNtopWidget, p_form,
					XmNleftAttachment, XmATTACH_FORM,
					XmNrightAttachment, XmATTACH_FORM,
					XmNbottomAttachment, XmATTACH_FORM,
				    XmNfractionBase, 3, NULL);

	find_ok = XtVaCreateManagedWidget("Find", xmPushButtonWidgetClass, b_form,
					XmNtopAttachment, XmATTACH_POSITION, 
					XmNleftAttachment, XmATTACH_POSITION,
					XmNrightAttachment, XmATTACH_POSITION,
					XmNbottomAttachment, XmATTACH_POSITION,
					XmNtopPosition, 1,
					XmNleftPosition, 0,
					XmNrightPosition, 1,
					XmNbottomPosition, 2,
					XmNuserData, frec, NULL);
	XtAddCallback(find_ok, XmNactivateCallback, find_CB, (XtPointer) find_shell);
  
	find_cancel = XtVaCreateManagedWidget("Cancel", xmPushButtonWidgetClass, b_form,  
					XmNtopAttachment, XmATTACH_POSITION, 
					XmNleftAttachment, XmATTACH_POSITION,
					XmNrightAttachment, XmATTACH_POSITION,
					XmNbottomAttachment, XmATTACH_POSITION,
					XmNtopPosition, 1,
					XmNleftPosition, 1,
					XmNrightPosition, 2,
					XmNbottomPosition, 2,
					XmNuserData, frec, NULL);

	XtAddCallback(find_cancel, XmNactivateCallback, f_cancelCB, (XtPointer) find_shell);


	find_help = XtVaCreateManagedWidget("Help", xmPushButtonWidgetClass, b_form,
					XmNtopAttachment, XmATTACH_POSITION, 
					XmNleftAttachment, XmATTACH_POSITION,
					XmNrightAttachment, XmATTACH_POSITION,
					XmNbottomAttachment, XmATTACH_POSITION,
					XmNtopPosition, 1,
					XmNleftPosition, 2,
					XmNrightPosition, 3,
					XmNbottomPosition, 2,
					XmNuserData, IbPtr, NULL);

	XtAddCallback(find_help, XmNactivateCallback, HelpTopic, (XtPointer) FILE_HELP_FIND);

	XtPopup(find_shell, XtGrabNone);
}


/* Ask about what directories and file pattern we should look for. */
void FindFileDialogBack(IfaceBranche * IbPtr)
{
  Widget find_shell, find_bb, find_b1, find_b2, find_ok, find_cancel, 
         find_help, find_l1, find_l2;
	struct FindRec * frec;

	frec = (struct FindRec *) malloc(sizeof(struct FindRec));
	
	frec->IbPtr = IbPtr;

  find_shell = XtVaCreatePopupShell("find_qshell", vendorShellWidgetClass,
				    IbPtr->top_level, XmNtitle, "Find file(s)", NULL);
  find_bb = XtVaCreateManagedWidget("find_bb", xmBulletinBoardWidgetClass,
				    find_shell, XmNwidth, 600, XmNheight, 400,
				    NULL);

  find_l1 = XtVaCreateManagedWidget("find_l1", xmLabelWidgetClass, find_bb,
				    XmNlabelString, XmStringCreateSimple("Find this file or pattern:"), XmNx, 10, XmNy, 10, NULL);
  frec->tf1 = XtVaCreateManagedWidget("find_tf", xmTextFieldWidgetClass,
				     find_bb, XmNx, 10, XmNy, 55, 
				     XmNvalue, "*", XmNwidth, 370, XmNuserData, frec, NULL);
  XtAddCallback(frec->tf1, XmNactivateCallback, find_CB,
		(XtPointer) find_shell);
  find_l2 = XtVaCreateManagedWidget("find_l2", xmLabelWidgetClass, find_bb,
				    XmNlabelString, XmStringCreateSimple("Start from this directory:"), XmNx, 10, XmNy, 150, NULL);
  frec->tf2 = XtVaCreateManagedWidget("find_tf", xmTextFieldWidgetClass,
				     find_bb, XmNx, 10, XmNy, 190, 
				     XmNwidth, 370, 
				     XmNvalue, IbPtr->current_wd, XmNuserData, frec, NULL);
  XtAddCallback(frec->tf2, XmNactivateCallback, find_CB,
		(XtPointer) find_shell);
  find_b1 = XtVaCreateManagedWidget("find_b1", xmPushButtonWidgetClass, 
				    find_bb, XmNx, 400, XmNy, 120,
				    XmNlabelString, XmStringCreateSimple("/"),
				    XmNwidth, 50, XmNuserData, frec, NULL);
  XtAddCallback(find_b1, XmNactivateCallback, find_b1_CB, NULL);
  find_b2 = XtVaCreateManagedWidget("find_b2", xmPushButtonWidgetClass,
				    find_bb, XmNx, 400, XmNy, 190,
				    XmNlabelString, XmStringCreateSimple("Home"), XmNwidth, 70, XmNuserData, frec, NULL);
  XtAddCallback(find_b2, XmNactivateCallback, find_b2_CB, NULL);

  find_ok = XtVaCreateManagedWidget("Find", xmPushButtonWidgetClass, find_bb,
				    XmNx, 40, XmNy, 300, XmNheight, 40,
				    XmNwidth, 90, XmNuserData, frec, NULL);
  XtAddCallback(find_ok, XmNactivateCallback, find_CB,
		(XtPointer) find_shell);
  find_cancel = XtVaCreateManagedWidget("Cancel", xmPushButtonWidgetClass, 
					find_bb, XmNx, 160, XmNy, 300, 
					XmNheight, 40, XmNwidth, 90, XmNuserData, frec, NULL);
  XtAddCallback(find_cancel, XmNactivateCallback, f_cancelCB,
		(XtPointer) find_shell);
  find_help = XtVaCreateManagedWidget("Help", xmPushButtonWidgetClass, find_bb,
				      XmNx, 280, XmNy, 300, XmNheight, 40,
				      XmNwidth, 90, XmNuserData, IbPtr, NULL);
  XtAddCallback(find_help, XmNactivateCallback, HelpTopic,
		(XtPointer) FILE_HELP_FIND);
  XtPopup(find_shell, XtGrabNone);
}


void ReadCB(XtPointer client_data, int * fid, XtInputId id)
{
	char incoming[4096];
	struct FindProc * fproc;
	struct OptAttrib * optA;
	char * p;
	struct stat buff;
	struct optfileinfo * finfo;
	
	fproc = (struct FindProc *) client_data;
	optA = fproc->opt;
	
	if (fgets(incoming, 4096, fproc->fp) != NULL) {
#ifdef DEBUG
    printf("Finded:%s\n", incoming);
#endif
		if (p = strchr(incoming, '\n'))
			*p = 0;
		XmListAddItem(fproc->list, XmStringCreateLocalized(incoming), 0);
		
		if (0 == stat(incoming, &buff))
		{
			if (optA->count == 0)
			{
				optA->optinfo = (struct optfileinfo *) malloc(sizeof(struct optfileinfo));
			}
			else
			{
				optA->optinfo = realloc(optA->optinfo, sizeof(struct optfileinfo) * (optA->count + 1));
			}
				
			finfo = optA->optinfo + (optA->count);
			optA->count++;

			finfo->f_size = buff.st_size;
			finfo->f_atime = buff.st_atime;
			finfo->f_mtime = buff.st_mtime;
			finfo->f_ctime = buff.st_ctime;
			finfo->f_perm = buff.st_mode;
			finfo->f_owner = buff.st_uid;
			finfo->f_owngrp = buff.st_gid;
			finfo->magic = NULL;
			strcpy(finfo->name, incoming);
		}
	}
	else
	{
		pclose(fproc->fp);
		XtRemoveInput(fproc->id);
		free(fproc);
	}
}


void find_CB(Widget w, XtPointer client_data, XtPointer call_data)
{
	Widget menubar_widget, file_pulldown, help_button;
	Widget file_run, file_copy, file_move, file_delete, file_info, file_exit;
	Widget f_shell, f_form;
	Widget f_slist;
	char *thispath, *thispattern, *shellcmd, *incoming;
	FILE *fp;
	XmString temp1;
	Arg args[10];
	struct FindRec * frec;
	IfaceBranche * IbPtr;
	struct FindProc * fproc;
	struct OptAttrib * optA;


#ifdef DEBUG
	printf("FindOK_CB \n");
#endif

	XtVaGetValues(w, XmNuserData, &frec, NULL);
	IbPtr = frec->IbPtr;

	XtVaGetValues(frec->tf1, XmNvalue, &thispattern, NULL);
	XtVaGetValues(frec->tf2, XmNvalue, &thispath, NULL);

#ifdef DEBUG
	printf("FindOK_CB %s %s\n",thispattern, thispath );
#endif

	shellcmd = calloc(strlen(thispath) + strlen(thispattern) + 30, sizeof(char));
	incoming = calloc(120, sizeof(char));

	sprintf(shellcmd, "find %s -name \"%s\"", thispath, thispattern);

#ifdef DEBUG
	printf("%s\n", shellcmd);
#endif

	free(frec);

	XtDestroyWidget((Widget) client_data);

  f_shell = XtVaCreatePopupShell("f_shell", vendorShellWidgetClass, IbPtr->top_level,
				 XmNtitle, "bxfm: Results of Find", NULL);
  f_form = XtVaCreateManagedWidget("f_form", xmFormWidgetClass, f_shell,
				   NULL);
  /* Begin menu bar definition. */
  XtSetArg(args[0], XmNtopAttachment, XmATTACH_FORM);
  XtSetArg(args[1], XmNleftAttachment, XmATTACH_FORM);
  XtSetArg(args[2], XmNrightAttachment, XmATTACH_FORM);
  menubar_widget = XmCreateMenuBar(f_form, "menubar", args, 3);
  XtManageChild(menubar_widget);
  file_pulldown = XmCreatePulldownMenu(menubar_widget, "file_pulldown", 
				       NULL, 0);
  file_run = XtVaCreateManagedWidget("file_run", xmPushButtonWidgetClass,
				     file_pulldown, NULL);
  XtAddCallback(file_run, XmNactivateCallback, FindMenuCallback,
		(XtPointer) FILE_MENU_RUN);
  XtVaSetValues(file_run, XmNlabelString, XmStringCreateSimple("Run..."),
		NULL);
  file_copy = XtVaCreateManagedWidget("file_copy", xmPushButtonWidgetClass,
				     file_pulldown, NULL);
  XtAddCallback(file_copy, XmNactivateCallback, FindMenuCallback,
		(XtPointer) FILE_MENU_COPY);
  XtVaSetValues(file_copy, XmNlabelString, XmStringCreateSimple("Copy"),
		NULL);
  file_move = XtVaCreateManagedWidget("file_move", xmPushButtonWidgetClass,
				     file_pulldown, NULL);
  XtAddCallback(file_move, XmNactivateCallback, FindMenuCallback,
		(XtPointer) FILE_MENU_MOVE);
  XtVaSetValues(file_move, XmNlabelString, XmStringCreateSimple("Move"),
		NULL);
  file_delete = XtVaCreateManagedWidget("file_delete", xmPushButtonWidgetClass,
				     file_pulldown, NULL);
  XtAddCallback(file_delete, XmNactivateCallback, FindMenuCallback,
		(XtPointer) FILE_MENU_DELETE);
  XtVaSetValues(file_delete, XmNlabelString, XmStringCreateSimple("Delete"),
		NULL);
  file_info = XtVaCreateManagedWidget("file_info", xmPushButtonWidgetClass,
				     file_pulldown, NULL);
  XtAddCallback(file_info, XmNactivateCallback, FindMenuCallback,
		(XtPointer) FILE_MENU_INFO);
  XtVaSetValues(file_info, XmNlabelString, XmStringCreateSimple("Info"),
		NULL);
  file_exit = XtVaCreateManagedWidget("file_close", xmPushButtonWidgetClass,
				      file_pulldown, NULL);
  XtAddCallback(file_exit, XmNactivateCallback, FindFileDialogClose,
		(XtPointer) f_shell);
  XtVaSetValues(file_exit, XmNlabelString, XmStringCreateSimple("Close"),
		NULL);
  XtVaCreateManagedWidget("File", xmCascadeButtonWidgetClass, menubar_widget,
			  XmNsubMenuId, file_pulldown, NULL);
  help_button = XtVaCreateManagedWidget("Help", xmCascadeButtonWidgetClass,
					menubar_widget, NULL);
	XtVaSetValues(help_button, XmNuserData, IbPtr, NULL);

  XtAddCallback(help_button, XmNactivateCallback, HelpTopic,
		(XtPointer) FIND_WINDOW);
  XtVaSetValues(menubar_widget, XmNmenuHelpWidget, help_button, NULL);
  /* End menu bar definition. */

  XtSetArg(args[0], XmNwidth, 360);
  XtSetArg(args[1], XmNheight, 360);
  XtSetArg(args[2], XmNselectionPolicy, XmSINGLE_SELECT);
  XtSetArg(args[3], XmNscrollingPolicy, XmAUTOMATIC);
  XtSetArg(args[4], XmNtopAttachment, XmATTACH_WIDGET);
  XtSetArg(args[5], XmNtopWidget, menubar_widget);
  XtSetArg(args[6], XmNbottomAttachment, XmATTACH_FORM);
  XtSetArg(args[7], XmNleftAttachment, XmATTACH_FORM);
  XtSetArg(args[8], XmNrightAttachment, XmATTACH_FORM);
  f_slist = XmCreateScrolledList(f_form, "f_slist", args, 9);

  if ((fp = popen(shellcmd, "r")) == NULL) {
  free(shellcmd);
  free(incoming);
  XtDestroyWidget(f_shell);
    NoCanDo(DONT_HAVE_FIND, IbPtr, NULL, NULL);
    return;
  }

	fproc = (struct FindProc *) malloc(sizeof(struct FindProc));
	fproc->list = f_slist;
	fproc->IbPtr = IbPtr;
	fproc->fp = fp;
	fproc->id = XtAppAddInput(IbPtr->app, fileno(fp), XtInputReadMask, (XtInputCallbackProc) ReadCB, (XtPointer) fproc);

	optA = (struct OptAttrib *) calloc(1, sizeof(struct OptAttrib));
	optA->list = f_slist;
	optA->IbPtr = IbPtr;
	
	fproc->opt = optA;
	
	XtVaSetValues(file_run, XmNuserData, optA, NULL);
	XtVaSetValues(file_copy, XmNuserData, optA, NULL);
	XtVaSetValues(file_move, XmNuserData, optA, NULL);
	XtVaSetValues(file_delete, XmNuserData, optA, NULL);
	XtVaSetValues(file_exit, XmNuserData, optA, NULL);
	XtVaSetValues(file_info, XmNuserData, optA, NULL);

//  while (fgets(incoming, 120, fp) != NULL) {
//#ifdef DEBUG
//    printf("%s\n", incoming);
//#endif
//    XmListAddItem(f_slist, XmStringCreateSimple(incoming), 0);
//  }
//  pclose(fp);

	XtManageChild(f_slist);

	XtPopup(f_shell, XtGrabNone);

	free(shellcmd);
	free(incoming);
}










