#define _XOPEN_SOURCE 500

#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <stdlib.h>
#include <pthread.h>
#include <dirent.h>
#include <errno.h>
#include <utime.h>
#include <ftw.h>


#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/SelectioB.h>
#include <Xm/MessageB.h>

#include "core.h"
#include "errormsg.h"
#include "defines.h"
#include "getdir.h"
#include "filearea.h"
#include "helpsys.h"
#include "permission.h"
#include "utils.h"

#include <X11/Xatom.h>
#include <X11/Xmu/Atoms.h>
#include <X11/Xmu/StdSel.h>
#include <pthread.h>
#include <semaphore.h>
#include <alloca.h>


//#define DEBUG 1
#define CP_BUFSIZE 1000
#define MAXPATHLEN 4000

#define M_OK 0
#define M_ABORT -1

#define N_OK 0
#define N_ABORT -1
#define N_SKIP 1


#define CM_COPY 1
#define CM_MOVE 2
#define CM_CANCEL 3

#define MAX_CHECK_MOVE_THRED 10

extern Atom COPY_ATOM;
extern Atom UTF8_STRING;
//extern Widget top_level, fm_scroll1;
//extern char current_wd[120];
char cur_file[100];
//char * file_list = NULL;


struct _CheckMoveCap
{
	pthread_t task_thread_id;
	int nofree;
	struct _PreparingRec * prec;
} typedef CheckMoveCap;

CheckMoveCap CheckMoveArr[MAX_CHECK_MOVE_THRED];

pthread_mutex_t check_move_mutex = PTHREAD_MUTEX_INITIALIZER;

void CleanCMData(struct _PreparingRec * rec)
{
	struct _FileListNode * list, * ptr;
	struct _FilesOpsRec * list2, * ptr2;

	sem_t * sem;
	pthread_mutex_t * mutex;

	list = rec->In;
	while (list)
	{
		ptr = list->next;
		if (list->fname) free(list->fname);
		if (list->ddir) free(list->ddir);
		free(list);
		list = ptr;
	}

	list = rec->OutMove;
	while (list)
	{
		ptr = list->next;
		if (list->fname) free(list->fname);
		if (list->ddir) free(list->ddir);
		free(list);
		list = ptr;
	}

	list2 = rec->Out;
	while (list2)
	{
		ptr2 = list2->Next;
		if (list2->src) free(list2->src);
		if (list2->dst) free(list2->dst);
		free(list2);
		list2 = ptr2;
	}


	if (rec->filename) free(rec->filename);

	if (rec->full_dest_path) free(rec->full_dest_path);

	if (rec->full_source_path) free(rec->full_source_path);

	if (rec->dstdir) free(rec->dstdir);

	sem = rec->sem;
	mutex = rec->mutex;

	if (mutex)
	{ 
		pthread_mutex_destroy(mutex);
		free(rec->mutex);
	}

/*	sem_destroy(rec->sem);
	free(rec->sem);*/
	free(rec);
	
	return ;
}

void CleanMDataList(struct _FileListNode * list)
{
	struct _FileListNode * ptr;

	while (list)
	{
		ptr = list->next;
		if (list->fname) free(list->fname);
		if (list->ddir) free(list->ddir);
		free(list);
		list = ptr;
	}
	return ;
}


void InitCheckMoveArr(void)
{
	int i;
	
	for (i = 0; i < MAX_CHECK_MOVE_THRED; i++)
	{
		CheckMoveArr[i].nofree = 0;
		CheckMoveArr[i].prec = NULL;
	}
}


int CheckReadPerm(struct stat * stbuf)
{
	
	if (local_uid == stbuf->st_uid)
	{
		if (stbuf->st_mode & S_IRUSR)
			return 1;
	}

	if (local_gid == stbuf->st_gid)
	{
		if (stbuf->st_mode & S_IRGRP)
			return 1;
	}
	
	if (stbuf->st_mode & S_IROTH)
		return 1;
	
	return 0;
}

int CheckWritePerm(struct stat * stbuf)
{
	
	if (local_uid == stbuf->st_uid)
	{
		if (stbuf->st_mode & S_IWUSR)
			return 1;
	}

	if (local_gid == stbuf->st_gid)
	{
		if (stbuf->st_mode & S_IWGRP)
			return 1;
	}
	
	if (stbuf->st_mode & S_IWOTH)
		return 1;
	
	return 0;
}

static void WaitUnknownError(struct _PreparingRec *rec, const char * path)
{
	sem_t * sem;

	sem = rec->sem;

	rec->message = strdup(path);
	rec->dialog_type = DIALOG_UNKNOWN_ERROR_TYPE;

	rec->wait_user_action = 1;
	sem_wait(sem);
}


static void WaitNoCanDo(struct _PreparingRec *rec, char * path)
{
	sem_t * sem;

	sem = rec->sem;

	rec->message = strdup(path);
	rec->dialog_type = DIALOG_NO_CAN_DO_TYPE;

	rec->wait_user_action = 1;
	sem_wait(sem);
}

static void WaitDeleteFileError(struct _PreparingRec *rec, char * path)
{
	sem_t * sem;

	sem = rec->sem;

	rec->message = strdup(path);
	rec->dialog_type = DIALOG_DELETE_FILE_TYPE;

	rec->wait_user_action = 1;
	sem_wait(sem);
}

static void WaitDeleteDirError(struct _PreparingRec *rec, char * path)
{
	sem_t * sem;

	sem = rec->sem;

	rec->message = strdup(path);
	rec->dialog_type = DIALOG_DELETE_DIR_TYPE;

	rec->wait_user_action = 1;
	sem_wait(sem);
}


static void WaitNoRead(struct _PreparingRec *rec, const char * path)
{
	sem_t * sem;

	sem = rec->sem;

	rec->message = strdup(path);
	rec->dialog_type = DIALOG_NO_READ_TYPE;

	rec->wait_user_action = 1;
	sem_wait(sem);
}

static void WaitNoWrite(struct _PreparingRec *rec, const char * path)
{
	sem_t * sem;

	sem = rec->sem;

	rec->message = strdup(path);
	rec->dialog_type = DIALOG_NO_WRITE_TYPE;

	rec->wait_user_action = 1;
	sem_wait(sem);
}

static void WaitDestinationDirFound(struct _PreparingRec *rec, const char * path)
{
	sem_t * sem;

	sem = rec->sem;

	rec->dialog_type = DIALOG_DESTINATION_DIR_FOUND_TYPE;
	rec->message = strdup(path);

	rec->wait_user_action = 1;
	sem_wait(sem);
}

static void WaitDestinationFileFound(struct _PreparingRec *rec, const char * path)
{
	sem_t * sem;

	sem = rec->sem;

	rec->dialog_type = DIALOG_DESTINATION_FILE_FOUND_TYPE;
	rec->message = strdup(path);

	rec->wait_user_action = 1;
	sem_wait(sem);
}

static void WaitNoRemove(struct _PreparingRec *rec, const char * path)
{
	sem_t * sem;

	sem = rec->sem;

	rec->message = strdup(path);
	rec->dialog_type = DIALOG_NO_REMOVE_TYPE;

	rec->wait_user_action = 1;
	sem_wait(sem);
}


/*-------------------------------------------------------------------------*/

/* recursive delete */
/* From moxfm */


int rdel(const char *path)
{
 DIR *dir;
 struct dirent *entry;
 struct stat stats;
 int i, pl = strlen(path), res;
  
  res = 0;
 if (lstat(path, &stats) || !(dir = opendir(path)))
     return -1;

 if (!(permission(&stats, P_WRITE)))
 {
#ifdef DEBUG
	printf("rdel: dir deleting not permitted\n");
#endif
     closedir(dir);
/*     errno = EPERM;
     rmError(path, !rm_only_dirs);*/
     return -1;
 }

 for (i=0; (entry = readdir(dir)); i++)
 {
      if (entry->d_name[0] != '.' || (entry->d_name[1] != '\0' && (entry->d_name[1] != '.' || entry->d_name[2] != '\0')))
      {
	  int pl1 = pl, l = strlen(entry->d_name);
	  char *path1 = (char *)alloca(pl1+l+2);

	  strcpy(path1, path);
	  if (path1[pl1-1] != '/')  path1[pl1++] = '/';
	  strcpy(path1+pl1, entry->d_name);
	  if (!(res = lstat(path1, &stats)))
	  {
	      if (!S_ISLNK(stats.st_mode) && S_ISDIR(stats.st_mode))
		  res = rdel(path1);
	      else res = unlink(path1);
#ifdef DEBUG
			printf("rdel: res = %d\n", res);
#endif
	  }
	  if (res)
	  {
/*	      rmError(path1, !rm_only_dirs);
	      if (abort_delete)  break;*/
#ifdef DEBUG
			printf("rdel: returned error\n");
#endif
	      break ;
	  }
      }
 }
 if (closedir(dir) || rmdir(path) || res)
     return -1;
   else
	return 0;
}


char * FilenameFromPath(char * string)
{
	char * ptr;
	while ((ptr = strstr(string, "/")))
	{
		string = ptr + 1;
	}
	return string;
}

/* Run selected application */
void RunSelectedFile(char *thisprg, IfaceBranche * IbPtr) {
  char thiscmd[120];
  struct stat buf;
  int ret;

  stat(thisprg, &buf);
  if (S_ISDIR(buf.st_mode)) {
    NoCanDo(NOT_EXECUTABLE, IbPtr, NULL, NULL);
    return;
  }
  if (IsExecutable(buf)) {
    sprintf(thiscmd, "%s &", thisprg);
    ret = system(thiscmd);
    return;
  }
  if (buf.st_mode & 73) {
    NoCanDo(CANT_EXECUTE, IbPtr, NULL, NULL);
    return;
  }
  NoCanDo(NOT_EXECUTABLE, IbPtr, NULL, NULL);
}

/* OK callback for RunUnselectedFile */
void RunUnselectedFile_ok(Widget w, XtPointer client_data, XtPointer call_data)
{
  XmSelectionBoxCallbackStruct *selection;
  char *text, systemcall[90];
  struct stat buf;
  int ret;
  IfaceBranche * IbPtr = (IfaceBranche *) client_data;

  selection = (XmSelectionBoxCallbackStruct *) call_data;
  if (selection->length) {
    XmStringGetLtoR(selection->value, XmFONTLIST_DEFAULT_TAG, &text);
    stat(text, &buf);
    if ((IsExecutable(buf) == 1)) {
      if (S_ISDIR(buf.st_mode))
	NoCanDo(NOT_EXECUTABLE, IbPtr, NULL, NULL);
      else {
	sprintf(systemcall, "%s &", text);
	ret = system(systemcall);
      }
    }
    else
      NoCanDo(CANT_EXECUTE, IbPtr, NULL, NULL);
    XtFree(text);
  }
  XtDestroyWidget(w);
}

/* Ask user to name application to run */
void RunUnselectedFile(IfaceBranche * IbPtr) {
  Widget rundialog;
  XmString run_prompt;
  Arg args[10];

  run_prompt=XmStringCreateLtoR("Name of program to run:",
				XmSTRING_DEFAULT_CHARSET);

  XtSetArg(args[0], XmNselectionLabelString, run_prompt);
  XtSetArg(args[1], XmNtitle, "Run which file?");
	XtSetArg(args[2], XmNuserData, IbPtr);
//	n++;
  rundialog=(Widget)XmCreatePromptDialog(IbPtr->top_level, "rundialog_sh", args, 3);
  XtAddCallback(rundialog, XmNokCallback, RunUnselectedFile_ok, IbPtr);
  XtAddCallback(rundialog, XmNcancelCallback, CancelCB, IbPtr);
  XtAddCallback(rundialog, XmNhelpCallback, HelpTopic, 
		(XtPointer)FILE_HELP_RUN);
  XtManageChild(rundialog);
  XmStringFree(run_prompt);
}

/* Function prototype */
void CopyMoveFile(char *, int, IfaceBranche *);


static int copy(struct _PreparingRec * , int , const char *, const char *);


static int preparediroverwrite(struct _PreparingRec * rec, const char * path)
{
	sem_t * sem;
	int ret;

	sem = rec->sem;

	ret = rdel(path);
	if (ret)
	{
#ifdef DEBUG
		printf("preparediroverwrite: rdel error, creating NoDeleteDialog\n");
#endif
		if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
#ifdef DEBUG
		printf("preparediroverwrite: old dialog destroyed\n");
#endif
		rec->ProgressDialogFound = False;
		NoDeleteDialog(rec, path);
		sem_wait(sem);
#ifdef DEBUG
		printf("preparediroverwrite: returned from NoDeleteDialog\n");
#endif
		if (rec->dialog_ret_code == DIALOG_RET_CANCEL) return N_ABORT;
		if (rec->dialog_ret_code == DIALOG_RET_SKIP) return N_SKIP;
	}
	return N_OK;
	
}

static int preparedir(struct _PreparingRec * rec, struct stat *oldstats,
					const char *oldpath, const char *newpath)
{
	DIR *dir;
	struct dirent *entry;
	int i;
	struct stat newstats;
	struct _FileListNode * list, * ptr, *ptr2;
	sem_t * sem;
	int ret;
	int new_dir_created = 0;
	
	sem = rec->sem;

#ifdef DEBUG
	printf("preparedir: start %s -> %s\n", oldpath, newpath);
#endif

/*****************************************************/
/************ Destination dir found check ************/
/*****************************************************/
	if(!(lstat(newpath, &newstats)))
	{
		
#ifdef DEBUG
		printf("preparedir: destination dir found \n");
#endif
		if (rec->UserInterrupt) return M_ABORT;
		if (rec->SkipAllDstDir) return M_OK;

#ifdef DEBUG
		printf("preparedir: not skipped or canceled \n");
#endif

		if (!rec->OverwriteAllDstDir)
		{
#ifdef DEBUG
			printf("preparedir: not overwrite all dir \n");
#endif
//			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//			rec->ProgressDialogFound = False;
#ifdef DEBUG
			printf("preparedir: old dialog destroyed \n");
#endif
			WaitDestinationDirFound(rec, newpath);
//			DestinationDirFoundDialog(rec, newpath);
//			sem_wait(sem);

			if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
			{
				rec->UserInterrupt = True;
				return M_ABORT;
			}
			if (rec->dialog_ret_code == DIALOG_RET_SKIP) return M_OK;
			if (rec->dialog_ret_code == DIALOG_RET_SKIP_ALL)
			{
				rec->SkipAllDstDir = True;
				rec->OverwriteAllDstDir = False;
				return M_OK;
			}
			
			if (rec->dialog_ret_code == DIALOG_RET_OVERWRITE)
			{
/*				ret = preparediroverwrite(rec, newpath);
				if (ret == N_ABORT) return M_ABORT;
				if (ret == N_SKIP) return M_OK;*/
				rec->SkipAllDstDir = False;
				goto scan_phase;
			}
			
			if (rec->dialog_ret_code == DIALOG_RET_OVERWRITE_ALL)
			{
				rec->SkipAllDstDir = False;
				rec->OverwriteAllDstDir = True;
				goto scan_phase;
			}
		}
		
		if (rec->OverwriteAllDstDir)
		{
#ifdef DEBUG
			printf("preparedir: destination dir found and oerwrite all\n");
#endif
/*			ret = preparediroverwrite(rec, newpath);
			if (ret == N_ABORT) 
			{
				rec->UserInterrupt = True;
				return M_ABORT;
			}
			if (ret == N_SKIP) return M_OK;*/
			goto scan_phase;
		}
	}
/*****************************************************/
/********* End of destination dir found check ********/
/*****************************************************/

/*	if ((mkdir(newpath, oldstats->st_mode) < 0 && errno != EEXIST) ||
		lstat(newpath, &newstats) || !(dir = opendir(oldpath)))
	{
		rec->ret_code = STATUS_UNKNOWN_ERROR;
		return M_OK;
	}*/
	
	if ((mkdir(newpath, oldstats->st_mode)) < 0 && errno != EEXIST)
	{
		rec->ret_code = STATUS_NO_WRITABLE;
		return M_ABORT;
	}
	new_dir_created = 1;


scan_phase:

	if ((dir = opendir(oldpath)) == NULL)
	{
		rec->ret_code = STATUS_NO_READABLE;
		return M_ABORT;
	}

	if (new_dir_created)
	{
		if (!(oldstats->st_mode & S_IWUSR))
		{
			mode_t wr_mode;
			
			wr_mode = oldstats->st_mode | S_IWUSR;
			chmod(newpath, wr_mode);
		}
	}
	
#ifdef DEBUG
	printf("preparedir: dir %s created\n", newpath);
#endif

	list = NULL;
	ptr = NULL;
	ptr2 = NULL;

	for(i = 0; (entry = readdir(dir)); i++)
	{
		if (rec->UserInterrupt)
		{
#ifdef DEBUG
			printf("Copydir interrupted by user\n");
#endif
			closedir(dir);
			return M_ABORT;
		}
		if (entry->d_name[0] != '.' || (entry->d_name[1] != '\0'
			&& (entry->d_name[1] != '.' || entry->d_name[2] != '\0'))) 
		{
//			int ol1 = ol, nl1 = nl, l = strlen(entry->d_name), res;
/*			char *oldpath1 = (char *)alloca(ol1+l+2);
			char *newpath1 = (char *)alloca(nl1+l+2);

			strcpy(oldpath1, oldpath);
			strcpy(newpath1, newpath);
			if (oldpath1[ol1-1] != '/')
				oldpath1[ol1++] = '/';
			if (newpath1[nl1-1] != '/')
				newpath1[nl1++] = '/';

			strcpy(oldpath1+ol1, entry->d_name);
			strcpy(newpath1+nl1, entry->d_name);*/

			ptr = malloc(sizeof(struct _FileListNode));
			if (!list) list = ptr; /* list - first node */
			ptr->next = NULL;
			
/*			ptr->next = rec->In;
			rec->In = ptr;*/

			ptr->command = rec->In->command;
//			ptr->fname = malloc(strlen(oldpath) + 3 + strlen(FilenameFromPath(oldpath)) + strlen(entry->d_name));
			ptr->fname = malloc(strlen(oldpath) + 3 + strlen(entry->d_name));
			strcpy(ptr->fname, oldpath);
			strcat(ptr->fname, "/");
			strcat(ptr->fname, entry->d_name);

			ptr->ddir = malloc(strlen(newpath));
			strcpy(ptr->ddir, newpath);

#ifdef DEBUG
			printf("preparedir: added entry -> %s for destdir %s\n", ptr->fname, ptr->ddir);
#endif
			
			if (ptr2) ptr2->next = ptr;
			ptr2 = ptr;
		}
	}

	if (list)
	{
		ptr2 = rec->In->next;
		rec->In->next = list;
		ptr->next = ptr2;
	}
	
#ifdef DEBUG
	list = rec->In;
	while (list)
	{
		printf("Check point: %s -> %s\n", list->fname, list->ddir);
		list = list->next;
	}
#endif
	closedir(dir);
	if (rec->UserInterrupt) 
		return M_ABORT;
	else
		return M_OK;

}


static int preparedir_move(struct _PreparingRec * rec, struct _FileListNode ** list, struct stat *oldstats,
					const char *oldpath, const char *newpath)
{
	DIR *dir;
	struct dirent *entry;
	int i;
	struct stat newstats;
	struct _FileListNode * ptr, *ptr2, *new_list, *ptr3;
	sem_t * sem;
	int ret;
	int new_dir_created = 0;
	
	sem = rec->sem;

#ifdef DEBUG
	printf("preparedir_move: start %s -> %s\n", oldpath, newpath);

	ptr = *list;
	while (ptr)
	{
		printf("Check point0: %s -> %s\n", ptr->fname, ptr->ddir);
		ptr = ptr->next;
	}
#endif

/*****************************************************/
/************ Destination dir found check ************/
/*****************************************************/
	if(!(lstat(newpath, &newstats)))
	{
		
#ifdef DEBUG
		printf("preparedir_move: destination dir found \n");
#endif
		if (rec->UserInterrupt) 
		{
			return M_ABORT;
		}
		if (rec->SkipAllDstDir)
		{
			return M_OK;
		}

#ifdef DEBUG
		printf("preparedir_move: not skipped or canceled \n");
#endif

		if (!S_ISDIR(newstats.st_mode))
		{
#ifdef DEBUG
			printf("preparedir_move: found destination name %s and it is not directory\n", newpath);
#endif


			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
			rec->ProgressDialogFound = False;
#ifdef DEBUG
			printf("preparedir_move: old dialog destroyed \n");
#endif
			NoExecActionDialog(rec, "In destination directory found file with name of moved directory.");
			sem_wait(sem);

			if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
			{
				rec->UserInterrupt = True;
				return M_ABORT;
			}
			if (rec->dialog_ret_code == DIALOG_RET_SKIP) 
			{	

				ptr3 = *list;
				ptr2 = ptr3->next;
	
				*list = ptr2;

				if (ptr3->fname)
					free(ptr3->fname);
					
				if (ptr3->ddir)
					free(ptr3->ddir);
	
				free(ptr3);
#ifdef DEBUG
				ptr = *list;
				while (ptr)
				{
					printf("Check point1: %s -> %s\n", ptr->fname, ptr->ddir);
					ptr = ptr->next;
				}

				ptr = rec->OutMove;
				while (ptr)
				{
					printf("Check point2: %s -> %s\n", ptr->fname, ptr->ddir);
					ptr = ptr->next;
				}
#endif

				return M_OK;

			}
		}
		else
			goto scan_phase;
/*		if (!rec->OverwriteAllDstDir)
		{
#ifdef DEBUG
			printf("preparedir_move: not overwrite all dir \n");
#endif
			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
			rec->ProgressDialogFound = False;
#ifdef DEBUG
			printf("preparedir_move: old dialog destroyed \n");
#endif
			DestinationDirFoundDialog(rec, newpath);
			sem_wait(sem);

			if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
			{
				rec->UserInterrupt = True;
				return M_ABORT;
			}
			if (rec->dialog_ret_code == DIALOG_RET_SKIP) return M_OK;
			if (rec->dialog_ret_code == DIALOG_RET_SKIP_ALL)
			{
				rec->SkipAllDstDir = True;
				rec->OverwriteAllDstDir = False;
				return M_OK;
			}
			
			if (rec->dialog_ret_code == DIALOG_RET_OVERWRITE)
			{
				rec->SkipAllDstDir = False;
				goto scan_phase;
			}
			
			if (rec->dialog_ret_code == DIALOG_RET_OVERWRITE_ALL)
			{
				rec->SkipAllDstDir = False;
				rec->OverwriteAllDstDir = True;
				goto scan_phase;
			}
		}
		
		if (rec->OverwriteAllDstDir)
		{
#ifdef DEBUG
			printf("preparedir_move: destination dir found and oerwrite all\n");
#endif
			goto scan_phase;
		}*/
	}
/*****************************************************/
/********* End of destination dir found check ********/
/*****************************************************/

/*	if ((mkdir(newpath, oldstats->st_mode) < 0 && errno != EEXIST) ||
		lstat(newpath, &newstats) || !(dir = opendir(oldpath)))
	{
		rec->ret_code = STATUS_UNKNOWN_ERROR;
		return M_OK;
	}*/
	
	if ((mkdir(newpath, oldstats->st_mode)) < 0 && errno != EEXIST)
	{
		rec->ret_code = STATUS_NO_WRITABLE;
		return M_ABORT;
	}
	new_dir_created = 1;


scan_phase:

#ifdef DEBUG
	printf("preparedir_move: scan dir %s\n", oldpath);
#endif

	if ((dir = opendir(oldpath)) == NULL)
	{
		rec->ret_code = STATUS_NO_READABLE;
		return M_ABORT;
	}

	if (new_dir_created)
	{
		if (!(oldstats->st_mode & S_IWUSR))
		{
			mode_t wr_mode;
			
			wr_mode = oldstats->st_mode | S_IWUSR;
			chmod(newpath, wr_mode);
		}
	}
	
#ifdef DEBUG
	printf("preparedir_move: dir %s created\n", newpath);
#endif


/**********************************/
/**********************************/

	new_list = NULL;
	ptr = NULL;
	ptr2 = NULL;

	for(i = 0; (entry = readdir(dir)); i++)
	{
//		printf("%p -> %p -> %s\n", dir, entry, oldpath);
		if (rec->UserInterrupt)
		{
#ifdef DEBUG
			printf("Copydir interrupted by user\n");
#endif
			closedir(dir);
			return M_ABORT;
		}
//		printf("A == %c%c%c\n", entry->d_name[0], entry->d_name[1], entry->d_name[2]);
//		if (entry->d_name[0] != '.' || (entry->d_name[1] != '\0'
//			&& (entry->d_name[1] != '.' || entry->d_name[2] != '\0'))) 
		if (((strcmp(entry->d_name, ".")) != 0) && ((strcmp(entry->d_name, "..")) != 0)) 
		{
//		printf("AA == %s\n", entry->d_name);
//			int ol1 = ol, nl1 = nl, l = strlen(entry->d_name), res;
/*			char *oldpath1 = (char *)alloca(ol1+l+2);
			char *newpath1 = (char *)alloca(nl1+l+2);

			strcpy(oldpath1, oldpath);
			strcpy(newpath1, newpath);
			if (oldpath1[ol1-1] != '/')
				oldpath1[ol1++] = '/';
			if (newpath1[nl1-1] != '/')
				newpath1[nl1++] = '/';

			strcpy(oldpath1+ol1, entry->d_name);
			strcpy(newpath1+nl1, entry->d_name);*/

//			printf("ok1\n");
			ptr = malloc(sizeof(struct _FileListNode));
			if (!new_list) new_list = ptr; /* list - first node */
			ptr->next = NULL;
//			printf("ok2\n");
//		continue;
			

//			ptr->command = rec->In->command;
			ptr->fname = calloc(strlen(oldpath) + 3 + strlen(entry->d_name), sizeof(char));
			strcpy(ptr->fname, oldpath);
			strcat(ptr->fname, "/");
			strcat(ptr->fname, entry->d_name);
//			printf("ok3\n");

			ptr->ddir = malloc(strlen(newpath));
			strcpy(ptr->ddir, newpath);

#ifdef DEBUG
			printf("preparedir_move: added entry -> %s for destdir %s\n", ptr->fname, ptr->ddir);
#endif
			
			if (ptr2) ptr2->next = ptr;
			ptr2 = ptr;
		}
	}
#ifdef DEBUG
			printf("preparedir_move: scan dir ok \n");
#endif

	ptr3 = *list;
	ptr2 = ptr3->next;
	
	if (new_list)
	{
		*list = new_list;
		ptr->next = ptr2;
	}
	else
	{
		*list = ptr2;
	}


/*	ptr3 = *list;
	if (new_list)
	{
		ptr2 = ptr3->next;
		*list = new_list;;
		ptr->next = ptr2;
	}*/
	
	ptr3->next = rec->OutMove;
	rec->OutMove = ptr3;
	
//#ifdef DEBUG
	ptr = *list;
	while (ptr)
	{
#ifdef DEBUG
		printf("Check point1: %s -> %s\n", ptr->fname, ptr->ddir);
#endif
		ptr = ptr->next;
	}

	ptr = rec->OutMove;
	while (ptr)
	{
#ifdef DEBUG
		printf("Check point2: %s -> %s\n", ptr->fname, ptr->ddir);
#endif
		ptr = ptr->next;
	}

//#endif
	closedir(dir);
	if (rec->UserInterrupt) 
		return M_ABORT;
	else
		return M_OK;

}



static int copyfile(struct _PreparingRec * rec, const char *oldpath, const char *newpath)
{
	struct stat stats;
	int src = -1, dest = -1, n;
	char buf[CP_BUFSIZE];
	XmString info;
	sem_t * sem;
	struct utimbuf tm_buf;
	
	sem = rec->sem;

#ifdef DEBUG
	printf("copyfile: start %s -> %s\n", oldpath, newpath);
	sleep(1);
#endif

	if ((src = open(oldpath, O_RDONLY)) == -1 || stat(oldpath, &stats))
	{
		rec->ret_code = STATUS_NO_READABLE;
//		if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//		rec->ProgressDialogFound = False;
		WaitNoRead(rec, oldpath);
//		NoReadDialog(rec, oldpath);
//		sem_wait(sem);
		if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
		{
			rec->UserInterrupt = True;
			return M_ABORT;
		}
		if (rec->dialog_ret_code == DIALOG_RET_SKIP) return M_OK;
	}
	else 
		if ((dest = creat(newpath, stats.st_mode)) == -1)
		{
			rec->ret_code = STATUS_NO_WRITABLE;
			if (src != -1) close(src);
//			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//			rec->ProgressDialogFound = False;
			WaitNoWrite(rec, newpath);
//			NoWriteDialog(rec, newpath);
//			sem_wait(sem);
			if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
			{
				rec->UserInterrupt = True;
				return M_ABORT;
			}
			if (rec->dialog_ret_code == DIALOG_RET_SKIP) return M_OK;
	
		}

	if (rec->ProgressDialogFound == True)
	{ 
		info = XmStringCreateLocalized((char *) oldpath);
		if (rec->ProgressDialogFound)
		{
			XtVaSetValues(rec->ProgressDialog, XmNmessageString, info, NULL);
			XmUpdateDisplay(rec->ProgressDialog);
		}
		XmStringFree(info);
	}
/*	else
	{
		CopyMoveProgressDialogNew(rec, "bxfm: copy/move"); 
		rec->ProgressDialogFound = True;
		info = XmStringCreateLocalized(oldpath);
		XtVaSetValues(rec->ProgressDialog, XmNmessageString, info, NULL);
		XmStringFree(info);
		XmUpdateDisplay(rec->ProgressDialog);
		
	}*/

	while ( (n = read(src, buf, CP_BUFSIZE)) != 0)
	{
		if ( n == -1 || write(dest, buf, n) != n ) 
		{
			rec->ret_code = STATUS_UNKNOWN_ERROR;
#ifdef DEBUG
			printf("copyfile: unknown error in copy data phase\n");
#endif
			if (src != -1) close(src);
			if (dest != -1) close(dest);
			unlink(newpath);
//			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//			rec->ProgressDialogFound = False;
			WaitUnknownError(rec, newpath);
//			UnknownErrorDialog(rec, newpath);
//			sem_wait(sem);
			if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
			{
				rec->UserInterrupt = True;
				return M_ABORT;
			}
			if (rec->dialog_ret_code == DIALOG_RET_SKIP) return M_OK;
			return M_ABORT;
		}
/*#ifdef DEBUG
		printf("copyfile: copyed %d byte\n", CP_BUFSIZE);
#endif*/
		if (rec->UserInterrupt)
		{
#ifdef DEBUG
			printf("copyfile: interrupted by user\n");
#endif
			if (src != -1) close(src);
			if (dest != -1) close(dest);
			unlink(newpath);
#ifdef DEBUG
			printf("Copyfile: finish\n");
#endif
			return M_ABORT;
		}
	}


	if (src != -1) close(src);
	if (dest != -1) close(dest);
	
	tm_buf.actime = stats.st_atime;
	tm_buf.modtime = stats.st_mtime;
	utime(newpath, &tm_buf);
#ifdef DEBUG
	printf("Copyfile: finish\n");
#endif

	return M_OK;
}


static int movefile(struct _PreparingRec * rec, const char *oldpath, const char *newpath)
{
	struct stat stats;
	int src = -1, dest = -1, n;
	char buf[CP_BUFSIZE];
	XmString info;
	sem_t * sem;
	struct utimbuf tm_buf;
	
	sem = rec->sem;

#ifdef DEBUG
	printf("movefile: start %s -> %s\n", oldpath, newpath);
	sleep(1);
#endif

	if ((src = open(oldpath, O_RDONLY)) == -1 || stat(oldpath, &stats))
	{
		rec->ret_code = STATUS_NO_READABLE;
//		if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//		rec->ProgressDialogFound = False;
		WaitNoRead(rec, oldpath);
//		NoReadDialog(rec, oldpath);
//		sem_wait(sem);
		if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
		{
			rec->UserInterrupt = True;
			return M_ABORT;
		}
		if (rec->dialog_ret_code == DIALOG_RET_SKIP) return M_OK;
	}
	else 
		if ((dest = creat(newpath, stats.st_mode)) == -1)
		{
			rec->ret_code = STATUS_NO_WRITABLE;
			if (src != -1) close(src);
//			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//			rec->ProgressDialogFound = False;
			WaitNoWrite(rec, newpath);
//			NoWriteDialog(rec, newpath);
//			sem_wait(sem);
			if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
			{
				rec->UserInterrupt = True;
				return M_ABORT;
			}
			if (rec->dialog_ret_code == DIALOG_RET_SKIP) return M_OK;
	
		}

	if (rec->ProgressDialogFound == True)
	{ 
		info = XmStringCreateLocalized((char *) oldpath);
		if (rec->ProgressDialogFound)
		{
			XtVaSetValues(rec->ProgressDialog, XmNmessageString, (char *) info, NULL);
			XmUpdateDisplay(rec->ProgressDialog);
		}
		XmStringFree(info);
	}
/*	else
	{
		CopyMoveProgressDialogNew(rec, "bxfm: copy/move"); 
		rec->ProgressDialogFound = True;
		info = XmStringCreateLocalized(oldpath);
		XtVaSetValues(rec->ProgressDialog, XmNmessageString, info, NULL);
		XmStringFree(info);
		XmUpdateDisplay(rec->ProgressDialog);
		
	}*/

	while ( (n = read(src, buf, CP_BUFSIZE)) != 0)
	{
		if ( n == -1 || write(dest, buf, n) != n ) 
		{
			rec->ret_code = STATUS_UNKNOWN_ERROR;
#ifdef DEBUG
			printf("movefile: unknown error in copy data phase\n");
#endif
			if (src != -1) close(src);
			if (dest != -1) close(dest);
			unlink(newpath);
//			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//			rec->ProgressDialogFound = False;
			WaitUnknownError(rec, newpath);
//			UnknownErrorDialog(rec, newpath);
//			sem_wait(sem);
			if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
			{
				rec->UserInterrupt = True;
				return M_ABORT;
			}
			if (rec->dialog_ret_code == DIALOG_RET_SKIP) return M_OK;
			return M_ABORT;
		}
		if (rec->UserInterrupt)
		{
#ifdef DEBUG
			printf("movefile: interrupted by user\n");
#endif
			if (src != -1) close(src);
			if (dest != -1) close(dest);
			unlink(newpath);
#ifdef DEBUG
			printf("movefile: finish\n");
#endif
			return M_ABORT;
		}
	}


	if (src != -1) close(src);
	if (dest != -1) close(dest);
	
	tm_buf.actime = stats.st_atime;
	tm_buf.modtime = stats.st_mtime;
	utime(newpath, &tm_buf);
	unlink(oldpath);
#ifdef DEBUG
	printf("movefile: finish\n");
#endif

	return M_OK;
}



static int copy(struct _PreparingRec * rec, int n_inodes, const char *oldpath, const char *newpath)
{
	struct stat stats, stats2;
//	XmString info;
	sem_t * sem;
	char * newpath2;
	struct _FileListNode * list;
	char * new_message, * last_message, * full_message, * buf1, * buf2; 
	
/*	strcpy(err_source, oldpath);
	strcpy(err_target, newpath);*/
#ifdef DEBUG
	printf("Copy: start %s -> %s\n", oldpath, newpath);
#endif
	sem = rec->sem;
	list = rec->In;

	newpath2 = malloc(strlen(newpath) + 1);
	strcpy(newpath2, newpath);

	if (lstat(oldpath, &stats))
	{
#ifdef DEBUG
		printf("Copy: source file %s error\n", oldpath);
#endif
//		rec->ret_code = STATUS_NO_READABLE;
//		if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//		rec->ProgressDialogFound = False;
		WaitNoRead(rec, oldpath);
//		NoReadDialog(rec, oldpath);
//		sem_wait(sem);
		if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
		{
			rec->UserInterrupt = True;
			if (newpath2)
				free(newpath2);
			return M_ABORT;
		}
		if (rec->dialog_ret_code == DIALOG_RET_SKIP) return M_OK;
	}
	else 
//		if (!lstat(newpath, &stats2) && !S_ISDIR(stats2.st_mode))
		while (!lstat(newpath2, &stats2) && !S_ISDIR(stats2.st_mode))
		{
/********* Destination file found **********/
#ifdef DEBUG
			printf("Copy: dest file %s found error, mode = %d\n", newpath2, rec->mode);
#endif
			if (rec->OverwriteAllDstFile) goto unlink_phase;
			if (rec->SkipAllDstFile) 
			{
				if (newpath2)
					free(newpath2);

				return M_OK;
			}

			buf1 = get_human_readable_size(stats.st_size, NULL, 1);
			buf2 = get_human_readable_time(&(stats.st_mtime), NULL);
			
#ifdef DEBUG
			printf("Last size= %s\n", buf1);
			printf("Last time= %s\n", buf2);
#endif
			
			last_message = calloc(strlen(resdata.DialExistFileSourceString) + strlen(resdata.DialExistFileSizeString) + strlen(buf1)  +
									strlen(resdata.DialExistFileModTimeString) + strlen(buf2) + 10, sizeof(char));

			sprintf(last_message, "%s%s%s %s%s\n", resdata.DialExistFileSourceString, resdata.DialExistFileSizeString, buf1, resdata.DialExistFileModTimeString, buf2);
			
			if (buf1)
				free(buf1);

			if (buf2)
				free(buf2);

			buf1 = get_human_readable_size(stats2.st_size, NULL, 1);
			buf2 = get_human_readable_time(&(stats2.st_mtime), NULL);
			

#ifdef DEBUG
			printf("Last = %s\n", last_message);
#endif

			
			new_message = calloc(strlen(resdata.DialExistFileSourceString) + strlen(resdata.DialExistFileSizeString) + strlen(buf1)  +
									strlen(resdata.DialExistFileModTimeString) + strlen(buf2) + 10, sizeof(char));

			sprintf(new_message, "%s%s%s %s%s\n", resdata.DialExistFileExistString, resdata.DialExistFileSizeString, buf1, resdata.DialExistFileModTimeString, buf2);
			
#ifdef DEBUG
			printf("New = %s\n", new_message);
#endif

			if (buf1)
				free(buf1);

			if (buf2)
				free(buf2);

			full_message = calloc(strlen(newpath2) + strlen(last_message) + strlen(new_message) + 3, sizeof(char));
			sprintf(full_message, "%s\n%s%s", newpath2, last_message, new_message);

#ifdef DEBUG
			printf("Full = %s\n", full_message);
#endif


			if (last_message)
				free(last_message);

			if (new_message)
				free(new_message);

//			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//			rec->ProgressDialogFound = False;
			WaitDestinationFileFound(rec, full_message);
/*			WaitDestinationFileFound(rec, newpath2);*/
//			DestinationFileFoundDialog(rec, newpath2);
//			sem_wait(sem);
#ifdef DEBUG
			printf("copy sem \n");
#endif
			if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
			{
				rec->UserInterrupt = True;
				if (newpath2)
					free(newpath2);
				if (full_message)
					free(full_message);
				return M_ABORT;
			}
			if (rec->dialog_ret_code == DIALOG_RET_SKIP) 
			{
				if (newpath2)
					free(newpath2);
				if (full_message)
					free(full_message);
				return M_OK;
			}
			if (rec->dialog_ret_code == DIALOG_RET_SKIP_ALL)
			{
				rec->SkipAllDstFile = True;
				rec->OverwriteAllDstFile = False;
				if (newpath2)
					free(newpath2);
				if (full_message)
					free(full_message);
				return M_OK;
			}
			if (rec->dialog_ret_code == DIALOG_RET_OVERWRITE) goto unlink_phase;
			if (rec->dialog_ret_code == DIALOG_RET_OVERWRITE_ALL)
			{
				rec->OverwriteAllDstFile = True;
				rec->SkipAllDstFile = False;
			}	
			if (rec->OverwriteAllDstFile) 
			{
//				rec->ret_code = STATUS_FILE_FOUND;
//				if (rec->mode == MODE_OVERWRITE) rec->mode = MODE_NORMAL;
unlink_phase:	if (unlink(newpath2))
				{
#ifdef DEBUG
					printf("Copy: can not be removed dest file %s\n", newpath2);
#endif
//					if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//					rec->ProgressDialogFound = False;
					WaitNoRemove(rec, newpath2);
//					NoRemoveDialog(rec, newpath2);
//					sem_wait(sem);
					if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
					{
						rec->UserInterrupt = True;
						if (newpath2)
							free(newpath2);
						return M_ABORT;
					}
					if (rec->dialog_ret_code == DIALOG_RET_SKIP) 
					{
						if (newpath2)
							free(newpath2);
						return M_OK;
					}
				}
				else break;
			}
			if (rec->dialog_ret_code == DIALOG_RET_RENAME)
			{
				if (newpath2) free(newpath2);
				newpath2 = malloc(strlen(rec->filename) + 3 + strlen(list->ddir));
				sprintf(newpath2, "%s/%s", list->ddir, rec->filename);
//				newpath2 = rec->filename;
				rec->mode == MODE_NORMAL;
#ifdef DEBUG
				printf("Copy: copy to dest file with new name:%s\n", newpath2);
#endif
			}
		}

/* Regular file: copy block by block */
	if (S_ISREG(stats.st_mode))
	{
		int retcode;
		retcode = copyfile(rec, oldpath, newpath2);
		if (newpath2)
			free(newpath2);
		return retcode;
	}
		

/* Fifo: make a new one */
	else 
		if (S_ISFIFO(stats.st_mode))
		{
			int retcode;
			retcode = mkfifo(newpath2, stats.st_mode);
			if (newpath2)
				free(newpath2);
			return retcode;
		}
			

/* Device: make a new one */
		else 
			if (S_ISBLK(stats.st_mode) || S_ISCHR(stats.st_mode) || S_ISSOCK(stats.st_mode))
			{
				int retcode;
				retcode = mknod(newpath2, stats.st_mode, stats.st_rdev);
				if (newpath2)
					free(newpath2);
				return retcode;
			}

/* Symbolic link: make a new one */
			else 
				if (S_ISLNK(stats.st_mode)) 
				{
					static char lnk[MAXPATHLEN+1];
					int l = readlink(oldpath, lnk, MAXPATHLEN);

					if (l<0)
						return -1;
					lnk[l] = '\0';
					l = (symlink(lnk, newpath2));
					if (newpath2)
						free(newpath2);
					return l;
				}

/* This shouldn't happen */
				else 
				{
//					xplerr1(ERR_INVALID, (String) oldpath);
					rec->ret_code = STATUS_OK;
					if (newpath2)
						free(newpath2);
					return 0;
				}
}


static int move(struct _PreparingRec * rec, struct _FileListNode * list, const char *oldpath, const char *newpath)
{
	struct stat stats, stats2;
//	XmString info;
	sem_t * sem;
	char * newpath2;
	char * source_path;
	int len;
	int rename_possible = 0;
	dev_t old_dev, new_dev;
//	struct _FileListNode * list;
	
/*	strcpy(err_source, oldpath);
	strcpy(err_target, newpath);*/
#ifdef DEBUG
	printf("Move: start %s -> %s\n", oldpath, newpath);
#endif
	sem = rec->sem;
//	list = rec->In;

	newpath2 = malloc(strlen(newpath) + 1);
	strcpy(newpath2, newpath);

	len = FilenameFromPath((char *) oldpath) - oldpath;
	source_path = calloc(len + 2, sizeof(char));
	
	strncpy(source_path, oldpath, len - 1);
	
#ifdef DEBUG
	printf("move: source path -> %s\n", source_path);
#endif

/*** Check read and write permisson for source directory ***/

	if (lstat(source_path, &stats))
	{
#ifdef DEBUG
		printf("move: source directory %s error\n", source_path);
#endif
//		rec->ret_code = STATUS_NO_READABLE;
//		if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//		rec->ProgressDialogFound = False;
		WaitNoRead(rec, oldpath);
//		NoReadDialog(rec, oldpath);
//		sem_wait(sem);
		if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
		{
			rec->UserInterrupt = True;
			return M_ABORT;
		}
		if (rec->dialog_ret_code == DIALOG_RET_SKIP) 
		{
			if (source_path)
				free(source_path);
			if (newpath2)
				free(newpath2);
			return M_OK;
		}
		
	}
	else
	{
		if (!CheckReadPerm(&stats))
		{
#ifdef DEBUG
			printf("move: source directory %s not readable\n", source_path);
#endif
//			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//			rec->ProgressDialogFound = False;
			WaitNoRead(rec, oldpath);
//			NoReadDialog(rec, oldpath);
//			sem_wait(sem);
			if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
			{
				rec->UserInterrupt = True;
				return M_ABORT;
			}
			if (rec->dialog_ret_code == DIALOG_RET_SKIP) 
			{
				if (source_path)
					free(source_path);
				if (newpath2)
					free(newpath2);
				return M_OK;
			}
		}
		
		if (!CheckWritePerm(&stats))
		{
#ifdef DEBUG
			printf("move: source directory %s not writeble\n", source_path);
#endif
//			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//			rec->ProgressDialogFound = False;
			WaitNoRemove(rec, oldpath);
//			NoRemoveDialog(rec, (char *) oldpath);
//			sem_wait(sem);
			if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
			{
				rec->UserInterrupt = True;
				return M_ABORT;
			}
			if (rec->dialog_ret_code == DIALOG_RET_SKIP) 
			{
				if (source_path)
					free(source_path);
				if (newpath2)
					free(newpath2);
				return M_OK;
			}
		}
	}
	
	if (source_path)
		free(source_path);
		
#ifdef DEBUG
printf("Permissions for source dir ok: %s\n", source_path);
printf("Check permissions for destination dir ok: %s\n", list->ddir);
#endif		
/*** Check write permisson for source directory ***/
		
	if (lstat(list->ddir, &stats))
	{
#ifdef DEBUG
		printf("move: destination directory %s error\n", list->ddir);
#endif
//		rec->ret_code = STATUS_NO_READABLE;
//		if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//		rec->ProgressDialogFound = False;
		WaitNoRemove(rec, list->ddir);
//		NoRemoveDialog(rec, list->ddir);
//		sem_wait(sem);
		if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
		{
			rec->UserInterrupt = True;
			return M_ABORT;
		}
		if (rec->dialog_ret_code == DIALOG_RET_SKIP) 
		{
			if (newpath2)
				free(newpath2);
			return M_OK;
		}
		
	}
	else
	{
		new_dev = stats.st_dev;
		
		if (!CheckWritePerm(&stats))
		{
#ifdef DEBUG
			printf("move: destination directory %s not writeble\n", list->ddir);
#endif
//			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//			rec->ProgressDialogFound = False;
			WaitNoRemove(rec, list->ddir);
//			NoRemoveDialog(rec, list->ddir);
//			sem_wait(sem);
			if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
			{
				rec->UserInterrupt = True;
				return M_ABORT;
			}
			if (rec->dialog_ret_code == DIALOG_RET_SKIP) 
			{
				if (newpath2)
					free(newpath2);
				return M_OK;
			}
		}
	}

#ifdef DEBUG
printf("Permissions for destination dir ok: %s\n", list->ddir);
#endif
	if (lstat(oldpath, &stats))
	{
#ifdef DEBUG
		printf("move: source file %s error\n", oldpath);
#endif
//		rec->ret_code = STATUS_NO_READABLE;
//		if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//		rec->ProgressDialogFound = False;
		WaitNoRead(rec, oldpath);
//		NoReadDialog(rec, oldpath);
//		sem_wait(sem);
		if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
		{
			rec->UserInterrupt = True;
			return M_ABORT;
		}
		if (rec->dialog_ret_code == DIALOG_RET_SKIP) return M_OK;
	}
	else 
//		if (!lstat(newpath, &stats2) && !S_ISDIR(stats2.st_mode))
		while (!lstat(newpath2, &stats2) && !S_ISDIR(stats2.st_mode))
		{
/********* Destination file found **********/
#ifdef DEBUG
			printf("move: dest file %s found error, mode = %d\n", newpath2, rec->mode);
#endif
			if (rec->OverwriteAllDstFile) goto unlink_phase;
			if (rec->SkipAllDstFile) return M_OK;

//			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//			rec->ProgressDialogFound = False;
			WaitDestinationFileFound(rec, newpath2);
//			DestinationFileFoundDialog(rec, newpath2);
//			sem_wait(sem);
#ifdef DEBUG
			printf("move sem \n");
#endif
			if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
			{
				rec->UserInterrupt = True;
				return M_ABORT;
			}
			if (rec->dialog_ret_code == DIALOG_RET_SKIP) return M_OK;
			if (rec->dialog_ret_code == DIALOG_RET_SKIP_ALL)
			{
				rec->SkipAllDstFile = True;
				rec->OverwriteAllDstFile = False;
				return M_OK;
			}
			if (rec->dialog_ret_code == DIALOG_RET_OVERWRITE) goto unlink_phase;
			if (rec->dialog_ret_code == DIALOG_RET_OVERWRITE_ALL)
			{
				rec->OverwriteAllDstFile = True;
				rec->SkipAllDstFile = False;
			}	
			if (rec->OverwriteAllDstFile) 
			{
//				rec->ret_code = STATUS_FILE_FOUND;
//				if (rec->mode == MODE_OVERWRITE) rec->mode = MODE_NORMAL;
unlink_phase:	if (unlink(newpath2))
				{
#ifdef DEBUG
					printf("move: can not be removed dest file %s\n", newpath2);
#endif
//					if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//					rec->ProgressDialogFound = False;
					WaitNoRemove(rec, newpath2);
//					NoRemoveDialog(rec, newpath2);
//					sem_wait(sem);
					if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
					{
						rec->UserInterrupt = True;
						return M_ABORT;
					}
					if (rec->dialog_ret_code == DIALOG_RET_SKIP) return M_OK;
				}
				else break;
			}
			if (rec->dialog_ret_code == DIALOG_RET_RENAME)
			{
				if (newpath2) free(newpath2);
				newpath2 = malloc(strlen(rec->filename) + 3 + strlen(list->ddir));
				sprintf(newpath2, "%s/%s", list->ddir, rec->filename);
//				newpath2 = rec->filename;
				rec->mode == MODE_NORMAL;
#ifdef DEBUG
				printf("move: copy to dest file with new name:%s\n", newpath2);
#endif
			}
		}



	old_dev = stats.st_dev;
	
	if (old_dev == new_dev)
	{
#ifdef DEBUG
		printf("Next rename %s\n", oldpath);
#endif
		len = rename(oldpath, newpath2);
		if (newpath2)
			free(newpath2);
		return len;
//		return 0;
	}


#ifdef DEBUG
printf("Next movefile\n");
#endif

/* Regular file: copy block by block */
	if (S_ISREG(stats.st_mode))
		return movefile(rec, oldpath, newpath2);

/* Fifo: make a new one */
	else 
		if (S_ISFIFO(stats.st_mode))
//			return mkfifo(newpath2, stats.st_mode);
		{
			if (newpath2)
				free(newpath2);
			return 0;
		}

/* Device: make a new one */
		else 
			if (S_ISBLK(stats.st_mode) || S_ISCHR(stats.st_mode) || S_ISSOCK(stats.st_mode))
//				return mknod(newpath2, stats.st_mode, stats.st_rdev);
			{
				if (newpath2)
					free(newpath2);
				return 0;
			}

/* Symbolic link: make a new one */
			else 
				if (S_ISLNK(stats.st_mode)) 
				{
					static char lnk[MAXPATHLEN+1];
					int l = readlink(oldpath, lnk, MAXPATHLEN);

					if (l<0)
					{
						if (newpath2)
							free(newpath2);
						return -1;
					}
					lnk[l] = '\0';
					l = symlink(lnk, newpath2);
					if (l == 0)
						unlink(oldpath);
					if (newpath2)
						free(newpath2);
					return l;
				}

/* This shouldn't happen */
				else 
				{
//					xplerr1(ERR_INVALID, (String) oldpath);
					rec->ret_code = STATUS_OK;
					if (newpath2)
						free(newpath2);
					return 0;
				}
}



void *DeleteThread(void * arg)
{
	struct _PreparingRec * rec;
	int ret_code;

	struct stat source_buf;
	struct _FileListNode * list, * ptr;
	sem_t * sem;
	pthread_mutex_t * mutex;

	
	rec = (struct _PreparingRec *) arg;
	sem = rec->sem;
	mutex = rec->mutex;

	list = rec->In;

	while(1)
	{
		if (rec->UserInterrupt) break;

		if (list)
		{
			rec->full_source_path = malloc(strlen(list->fname) + 1);
			strcpy(rec->full_source_path, list->fname);
				
				rec->filename = malloc(strlen(FilenameFromPath(list->fname)) + 3);
				strcpy(rec->filename, FilenameFromPath(list->fname));
				
#ifdef DEBUG
			printf("DeleteThread: full name: %s\n", rec->full_source_path);
			printf("DeleteThread: short name: %s\n", rec->filename);
#endif

			rec->state = CM_STATE_PROCESSING;
		}
		else
		{
#ifdef DEBUG
			printf("DeleteThread:  files list empty \n");
#endif
			break;
		}
		


		if ((lstat(rec->full_source_path, &source_buf)) == 0)
		{
			if(S_ISDIR(source_buf.st_mode))
			{
#ifdef DEBUG
				printf("DeleteThread:  %s is dir \n", rec->full_source_path);
#endif
				ret_code = rdel(rec->full_source_path); 
				if (ret_code == 0) 
				{
#ifdef DEBUG
					printf("DeleteThread:  dir %s deleted\n", rec->full_source_path);
#endif				
					goto next;
				}
				else
				{
#ifdef DEBUG
					printf("DeleteThread:  error deleting dir %s\n", rec->full_source_path);
#endif				

//					if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//					rec->ProgressDialogFound = False;
#ifdef DEBUG
					printf("DeleteThread: progress dialog destroyed \n");
#endif
					WaitDeleteDirError(rec, rec->full_source_path);
//					DeleteDirErrorDialog(rec, rec->full_source_path);
//					sem_wait(sem);

					if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
					{
						rec->UserInterrupt = True;
						goto interrupt;
					}
					if (rec->dialog_ret_code == DIALOG_RET_SKIP) goto next;
				}
			}
		}
		else
		{
/***!!!!!!!!!!!!!!!*****/
#ifdef DEBUG
			printf("CopyMoveThread:  dir %s error\n", rec->full_source_path);
#endif				
		}

/********Delete file**************/

		ret_code = unlink(rec->full_source_path);

		if (ret_code == 0) 
		{
#ifdef DEBUG
			printf("DeleteThread:  file %s deleted\n", rec->full_source_path);
#endif				
			goto next;
		}
		else
		{
#ifdef DEBUG
			printf("DeleteThread:  error deleting file %s\n", rec->full_source_path);
#endif				

//			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//			rec->ProgressDialogFound = False;
#ifdef DEBUG
			printf("DeleteThread: progress dialog destroyed \n");
#endif
			WaitDeleteFileError(rec, rec->full_source_path);
//			DeleteFileErrorDialog(rec, rec->full_source_path);
//			sem_wait(sem);

			if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
			{
				rec->UserInterrupt = True;
				goto interrupt;
			}
			if (rec->dialog_ret_code == DIALOG_RET_SKIP) goto next;
		}




		
		
next:	if (rec->filename) 
		{
			free((void *)rec->filename);
			rec->filename = NULL;
		}
		if (rec->full_dest_path) 
		{
			free(rec->full_dest_path);
			rec->full_dest_path = NULL;
		}
		if (rec->full_source_path) 
		{
			free(rec->full_source_path);
			rec->full_source_path = NULL;
		}

		
		ptr = rec->In;
		list = ptr->next;
		free(ptr->fname);
		free(ptr->ddir);
		free(ptr);
		rec->In = list;

#ifdef DEBUG
printf("Next ok\n");
		sleep(1);
#endif
	}
	
interrupt:	
#ifdef DEBUG
	printf("DeleteThread:  cleaning memory\n");
#endif
	rec->OpsCompleted = True;
//	pthread_mutex_unlock(mutex);
//	CleanCMData(rec);
	return NULL;
}

/*
int nftw_callback(const char *fpath, const struct stat *sb, int typeflag, struct FTW *ftwbuf)
{
	int res;
	int index;
	char *destpath;
	char *destname;
	int l1, l2;
	int pos1, pos2;
	struct stat dstsb;
	
	struct _PreparingRec * rec;

	for (index = 0; index < MAX_CHECK_MOVE_THRED; index++)
	{
		if (pthread_equal(CheckMoveArr[index].task_thread_id, pthread_self()) != 0)
		{
			rec = CheckMoveArr[index].prec;
			break;
		}
	}




	if (strlen(rec->full_source_path) == strlen(fpath))
	{
		destpath = calloc(strlen(rec->dstdir) + 3, sizeof(char));
		strcpy(destpath, rec->dstdir);

		destname = calloc(strlen(rec->full_dest_path) + strlen(fpath) + 3, sizeof(char));

		strcpy(destname, destpath);

		strcat(destname, "/");

		strncat(destname, fpath + ftwbuf->base, strlen(fpath) - ftwbuf->base);
	}
	else
		if (ftwbuf->level == 1)
		{
			destpath = calloc(strlen(rec->full_dest_path) + strlen(fpath) + 3, sizeof(char));
			strcpy(destpath, rec->full_dest_path);
			


			destname = calloc(strlen(destpath) + strlen(fpath) + 3, sizeof(char));

			strcpy(destname, destpath);

			strcat(destname, "/");

			strncat(destname, fpath + ftwbuf->base, strlen(fpath) - ftwbuf->base);
		}
		else
		{
			destpath = calloc(strlen(rec->full_dest_path) + strlen(fpath) + 3, sizeof(char));
			strcpy(destpath, rec->full_dest_path);

				
			strncat(destpath, fpath + strlen(rec->full_source_path), ftwbuf->base - strlen(rec->full_source_path) - 1);

			destname = calloc(strlen(destpath) + strlen(fpath) + 3, sizeof(char));

			strcpy(destname, destpath);

			strcat(destname, "/");

			strncat(destname, fpath + ftwbuf->base, strlen(fpath) - ftwbuf->base);
		}


	printf("-------------- base %d fpath %d level %d source %d\n", ftwbuf->base, strlen(fpath), ftwbuf->level, strlen(rec->full_source_path));
	printf("Full Dest path: %s\n", rec->full_dest_path);
	printf("Dest path: %s\n", destpath);
	printf("Dest name: %s\n", destname);
	res = CheckReadPerm(sb);
	if (res)
		printf("++Source item %s ready to read\n", fpath);
	else
	{
		rec->no_read_items++;
		printf("--Source item %s not ready to read\n", fpath);
	}
	
	res = CheckWritePerm(sb);
	if (res)
		printf("++Source item %s ready to moved\n", fpath);
	else
	{
		rec->no_write_items++;
		printf("--Source item %s not ready to moved\n", fpath);
	}


	if ((lstat(destpath, &dstsb)) == 0)
	{
		if (S_ISDIR(dstsb.st_mode))
		{
			if (!CheckWritePerm(&dstsb))
			{
				printf("--Destination dir found and not writable %s\n", destpath);
				rec->dest_found_nowrite++;
			}
		}
		else
		{
			printf("--Found destination file with name of source directory %s\n", destpath);
			rec->dest_found++;
		}
	}

	if ((lstat(destname, &dstsb)) == 0)
	{
		if (S_ISDIR(dstsb.st_mode))
		{
			if (!S_ISDIR(sb->st_mode))
			{
				printf("Found destination dir with name of source file %s\n", destname);
				rec->dest_found++;
			}
		}
		else	
			if (!CheckWritePerm(&dstsb))
			{
				printf("--Destination file found and not writable %s\n", destname);
				rec->dest_found_nowrite++;
			}
	}

	
	free(destpath);
	free(destname);
	
	return 0;
}


*/



int RecursiveMove(struct _PreparingRec * rec, struct _FileListNode * ptr)
{
//	struct _PreparingRec * rec;
	int ret_code;
	IfaceBranche * IbPtr;
	struct stat source_buf;
	struct _FileListNode * list, * ptr2, * ptr3;
	sem_t * sem;
	pthread_mutex_t * mutex;
	int ftdir;
	int flags = 0;
	int index;
	char * tmp_string;
	DIR *dir;
	struct dirent *entry;
	
	
//	rec = (struct _PreparingRec *) arg;
	IbPtr = (IfaceBranche *) rec->IbPtr;
	sem = rec->sem;
	mutex = rec->mutex;

#ifdef DEBUG
printf("***** Enter to recursive moving ***\n");
#endif

	list = ptr;
	
	while (list)
	{
		if (rec->UserInterrupt) 
			goto interrupt;

		if (list)
		{
			rec->command = list->command;

			rec->full_source_path = malloc(strlen(list->fname) + 1);
			strcpy(rec->full_source_path, list->fname);
				
			rec->filename = malloc(strlen(FilenameFromPath(list->fname)) + 3);
			strcpy(rec->filename, FilenameFromPath(list->fname));

			rec->full_dest_path = malloc(strlen(rec->filename) + 3 + strlen(list->ddir));
			sprintf(rec->full_dest_path, "%s/%s", list->ddir, rec->filename);

			if (rec->mode == MODE_RENAME) rec->mode = MODE_NORMAL;
				
#ifdef DEBUG
			printf("MoveThread recursive: src: %s\n", rec->full_source_path);
			printf("MoveThread recursive: dst: %s\n", rec->full_dest_path);
			printf("MoveThread recursive: dstname: %s\n", rec->filename);
			printf("MoveThread recursive: command: %d\n", rec->command);
#endif

			rec->state = CM_STATE_PROCESSING;
		}
		else
		{
#ifdef DEBUG
			printf("MoveThread recursive:  files list empty \n");
#endif
//			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog); 
//			rec->ProgressDialogFound = False;
			break;
		}

		if ((lstat(rec->full_source_path, &source_buf)) == 0)
		{
			if(S_ISDIR(source_buf.st_mode))
			{
#ifdef DEBUG
				printf("MoveThread recursive:  %s is dir \n", rec->full_source_path);
#endif
				ret_code = preparedir_move(rec, &list, &source_buf, rec->full_source_path, rec->full_dest_path); 
				switch (ret_code) 
				{
				case M_OK:
#ifdef DEBUG
					printf("MoveThread recursive:  dir %s preparing\n", rec->full_source_path);
#endif				
//					goto next;
					continue ;
				case M_ABORT:

					if (rec->ret_code == STATUS_NO_READABLE)
					{
//						if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//						rec->ProgressDialogFound = False;
						WaitNoRead(rec, rec->full_source_path);
//						NoReadDialog(rec, rec->full_source_path);
//						sem_wait(sem);
						if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
						{
							rec->UserInterrupt = True;
							goto interrupt;
						}
						if (rec->dialog_ret_code == DIALOG_RET_SKIP) 
						{
							rec->ret_code = STATUS_OK;
							goto next;
						}
					}

					if (rec->ret_code == STATUS_NO_WRITABLE)
					{
//						if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//						rec->ProgressDialogFound = False;
						WaitNoWrite(rec, rec->full_dest_path);
//						NoWriteDialog(rec, rec->full_dest_path);
//						sem_wait(sem);
						if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
						{
							rec->UserInterrupt = True;
							goto interrupt;
						}
						if (rec->dialog_ret_code == DIALOG_RET_SKIP) 
						{
							rec->ret_code = STATUS_OK;
							goto next;
						}
					}

#ifdef DEBUG
					printf("MoveThread recursive:  aborted\n");
#endif				
					goto interrupt;
				}
			}
		}
		else
		{
/***!!!!!!!!!!!!!!!*****/
#ifdef DEBUG
			printf("MoveThread recursive:  dir %s error\n", rec->full_source_path);
#endif				
		}

/********Copy or move**************/

		ret_code = move(rec, list, rec->full_source_path, rec->full_dest_path);

		switch (ret_code) 
		{
		case M_OK:
#ifdef DEBUG
			printf("MoveThread recursive:  file %s processed\n", rec->full_source_path);
#endif				
			goto next;
		case M_ABORT:
#ifdef DEBUG
			printf("MoveThread recursive:  aborted\n");
#endif				
			goto interrupt;
		}

		
		
next:	if (rec->filename) 
		{
			free((void *)rec->filename);
			rec->filename = NULL;
		}
		if (rec->full_dest_path) 
		{
			free(rec->full_dest_path);
			rec->full_dest_path = NULL;
		}
		if (rec->full_source_path) 
		{
			free(rec->full_source_path);
			rec->full_source_path = NULL;
		}

		
		ptr2 = list;
		list = ptr2->next;
		free(ptr2->fname);
		free(ptr2->ddir);
		free(ptr2);

#ifdef DEBUG
printf(" recursive: Next ok\n");
		sleep(1);
#endif
		
	}

#ifdef DEBUG
	printf("*****************\nList of directory for deleting\n");
	ptr2 = rec->OutMove;
	while(ptr2)
	{
		printf("\t%s\n", ptr2->fname);
		ptr2 = ptr2->next;
	}
#endif

	ptr2 = rec->OutMove;
	while(ptr2)
	{
		rmdir(ptr2->fname);
		ptr2 = ptr2->next;
	}


	return M_OK;

interrupt:
	CleanMDataList(list);
	return M_ABORT;

}

void * MoveThread(void * arg)
{
	struct _PreparingRec * rec;
	int ret_code;
	IfaceBranche * IbPtr;
	struct stat source_buf;
	struct _FileListNode * list, * ptr;
	sem_t * sem;
	pthread_mutex_t * mutex;
	int ftdir;
	int flags = 0;
	int index;
	char * tmp_string;
	dev_t old_dev, new_dev;
	
	
	rec = (struct _PreparingRec *) arg;
	IbPtr = (IfaceBranche *) rec->IbPtr;
	sem = rec->sem;
	mutex = rec->mutex;

	list = rec->In;

	flags |= FTW_PHYS;

/******************************************************/
/** Check write permission for destination directory **/
/******************************************************/

	if (lstat(rec->dstdir, &source_buf) != 0)
	{
#ifdef DEBUG
		printf("Destination dir %s not ready to get moved data\n", rec->dstdir);
#endif
//		if (rec->ProgressDialogFound)
//		{
//			rec->ProgressDialogFound = 0;
//			XtDestroyWidget(rec->ProgressDialog);
//		}
//		NoCanDo(OPERATION_FAILED, IbPtr);
//		rec->ControlDialogFound = 1;
		WaitUnknownError(rec, rec->dstdir);
		rec->OpsCompleted = True;
		return NULL;
	}
	ret_code = CheckWritePerm(&source_buf);
	if (ret_code)
		printf("Destination dir %s ready to get moved data\n", rec->dstdir);
	else
	{
		printf("Destination dir %s is not writable\n", rec->dstdir);
//		if (rec->ProgressDialogFound)
//		{
//			rec->ProgressDialogFound = 0;
//			XtDestroyWidget(rec->ProgressDialog);
//		}
//		NoCanDo(OPERATION_FAILED, IbPtr);
//		rec->ControlDialogFound = 1;
		WaitNoCanDo(rec, rec->dstdir);
		rec->OpsCompleted = True;
		return NULL;
	}
/******************************************************/


	while(1)
	{
		if (rec->UserInterrupt) 
			break;

		if (!list)
		{
#ifdef DEBUG
			printf("CopyMoveThread:  files list empty \n");
#endif
			break;
		}

		rec->command = list->command;
		rec->full_source_path = malloc(strlen(list->fname) + 1);
		strcpy(rec->full_source_path, list->fname);
				
		rec->filename = malloc(strlen(FilenameFromPath(list->fname)) + 3);
		strcpy(rec->filename, FilenameFromPath(list->fname));
		rec->full_dest_path = malloc(strlen(rec->filename) + 3 + strlen(list->ddir));
		sprintf(rec->full_dest_path, "%s/%s", list->ddir, rec->filename);
		if (rec->mode == MODE_RENAME) rec->mode = MODE_NORMAL;
				
#ifdef DEBUG
		printf("CopyMoveThread: src: %s\n", rec->full_source_path);
		printf("CopyMoveThread: dst: %s\n", rec->full_dest_path);
		printf("CopyMoveThread: dstname: %s\n", rec->filename);
		printf("CopyMoveThread: command: %d\n", rec->command);
#endif

		rec->state = CM_STATE_PROCESSING;
		
		if ((lstat(rec->full_source_path, &source_buf)) == 0)
		{
#ifdef DEBUG
			printf("Source path found: %s\n", rec->full_source_path);
#endif
			old_dev = source_buf.st_dev;
			
			if (S_ISDIR(source_buf.st_mode))
			{
#ifdef DEBUG
				printf("Source path is dir\n");
				printf("!!!! Go to recursive moving\n");
#endif						

				if (rec->filename) 
				{
					free((void *)rec->filename);
					rec->filename = NULL;
				}
				if (rec->full_dest_path) 
				{
					free(rec->full_dest_path);
					rec->full_dest_path = NULL;
				}
				if (rec->full_source_path) 
				{
					free(rec->full_source_path);
					rec->full_source_path = NULL;
				}

					
				ptr = rec->In;
				list = ptr->next;
				rec->In = list;
				ptr->next = NULL;
				RecursiveMove(rec, ptr);
				continue ;
			}
		}
		else
		{
			printf("--Cant get properties for source %s\n", rec->full_source_path);
		}

		if ((lstat(list->ddir, &source_buf)) == 0)
		{
			new_dev = source_buf.st_dev;
		}
		else
		{
			printf("--Cant get properties for source %s\n", rec->full_source_path);
		}

		if (old_dev == new_dev)
		{
			int res;
#ifdef DEBUG
			printf("MoveThread: next rename %s\n", rec->full_source_path);
#endif
			res = rename(rec->full_source_path, rec->full_dest_path);
		}
		else
		{
			move(rec, list, rec->full_source_path, rec->full_dest_path);
		}

next_mv_thread:
		if (rec->filename) 
		{
			free((void *)rec->filename);
			rec->filename = NULL;
		}
		if (rec->full_dest_path) 
		{
			free(rec->full_dest_path);
			rec->full_dest_path = NULL;
		}
		if (rec->full_source_path) 
		{
			free(rec->full_source_path);
			rec->full_source_path = NULL;
		}

		
		ptr = rec->In;
		list = ptr->next;
		free(ptr->fname);
		free(ptr->ddir);
		free(ptr);
		rec->In = list;
	}

interrupt_mv_thread:	
#ifdef DEBUG
	printf("MoveThread:  comleted\n");
#endif

	rec->OpsCompleted = True;
	return NULL;
}


void *CopyThread(void * arg)
{
	struct _PreparingRec * rec;
	int ret_code;
	IfaceBranche * IbPtr;
	struct stat source_buf;
	struct _FileListNode * list, * ptr;
	sem_t * sem;
//	char string[200];
//	XmString info;;
	pthread_mutex_t * mutex;
//	int n = 1;

	
	rec = (struct _PreparingRec *) arg;
	IbPtr = (IfaceBranche *) rec->IbPtr;
	sem = rec->sem;
	mutex = rec->mutex;

	list = rec->In;

	while(1)
	{
		if (rec->UserInterrupt) 
			break;

		if (list)
		{
			rec->command = list->command;
			rec->full_source_path = malloc(strlen(list->fname) + 1);
			strcpy(rec->full_source_path, list->fname);
				
/*			if (rec->mode != MODE_RENAME)
			{*/
				rec->filename = malloc(strlen(FilenameFromPath(list->fname)) + 3);
				strcpy(rec->filename, FilenameFromPath(list->fname));
/*			}*/

//			rec->full_dest_path = malloc(strlen(rec->filename) + 3 + strlen(rec->dstdir));
			rec->full_dest_path = malloc(strlen(rec->filename) + 3 + strlen(list->ddir));
//			sprintf(rec->full_dest_path, "%s/%s", rec->dstdir, rec->filename);
			sprintf(rec->full_dest_path, "%s/%s", list->ddir, rec->filename);
			if (rec->mode == MODE_RENAME) rec->mode = MODE_NORMAL;
				
#ifdef DEBUG
			printf("CopyMoveThread: src: %s\n", rec->full_source_path);
			printf("CopyMoveThread: dst: %s\n", rec->full_dest_path);
			printf("CopyMoveThread: dstname: %s\n", rec->filename);
			printf("CopyMoveThread: command: %d\n", rec->command);
#endif

			rec->state = CM_STATE_PROCESSING;
/*			if (rec->DialogFound == True)
			{ 
				info = XmStringCreateLocalized(list->fname);
				XtVaSetValues(rec->dialog, XmNmessageString, info, NULL);
				XmStringFree(info);
				XmUpdateDisplay(rec->dialog);
			}*/
		}
		else
		{
#ifdef DEBUG
			printf("CopyMoveThread:  files list empty \n");
#endif
//			if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog); 
//			rec->ProgressDialogFound = False;
			break;
		}

		if ((lstat(rec->full_source_path, &source_buf)) == 0)
		{
			if(S_ISDIR(source_buf.st_mode))
			{
#ifdef DEBUG
				printf("CopyMoveThread:  %s is dir \n", rec->full_source_path);
#endif
				ret_code = preparedir(rec, &source_buf, rec->full_source_path, rec->full_dest_path); 
				switch (ret_code) 
				{
				case M_OK:
#ifdef DEBUG
					printf("CopyMoveThread:  dir %s preparing\n", rec->full_source_path);
#endif				
					goto next;
				case M_ABORT:

					if (rec->ret_code == STATUS_NO_READABLE)
					{
//						if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//						rec->ProgressDialogFound = False;
						WaitNoRead(rec, rec->full_source_path);
//						NoReadDialog(rec, rec->full_source_path);
//						sem_wait(sem);
						if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
						{
							rec->UserInterrupt = True;
							goto interrupt;
						}
						if (rec->dialog_ret_code == DIALOG_RET_SKIP) 
						{
							rec->ret_code = STATUS_OK;
							goto next;
						}
					}

					if (rec->ret_code == STATUS_NO_WRITABLE)
					{
//						if (rec->ProgressDialogFound) XtDestroyWidget(rec->ProgressDialog);
//						rec->ProgressDialogFound = False;
						WaitNoWrite(rec, rec->full_dest_path);
//						NoWriteDialog(rec, rec->full_dest_path);
//						sem_wait(sem);
						if (rec->dialog_ret_code == DIALOG_RET_CANCEL) 
						{
							rec->UserInterrupt = True;
							goto interrupt;
						}
						if (rec->dialog_ret_code == DIALOG_RET_SKIP) 
						{
							rec->ret_code = STATUS_OK;
							goto next;
						}
					}

#ifdef DEBUG
					printf("CopyMoveThread:  aborted\n");
#endif				
					goto interrupt;
				}
			}
		}
		else
		{
/***!!!!!!!!!!!!!!!*****/
#ifdef DEBUG
			printf("CopyMoveThread:  dir %s error\n", rec->full_source_path);
#endif				
		}

/********Copy or move**************/

		ret_code = copy(rec, 0, rec->full_source_path, rec->full_dest_path);

		switch (ret_code) 
		{
		case M_OK:
#ifdef DEBUG
			printf("CopyMoveThread:  file %s processed\n", rec->full_source_path);
#endif				
			goto next;
		case M_ABORT:
#ifdef DEBUG
			printf("CopyMoveThread:  aborted\n");
#endif				
			goto interrupt;
		}

		
		
next:	if (rec->filename) 
		{
			free((void *)rec->filename);
			rec->filename = NULL;
		}
		if (rec->full_dest_path) 
		{
			free(rec->full_dest_path);
			rec->full_dest_path = NULL;
		}
		if (rec->full_source_path) 
		{
			free(rec->full_source_path);
			rec->full_source_path = NULL;
		}

		
		ptr = rec->In;
		list = ptr->next;
		free(ptr->fname);
		free(ptr->ddir);
		free(ptr);
		rec->In = list;

#ifdef DEBUG
printf("Next ok\n");
		sleep(1);
#endif
	}
	
interrupt:	
#ifdef DEBUG
	printf("CopyMoveThread:  comleted\n");
#endif
	rec->OpsCompleted = True;
//	pthread_mutex_unlock(mutex);
//	CleanCMData(rec);
	return NULL;
}








/* CopyMove action. */
void CopyMoveAction(struct _FileListNode * FirstFileNode, IfaceBranche * IbPtr, char * DestinationPath) 
{
	pthread_mutex_t * mutex;
	sem_t * sem;
	pthread_t thread_id;
	void ** fps;
	int i;

	struct _PreparingRec * prep;

	if (!FirstFileNode)
		return;

#ifdef DEBUG
	printf("Current work directory:  %s\n", IbPtr->current_wd);
	struct _FileListNode * CurrentFileNode = FirstFileNode;
	while (CurrentFileNode)
	{
//		printf("Command = %d src = %s dst = %s\n", CurrentFileNode->command, CurrentFileNode->fname, current_wd);
		printf("CopyMoveAction: %d %s\n", CurrentFileNode->command, CurrentFileNode->fname);
		CurrentFileNode = CurrentFileNode->next;
	}
#endif

	prep = (struct _PreparingRec * ) malloc(sizeof(struct _PreparingRec));
	prep->In = FirstFileNode;
	prep->OutMove = NULL;
	prep->Out = NULL;
/*	prep->dstdir = (char *)malloc(strlen(IbPtr->current_wd)+1);
	strcpy(prep->dstdir, IbPtr->current_wd);*/
	prep->dstdir = DestinationPath;

#ifdef DEBUG
	printf("Current work directory:  %s\n", prep->dstdir);
#endif

	prep->IbPtr = IbPtr;
	prep->ret_code = STATUS_OK;
	prep->ready = 0;
//	prep->state = CM_STATE_START;
	prep->state = CM_STATE_PROCESSING;
	prep->mode = MODE_NORMAL;
	prep->UserInterrupt = False;

	prep->fops_type = FOPS_IS_COPY_MOVE;
	prep->wait_user_action = 0;

	prep->filename = NULL;
	prep->full_dest_path = NULL;
	prep->full_source_path = NULL;


	prep->OverwriteAllDstDir = False;
	prep->OverwriteAllDstFile = False;
	prep->SkipAllDstDir = False;
	prep->SkipAllDstFile = False;
	prep->SkipAllSrcDir = False;
	prep->SkipAllSrcFile = False;
	
	prep->ProgressDialogFound = False;
	prep->ControlDialogFound = False;
	prep->OpsCompleted = False;


	mutex = malloc(sizeof(pthread_mutex_t));
	pthread_mutex_init(mutex, NULL);

	sem = malloc(sizeof(sem_t));
	sem_init(sem, 0, 0);

	prep->sem = sem;
	prep->mutex = mutex;
	
	prep->no_read_items = 0;
	prep->no_write_items = 0;
	prep->dest_no_write_items = 0;
	prep->ex_dev = 0;
	prep->dest_found = 0;
	prep->dest_found_nowrite = 0;

//	pthread_create(&thread_id, NULL, CopyMoveThread, (void *) prep);

//	CopyMoveProgressDialogNew(prep, "bxfm: copy/move"); 



	if (IbPtr->fops_allocated < (IbPtr->copy_move_thread_count + 1))
	{
		fps = calloc(IbPtr->fops_allocated + 5, sizeof (void *));
		if (fps)
		{
			if (IbPtr->fops)
			{
				memmove(fps, IbPtr->fops, sizeof(void *) * IbPtr->fops_allocated);
				free(IbPtr->fops);
			}
			IbPtr->fops = fps;
			IbPtr->fops_allocated += 5;
		}
	}
	
	for (i = 0; i < IbPtr->fops_allocated; i++)
	{
		if (IbPtr->fops[i] == NULL)
			break ;
	}


#ifdef DEBUG
printf("Past i = %d fops = %p\n", i, IbPtr->fops);
#endif

	if (i >= IbPtr->fops_allocated || !IbPtr->fops)
	{
		CleanCMData(prep);
		return ;
	}

#ifdef DEBUG
printf("Next ++\n");
#endif

	IbPtr->copy_move_thread_count++;
	IbPtr->fops[i] = (void *) prep;

 
	if (FirstFileNode->command == COPY_ACTION)
		pthread_create(&thread_id, NULL, CopyThread, (void *) prep);
	else
		pthread_create(&thread_id, NULL, MoveThread, (void *) prep);

	prep->task_thread_id = thread_id;
	

#ifdef DEBUG
printf("Added copy thread\n");
#endif

//	CopyMoveThreadNew((void *) prep);
//	prep->WorkProcFound = True;
//	prep->WorkProc = XtAppAddWorkProc(app, CopyMoveWorkProcedure, (XtPointer) prep);

//	XtAppAddTimeOut(IbPtr->app, 500, CopyMoveWorkProcedure, (XtPointer) prep);

	return ;
}




char * uri_decode(const char * string)
{
	char one_byte;


	int i, k;
	size_t length;
	char *out;

	length = strlen(string);
	k=0;
	i=0;
#ifdef DEBUG
	printf("length = %d\n", length);
	fflush(stdout);
#endif
	out = malloc(1000);
	while (i<strlen(string))
	{
		if (string[i] == '\r')
		{
			i++;
			continue;
		}
		if (string[i] == '\%')
		{
			sscanf(&(string[i+1]), "%2hhx", &one_byte);
//			if (k >= length) out = (char *) realloc((void *) out, length+=20);
			out[k] = one_byte;
			i+=2;

		}
		else
		{
//			if (k >= length) out = (char *) realloc((void *) out, length+=20);
			out[k]=string[i];
		}
		i++;
		k++;
		if (k >= length) out = (char *) realloc((void *) out, length+=20);
	}
	out[k]='\0';
#ifdef DEBUG
	printf("Decoded uri:%s\n", out);
#endif
	return out;
}




void PasteAction(char * fnames, IfaceBranche * IbPtr, char * DestinationPath)
{
	char * ptr, * ptr2, * buf;
	int command = 0;
	
	struct _FileListNode * FirstNode = NULL, * CurrentNode = NULL;
	
	int name_num = 0;

	
	ptr = strchr(fnames, '\n');
	if (!ptr) return ;

	buf = calloc(ptr - fnames + 1, sizeof(char));

	if (!buf) return ;

	strncpy(buf, fnames, ptr - fnames);
	
	if (strstr(buf, "copy")) command = COPY_ACTION;
	if (strstr(buf, "cut")) command = MOVE_ACTION;
	
	if (!command) return ;
	free(buf);
	ptr++;
	
	if ((ptr - fnames) >= strlen(fnames)) return ;
	
	ptr2 = ptr;
	
	while(1)
	{
		if ((ptr2 = strstr(ptr, "\n")) != NULL)
		{
#ifdef DEBUG
			printf("End line found\n");
#endif
			if (ptr2 > ptr)
			{
				if ((buf = calloc(ptr2 - ptr + 1, sizeof(char))) != NULL)
				{
#ifdef DEBUG
					printf("End line found and calloc ok\n");
#endif
					strncpy(buf, ptr, ptr2 - ptr);
					if ((ptr = strstr(buf, "file://")) != NULL)
					{
						ptr = ptr + strlen("file://");
#ifdef DEBUG
						printf("1____________Pasting:%s\n", ptr);
						printf("1____________name_num:%d mem %d\n", name_num, sizeof(char *) * name_num);
#endif
/*						if (!name_list) name_list = malloc(sizeof(char *));
						else name_list = realloc(name_list, (size_t)(sizeof(char *) * (name_num+1)));
						((char **)name_list)[name_num] = uri_decode(ptr);*/
						name_num++;
						if (FirstNode)
						{
							CurrentNode->next = (struct _FileListNode *)malloc(sizeof(struct _FileListNode));
							CurrentNode = CurrentNode->next;
							CurrentNode->next = NULL;
						}
						else
						{
							FirstNode = (struct _FileListNode *)malloc(sizeof(struct _FileListNode));
							CurrentNode = FirstNode;
							CurrentNode->next = NULL;
						}
						CurrentNode->command = command;
						CurrentNode->fname = uri_decode(ptr);
						CurrentNode->ddir = (char *) calloc(strlen(DestinationPath) + 1, sizeof(char));
						strcpy(CurrentNode->ddir, DestinationPath);
/*						CurrentNode->ddir = (char *)malloc(strlen(IbPtr->current_wd)+1);
						strcpy(CurrentNode->ddir, IbPtr->current_wd);*/
							
					}
#ifdef DEBUG
					printf("End line found and next free\n");
					printf("+++++++Cmd %d fname %s ddir %s\n", CurrentNode->command, CurrentNode->fname, CurrentNode->ddir);
#endif
					free(buf);
				}
			}
			ptr = ptr2 + 1;
			if (ptr >= fnames + strlen(fnames)) break ;
		}
		else
		{
#ifdef DEBUG
			printf("End line not found\n");
#endif
			if (ptr >= fnames + strlen(fnames)) break ;
#ifdef DEBUG
			printf("End line not found and string found\n");
#endif
			if ((buf = calloc(strlen(ptr) + 1, sizeof(char))) != NULL)
			{
#ifdef DEBUG
				printf("End line not found and calloc ok\n");
#endif
				strcpy(buf, ptr);
				if ((ptr = strstr(buf, "file://")) != NULL)
				{
					ptr = ptr + strlen("file://");
#ifdef DEBUG
					printf("2____________Pasting:%s\n", ptr);
					printf("2____________name_num:%d mem %d\n", name_num, sizeof(char *) * name_num);
#endif
/*					if (!name_list) name_list = malloc(sizeof(char *));
					else name_list = realloc(name_list, (size_t)(sizeof(char *) * (name_num+1)));
					((char **)name_list)[name_num] = uri_decode(ptr);*/
					name_num++;
					if (FirstNode)
					{
						CurrentNode->next = (struct _FileListNode *)malloc(sizeof(struct _FileListNode));
						CurrentNode = CurrentNode->next;
						CurrentNode->next = NULL;
					}
					else
					{
						FirstNode = (struct _FileListNode *)malloc(sizeof(struct _FileListNode));
						CurrentNode = FirstNode;
						CurrentNode->next = NULL;
					}
					CurrentNode->command = command;
					CurrentNode->fname = uri_decode(ptr);
					CurrentNode->ddir = (char *) calloc(strlen(DestinationPath) + 1, sizeof(char));
					strcpy(CurrentNode->ddir, DestinationPath);
/*					CurrentNode->ddir = (char *)malloc(strlen(IbPtr->current_wd) + 1);
					strcpy(CurrentNode->ddir, IbPtr->current_wd);*/
				}
#ifdef DEBUG
				printf("End line not found and next free\n");
				printf("+++++++Cmd %d fname %s ddir %s\n", CurrentNode->command, CurrentNode->fname, CurrentNode->ddir);
#endif
				free(buf);
				break ;
			}
			
		}
	}
#ifdef DEBUG
	printf("Current work directory:  %s|\n", IbPtr->current_wd);
	{
		struct _FileListNode * CurrentFileNode = FirstNode;
		while (CurrentFileNode)
		{
//			printf("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxCommand = %d src = %s \n", CurrentFileNode->command, CurrentFileNode->fname);
			printf("%d %s %s\n", CurrentFileNode->command, CurrentFileNode->fname, CurrentFileNode->ddir);
			CurrentFileNode = CurrentFileNode->next;
		}
	}
#endif
	if (name_num) CopyMoveAction(FirstNode, IbPtr, DestinationPath);
}



void PasteActionBack(char * fnames)
{
	char * ptr, * ptr2, * buf;
	int command = 0;
	
	int name_num = 0;
	void *name_list = NULL;
	
	ptr = strchr(fnames, '\n');
	if (!ptr) return ;

	buf = calloc(ptr - fnames + 1, sizeof(char));

	if (!buf) return ;

	strncpy(buf, fnames, ptr - fnames);
	
	if (strstr(buf, "copy")) command = 1;
	if (strstr(buf, "cut")) command = 2;
	
	if (!command) return ;
	free(buf);
	ptr++;
	
	if ((ptr - fnames) >= strlen(fnames)) return ;
	
	ptr2 = ptr;
	
	while(1)
	{
		if ((ptr2 = strstr(ptr, "\n")) != NULL)
		{
#ifdef DEBUG
			printf("End line found\n");
#endif
			if (ptr2 > ptr)
			{
				if ((buf = calloc(ptr2 - ptr + 1, sizeof(char))) != NULL)
				{
#ifdef DEBUG
					printf("End line found and calloc ok\n");
#endif
					strncpy(buf, ptr, ptr2 - ptr);
					if ((ptr = strstr(buf, "file://")) != NULL)
					{
						ptr = ptr + strlen("file://");
#ifdef DEBUG
						printf("1____________Pasting:%s\n", ptr);
						printf("1____________name_num:%d mem %d\n", name_num, sizeof(char *) * name_num);
#endif
						if (!name_list) name_list = malloc(sizeof(char *));
						else name_list = realloc(name_list, (size_t)(sizeof(char *) * (name_num+1)));
						((char **)name_list)[name_num] = uri_decode(ptr);
						name_num++;
//						CopyMoveAction(ptr, command);
					}
#ifdef DEBUG
					printf("End line found and next free\n");
#endif
					free(buf);
				}
			}
			ptr = ptr2 + 1;
			if (ptr >= fnames + strlen(fnames)) break ;
		}
		else
		{
#ifdef DEBUG
			printf("End line not found\n");
#endif
			if (ptr >= fnames + strlen(fnames)) break ;
#ifdef DEBUG
			printf("End line not found and string found\n");
#endif
			if ((buf = calloc(strlen(ptr) + 1, sizeof(char))) != NULL)
			{
#ifdef DEBUG
				printf("End line not found and calloc ok\n");
#endif
				strcpy(buf, ptr);
				if ((ptr = strstr(buf, "file://")) != NULL)
				{
					ptr = ptr + strlen("file://");
#ifdef DEBUG
					printf("2____________Pasting:%s\n", ptr);
					printf("2____________name_num:%d mem %d\n", name_num, sizeof(char *) * name_num);
#endif
					if (!name_list) name_list = malloc(sizeof(char *));
					else name_list = realloc(name_list, (size_t)(sizeof(char *) * (name_num+1)));
					((char **)name_list)[name_num] = uri_decode(ptr);
					name_num++;
//					CopyMoveAction(ptr, command);
				}
#ifdef DEBUG
				printf("End line not found and next free\n");
#endif
				free(buf);
				break ;
			}
		}
	}
//if (name_num) CopyMoveActionBack((char**) name_list, name_num, command);
}

static Boolean 
ConvertSelection(Widget w, Atom *selection, Atom *target,
		 Atom *type, XtPointer *value, unsigned long *length, 
		 int *format)
{
	Display* d = XtDisplay(w);
	XSelectionRequestEvent* req = XtGetSelectionRequest(w, *selection, (XtRequestId)NULL);
	IfaceBranche * IbPtr;
	char * ptr1, * ptr2;
#ifdef DEBUG
	char * name;
	printf("ConvertSelection target %ld\n", *target);
	name = XGetAtomName(XtDisplay(w), *target);
	printf("=========Atom %s\n", name);
#endif


#ifdef DEBUG
	if (*target == XA_CLIPBOARD(d)) 
	{
		printf("XA_CLIPBOARD\n");
	}
#endif

	if (*target == XA_TARGETS(d)) 
	{
#ifdef DEBUG
		printf("XA_TARGETS\n");
#endif
		Atom* targetP;
		Atom* std_targets;
		unsigned long std_length;
		XmuConvertStandardSelection(w, req->time, selection, target, type,
				    (XPointer*)&std_targets, &std_length,
				    format);
//		*value = XtMalloc(sizeof(Atom)*(std_length + 5));
		*value = XtMalloc(sizeof(Atom)*(std_length + 2));
		targetP = *(Atom**)value;
		*targetP++ = COPY_ATOM;
//		*length = std_length + (targetP - (*(Atom **) value));
		*length = std_length + 1;

//		targetP = *(Atom**)value;
		*targetP++ = UTF8_STRING;
//		*length = std_length + (targetP - (*(Atom **) value));
		*length = std_length + 1;

		memmove( (char*)targetP, (char*)std_targets, sizeof(Atom)*std_length);
		XtFree((char*)std_targets);
		*type = XA_ATOM;
		*format = 32;
#ifdef DEBUG
		printf("XA_TARGETS ok\n");
#endif
		return True;
	}
	else if (*target == COPY_ATOM)
	{
		char * temp;
#ifdef DEBUG
		printf("COPY_ATOM\n");
#endif
		XtVaGetValues(w, XmNuserData, &IbPtr, NULL);	
    	if(IbPtr->file_list)
    	{
			temp = (char *) XtMalloc(strlen(IbPtr->file_list) + 1);
			strcpy(temp, IbPtr->file_list);
			
			*value = (XPointer) temp;
			*type = COPY_ATOM;
			*length = strlen(temp) + 1;
			*format = 8;
			return True;
		}
	}
		else
			if (*target == UTF8_STRING)
			{
				char * temp;
#ifdef DEBUG
				printf("UTF8_STRING\n");
#endif
				XtVaGetValues(w, XmNuserData, &IbPtr, NULL);	
				if(IbPtr->file_list)
				{
					temp = (char *) XtCalloc(strlen(IbPtr->file_list) + 1, sizeof(char));
					ptr1 = strstr(IbPtr->file_list, "\nfile://");
					while (ptr1)
					{
						ptr2 = ptr1;
						ptr1 = strstr(ptr2 + 8, "\nfile://");
						if (ptr1)
							strncat(temp, ptr2 + 7, ptr1 - ptr2 - 6);
						else
							strncat(temp, ptr2 + 7, strlen(ptr2 + 7));
					}
					*value = (XPointer) temp;
					*type = UTF8_STRING;
					*length = strlen(temp) + 1;
					*format = 8;
					return True;
				}
			}
			else
			{
				return False;
			}

	return False;
}

static void RequestorCallback(Widget w, XtPointer client_data, Atom *selection, Atom *type, XtPointer value, unsigned long * length, int *format)
{
	Atom *t_atom;
	char * d_path = NULL;
	int i;
	IfaceBranche * IbPtr;
	Boolean ok;
	int item_num, * numbers;
	struct filedata * fdp = NULL;
	unsigned char valuemask = 0 | CellUserData;
	XmNlCell item;

#ifdef DEBUG
	printf("requestor_callback called atom size = %lu\n", sizeof(Atom));
	if (*length > 0) printf("length = %lu format = %d\n", *length, *format);
	printf("Atom type = %d\n", *((int *) type));
#endif

	XtVaGetValues(w, XmNuserData, &IbPtr, NULL);
	
	if (*type == XA_ATOM)
	{
#ifdef DEBUG
		printf("Atom list retrieved\n");
#endif
		t_atom = (Atom *) value;
		for (i = 0; i < * length; i++)
		{
			if (*(t_atom+i) == COPY_ATOM)
			{
#ifdef DEBUG
				printf("x-special/gnome-copied-files ok\n");
#endif
				XtGetSelectionValue(w, XA_CLIPBOARD(XtDisplay(w)), COPY_ATOM, RequestorCallback, 
					client_data, CurrentTime);
			}
		}
		XtFree(value);
		return ;
	}
	if (*type == COPY_ATOM)
	{
#ifdef DEBUG
		printf("x-special/gnome-copied-files retrieved\n");
		printf("Value: %s\n", (char *) value);
		printf("copy target is %d\n", *((int *) client_data));
#endif
		if (*((int *) client_data) == COPY_TO_CURRENT_DIR)
		{
			d_path = calloc(strlen(IbPtr->current_wd) + 1, sizeof(char));
			if (d_path)
				strcpy(d_path, IbPtr->current_wd);
		}
		else
		{
			XtVaGetValues(IbPtr->fm_scroll_win, XmNselectedPositionCount, &item_num, XmNselectedPositions, &numbers, NULL);			
			ok = XmNlListGetItem(IbPtr->fm_scroll_win, &item, valuemask, *numbers);
			if (ok)
			{
				fdp = (struct filedata *) item.UserDataPointer;

				d_path = (char *) calloc((strlen(IbPtr->current_wd) + 4 + strlen(fdp->name)), sizeof(char));
				if (d_path) 
				{
					sprintf(d_path, "%s/%s", IbPtr->current_wd, fdp->name);
				}
			}
		}
		PasteAction((char *) value, IbPtr, d_path);
		XtFree(value);
		return ;
	}
}



void CutFile(char *source, IfaceBranche * IbPtr) {
#ifdef DEBUG
	printf("Cut:\n%s\n", source);
#endif

	if (IbPtr->file_list) 
	{
		free(IbPtr->file_list);
	}
	IbPtr->file_list = (char *) calloc(strlen(source), sizeof(char));
	strcpy(IbPtr->file_list, source);

	XtOwnSelection(IbPtr->fm_scroll_win, XA_CLIPBOARD(XtDisplay(IbPtr->fm_scroll_win)), CurrentTime,
			ConvertSelection, NULL, NULL);

}

void PasteFile(IfaceBranche * IbPtr, int * target) {

#ifdef DEBUG
	printf("Paste:\n%s\n", IbPtr->current_wd);
#endif


	XtGetSelectionValue(IbPtr->fm_scroll_win, XA_CLIPBOARD(XtDisplay(IbPtr->fm_scroll_win)), XA_TARGETS(XtDisplay(IbPtr->fm_scroll_win)), 
						RequestorCallback, (XtPointer) target, CurrentTime);
}

/* Copy file interface.  */
void CopyFile(char *source, IfaceBranche * IbPtr) {
#ifdef DEBUG
	printf("Copy X:\n%s\n", source);
#endif
	if (IbPtr->file_list) 
		free(IbPtr->file_list);
	IbPtr->file_list = (char *) calloc(strlen(source) + 1, sizeof(char));
	strcpy(IbPtr->file_list, source);

	XtOwnSelection(IbPtr->fm_scroll_win, XA_CLIPBOARD(XtDisplay(IbPtr->fm_scroll_win)), CurrentTime,
				ConvertSelection, NULL, NULL);

}

/* Need to access these repeatedly. */
Widget cm_shell, source_tf, dest_tf;

/* CopyMove OK callback. */
void CM_CB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	char *source, *dest, *cwd;
	char source2[1024], dest2[1024];
	char system_cmd[1024];
	int ret;
	struct stat source_buf, dest_buf;
	Widget text, label;
	IfaceBranche * IbPtr;


	text = XtNameToWidget(w, "Text");
	label = XtNameToWidget(w, "Selection");
	

	XtVaGetValues(label, XmNuserData, &source, NULL);
	XtVaGetValues(text, XmNvalue, &dest, NULL);
	XtVaGetValues(w, XmNuserData, &IbPtr, NULL);


	if ((int)client_data == CM_CANCEL) {
		free(source);
		XtDestroyWidget(XtParent(w));
		return;
	}

	sprintf(source2, "%s", source);


	if (dest[0] != '/')
		sprintf(dest2, "%s/%s", IbPtr->current_wd, dest);
	else
		sprintf(dest2, "%s", dest);
//  cwd = (char *)malloc(sizeof(char)*strlen(current_wd));
//  strcpy(cwd, current_wd);
//  if (strlen(cwd) > 1) cwd[strlen(cwd)-1] = 0;


	XtDestroyWidget(XtParent(w));

	free(source);

	stat(source2, &source_buf);
	stat(dest2, &dest_buf);
	if (!IsReadable(source_buf)) {
		NoCanDo(CANT_ACCESS_SRC, IbPtr, NULL, NULL);
		return;
	}
	
	if (!IsWritable(dest_buf)) {
		NoCanDo(CANT_ACCESS_DEST, IbPtr, NULL, NULL);
		return;
	}

	if ((int)client_data == CM_COPY) {
		sprintf(system_cmd, "cp %s %s", source2, dest2);
		ret = system(system_cmd);
//		cwd = strdup(IbPtr->current_wd);
//		load_dir(IbPtr, cwd);
//		DrawFileArea(IbPtr);
//	    free(cwd);
		return;
	}
	else
	{
		if (IsWritable(source_buf)) {
			sprintf(system_cmd, "mv %s %s", source2, dest2);
			ret = system(system_cmd);
//			cwd = strdup(IbPtr->current_wd);
//			load_dir(IbPtr, cwd);
			DrawFileArea(IbPtr);
//			free(cwd);
			return;
		}
		else
			NoCanDo(CANT_MOVE_SRC, IbPtr, NULL, NULL);
	}
}

/* if copymove is 0, move file.  If copymove is 1, copy the file. */
void CopyMoveFile(char *source, int copymove, IfaceBranche * IbPtr) 
{
	XmString toplabel, toplabl, ok_s, cancel_s, help_s;
	char wmname[256], * string;
	Arg args[9];
	Cardinal n;
	Widget dialog, cm_form, cm_label, cm_labl2, cm_ok, cm_cancel, cm_help;

	if (copymove) 
	{
		strcpy(wmname, "Copy");
		string = calloc(strlen("Copy ") + strlen(source) + strlen(" to:") + 1, sizeof(char));
		sprintf(string, "Copy %s to:", source);
	}
	else 
	{
		strcpy(wmname, "Move");
		string = calloc(strlen("Move ") + strlen(source) + strlen(" to:") + 1, sizeof(char));
		sprintf(string, "Move %s to:", source);
	}
	
	toplabl = XmStringCreateLocalized(string);
	free(string);
/*  ok_s = XmStringCreateSimple("OK");
  cancel_s = XmStringCreateSimple("Cancel");
  help_s = XmStringCreateSimple("Help");
*/
	n = 0;
	XtSetArg(args[n], XmNselectionLabelString, toplabl);
	n++;
	XtSetArg(args[n], XmNtitle, wmname);
	n++;
	XtSetArg(args[n], XmNautoUnmanage, False); 
	n++;


	dialog = XmCreatePromptDialog(IbPtr->top_level, "CopyMove", args, n);
	XmStringFree(toplabl);

	cm_label = XtNameToWidget(dialog, "Selection");
	XtVaSetValues(dialog, XmNuserData, IbPtr, NULL);
	XtVaSetValues(cm_label, XmNuserData, source, NULL);
//	cm_cancel = XtNameToWidget(dialog, "Cancel");

	if (copymove) XtAddCallback(dialog, XmNokCallback, CM_CB, (XtPointer) CM_COPY);
	else XtAddCallback(dialog, XmNokCallback, CM_CB, (XtPointer) CM_MOVE);

	XtAddCallback(dialog, XmNcancelCallback, CM_CB, (XtPointer) CM_CANCEL);

	XtManageChild(dialog);

}

void DeleteCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	struct _FileListNode * FirstFileNode = (struct _FileListNode *) client_data;
	pthread_mutex_t * mutex;
	sem_t * sem;
	pthread_t thread_id;
	IfaceBranche * IbPtr;
	struct _PreparingRec * prep;
	void ** fps;
	int i;


	XtVaGetValues(w, XmNuserData, &IbPtr, NULL);
	
	prep = (struct _PreparingRec * ) malloc(sizeof(struct _PreparingRec));
	prep->In = FirstFileNode;
	prep->Out = NULL;
	prep->OutMove = NULL;
	prep->dstdir = NULL;
	prep->ret_code = STATUS_OK;
	prep->ready = 0;
	prep->IbPtr = IbPtr;
//	prep->state = CM_STATE_START;
	prep->state = CM_STATE_PROCESSING;
	prep->mode = MODE_NORMAL;
	prep->UserInterrupt = False;

	prep->filename = NULL;
	prep->full_dest_path = NULL;
	prep->full_source_path = NULL;

	prep->fops_type = FOPS_IS_DELETE;
	prep->wait_user_action = 0;
	
	prep->OverwriteAllDstDir = False;
	prep->OverwriteAllDstFile = False;
	prep->SkipAllDstDir = False;
	prep->SkipAllDstFile = False;
	prep->SkipAllSrcDir = False;
	prep->SkipAllSrcFile = False;
	
	prep->ProgressDialogFound = False;
	prep->ControlDialogFound = False;
	prep->OpsCompleted = False;


	mutex = malloc(sizeof(pthread_mutex_t));
	pthread_mutex_init(mutex, NULL);

	sem = malloc(sizeof(sem_t));
	sem_init(sem, 0, 0);

	prep->sem = sem;
	prep->mutex = mutex;

	if (IbPtr->fops_allocated < (IbPtr->copy_move_thread_count + 1))
	{
		fps = calloc(IbPtr->fops_allocated + 5, sizeof (void *));
		if (fps)
		{
			if (IbPtr->fops)
			{
				memmove(fps, IbPtr->fops, sizeof(void *) * IbPtr->fops_allocated);
				free(IbPtr->fops);
			}
			IbPtr->fops = fps;
			IbPtr->fops_allocated += 5;
		}
	}
	
	for (i = 0; i < IbPtr->fops_allocated; i++)
	{
		if (IbPtr->fops[i] == NULL)
			break ;
	}


//printf("Delete: Past i = %d fops = %p\n", i, IbPtr->fops);

	if (i >= IbPtr->fops_allocated || !IbPtr->fops)
	{
		CleanCMData(prep);
		return ;
	}

//printf("Next ++\n");

	IbPtr->copy_move_thread_count++;
	IbPtr->fops[i] = (void *) prep;





//	pthread_create(&thread_id, NULL, CopyMoveThread, (void *) prep);

//	DeleteProgressDialog(prep, "bxfm: deleting file\(s\)"); 
  
	pthread_create(&thread_id, NULL, DeleteThread, (void *) prep);

	prep->task_thread_id = thread_id;

//	CopyMoveThreadNew((void *) prep);
//	prep->WorkProcFound = True;
//	prep->WorkProc = XtAppAddWorkProc(app, CopyMoveWorkProcedure, (XtPointer) prep);

//	XtAppAddTimeOut(IbPtr->app, 500, (XtTimerCallbackProc) DeleteWorkProcedure, (XtPointer) prep);

	return ;

}




void CancelDeleteMainCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	struct _FileListNode * list = (struct _FileListNode *) client_data;
	struct _FileListNode * ptr;

	XtDestroyWidget(XtParent(w));
	
	while (list)
	{
		if (list->fname) free(list->fname);
		if (list->ddir) free(list->ddir);
		ptr = list;
		list = list->next;
		free(ptr);
	}
}


void DeleteFileMainDialog(int num, struct _FileListNode * list, IfaceBranche * IbPtr) 
{
	Widget delete_dialog;
	XmString delete_msg;
	char *msg_str, *cfile;
	Arg args[6];
	Cardinal n;
	struct stat buf;

#ifdef DEBUG
	printf("DeleteFileMainDialog: starting\n");
#endif

	if (num > 1)
	{
		msg_str = (char *) malloc(strlen("Really delete files") + 20);
		sprintf(msg_str, "Really delete %d files", num);
	}
	else
	{
		msg_str = (char *) malloc(strlen("Really delete   file") + strlen(list->fname) + 1);
		sprintf(msg_str, "Really delete file %s", list->fname);
	}
	delete_msg = XmStringCreateLocalized(msg_str);
	n = 0;
	XtSetArg(args[n], XmNmessageString, delete_msg);
	n++;
	XtSetArg(args[n], XmNtitle, "Delete this file?");
	n++;
	XtSetArg(args[n], XmNuserData, IbPtr);
	n++;
		
	delete_dialog = XmCreateWarningDialog(IbPtr->top_level, "delete_dialog1", args, n);
	XtAddCallback(delete_dialog, XmNokCallback, DeleteCB, (XtPointer) list);
	XtAddCallback(delete_dialog, XmNcancelCallback, CancelDeleteMainCB, (XtPointer) list);
	XtAddCallback(delete_dialog, XmNhelpCallback, HelpTopic, (XtPointer)FILE_HELP_DELETE);
	XtManageChild(delete_dialog);
	XmStringFree(delete_msg);
	free(msg_str);

#ifdef DEBUG
	printf("DeleteFileMainDialog: completed\n");
#endif

/*  cfile = (char *)malloc(sizeof(char)*100);
  stat(thisfile, &buf);
  if (IsWritable(buf)) {
    strcpy(cfile, thisfile);
    if (S_ISDIR(buf.st_mode))
      sprintf(msg_str, 
	      "Really delete directory %s\nand all its subdirectories?", 
	      thisfile);
    else
      sprintf(msg_str, "Really delete %s?", thisfile);      
    delete_msg = XmStringCreate(msg_str, XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[0], XmNmessageString, delete_msg);
    XtSetArg(args[1], XmNtitle, "Delete this file?");
    delete_dialog=XmCreateWarningDialog(top_level, "delete_dialog1", args, 2);
    XtAddCallback(delete_dialog, XmNokCallback, DeleteCB, cfile);
    XtAddCallback(delete_dialog, XmNcancelCallback, CancelCB, NULL);
    XtAddCallback(delete_dialog, XmNhelpCallback, HelpTopic, 
		  (XtPointer)FILE_HELP_DELETE);
    XtManageChild(delete_dialog);
    XmStringFree(delete_msg);
  }
  else {
    NoCanDo(CANT_DELETE);
  }*/
}


  
  
void DeleteFile(char * fnames, IfaceBranche * IbPtr)
{
	char * ptr, * ptr2, * buf;
	int command = 0;
	
	struct _FileListNode * FirstNode = NULL, * CurrentNode = NULL;
	
	int name_num = 0;

	
/*	ptr = strchr(fnames, '\n');
	if (!ptr) return ;

	ptr++;
	
	if ((ptr - fnames) >= strlen(fnames)) return ;*/
	
	ptr = fnames;
	
	while(1)
	{
		if ((ptr2 = strstr(ptr, "\n")) != NULL)
		{
#ifdef DEBUG
			printf("End line found\n");
#endif
			if (ptr2 > ptr)
			{
				if ((buf = calloc(ptr2 - ptr + 1, sizeof(char))) != NULL)
				{
#ifdef DEBUG
					printf("End line found and calloc ok\n");
#endif
					strncpy(buf, ptr, ptr2 - ptr);
#ifdef DEBUG
					printf("1____________for deleting:%s\n", ptr);
					printf("1____________name_num:%d mem %d\n", name_num, sizeof(char *) * name_num);
#endif
					name_num++;
					if (FirstNode)
					{
						CurrentNode->next = (struct _FileListNode *)malloc(sizeof(struct _FileListNode));
						CurrentNode = CurrentNode->next;
						CurrentNode->next = NULL;
					}
					else
					{
						FirstNode = (struct _FileListNode *)malloc(sizeof(struct _FileListNode));
						CurrentNode = FirstNode;
						CurrentNode->next = NULL;
					}
					CurrentNode->command = command;
					CurrentNode->fname = buf;
					CurrentNode->ddir = (char *)malloc(strlen(IbPtr->current_wd)+1);
					strcpy(CurrentNode->ddir, IbPtr->current_wd);
							
#ifdef DEBUG
					printf("+++++++Cmd %d fname %s ddir %s\n", CurrentNode->command, CurrentNode->fname, CurrentNode->ddir);
#endif
				}
			}
			ptr = ptr2 + 1;
			if (ptr >= fnames + strlen(fnames)) break ;
		}
		else
		{
#ifdef DEBUG
			printf("End line not found\n");
#endif
			if (ptr >= fnames + strlen(fnames)) break ;
#ifdef DEBUG
			printf("End line not found and string found\n");
#endif
			if ((buf = calloc(strlen(ptr) + 1, sizeof(char))) != NULL)
			{
#ifdef DEBUG
				printf("End line not found and calloc ok\n");
#endif
				strcpy(buf, ptr);
#ifdef DEBUG
				printf("2___________for deletng:%s\n", ptr);
				printf("2____________name_num:%d mem %d\n", name_num, sizeof(char *) * name_num);
#endif
				name_num++;
				if (FirstNode)
				{
					CurrentNode->next = (struct _FileListNode *)malloc(sizeof(struct _FileListNode));
					CurrentNode = CurrentNode->next;
					CurrentNode->next = NULL;
				}
				else
				{
					FirstNode = (struct _FileListNode *)malloc(sizeof(struct _FileListNode));
					CurrentNode = FirstNode;
					CurrentNode->next = NULL;
				}
				CurrentNode->command = command;
				CurrentNode->fname = buf;
				CurrentNode->ddir = (char *)malloc(strlen(IbPtr->current_wd)+1);
				strcpy(CurrentNode->ddir, IbPtr->current_wd);
#ifdef DEBUG
				printf("+++++++Cmd %d fname %s ddir %s\n", CurrentNode->command, CurrentNode->fname, CurrentNode->ddir);
#endif
				break ;
			}
			
		}
	}
#ifdef DEBUG
	printf("Current work directory:  %s|\n", IbPtr->current_wd);
	struct _FileListNode * CurrentFileNode = FirstNode;
	while (CurrentFileNode)
	{
//		printf("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxCommand = %d src = %s \n", CurrentFileNode->command, CurrentFileNode->fname);
		printf("%d %s %s\n", CurrentFileNode->command, CurrentFileNode->fname, IbPtr->current_wd);
		CurrentFileNode = CurrentFileNode->next;
	}
#endif
	if (name_num) DeleteFileMainDialog(name_num, FirstNode, IbPtr);

}
  
