#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <pwd.h>
#include <grp.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>



#include <Xm/Xm.h>
#include <Xm/XmP.h>
#include <Xm/Container.h>
#include <Xm/IconG.h>
#include <Xm/DragDrop.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/SeparatoG.h>
#include <Xm/ToggleB.h>

#include <X11/xpm.h>
#include <X11/Xos.h>
#include <X11/cursorfont.h>

#include "core.h"
#include "getdir.h"
#include "smallicons.h"
#include "smbshare.h"
#include "filearea.h"
#include "getinfo.h"
#include "filecmd.h"
#include "defines.h"
#include "errormsg.h"
#include "utils.h"
#include "openfile.h"
#include "dircmd.h"

#include "XmNl/XmNlPartRes.h"
#include "XmNl/XmNlResColList.h"
#include "XmNl/XmNl.h"
#include "XmNl/XmNlList.h"


#define PopupMenuItemOn(a, b) MenuItemManage(a, b, True)
#define PopupMenuItemOff(a, b) MenuItemManage(a, b, False)
#define CHECK_IS_DIR_LNK(mode) 	((mode & S_IFMT) == (S_IFDIR | S_IFLNK))

#define TMP_CHAR_BUF_SIZE 200

//#define DEBUG 1
//#define DEBUG_WATCH_DIR 1

static char *SensitiveItems[] = {"NewWidndow", "Run", "Find", "Close", "Exit", "Create", "Goto",
								"Home", "Up", "Cut", "Copy", "Paste", "Delete", "Information",
								"LargeView", "SmallView", "DetailView", "ShowHiddenDirs", "ShowHiddenFiles",
								"ShowCurrentDir", "ShowParentDir",};
const int SensitiveItmesCount = 21;


/**** Switch: copy to current or selected dir ****/
int _CopyToCurrentDir = COPY_TO_CURRENT_DIR;
int _CopyToSelectedDir = COPY_TO_SELECTED_DIR;

Pixmap dir_xpm, file_xpm, lfile_xpm, ldir_xpm, lbad_xpm;
Pixmap mask_dir_xpm, mask_file_xpm, mask_lfile_xpm, mask_ldir_xpm, mask_lbad_xpm;

Pixmap small_dir_xpm, small_file_xpm, small_lfile_xpm, small_ldir_xpm, small_lbad_xpm;
Pixmap mask_small_dir_xpm, mask_small_file_xpm, mask_small_lfile_xpm, mask_small_ldir_xpm, mask_small_lbad_xpm;

//Widget *file_icons;
int old_fp = 0, first_time = 0;
extern char current_wd[120];
extern int CurrentViewType;
extern char * MakeSelectList(int, IfaceBranche *);
extern void exec_action(char * name, char * action);

extern bxfm_ftype ** ftype_list;

extern int count_all;
extern int count_current;

extern Atom FILE_NAME;

extern pthread_mutex_t iface_mutex;
extern pthread_mutex_t config_mutex;

//Cursor WaithCursor;
//Boolean CursorCreated = False;

struct _MenuItemDesc
{
	int action;
	int clicked;
	IfaceBranche * IbPtr;
	struct _MenuItemDesc * next;
} typedef MenuItemDesc;

const char icon_title[]="O";

const char name_title[]="Name";
const char size_title[]="Size";
const char date_title[]="Date";
const char perm_title[]="Permission";
const char owner_title[]="Owner";
const char owngrp_title[]="Group";

/*void ReDrawFileArea(IfaceBranche *);*/
int ItemAdd(IfaceBranche * , int , int );
void ReSort(IfaceBranche * IbPtr);


//XtWorkProcId id1, id2;

#ifdef USE_INOTIFY

#define CHANGE_DATE 0x01
#define CHANGE_PERMISSION 0x02
#define CHANGE_UID 0x04
#define CHANGE_GID 0x08
#define CHANGE_SIZE 0x10
#define CHANGE_MAGIC 0x20

int CheckInsertPositon(IfaceBranche *IbPtr, struct filedata * fileref, struct filedata * files);
int CloseItemInFileView(IfaceBranche * IbPtr, struct filedata * fileref);


XmString CreateLabel(char * name)
{
	XmString str1, str2, str3;
	int n, l, k = 0;
	char *ptr, tmp_char;
	
	n = strlen(name);
	if (MultilineLabelLimit > n)
	{
		str1 = XmStringGenerate((XtPointer) name, NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);
		return str1;
	}
	else
	{
		ptr = name;
		l = mblen(ptr, n);
		while(l != 0 || n > 0)
		{
			if (l == -1)
			{
				printf("incorrect multybyte symbol\n");
				ptr++;
				k++;
				n--;
				l = mblen(ptr, n);
				continue;
			}
			if (l == 0)
			{
				break;
			}
			if (l > 0)
			{
				ptr = ptr + l;
				n = n - l;
				k = k + l;
				if (k > MultilineLabelLimit)
				{
					l = mblen(ptr, n);
					if ((n - l) > 3)
					{
						tmp_char = *ptr;
						*ptr = '\0';
						str1 = XmStringGenerate((XtPointer) name, NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);
						str2 = XmStringComponentCreate(XmSTRING_COMPONENT_SEPARATOR, 0, NULL);
						str3 = XmStringConcatAndFree(str1, str2); 
						*ptr = tmp_char;
						str2 = XmStringGenerate((XtPointer) ptr, NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);
						str1 = XmStringConcatAndFree(str3, str2); 
						return str1;
					}
					else
						return XmStringGenerate((XtPointer) name, NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);
				}
				l = mblen(ptr, n);
				continue;
			}
		}
		return XmStringGenerate((XtPointer) name, NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);
	}
}


void LargeItemInsert(IfaceBranche * IbPtr, struct filedata * fileref)
{
	bxfm_ftype * mgtype;
	unsigned char valuemask = 0 | CellXmString | CellPixmap | CellMask | CellUserData | CellCharString;
	struct filedata * fileptr;
	XmNlCell item, cell;
	int i, n, num_items, start_row = 0;
	int item_is_directory = 0, inserted_ok = 0;
	Widget wid;


	if (IbPtr->CurrentViewType != LARGE_VIEW)
		return ;

	mgtype = fileref->magic;

	if (mgtype != NULL && mgtype->big_icon_name) 
	{
#ifdef DEBUG
		printf("--------Magic found %p\n", mgtype);
#endif
		if (mgtype->big_pixmap > 2)
		{
#ifdef DEBUG
			printf("---------External pix found %lx %lx\n", mgtype->big_pixmap, mgtype->big_mask);
#endif
			item.pixmap = mgtype->big_pixmap;
			item.mask = mgtype->big_mask;
		}
		else
		{
			item.pixmap = XmUNSPECIFIED_PIXMAP;
			item.mask = XmUNSPECIFIED_PIXMAP;
		}
	}
	if (mgtype == NULL || (mgtype && !mgtype->big_icon_name))
	{
		switch (fileref->filetype & S_IFMT) 
		{
			case (S_IFDIR | S_IFLNK):
				item.pixmap = ldir_xpm;
				item.mask = mask_ldir_xpm;
				break;
			case S_IFDIR:
				item.pixmap = dir_xpm;
				item.mask = mask_dir_xpm;
				break;
			case S_IFREG:
				item.pixmap = file_xpm;
				item.mask = mask_file_xpm;
				break;
			case S_IFLNK:
				if (fileref->linkto)
				{
					item.pixmap = lfile_xpm;
					item.mask = mask_lfile_xpm;
				}
				else
				{
					item.pixmap = lbad_xpm;
					item.mask = mask_lbad_xpm;
				}
				break;
			default:
				item.pixmap = XmUNSPECIFIED_PIXMAP;
				item.mask = XmUNSPECIFIED_PIXMAP;
				break;
		}
	}

	item.text = fileref->name;
	item.xmlabel = XmStringCreateLocalized(fileref->name);
	item.UserDataPointer = (void *) fileref;


	if (S_ISDIR(fileref->filetype) || CHECK_IS_DIR_LNK(fileref->filetype))
		item_is_directory = 1;
		
	wid = XmNlListGetIBWidget(IbPtr->fm_scroll_win);

	XtVaGetValues(wid, XmNitemCount, &num_items, NULL);

	if (IbPtr->ParentDirShow)
		start_row++;

	if (IbPtr->CurrentDirShow)
		start_row++;

	for (i = start_row; i < num_items; i++)
	{
		XmNlItBoxGetItem(wid, &cell, CellUserData, i);
		fileptr = (struct filedata *) cell.UserDataPointer;
		if (item_is_directory)
		{
			if (!S_ISDIR(fileptr->filetype) && !CHECK_IS_DIR_LNK(fileptr->filetype))
			{
				XmNlItBoxInsertItems(wid, &item, i, 1, valuemask);
				inserted_ok = 1;
				break ;
			}
			if (S_ISDIR(fileptr->filetype) || CHECK_IS_DIR_LNK(fileptr->filetype))
			{
				n = CheckInsertPositon(IbPtr, fileref, fileptr);
				if (n <= 0)
				{
					XmNlItBoxInsertItems(wid, &item, i, 1, valuemask);
					inserted_ok = 1;
					break ;
				}
			}
		}
		else
		{
			if (S_ISDIR(fileptr->filetype) || CHECK_IS_DIR_LNK(fileptr->filetype))
				continue ;
				
			n = CheckInsertPositon(IbPtr, fileref, fileptr);
			if (n <= 0)
			{
				XmNlItBoxInsertItems(wid, &item, i, 1, valuemask);
				inserted_ok = 1;
				break ;
			}
		}
	}

	if (!inserted_ok)
	{
		XmNlListAddItems(IbPtr->fm_scroll_win, &item, 1, valuemask);
	}

	XmStringFree(item.xmlabel);
}

void LargeItemSetIcon(IfaceBranche * IbPtr, int n)
{
	bxfm_ftype * mgtype;
	unsigned char valuemask = 0 | CellPixmap | CellMask;
	struct filedata * fileptr;
	XmNlCell item;
	Widget w;
	Boolean item_ok;

	if (IbPtr->CurrentViewType != LARGE_VIEW)
		return ;
printf("LargeItemSetIcon\n");
	w = XmNlListGetIBWidget(IbPtr->fm_scroll_win);

	item_ok = XmNlItBoxGetItem(w, &item, CellUserData, n);

	if (!item_ok)
		return ;
		
	fileptr = (struct filedata *) item.UserDataPointer;
	mgtype = fileptr->magic;

	if (mgtype != NULL && mgtype->big_icon_name) 
	{
//#ifdef DEBUG
		printf("--------Magic found for file: %s -> %p -> %s\n", fileptr->name, mgtype, mgtype->magic);
//#endif
		if (mgtype->big_pixmap > 2)
		{
//#ifdef DEBUG
			printf("---------External pix found %lx %lx\n", mgtype->big_pixmap, mgtype->big_mask);
//#endif
			item.pixmap = mgtype->big_pixmap;
			item.mask = mgtype->big_mask;
		}
		else
		{
			item.pixmap = XmUNSPECIFIED_PIXMAP;
			item.mask = XmUNSPECIFIED_PIXMAP;
		}
	}
	if (mgtype == NULL || (mgtype && !mgtype->big_icon_name))
	{
		switch (fileptr->filetype & S_IFMT) 
		{
			case (S_IFDIR | S_IFLNK):
				item.pixmap = ldir_xpm;
				item.mask = mask_ldir_xpm;
				break;
			case S_IFDIR:
				item.pixmap = dir_xpm;
				item.mask = mask_dir_xpm;
				break;
			case S_IFREG:
				item.pixmap = file_xpm;
				item.mask = mask_file_xpm;
				break;
			case S_IFLNK:
				if (fileptr->linkto)
				{
					item.pixmap = lfile_xpm;
					item.mask = mask_lfile_xpm;
				}
				else
				{
					item.pixmap = lfile_xpm;
					item.mask = mask_lfile_xpm;
				}
				break;
			default:
				item.pixmap = XmUNSPECIFIED_PIXMAP;
				item.mask = XmUNSPECIFIED_PIXMAP;
				break;
		}
	}
	item.text = NULL;
	item.xmlabel = NULL;
	item.UserDataPointer = NULL;

	XmNlItBoxSetItem(w, &item, valuemask, n);
}


void SmallItemInsert(IfaceBranche * IbPtr, struct filedata * fileref)
{
	bxfm_ftype * mgtype;
	unsigned char valuemask = 0 | CellXmString | CellPixmap | CellMask | CellUserData | CellCharString;
	struct filedata * fileptr;
	XmNlCell item, cell;
	int i, n, num_items, start_row = 0;
	int item_is_directory = 0, inserted_ok = 0;
	Widget wid;

	if (IbPtr->CurrentViewType != SMALL_VIEW)
		return ;

	mgtype = fileref->magic;

	if (mgtype != NULL && mgtype->small_icon_name) 
	{
#ifdef DEBUG
		printf("--------Magic found %p\n", mgtype);
#endif
		if (mgtype->small_pixmap > 2)
		{
#ifdef DEBUG
			printf("---------External pix found %lx %lx\n", mgtype->small_pixmap, mgtype->small_mask);
#endif
			item.pixmap = mgtype->small_pixmap;
			item.mask = mgtype->small_mask;
		}
		else
		{
			item.pixmap = XmUNSPECIFIED_PIXMAP;
			item.mask = XmUNSPECIFIED_PIXMAP;
		}
	}
	if (mgtype == NULL || (mgtype && !mgtype->small_icon_name))
	{
		switch (fileref->filetype & S_IFMT) 
		{
			case S_IFDIR:
				item.pixmap = small_dir_xpm;
				item.mask = mask_small_dir_xpm;
				break;
			case (S_IFDIR | S_IFLNK):
				item.pixmap = small_ldir_xpm;
				item.mask = mask_small_ldir_xpm;
				break;
			case S_IFREG:
				item.pixmap = small_file_xpm;
				item.mask = mask_small_file_xpm;
				break;
			case S_IFLNK:
				if (fileref->linkto)
				{
					item.pixmap = small_lfile_xpm;
					item.mask = mask_small_lfile_xpm;
				}
				else
				{
					item.pixmap = small_lbad_xpm;
					item.mask = mask_small_lbad_xpm;
				}
				break;
			default:
				item.pixmap = XmUNSPECIFIED_PIXMAP;
				item.mask = XmUNSPECIFIED_PIXMAP;
				break;
		}
	}
	item.text = fileref->name;
	item.xmlabel = XmStringCreateLocalized(fileref->name);
	item.UserDataPointer = (void *) fileref;




	if (S_ISDIR(fileref->filetype) || CHECK_IS_DIR_LNK(fileref->filetype))
		item_is_directory = 1;
		
	wid = XmNlListGetIBWidget(IbPtr->fm_scroll_win);

	XtVaGetValues(wid, XmNitemCount, &num_items, NULL);

	if (IbPtr->ParentDirShow)
		start_row++;

	if (IbPtr->CurrentDirShow)
		start_row++;

	for (i = start_row; i < num_items; i++)
	{
		XmNlItBoxGetItem(wid, &cell, CellUserData, i);
		fileptr = (struct filedata *) cell.UserDataPointer;
		if (item_is_directory)
		{
			if (!S_ISDIR(fileptr->filetype) && !CHECK_IS_DIR_LNK(fileptr->filetype))
			{
				XmNlItBoxInsertItems(wid, &item, i, 1, valuemask);
				inserted_ok = 1;
				break ;
			}
			if (S_ISDIR(fileptr->filetype) || CHECK_IS_DIR_LNK(fileptr->filetype))
			{
				n = CheckInsertPositon(IbPtr, fileref, fileptr);
				if (n <= 0)
				{
					XmNlItBoxInsertItems(wid, &item, i, 1, valuemask);
					inserted_ok = 1;
					break ;
				}
			}
		}
		else
		{
			if (S_ISDIR(fileptr->filetype) || CHECK_IS_DIR_LNK(fileptr->filetype))
				continue ;
				
			n = CheckInsertPositon(IbPtr, fileref, fileptr);
			if (n <= 0)
			{
				XmNlItBoxInsertItems(wid, &item, i, 1, valuemask);
				inserted_ok = 1;
				break ;
			}
		}
	}

	if (!inserted_ok)
	{
		XmNlListAddItems(IbPtr->fm_scroll_win, &item, 1, valuemask);
	}

	XmStringFree(item.xmlabel);
}

void SmallItemSetIcon(IfaceBranche * IbPtr, int n)
{
	bxfm_ftype * mgtype;
	unsigned char valuemask = 0 | CellPixmap | CellMask;
	struct filedata * fileptr;
	XmNlCell item;
	Widget w;
	Boolean item_ok;

	if (IbPtr->CurrentViewType != SMALL_VIEW)
		return ;

	w = XmNlListGetIBWidget(IbPtr->fm_scroll_win);

	item_ok = XmNlItBoxGetItem(w, &item, CellUserData, n);

	if (!item_ok)
		return ;
		
	fileptr = (struct filedata *) item.UserDataPointer;

	mgtype = fileptr->magic;

	if (mgtype != NULL && mgtype->small_icon_name) 
	{
#ifdef DEBUG
		printf("--------Magic found %p\n", mgtype);
#endif
		if (mgtype->small_pixmap > 2)
		{
#ifdef DEBUG
			printf("---------External pix found %lx %lx\n", mgtype->small_pixmap, mgtype->small_mask);
#endif
			item.pixmap = mgtype->small_pixmap;
			item.mask = mgtype->small_mask;
		}
		else
		{
			item.pixmap = XmUNSPECIFIED_PIXMAP;
			item.mask = XmUNSPECIFIED_PIXMAP;
		}
	}
	if (mgtype == NULL || (mgtype && !mgtype->small_icon_name)) 
	{
		switch (fileptr->filetype & S_IFMT) 
		{
			case S_IFDIR:
				item.pixmap = small_dir_xpm;
				item.mask = mask_small_dir_xpm;
				break;
			case (S_IFDIR | S_IFLNK):
				item.pixmap = small_ldir_xpm;
				item.mask = mask_small_ldir_xpm;
				break;
			case S_IFREG:
				item.pixmap = small_file_xpm;
				item.mask = mask_small_file_xpm;
				break;
			case S_IFLNK:
				if (fileptr->linkto)
				{
					item.pixmap = small_lfile_xpm;
					item.mask = mask_small_lfile_xpm;
				}
				else
				{
					item.pixmap = small_lbad_xpm;
					item.mask = mask_small_lbad_xpm;
				}
				break;
			default:
				item.pixmap = XmUNSPECIFIED_PIXMAP;
				item.mask = XmUNSPECIFIED_PIXMAP;
				break;
		}
	}
	item.text = NULL;
	item.xmlabel = NULL;
	item.UserDataPointer = NULL;

	XmNlItBoxSetItem(w, &item, valuemask, n);
}

int CheckInsertPositon(IfaceBranche *IbPtr, struct filedata * fileref, struct filedata * files)
{


	switch (IbPtr->SortingCategory) 
	{
		case SORTING_NAME:
				if (IbPtr->SortingType == SORTING_ASCEND)
				{
					return strcmp(fileref->name, files->name);
				}
				else
				{
					return strcmp(files->name, fileref->name);
				}
				break;
		case SORTING_DATE:
				if (IbPtr->SortingType == SORTING_ASCEND)
				{
					if (fileref->info->f_mtime < files->info->f_mtime)
						return -1;
					else
						if (fileref->info->f_mtime == files->info->f_mtime)
							return 0;
						else
							return 1;
				}
				else
				{
					if (fileref->info->f_mtime < files->info->f_mtime)
						return 1;
					else
						if (fileref->info->f_mtime == files->info->f_mtime)
							return 0;
						else
							return -1;
				}
				break;
		case SORTING_SIZE:
				if (IbPtr->SortingType == SORTING_ASCEND)
				{
					if (fileref->info->f_size < files->info->f_size)
						return -1;
					else
						if (fileref->info->f_size == files->info->f_size)
							return 0;
						else
							return 1;
				}
				else
				{
					if (fileref->info->f_size < files->info->f_size)
						return 1;
					else
						if (fileref->info->f_size == files->info->f_size)
							return 0;
						else
							return -1;
				}
				break;
			default:
				return 0;
				break;
	}
	
}


void DetailItemInsert(IfaceBranche * IbPtr, struct filedata * fileref)
{
	char thisnum[4], fullpath[120];
	int m;
	bxfm_ftype * mgtype;
	int external_pix = 0;
//	unsigned char valuemask = 0 | CellXmString | CellPixmap | CellMask | CellUserData | CellCharString;
	unsigned char valuemask = 0 | CellXmString | CellPixmap | CellMask | CellUserData ;
	struct filedata * files;
	XmNlCell data_massiv[35];
	char tmp_str[TMP_CHAR_BUF_SIZE];
	int item_is_directory = 0, inserted_ok = 0;
	int start_row = 0, num_row;
	int i, n;
	Widget file_view_wid;
	XmNlCell cell;


	if (IbPtr->CurrentViewType != DETAIL_VIEW)
		return ;
	mgtype = fileref->magic;

	if (mgtype != NULL && mgtype->small_icon_name) 
	{
#ifdef DEBUG
		printf("--------Magic found %p\n", mgtype);
#endif
		if (mgtype->small_pixmap > 2)
		{
#ifdef DEBUG
			printf("---------External pix found %lx %lx\n", mgtype->small_pixmap, mgtype->small_mask);
#endif
			data_massiv[0].pixmap = mgtype->small_pixmap;
			data_massiv[0].mask = mgtype->small_mask;
		}
		else
		{
			data_massiv[0].pixmap = XmUNSPECIFIED_PIXMAP;
			data_massiv[0].mask = XmUNSPECIFIED_PIXMAP;
		}
	}
	if (mgtype == NULL || (mgtype && !mgtype->small_icon_name))
	{
#ifdef DEBUG
		printf("--------Magic not found %p\n", mgtype);
#endif
		switch (fileref->filetype & S_IFMT) 
		{
			case S_IFDIR:
				data_massiv[0].pixmap = small_dir_xpm;
				data_massiv[0].mask = mask_small_dir_xpm;
				break ;
			case (S_IFDIR | S_IFLNK):
				data_massiv[0].pixmap = small_ldir_xpm;
				data_massiv[0].mask = mask_small_ldir_xpm;
				break ;
			case S_IFREG:
				data_massiv[0].pixmap = small_file_xpm;
				data_massiv[0].mask = mask_small_file_xpm;
				break ;
			case S_IFLNK:
				if (fileref->linkto)
				{
					data_massiv[0].pixmap = small_lfile_xpm;
					data_massiv[0].mask = mask_small_lfile_xpm;
				}
				else
				{
					data_massiv[0].pixmap = small_lbad_xpm;
					data_massiv[0].mask = mask_small_lbad_xpm;
				}
				break ;
			default:
				data_massiv[0].pixmap = XmUNSPECIFIED_PIXMAP;
				data_massiv[0].mask = XmUNSPECIFIED_PIXMAP;
				break;
		}
#ifdef DEBUG
			printf("---------Internal pix found %lx %lx\n", data_massiv[0].pixmap, data_massiv[0].mask);
#endif
	}
			
	data_massiv[0].text = (char *) NULL;
	data_massiv[0].xmlabel = NULL;
	data_massiv[0].UserDataPointer = (void *) fileref;

	data_massiv[1].text = (char *) NULL;
	data_massiv[1].xmlabel = XmStringCreateLocalized(fileref->name);
	data_massiv[1].pixmap = XmUNSPECIFIED_PIXMAP;
	data_massiv[1].mask = XmUNSPECIFIED_PIXMAP;

	data_massiv[2].text = (char *) NULL;
	if (!S_ISDIR(fileref->info->f_perm))
	{
		if (NULL != get_human_readable_size(fileref->info->f_size, tmp_str, 0))
			data_massiv[2].xmlabel = XmStringCreateLocalized(tmp_str);
		else
			data_massiv[2].xmlabel = XmStringCreateLocalized("-");
	}
	else
		data_massiv[2].xmlabel = XmStringCreateLocalized("-");

	data_massiv[2].pixmap = XmUNSPECIFIED_PIXMAP;
	data_massiv[2].mask = XmUNSPECIFIED_PIXMAP;

	data_massiv[3].text = (char *) NULL;
	if (NULL != get_human_readable_time(&(fileref->info->f_mtime), tmp_str))
		data_massiv[3].xmlabel = XmStringCreateLocalized(tmp_str);
	else
		data_massiv[3].xmlabel = XmStringCreateLocalized("-");

	data_massiv[3].pixmap = XmUNSPECIFIED_PIXMAP;
	data_massiv[3].mask = XmUNSPECIFIED_PIXMAP;

//	data_massiv[4].text = (char *) files[n].info->f_perm;
	data_massiv[4].text = (char *) NULL;
	if (NULL != get_human_readable_permission(fileref->info->f_perm, tmp_str))
		data_massiv[4].xmlabel = XmStringCreateLocalized(tmp_str);
	else
		data_massiv[4].xmlabel = XmStringCreateLocalized("-");
	
	data_massiv[4].pixmap = XmUNSPECIFIED_PIXMAP;
	data_massiv[4].mask = XmUNSPECIFIED_PIXMAP;

	data_massiv[5].text = (char *) NULL;
	if (NULL != get_human_readable_owner(fileref->info->f_owner, tmp_str))
		data_massiv[5].xmlabel = XmStringCreateLocalized(tmp_str);
	else
		data_massiv[5].xmlabel = XmStringCreateLocalized("-");

	data_massiv[5].pixmap = XmUNSPECIFIED_PIXMAP;
	data_massiv[5].mask = XmUNSPECIFIED_PIXMAP;

	data_massiv[6].text = (char *) NULL;
	if (NULL != get_human_readable_ownergr(fileref->info->f_owngrp, tmp_str))
		data_massiv[6].xmlabel = XmStringCreateLocalized(tmp_str);
	else
		data_massiv[6].xmlabel = XmStringCreateLocalized("-");

	data_massiv[6].pixmap = XmUNSPECIFIED_PIXMAP;
	data_massiv[6].mask = XmUNSPECIFIED_PIXMAP;


	if (S_ISDIR(fileref->filetype) || CHECK_IS_DIR_LNK(fileref->filetype))
		item_is_directory = 1;
		
	file_view_wid = XmNlListGetRCWidget(IbPtr->fm_scroll_win);

	XtVaGetValues(file_view_wid,
						XmNitemCount, &num_row,
						NULL);

	if (IbPtr->ParentDirShow)
		start_row++;

	if (IbPtr->CurrentDirShow)
		start_row++;

	for (i = start_row; i < num_row; i++)
	{
		XmNlResColGetCell(file_view_wid, &cell, CellUserData, 0, i);
		files = (struct filedata *) cell.UserDataPointer;
		if (item_is_directory)
		{
			if (!S_ISDIR(files->filetype) && !CHECK_IS_DIR_LNK(files->filetype))
			{
				XmNlResColInsertRow(file_view_wid, data_massiv, i, valuemask);
				inserted_ok = 1;
				break ;
			}
			if (S_ISDIR(files->filetype) || CHECK_IS_DIR_LNK(files->filetype))
			{
				n = CheckInsertPositon(IbPtr, fileref, files);
				if (n <= 0)
				{
					XmNlResColInsertRow(file_view_wid, data_massiv, i, valuemask);
					inserted_ok = 1;
					break ;
				}
			}
		}
		else
		{
			if (S_ISDIR(files->filetype) || CHECK_IS_DIR_LNK(files->filetype))
				continue ;
				
			n = CheckInsertPositon(IbPtr, fileref, files);
			if (n <= 0)
			{
				XmNlResColInsertRow(file_view_wid, data_massiv, i, valuemask);
				inserted_ok = 1;
				break ;
			}
		}
	}

	if (!inserted_ok)
	{
		XmNlListAddRows(IbPtr->fm_scroll_win, data_massiv, 1, valuemask);
	}

	XmStringFree(data_massiv[1].xmlabel);
	XmStringFree(data_massiv[2].xmlabel);
	XmStringFree(data_massiv[3].xmlabel);
	XmStringFree(data_massiv[4].xmlabel);
	XmStringFree(data_massiv[5].xmlabel);
	XmStringFree(data_massiv[6].xmlabel);
}


void DetailItemSetIcon(IfaceBranche * IbPtr, int n)
{
	char thisnum[4], fullpath[120];
	int m;
	bxfm_ftype * mgtype;
	int external_pix = 0;
	unsigned char valuemask = 0 | CellPixmap | CellMask ;
	struct filedata * fileptr;
	XmNlCell cell;
	Widget w;
	Boolean cell_ok;

	if (IbPtr->CurrentViewType != DETAIL_VIEW)
		return ;

	w = XmNlListGetRCWidget(IbPtr->fm_scroll_win);

	cell_ok = XmNlResColGetCell(w, &cell, CellUserData, 0, n);

	if (!cell_ok)
		return ;
		
	fileptr = (struct filedata *) cell.UserDataPointer;
	mgtype = fileptr->magic;

	if (mgtype != NULL && mgtype->small_icon_name) 
	{
#ifdef DEBUG
		printf("--------Magic found %p\n", mgtype);
#endif
		if (mgtype->small_pixmap > 2)
		{
#ifdef DEBUG
			printf("---------External pix found %lx %lx\n", mgtype->small_pixmap, mgtype->small_mask);
#endif
			cell.pixmap = mgtype->small_pixmap;
				cell.mask = mgtype->small_mask;
		}
		else
		{
			cell.pixmap = XmUNSPECIFIED_PIXMAP;
			cell.mask = XmUNSPECIFIED_PIXMAP;
		}
	}
	if (mgtype == NULL || (mgtype && !mgtype->small_icon_name)) 
	{
		switch (fileptr->filetype & S_IFMT) 
		{
			case S_IFDIR:
				cell.pixmap = small_dir_xpm;
				cell.mask = mask_small_dir_xpm;
				break ;
			case (S_IFDIR | S_IFLNK):
				cell.pixmap = small_ldir_xpm;
				cell.mask = mask_small_ldir_xpm;
				break ;
			case S_IFREG:
				cell.pixmap = small_file_xpm;
				cell.mask = mask_small_file_xpm;
				break ;
			case S_IFLNK:
				if (fileptr->linkto)
				{
					cell.pixmap = small_lfile_xpm;
					cell.mask = mask_small_lfile_xpm;
				}
				else
				{
					cell.pixmap = small_lbad_xpm;
					cell.mask = mask_small_lbad_xpm;
				}
				break ;
			default:
				cell.pixmap = XmUNSPECIFIED_PIXMAP;
				cell.mask = XmUNSPECIFIED_PIXMAP;
				break;
		}
#ifdef DEBUG
		printf("---------Internal pix found %lx %lx\n", cell.pixmap, cell.mask);
#endif
	}
			
	cell.text = (char *) NULL;
	cell.xmlabel = NULL;
	cell.UserDataPointer = NULL;
		
		
	XmNlResColSetCell(w, &cell, valuemask, 0, n);
}


void ItemInsert(IfaceBranche * IbPtr, struct filedata * fileref)
{
	if (IbPtr->CurrentViewType == LARGE_VIEW)
	{
		LargeItemInsert(IbPtr, fileref);
		return;
	}
	if (IbPtr->CurrentViewType == SMALL_VIEW)
	{
		SmallItemInsert(IbPtr, fileref);
		return;
	}
	if (IbPtr->CurrentViewType == DETAIL_VIEW)
	{
		DetailItemInsert(IbPtr, fileref);
		return;
	}
}


void ApplyMagicIconToItem(IfaceBranche * IbPtr, int n)
{
	if (IbPtr->CurrentViewType == LARGE_VIEW)
	{
		LargeItemSetIcon(IbPtr, n);
		return;
	}
	if (IbPtr->CurrentViewType == SMALL_VIEW)
	{
		SmallItemSetIcon(IbPtr, n);
		return;
	}
	if (IbPtr->CurrentViewType == DETAIL_VIEW)
	{
		DetailItemSetIcon(IbPtr, n);
		return;
	}
}


int DeleteItemFromFileView(IfaceBranche * IbPtr, struct filedata * fileref)
{
	struct filedata * fileptr;
	int i, num_row, start_row = 0;
	Widget w;
	XmNlCell cell;
	int found = 0, item_is_directory = 0;;
	Boolean cell_ok;
	

#ifdef DEBUG
	printf("DeleteItemFromFileView: %s\n", fileref->name);
#endif


	w = FindActiveInfoDialog(IbPtr, fileref);
	if (w)
	{
#ifdef DEBUG
		printf("DeleteItemFromFileView: dialog found\n");
#endif
		XtDestroyWidget(w);
	}

	if (IbPtr->CurrentViewType == LARGE_VIEW || IbPtr->CurrentViewType == SMALL_VIEW)
	{
		w = XmNlListGetIBWidget(IbPtr->fm_scroll_win);
	}
	else
	{
		w = XmNlListGetRCWidget(IbPtr->fm_scroll_win);
	}

	if (!w)
		return 1;

	XtVaGetValues(w, XmNitemCount, &num_row, NULL);

	if (IbPtr->ParentDirShow)
		start_row++;

	if (IbPtr->CurrentDirShow)
		start_row++;

	for (i = start_row; i < num_row; i++)
	{
		if (IbPtr->CurrentViewType == DETAIL_VIEW)
			cell_ok = XmNlResColGetCell(w, &cell, CellUserData, 0, i);
		else
			cell_ok = XmNlItBoxGetItem(w, &cell, CellUserData, i);

		if (!cell_ok)
			return 1;

		fileptr = (struct filedata *) cell.UserDataPointer;
		
		if (0 == strcmp(fileptr->name, fileref->name))
		{
			found = 1;

			if (IbPtr->CurrentViewType == DETAIL_VIEW)
				XmNlResColDeleteRows(w, i, 1);
		else
				XmNlItBoxDeleteItems(w, &i, 1);

			break ;
		}
	}
	
	if (!found)
		return 1;
		
	if (S_ISDIR(fileptr->filetype) || CHECK_IS_DIR_LNK(fileptr->filetype))
		item_is_directory = 1;
	
	if (item_is_directory)
	{
		for (i = 0; i < IbPtr->ndirs; i++)
		{
//			fileptr = IbPtr->dirs_ptr[i];
//			if ((strcmp(fileptr->name, fileref->name)) == 0)
			if (IbPtr->dirs_ptr[i] == fileptr)
			{
#ifdef DEBUG
				printf("DeleteItemFromFileView: delete from directory list %d %s %s\n", i, fileref->name, (IbPtr->dirs_ptr[i])->name);
#endif
			
				if (fileptr->info)
					free(fileptr->info);
					
				free(fileptr->name);
				if (fileptr->linkto)
					free(fileptr->linkto);

				free(fileptr);
				
				if (i < (IbPtr->ndirs - 1) && IbPtr->ndirs != 1) 
					memmove((void *) (IbPtr->dirs_ptr + i), (void *) (IbPtr->dirs_ptr + i + 1), 
							sizeof(struct filedata *) * (IbPtr->ndirs - i -1));
								
				IbPtr->ndirs--;
#ifdef DEBUG
				printf("DeleteItemFromFileView: directory %d ok\n", IbPtr->ndirs);
#endif
				return 0;
			}
		}
	}
	else
	{
		for (i = 0; i < IbPtr->nfiles; i++)
		{
//			fileptr = IbPtr->files_ptr[i];
//			if ((strcmp(fileptr->name, fileref->name)) == 0)
			if (IbPtr->files_ptr[i] == fileptr)
			{
#ifdef DEBUG
				printf("DeleteItemFromFileView: delete from files list %d %s %s\n", i, fileref->name, (IbPtr->files_ptr[i])->name);
#endif
			
				if (fileptr->info)
					free(fileptr->info);
					
				free(fileptr->name);
				if (fileptr->linkto)
					free(fileptr->linkto);

				free(fileptr);
				
				if (i < (IbPtr->nfiles - 1) && IbPtr->nfiles != 1) 
					memmove((void *) (IbPtr->files_ptr + i), (void *) (IbPtr->files_ptr + i + 1), 
								sizeof(struct filedata *) * (IbPtr->nfiles - i -1));
								
				IbPtr->nfiles--;
#ifdef DEBUG
				printf("DeleteItemFromFileView: files %d ok\n", IbPtr->nfiles);
#endif
			return 0;
			}
		}
	}
	return 1;
}

int AddItemToFileView(IfaceBranche * IbPtr, struct filedata * fileref)
{
	int i, j, n, limit = 0;
	int found = 0, item_is_directory = 0;
	struct filedata ** fileptr1, * fileptr2;

#ifdef DEBUG
	if (fileref->name)
		printf("Add file %s from inotify queue\n", fileref->name);
	else
		printf("Add file NONAME from inotify queue\n");
#endif

	if (0 == IbPtr->nfiles && 0 == IbPtr->ndirs)
	{
		if (S_ISDIR(fileref->filetype) || CHECK_IS_DIR_LNK(fileref->filetype)){
			if (0 == IbPtr->dirsallocated)
			{
				IbPtr->dirsallocated += 10;
				IbPtr->dirs_ptr = calloc(IbPtr->dirsallocated, sizeof(struct filedata *));
			}
			IbPtr->ndirs++;
			IbPtr->dirs_ptr[0] = fileref;
		}
		else
		{
			if (0 == IbPtr->filesallocated)
			{
				IbPtr->filesallocated += 10;
				IbPtr->files_ptr = calloc(IbPtr->filesallocated, sizeof(struct filedata *));
			}
			IbPtr->nfiles++;
			IbPtr->files_ptr[0] = fileref;
		}

		ItemAdd(IbPtr, 0, 1);	

#ifdef DEBUG
	if (fileref->name)
		printf("Add file %s from inotify queue ok\n", fileref->name);
	else
		printf("Add file NONAME from inotify queue ok\n");
#endif
		return 1;
	}
	
	n = 0;
	if (S_ISDIR(fileref->filetype) || CHECK_IS_DIR_LNK(fileref->filetype))
	{
		item_is_directory = 1;
		fileptr1 = IbPtr->dirs_ptr;
		limit = IbPtr->ndirs;
	}
	else
	{
		fileptr1 = IbPtr->files_ptr;
		limit = IbPtr->nfiles;
	}

	for (i = 0; i < limit; i++)
	{
		fileptr2 = fileptr1[i];
#ifdef DEBUG
		printf("|i=%d\t|name = %s\ttype = %d\tname = %s\ttype = %d|\n", i, fileptr2->name, fileptr2->filetype, fileref->name, fileref->filetype);
#endif

		j = strcmp(fileptr2->name, fileref->name);

		if (j == 0)
		{
			found = 1;
			break;
		}
	}

/* Added file found, may be moved when replacing */
	if (found && j == 0)
	{
#ifdef DEBUG
	printf("File %s is already found\n", fileref->name);
#endif
		return CloseItemInFileView(IbPtr, fileref);
	}

	if (item_is_directory)
	{
		if ((IbPtr->ndirs + 1) > IbPtr->dirsallocated)
		{
			IbPtr->dirsallocated += 100;
			IbPtr->dirs_ptr = realloc(IbPtr->dirs_ptr, sizeof(struct filedata *) * IbPtr->dirsallocated);
		}
		IbPtr->dirs_ptr[IbPtr->ndirs] = fileref;
		IbPtr->ndirs++;
	}
	else
	{
		if ((IbPtr->nfiles + 1) > IbPtr->filesallocated)
		{
			IbPtr->filesallocated += 100;
			IbPtr->files_ptr = realloc(IbPtr->files_ptr, sizeof(struct filedata *) * IbPtr->filesallocated);
		}
		IbPtr->files_ptr[IbPtr->nfiles] = fileref;
		IbPtr->nfiles++;
	}	

	ItemInsert(IbPtr, fileref);
	
#ifdef DEBUG
	if (fileref->name)
		printf("Add file %s from inotify queue ok\n", fileref->name);
	else
		printf("Add file NONAME from inotify queue ok\n");
#endif
	return 1;
}


int ChangeAttribInFileView(IfaceBranche * IbPtr, struct filedata * fileref)
{
	int i, j;
	int num_row;
	int found = 0;
	struct filedata * fileptr;
	unsigned char valuemask = 0 | CellXmString ;
	XmNlCell cell;
	Widget wid;
	unsigned char change_value = 0;
	char char_str[TMP_CHAR_BUF_SIZE];
	Boolean cell_ok;

#ifdef DEBUG
	if (fileref->name)
		printf("Change attrib for file %s from inotify queue\n", fileref->name);
	else
		printf("Change attrib for file NONAME from inotify queue\n");
#endif

	if (IbPtr->CurrentViewType == DETAIL_VIEW)
	{
		wid = XmNlListGetRCWidget(IbPtr->fm_scroll_win);

		XtVaGetValues(wid, XmNitemCount, &num_row,	NULL);
	}
	else
	{
		wid = XmNlListGetIBWidget(IbPtr->fm_scroll_win);

		XtVaGetValues(wid, XmNitemCount, &num_row,	NULL);
	}

	for (i = 0; i < num_row; i++)
	{
		if (IbPtr->CurrentViewType == DETAIL_VIEW)
			cell_ok = XmNlResColGetCell(wid, &cell, CellUserData, 0, i);
		else
			cell_ok = XmNlItBoxGetItem(wid, &cell, CellUserData, i);
			
		if (!cell_ok)
			return 0;

		fileptr = (struct filedata *) cell.UserDataPointer;

		if ((strcmp(fileptr->name, fileref->name)) == 0)
		{
			found = 1;
			break;
		}
	}

	if (!found)
	{
#ifdef DEBUG
	if (fileref->name)
		printf("Change attrib for file %s from inotify queue ok\n", fileref->name);
	else
		printf("Change attrib for file NONAME from inotify queue ok\n");
#endif
		return 0;
	}

	wid = FindActiveInfoDialog(IbPtr, fileref);


	if (fileptr->info)
	{
		if (fileref->info)
		{
			if (fileptr->info->f_perm != fileref->info->f_perm)
			{
				change_value = change_value | CHANGE_PERMISSION;
				if (wid)
					ApplyPermChanges(wid, fileref);
			}
			if (fileptr->info->f_owner != fileref->info->f_owner)
			{
				change_value = change_value | CHANGE_UID;
				if (wid)
					ApplyOwnerChanges(wid, fileref);
			}
			if (fileptr->info->f_owngrp != fileref->info->f_owngrp)
			{
				change_value = change_value | CHANGE_GID;
				if (wid)
					ApplyGrpChanges(wid, fileref);
			}
			if (fileptr->info->f_mtime != fileref->info->f_mtime)
				change_value = change_value | CHANGE_DATE;
		}
		free(fileptr->info);
	}

	fileptr->info = fileref->info;
	fileptr->magic = fileref->magic;
	
/************** !!!!!!!! **************/
	if (fileptr->linkto)
	{
		free(fileptr->linkto);
		fileptr->linkto = fileref->linkto;
	}
	
	if (fileref->name)
		free(fileref->name);
		
		
	if (0 == change_value)
	{
#ifdef DEBUG
		if (fileptr->name)
			printf("Close file %s from inotify queue ok\n", fileptr->name);
		else
			printf("Close file NONAME from inotify queue ok\n");
#endif
		
		free(fileref);

		return 1;
	}
	
	if (IbPtr->CurrentViewType == DETAIL_VIEW && fileptr->info)
	{
		wid = XmNlListGetRCWidget(IbPtr->fm_scroll_win);
		
		if (change_value & CHANGE_SIZE)
		{
			cell.text = (char *) NULL;
			if (!S_ISDIR(fileptr->info->f_perm))
			{
				if (NULL != get_human_readable_size(fileptr->info->f_size, char_str, 0))
					cell.xmlabel = XmStringCreateLocalized(char_str);
				else
					cell.xmlabel = XmStringCreateLocalized("-");
			}
			else
				cell.xmlabel = XmStringCreateLocalized("-");
			cell.pixmap = XmUNSPECIFIED_PIXMAP;
			cell.mask = XmUNSPECIFIED_PIXMAP;

			XmNlResColSetCell(wid, &cell, valuemask, 2, i);
//		XmNlListSetCell(IbPtr->fm_scroll_win, i, 2, &cell);

			if (cell.xmlabel) 
				XmStringFree(cell.xmlabel);
		}

		if (change_value & CHANGE_DATE)
		{
			cell.text = (char *) NULL;
			if (NULL != get_human_readable_time(&(fileptr->info->f_mtime), char_str))
				cell.xmlabel = XmStringCreateLocalized(char_str);
			else
				cell.xmlabel = XmStringCreateLocalized("-");
			cell.pixmap = XmUNSPECIFIED_PIXMAP;
			cell.mask = XmUNSPECIFIED_PIXMAP;

			XmNlResColSetCell(wid, &cell, valuemask, 3, i);
			
			if (cell.xmlabel)
				XmStringFree(cell.xmlabel);
		}

		if (change_value & CHANGE_PERMISSION)
		{
			cell.text = (char *) NULL;
			if (NULL != get_human_readable_permission(fileptr->info->f_perm, char_str))
				cell.xmlabel = XmStringCreateLocalized(char_str);
			else
				cell.xmlabel = XmStringCreateLocalized("-");
			cell.pixmap = XmUNSPECIFIED_PIXMAP;
			cell.mask = XmUNSPECIFIED_PIXMAP;

			XmNlResColSetCell(wid, &cell, valuemask, 4, i);
			
			if (cell.xmlabel)
				XmStringFree(cell.xmlabel);
		}

		if (change_value & CHANGE_UID)
		{
			cell.text = (char *) NULL;
			if (get_human_readable_owner(fileptr->info->f_owner, char_str))
			{
				cell.xmlabel = XmStringCreateLocalized(char_str);
				cell.pixmap = XmUNSPECIFIED_PIXMAP;
				cell.mask = XmUNSPECIFIED_PIXMAP;

				XmNlResColSetCell(wid, &cell, valuemask, 5, i);
				
				if (cell.xmlabel)
					XmStringFree(cell.xmlabel);
			}
		}

		if (change_value & CHANGE_GID)
		{
			cell.text = (char *) NULL;
			if (get_human_readable_ownergr(fileptr->info->f_owngrp, char_str))
			{
				cell.xmlabel = XmStringCreateLocalized(char_str);
				cell.pixmap = XmUNSPECIFIED_PIXMAP;
				cell.mask = XmUNSPECIFIED_PIXMAP;

				XmNlResColSetCell(wid, &cell, valuemask, 6, i);
				
				if (cell.xmlabel)
					XmStringFree(cell.xmlabel);
			}
		}
	}
	
	if ((fileref->filetype & S_IFMT) == S_IFLNK)
	{
		
	}
	
#ifdef DEBUG
	if (fileptr->name)
		printf("Close file %s from inotify queue ok\n", fileptr->name);
	else
		printf("Close file NONAME from inotify queue ok\n");
#endif
		
	free(fileref);

	return 1;
}



int CloseItemInFileView(IfaceBranche * IbPtr, struct filedata * fileref)
{
	int i, j, num_row;
	int found = 0;
	struct filedata * fileptr;
	unsigned char valuemask = 0 | CellXmString ;
	XmNlCell cell;
	Widget wid;
	Boolean cell_ok;
	char char_str[TMP_CHAR_BUF_SIZE];
	unsigned char change_value = 0;

#ifdef DEBUG
	if (fileref->name)
		printf("Close file %s from inotify queue\n", fileref->name);
	else
		printf("Close file NONAME from inotify queue\n");
#endif


	if (IbPtr->CurrentViewType == DETAIL_VIEW)
	{
		wid = XmNlListGetRCWidget(IbPtr->fm_scroll_win);

		XtVaGetValues(wid, XmNitemCount, &num_row,	NULL);
	}
	else
	{
		wid = XmNlListGetIBWidget(IbPtr->fm_scroll_win);

		XtVaGetValues(wid, XmNitemCount, &num_row,	NULL);
	}
	


	for (i = 0; i < num_row; i++)
	{
		if (IbPtr->CurrentViewType == DETAIL_VIEW)
			cell_ok = XmNlResColGetCell(wid, &cell, CellUserData, 0, i);
		else
			cell_ok = XmNlItBoxGetItem(wid, &cell, CellUserData, i);
			
		if (!cell_ok)
			return 0;

		fileptr = (struct filedata *) cell.UserDataPointer;

		if ((strcmp(fileptr->name, fileref->name)) == 0)
		{
			found = 1;
			break;
		}
	}


	if (!found)
	{
#ifdef DEBUG
		if (fileref->name)
			printf("Close file %s from inotify queue ok\n", fileref->name);
		else
			printf("Close file NONAME from inotify queue ok\n");
#endif
		return 0;
	}

	wid = FindActiveInfoDialog(IbPtr, fileref);

	if (fileptr->info)
	{
		if (fileref->info)
		{
			if (fileptr->info->f_size != fileref->info->f_size)
			{
				change_value = change_value | CHANGE_SIZE;
				if (wid)
					ApplySizeChanges(wid, fileref);
			}
			if (fileptr->info->f_perm != fileref->info->f_perm)
			{
				change_value = change_value | CHANGE_PERMISSION;
			}
			if (fileptr->info->f_owner != fileref->info->f_owner)
			{
				change_value = change_value | CHANGE_UID;
			}
			if (fileptr->info->f_owngrp != fileref->info->f_owngrp)
			{
				change_value = change_value | CHANGE_GID;
			}
			if (fileptr->info->f_mtime != fileref->info->f_mtime)
			{
				change_value = change_value | CHANGE_DATE;
				if (wid)
					ApplyDateChanges(wid, fileref, 2);
			}
		}
		free(fileptr->info);
	}

	fileptr->info = fileref->info;
	
	if (fileptr->magic != fileref->magic)
	{
		change_value = change_value | CHANGE_MAGIC;
	}
	
	fileptr->magic = fileref->magic;
	
/************** !!!!!!!! **************/
	if (fileptr->linkto)
	{
		free(fileptr->linkto);
		fileptr->linkto = fileref->linkto;
	}
	
	if (fileref->name)
		free(fileref->name);

	
	if (0 == change_value)
	{
#ifdef DEBUG
		if (fileptr->name)
			printf("Close file %s from inotify queue ok\n", fileptr->name);
		else
			printf("Close file NONAME from inotify queue ok\n");
#endif
		
		free(fileref);

		return 1;
	}
	
	if (fileptr->magic && (change_value & CHANGE_MAGIC))
		ApplyMagicIconToItem(IbPtr, i);
	
	if (IbPtr->CurrentViewType == DETAIL_VIEW && fileptr->info)
	{
		wid = XmNlListGetRCWidget(IbPtr->fm_scroll_win);
		
		if (change_value & CHANGE_SIZE)
		{
			cell.text = (char *) NULL;
			if (!S_ISDIR(fileptr->info->f_perm))
			{
				if (get_human_readable_size(fileptr->info->f_size, char_str, 0))
					cell.xmlabel = XmStringCreateLocalized(char_str);
				else
					cell.xmlabel = XmStringCreateLocalized("-");
			}
			else
				cell.xmlabel = XmStringCreateLocalized("-");

			cell.pixmap = XmUNSPECIFIED_PIXMAP;
			cell.mask = XmUNSPECIFIED_PIXMAP;

			XmNlResColSetCell(wid, &cell, valuemask, 2, i);
//		XmNlListSetCell(IbPtr->fm_scroll_win, i, 2, &cell);

			if (cell.xmlabel) 
				XmStringFree(cell.xmlabel);
		}

		if (change_value & CHANGE_DATE)
		{
			cell.text = (char *) NULL;
			if (get_human_readable_time(&(fileptr->info->f_mtime), char_str))
				cell.xmlabel = XmStringCreateLocalized(char_str);
			else
				cell.xmlabel = XmStringCreateLocalized("-");
			cell.pixmap = XmUNSPECIFIED_PIXMAP;
			cell.mask = XmUNSPECIFIED_PIXMAP;

			XmNlResColSetCell(wid, &cell, valuemask, 3, i);
			
			if (cell.xmlabel)
				XmStringFree(cell.xmlabel);
		}

		if (change_value & CHANGE_PERMISSION)
		{
			cell.text = (char *) NULL;
			if (get_human_readable_permission(fileptr->info->f_perm, char_str))
				cell.xmlabel = XmStringCreateLocalized(char_str);
			else
				cell.xmlabel = XmStringCreateLocalized("-");
			cell.pixmap = XmUNSPECIFIED_PIXMAP;
			cell.mask = XmUNSPECIFIED_PIXMAP;

			XmNlResColSetCell(wid, &cell, valuemask, 4, i);
			
			if (cell.xmlabel)
				XmStringFree(cell.xmlabel);
		}

		if (change_value & CHANGE_UID)
		{
			cell.text = (char *) NULL;
			if (get_human_readable_owner(fileptr->info->f_owner, char_str))
			{
				cell.xmlabel = XmStringCreateLocalized(char_str);
				cell.pixmap = XmUNSPECIFIED_PIXMAP;
				cell.mask = XmUNSPECIFIED_PIXMAP;

				XmNlResColSetCell(wid, &cell, valuemask, 5, i);
				
				if (cell.xmlabel)
					XmStringFree(cell.xmlabel);
			}
		}

		if (change_value & CHANGE_GID)
		{
			cell.text = (char *) NULL;
			if (get_human_readable_ownergr(fileptr->info->f_owngrp, char_str))
			{
				cell.xmlabel = XmStringCreateLocalized(char_str);
				cell.pixmap = XmUNSPECIFIED_PIXMAP;
				cell.mask = XmUNSPECIFIED_PIXMAP;

				XmNlResColSetCell(wid, &cell, valuemask, 6, i);
				
				if (cell.xmlabel)
					XmStringFree(cell.xmlabel);
			}
		}
	}
	
	if ((fileref->filetype & S_IFMT) == S_IFLNK)
	{
		
	}
	
#ifdef DEBUG
	if (fileptr->name)
		printf("Close file %s from inotify queue ok\n", fileptr->name);
	else
		printf("Close file NONAME from inotify queue ok\n");
#endif
		
	free(fileref);

	return 1;
}

#endif

static void MenuItemSensitive(Widget menu, char * name, Boolean on)
{
	Widget wid;
	
	wid = XtNameToWidget(menu, name);
	if (wid)
		XtVaSetValues(wid, XmNsensitive, on, NULL);
}

static void MenuItemManage(Widget menu, char * name, Boolean on)
{
	Widget wid;
	
	wid = XtNameToWidget(menu, name);
	if (wid)
	{
		if (on)
			XtManageChild(wid);
		else
			XtUnmanageChild(wid);
	}
}

static void MenuSetClickedForItem(Widget menu, char * name, int clicked)
{
	Widget wid;
	MenuItemDesc * MenuItem;
	XtPointer ptr;
	
	wid = XtNameToWidget(menu, name);
	if (wid)
	{
		XtVaGetValues(wid, XmNuserData, &ptr, NULL);
		if (ptr)
		{
			MenuItem = (MenuItemDesc *) ptr;
			MenuItem->clicked = clicked;
		}
	}
}


static void MenuItemChange(Widget menu, char * name, char * label)
{
	Widget wid;
	XmString info_str;
	int nargs = 0;
	Arg args[5];
	
	wid = XtNameToWidget(menu, name);
	if (wid)
	{
		info_str = XmStringCreateLocalized(label);
							
		XtSetArg(args[nargs], XmNlabelString, info_str);
		nargs++;
		XtSetValues(wid, args, nargs);
		XtManageChild(wid);
		XmStringFree(info_str);
	}
}


void FilePopupHandlerCB (Widget w, XtPointer client_data, XtPointer call_data)
{
	XmPopupHandlerCallbackStruct * cb = (XmPopupHandlerCallbackStruct *) call_data;
	IfaceBranche * IbPtr = (IfaceBranche *) client_data;
	XButtonEvent *button_event;
	Widget scroll_list;
	int i, pos, item_num, * numbers, j;
	int ClickedToSelected = 0;

	struct filedata * fdp;
	bxfm_ftype * magicptr;
	alter_action * alter_ptr;
	unsigned char valuemask = 0 | CellUserData;
	XmNlCell item;

	int nargs=0;
	Arg args[5];
	static int intern_serial = 0;
	Widget menuA, menuB, menuC;

#ifdef DEBUG
	printf("Popup menu handler\n");
	printf("\t int serial %d\n", intern_serial);
	fflush(stdout);
	intern_serial++;
#endif

	scroll_list = XtParent(cb->target);
	
#ifdef DEBUG
	if (cb->target)
		printf("Widget: %s\n", XtName(cb->target));
#endif

	if (cb->reason == XmCR_POST)
	{
		button_event = (XButtonEvent *) cb->event;
#ifdef DEBUG
		printf("\t type %d\n", button_event->type);
		printf("\t serial %ld\n", button_event->serial);
		printf("\t x %d y %d\n", button_event->x, button_event->y);
#endif
		
		if (button_event->button == 3) 
		{
#ifdef DEBUG
			printf("3 button pressed\n");
			fflush(stdout);
#endif
	
			pos = XmNlListXYtoPos(scroll_list, button_event->x, button_event->y);
			
			item_num = 0;
			XtVaGetValues(IbPtr->fm_scroll_win, XmNselectedPositionCount, &item_num, XmNselectedPositions, &numbers, NULL);

			if (IbPtr->CurrentViewType == DETAIL_VIEW)
			{
				menuA = IbPtr->menuAdetail;
				menuB = IbPtr->menuBdetail;
			}
			else
			{
				menuA = IbPtr->menuAiconbox;
				menuB = IbPtr->menuBiconbox;
				menuC = IbPtr->menuCiconbox;
			}
			
			if (pos < 0)
			{
				if (item_num != 0)
				{
					MenuItemSensitive(menuB, "Copy", True);
					MenuItemSensitive(menuB, "Cut", True);
				}
				else
				{
					MenuItemSensitive(menuB, "Copy", False);
					MenuItemSensitive(menuB, "Cut", False);
				}

				if (0 == strcmp("/", IbPtr->current_wd))
				{
					MenuItemSensitive(menuB, "Info", False);
				}
				else
				{
					MenuItemSensitive(menuB, "Info", True);
				}

				if (IbPtr->CurrentViewType == DETAIL_VIEW)
					cb->menuToPost = IbPtr->menuBdetail;
				else
					cb->menuToPost = IbPtr->menuCiconbox;
				return ;
			}

			MenuSetClickedForItem(menuA, "Copy", pos);
			MenuSetClickedForItem(menuA, "Cut", pos);
			MenuSetClickedForItem(menuA, "Past", pos);
			MenuSetClickedForItem(menuA, "OpenInXterm", pos);
			MenuSetClickedForItem(menuA, "Info", pos);
			

			if (item_num < 1)
			{
				cb->menuToPost = NULL;
				return ;
			}
			for (i = 0; i < item_num; i++)
			{
				if (numbers[i] == pos)
					ClickedToSelected = 1;
			}
			if (!ClickedToSelected)
			{
				cb->menuToPost = NULL;
				return ;
			}
			
			if (item_num > 1)
			{
				PopupMenuItemOff(menuA, "Alt1");
				PopupMenuItemOff(menuA, "Alt2");
				PopupMenuItemOff(menuA, "Alt3");
				PopupMenuItemOff(menuA, "OpenInXterm");
				PopupMenuItemOff(menuA, "separator1");
				PopupMenuItemOff(menuA, "separator2");
				PopupMenuItemOff(menuA, "separator4");
				PopupMenuItemOff(menuA, "Info");
			}
			else
			{
				PopupMenuItemOn(menuA, "OpenInXterm");
				PopupMenuItemOn(menuA, "separator2");
				PopupMenuItemOn(menuA, "separator3");
				PopupMenuItemOn(menuA, "separator4");
				PopupMenuItemOn(menuA, "Info");

				XmNlListGetItem(scroll_list, &item, valuemask, pos);
				fdp = (struct filedata *) item.UserDataPointer;

				if ((fdp->filetype & S_IXUSR) || (fdp->filetype & S_IXGRP) || (fdp->filetype & S_IXOTH) &&
					(!S_ISDIR(fdp->filetype) && !CHECK_IS_DIR_LNK(fdp->filetype)))
				{
					MenuItemSensitive(menuA, "OpenInXterm", True);
				}

				if ((!(fdp->filetype & S_IXUSR) && !(fdp->filetype & S_IXGRP) && !(fdp->filetype & S_IXOTH)) ||
					S_ISDIR(fdp->filetype) || CHECK_IS_DIR_LNK(fdp->filetype))
				{
					MenuItemSensitive(menuA, "OpenInXterm", False);
				}
				
				magicptr = fdp->magic;
				if (magicptr && magicptr->big_icon_name)
				{
					alter_ptr = magicptr->alter_ptr;
					if (alter_ptr)
					{
						if (alter_ptr->label1)
						{
							MenuItemChange(menuA, "Alt1", alter_ptr->label1);
							j++;
						}
						else
						{
							PopupMenuItemOff(menuA, "Alt1");
						}
						
						if (alter_ptr->label2)
						{
							MenuItemChange(menuA, "Alt2", alter_ptr->label2);
							j++;
						}
						else
						{
							PopupMenuItemOff(menuA, "Alt2");
						}
						
						if (alter_ptr->label3)
						{
							MenuItemChange(menuA, "Alt3", alter_ptr->label3);
							j++;
						}
						else
						{
							PopupMenuItemOff(menuA, "Alt3");
						}

						if (j > 0)
						{
							PopupMenuItemOn(menuA, "separator1");
						}
						else
						{
							PopupMenuItemOff(menuA, "separator1");
						}
					}
					else
					{
						PopupMenuItemOff(menuA, "Alt1");
						PopupMenuItemOff(menuA, "Alt2");
						PopupMenuItemOff(menuA, "Alt3");
						PopupMenuItemOff(menuA, "separator1");
					}
				}
				else
				{
					PopupMenuItemOff(menuA, "Alt1");
					PopupMenuItemOff(menuA, "Alt2");
					PopupMenuItemOff(menuA, "Alt3");
					PopupMenuItemOff(menuA, "separator1");
				}
			}

		cb->menuToPost = menuA;
		}
	}
}


/*
void FilePopupMapCB (Widget w, XtPointer client_data, XtPointer call_data)
{
#ifdef DEBUG
	printf("Mapping for popup menu \n");
	fflush(stdout);
#endif
}

void FilePopupUnMapCB (Widget w, XtPointer client_data, XtPointer call_data)
{
#ifdef DEBUG
	printf("Unmapping for popup menu \n");
	fflush(stdout);
#endif
}
*/

void FilePopupDestroyCB (Widget w, XtPointer client_data, XtPointer call_data)
{
#ifdef DEBUG
	printf("Destroy Callback for popup menu %s pointer %p\n", XtName(w), client_data);
	fflush(stdout);
#endif
	MenuItemDesc * p1, * p2;
	
	p1 = (MenuItemDesc *) client_data;


	while(p1)
	{
		p2 = p1->next;
		free((void * ) p1);
		p1 = p2;
	}
}

void FilePopupChangeCB(Widget w, XtPointer client_data, XtPointer call_data)
{
	int i;
	int tp;
	int item_num, * numbers;
	struct filedata * fdp = NULL;
	bxfm_ftype * magicptr = NULL;
	alter_action * alter_ptr = NULL;
	char * fullpath = NULL;
	unsigned char valuemask = 0 | CellUserData;
	XmNlCell item;
	Boolean ok;
	IfaceBranche * IbPtr;
	MenuItemDesc * MenuItem;
	XmToggleButtonCallbackStruct *toggle_data = (XmToggleButtonCallbackStruct *) call_data;
	

	XtVaGetValues(w, XmNuserData, &MenuItem, NULL);
	IbPtr = MenuItem->IbPtr;
	tp = MenuItem->action;

	switch (tp)
	{
		case POPUP_NAME_SORT:
			if (toggle_data->set == XmSET)
			{
				XmToggleButtonSetState(IbPtr->sort_size_bt, FALSE, FALSE);
				XmToggleButtonSetState(IbPtr->sort_date_bt, FALSE, FALSE);
				IbPtr->SortingCategory = SORTING_NAME;
				ReSort(IbPtr);
			}
			else
			{
				XmToggleButtonSetState(IbPtr->sort_size_bt, TRUE, FALSE);
				XmToggleButtonSetState(IbPtr->sort_date_bt, FALSE, FALSE);
				IbPtr->SortingCategory = SORTING_SIZE;
				ReSort(IbPtr);
			}

			break;
		case POPUP_SIZE_SORT:
			if (toggle_data->set == XmSET)
			{
				XmToggleButtonSetState(IbPtr->sort_name_bt, FALSE, FALSE);
				XmToggleButtonSetState(IbPtr->sort_date_bt, FALSE, FALSE);
				IbPtr->SortingCategory = SORTING_SIZE;
				ReSort(IbPtr);
			}
			else
			{
				XmToggleButtonSetState(IbPtr->sort_date_bt, TRUE, FALSE);
				XmToggleButtonSetState(IbPtr->sort_name_bt, FALSE, FALSE);
				IbPtr->SortingCategory = SORTING_DATE;
				ReSort(IbPtr);
			}
			break;
		case POPUP_DATE_SORT:
			if (toggle_data->set == XmSET)
			{
				XmToggleButtonSetState(IbPtr->sort_size_bt, FALSE, FALSE);
				XmToggleButtonSetState(IbPtr->sort_name_bt, FALSE, FALSE);
				IbPtr->SortingCategory = SORTING_DATE;
				ReSort(IbPtr);
			}
			else
			{
				XmToggleButtonSetState(IbPtr->sort_name_bt, TRUE, FALSE);
				XmToggleButtonSetState(IbPtr->sort_size_bt, FALSE, FALSE);
				IbPtr->SortingCategory = SORTING_NAME;
				ReSort(IbPtr);
			}
			break;
		case POPUP_REVERSE_SORT:
			if (toggle_data->set == XmSET)
			{
				IbPtr->SortingType = SORTING_DESCEND;
				ReSort(IbPtr);
			}
			else
			{
				IbPtr->SortingType = SORTING_ASCEND;
				ReSort(IbPtr);
			}
			break;
		default: ;
	}
	return ;
}


void FilePopupActivateCB (Widget w, XtPointer client_data, XtPointer call_data)
{
	int i;
	int tp;
	int item_num, * numbers;
	struct filedata * fdp = NULL;
	bxfm_ftype * magicptr = NULL;
	alter_action * alter_ptr = NULL;
	char * fullpath = NULL;
	unsigned char valuemask = 0 | CellUserData;
	XmNlCell item;
	Boolean ok;
	IfaceBranche * IbPtr;
	MenuItemDesc * MenuItem;
	
	XtVaGetValues(w, XmNuserData, &MenuItem, NULL);
	IbPtr = MenuItem->IbPtr;
	tp = MenuItem->action;
	XtVaGetValues(IbPtr->fm_scroll_win, XmNselectedPositionCount, &item_num, XmNselectedPositions, &numbers, NULL);

	switch (tp)
	{
		case POPUP_IN_XTERM_ACTION:
			if (item_num == 1 && MenuItem->clicked == *numbers) 
			{
				ok = XmNlListGetItem(IbPtr->fm_scroll_win, &item, valuemask, *numbers);
				if (ok)
				{
					fdp = (struct filedata *) item.UserDataPointer;
					fullpath = (char *) calloc((strlen(IbPtr->current_wd) + 6 + strlen(fdp->name)), sizeof(char));
					if (fullpath)
					{
						sprintf(fullpath, "\'%s/%s\'", IbPtr->current_wd, fdp->name);
						exec_in_xterm_action(fullpath);
						free(fullpath);
					}
				}
			}
			break;
		case POPUP_XTERM_ACTION:
#ifdef DEBUG
			printf("Open xterm\n");
#endif
			if (MenuItem->clicked == -1) 
			{
				exec_xterm_action(IbPtr);
			}
			break;
		case POPUP_COPY:
			if (item_num > 0) 
			{
				char * CopyString;
				CopyString = MakeSelectList(1, IbPtr);
				if (CopyString)
				{
					CopyFile(CopyString, IbPtr);
					free(CopyString);
				}
			}
			break;
		case POPUP_CUT:
			if (item_num > 0) 
			{
				char * CopyString;
				CopyString = MakeSelectList(2, IbPtr);
				if (CopyString)
				{
					CopyFile(CopyString, IbPtr);
					free(CopyString);
				}
			}
#ifdef DEBUG
			printf("Cut activated for item %d\n", *numbers);
#endif
			break;
		case POPUP_PASTE:
#ifdef DEBUG
			printf("Paste activated for clicked %d\n", MenuItem->clicked);
#endif
			if (MenuItem->clicked == -1)
			{
				PasteFile(IbPtr, &_CopyToCurrentDir);
			}
			else
			{
				if (item_num == 1)
				{
					ok = XmNlListGetItem(IbPtr->fm_scroll_win, &item, valuemask, *numbers);
					if (ok)
					{
						fdp = (struct filedata *) item.UserDataPointer;
						if (fdp->filetype == 0)
						{
							PasteFile(IbPtr, &_CopyToSelectedDir);
						}
					}	
				}
			}
			break;
		case POPUP_DELETE:
			if (item_num > 0) 
			{
				char * DeleteString;
				DeleteString = MakeSelectList(3, IbPtr);
#ifdef DEBUG
				printf("DeleteFile, CopyString %s \n", DeleteString);
#endif
				if (DeleteString) 
				{
					DeleteFile(DeleteString, IbPtr);
					free(DeleteString);
				}
			}
			break;
		case POPUP_INFO:
#ifdef DEBUG
			printf("Info activated for item %d\n", MenuItem->clicked);
#endif
			if (MenuItem->clicked == -1)
				display_info(NULL, IbPtr, NULL);
/*				display_info(IbPtr->current_wd, IbPtr);*/
			else
				if (item_num == 1) 
				{
					ok = XmNlListGetItem(IbPtr->fm_scroll_win, &item, valuemask, *numbers);
					if (ok)
					{
						fdp = (struct filedata *) item.UserDataPointer;
						display_info(fdp, IbPtr, NULL);
/*						fullpath = (char *) calloc((strlen(IbPtr->current_wd) + 4 + strlen(fdp->name)), sizeof(char));
						if (fullpath)
						{
							sprintf(fullpath, "%s/%s", IbPtr->current_wd, fdp->name);
							display_info(fullpath, IbPtr);
							free(fullpath);
						}*/
					}
				}
			break;
		case POPUP_USER_ACTION1:
#ifdef DEBUG
			printf("Open action 1 with activated for item %d\n", MenuItem->clicked);
#endif
			if (item_num == 1) 
			{
				ok = XmNlListGetItem(IbPtr->fm_scroll_win, &item, valuemask, *numbers);
				if (ok)
				{
					fdp = (struct filedata *) item.UserDataPointer;
					magicptr = fdp->magic;
					if (magicptr && magicptr->big_icon_name)
					{
						alter_ptr = magicptr->alter_ptr;
						if (alter_ptr)
						{
							if (alter_ptr->action1)
							{
								fullpath = (char *) calloc((strlen(IbPtr->current_wd) + 4 + strlen(fdp->name)), sizeof(char));
								if (fullpath) 
								{
									sprintf(fullpath, "%s/%s", IbPtr->current_wd, fdp->name);
#ifdef DEBUG
									printf("Action1 %s for %s\n", alter_ptr->action1, fullpath);
#endif
									exec_action(fullpath, alter_ptr->action1);
									free(fullpath);
								}
							}
						}
					}
				}
			}
			break;
		case POPUP_USER_ACTION2:
#ifdef DEBUG
			printf("Open action 2 with activated for item %d\n", MenuItem->clicked);
#endif
			if (item_num == 1) 
			{
				ok = XmNlListGetItem(IbPtr->fm_scroll_win, &item, valuemask, *numbers);
				if (ok)
				{
					fdp = (struct filedata *) item.UserDataPointer;
					magicptr = fdp->magic;
					if (magicptr && magicptr->big_icon_name)
					{
						alter_ptr = magicptr->alter_ptr;
						if (alter_ptr)
						{
							if (alter_ptr->action2)
							{
								fullpath = (char *) calloc((strlen(IbPtr->current_wd) + 4 + strlen(fdp->name)), sizeof(char));
								if (fullpath) 
								{
									sprintf(fullpath, "%s/%s", IbPtr->current_wd, fdp->name);
#ifdef DEBUG
									printf("Action1 %s for %s\n", alter_ptr->action2, fullpath);
#endif
									exec_action(fullpath, alter_ptr->action2);
									free(fullpath);
								}
							}
						}
					}
				}
			}
			break;
		case POPUP_USER_ACTION3:
#ifdef DEBUG
			printf("Open action 3 with activated for item %d\n", MenuItem->clicked);
#endif
			if (item_num == 1) 
			{
				ok = XmNlListGetItem(IbPtr->fm_scroll_win, &item, valuemask, *numbers);
				if (ok)
				{
					fdp = (struct filedata *) item.UserDataPointer;
					magicptr = fdp->magic;
					if (magicptr && magicptr->big_icon_name)
					{
						alter_ptr = magicptr->alter_ptr;
						if (alter_ptr)
						{
							if (alter_ptr->action3)
							{
								fullpath = (char *) calloc((strlen(IbPtr->current_wd) + 4 + strlen(fdp->name)), sizeof(char));
								if (fullpath) 
								{
									sprintf(fullpath, "%s/%s", IbPtr->current_wd, fdp->name);
#ifdef DEBUG
									printf("Action1 %s for %s\n", alter_ptr->action3, fullpath);
#endif
									exec_action(fullpath, alter_ptr->action3);
									free(fullpath);
								}
							}
						}
					}
				}
			}
			break;
		default: ;
	}
	return ;
}


static MenuItemDesc * CreateMenuDescriptor(MenuItemDesc * parent, int action_type, IfaceBranche * IbPtr)
{
	MenuItemDesc * MenuItem;

	MenuItem = calloc(1, sizeof(MenuItemDesc));
	if (parent)
		parent->next = MenuItem;
	MenuItem->action = action_type;
	MenuItem->IbPtr = IbPtr;
	MenuItem->clicked = -1;
	
	return MenuItem;
}

static Widget CreatePopupMenuItem(Widget parent, char * name, char * label, XtPointer user_data)
{
	Widget w;
	int nargs = 0;
	Arg args[5];
	XmString str =  NULL;
	
	if (label)
	{
		str = XmStringCreateLocalized(label);
		
		XtSetArg(args[nargs], XmNlabelString, str);
		nargs++;
	}

	if (user_data)
	{
		XtSetArg(args[nargs], XmNuserData, user_data);	
		nargs++;
	}
	
	if (nargs)
		w = XmCreatePushButton(parent, name, args, nargs);
	else
		w = XmCreatePushButton(parent, name, NULL, 0);
	
    XtAddCallback(w, XmNactivateCallback, FilePopupActivateCB, NULL);

    XtManageChild(w);

	if (str)
		XmStringFree(str);
	
	return w;
}

static Widget CreatePopupMenuItem2(Widget parent, char * name, char * label, XtPointer user_data)
{
	Widget w;
	XmString str =  NULL;
	int nargs = 0;
	Arg args[10];

	XtSetArg(args[nargs], XmNtoggleMode, XmTOGGLE_BOOLEAN);
	nargs++;
	
//	XtSetArg(args[nargs], XmNindicatorType, XmONE_OF_MANY_ROUND);
//	nargs++;


	if (label)
	{
		str = XmStringCreateLocalized(label);
		
		XtSetArg(args[nargs], XmNlabelString, str);
		nargs++;
	}

	if (user_data)
	{
		XtSetArg(args[nargs], XmNuserData, user_data);	
		nargs++;
	}

	if (nargs)
		w = XmCreateToggleButton(parent, name, args, nargs);
	else
		w = XmCreateToggleButton(parent, name, NULL, 0);
	
//    XtAddCallback(w, XmNactivateCallback, FilePopupActivateCB, NULL);
	XtAddCallback(w, XmNvalueChangedCallback, FilePopupChangeCB, NULL);

    XtManageChild(w);

	if (str)
		XmStringFree(str);
	
	return w;
}

static Widget CreatePopupMenuItem3(Widget parent, char * name, char * label, XtPointer user_data)
{
	Widget w;
	XmString str =  NULL;
	int nargs = 0;
	Arg args[10];

	XtSetArg(args[nargs], XmNtoggleMode, XmTOGGLE_BOOLEAN);
	nargs++;
	
	XtSetArg(args[nargs], XmNindicatorType, XmONE_OF_MANY_ROUND);
	nargs++;

	XtSetArg(args[nargs], XmNindicatorOn, XmINDICATOR_CHECK_BOX);
	nargs++;

	XtSetArg(args[nargs], XmNvisibleWhenOff, True);
	nargs++;

	if (label)
	{
		str = XmStringCreateLocalized(label);
		
		XtSetArg(args[nargs], XmNlabelString, str);
		nargs++;
	}

	if (user_data)
	{
		XtSetArg(args[nargs], XmNuserData, user_data);	
		nargs++;
	}

	if (nargs)
		w = XmCreateToggleButton(parent, name, args, nargs);
	else
		w = XmCreateToggleButton(parent, name, NULL, 0);
	
//    XtAddCallback(w, XmNactivateCallback, FilePopupActivateCB, NULL);
	XtAddCallback(w, XmNvalueChangedCallback, FilePopupChangeCB, NULL);

    XtManageChild(w);

	if (str)
		XmStringFree(str);
	
	return w;
}


Widget CreateMenuA(IfaceBranche * IbPtr, Widget parent)
{
	Widget a, sep;
	MenuItemDesc * MenuItem;
	Widget menu_A;

#ifdef DEBUG
	printf("Create popup menu A\n");
#endif

//	menu_A = XmCreatePopupMenu(IbPtr->fm_scroll_win, "PopupMenuA", NULL, 0);

	if (XtNameToWidget(parent, "PopupMenuA"))
		return NULL;

	menu_A = XmCreatePopupMenu(parent, "PopupMenuA", NULL, 0);
		
	XtVaSetValues(menu_A, XmNpopupEnabled, XmPOPUP_AUTOMATIC, NULL);

	MenuItem = CreateMenuDescriptor(NULL, POPUP_USER_ACTION1, IbPtr);

	XtAddCallback(menu_A, XmNdestroyCallback, FilePopupDestroyCB, (XtPointer) MenuItem);

//	XtAddCallback(XmNlListGetIBWidget(parent), XmNpopupHandlerCallback, FilePopupHandlerCB, (XtPointer) IbPtr);
//	XtAddCallback(XmNlListGetRCWidget(parent), XmNpopupHandlerCallback, FilePopupHandlerCB, (XtPointer) IbPtr);
				
	a = CreatePopupMenuItem(menu_A, "Alt1", NULL, MenuItem);

	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_USER_ACTION2, IbPtr);
	
	
	a = CreatePopupMenuItem(menu_A, "Alt2", NULL, MenuItem);

	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_USER_ACTION3, IbPtr);

	a = CreatePopupMenuItem(menu_A, "Alt3", NULL, MenuItem);

	sep = XmCreateSeparatorGadget(menu_A, "separator1", NULL, 0);
	XtManageChild(sep);

	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_IN_XTERM_ACTION, IbPtr);

	a = CreatePopupMenuItem(menu_A, "OpenInXterm", resdata.PopupMenuInTermString, MenuItem);

	sep = XmCreateSeparatorGadget(menu_A, "separator2", NULL, 0);
	XtManageChild(sep);


	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_CUT, IbPtr);

	a = CreatePopupMenuItem(menu_A, "Cut", resdata.PopupMenuCutString, MenuItem);

	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_COPY, IbPtr);

	a = CreatePopupMenuItem(menu_A, "Copy", resdata.PopupMenuCopyString, MenuItem);
	
	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_PASTE, IbPtr);

	a = CreatePopupMenuItem(menu_A, "Past", resdata.PopupMenuPastString, MenuItem);

	sep = XmCreateSeparatorGadget(menu_A, "separator3", NULL, 0);
	XtManageChild(sep);

	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_DELETE, IbPtr);

	a = CreatePopupMenuItem(menu_A, "Delete", resdata.PopupMenuDeleteString, MenuItem);

	sep = XmCreateSeparatorGadget(menu_A, "separator4", NULL, 0);
	XtManageChild(sep);

	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_INFO, IbPtr);

	a = CreatePopupMenuItem(menu_A, "Info", resdata.PopupMenuInfoString, MenuItem);

#ifdef DEBUG
	printf("Popup menu A created\n");
#endif

	return menu_A;
}


Widget CreateMenuB(IfaceBranche * IbPtr, Widget parent)
{
	Widget a, sep;
	MenuItemDesc * MenuItem;
	Widget menu_B;

#ifdef DEBUG
	printf("Create popup menu B\n");
#endif
		

//	menu_A = XmCreatePopupMenu(IbPtr->fm_scroll_win, "PopupMenuA", NULL, 0);

	if (XtNameToWidget(parent, "PopupMenuB"))
		return NULL;

	menu_B = XmCreatePopupMenu(parent, "PopupMenuB", NULL, 0);
		
	XtVaSetValues(menu_B, XmNpopupEnabled, XmPOPUP_AUTOMATIC, NULL);

	MenuItem = CreateMenuDescriptor(NULL, POPUP_XTERM_ACTION, IbPtr);


	XtAddCallback(menu_B, XmNdestroyCallback, FilePopupDestroyCB, (XtPointer) MenuItem);
/*	XtAddCallback(menu_A, XmNmapCallback, FilePopupMapCB, (XtPointer) MenuItem);
	XtAddCallback(menu_A, XmNunmapCallback, FilePopupUnMapCB, (XtPointer) MenuItem);*/
//	XtAddCallback(parent, XmNpopupHandlerCallback, FilePopupHandlerCB, (XtPointer) MenuItem);

//	XtAddCallback(XmNlListGetIBWidget(parent), XmNpopupHandlerCallback, FilePopupHandlerCB, (XtPointer) IbPtr);
//	XtAddCallback(XmNlListGetRCWidget(parent), XmNpopupHandlerCallback, FilePopupHandlerCB, (XtPointer) IbPtr);

	a = CreatePopupMenuItem(menu_B, "OpenXterm", resdata.PopupMenuTermHereString, MenuItem);

	sep = XmCreateSeparatorGadget(menu_B, "separator1", NULL, 0);
	XtManageChild(sep);


	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_CUT, IbPtr);

	a = CreatePopupMenuItem(menu_B, "Cut", resdata.PopupMenuCutString, MenuItem);

	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_COPY, IbPtr);


	a = CreatePopupMenuItem(menu_B, "Copy", resdata.PopupMenuCopyString, MenuItem);
	
	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_PASTE, IbPtr);


	a = CreatePopupMenuItem(menu_B, "Past", resdata.PopupMenuPastString, MenuItem);

	sep = XmCreateSeparatorGadget(menu_B, "separator2", NULL, 0);
	XtManageChild(sep);

	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_DELETE, IbPtr);


	a = CreatePopupMenuItem(menu_B, "Delete", resdata.PopupMenuDeleteString, MenuItem);

	sep = XmCreateSeparatorGadget(menu_B, "separator3", NULL, 0);

	XtManageChild(sep);

	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_INFO, IbPtr);

	a = CreatePopupMenuItem(menu_B, "Info", resdata.PopupMenuInfoString, MenuItem);

#ifdef DEBUG
	printf("Popup menu B created\n");
#endif
	return menu_B;
}



Widget CreateMenuC(IfaceBranche * IbPtr, Widget parent)
{
	Widget a, sep;
	MenuItemDesc * MenuItem;
	Widget menu_C;

#ifdef DEBUG
	printf("Create popup menu C ibptr: 5p\n", IbPtr);
#endif
		

//	menu_A = XmCreatePopupMenu(IbPtr->fm_scroll_win, "PopupMenuA", NULL, 0);

	if (XtNameToWidget(parent, "PopupMenuC"))
		return NULL;

	menu_C = XmCreatePopupMenu(parent, "PopupMenuC", NULL, 0);
		
	XtVaSetValues(menu_C, XmNpopupEnabled, XmPOPUP_AUTOMATIC, NULL);

	MenuItem = CreateMenuDescriptor(NULL, POPUP_XTERM_ACTION, IbPtr);


	XtAddCallback(menu_C, XmNdestroyCallback, FilePopupDestroyCB, (XtPointer) MenuItem);
/*	XtAddCallback(menu_A, XmNmapCallback, FilePopupMapCB, (XtPointer) MenuItem);
	XtAddCallback(menu_A, XmNunmapCallback, FilePopupUnMapCB, (XtPointer) MenuItem);*/
//	XtAddCallback(parent, XmNpopupHandlerCallback, FilePopupHandlerCB, (XtPointer) MenuItem);

//	XtAddCallback(XmNlListGetIBWidget(parent), XmNpopupHandlerCallback, FilePopupHandlerCB, (XtPointer) IbPtr);

	a = CreatePopupMenuItem(menu_C, "OpenXterm", resdata.PopupMenuTermHereString, MenuItem);

	sep = XmCreateSeparatorGadget(menu_C, "separator1", NULL, 0);
	XtManageChild(sep);


	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_CUT, IbPtr);

	a = CreatePopupMenuItem(menu_C, "Cut", resdata.PopupMenuCutString, MenuItem);

	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_COPY, IbPtr);


	a = CreatePopupMenuItem(menu_C, "Copy", resdata.PopupMenuCopyString, MenuItem);
	
	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_PASTE, IbPtr);


	a = CreatePopupMenuItem(menu_C, "Past", resdata.PopupMenuPastString, MenuItem);

	sep = XmCreateSeparatorGadget(menu_C, "separator2", NULL, 0);
	XtManageChild(sep);

	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_DELETE, IbPtr);


	a = CreatePopupMenuItem(menu_C, "Delete", resdata.PopupMenuDeleteString, MenuItem);

	sep = XmCreateSeparatorGadget(menu_C, "separator3", NULL, 0);

	XtManageChild(sep);

	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_INFO, IbPtr);

	a = CreatePopupMenuItem(menu_C, "Info", resdata.PopupMenuInfoString, MenuItem);


	sep = XmCreateSeparatorGadget(menu_C, "separator4", NULL, 0);

	XtManageChild(sep);
	
	
	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_NAME_SORT, IbPtr);

	a = CreatePopupMenuItem2(menu_C, "Name", resdata.NameTitleString, MenuItem);
	IbPtr->sort_name_bt = a;

	if (IbPtr->SortingCategory == SORTING_NAME)
		XmToggleButtonSetState(a, TRUE, FALSE);


	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_SIZE_SORT, IbPtr);

	a = CreatePopupMenuItem2(menu_C, "Size", resdata.SizeTitleString, MenuItem);
	IbPtr->sort_size_bt = a;

	if (IbPtr->SortingCategory == SORTING_SIZE)
		XmToggleButtonSetState(a, TRUE, FALSE);


	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_DATE_SORT, IbPtr);

	a = CreatePopupMenuItem2(menu_C, "Date", resdata.DateTitleString, MenuItem);
	IbPtr->sort_date_bt = a;

	if (IbPtr->SortingCategory == SORTING_DATE)
		XmToggleButtonSetState(a, TRUE, FALSE);


	sep = XmCreateSeparatorGadget(menu_C, "separator5", NULL, 0);

	XtManageChild(sep);


	MenuItem = CreateMenuDescriptor(MenuItem, POPUP_REVERSE_SORT, IbPtr);

	a = CreatePopupMenuItem3(menu_C, "Reverse", resdata.PopupMenuReverseString, MenuItem);
	IbPtr->sort_reverse_bt = a;

	if (IbPtr->SortingType == SORTING_DESCEND)
		XmToggleButtonSetState(a, TRUE, FALSE);

#ifdef DEBUG
	printf("Popup menu C created\n");
#endif
	return menu_C;
}


static void EnableWaitCursor(IfaceBranche * IbPtr)
{
	if (!CursorCreated)
	{
		WaithCursor = XCreateFontCursor(XtDisplay(IbPtr->top_level), XC_watch);
		CursorCreated = True;
	}
	
	XDefineCursor(XtDisplay(IbPtr->fm_scroll_win), XtWindow(IbPtr->fm_scroll_win), WaithCursor);
	IbPtr->wait_cursor = 1;
}

static void DisableWaitCursor(IfaceBranche * IbPtr)
{
	if (IbPtr->wait_cursor)
	{
		XUndefineCursor(XtDisplay(IbPtr->fm_scroll_win), XtWindow(IbPtr->fm_scroll_win));
		IbPtr->wait_cursor = 0;
	}
}

void LargeItemAdd(IfaceBranche * IbPtr, int n)
{
	bxfm_ftype * mgtype;
	unsigned char valuemask = 0 | CellXmString | CellPixmap | CellMask | CellUserData | CellCharString;
	struct filedata * fileptr;
	XmNlCell item;

	if (IbPtr->CurrentViewType != LARGE_VIEW)
		return ;

	bzero((void *) &item, sizeof(XmNlCell));

	if (n < IbPtr->ndirs)
		fileptr = IbPtr->dirs_ptr[n];
	else
		fileptr = IbPtr->files_ptr[n - IbPtr->ndirs];

	mgtype = fileptr->magic;

	if (mgtype != NULL && mgtype->big_icon_name) 
	{
#ifdef DEBUG
		printf("--------Magic found %p\n", files->magic);
#endif
		if (mgtype->big_pixmap > 2)
		{
#ifdef DEBUG
			printf("---------External pix found %lx %lx\n", mgtype->big_pixmap, mgtype->big_mask);
#endif
			item.pixmap = mgtype->big_pixmap;
			item.mask = mgtype->big_mask;
		}
		else
		{
			item.pixmap = XmUNSPECIFIED_PIXMAP;
			item.mask = XmUNSPECIFIED_PIXMAP;
		}
	}
	else
	{
		item.pixmap = XmUNSPECIFIED_PIXMAP;
		item.mask = XmUNSPECIFIED_PIXMAP;
	}

	if (mgtype == NULL || item.pixmap == XmUNSPECIFIED_PIXMAP)
	{
		switch (fileptr->filetype & S_IFMT) 
		{
			case (S_IFDIR | S_IFLNK):
				item.pixmap = ldir_xpm;
				item.mask = mask_ldir_xpm;
				break;
			case S_IFDIR:
				item.pixmap = dir_xpm;
				item.mask = mask_dir_xpm;
				break;
			case S_IFREG:
				item.pixmap = file_xpm;
				item.mask = mask_file_xpm;
				break;
			case S_IFLNK:
				if (fileptr->linkto)
				{
					item.pixmap = lfile_xpm;
					item.mask = mask_lfile_xpm;
				}
				else
				{
					item.pixmap = lbad_xpm;
					item.mask = mask_lbad_xpm;
				}
				break;
			default:
				item.pixmap = XmUNSPECIFIED_PIXMAP;
				item.mask = XmUNSPECIFIED_PIXMAP;
				break;
		}
	}
	item.text = fileptr->name;
//	item.xmlabel = XmStringCreateLocalized(fileptr->name);
	item.xmlabel = CreateLabel(fileptr->name);
	item.UserDataPointer = (void *) fileptr;

	XmNlListAddItems(IbPtr->fm_scroll_win, &item, 1, valuemask);
	XmStringFree(item.xmlabel);
}

void SmallItemAdd(IfaceBranche * IbPtr, int n)
{
	bxfm_ftype * mgtype;
	unsigned char valuemask = 0 | CellXmString | CellPixmap | CellMask | CellUserData | CellCharString;
	struct filedata * fileptr;
	XmNlCell item;

	if (IbPtr->CurrentViewType != SMALL_VIEW)
		return ;

	bzero((void *) &item, sizeof(XmNlCell));

	if (n < IbPtr->ndirs)
		fileptr = IbPtr->dirs_ptr[n];
	else
		fileptr = IbPtr->files_ptr[n - IbPtr->ndirs];

	mgtype = fileptr->magic;
	if (mgtype != NULL && mgtype->small_icon_name) 
	{
#ifdef DEBUG
		printf("--------Magic found %p\n", fileptr->magic);
#endif
		if (mgtype->small_pixmap > 2)
		{
#ifdef DEBUG
			printf("---------External pix found %lx %lx\n", mgtype->small_pixmap, mgtype->small_mask);
#endif
			item.pixmap = mgtype->small_pixmap;
			item.mask = mgtype->small_mask;
		}
		else
		{
			item.pixmap = XmUNSPECIFIED_PIXMAP;
			item.mask = XmUNSPECIFIED_PIXMAP;
		}
	}
	else
	{
		item.pixmap = XmUNSPECIFIED_PIXMAP;
		item.mask = XmUNSPECIFIED_PIXMAP;
	}

	if (mgtype == NULL || item.pixmap == XmUNSPECIFIED_PIXMAP)
	{
		switch (fileptr->filetype & S_IFMT) 
		{
			case S_IFDIR:
				item.pixmap = small_dir_xpm;
				item.mask = mask_small_dir_xpm;
				break;
			case (S_IFDIR | S_IFLNK):
				item.pixmap = small_ldir_xpm;
				item.mask = mask_small_ldir_xpm;
				break;
			case S_IFREG:
				item.pixmap = small_file_xpm;
				item.mask = mask_small_file_xpm;
				break;
			case S_IFLNK:
				if (fileptr->linkto)
				{
					item.pixmap = small_lfile_xpm;
					item.mask = mask_small_lfile_xpm;
				}
				else
				{
					item.pixmap = small_lbad_xpm;
					item.mask = mask_small_lbad_xpm;
				}
				break;
			default:
				item.pixmap = XmUNSPECIFIED_PIXMAP;
				item.mask = XmUNSPECIFIED_PIXMAP;
				break;
		}
	}
	item.text = fileptr->name;
//	item.xmlabel = XmStringCreateLocalized(fileptr->name);
	item.xmlabel = CreateLabel(fileptr->name);
	item.UserDataPointer = (void *) fileptr;

	XmNlListAddItems(IbPtr->fm_scroll_win, &item, 1, valuemask);

	XmStringFree(item.xmlabel);
}

int DetailItemAdd(IfaceBranche * IbPtr, int start_pos, int n)
{
	char thisnum[4], fullpath[120];
	char text_buf[1024];
	int m;
	bxfm_ftype * mgtype;
	int external_pix = 0;
//	unsigned char valuemask = 0 | CellXmString | CellPixmap | CellMask | CellUserData | CellCharString;
	unsigned char valuemask = 0 | CellXmString | CellPixmap | CellMask | CellUserData ;
	struct filedata * files;
	XmNlCell data_massiv[35];
	
	if (IbPtr->CurrentViewType != DETAIL_VIEW)
		return 0;

	for (m = 0; m < n; m++)
	{
		if ((start_pos + m) < IbPtr->ndirs)
			files = IbPtr->dirs_ptr[start_pos + m];
		else
			files = IbPtr->files_ptr[start_pos + m - IbPtr->ndirs];

		mgtype = files->magic;

		if (mgtype != NULL && mgtype->small_icon_name) 
		{
#ifdef DEBUG
			printf("--------Magic found %p\n", files->magic);
#endif
			if (mgtype->small_pixmap > 2)
			{
#ifdef DEBUG
				printf("---------External pix found %lx %lx\n", mgtype->small_pixmap, mgtype->small_mask);
#endif
				data_massiv[7*m].pixmap = mgtype->small_pixmap;
				data_massiv[7*m].mask = mgtype->small_mask;
			}
			else
			{
				data_massiv[7*m].pixmap = XmUNSPECIFIED_PIXMAP;
				data_massiv[7*m].mask = XmUNSPECIFIED_PIXMAP;
			}
		}
		else
		{
			data_massiv[7*m].pixmap = XmUNSPECIFIED_PIXMAP;
			data_massiv[7*m].mask = XmUNSPECIFIED_PIXMAP;
		}
	

		if (mgtype == NULL || data_massiv[7*m].pixmap == XmUNSPECIFIED_PIXMAP)
		{
			switch (files->filetype & S_IFMT) 
			{
			case S_IFDIR:
				data_massiv[7*m].pixmap = small_dir_xpm;
				data_massiv[7*m].mask = mask_small_dir_xpm;
				break ;
			case (S_IFDIR | S_IFLNK):
				data_massiv[7*m].pixmap = small_ldir_xpm;
				data_massiv[7*m].mask = mask_small_ldir_xpm;
				break ;
			case S_IFREG:
				data_massiv[7*m].pixmap = small_file_xpm;
				data_massiv[7*m].mask = mask_small_file_xpm;
				break ;
			case S_IFLNK:
				if (files->linkto)
				{
					data_massiv[7*m].pixmap = small_lfile_xpm;
					data_massiv[7*m].mask = mask_small_lfile_xpm;
				}
				else
				{
					data_massiv[7*m].pixmap = small_lbad_xpm;
					data_massiv[7*m].mask = mask_small_lbad_xpm;
				}
				break ;
			default:
				data_massiv[7*m].pixmap = XmUNSPECIFIED_PIXMAP;
				data_massiv[7*m].mask = XmUNSPECIFIED_PIXMAP;
				break;
			}
#ifdef DEBUG
			printf("---------Internal pix found %lx %lx\n", data_massiv[7*m].pixmap, data_massiv[7*m].mask);
#endif
		}
			
		data_massiv[7*m].text = (char *) NULL;
		data_massiv[7*m].xmlabel = NULL;
		data_massiv[7*m].UserDataPointer = (void *) files;

		data_massiv[7*m + 1].text = (char *) NULL;
//		data_massiv[7*m + 1].xmlabel = XmStringCreateLocalized(files->name);
		data_massiv[7*m + 1].xmlabel = XmStringGenerate((XtPointer) files->name, NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);
		data_massiv[7*m + 1].pixmap = XmUNSPECIFIED_PIXMAP;
		data_massiv[7*m + 1].mask = XmUNSPECIFIED_PIXMAP;

		data_massiv[7*m + 2].text = (char *) NULL;
		if (!S_ISDIR(files->info->f_perm))
		{
			if (get_human_readable_size(files->info->f_size, text_buf, 0))
//				data_massiv[7*m + 2].xmlabel = XmStringCreateLocalized(text_buf);
				data_massiv[7*m + 2].xmlabel = XmStringGenerate((XtPointer) text_buf, NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);
			else
//				data_massiv[7*m + 2].xmlabel = XmStringCreateLocalized("-");
				data_massiv[7*m + 2].xmlabel = XmStringGenerate((XtPointer) "-", NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);
		}
		else
//			data_massiv[7*m + 2].xmlabel = XmStringCreateLocalized("-");
			data_massiv[7*m + 2].xmlabel = XmStringGenerate((XtPointer) "-", NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);
	
		data_massiv[7*m + 2].pixmap = XmUNSPECIFIED_PIXMAP;
		data_massiv[7*m + 2].mask = XmUNSPECIFIED_PIXMAP;
			

		data_massiv[7*m + 3].text = (char *) NULL;
		if (get_human_readable_time(&(files->info->f_mtime), text_buf))
//			data_massiv[7*m + 3].xmlabel = XmStringCreateLocalized(text_buf);
			data_massiv[7*m + 3].xmlabel = XmStringGenerate((XtPointer) text_buf, NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);
		else
//			data_massiv[7*m + 3].xmlabel = XmStringCreateLocalized("-");
			data_massiv[7*m + 3].xmlabel = XmStringGenerate((XtPointer) "-", NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);
			
		data_massiv[7*m + 3].pixmap = XmUNSPECIFIED_PIXMAP;
		data_massiv[7*m + 3].mask = XmUNSPECIFIED_PIXMAP;
			
		data_massiv[7*m + 4].text = (char *) NULL;
		if (get_human_readable_permission(files->info->f_perm, text_buf))
//			data_massiv[7*m + 4].xmlabel = XmStringCreateLocalized(text_buf);
			data_massiv[7*m + 4].xmlabel = XmStringGenerate((XtPointer) text_buf, NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);
		else
//			data_massiv[7*m + 4].xmlabel = XmStringCreateLocalized("-");
			data_massiv[7*m + 4].xmlabel = XmStringGenerate((XtPointer) "-", NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);

		data_massiv[7*m + 4].pixmap = XmUNSPECIFIED_PIXMAP;
		data_massiv[7*m + 4].mask = XmUNSPECIFIED_PIXMAP;
			
		data_massiv[7*m + 5].text = (char *) NULL;
		if (NULL != get_human_readable_owner(files->info->f_owner, text_buf))
//			data_massiv[7*m + 5].xmlabel = XmStringCreateLocalized(text_buf);
			data_massiv[7*m + 5].xmlabel = XmStringGenerate((XtPointer) text_buf, NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);
		else
//			data_massiv[7*m + 5].xmlabel = XmStringCreateLocalized("-");
			data_massiv[7*m + 5].xmlabel = XmStringGenerate((XtPointer) "-", NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);

		data_massiv[7*m + 5].pixmap = XmUNSPECIFIED_PIXMAP;
		data_massiv[7*m + 5].mask = XmUNSPECIFIED_PIXMAP;

		data_massiv[7*m + 6].text = (char *) NULL;
		if (NULL != get_human_readable_ownergr(files->info->f_owngrp, text_buf))
//			data_massiv[7*m + 6].xmlabel = XmStringCreateLocalized(text_buf);
			data_massiv[7*m + 6].xmlabel = XmStringGenerate((XtPointer) text_buf, NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);
		else
//			data_massiv[7*m + 6].xmlabel = XmStringCreateLocalized("-");
			data_massiv[7*m + 6].xmlabel = XmStringGenerate((XtPointer) "-", NULL, XmMULTIBYTE_TEXT, XmFONTLIST_DEFAULT_TAG_STRING);

		data_massiv[7*m + 6].pixmap = XmUNSPECIFIED_PIXMAP;
		data_massiv[7*m + 6].mask = XmUNSPECIFIED_PIXMAP;
	}

	XmNlListAddRows(IbPtr->fm_scroll_win, data_massiv, n, valuemask);
	
	for (m = 0; m < n; m++)
	{
		XmStringFree(data_massiv[m*7 + 1].xmlabel);
		XmStringFree(data_massiv[m*7 + 2].xmlabel);
		XmStringFree(data_massiv[m*7 + 3].xmlabel);
		XmStringFree(data_massiv[m*7 + 4].xmlabel);
		XmStringFree(data_massiv[m*7 + 5].xmlabel);
		XmStringFree(data_massiv[m*7 + 6].xmlabel);
	}
	
	return n;
}

int ItemAdd(IfaceBranche * IbPtr, int start_pos, int n)
{
	int num;
	if (IbPtr->CurrentViewType == LARGE_VIEW)
	{
		LargeItemAdd(IbPtr, start_pos);
		return 1;
	}
	if (IbPtr->CurrentViewType == SMALL_VIEW)
	{
		SmallItemAdd(IbPtr, start_pos);
		return 1;
	}
	if (IbPtr->CurrentViewType == DETAIL_VIEW)
	{
		if (0 == n)
		{
			num = IbPtr->filesready - IbPtr->processed;
			if (num > 5)
				num = 5;

			num = DetailItemAdd(IbPtr, start_pos, num);
			return num;
		}
		num = DetailItemAdd(IbPtr, start_pos, n);
		return num;
	}
}


void CleanIconsSet1(Display * disp)
{
	if (dir_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, dir_xpm);
	if (mask_dir_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, mask_dir_xpm);
			
	if (file_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, file_xpm);
	if (mask_file_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, mask_file_xpm);

	if (lfile_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, lfile_xpm);
	if (mask_lfile_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, mask_lfile_xpm);

	if (ldir_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, ldir_xpm);
	if (mask_ldir_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, mask_ldir_xpm);

	if (lbad_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, lbad_xpm);
	if (mask_lbad_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, mask_lbad_xpm);

/************************************************/

	if (small_dir_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, small_dir_xpm);
	if (mask_small_dir_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, mask_small_dir_xpm);
			
	if (small_file_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, small_file_xpm);
	if (mask_small_file_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, mask_small_file_xpm);
			
	if (small_lfile_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, small_lfile_xpm);
	if (mask_small_lfile_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, mask_small_lfile_xpm);
			
	if (small_ldir_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, small_ldir_xpm);
	if (mask_small_ldir_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, mask_small_ldir_xpm);

	if (small_lbad_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, small_lbad_xpm);
	if (mask_small_lbad_xpm >= XmUNSPECIFIED_PIXMAP) 
			XFreePixmap(disp, mask_small_lbad_xpm);
}

void MenuToOff(IfaceBranche * IbPtr)
{
	int i;
	
	for (i = 0; i < SensitiveItmesCount; i++)
	{
		MenuItemSensitive(IbPtr->file_pulldown, SensitiveItems[i], False);
	}
}


void MenuToOn(IfaceBranche * IbPtr)
{
	int i;
	
	for (i = 0; i < SensitiveItmesCount; i++)
	{
		MenuItemSensitive(IbPtr->file_pulldown, SensitiveItems[i], True);
	}
}


static int ProcessWatchEvent(IfaceBranche * IbPtr)
{
	WatchEvent * WtEv;
	struct filedata * file_ptr;
	int res;
	
	WtEv = GetWatchEvent(IbPtr);
	if (!WtEv)
		return 0;

	file_ptr = WtEv->file_ptr;

#ifdef DEBUG_WATCH_DIR
			printf("=========\n");
			printf("\tFilearea: thread %d event type %d iface ref %p\n", IbPtr->thread_number, WtEv->code, IbPtr);
			printf("Filearea: path %s event %p file %p\n", WtEv->path, WtEv, WtEv->file_ptr);
			if (file_ptr)
			{
				printf("Filearea: file %s\n", file_ptr->name);
			}
			printf("Filearea: path %p\n", WtEv->path);
			printf("=========\n");

			if (pthread_equal(IbPtr->thread_id, pthread_self()))
				printf("THREAD OK\n");
			else
				printf("THREAD WRONG\n");
#endif

	if (0 != strcmp(IbPtr->current_wd, WtEv->path))
	{
lb_del:	if (file_ptr)
		{
			if (file_ptr->info)
				free(file_ptr->info);
			
			if (file_ptr->linkto)
				free(file_ptr->linkto);

			if (file_ptr->name)
				free(file_ptr->name);
				
			free(file_ptr);
		}
		
		if (WtEv->path)
			free(WtEv->path);
		
		free(WtEv);
		
#ifdef DEBUG_WATCH_DIR
			printf("Clean event ok\n");
#endif
		return 1;
	}
	
	switch (WtEv->code)
	{
		case NOTIFY_ADD_FILE:
			res = AddItemToFileView(IbPtr, file_ptr);
#ifdef DEBUG_WATCH_DIR
			printf("--Add ok\n");
#endif
			if (!res)
				goto lb_del;
			else
			{
				if (WtEv->path)
					free(WtEv->path);
				free(WtEv);
			}
			break;
		
		case NOTIFY_CLOSE_FILE:
			res = CloseItemInFileView(IbPtr, file_ptr);
#ifdef DEBUG_WATCH_DIR
			printf("--Close ok\n");
#endif
			if (!res)
				goto lb_del;
			else
			{
				if (WtEv->path)
					free(WtEv->path);
				free(WtEv);
			}
			break;
		
		case NOTIFY_CHANGE_ATTRIB:
			res = ChangeAttribInFileView(IbPtr, file_ptr);
#ifdef DEBUG_WATCH_DIR
			printf("--Change attrib ok\n");
#endif
			if (!res)
				goto lb_del;
			else
			{
				if (WtEv->path)
					free(WtEv->path);
				free(WtEv);
			}
			break;

		case NOTIFY_DELETE_FILE:
			res = DeleteItemFromFileView(IbPtr, file_ptr);
#ifdef DEBUG_WATCH_DIR
			printf("--Delete ok\n");
#endif
			goto lb_del;
			break;

		case NOTIFY_NEED_REDISPLAY:
			ReDrawFileArea(IbPtr);
#ifdef DEBUG_WATCH_DIR
			printf("--ReDraw ok\n");
#endif
			goto lb_del;
			break;
	}
	return 1;
}


static int CheckFileReadJoined(IfaceBranche * IbPtr)
{

	if ( 0 == pthread_tryjoin_np(IbPtr->files_thread_id, NULL))
	{
#ifdef DEBUG
		printf("Files reading thread joined\n");
#endif
		DisableWaitCursor(IbPtr);
#ifdef DEBUG
		printf("Desable Wait cursor\n");
#endif
		if (IbPtr->cancel_reading)
		{
			XmNlListDeletAllInfo(IbPtr->fm_scroll_win);
#ifdef DEBUG
			printf("TimeOutWaitsJoinProc: clean view\n");
#endif
			clear_dir_list(IbPtr);
#ifdef DEBUG
			printf("TimeOutWaitsJoinProc: clean files\n");
#endif
			IbPtr->filesready = 0;
		}
		IbPtr->processed = 0;
		IbPtr->load_dir_joined = 1;
		IbPtr->cancel_reading = 0;
		IbPtr->reading_process = 0;
		XtVaSetValues(IbPtr->stop_load_dir, XmNsensitive, False, NULL);
		XtVaSetValues(IbPtr->go, XmNsensitive, True, NULL);
		XtVaSetValues(IbPtr->go_up_dir, XmNsensitive, True, NULL);
		XtVaSetValues(IbPtr->fm_textfield, XmNsensitive, True, NULL);
		MenuToOn(IbPtr);

#ifdef USE_INOTIFY
		if (IbPtr->i_fd != -1)
		{
/*			IbPtr->i_wd = inotify_add_watch(IbPtr->i_fd, IbPtr->current_wd, 
                         IN_MODIFY | IN_CREATE | IN_DELETE | IN_MOVED_FROM | IN_MOVE_SELF | IN_MOVED_TO | IN_DELETE);*/
/*			IbPtr->i_wd = inotify_add_watch(IbPtr->i_fd, IbPtr->current_wd, 
                         IN_CREATE | IN_DELETE | IN_MOVED_FROM | IN_MOVED_TO | IN_CLOSE_WRITE);
*/
			PutWatchCommand(IbPtr, COMMAND_ADD_WATCH);
//			XtAppAddTimeOut(IbPtr->app, 1000, (XtTimerCallbackProc) TimeOutWatchProc, data);
		}

#ifdef DEBUG_WATCH_DIR
	printf("Filearea: command to queue inserted\n");
#endif

#endif
		
		return 1;
	}
	else
		return 0;
}

static void TimeOutFilesProcessing(XtPointer data);


static int ProcessFops(IfaceBranche * IbPtr)
{
	struct _PreparingRec * rec;
	Widget dialog;
	char * tmp_name;
	int i;
	
#ifdef DEBUG
		printf("ProcessFops\n");
#endif

	for (i = 0; i < IbPtr->copy_move_thread_count; i++)
	{
		rec = (struct _PreparingRec *) IbPtr->fops[i];
		if (rec == NULL)
			continue ;


/**********************************************************************/
		if (rec->OpsCompleted)
		{
			if (0 == pthread_tryjoin_np(rec->task_thread_id, NULL))
			{
#ifdef DEBUG
				if (rec->fops_type == FOPS_IS_COPY_MOVE)
					printf("ProcessFops: copy/move thread joined\n");
				else
					printf("ProcessFops: delete thread joined\n");
#endif
				

				if (rec->ProgressDialogFound) 
					XtDestroyWidget(rec->ProgressDialog);

				if (rec->ControlDialogFound) 
					XtDestroyWidget(rec->ControlDialog);

				IbPtr->copy_move_thread_count--;
				CleanCMData(rec);
				IbPtr->fops[i] = NULL;

#ifndef USE_INOTIFY
				DrawFileArea(IbPtr);
#endif

#ifdef DEBUG
				printf("ProcessFops: DrawFileArea ok -> %s\n", IbPtr->current_wd);
#endif
				continue ;
			}
		}
/**********************************************************************/
		if (rec->wait_user_action)
		{
			if (rec->ProgressDialogFound)
			{
				XtDestroyWidget(rec->ProgressDialog);
				rec->ProgressDialogFound = False;
			}

			if (rec->dialog_type == DIALOG_DESTINATION_DIR_FOUND_TYPE)
			{
				DestinationDirFoundDialog(rec, rec->message);
				if (rec->message)
				{
					free(rec->message);
					rec->message = NULL;
				}
			}

			if (rec->dialog_type == DIALOG_DESTINATION_FILE_FOUND_TYPE)
			{
				DestinationFileFoundDialog(rec, rec->message);
				if (rec->message)
				{
					free(rec->message);
					rec->message = NULL;
				}
			}

			if (rec->dialog_type == DIALOG_NO_READ_TYPE)
			{
				NoReadDialog(rec, rec->message);
				if (rec->message)
				{
					free(rec->message);
					rec->message = NULL;
				}
			}

			if (rec->dialog_type == DIALOG_NO_REMOVE_TYPE)
			{
				NoRemoveDialog(rec, rec->message);
				if (rec->message)
				{
					free(rec->message);
					rec->message = NULL;
				}
			}

			if (rec->dialog_type == DIALOG_NO_WRITE_TYPE)
			{
				NoWriteDialog(rec, rec->message);
				if (rec->message)
				{
					free(rec->message);
					rec->message = NULL;
				}
			}

			if (rec->dialog_type == DIALOG_DELETE_DIR_TYPE)
			{
				DeleteDirErrorDialog(rec, rec->message);
				if (rec->message)
				{
					free(rec->message);
					rec->message = NULL;
				}
			}

			if (rec->dialog_type == DIALOG_DELETE_FILE_TYPE)
			{
				DeleteFileErrorDialog(rec, rec->message);
				if (rec->message)
				{
					free(rec->message);
					rec->message = NULL;
				}
			}

			if (rec->dialog_type == DIALOG_UNKNOWN_ERROR_TYPE)
			{
				UnknownErrorDialog(rec, rec->message);
				if (rec->message)
				{
					free(rec->message);
					rec->message = NULL;
				}
			}

			if (rec->dialog_type == DIALOG_NO_CAN_DO_TYPE)
			{
				NoCanDo(OPERATION_FAILED, IbPtr, CancelAllCB, (XtPointer) rec);
				rec->ControlDialogFound = True;
//				UnknownErrorDialog(rec, rec->message);
				if (rec->message)
				{
					free(rec->message);
					rec->message = NULL;
				}
			}

			rec->wait_user_action = 0;
			continue ;
		}
/**********************************************************************/
		if (!rec->ProgressDialogFound && !rec->ControlDialogFound && !rec->wait_user_action)
		{
#ifdef DEBUG
			printf("ProcessFops: Start new dialog\n");
#endif
			if (rec->fops_type == FOPS_IS_COPY_MOVE)
				CopyMoveProgressDialogNew(rec, "Copy/move");
			else
				DeleteProgressDialog(rec, "Deleting file(s)");

			rec->ProgressDialogFound = True;
		}
	}
	return 0;
}


static int ProcessLoadDir(IfaceBranche * IbPtr)
{
	int n;
	if (IbPtr->reading_process == 1)
	{
#ifdef DEBUG
		printf("===ok reading process\n");
#endif
/** Check terminating of files reading ***/
		if (IbPtr->cancel_reading || IbPtr->load_dir_error_set)
		{
#ifdef DEBUG
		printf("TimeOutWaitsFilesProc: cancel reading or error set\n");
#endif

			if (CheckFileReadJoined(IbPtr))
			{
				if (IbPtr->load_dir_error_set)
				{
					IbPtr->load_dir_error_set = 0;
					NoCanDo(CANT_READ_DIR, IbPtr, NULL, NULL);
					if (IbPtr->load_dir_error_message)
						free(IbPtr->load_dir_error_message);
				}
				DisableWaitCursor(IbPtr);
				IbPtr->reading_process = 0;
			}
			return 0;
		}
/** Check reading empty directory ***/		
		if (IbPtr->nfiles == 0 && IbPtr->ndirs == 0)
		{
			if (CheckFileReadJoined(IbPtr))
			{
				DisableWaitCursor(IbPtr);
				IbPtr->reading_process = 0;
				return 0;
			}
			else
				return 1;
		}
/** Check readed files found ***/		
		if (IbPtr->filesready > 0)
		{
			if (IbPtr->processed == (IbPtr->nfiles + IbPtr->ndirs))
			{
				if (CheckFileReadJoined(IbPtr))
				{
					DisableWaitCursor(IbPtr);
					IbPtr->processed = 0;
#ifdef DEBUG
					printf("------- All dirs and files processed 1 step = %d %d\n", IbPtr->nfiles, IbPtr->ndirs);
#endif
					return 0;
				}
				else
					return 1;
			}

			if (IbPtr->processed < IbPtr->filesready)
			{
				n = ItemAdd(IbPtr, IbPtr->processed, 0);


				IbPtr->processed = IbPtr->processed + n;
#ifdef DEBUG
				printf("---> PrpcessLoadDir: processed %d\n", IbPtr->processed);
#endif
			}

			if (IbPtr->processed < (IbPtr->nfiles + IbPtr->ndirs)) 
			{
#ifdef DEBUG
				printf("------- Processed %d from %d dirs and %d files, need fast processing\n", IbPtr->processed, IbPtr->ndirs, IbPtr->nfiles);
#endif
				return 1;
			}
			else
			{
#ifdef DEBUG
				printf("------- All dirs and files processed step 2 = %d %d\n", IbPtr->ndirs, IbPtr->nfiles);
#endif
				if (CheckFileReadJoined(IbPtr))
				{
					DisableWaitCursor(IbPtr);
					IbPtr->processed = 0;
#ifdef DEBUG
					printf("------- All dirs and files processed 1 step = %d %d\n", IbPtr->ndirs, IbPtr->nfiles);
#endif
					return 0;
				}
				else
					return 1;
			}
		}

/** No response from LoadDir thread => default action  **/
		return 0;
	}
	return 0;
}


Boolean WorkProcFileProcessing(XtPointer data)
{
	IfaceBranche * IbPtr = (IfaceBranche *) data;
	int NeedFastProcessing = 0;
#ifdef USE_INOTIFY
	WatchEvent * WtEv;
	struct filedata * file_ptr;
#endif


	NeedFastProcessing = ProcessLoadDir(IbPtr);
	
#ifdef USE_INOTIFY
	if (IbPtr->reading_process != 1)
		NeedFastProcessing = ProcessWatchEvent(IbPtr) | NeedFastProcessing;
#endif
	
	NeedFastProcessing = ProcessFops(IbPtr) | NeedFastProcessing;

	if (NeedFastProcessing)
	{
		return False;
	}
	else
	{
		XtAppAddTimeOut(IbPtr->app, IDL_TIMEOUT_MAX, (XtTimerCallbackProc) TimeOutFilesProcessing, data);
		return True;
	}

}


static void TimeOutFilesProcessing(XtPointer data)
{
	IfaceBranche * IbPtr = (IfaceBranche *) data;
#ifdef USE_INOTIFY
	WatchEvent * WtEv;
	struct filedata * file_ptr;
#endif
	int NeedFastProcessing = 0;
	
	NeedFastProcessing = ProcessLoadDir(IbPtr);
	
#ifdef USE_INOTIFY
	if (IbPtr->reading_process != 1)
		NeedFastProcessing = ProcessWatchEvent(IbPtr) | NeedFastProcessing;
#endif
	
	NeedFastProcessing = ProcessFops(IbPtr) | NeedFastProcessing;

	if (NeedFastProcessing)
		XtAppAddWorkProc(IbPtr->app, WorkProcFileProcessing, data);
	else
		XtAppAddTimeOut(IbPtr->app, IDL_TIMEOUT_MAX, (XtTimerCallbackProc) TimeOutFilesProcessing, data);

	return ;
}


void StopLoadDir(Widget w, XtPointer client_data, XtPointer call_data)
{
	IfaceBranche * IbPtr = (IfaceBranche *) client_data;
	
	IbPtr->cancel_reading = 1;
}

void GoUpDir(Widget w, XtPointer client_data, XtPointer call_data)
{
	IfaceBranche * IbPtr = (IfaceBranche *) client_data;
	
	chdir_up(IbPtr);
}

void ReDrawFileArea(IfaceBranche * IbPtr)
{
	int i = 0, n = 1;
	XmString string;
	char str[200];
	int all = IbPtr->ndirs + IbPtr->nfiles;

#ifdef DEBUG
	printf("ReDrawFileArea %s\n", IbPtr->current_wd);
#endif
  
	XmNlListDeletAllInfo(IbPtr->fm_scroll_win);

#ifdef DEBUG
	printf("ReDrawFileArea: clean widget\n");
#endif

/* First: sort directories in internal list. */

	sort_dir(IbPtr);

/* Two: display directories. */

	if ((IbPtr->dirs_ptr || IbPtr->files_ptr) && all > 0)
	{
		while (i < all)
		{
			if (IbPtr->CurrentViewType == DETAIL_VIEW)
			{
				n = all - i;
				if (n > 5)
					n = 5;
			}
			ItemAdd(IbPtr, i, n);
			i = i + n;
		}
	}
	
	sprintf(str, "%d %s, %s 0 %s", all, resdata.ItemsNameString, resdata.SelectNameString, resdata.ItemsNameString);
	string = XmStringCreateLocalized(str);

	if (string)
	{
		XtVaSetValues(IbPtr->statusBar, XmNlabelString, string, NULL);
		XmStringFree(string);
	}

#ifdef DEBUG
	printf("Created widgets. Number of file %d\n", IbPtr->nfiles + IbPtr->ndirs);
#endif
}


void CreateIconsSet1(Display * dpy)
{
	XpmCreatePixmapFromData(dpy, DefaultRootWindow(dpy),
					folder_xpm, &dir_xpm, &mask_dir_xpm, NULL);
	XpmCreatePixmapFromData(dpy, DefaultRootWindow(dpy),
					data_file_xpm, &file_xpm, &mask_file_xpm, NULL);
	XpmCreatePixmapFromData(dpy, DefaultRootWindow(dpy),
					linkfile_xpm, &lfile_xpm, &mask_lfile_xpm, NULL);
	XpmCreatePixmapFromData(dpy, DefaultRootWindow(dpy),
					linkfolder_xpm, &ldir_xpm, &mask_ldir_xpm, NULL);
	XpmCreatePixmapFromData(dpy, DefaultRootWindow(dpy),
					file_link_bad_xpm, &lbad_xpm, &mask_lbad_xpm, NULL);


	XpmCreatePixmapFromData(dpy, DefaultRootWindow(dpy),
					small_folder_xpm, &small_dir_xpm, &mask_small_dir_xpm, NULL);
	XpmCreatePixmapFromData(dpy, DefaultRootWindow(dpy),
					data_small_file_xpm, &small_file_xpm, &mask_small_file_xpm, NULL);
	XpmCreatePixmapFromData(dpy, DefaultRootWindow(dpy),
					small_link_file_xpm, &small_lfile_xpm, &mask_small_lfile_xpm, NULL);
	XpmCreatePixmapFromData(dpy, DefaultRootWindow(dpy),
					small_link_folder_xpm, &small_ldir_xpm, &mask_small_ldir_xpm, NULL);
	XpmCreatePixmapFromData(dpy, DefaultRootWindow(dpy),
					file_link_bad_small_xpm, &small_lbad_xpm, &mask_small_lbad_xpm, NULL);
}


void DrawFileArea(IfaceBranche * IbPtr)
{
	Display *mydisplay;
	XmString string;
	char str[200];

	if (dir_xpm <= XmUNSPECIFIED_PIXMAP) {
		mydisplay = XtDisplay(IbPtr->top_level);
//		myscreen = XtScreen(IbPtr->fm_scroll_win);

		XpmCreatePixmapFromData(mydisplay, DefaultRootWindow(mydisplay),
					folder_xpm, &dir_xpm, &mask_dir_xpm, NULL);
		XpmCreatePixmapFromData(mydisplay, DefaultRootWindow(mydisplay),
					data_file_xpm, &file_xpm, &mask_file_xpm, NULL);
		XpmCreatePixmapFromData(mydisplay, DefaultRootWindow(mydisplay),
					linkfile_xpm, &lfile_xpm, &mask_lfile_xpm, NULL);
		XpmCreatePixmapFromData(mydisplay, DefaultRootWindow(mydisplay),
					linkfolder_xpm, &ldir_xpm, &mask_ldir_xpm, NULL);
		XpmCreatePixmapFromData(mydisplay, DefaultRootWindow(mydisplay),
					file_link_bad_xpm, &lbad_xpm, &mask_lbad_xpm, NULL);


		XpmCreatePixmapFromData(mydisplay, DefaultRootWindow(mydisplay),
					small_folder_xpm, &small_dir_xpm, &mask_small_dir_xpm, NULL);
		XpmCreatePixmapFromData(mydisplay, DefaultRootWindow(mydisplay),
					data_small_file_xpm, &small_file_xpm, &mask_small_file_xpm, NULL);
		XpmCreatePixmapFromData(mydisplay, DefaultRootWindow(mydisplay),
					small_link_file_xpm, &small_lfile_xpm, &mask_small_lfile_xpm, NULL);
		XpmCreatePixmapFromData(mydisplay, DefaultRootWindow(mydisplay),
					small_link_folder_xpm, &small_ldir_xpm, &mask_small_ldir_xpm, NULL);
		XpmCreatePixmapFromData(mydisplay, DefaultRootWindow(mydisplay),
					file_link_bad_small_xpm, &small_lbad_xpm, &mask_small_lbad_xpm, NULL);

	}

printf("Case %d\n", IbPtr->CaseSensitiveSorting);

#ifdef DEBUG
	printf("DrawFileArea %s thread %d address %p\n", IbPtr->current_wd, IbPtr->thread_number, IbPtr);
	printf("Id from IbPtr %ld Self Id %ld\n", IbPtr->thread_id, pthread_self());
			if (pthread_equal(IbPtr->thread_id, pthread_self()))
				printf("THREAD OK\n");
			else
				printf("THREAD WRONG\n");
#endif
 
	XmNlListDeletAllInfo(IbPtr->fm_scroll_win);

  
  /* First pass: display directories. */

	clear_dir_list(IbPtr);
	IbPtr->reading_process = 1;
	
	IbPtr->filesready = 0;
	IbPtr->cancel_reading = 0;
	IbPtr->processed = 0;
	IbPtr->load_dir_joined = 0;
	if (IbPtr->load_dir_error_message)
		free(IbPtr->load_dir_error_message);
	IbPtr->load_dir_error_message = NULL;
	IbPtr->load_dir_error_set = 0;

	XtVaSetValues(IbPtr->stop_load_dir, XmNsensitive, True, NULL);
	XtVaSetValues(IbPtr->go_up_dir, XmNsensitive, False, NULL);
	XtVaSetValues(IbPtr->go, XmNsensitive, False, NULL);
	XtVaSetValues(IbPtr->fm_textfield, XmNsensitive, False, NULL);

	MenuToOff(IbPtr);

	pthread_create(&(IbPtr->files_thread_id), NULL, LoadDirThread, (void *) IbPtr);
//	XtAppAddTimeOut(IbPtr->app, 250, (XtTimerCallbackProc) TimeOutWaitsFilesProc, (XtPointer) IbPtr);
	if (IbPtr->first_time == 1)
	{
		XtAppAddTimeOut(IbPtr->app, 250, (XtTimerCallbackProc) TimeOutFilesProcessing, (XtPointer) IbPtr);
		IbPtr->first_time = 0;
	}
	
	EnableWaitCursor(IbPtr);
	
	sprintf(str, "%s 0 %s", resdata.SelectNameString, resdata.ItemsNameString);
	
	string = XmStringCreateLocalized(str);

	if (string)
	{
		XtVaSetValues(IbPtr->statusBar, XmNlabelString, string, NULL);
		XmStringFree(string);
	}

#ifdef DEBUG
	printf("Created widgets. \n");
#endif
}

void HandleDrop(Widget, XtPointer, XtPointer);


void HglCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
	IfaceBranche * IbPtr = (IfaceBranche * ) client_data;
    ListItemReturnStruct * rez = (ListItemReturnStruct *) call_data;
	int i;
	Boolean ok;
	XmString xmstr;
	char str[200], str2[100];
	XmNlCell SelectedCells;
	struct filedata * file_ptr = NULL;
	struct fileinfo * file_info = NULL;
	off_t size = 0;

	
	if (0 == rez->count)
	{
		sprintf(str, "%d %s, %s 0 %s", IbPtr->nfiles, resdata.ItemsNameString, resdata.SelectNameString, resdata.ItemsNameString);

		xmstr = XmStringCreateLocalized(str);
		
		if (xmstr)
		{
			XtVaSetValues(IbPtr->statusBar, XmNlabelString, xmstr, NULL);
			XmStringFree(xmstr);
		}
		
		return ;
	}

	for (i = 0; i < rez->count; i++ )
	{
		ok = XmNlListGetItem(IbPtr->fm_scroll_win, &SelectedCells, CellUserData, rez->number[i]);
		if (ok)
		{
#ifdef DEBUG
			printf("Item %d\n", rez->number[i]);
#endif
			file_ptr = (struct filedata *) SelectedCells.UserDataPointer;
			if (!file_ptr->info)
					continue;

			file_info = file_ptr->info;
			
			if ( S_ISREG(file_info->f_perm))
				size = size + file_info->f_size;

#ifdef DEBUG
			printf("........ added selected size: %ld\n", file_info->f_size);
#endif
		}
	}

	get_human_readable_size(size, str2, 0);

	sprintf(str, "%d %s, %s %d %s, %s", IbPtr->nfiles, resdata.ItemsNameString, resdata.SelectNameString, rez->count, resdata.ItemsNameString, str2);

	xmstr = XmStringCreateLocalized(str);
	
	if (xmstr)
	{
		XtVaSetValues(IbPtr->statusBar, XmNlabelString, xmstr, NULL);
		XmStringFree(xmstr);
	}

/*	for (i=0; i<rez->count; i++)
	{
		printf("xmnllist4: selected item=%d\n", rez->number[i]);
	}*/
}


int comparerDescendLargeSmall(const void * ptr1, const void * ptr2)
{
	Widget itb;
	XmNlCell cell1, cell2;
	IfaceBranche * IbPtr;
	int found = 0;
	struct filedata * file1, * file2;


	pthread_mutex_lock(&iface_mutex);

	IbPtr = AllIfaceBranches;
	while (IbPtr)
	{
		if (pthread_equal(IbPtr->thread_id, pthread_self()))
		{
			found = 1;
			break;
		}
		else
			IbPtr = IbPtr->next_branche;
	}
	pthread_mutex_unlock(&iface_mutex);

	if (found)
	{
		itb = XmNlListGetIBWidget(IbPtr->fm_scroll_win);
		XmNlItBoxGetItemAtPointer(itb, &cell1, CellUserData, ptr1);
		XmNlItBoxGetItemAtPointer(itb, &cell2, CellUserData, ptr2);

		file1 = (struct filedata *) cell1.UserDataPointer;
		file2 = (struct filedata *) cell2.UserDataPointer;
	
#ifdef DEBUG
		printf("1 arg = %s\n", (char *) (file1->name));
		printf("2 arg = %s\n", (char *) (file2->name));
#endif

		switch (IbPtr->SortingCategory) 
		{
			case SORTING_NAME:
				if (IbPtr->CaseSensitiveSorting)
					return strcmp((char *)(file2->name), (char *)(file1->name));
				else
					return strcasecmp((char *)(file2->name), (char *)(file1->name));
				break;
			case SORTING_SIZE:
				if (file2->info->f_size == file1->info->f_size)
					return 0;
				if (file2->info->f_size > file1->info->f_size)
					return 1;
				if (file2->info->f_size < file1->info->f_size)
					return -1;
				break;
			case SORTING_DATE:
				if (file2->info->f_mtime == file1->info->f_mtime)
					return 0;
				if (file2->info->f_mtime > file1->info->f_mtime)
					return 1;
				if (file2->info->f_mtime < file1->info->f_mtime)
					return -1;
				break;
			default:
				return 0;
				break;
		}
	}
}

int comparerAscendLargeSmall(const void * ptr1, const void * ptr2)
{
	Widget itb;
	XmNlCell cell1, cell2;
	IfaceBranche * IbPtr;
	int found = 0;
	struct filedata * file1, * file2;


	pthread_mutex_lock(&iface_mutex);

	IbPtr = AllIfaceBranches;
	while (IbPtr)
	{
		if (pthread_equal(IbPtr->thread_id, pthread_self()))
		{
			found = 1;
			break;
		}
		else
			IbPtr = IbPtr->next_branche;
	}
	pthread_mutex_unlock(&iface_mutex);

	if (found)
	{
		itb = XmNlListGetIBWidget(IbPtr->fm_scroll_win);
		XmNlItBoxGetItemAtPointer(itb, &cell1, CellUserData, ptr1);
		XmNlItBoxGetItemAtPointer(itb, &cell2, CellUserData, ptr2);

		file1 = (struct filedata *) cell1.UserDataPointer;
		file2 = (struct filedata *) cell2.UserDataPointer;
	
#ifdef DEBUG
		printf("1 arg = %s\n", (char *) (file1->name));
		printf("2 arg = %s\n", (char *) (file2->name));
#endif

		switch (IbPtr->SortingCategory) 
		{
			case SORTING_NAME:
				if (IbPtr->CaseSensitiveSorting)
					return strcmp((char *)(file1->name), (char *)(file2->name));
				else
					return strcasecmp((char *)(file1->name), (char *)(file2->name));
				break;
			case SORTING_SIZE:
				if (file1->info->f_size == file2->info->f_size)
					return 0;
				if (file1->info->f_size > file2->info->f_size)
					return 1;
				if (file1->info->f_size < file2->info->f_size)
					return -1;
				break;
			case SORTING_DATE:
				if (file1->info->f_mtime == file2->info->f_mtime)
					return 0;
				if (file1->info->f_mtime > file2->info->f_mtime)
					return 1;
				if (file1->info->f_mtime < file2->info->f_mtime)
					return -1;
				break;
			default:
				return 0;
				break;
		}
	}
}


int comparerDescendDetail(const void * ptr1, const void * ptr2)
{
	Widget rc;
	XmNlCell cell1, cell2;
	IfaceBranche * IbPtr;
	int found = 0;
	struct filedata * file1, * file2;


	pthread_mutex_lock(&iface_mutex);

	IbPtr = AllIfaceBranches;
	while (IbPtr)
	{
		if (pthread_equal(IbPtr->thread_id, pthread_self()))
		{
			found = 1;
			break;
		}
		else
			IbPtr = IbPtr->next_branche;
	}
	pthread_mutex_unlock(&iface_mutex);

	if (found)
	{
		rc = XmNlListGetRCWidget(IbPtr->fm_scroll_win);
		XmNlResColGetCellAtPointer(rc, &cell1, CellUserData, ptr1, 0);
		XmNlResColGetCellAtPointer(rc, &cell2, CellUserData, ptr2, 0);

		file1 = (struct filedata *) cell1.UserDataPointer;
		file2 = (struct filedata *) cell2.UserDataPointer;
	
#ifdef DEBUG
		printf("1 arg = %s\n", (char *) (file1->name));
		printf("2 arg = %s\n", (char *) (file2->name));
#endif

		switch (IbPtr->SortingCategory) 
		{
			case SORTING_NAME:
				if (IbPtr->CaseSensitiveSorting)
					return strcmp((char *)(file2->name), (char *)(file1->name));
				else
					return strcasecmp((char *)(file2->name), (char *)(file1->name));
				break;
			case SORTING_SIZE:
				if (file2->info->f_size == file1->info->f_size)
					return 0;
				if (file2->info->f_size > file1->info->f_size)
					return 1;
				if (file2->info->f_size < file1->info->f_size)
					return -1;
				break;
			case SORTING_DATE:
				if (file2->info->f_mtime == file1->info->f_mtime)
					return 0;
				if (file2->info->f_mtime > file1->info->f_mtime)
					return 1;
				if (file2->info->f_mtime < file1->info->f_mtime)
					return -1;
				break;
			default:
				return 0;
				break;
		}
	}
}


int comparerAscendDetail(const void * ptr1, const void * ptr2)
{
	Widget rc;
	XmNlCell cell1, cell2;
	IfaceBranche * IbPtr;
	int found = 0;
	struct filedata * file1, * file2;


	pthread_mutex_lock(&iface_mutex);

	IbPtr = AllIfaceBranches;
	while (IbPtr)
	{
		if (pthread_equal(IbPtr->thread_id, pthread_self()))
		{
			found = 1;
			break;
		}
		else
			IbPtr = IbPtr->next_branche;
	}
	pthread_mutex_unlock(&iface_mutex);

	if (found)
	{
		rc = XmNlListGetRCWidget(IbPtr->fm_scroll_win);
		XmNlResColGetCellAtPointer(rc, &cell1, CellUserData, ptr1, 0);
		XmNlResColGetCellAtPointer(rc, &cell2, CellUserData, ptr2, 0);

		file1 = (struct filedata *) cell1.UserDataPointer;
		file2 = (struct filedata *) cell2.UserDataPointer;
	
#ifdef DEBUG
		printf("1 arg = %s\n", (char *) (file1->name));
		printf("2 arg = %s\n", (char *) (file2->name));
#endif

		switch (IbPtr->SortingCategory) 
		{
			case SORTING_NAME:
				if (IbPtr->CaseSensitiveSorting)
					return strcmp((char *)(file1->name), (char *)(file2->name));
				else
					return strcasecmp((char *)(file1->name), (char *)(file2->name));
				break;
			case SORTING_SIZE:
				if (file1->info->f_size == file2->info->f_size)
					return 0;
				if (file1->info->f_size > file2->info->f_size)
					return 1;
				if (file1->info->f_size < file2->info->f_size)
					return -1;
				break;
			case SORTING_DATE:
				if (file1->info->f_mtime == file2->info->f_mtime)
					return 0;
				if (file1->info->f_mtime > file2->info->f_mtime)
					return 1;
				if (file1->info->f_mtime < file2->info->f_mtime)
					return -1;
				break;
			default:
				return 0;
				break;
		}
	}
}


void ReSortDirs(IfaceBranche * IbPtr)
{
	int start_row = 0;
	int i, row_num, end_row, row_counter;
	Widget file_view_wid;


	if (IbPtr->ParentDirShow) start_row++;
	if (IbPtr->CurrentDirShow) start_row++;

	if (IbPtr->CurrentViewType == DETAIL_VIEW)
		file_view_wid = XmNlListGetRCWidget(IbPtr->fm_scroll_win);
	else
		file_view_wid = XmNlListGetIBWidget(IbPtr->fm_scroll_win);

	XtVaGetValues(file_view_wid, XmNitemCount, &row_num, NULL);

	if (start_row >= row_num || start_row >= IbPtr->ndirs)
		return ;

	row_counter = IbPtr->ndirs - start_row;
	
	if (row_counter > row_num)
		return ;


	if (IbPtr->SortingType == SORTING_DESCEND)
	{
#ifdef DEBUG
		printf("Sort directory from %d with lenght %d\n", start_row, row_counter);
#endif
		if (IbPtr->CurrentViewType == DETAIL_VIEW)
			XmNlResColSort(file_view_wid, start_row, row_counter, comparerDescendDetail);
		else
			XmNlItBoxSort(file_view_wid, start_row, row_counter, comparerDescendLargeSmall);
	}
	else
	{
#ifdef DEBUG
		printf("Sort directory from %d with lenght %d\n", start_row, row_counter);
#endif
		if (IbPtr->CurrentViewType == DETAIL_VIEW)
			XmNlResColSort(file_view_wid, start_row, row_counter, comparerAscendDetail);
		else
			XmNlItBoxSort(file_view_wid, start_row, row_counter, comparerAscendLargeSmall);
	}
}

void ReSortFiles(IfaceBranche * IbPtr)
{
	int start_row = 0;
	int i, row_num, end_row, row_counter;
	Widget file_view_wid;


	start_row = IbPtr->ndirs;

	if (IbPtr->CurrentViewType == DETAIL_VIEW)
		file_view_wid = XmNlListGetRCWidget(IbPtr->fm_scroll_win);
	else
		file_view_wid = XmNlListGetIBWidget(IbPtr->fm_scroll_win);

	XtVaGetValues(file_view_wid, XmNitemCount, &row_num, NULL);

	if (start_row >= row_num || start_row >= (IbPtr->ndirs + IbPtr->nfiles))
		return ;

	row_counter = IbPtr->nfiles;
	
	if (row_counter > row_num)
		return ;


	if (IbPtr->SortingType == SORTING_DESCEND)
	{
#ifdef DEBUG
		printf("Sort directory from %d with lenght %d\n", start_row, row_counter);
#endif
		if (IbPtr->CurrentViewType == DETAIL_VIEW)
			XmNlResColSort(file_view_wid, start_row, row_counter, comparerDescendDetail);
		else
			XmNlItBoxSort(file_view_wid, start_row, row_counter, comparerDescendLargeSmall);
	}
	else
	{
#ifdef DEBUG
		printf("Sort directory from %d with lenght %d\n", start_row, row_counter);
#endif
		if (IbPtr->CurrentViewType == DETAIL_VIEW)
			XmNlResColSort(file_view_wid, start_row, row_counter, comparerAscendDetail);
		else
			XmNlItBoxSort(file_view_wid, start_row, row_counter, comparerAscendLargeSmall);
	}
}

void ReSort(IfaceBranche * IbPtr)
{
	ReSortDirs(IbPtr);
	ReSortFiles(IbPtr);
}


void CleanTitle(IfaceBranche * IbPtr)
{
	XmNlColSpecRec * colspec;
	Arg args[20];
	int n;

	switch (IbPtr->SortingCategory) 
	{
		case SORTING_NAME:
			n = 0;
			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
			XtSetArg( args[n], XmNtileType, XmSTRING); n++;
			XtSetArg( args[n], XmNlabelString, XmNameTitleString); n++;

			colspec = XmNlColSpecCreate(XtDisplay(IbPtr->fm_scroll_win), NULL, "Col1", args, n);
			XmNlListSetColumn(IbPtr->fm_scroll_win, colspec, 1);
			XmNlColSpecFree(colspec);
			break;
		case SORTING_SIZE:
			n = 0;
			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
			XtSetArg( args[n], XmNtileType, XmSTRING); n++;
			XtSetArg( args[n], XmNlabelString, XmSizeTitleString); n++;

			colspec = XmNlColSpecCreate(XtDisplay(IbPtr->fm_scroll_win), NULL, "Col2", args, n);
			XmNlListSetColumn(IbPtr->fm_scroll_win, colspec, 2);
			XmNlColSpecFree(colspec);
			break;
		case SORTING_DATE:
			n = 0;
			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
			XtSetArg( args[n], XmNtileType, XmSTRING); n++;
			XtSetArg( args[n], XmNlabelString, XmDateTitleString); n++;

			colspec = XmNlColSpecCreate(XtDisplay(IbPtr->fm_scroll_win), NULL, "Col3", args, n);
			XmNlListSetColumn(IbPtr->fm_scroll_win, colspec, 3);
			XmNlColSpecFree(colspec);
			break;
		default:
			return ;
			break;
	}
}

void SortSwitchCB(Widget w, XtPointer client_data, XtPointer call_data)
{
	IfaceBranche * IbPtr;
	ListTileActivateReturnStruct * rez = (ListTileActivateReturnStruct *) call_data;
	XmNlColSpecRec * colspec;
	Arg args[20];
	int n;

	IbPtr = (IfaceBranche *) client_data;

	switch (rez->col_number) 
	{
		case 1:
			n = 0;
			XtSetArg( args[n], XmNtileType, XmPIXMAP_AND_STRING); n++;
			XtSetArg( args[n], XmNpixmapPlacement, XmPIXMAP_RIGHT); n++;
			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_CENTER); n++;

			if (IbPtr->SortingCategory != SORTING_NAME)
			{
				CleanTitle(IbPtr);
				IbPtr->SortingCategory = SORTING_NAME;
				IbPtr->SortingType = SORTING_ASCEND;
				XtSetArg( args[n], XtNtilePixmap, downSortIcon); n++;
			}
			else
			{
				if (IbPtr->SortingType == SORTING_ASCEND)
				{
					IbPtr->SortingType = SORTING_DESCEND;
					XtSetArg( args[n], XtNtilePixmap, upSortIcon); n++;
					XtSetArg( args[n], XtNtilePixmapMask, upSortMask); n++;
				}
				else
				{
					IbPtr->SortingType = SORTING_ASCEND;
					XtSetArg( args[n], XtNtilePixmap, downSortIcon); n++;
					XtSetArg( args[n], XtNtilePixmapMask, downSortMask); n++;
				}
			}
			XtSetArg( args[n], XmNlabelString, XmNameTitleString); n++;
			colspec = XmNlColSpecCreate(XtDisplay(IbPtr->fm_scroll_win), NULL, "Col1", args, n);
			XmNlListSetColumn(IbPtr->fm_scroll_win, colspec, 1);
			XmNlColSpecFree(colspec);

			ReSort(IbPtr);

			if (IbPtr->sort_name_bt && IbPtr->sort_date_bt && IbPtr->sort_size_bt && IbPtr->sort_reverse_bt)
			{
				XmToggleButtonSetState(IbPtr->sort_name_bt, True, False);
				XmToggleButtonSetState(IbPtr->sort_size_bt, False, False);
				XmToggleButtonSetState(IbPtr->sort_date_bt, False, False);
				if (IbPtr->SortingType == SORTING_DESCEND)
					XmToggleButtonSetState(IbPtr->sort_reverse_bt, True, False);
				else
					XmToggleButtonSetState(IbPtr->sort_reverse_bt, False, False);
			}
			
			break;
		case 2:
			n = 0;
			XtSetArg( args[n], XmNtileType, XmPIXMAP_AND_STRING); n++;
			XtSetArg( args[n], XmNpixmapPlacement, XmPIXMAP_RIGHT); n++;
			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_CENTER); n++;

			if (IbPtr->SortingCategory != SORTING_SIZE)
			{
				CleanTitle(IbPtr);
				IbPtr->SortingCategory = SORTING_SIZE;
				IbPtr->SortingType = SORTING_ASCEND;
				XtSetArg( args[n], XtNtilePixmap, downSortIcon); n++;
				XtSetArg( args[n], XtNtilePixmapMask, downSortMask); n++;
			}
			else
			{
				if (IbPtr->SortingType == SORTING_ASCEND)
				{
					IbPtr->SortingType = SORTING_DESCEND;
					XtSetArg( args[n], XtNtilePixmap, upSortIcon); n++;
					XtSetArg( args[n], XtNtilePixmapMask, upSortMask); n++;
				}
				else
				{
					IbPtr->SortingType = SORTING_ASCEND;
					XtSetArg( args[n], XtNtilePixmap, downSortIcon); n++;
					XtSetArg( args[n], XtNtilePixmapMask, downSortMask); n++;
				}
			}
			XtSetArg( args[n], XmNlabelString, XmSizeTitleString); n++;
			colspec = XmNlColSpecCreate(XtDisplay(IbPtr->fm_scroll_win), NULL, "Col2", args, n);
			XmNlListSetColumn(IbPtr->fm_scroll_win, colspec, 2);
			XmNlColSpecFree(colspec);

			ReSort(IbPtr);
			if (IbPtr->sort_name_bt && IbPtr->sort_date_bt && IbPtr->sort_size_bt && IbPtr->sort_reverse_bt)
			{
				XmToggleButtonSetState(IbPtr->sort_size_bt, True, False);
				XmToggleButtonSetState(IbPtr->sort_name_bt, False, False);
				XmToggleButtonSetState(IbPtr->sort_date_bt, False, False);
				if (IbPtr->SortingType == SORTING_DESCEND)
					XmToggleButtonSetState(IbPtr->sort_reverse_bt, True, False);
				else
					XmToggleButtonSetState(IbPtr->sort_reverse_bt, False, False);
			}

			break;
		case 3:
			n = 0;
			XtSetArg( args[n], XmNtileType, XmPIXMAP_AND_STRING); n++;
			XtSetArg( args[n], XmNpixmapPlacement, XmPIXMAP_RIGHT); n++;
			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_CENTER); n++;

			if (IbPtr->SortingCategory != SORTING_DATE)
			{
				CleanTitle(IbPtr);
				IbPtr->SortingCategory = SORTING_DATE;
				IbPtr->SortingType = SORTING_ASCEND;
				XtSetArg( args[n], XtNtilePixmap, downSortIcon); n++;
				XtSetArg( args[n], XtNtilePixmapMask, downSortMask); n++;
			}
			else
			{
				if (IbPtr->SortingType == SORTING_ASCEND)
				{
					IbPtr->SortingType = SORTING_DESCEND;
					XtSetArg( args[n], XtNtilePixmap, upSortIcon); n++;
					XtSetArg( args[n], XtNtilePixmapMask, upSortMask); n++;
				}
				else
				{
					IbPtr->SortingType = SORTING_ASCEND;
					XtSetArg( args[n], XtNtilePixmap, downSortIcon); n++;
					XtSetArg( args[n], XtNtilePixmapMask, downSortMask); n++;
				}
			}
			XtSetArg( args[n], XmNlabelString, XmDateTitleString); n++;
			colspec = XmNlColSpecCreate(XtDisplay(IbPtr->fm_scroll_win), NULL, "Col3", args, n);
			XmNlListSetColumn(IbPtr->fm_scroll_win, colspec, 3);
			XmNlColSpecFree(colspec);

			ReSort(IbPtr);

			if (IbPtr->sort_name_bt && IbPtr->sort_date_bt && IbPtr->sort_size_bt && IbPtr->sort_reverse_bt)
			{
				XmToggleButtonSetState(IbPtr->sort_date_bt, True, False);
				XmToggleButtonSetState(IbPtr->sort_size_bt, False, False);
				XmToggleButtonSetState(IbPtr->sort_name_bt, False, False);
				if (IbPtr->SortingType == SORTING_DESCEND)
					XmToggleButtonSetState(IbPtr->sort_reverse_bt, True, False);
				else
					XmToggleButtonSetState(IbPtr->sort_reverse_bt, False, False);
			}
			break;
		default:
			return ;
			break;
	}
}

void SetFileViewAttributs(IfaceBranche * IbPtr)
{
	XmNlColSpecRec * colspec;
	Arg args[20];
	int n;
	unsigned char cur_mode;
	Atom *importTargets, *newTargets;
	Atom importList[2];
	Widget file_view_wid;
	unsigned char valuemask = CellXmString | CellPixmap | CellAlignment | CellPriority;


#ifdef DEBUG
	printf("SetAttrib Id from IbPtr %ld Self Id %ld\n", IbPtr->thread_id, pthread_self());
#endif
	XtVaGetValues(IbPtr->fm_scroll_win,
					XmNViewListType, &cur_mode,
					NULL);

	if (IbPtr->CurrentViewType == LARGE_VIEW)
	{
		XtVaSetValues(IbPtr->fm_scroll_win,
						XmNViewListType, XmNlList_Big,
						NULL);

		file_view_wid = XmNlListGetIBWidget(IbPtr->fm_scroll_win);

		if (IbPtr->DropSiteRegisterNeedIbox)
		{
			XtAugmentTranslations(file_view_wid, IbPtr->parsed_trans);
			importList[0] = FILE_NAME;
			n = 0;
			XtSetArg (args[n], XmNimportTargets, importList); n++;
			XtSetArg (args[n], XmNnumImportTargets, 1); n++;
			XtSetArg (args[n], XmNdropSiteOperations, XmDROP_COPY); n++;
			XtSetArg (args[n], XmNdropProc, HandleDrop); n++;
			XmDropSiteRegister (file_view_wid, args, n);
			IbPtr->DropSiteRegisterNeedIbox = 0;
		}

#ifdef DEBUG
		printf("++++++++++++++++++ SetFileViewAttributs DnD drop site registered for large mode view\n");
#endif
	}
	if (IbPtr->CurrentViewType == SMALL_VIEW) 
	{
		XtVaSetValues(IbPtr->fm_scroll_win,
						XmNViewListType, XmNlList_Small,
						NULL);

		file_view_wid = XmNlListGetIBWidget(IbPtr->fm_scroll_win);
		if (IbPtr->DropSiteRegisterNeedIbox)
		{
			XtAugmentTranslations(file_view_wid, IbPtr->parsed_trans);
			importList[0] = FILE_NAME;
			n = 0;
			XtSetArg (args[n], XmNimportTargets, importList); n++;
			XtSetArg (args[n], XmNnumImportTargets, 1); n++;
			XtSetArg (args[n], XmNdropSiteOperations, XmDROP_COPY); n++;
			XtSetArg (args[n], XmNdropProc, HandleDrop); n++;
			XmDropSiteRegister (file_view_wid, args, n);
			IbPtr->DropSiteRegisterNeedIbox = 0;
#ifdef DEBUG
		printf("++++++++++++++++++ SetFileViewAttributs DnD drop site registered for small mode view\n");
#endif
		}

	}

	if (IbPtr->CurrentViewType == DETAIL_VIEW) 
	{
		XtVaSetValues(IbPtr->fm_scroll_win,
						XmNViewListType, XmNlList_Detail, NULL);

//		XmNlListSetAutoresCol(IbPtr->fm_scroll_win, 1);
		
		file_view_wid = XmNlListGetRCWidget(IbPtr->fm_scroll_win);
		if (IbPtr->DropSiteRegisterNeedDeatail)
		{
			XtAugmentTranslations(file_view_wid, IbPtr->parsed_trans);
			importList[0] = FILE_NAME;
			n = 0;
			XtSetArg (args[n], XmNimportTargets, importList); n++;
			XtSetArg (args[n], XmNnumImportTargets, 1); n++;
			XtSetArg (args[n], XmNdropSiteOperations, XmDROP_COPY); n++;
			XtSetArg (args[n], XmNdropProc, HandleDrop); n++;
			XmDropSiteRegister (file_view_wid, args, n);
			IbPtr->DropSiteRegisterNeedDeatail = 0;
		}
/***************************** 0 **************************************/
		n = 0;
		XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNcolType, XmPIXMAP); n++;

		XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNtileType, XmSTRING); n++;
		XtSetArg( args[n], XmNlabelString, XmIconTitleString); n++;

		colspec = XmNlColSpecCreate(XtDisplay(file_view_wid), NULL, "Col0", args, n);
		XmNlResColAppendColumn(file_view_wid, colspec);
		XmNlColSpecFree(colspec);

/***************************** 1 **************************************/
		n = 0;
		XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNcolType, XmSTRING); n++;

		if (IbPtr->SortingCategory == SORTING_NAME)
		{
			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_CENTER); n++;
			XtSetArg( args[n], XmNtileType, XmPIXMAP_AND_STRING); n++;
			XtSetArg( args[n], XmNpixmapPlacement, XmPIXMAP_RIGHT); n++;
			
			if (IbPtr->SortingType == SORTING_ASCEND)
			{
				XtSetArg( args[n], XtNtilePixmap, downSortIcon); n++;
				XtSetArg( args[n], XtNtilePixmapMask, downSortMask); n++;
			}
			else
			{
				XtSetArg( args[n], XtNtilePixmap, upSortIcon); n++;
				XtSetArg( args[n], XtNtilePixmapMask, upSortMask); n++;
			}
		}
		else
		{
			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
			XtSetArg( args[n], XmNtileType, XmSTRING); n++;
		}

		XtSetArg( args[n], XmNlabelString, XmNameTitleString); n++;

		colspec = XmNlColSpecCreate(XtDisplay(file_view_wid), NULL, "Col1", args, n);
		XmNlResColAppendColumn(file_view_wid, colspec);
		XmNlColSpecFree(colspec);
		
/***************************** 2 **************************************/
		n = 0;
		XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNcolType, XmSTRING); n++;

		if (IbPtr->SortingCategory == SORTING_SIZE)
		{
			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_CENTER); n++;
			XtSetArg( args[n], XmNtileType, XmPIXMAP_AND_STRING); n++;
			XtSetArg( args[n], XmNpixmapPlacement, XmPIXMAP_RIGHT); n++;
			
			if (IbPtr->SortingType == SORTING_ASCEND)
			{
				XtSetArg( args[n], XtNtilePixmap, downSortIcon); n++;
				XtSetArg( args[n], XtNtilePixmapMask, downSortMask); n++;
			}
			else
			{
				XtSetArg( args[n], XtNtilePixmap, upSortIcon); n++;
				XtSetArg( args[n], XtNtilePixmapMask, upSortMask); n++;
			}
		}
		else
		{
			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
			XtSetArg( args[n], XmNtileType, XmSTRING); n++;
		}

		XtSetArg( args[n], XmNlabelString, XmSizeTitleString); n++;

		colspec = XmNlColSpecCreate(XtDisplay(file_view_wid), NULL, "Col2", args, n);
		XmNlResColAppendColumn(file_view_wid, colspec);
		XmNlColSpecFree(colspec);

/***************************** 3 **************************************/
		n = 0;
		XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNcolType, XmSTRING); n++;

		XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
		if (IbPtr->SortingCategory == SORTING_DATE)
		{
			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_CENTER); n++;
			XtSetArg( args[n], XmNtileType, XmPIXMAP_AND_STRING); n++;
			XtSetArg( args[n], XmNpixmapPlacement, XmPIXMAP_RIGHT); n++;
			
			if (IbPtr->SortingType == SORTING_ASCEND)
			{
				XtSetArg( args[n], XtNtilePixmap, downSortIcon); n++;
				XtSetArg( args[n], XtNtilePixmapMask, downSortMask); n++;
			}
			else
			{
				XtSetArg( args[n], XtNtilePixmap, upSortIcon); n++;
				XtSetArg( args[n], XtNtilePixmapMask, upSortMask); n++;
			}
		}
		else
		{
			XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
			XtSetArg( args[n], XmNtileType, XmSTRING); n++;
		}

		XtSetArg( args[n], XmNlabelString, XmDateTitleString); n++;

		colspec = XmNlColSpecCreate(XtDisplay(file_view_wid), NULL, "Col3", args, n);
		XmNlResColAppendColumn(file_view_wid, colspec);
		XmNlColSpecFree(colspec);

/***************************** 4 **************************************/
		n = 0;
		XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNcolType, XmSTRING); n++;

		XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNtileType, XmSTRING); n++;
		XtSetArg( args[n], XmNlabelString, XmPermTitleString); n++;

		colspec = XmNlColSpecCreate(XtDisplay(file_view_wid), NULL, "Col4", args, n);
		XmNlResColAppendColumn(file_view_wid, colspec);
		XmNlColSpecFree(colspec);

/***************************** 5 **************************************/
		n = 0;
		XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNcolType, XmSTRING); n++;

		XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNtileType, XmSTRING); n++;
		XtSetArg( args[n], XmNlabelString, XmOwnerTitleString); n++;

		colspec = XmNlColSpecCreate(XtDisplay(file_view_wid), NULL, "Col5", args, n);
		XmNlResColAppendColumn(file_view_wid, colspec);
		XmNlColSpecFree(colspec);

/***************************** 6 **************************************/
		n = 0;
		XtSetArg( args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNcolType, XmSTRING); n++;

		XtSetArg( args[n], XmNtileAlignment, XmALIGNMENT_BEGINNING); n++;
		XtSetArg( args[n], XmNtileType, XmSTRING); n++;
		XtSetArg( args[n], XmNlabelString, XmOwnergrpTitleString); n++;

		colspec = XmNlColSpecCreate(XtDisplay(file_view_wid), NULL, "Col6", args, n);
		XmNlResColAppendColumn(file_view_wid, colspec);
		XmNlColSpecFree(colspec);

		XmNlListSetAutoresCol(IbPtr->fm_scroll_win, 1);

		if (!IbPtr->resort_callback_installed)
		{
			XtAddCallback(IbPtr->fm_scroll_win, XmNlTileClickedCallback, SortSwitchCB, (XtPointer) IbPtr); 
			IbPtr->resort_callback_installed = 1;
		}

		
#ifdef DEBUG
		printf("\n RCSetPropertyRow complet\n");
#endif
	}

	if (!IbPtr->HlgCallbackAttached)
	{
		XtAddCallback(IbPtr->fm_scroll_win, XtNhighlightCallback, HglCallback, (XtPointer) IbPtr); 
		IbPtr->HlgCallbackAttached = 1;
	}

//	XtInsertEventHandler(file_view_wid, ButtonPressMask, False,
//						(XtEventHandler)FilePopupH, NULL, XtListTail);

/*	XtAddEventHandler(file_view_wid, SelectionNotify | SelectionRequest | SelectionClear, True,
						(XtEventHandler)SelNotH, NULL);
*/
}

void TransferProc (Widget, XtPointer, Atom *, Atom *, XtPointer, unsigned long *, int);


void HandleDrop(Widget widget, XtPointer client_data,
			XtPointer call_data)
{
	Display *dpy;
	Atom FILE_NAME;
	XmDropProcCallback DropData;
	XmDropTransferEntryRec transferEntries[2];
	XmDropTransferEntry transferList;
	Arg args[10];
	int n, i;
	Widget dc;
	Cardinal numExportTargets;
	Atom *exportTargets;
	Boolean file_name = False;
	IfaceBranche * IbPtr;

#ifdef DEBUG
	printf("HandleDrop\n");
	fflush(stdout);
#endif

	XtVaGetValues(XtParent(widget), XmNuserData, &IbPtr, NULL);

/* intern the Atoms for data targets */

	dpy = XtDisplay(widget);
//FILE_CONTENTS = XInternAtom (dpy, "FILE_CONTENTS", False);
	FILE_NAME = XInternAtom (dpy, "FILE_NAME", False);
	DropData = (XmDropProcCallback) call_data;
	dc = DropData->dragContext;

/* retrieve the data targets and search for FILE_NAME */

	n = 0;
	XtSetArg (args[n], XmNexportTargets, &exportTargets); n++;
	XtSetArg (args[n], XmNnumExportTargets, &numExportTargets); n++;
	XtGetValues (dc, args, n);

#ifdef DEBUG
	printf("NumExportTargets: %d\n", numExportTargets);
	fflush(stdout);
#endif

	for (i = 0; i < numExportTargets; i++) {
		if (exportTargets[i] == FILE_NAME) {
			file_name = True;
#ifdef DEBUG
			printf("File_Name true\n");
			fflush(stdout);
#endif
			break;
		}
	}

/* make sure we have a drop that is a copy operation and one of
** the targets is FILE_NAME. if not, set the status to failure.
*/

	n = 0;

	if ((!file_name) || (DropData->dropAction != XmDROP) ||
		(DropData->operation != XmDROP_COPY)) {
		XtSetArg (args[n], XmNtransferStatus, XmTRANSFER_FAILURE); n++;
		XtSetArg (args[n], XmNnumDropTransfers, 0); n++;
	}
	else {
/* set up transfer requests for drop site */
//	transferEntries[0].target = FILE_CONTENTS;
//	transferEntries[0].client_data = (XtPointer) text_edit;
		transferEntries[0].target = FILE_NAME;
		transferEntries[0].client_data = (XtPointer) IbPtr;
		transferList = transferEntries;

#ifdef DEBUG
		printf("HandleDrop IbPtr = %p\n", IbPtr);
#endif

		XtSetArg (args[n], XmNdropTransfers, transferEntries); n++;
		XtSetArg (args[n], XmNnumDropTransfers, 1); n++;
		XtSetArg (args[n], XmNtransferProc, TransferProc); n++;
	}

#ifdef DEBUG
	printf("Next transfer start\n");
	fflush(stdout);
#endif
	XmDropTransferStart(dc, args, n);

#ifdef DEBUG
	printf("After transfer start\n");
	fflush(stdout);
#endif
}

static void TimeOutCopyMove(XtPointer data)
{
	IfaceBranche * IbPtr;
	int found = 0;
	char *label = (char *) data;
	char *dst;
	struct _FileListNode * FirstNode = NULL, * CurrentNode = NULL;

	pthread_mutex_lock(&iface_mutex);

	IbPtr = AllIfaceBranches;
	while (IbPtr)
	{
		if (pthread_equal(IbPtr->thread_id, pthread_self()))
		{
			found = 1;
			break;
		}
		else
			IbPtr = IbPtr->next_branche;
	}
	pthread_mutex_unlock(&iface_mutex);

	if (found)
	{
#ifdef DEBUG
		printf("TimeOutCopyMove activated\n");
		fflush(stdout);
#endif

		FirstNode = (struct _FileListNode *) malloc(sizeof(struct _FileListNode));
		FirstNode->ddir = (char *) calloc(strlen(IbPtr->current_wd) + 1, sizeof(char));
		FirstNode->next = NULL;
		FirstNode->command = COPY_ACTION;
		FirstNode->fname = strdup(label);
		strcpy(FirstNode->ddir, IbPtr->current_wd);

		dst = (char *) calloc(strlen(IbPtr->current_wd) + 1, sizeof(char));
		strcpy(dst, IbPtr->current_wd);

		CopyMoveAction(FirstNode, IbPtr, dst);

//	CopyMoveFile(label, 1, IbPtr);	
	}
}



void TransferProc(Widget widget, XtPointer client_data, Atom
			*seltype, Atom *type, XtPointer value, unsigned long *length, int format)
{
	Display *dpy;
	Atom FILE_NAME;
	Widget w;
	XmString string;
	char *label;
	IfaceBranche * IbPtr = NULL;
	XmDropTransferEntryRec *transferEntries;
	Arg args[10];
	int n, i;
	Cardinal numTransferEntry;

/* intern the Atoms for data targets */

#ifdef DEBUG
	printf("TransferProc started \n");
	fflush(stdout);
#endif
	dpy = XtDisplay(widget);
	FILE_NAME = XInternAtom (dpy, "FILE_NAME", False);
//	w = (Widget) client_data;
	if (*type == FILE_NAME) {
#ifdef DEBUG
		printf("OK\n");
		printf ("Filename: %s\n", (char *) value);
		fflush(stdout);
#endif

//		XtVaGetValues(widget, XmNnumDropTransfers, &numTransferEntry, XmNdropTransfers, &transferEntries, NULL);

		n = 0;
		XtSetArg (args[n], XmNnumDropTransfers, &numTransferEntry); n++;
		XtSetArg (args[n], XmNdropTransfers, &transferEntries); n++;
		XtGetValues(widget, args, n);

		if (numTransferEntry == 0)
			return;
			
#ifdef DEBUG
		printf("numTransferEntry = %d\n", numTransferEntry);
		fflush(stdout);
#endif

		while (numTransferEntry > 0)
		{
			if (transferEntries[numTransferEntry - 1].target == FILE_NAME)
			{
				IbPtr = (IfaceBranche *) transferEntries[numTransferEntry - 1].client_data;
				break;
			}
			numTransferEntry--;
		}
		
#ifdef DEBUG
		printf("TransferProc IbPtr = %p\n", IbPtr);
		fflush(stdout);
#endif
		if (!IbPtr)
			return ;
		label = strdup((char *) value);
		
#ifdef DEBUG
		printf("Copy: %s to %s\n", label, IbPtr->current_wd);
		fflush(stdout);
#endif
		XtAppAddTimeOut(IbPtr->app, 250, (XtTimerCallbackProc) TimeOutCopyMove, (XtPointer) label);

//		CopyMoveFile(label, 1, IbPtr);
#ifdef DEBUG
		printf("Copy complete\n");
		fflush(stdout);
#endif
//		free(label);
	}
}


