#include <pthread.h>
#include <semaphore.h>

#define THREAD_WAIT 1
#define PROCESS_IN_PROGRESS 2
#define FILE_OK 3
#define ALL_FILE_OK 4
#define FILE_ERROR 5

/*Copy or move ok*/
#define STATUS_OK 1
/*Write to destination file denied*/
#define STATUS_NO_WRITABLE 2
/*Read from source file denied*/
#define STATUS_NO_READABLE 3
/*Delete source file denied*/
#define STATUS_NO_MOVE 4
/*Destination file found*/
#define STATUS_FILE_FOUND 5
#define STATUS_UNKNOWN_ERROR 6
#define STATUS_SRC_IS_DIR 7


#define PROC_START 1
#define PROC_PROCESSING 2
#define PROC_OK 3
#define PROC_ERROR 4
#define PROC_CANCEL 5

/*Initial state, thread started and blcked by semaphor*/
#define CM_STATE_START 1
/*State after closed dialog*/
#define CM_STATE_RESTART 2
/*Copy or move action in thread in progress*/
#define CM_STATE_PROCESSING 3
/*Copy or move action for one file completed. Error or success*/
#define CM_STATE_PROCESSING_COMPLETE 4
/*Wait selfdestoyed of thread*/
#define CM_STATE_WAIT_FINISH_THREAD 5
/*Thread selfdestoryed. Next cleaning in workproc */
#define CM_STATE_THREAD_SELFDESTROY 6
/*Wait for user select action in dialog*/
#define CM_STATE_WAIT_USER 7
#define CM_STATE_BREAK 8


#define OPTION_NORMAL 1
#define OPTION_OVERWRITE 2
#define OPTION_NEW_NAME 3
#define OPTION_OVERWRITE_ALL 4

#define MODE_NORMAL 1
#define MODE_RENAME 2
#define MODE_OVERWRITE 3
#define MODE_OVERWRITE_ALL 4
#define MODE_CANCEL_ALL 5
#define MODE_SKIP 6
#define MODE_SKIP_ALL_DST_FILE_FOUND 7
#define MODE_SKIP_ALL_DST_DIR_FOUND 8
#define MODE_SKIP_ALL_SRC_FILE_NOTREAD 9
#define MODE_SKIP_ALL_SRC_DIR_NOTREAD 10
#define MODE_OVERWRITE_ALL_DST_FILE 11
#define MODE_OVERWRITE_ALL_DST_DIR 12

#define RADIO_ONE 0
#define RADIO_ALL 1


#define DIALOG_RET_SKIP 1
#define DIALOG_RET_SKIP_ALL 2
#define DIALOG_RET_RENAME 3
#define DIALOG_RET_OVERWRITE 4
#define DIALOG_RET_OVERWRITE_ALL 5
#define DIALOG_RET_CANCEL 6


#define COPY_ACTION 1
#define MOVE_ACTION 2

#define FOPS_IS_COPY_MOVE 1
#define FOPS_IS_DELETE 2

#define DIALOG_NO_READ_TYPE 1
#define DIALOG_NO_WRITE_TYPE 2
#define DIALOG_DESTINATION_DIR_FOUND_TYPE 3
#define DIALOG_DESTINATION_FILE_FOUND_TYPE 4
#define DIALOG_NO_REMOVE_TYPE 5
#define DIALOG_UNKNOWN_ERROR_TYPE 6
#define DIALOG_NO_CAN_DO_TYPE 7
#define DIALOG_DELETE_DIR_TYPE 8
#define DIALOG_DELETE_FILE_TYPE 9



struct _FileListNode
{
	int command;
	char * fname;
	char * ddir;
	struct _FileListNode * next;
};

struct _FilesOpsRec
{
	struct _FilesOpsRec * First;
	struct _FilesOpsRec * Next;
	int command;
	int status;
	char * src;
	char * dst;
};

struct _PreparingRec
{
	struct _FilesOpsRec * Out;
	struct _FileListNode * In;
	struct _FileListNode * OutMove;
	struct _FilesOpsRec * CurrentProc;
	IfaceBranche * IbPtr;
	Widget ProgressDialog;
	Widget ControlDialog;
	Widget radio;
	int wait_user_action;
	int fops_type;
	int dialog_type;
	int ready;
	int state; /*Current state*/ 
	int ret_code; /*Return code from thread*/
	int dialog_ret_code; /* Return code from dialog*/
	int mode;
	int radio_state;
	pthread_t task_thread_id;
	pthread_mutex_t * mutex;
	sem_t * sem;
	XtWorkProcId WorkProc;
/****************/
	Boolean OverwriteAllDstDir;
	Boolean OverwriteAllDstFile;
	Boolean SkipAllDstDir;
	Boolean SkipAllDstFile;
	Boolean SkipAllSrcDir;
	Boolean SkipAllSrcFile;
/****************/
	Boolean WorkProcFound;
	Boolean ControlDialogFound;
	Boolean ProgressDialogFound;
	Boolean UserInterrupt;
	Boolean OpsCompleted;
	int command;
	int no_read_items;
	int no_write_items;
	int dest_no_write_items;
	int dest_found;
	int dest_found_nowrite;
	int ex_dev;
	char * message;
	char * dstdir;
	char * full_source_path;
	char * full_dest_path;
	char * filename;
};




struct _CopyMoveProcNode
{
	int event_type;
	char * message;
	struct _CopyMoveProcNode * next;
};

struct _ThreadRecord
{
	struct _FileListNode * FileList;
	struct _CopyMoveProcNode * MessageList;
	pthread_mutex_t * mutex;
	sem_t * sem;
	Widget dialog;
};

void DestinationDirFoundDialog(struct _PreparingRec * rec, const char * fname);
void NoReadDialog(struct _PreparingRec * rec, const char * fname);
void NoWriteDialog(struct _PreparingRec * rec, const char * fname);
void UnknownErrorDialog(struct _PreparingRec * rec, const char * fname);
void DestinationFileFoundDialog(struct _PreparingRec * rec, char * fname);
void NoRemoveDialog(struct _PreparingRec * rec, char * fname);
void NoDeleteDialog(struct _PreparingRec * rec, const char * fname);

void NoReadMoveDialog(struct _PreparingRec * rec);
void DestinationFoundDialog(struct _PreparingRec * rec);
void CancelAllCB(Widget w, XtPointer client_data, XtPointer call_data); 
void CopyMoveProgressDialog(struct _PreparingRec * rec, char * title); 
void DestinationFoundDialog2(struct _PreparingRec * rec);

void NoCanDo(int, IfaceBranche *, XtCallbackProc callback, XtPointer client_data);
void CancelCB(Widget, XtPointer, XtPointer);
void ConfirmCloseDialog(IfaceBranche * IbPtr);
void ConfirmCloseDialog2(IfaceBranche * IbPtr);
void CloseWindowCB (Widget menu_item, XtPointer client_data, XtPointer call_data);
void NoExecActionDialog(struct _PreparingRec * rec, char * message);
void ConfirmAction(IfaceBranche * IbPtr, char * message, XtCallbackProc callback);
//void ExDialog(void);
void CleanCMData(struct _PreparingRec * rec);
void DeleteDirErrorDialog(struct _PreparingRec * rec, const char * fname);
void DeleteFileErrorDialog(struct _PreparingRec * rec, const char * fname); 
void DeleteProgressDialog(struct _PreparingRec * rec, char * title); 
void CopyMoveProgressDialogNew(struct _PreparingRec * rec, char * title); 
