#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <Xm/Xm.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/TextF.h>
#include <Xm/Text.h>
#include <Xm/ToggleBG.h>

#include "defines.h"
#include "core.h"
#include "helpsys.h"
#include "errormsg.h"

/* Our shellWidgets need a parent */
//extern Widget top_level;

/* current working directory defined elsewhere */
//extern char current_wd[120];


extern char * FilenameFromPath(char * string);
//extern XtAppContext app;

void CancelCopyCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	struct _PreparingRec * rec = (struct _PreparingRec *) client_data;
	sem_t * sem;

	sem = rec->sem;
	
//	XtAppRemoveWorkProc(prep->WorkProc);
//	prep->cancel = 1;
		
	XtDestroyWidget(XtParent(w)); 
	rec->ControlDialogFound = False;
	rec->dialog_ret_code = DIALOG_RET_CANCEL;
	sem_post(sem);
	return ;
}


void CancelAllCBNew(Widget w, XtPointer client_data, XtPointer call_data) 
{
	struct _PreparingRec * rec = (struct _PreparingRec *) client_data;
	sem_t * sem;

	sem = rec->sem;

	rec->mode = MODE_CANCEL_ALL;
	rec->state = CM_STATE_BREAK;
	rec->UserInterrupt = True;
	rec->ProgressDialogFound = False; 

//	sem_post(sem);
		
//	XtDestroyWidget(XtParent(w));
}


void CancelAllCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	struct _PreparingRec * rec = (struct _PreparingRec *) client_data;
	sem_t * sem;
//	pthread_mutex_t * mutex;
	
	sem = rec->sem;
	
	rec->mode = MODE_CANCEL_ALL;
	rec->state = CM_STATE_RESTART;
	rec->dialog_ret_code = DIALOG_RET_CANCEL;
	rec->UserInterrupt = True;
		
	XtDestroyWidget(w);
	rec->ControlDialogFound = False; 
	sem_post(sem);
}




void RenameCopyCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	struct _PreparingRec * rec = (struct _PreparingRec *) client_data;
	Widget dialog, text;
	char * dstfile;
	sem_t * sem;
//	pthread_mutex_t * mutex;
	
	sem = rec->sem;
	
	dialog = rec->ControlDialog;
	text = XtNameToWidget(dialog, "Text");

	dstfile = XmTextFieldGetString(text);
#ifdef DEBUG
	printf("Rename to %s\n\n", dstfile);
#endif
	if (rec->filename) free(rec->filename);
	rec->filename = malloc(strlen(dstfile) + 1);
	strcpy(rec->filename, dstfile);
	XtFree(dstfile);
//	XtDestroyWidget(w); 
	XtDestroyWidget(XtParent(w)); 
	rec->mode = MODE_RENAME;
	rec->state = CM_STATE_RESTART;
	rec->ControlDialogFound = False; 
	rec->dialog_ret_code = DIALOG_RET_RENAME;
	sem_post(sem);
#ifdef DEBUG
	printf("RenameCopyCB completed\n");
#endif
}

void CancelRenameSymlinkFileCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	XtDestroyWidget(XtParent(w)); 
	
#ifdef DEBUG
	printf("CancelRenameSymlinkFileCB completed\n");
#endif
	return;
}


void OkRenameFileCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	char * name = (char *) client_data;
	Widget dialog, text, ok;
	char * dstfile, *fullpath, * newpath;
	IfaceBranche * IbPtr;

	text = XtNameToWidget(w, "Text");

	dstfile = XmTextFieldGetString(text);
	
	XtVaGetValues(w, XmNuserData, &IbPtr, NULL);

	fullpath = calloc(strlen(IbPtr->current_wd) + strlen(name) + 3, sizeof(char));
	newpath = calloc(strlen(IbPtr->current_wd) + strlen(dstfile) + 3, sizeof(char));
	
	sprintf(fullpath, "%s/%s", IbPtr->current_wd, name);
	sprintf(newpath, "%s/%s", IbPtr->current_wd, dstfile);
	
	rename(fullpath, newpath);
	XtFree(dstfile);
	free(fullpath);
	free(newpath);
	XtDestroyWidget(XtParent(w)); 
#ifdef DEBUG
	printf("OkRenameFileCB completed\n");
#endif
	return;
}


void OkSymlinkFileCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	char * name = (char *) client_data;
	Widget dialog, text, ok;
	char * dstfile, *fullpath, * newpath;
	IfaceBranche * IbPtr;

	text = XtNameToWidget(w, "Text");

	dstfile = XmTextFieldGetString(text);
	
	XtVaGetValues(w, XmNuserData, &IbPtr, NULL);

	fullpath = calloc(strlen(IbPtr->current_wd) + strlen(name) + 3, sizeof(char));
	sprintf(fullpath, "%s/%s", IbPtr->current_wd, name);
	
	if (strchr(dstfile, '/'))
	{
		symlink(fullpath, dstfile);
		XtFree(dstfile);
		free(fullpath);
	}
	else
	{
		newpath = calloc(strlen(IbPtr->current_wd) + strlen(dstfile) + 3, sizeof(char));
		sprintf(newpath, "%s/%s", IbPtr->current_wd, dstfile);
		symlink(fullpath, newpath);
		XtFree(dstfile);
		free(fullpath);
		free(newpath);
	}
	
	XtDestroyWidget(XtParent(w)); 
#ifdef DEBUG
	printf("OkSymlinkFileCB completed\n");
#endif
	return;
}


void SkipCopyCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	struct _PreparingRec * rec = (struct _PreparingRec *) client_data;
	sem_t * sem;
//	pthread_mutex_t * mutex;
	

	XtDestroyWidget(XtParent(w)); 

	sem = rec->sem;
	

	rec->mode = MODE_SKIP;
	rec->state = CM_STATE_RESTART;
	rec->dialog_ret_code = DIALOG_RET_SKIP;
	rec->ControlDialogFound = False; 
	

	sem_post(sem);
	

}


void SkipCopyCB2(Widget w, XtPointer client_data, XtPointer call_data) 
{
	struct _PreparingRec * rec = (struct _PreparingRec *) client_data;
//	struct _FileListNode * list, * ptr;
//	XmString info;
	char * string;
//	Arg args[10];
//	int n;
//	Widget dialog = rec->ControlDialog;
	Widget tg = rec->radio;
	sem_t * sem;
//	pthread_mutex_t * mutex;
	


	sem = rec->sem;

	string = alloca(strlen("button_1")+2);
	strcpy(string, "button_0");
	tg = XtNameToWidget(rec->radio, string);
	
	if (tg == NULL)
	{
#ifdef DEBUG
		printf("ToggleButton gadget not found, apply default skip mode\n");
#endif
		rec->mode = MODE_SKIP;
		XtDestroyWidget(XtParent(w)); 
		rec->state = CM_STATE_RESTART;
		rec->dialog_ret_code = DIALOG_RET_SKIP;
		rec->ControlDialogFound = False; 
		
		sem_post(sem);
		return ;
	}
	if (XmToggleButtonGadgetGetState(tg))
	{
#ifdef DEBUG
		printf("RaioBox in state 0\n");
#endif
		rec->mode = MODE_SKIP;
		rec->dialog_ret_code = DIALOG_RET_SKIP;
	}
	else
	{
#ifdef DEBUG
		printf("RaioBox in state 1\n");
#endif
		rec->mode = MODE_SKIP_ALL_DST_FILE_FOUND;
		rec->dialog_ret_code = DIALOG_RET_SKIP_ALL;
	}
	

/*	if (rec->radio_state == RADIO_ONE) rec->mode = MODE_SKIP;
	if (rec->radio_state == RADIO_ALL) rec->mode = MODE_SKIP_ALL;*/
	XtDestroyWidget(XtParent(w)); 
	rec->state = CM_STATE_RESTART;
	rec->ControlDialogFound = False; 
	

	sem_post(sem);
	

}



void OverCopyCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	struct _PreparingRec * rec = (struct _PreparingRec *) client_data;
//	struct _FileListNode * list, * ptr;
//	XmString info;
//	char * string;
//	Arg args[10];
//	int n;
//	Widget dialog;
	sem_t * sem;
//	pthread_mutex_t * mutex;
	sem = rec->sem;
	
	XtDestroyWidget(w); 

	rec->mode = MODE_OVERWRITE;
	rec->state = CM_STATE_RESTART;
	rec->dialog_ret_code = DIALOG_RET_OVERWRITE;
	rec->ControlDialogFound = False; 
	sem_post(sem);

}


void OverCopyAltCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	struct _PreparingRec * rec = (struct _PreparingRec *) client_data;
//	struct _FileListNode * list, * ptr;
//	XmString info;
	char * string;
//	Arg args[10];
//	int n;
//	Widget dialog = rec->ControlDialog;
	Widget tg;
	sem_t * sem;
//	pthread_mutex_t * mutex;
	sem = rec->sem;
	
	string = alloca(strlen("button_1")+2);
	strcpy(string, "button_0");
	tg = XtNameToWidget(rec->radio, string);
	
	if (tg == NULL)
	{
#ifdef DEBUG
		printf("ToggleButton gadget not found, apply default overwrite mode\n");
#endif
		rec->mode = MODE_OVERWRITE;
		XtDestroyWidget(XtParent(w)); 
		rec->state = CM_STATE_RESTART;
		rec->dialog_ret_code = DIALOG_RET_OVERWRITE;
		rec->ControlDialogFound = False; 
		
		sem_post(sem);
		return ;
	}
	if (XmToggleButtonGadgetGetState(tg))
	{
#ifdef DEBUG
		printf("RaioBox in state 0\n");
#endif
		rec->mode = MODE_OVERWRITE;
		rec->dialog_ret_code = DIALOG_RET_OVERWRITE;
	}
	else
	{
#ifdef DEBUG
		printf("RaioBox in state 1\n");
#endif
		rec->mode = MODE_OVERWRITE_ALL;
		rec->dialog_ret_code = DIALOG_RET_OVERWRITE_ALL;
	}
	XtDestroyWidget(XtParent(w)); 
	rec->state = CM_STATE_RESTART;
	rec->ControlDialogFound = False; 
	
	sem_post(sem);
#ifdef DEBUG
	printf("OverCopyAltCB completed\n");
#endif

}


void OverAllCopyCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	struct _PreparingRec * rec = (struct _PreparingRec *) client_data;
//	struct _FileListNode * list, * ptr;
//	XmString info;
//	char * string;
//	Arg args[10];
//	int n;
//	Widget dialog;
	sem_t * sem;
//	pthread_mutex_t * mutex;
	
	sem = rec->sem;
	
	XtDestroyWidget(w); 

	rec->mode = MODE_OVERWRITE_ALL;
	rec->state = CM_STATE_RESTART;
	rec->dialog_ret_code = DIALOG_RET_OVERWRITE_ALL;
	rec->ControlDialogFound = False; 
	sem_post(sem);

}




void NoReadDialog(struct _PreparingRec * rec, const char * fname)
{
//	struct _FileListNode * list, * ptr;
//	struct _FilesOpsRec * ops;
	XmString info, ok;
	char * string;
	Arg args[10];
	int n;
	Widget dialog;
	IfaceBranche * IbPtr = rec->IbPtr;
	
//	ops = rec->Out;

//	string = malloc(strlen(rec->filename) + 200);
	string = malloc(strlen(fname) + 200);
	if (rec->command == 1)
	{
		sprintf(string, "Reading of file or directory %s not permitted", fname);
	}
	else
	{
		sprintf(string, "Moving of file or directory %s not permitted", fname);
	}

	info = XmStringCreateLocalized(string);
	free(string);

	ok = XmStringCreateLocalized("Skip");
	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: copy/move");
	n++;
	XtSetArg(args[n], XmNokLabelString, ok);
	n++;
	XtSetArg (args[n], XmNautoUnmanage, False); 
	n++;

	dialog = XmCreateWarningDialog(IbPtr->top_level, "CopyMove", args, n);
	rec->ControlDialogFound = True; 

  
/*	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_OK_BUTTON));*/
	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_HELP_BUTTON));
  /* Press the ok button when finished reading. */
//	XtAddCallback(dialog, XmNokCallback, CancelCopyCB, (XtPointer) ToThread);
	XtAddCallback(dialog, XmNcancelCallback, CancelAllCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNokCallback, SkipCopyCB, (XtPointer) rec);


	XtManageChild(dialog);
	XmStringFree(info);
	XmStringFree(ok);

	return ;
	
}



void DestinationDirFoundDialog(struct _PreparingRec * rec, const char * fname) 
{
//	struct _FileListNode * list, * ptr;
//	struct _FilesOpsRec * ops;
	XmString info, over, one, all, skip;
	char * string;
	Arg args[10];
	int n;
	Widget dialog, radiobox, form, skip_button;
	IfaceBranche * IbPtr = rec->IbPtr;
	
//	ops = rec->Out;
#ifdef DEBUG
	printf("DestinationDirFoundDialog started\n");
#endif

	string = malloc(strlen(fname) + 200);
	sprintf(string, "Dir %s found in destination directory, select action", fname);


	info = XmStringCreateLocalized(string);
	free(string);

	over = XmStringCreateLocalized("Overwrite");
	one = XmStringCreateLocalized("Apply only for this item");
	all = XmStringCreateLocalized("Apply for all items");
	skip = XmStringCreateLocalized("Skip");
//	name = XmStringCreateLocalized("Enter new name");
	
	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: copy/move");
	n++;
	XtSetArg(args[n], XmNokLabelString, over);
	n++;
/*	XtSetArg(args[n], XmNhelpLabelString, skip);
	n++;*/
	XtSetArg (args[n], XmNautoUnmanage, False); 
	n++;


	dialog = XmCreateWarningDialog(IbPtr->top_level, "CopyMove", args, n);


//	XmStringFree(name);
	
	rec->ControlDialog = dialog;
	rec->ControlDialogFound = True; 
	rec->radio_state = RADIO_ONE;


/*** Creating form with message label and radiobox ***/

	form=XmCreateForm(dialog, "form", NULL, 0);


	n=0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM);
	n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM);
	n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM);
	n++;

	radiobox = XmVaCreateSimpleRadioBox (form,
				"radio_box", 0, NULL,
				XmVaRADIOBUTTON, one, 0, NULL, NULL,
				XmVaRADIOBUTTON, all, 0, NULL, NULL,
				XmNleftAttachment, XmATTACH_FORM,
				XmNrightAttachment, XmATTACH_FORM,
//				XmNbottomAttachment, XmATTACH_FORM,
				XmNtopAttachment, XmATTACH_FORM,
				XmNuserData, (XtPointer) rec,
				NULL);


	rec->radio = radiobox;




	XmStringFree(one);
	XmStringFree(all);

/*	n=0;
	XtSetArg (args[n], XmNlabelType, XmSTRING); n++;
	XtSetArg (args[n], XmNlabelString, info); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNbottomWidget, radiobox); n++;

	message = XmCreateLabel(form, "file", args, n);*/


	XmStringFree(info);


/*	text = XtNameToWidget(dialog, "Text");



	XmTextSetString(text, FilenameFromPath(fname));*/

	XtAddCallback(dialog, XmNcancelCallback, CancelAllCB, (XtPointer) rec);
//	XtAddCallback(dialog, XmNokCallback, RenameCopyCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNokCallback, OverCopyAltCB, (XtPointer) rec);
//	XtAddCallback(dialog, XmNhelpCallback, SkipCopyCB2, (XtPointer) rec);

	XtSetArg(args[0], XmNlabelString, skip);
	skip_button = XmCreatePushButton (dialog, "skip", args, 1);

	XtAddCallback(skip_button, XmNactivateCallback, SkipCopyCB2, (XtPointer) rec);


//	XtManageChild(XmMessageBoxGetChild(dialog, XmDIALOG_APPLY_BUTTON));
	XtManageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
//	XtManageChild (message);
	XtManageChild (skip_button);
	XtManageChild (radiobox);
	XtManageChild (form);
	XtManageChild(dialog);

	XmStringFree(over);
	XmStringFree(skip);



	return ;
	
}



void DestinationFileFoundDialog(struct _PreparingRec * rec, char * fname) 
{
//	struct _FileListNode * list, * ptr;
//	struct _FilesOpsRec * ops;
	XmString info, over, one, all, skip, name;
	char * string, * c;
	int i;
	Arg args[10];
	Cardinal n;
	Widget dialog, text, radiobox, form, message;
	IfaceBranche * IbPtr = rec->IbPtr;
	
//	ops = rec->Out;

	string = calloc(strlen(fname) + 200, sizeof(char));
	
	
	
	i = 0; 
	while (fname[i] != '\0')
	{
		if (fname[i] == '\n')
			break; 
		i++;
	}
	
	if (fname[i] == '\n')
	{
		strcpy(string, "File ");
		strncat(string, fname, i);
		strcat(string, " found in destination directory, enter new name or select other alternatives");
		strcat(string, fname + i);
		c = calloc(strlen(fname) + 1, sizeof(char));
		strncpy(c, fname, i);
	}
	else
	{
		sprintf(string, "File %s found in destination directory, enter new name or select other alternatives", fname);
		c = calloc(strlen(fname) + 1, sizeof(char));
		strcpy(c, fname);
	}


	info = XmStringCreateLocalized(string);
	free(string);

	over = XmStringCreateLocalized("Overwrite");
	one = XmStringCreateLocalized("Only for this item");
	all = XmStringCreateLocalized("For all items");
	skip = XmStringCreateLocalized("Skip");
	name = XmStringCreateLocalized("Enter new name");
	
	n = 0;
	XtSetArg(args[n], XmNselectionLabelString, name);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: copy/move");
	n++;
	XtSetArg(args[n], XmNapplyLabelString, over);
	n++;
	XtSetArg(args[n], XmNhelpLabelString, skip);
	n++;
	XtSetArg (args[n], XmNautoUnmanage, False); 
	n++;


	dialog = XmCreatePromptDialog(IbPtr->top_level, "CopyMove", args, n);


	XmStringFree(over);
	XmStringFree(skip);
	XmStringFree(name);
	
	rec->ControlDialog = dialog;
	rec->ControlDialogFound = True; 
	rec->radio_state = RADIO_ONE;


/*** Creating form with message label and radiobox ***/

	form = XmCreateForm(dialog, "form", NULL, 0);


	n=0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM);
	n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM);
	n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM);
	n++;

	radiobox = XmVaCreateSimpleRadioBox (form,
				"radio_box", 0, NULL,
				XmVaRADIOBUTTON, one, 0, NULL, NULL,
				XmVaRADIOBUTTON, all, 0, NULL, NULL,
				XmNleftAttachment, XmATTACH_FORM,
				XmNrightAttachment, XmATTACH_FORM,
				XmNbottomAttachment, XmATTACH_FORM,
				XmNuserData, (XtPointer) rec,
				NULL);


	rec->radio = radiobox;




	XmStringFree(one);
	XmStringFree(all);

	n=0;
	XtSetArg (args[n], XmNlabelType, XmSTRING); n++;
	XtSetArg (args[n], XmNlabelString, info); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNbottomWidget, radiobox); n++;

	message = XmCreateLabel(form, "file", args, n);


	XmStringFree(info);


	text = XtNameToWidget(dialog, "Text");



	XmTextSetString(text, FilenameFromPath(c));
	
	if (c)
		free(c);

	XtAddCallback(dialog, XmNcancelCallback, CancelAllCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNokCallback, RenameCopyCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNapplyCallback, OverCopyAltCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNhelpCallback, SkipCopyCB2, (XtPointer) rec);


	XtManageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_APPLY_BUTTON));
	XtManageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
	XtManageChild (message);
	XtManageChild (radiobox);
	XtManageChild (form);
	XtManageChild(dialog);



	return ;
	
}



void DestinationFoundDialog(struct _PreparingRec * rec) 
{
//	struct _FileListNode * list, * ptr;
//	struct _FilesOpsRec * ops;
	XmString info, over, over2, skip, cancel;
	char * string, * dstfile;
	Arg args[10];
	int n;
	Widget dialog, skip_button, text;
	IfaceBranche * IbPtr = rec->IbPtr;
	
//	ops = rec->Out;

	dstfile = rec->filename;

	string = malloc(strlen(rec->filename) + 200);
	sprintf(string, "File %s found in destination directory, enter new name or select other alternatives", rec->filename);

	info = XmStringCreateLocalized(string);
	free(string);

	over = XmStringCreateLocalized("Overwrite");
	over2 = XmStringCreateLocalized("Overwrite all");
	skip = XmStringCreateLocalized("Skip");
	cancel = XmStringCreateLocalized("Cancel");
	
	n = 0;
	XtSetArg(args[n], XmNselectionLabelString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: copy/move");
	n++;
	XtSetArg(args[n], XmNapplyLabelString, over);
	n++;
	XtSetArg(args[n], XmNhelpLabelString, over2);
	n++;
/*	XtSetArg(args[n], XmNapplyLabelString, over);
	n++;*/
	dialog = XmCreatePromptDialog(IbPtr->top_level, "CopyMove", args, n);
	
	rec->ControlDialog = dialog;
	rec->ControlDialogFound = True; 

	XtSetArg(args[0], XmNlabelString, skip);
	skip_button = XmCreatePushButton (dialog, "skip", args, 1);

	text = XtNameToWidget(dialog, "Text");

	XmTextSetString(text, dstfile);
/*	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_OK_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_HELP_BUTTON));*/
	
  /* Press the ok button when finished reading. */
//	XtAddCallback(dialog, XmNokCallback, CancelCopyCB, (XtPointer) ToThread);
	XtAddCallback(dialog, XmNcancelCallback, CancelAllCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNokCallback, RenameCopyCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNapplyCallback, OverCopyCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNhelpCallback, OverAllCopyCB, (XtPointer) rec);
	XtAddCallback(skip_button, XmNactivateCallback, SkipCopyCB, (XtPointer) rec);


	XtManageChild(dialog);
	XtManageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_APPLY_BUTTON));
	XtManageChild(skip_button);
	XmStringFree(info);
	XmStringFree(over);
	XmStringFree(over2);
	XmStringFree(skip);

	return ;
	
}


/*
void DestinationFoundDialog2(struct _PreparingRec * rec) 
{
	struct _FileListNode * list, * ptr;
	struct _FilesOpsRec * ops;
	XmString info, over, over2, skip, cancel;
	char * string, * dstfile;
	Arg args[10];
	int n;
	Widget dialog, skip_button, text;
	
	ops = rec->Out;

	dstfile = rec->filename;

	string = malloc(strlen(rec->filename) + 200);
	sprintf(string, "File %s found in destination directory, enter new name or select other alternatives", rec->filename);

	info = XmStringCreateLocalized(string);
	free(string);

	over = XmStringCreateLocalized("Overwrite");
	over2 = XmStringCreateLocalized("Overwrite all");
	skip = XmStringCreateLocalized("Skip");
	cancel = XmStringCreateLocalized("Cancel");
	
	n = 0;
	XtSetArg(args[n], XmNselectionLabelString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: copy/move");
	n++;
	XtSetArg(args[n], XmNapplyLabelString, over);
	n++;
	XtSetArg(args[n], XmNhelpLabelString, over2);
	n++;
	dialog = XmCreatePromptDialog(top_level, "CopyMove", args, n);
	
	rec->ControlDialog = dialog;
	rec->ControlDialogFound = True; 

	XtSetArg(args[0], XmNlabelString, skip);
	skip_button = XmCreatePushButton (dialog, "skip", args, 1);

	text = XtNameToWidget(dialog, "Text");

	XmTextSetString(text, dstfile);
	XtAddCallback(dialog, XmNcancelCallback, CancelAllCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNokCallback, RenameCopyCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNapplyCallback, OverCopyCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNhelpCallback, OverAllCopyCB, (XtPointer) rec);
	XtAddCallback(skip_button, XmNactivateCallback, SkipCopyCB, (XtPointer) rec);


	XtManageChild(dialog);
	XtManageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_APPLY_BUTTON));
	XtManageChild(skip_button);
	XmStringFree(info);
	XmStringFree(over);
	XmStringFree(over2);
	XmStringFree(skip);

	return ;
	
}

*/


void NoExecActionDialog(struct _PreparingRec * rec, char * message) 
{
//	struct _FileListNode * list, * ptr;
//	struct _FilesOpsRec * ops;
	XmString info, ok;
	Arg args[10];
	int n;
	Widget dialog;
	IfaceBranche * IbPtr = rec->IbPtr;
	
//	ops = rec->Out;

	info = XmStringCreateLocalized(message);

	ok = XmStringCreateLocalized("Skip");
	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: copy/move");
	n++;
	XtSetArg(args[n], XmNokLabelString, ok);
	n++;
	dialog = XmCreateWarningDialog(IbPtr->top_level, "CopyMove", args, n);
	rec->ControlDialogFound = True; 

  
/*	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_OK_BUTTON));*/
	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_HELP_BUTTON));
  /* Press the ok button when finished reading. */
//	XtAddCallback(dialog, XmNokCallback, CancelCopyCB, (XtPointer) ToThread);
	XtAddCallback(dialog, XmNcancelCallback, CancelAllCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNokCallback, SkipCopyCB, (XtPointer) rec);


	XtManageChild(dialog);
	XmStringFree(info);
	XmStringFree(ok);

	return ;
}




void NoReadMoveDialog(struct _PreparingRec * rec) 
{
//	struct _FileListNode * list, * ptr;
//	struct _FilesOpsRec * ops;
	XmString info, ok;
	char * string;
	Arg args[10];
	int n;
	Widget dialog;
	IfaceBranche * IbPtr = rec->IbPtr;
	
//	ops = rec->Out;

	string = malloc(strlen(rec->filename) + 200);
	if (rec->command == 1)
	{
		sprintf(string, "Reading of file %s not permitted", rec->filename);
	}
	else
	{
		sprintf(string, "Moving of file %s not permitted", rec->filename);
	}

	info = XmStringCreateLocalized(string);
	free(string);

	ok = XmStringCreateLocalized("Skip");
	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: copy/move");
	n++;
	XtSetArg(args[n], XmNokLabelString, ok);
	n++;
	dialog = XmCreateWarningDialog(IbPtr->top_level, "CopyMove", args, n);
	rec->ControlDialogFound = True; 

  
/*	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_OK_BUTTON));*/
	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_HELP_BUTTON));
  /* Press the ok button when finished reading. */
//	XtAddCallback(dialog, XmNokCallback, CancelCopyCB, (XtPointer) ToThread);
	XtAddCallback(dialog, XmNcancelCallback, CancelAllCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNokCallback, SkipCopyCB, (XtPointer) rec);


	XtManageChild(dialog);
	XmStringFree(info);
	XmStringFree(ok);

	return ;
	
}


void UnknownErrorDialog(struct _PreparingRec * rec, const char * fname) 
{
//	struct _FileListNode * list, * ptr;
	XmString info;
	Arg args[10];
	int n;
	Widget dialog;
	IfaceBranche * IbPtr = rec->IbPtr;
	
	sem_t * sem;
	sem = rec->sem;
//	list = rec->In;
#ifdef DEBUG
	printf("NoWriteDialog: start\n");
#endif
/*	while (list)
	{
		free(list->fname);
		ptr = list->next;
		free(list);
		list = ptr;
	}
#ifdef DEBUG
	printf("NoWriteDialog: cleaning ok\n");
#endif
	
	rec->In = NULL;
	
	free(rec->dstdir);
	rec->cancel = 1;
	
	sem_post(sem);
#ifdef DEBUG
	printf("NoWriteDialog: sem posting\n");
#endif
*/
	info = XmStringCreateLocalized("Writing of file(s) not permitted");
	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: copy/move");
	n++;
	dialog = XmCreateWarningDialog(IbPtr->top_level, "CopyMove", args, n);
	rec->ControlDialogFound = True; 

  
	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_OK_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_HELP_BUTTON));
	XtAddCallback(dialog, XmNcancelCallback, CancelCopyCB, (XtPointer) rec);


	XtManageChild(dialog);
	XmStringFree(info);

	return ;
	
}

/*void ExDialog(void) 
{
	XmString info;
	Arg args[10];
	int n;
	Widget dialog;
	
#ifdef DEBUG
	printf("NoWriteDialog: start\n");
#endif

	info = XmStringCreateLocalized("Example dialog");
	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: copy/move");
	n++;
	dialog = XmCreateWarningDialog(IbPtr->top_level, "CopyMove", args, n);


	XtManageChild(dialog);
	XmStringFree(info);

  while (XtIsManaged(dialog)) {
    XEvent event;

    XtAppNextEvent(app, &event);
    XtDispatchEvent(&event);
  }
  

	return ;
	
}

*/

void NoRemoveDialog(struct _PreparingRec * rec, char * fname) 
{
//	struct _FileListNode * list, * ptr;
	XmString info;
	Arg args[10];
	int n;
	Widget dialog;
	IfaceBranche * IbPtr = rec->IbPtr;
	
	sem_t * sem;
	sem = rec->sem;
//	list = rec->In;
#ifdef DEBUG
	printf("NoWriteDialog: start\n");
#endif
/*	while (list)
	{
		free(list->fname);
		ptr = list->next;
		free(list);
		list = ptr;
	}
#ifdef DEBUG
	printf("NoWriteDialog: cleaning ok\n");
#endif
	
	rec->In = NULL;
	
	free(rec->dstdir);
	rec->cancel = 1;
	
	sem_post(sem);
#ifdef DEBUG
	printf("NoWriteDialog: sem posting\n");
#endif
*/
	info = XmStringCreateLocalized("Writing of file(s) not permitted");
	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: copy/move");
	n++;
	dialog = XmCreateWarningDialog(IbPtr->top_level, "CopyMove", args, n);
	rec->ControlDialogFound = True; 

  
	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_OK_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_HELP_BUTTON));
	XtAddCallback(dialog, XmNcancelCallback, CancelCopyCB, (XtPointer) rec);


	XtManageChild(dialog);
	XmStringFree(info);

	return ;
	
}

void NoDeleteDialog(struct _PreparingRec * rec, const char * fname) 
{
//	struct _FileListNode * list, * ptr;
	XmString info, ok;
	Arg args[10];
	int n;
	Widget dialog;
	IfaceBranche * IbPtr = rec->IbPtr;
	
	sem_t * sem;
	sem = rec->sem;
//	list = rec->In;
#ifdef DEBUG
	printf("NoDeleteDialog: start\n");
#endif
	info = XmStringCreateLocalized("Deleting of file(s) not permitted");
	ok = XmStringCreateLocalized("Skip");

	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: copy/move");
	n++;
	XtSetArg(args[n], XmNokLabelString, ok);
	n++;
	XtSetArg (args[n], XmNautoUnmanage, False); 
	n++;

	dialog = XmCreateWarningDialog(IbPtr->top_level, "CopyMove", args, n);
	rec->ControlDialogFound = True; 

  
/*	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_OK_BUTTON));*/
	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_HELP_BUTTON));
	XtAddCallback(dialog, XmNokCallback, SkipCopyCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNcancelCallback, CancelCopyCB, (XtPointer) rec);


	XtManageChild(dialog);
	XmStringFree(info);
	XmStringFree(ok);

	return ;
	
}

void DeleteDirErrorDialog(struct _PreparingRec * rec, const char * fname) 
{
//	struct _FileListNode * list, * ptr;
	XmString info, ok;
	Arg args[10];
	int n;
	Widget dialog;
	IfaceBranche * IbPtr = rec->IbPtr;
	
	sem_t * sem;
	sem = rec->sem;
//	list = rec->In;
#ifdef DEBUG
	printf("NoDeleteDialog: start\n");
#endif
	info = XmStringCreateLocalized("Deleting of file(s) not permitted");
	ok = XmStringCreateLocalized("Skip");

	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: deleting");
	n++;
	XtSetArg(args[n], XmNokLabelString, ok);
	n++;
	XtSetArg (args[n], XmNautoUnmanage, False); 
	n++;

	dialog = XmCreateWarningDialog(IbPtr->top_level, "Delete", args, n);
	rec->ControlDialogFound = True; 

  
/*	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_OK_BUTTON));*/
	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_HELP_BUTTON));
	XtAddCallback(dialog, XmNokCallback, SkipCopyCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNcancelCallback, CancelCopyCB, (XtPointer) rec);


	XtManageChild(dialog);
	XmStringFree(info);
	XmStringFree(ok);

	return ;
	
}

void DeleteFileErrorDialog(struct _PreparingRec * rec, const char * fname) 
{
//	struct _FileListNode * list, * ptr;
	XmString info, ok;
	Arg args[10];
	int n;
	Widget dialog;
	IfaceBranche * IbPtr = rec->IbPtr;
	
	sem_t * sem;
	sem = rec->sem;
//	list = rec->In;
#ifdef DEBUG
	printf("NoDeleteDialog: start\n");
#endif
	info = XmStringCreateLocalized("Deleting of file(s) not permitted");
	ok = XmStringCreateLocalized("Skip");

	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: deleting");
	n++;
	XtSetArg(args[n], XmNokLabelString, ok);
	n++;
	XtSetArg (args[n], XmNautoUnmanage, False); 
	n++;

	dialog = XmCreateWarningDialog(IbPtr->top_level, "Delete", args, n);
	rec->ControlDialogFound = True; 

  
/*	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_OK_BUTTON));*/
	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_HELP_BUTTON));
	XtAddCallback(dialog, XmNokCallback, SkipCopyCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNcancelCallback, CancelCopyCB, (XtPointer) rec);


	XtManageChild(dialog);
	XmStringFree(info);
	XmStringFree(ok);

	return ;
	
}



void NoWriteDialog(struct _PreparingRec * rec, const char * fname) 
{
	XmString info, ok;
	char * string;
	Arg args[10];
	int n;
	Widget dialog;
	IfaceBranche * IbPtr = rec->IbPtr;
	
	string = calloc(strlen(fname) + 200, sizeof(char));

	sprintf(string, "Writing of file or directory %s is not permitted", fname);

	info = XmStringCreateLocalized(string);
	free(string);

	ok = XmStringCreateLocalized("Skip");
	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: copy/move");
	n++;
	XtSetArg(args[n], XmNokLabelString, ok);
	n++;
	XtSetArg (args[n], XmNautoUnmanage, False); 
	n++;

	dialog = XmCreateWarningDialog(IbPtr->top_level, "CopyMove", args, n);
	rec->ControlDialogFound = True; 

  
/*	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_OK_BUTTON));*/
	XtUnmanageChild(XmMessageBoxGetChild(dialog, 
                                       XmDIALOG_HELP_BUTTON));
  /* Press the ok button when finished reading. */
//	XtAddCallback(dialog, XmNokCallback, CancelCopyCB, (XtPointer) ToThread);
	XtAddCallback(dialog, XmNcancelCallback, CancelAllCB, (XtPointer) rec);
	XtAddCallback(dialog, XmNokCallback, SkipCopyCB, (XtPointer) rec);


	XtManageChild(dialog);
	XmStringFree(info);
	XmStringFree(ok);

	return ;
	
}

void CopyMoveProgressDialogNew(struct _PreparingRec * rec, char * title) 
{
	XmString info;
	Arg args[10];
	int n;
	Widget dialog;
	IfaceBranche * IbPtr = rec->IbPtr;

	info = XmStringCreateLocalized(title);

	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, title);
	n++;
	
	dialog = XmCreateWorkingDialog(IbPtr->top_level, "CopyMove", args, n);

	rec->ProgressDialog = dialog;
	rec->ProgressDialogFound = True; 
  
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_OK_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
	XtAddCallback(dialog, XmNcancelCallback, CancelAllCBNew, (XtPointer) rec);

	XtManageChild(dialog);
	XmStringFree(info);

	return ;
}

void DeleteProgressDialog(struct _PreparingRec * rec, char * title) 
{
	XmString info;
	Arg args[10];
	int n;
	Widget dialog;
	IfaceBranche * IbPtr = rec->IbPtr;

	info = XmStringCreateLocalized(title);

	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, title);
	n++;
	
	dialog = XmCreateWorkingDialog(IbPtr->top_level, "Delete", args, n);

	rec->ProgressDialog = dialog;
	rec->ProgressDialogFound = True; 
  
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_OK_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
	XtAddCallback(dialog, XmNcancelCallback, CancelAllCBNew, (XtPointer) rec);

	XtManageChild(dialog);
	XmStringFree(info);

	return ;
}


void CopyMoveProgressDialog(struct _PreparingRec * rec, char * title) 
{
	XmString info;
	Arg args[10];
	int n;
	Widget dialog;
	IfaceBranche * IbPtr = rec->IbPtr;

	info = XmStringCreateLocalized("Preparing to processing ...");

	n = 0;
	XtSetArg(args[n], XmNmessageString, info);
	n++;
	XtSetArg(args[n], XmNtitle, title);
	n++;
	
	dialog = XmCreateWorkingDialog(IbPtr->top_level, "CopyMove", args, n);

	rec->ControlDialog = dialog;
	rec->ControlDialogFound = True; 
  
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_OK_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
	XtAddCallback(dialog, XmNcancelCallback, CancelAllCB, (XtPointer) rec);

	XtManageChild(dialog);
	XmStringFree(info);

	return ;
}


void ConfirmCloseDialog(IfaceBranche * IbPtr);


void OkCloseWindowCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	IfaceBranche * IbPtr = (IfaceBranche * ) client_data;
		
	XtDestroyWidget(XtParent(w)); 
	if (IbPtr->copy_move_thread_count)
	{
#ifdef DEBUG
		printf("OkCloseWindowCB: Cancel all copy/move ops\n");
#endif
		ConfirmCloseDialog(IbPtr);
		return ;
	}
	
#ifdef DEBUG
	printf("OkCloseWindowCB: all copy/move ops prior terminated\n");
#endif

	if (IbPtr->DialPixLarge > XmUNSPECIFIED_PIXMAP)
	{
		XFreePixmap(XtDisplay(IbPtr->top_level), IbPtr->DialPixLarge);
		IbPtr->DialPixLarge = XmUNSPECIFIED_PIXMAP;
	}
		
	if (IbPtr->DialPixSmall > XmUNSPECIFIED_PIXMAP)
	{
		XFreePixmap(XtDisplay(IbPtr->top_level), IbPtr->DialPixSmall);
		IbPtr->DialPixSmall = XmUNSPECIFIED_PIXMAP;
	}

#ifdef USE_INOTIFY
	PutWatchCommand(IbPtr, COMMAND_DETACH_IFACE);
#endif
	XtAppSetExitFlag(IbPtr->app);
	return ;
}


/* Close one of the popup dialogs described herein (see below) */
void CancelCB(Widget w, XtPointer client_data, XtPointer call_data) 
{
	XtDestroyWidget(w);
}


void ConfirmCloseDialog(IfaceBranche * IbPtr)
{
	Widget topmsgbox;
	XmString s1;
	char * s2;
	Arg args[10];

#ifdef DEBUG
	printf("--------Start ConfirmCloseDialogg \n"); 
#endif
	s1 = XmStringCreateLocalized("Copy or move operation in progress. \n Cancel it, then repeat close");
	
	s2 = calloc(strlen(IbPtr->current_wd) + strlen("Closing window: ") + 3, sizeof(char));

	sprintf(s2, "Closing window: %s", IbPtr->current_wd);

	XtSetArg(args[0], XmNmessageString, s1);
	XtSetArg(args[1], XmNtitle, s2);
	XtSetArg(args[2], XmNuserData, IbPtr);
	topmsgbox = XmCreateWarningDialog(IbPtr->top_level, "colse_warning", args, 3);
	XmStringFree(s1);
	free(s2);
  
	XtUnmanageChild(XmMessageBoxGetChild(topmsgbox, XmDIALOG_CANCEL_BUTTON));
	XtAddCallback(topmsgbox, XmNokCallback, CancelCB, IbPtr);
/*	XtAddCallback(topmsgbox, XmNcancelCallback, CancelCB, NULL);*/
	XtManageChild(topmsgbox);
}


void ConfirmCloseDialog2(IfaceBranche * IbPtr)
{
	Widget topmsgbox;
	XmString s1;
	char * s2;
	Arg args[10];

#ifdef DEBUG
	printf("--------Start ConfirmCloseDialog2 \n"); 
#endif
	s1 = XmStringCreateLocalized("Closing of this window will entail completion of program.\n To close it?");
	
	s2 = calloc(strlen(IbPtr->current_wd) + strlen("Closing window: ") + 3, sizeof(char));

	sprintf(s2, "Closing window: %s", IbPtr->current_wd);

	XtSetArg(args[0], XmNmessageString, s1);
	XtSetArg(args[1], XmNtitle, s2);
	XtSetArg(args[2], XmNuserData, IbPtr);
	topmsgbox = XmCreateQuestionDialog(IbPtr->top_level, "colse_question", args, 3);
	XmStringFree(s1);
	free(s2);
  
	XtAddCallback(topmsgbox, XmNokCallback, OkCloseWindowCB, IbPtr);
	XtAddCallback(topmsgbox, XmNcancelCallback, CancelCB, NULL);
	XtManageChild(topmsgbox);
}


/* For any of these functions:  Display this popup when you can't do that */
void NoCanDo(int x, IfaceBranche * IbPtr, XtCallbackProc callback, XtPointer client_data) {
  Widget topmsgbox;
  XmString nowayjose;
  Arg args[10];

  if (x == OPERATION_FAILED)
    nowayjose=XmStringCreate("Operation failed!", XmSTRING_DEFAULT_CHARSET);
  if (x == CANT_EXECUTE)
    nowayjose=XmStringCreate("You don't have permission to run that program.",
			       XmSTRING_DEFAULT_CHARSET);
  if (x == NOT_A_DIRECTORY)
    nowayjose=XmStringCreate("That's not a directory.",
			       XmSTRING_DEFAULT_CHARSET);
  if (x == DIR_NOT_EXIST)
    nowayjose=XmStringCreate("That file or directory doesn't exist.",
			       XmSTRING_DEFAULT_CHARSET);
  if (x == IT_ALREADY_EXISTS)
    nowayjose=XmStringCreate("A file or directory with that name already exists.",
			       XmSTRING_DEFAULT_CHARSET);
  if (x == NOT_EXECUTABLE)
    nowayjose=XmStringCreate("That is not an executable file.",
			       XmSTRING_DEFAULT_CHARSET);
  if (x == CANT_FIND)
    nowayjose=XmStringCreate("Can't find one of the specified files.",
			       XmSTRING_DEFAULT_CHARSET);
  if (x == CANT_READ)
    nowayjose=XmStringCreate("You don't have permission to read that.",
			       XmSTRING_DEFAULT_CHARSET);
  if (x == CANT_DELETE)
    nowayjose=XmStringCreate("You don't have permission to delete that.",
			     XmSTRING_DEFAULT_CHARSET);
  if (x == CANT_READ_DIR)
    nowayjose=XmStringCreate("You don't have permission to enter that directory.", XmSTRING_DEFAULT_CHARSET);
  if (x == CANT_WRITE_DIR)
    nowayjose=XmStringCreate("You don't have permission to write in this directory.", XmSTRING_DEFAULT_CHARSET);
  if (x == CANT_ACCESS_SRC)
    nowayjose=XmStringCreateLtoR("Cannot move or copy that file:\nCan't read source file.", XmSTRING_DEFAULT_CHARSET);
  if (x == CANT_ACCESS_DEST)
    nowayjose=XmStringCreateLtoR("Cannot move or copy that file:\nCan't write to destination file.", XmSTRING_DEFAULT_CHARSET);
  if (x == CANT_MOVE_SRC)
    nowayjose=XmStringCreateLtoR("Cannot move that file:\nCan't remove the source file.", XmSTRING_DEFAULT_CHARSET);
  if (x == SMB_NOT_RUNNING)
    nowayjose=XmStringCreateLtoR("SMB server is not running.\nStart SMB server before making changes.", XmSTRING_DEFAULT_CHARSET);

  XtSetArg(args[0], XmNmessageString, nowayjose);
  XtSetArg(args[1], XmNtitle, "bxfm: Can't do that");
  XtSetArg(args[2], XmNuserData, IbPtr);
  topmsgbox = XmCreateWarningDialog(IbPtr->top_level, "nocando_warning", args, 3);
  
  XtUnmanageChild(XmMessageBoxGetChild(topmsgbox, 
                                       XmDIALOG_CANCEL_BUTTON));
  /* Press the ok button when finished reading. */
	if (!callback)
		XtAddCallback(topmsgbox, XmNokCallback, CancelCB, NULL);
	else
		XtAddCallback(topmsgbox, XmNokCallback, callback, client_data);
		
  XtAddCallback(topmsgbox, XmNhelpCallback, HelpTopic, (XtPointer) x);
  XtManageChild(topmsgbox);
  XmStringFree(nowayjose);
}

void ConfirmAction(IfaceBranche * IbPtr, char * message, XtCallbackProc callback) {
	Widget topmsgbox;
	XmString string;
	Arg args[10];

    string = XmStringCreateLocalized(message);

	XtSetArg(args[0], XmNmessageString, string);
	XtSetArg(args[1], XmNtitle, "bxfm: confirm action");
	XtSetArg(args[2], XmNuserData, IbPtr);

	topmsgbox = XmCreateWarningDialog(IbPtr->top_level, "conform_question", args, 3);
  
//	XtUnmanageChild(XmMessageBoxGetChild(topmsgbox, 
//                                       XmDIALOG_CANCEL_BUTTON));
  /* Press the ok button when finished reading. */

	XtAddCallback(topmsgbox, XmNokCallback, callback, (XtPointer) IbPtr);
	XtAddCallback(topmsgbox, XmNcancelCallback, CancelCB, NULL);
//	XtAddCallback(topmsgbox, XmNhelpCallback, HelpTopic, (XtPointer) x);
	XtManageChild(topmsgbox);
	XmStringFree(string);
}

void RenameFileDialog(IfaceBranche * IbPtr, char * name) 
{
	XmString info;
	char * string;
	Arg args[10];
	int n;
	Widget dialog, ok, text;
	

	string = calloc(strlen("Rename file  to:") + 5 + strlen(name), sizeof(char));
	sprintf(string, "Rename file %s to:", name);

	info = XmStringCreateLocalized(string);
	free(string);

	n = 0;
	XtSetArg(args[n], XmNselectionLabelString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: rename");
	n++;
	XtSetArg(args[n], XmNuserData, (XtPointer) IbPtr);
	n++;
	dialog = XmCreatePromptDialog(IbPtr->top_level, "Rename", args, n);
	
	
	ok = XtNameToWidget(dialog, "OK");

	XtVaSetValues(ok, XmNuserData, (XtPointer) IbPtr, NULL);

	text = XtNameToWidget(dialog, "Text");

	XtAddCallback(dialog, XmNcancelCallback, CancelRenameSymlinkFileCB, NULL);
	XtAddCallback(dialog, XmNokCallback, OkRenameFileCB, (XtPointer) name);
//	XtAddCallback(dialog, XmNhelpCallback, OverAllCopyCB, (XtPointer) rec);
//	XtAddCallback(skip_button, XmNactivateCallback, SkipCopyCB, (XtPointer) rec);


	XtManageChild(dialog);
//	XtManageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_APPLY_BUTTON));
//	XtManageChild(skip_button);
	XmStringFree(info);
//	XmStringFree(over);
//	XmStringFree(over2);
//	XmStringFree(skip);

	return ;
}

void SymlinkFileDialog(IfaceBranche * IbPtr, char * name) 
{
	XmString info;
	char * string, * dstfile;
	Arg args[10];
	int n;
	Widget dialog, ok, text;
	

	string = calloc(strlen("Create symbolic link for file  to:") + 5 + strlen(name), sizeof(char));
	sprintf(string, "Create symbolic link for file %s to:", name);

	info = XmStringCreateLocalized(string);
	free(string);

	n = 0;
	XtSetArg(args[n], XmNselectionLabelString, info);
	n++;
	XtSetArg(args[n], XmNtitle, "bxfm: symbolic link");
	n++;
	XtSetArg(args[n], XmNuserData, (XtPointer) IbPtr);
	n++;
	dialog = XmCreatePromptDialog(IbPtr->top_level, "Symlink", args, n);
	
	
	ok = XtNameToWidget(dialog, "OK");

	XtVaSetValues(ok, XmNuserData, (XtPointer) IbPtr, NULL);

	text = XtNameToWidget(dialog, "Text");

	dstfile = calloc(strlen(IbPtr->current_wd) + 3, sizeof(char));
	sprintf(dstfile, "%s/", IbPtr->current_wd);

	XmTextSetString(text, dstfile);
	free(dstfile);

	XtAddCallback(dialog, XmNcancelCallback, CancelRenameSymlinkFileCB, NULL);
	XtAddCallback(dialog, XmNokCallback, OkSymlinkFileCB, (XtPointer) name);


	XtManageChild(dialog);
	XmStringFree(info);

	return ;
}
