#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/Form.h>

#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include "defines.h"

#include "core.h"
/*#include "errormsg.h"*/
#include "filearea.h"
#include "getdir.h"
#include "utils.h"


//extern Widget top_level;
//extern char *home_dir;
//extern char current_wd[120];

/* TextField widget needed in multiple functions for dir_create_func(). */
//Widget dir_c_tf;
/* mode to use when creating directory */

struct DirMake
{
	char * current_wd;
	mode_t dir_create_mode;
	Widget dir_c_tf;
	IfaceBranche * IbPtr;
};

/* Cancel an operation by destroying its popup shell.  A very useful
 * function */
void chdir_goto_cancelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  struct DirMake * mdir; 

  XtVaGetValues(w, XmNuserData, &mdir, NULL);


	free(mdir->current_wd);
	free(mdir);

  XtDestroyWidget((Widget)client_data);
}

/* Cancel an operation by destroying its popup shell.  A very useful
 * function */
void mkdir_cancelCB(Widget w, XtPointer client_data, XtPointer call_data)
{
	struct DirMake * mdir; 

	XtVaGetValues(w, XmNuserData, &mdir, NULL);

#ifdef DEBUG
	printf("mkdir_cancelCB: current_wd %s\n", mdir->current_wd);
#endif
	free(mdir->current_wd);
	free(mdir);

	XtDestroyWidget(w);
}

/* Adjust dir_create_mode when the toggles are clicked. */
void toggleCB(Widget w, XtPointer client_data, XtPointer call_data)
{
	Boolean IsSet;
	struct DirMake * mdir; 

	XtVaGetValues(w, XmNset, &IsSet, XmNuserData, &mdir, NULL);

	if (IsSet)
		mdir->dir_create_mode |= (int) client_data;
	else
		mdir->dir_create_mode ^= (int) client_data;
}

/* Actually create the directory. */
void dir_createCB(Widget w, XtPointer client_data, XtPointer call_data)
{
	char *thisnewdir = NULL, *fulldirpath = NULL;
	struct DirMake * mdir;
	IfaceBranche * IbPtr;
	Widget text_f;
	

	XtVaGetValues(w, XmNuserData, &mdir, NULL);

	text_f = XtNameToWidget(w, "Text");
	
	if (text_f)
	{

		XtVaGetValues(text_f, XmNvalue, &thisnewdir, NULL);

		if (strlen(thisnewdir))
		{
			IbPtr = mdir->IbPtr;
			fulldirpath = calloc(strlen(mdir->current_wd) + strlen(thisnewdir) + 3, sizeof(char));

			sprintf(fulldirpath, "%s/%s", mdir->current_wd, thisnewdir);

#ifdef DEBUG
			printf("%d: %s\n", mdir->dir_create_mode, fulldirpath);
#endif
			mkdir(fulldirpath, mdir->dir_create_mode);
		
			if (thisnewdir)
				XtFree(thisnewdir);
		}
	}

	if (fulldirpath) 
		free(fulldirpath);

	if (mdir->current_wd) 
		free(mdir->current_wd);

	free(mdir);

	XtDestroyWidget(w);

	if (errno == EEXIST) {
		NoCanDo(IT_ALREADY_EXISTS, IbPtr, NULL, NULL);
		return;
	}

//  load_dir(IbPtr, IbPtr->current_wd);
#ifndef USE_INOTIFY
	DrawFileArea(IbPtr);
#endif
	return ;
}

/*static Widget CreatePermToggleB(Widget parent, char * name, void * user_data, char * label, char set, Boolean sensitive)
{
	XmString str;
	Arg args[5];
	int n = 0;
	Widget w;

	str = XmStringCreateLocalized(label);

	if (str)
	{
		XtSetArg(args[n], XmNlabelString, str);
		n++;
	}

	XtSetArg(args[n], XmNsensitive, sensitive);
	n++;
	XtSetArg(args[n], XmNset, set);
	n++;

	if (user_data)
	{
		XtSetArg(args[n], XmNuserData, user_data);
		n++;
	}
	
	w = XmCreateToggleButton(parent, name, args, n);

	XtManageChild(w);

	if (str)
		XmStringFree(str);
		
	return w;
}
*/


void dir_create_func(IfaceBranche * IbPtr) 
{
	XmString info, name;
	char * string, * c;
	int i;
	Arg args[10];
	Cardinal n;
	Widget dialog, text, radiobox, form, message, apply, uperms, gperms, aperms, label;

	struct stat buf;
	XmString xlabelstr;
	struct DirMake *mdir;

	stat(IbPtr->current_wd, &buf);
	if (!IsWritable(buf)) {
		NoCanDo(CANT_WRITE_DIR, IbPtr, NULL, NULL);
		return;
	}
	
	mdir = (struct DirMake *) malloc(sizeof(struct DirMake));
	mdir->current_wd = strdup(IbPtr->current_wd);
	mdir->IbPtr = IbPtr;
	
	mdir->dir_create_mode = 493;  /* results in: drwxr-xr-x on new directory */

	name = XmStringCreateLocalized("Enter new directory name");
	
	n = 0;
	XtSetArg(args[n], XmNtitle, "Create new directory");
	n++;
	XtSetArg(args[n], XmNautoUnmanage, False); 
	n++;
	XtSetArg(args[n], XmNselectionLabelString, name);
	n++;
	XtSetArg(args[n], XmNchildPlacement, XmPLACE_BELOW_SELECTION);
	n++;
	XtSetArg(args[n], XmNuserData, (XtPointer) mdir);
	n++;


	dialog = XmCreatePromptDialog(IbPtr->top_level, "NewDir", args, n);

	apply = XtNameToWidget(dialog, "Apply");

	XmStringFree(name);

/*** Creating form with message label and radiobox ***/

	form = XtVaCreateManagedWidget("perm_form", xmFormWidgetClass, dialog,
									XmNfractionBase, 3,
									NULL);

/* Display checkboxes to allow changing permissions. */

	n = 0;
	XtSetArg(args[n], XmNorientation, XmVERTICAL);
	n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNtopPosition, 0);
	n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNleftPosition, 0);
	n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNrightPosition, 1);
	n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNbottomPosition, 3);
	n++;


	uperms = XmCreateRowColumn(form, "info_rc1", args, n);
	
	label = XmCreateLabel(uperms, "User", NULL, 0);

	radiobox = CreatePermToggle(uperms, "read", (void *) mdir, resdata.DialInfoReadString, 1, True);

	XtAddCallback(radiobox, XmNvalueChangedCallback, toggleCB, (XtPointer)256);

	radiobox = CreatePermToggle(uperms, "write", (void *) mdir, resdata.DialInfoWriteString, 1, True);

	XtAddCallback(radiobox, XmNvalueChangedCallback, toggleCB, (XtPointer)128);

	radiobox = CreatePermToggle(uperms, "execute", (void *) mdir, resdata.DialInfoExecuteString, 1, True);

	XtAddCallback(radiobox, XmNvalueChangedCallback, toggleCB, (XtPointer)64);

	XtManageChild(uperms);
	XtManageChild(label);

	n = 0;
	XtSetArg(args[n], XmNorientation, XmVERTICAL);
	n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNtopPosition, 0);
	n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNleftPosition, 1);
	n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNrightPosition, 2);
	n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNbottomPosition, 3);
	n++;

	gperms = XmCreateRowColumn(form, "info_rc2", args, n);

	label = XmCreateLabel(gperms, "Group", NULL, 0);

	radiobox = CreatePermToggle(gperms, "read", (void *) mdir, resdata.DialInfoReadString, 1, True);

	XtAddCallback(radiobox, XmNvalueChangedCallback, toggleCB, (XtPointer)32);

	radiobox = CreatePermToggle(gperms, "write", (void *) mdir, resdata.DialInfoWriteString, 0, True);

	XtAddCallback(radiobox, XmNvalueChangedCallback, toggleCB, (XtPointer)16);

	radiobox = CreatePermToggle(gperms, "execute", (void *) mdir, resdata.DialInfoExecuteString, 1, True);

	XtAddCallback(radiobox, XmNvalueChangedCallback, toggleCB, (XtPointer)8);

	XtManageChild(gperms);
	XtManageChild(label);

	n = 0;
	XtSetArg(args[n], XmNorientation, XmVERTICAL);
	n++;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNtopPosition, 0);
	n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNleftPosition, 2);
	n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNrightPosition, 3);
	n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_POSITION);
	n++;
	XtSetArg(args[n], XmNbottomPosition, 3);
	n++;

	aperms = XmCreateRowColumn(form, "info_rc3", args, n);

	label = XmCreateLabel(aperms, "Others", NULL, 0);

	radiobox = CreatePermToggle(aperms, "read", (void *) mdir, resdata.DialInfoReadString, 1, True);

	XtAddCallback(radiobox, XmNvalueChangedCallback, toggleCB, (XtPointer)4);

	radiobox = CreatePermToggle(aperms, "write", (void *) mdir, resdata.DialInfoWriteString, 0, True);

	XtAddCallback(radiobox, XmNvalueChangedCallback, toggleCB, (XtPointer)2);

	radiobox = CreatePermToggle(aperms, "execute", (void *) mdir, resdata.DialInfoExecuteString, 1, True);

	XtAddCallback(radiobox, XmNvalueChangedCallback, toggleCB, (XtPointer)1);

	XtManageChild(aperms);
	XtManageChild(label);

/*
	n=0;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM);
	n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM);
	n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM);
	n++;

	radiobox = XmVaCreateSimpleRadioBox (form,
				"radio_box", 0, NULL,
				XmVaRADIOBUTTON, one, 0, NULL, NULL,
				XmVaRADIOBUTTON, all, 0, NULL, NULL,
				XmNleftAttachment, XmATTACH_FORM,
				XmNrightAttachment, XmATTACH_FORM,
				XmNbottomAttachment, XmATTACH_FORM,
				NULL);

	XmStringFree(one);
	XmStringFree(all);

	n=0;
	XtSetArg (args[n], XmNlabelType, XmSTRING); n++;
	XtSetArg (args[n], XmNlabelString, info); n++;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
	XtSetArg (args[n], XmNbottomWidget, radiobox); n++;

	message = XmCreateLabel(form, "file", args, n);
*/

	XmStringFree(info);




//	XtManageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_APPLY_BUTTON));
//	XtManageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
//	XtManageChild (message);
//	XtManageChild (radiobox);
	XtManageChild (form);
	XtUnmanageChild(apply);
	XtManageChild(dialog);

	XtAddCallback(dialog, XmNokCallback, (XtCallbackProc) dir_createCB,
				(XtPointer) NULL);
	XtAddCallback(dialog, XmNcancelCallback, (XtCallbackProc) mkdir_cancelCB,
				(XtPointer) NULL);

	return ;
}

void chdir_home(IfaceBranche * IbPtr) {
//  load_dir(IbPtr, home_dir);

#ifdef USE_INOTIFY
//	if (IbPtr->i_fd != -1 && IbPtr->i_wd != -1)
//		inotify_rm_watch(IbPtr->i_fd, IbPtr->i_wd);

	PutWatchCommand(IbPtr, COMMAND_DEL_WATCH);
#endif

	if (IbPtr->current_wd)
		free(IbPtr->current_wd);
	IbPtr->current_wd = strdup(home_dir);	
	DrawFileArea(IbPtr);
	XtVaSetValues(IbPtr->fm_textfield, XmNvalue, IbPtr->current_wd, NULL);
	XtVaSetValues(IbPtr->top_level, XmNtitle, IbPtr->current_wd, NULL);
}

void chdir_up(IfaceBranche * IbPtr) {
	char * str;
	
#ifdef USE_INOTIFY
//	if (IbPtr->i_fd != -1 && IbPtr->i_wd != -1)
//		inotify_rm_watch(IbPtr->i_fd, IbPtr->i_wd);
	PutWatchCommand(IbPtr, COMMAND_DEL_WATCH);
#endif
	str = strdup(getparent(IbPtr));
//  load_dir(IbPtr, getparent(IbPtr));
	if (IbPtr->current_wd)
		free(IbPtr->current_wd);
	IbPtr->current_wd = str;	
	DrawFileArea(IbPtr);
	XtVaSetValues(IbPtr->fm_textfield, XmNvalue, IbPtr->current_wd, NULL);
	XtVaSetValues(IbPtr->top_level, XmNtitle, IbPtr->current_wd, NULL);
}

void ChangeViewDo(IfaceBranche * IbPtr) 
{
#ifdef DEBUG
	printf("ChangeViewDoDetail\n");	
#endif
	SetFileViewAttributs(IbPtr);
	ReDrawFileArea(IbPtr);
}

Widget goto_tf;

void chdir_goto_okCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  struct stat buf;
  char *thisdir, *dirgo;
  struct DirMake * mdir;

  XtVaGetValues(w, XmNuserData, &mdir, NULL);
  XtVaGetValues(mdir->dir_c_tf, XmNvalue, &thisdir, NULL);
  stat(thisdir, &buf);

#ifdef USE_INOTIFY
//	if (mdir->IbPtr->i_fd != -1 && mdir->IbPtr->i_wd != -1)
//		inotify_rm_watch(mdir->IbPtr->i_fd, mdir->IbPtr->i_wd);
	PutWatchCommand(mdir->IbPtr, COMMAND_DEL_WATCH);
#endif

	if (mdir->IbPtr->current_wd)
		free(mdir->IbPtr->current_wd);

	mdir->IbPtr->current_wd = strdup(thisdir);


	XtDestroyWidget((Widget)client_data);

  if (errno == ENOENT) {
    NoCanDo(DIR_NOT_EXIST, mdir->IbPtr, NULL, NULL);
    return;
  }
  if (!IsReadable(buf)) {
    NoCanDo(CANT_READ_DIR, mdir->IbPtr, NULL, NULL);
    return;
  }
  if (!S_ISDIR(buf.st_mode)) {
    NoCanDo(NOT_A_DIRECTORY, mdir->IbPtr, NULL, NULL);
    return;
  }

//  load_dir(mdir->IbPtr, dirgo);
	DrawFileArea(mdir->IbPtr);
	XtVaSetValues(mdir->IbPtr->fm_textfield, XmNvalue, mdir->IbPtr->current_wd, NULL);
	XtVaSetValues(mdir->IbPtr->top_level, XmNtitle, mdir->IbPtr->current_wd, NULL);
//  free(dirgo);
	free(mdir->current_wd);
	free(mdir);
}
  
void chdir_goto(IfaceBranche * IbPtr) {
  Widget goto_shell, goto_bb, goto_label, goto_ok, goto_cancel, goto_help;
  XmString goto_msg;
	struct DirMake * mdir;

	mdir = (struct DirMake *) malloc(sizeof(struct DirMake));
	mdir->current_wd = strdup(IbPtr->current_wd);
	mdir->IbPtr = IbPtr;



  goto_msg = XmStringCreateSimple("Change to this directory:");
  
  goto_shell = XtVaCreatePopupShell("goto_shell", vendorShellWidgetClass,
				    IbPtr->top_level, XmNtitle, "Change directory",
				    XmNwidth, 280, XmNheight, 125, NULL);
  goto_bb = XtVaCreateManagedWidget("goto_bb", xmBulletinBoardWidgetClass,
				    goto_shell, XmNwidth, 280, 
				    XmNheight, 125, NULL);
  goto_label = XtVaCreateManagedWidget("goto_label", xmLabelWidgetClass,
				       goto_bb, XmNlabelString, goto_msg,
				       XmNx, 5, XmNy, 5, NULL);
  mdir->dir_c_tf = XtVaCreateManagedWidget("goto_tf", xmTextFieldWidgetClass,
				    goto_bb, XmNx, 5, XmNy, 35, 
				    XmNwidth, 260, XmNuserData, mdir, NULL);
  XtAddCallback(mdir->dir_c_tf, XmNactivateCallback, chdir_goto_okCB,
		(XtPointer) goto_shell);
  goto_ok = XtVaCreateManagedWidget("OK", xmPushButtonWidgetClass, goto_bb,
				    XmNx, 25, XmNy, 80, XmNheight, 30,
				    XmNwidth, 60, XmNuserData, mdir, NULL);
  XtAddCallback(goto_ok, XmNactivateCallback, chdir_goto_okCB,
		(XtPointer) goto_shell);
  goto_cancel = XtVaCreateManagedWidget("Cancel", xmPushButtonWidgetClass, 
					goto_bb, XmNx, 110, XmNy, 80, 
					XmNheight, 30, XmNwidth, 60, XmNuserData, mdir,  NULL);
  XtAddCallback(goto_cancel, XmNactivateCallback, chdir_goto_cancelCB,
		(XtPointer) goto_shell);
  goto_help = XtVaCreateManagedWidget("Help", xmPushButtonWidgetClass, goto_bb,
				      XmNx, 195, XmNy, 80, XmNheight, 30,
				      XmNwidth, 60, XmNuserData, mdir, NULL);
  XtAddCallback(goto_help, XmNactivateCallback, chdir_goto_cancelCB,
		(XtPointer) goto_shell);

  XtPopup(goto_shell, XtGrabNone);
  XmStringFree(goto_msg);
}
