#include "../config.h"



#ifdef USE_INOTIFY

#include <sys/inotify.h>

#define EVENT_SIZE ( sizeof (struct inotify_event))
#define EVENT_BUF_LEN ( 1024 * ( EVENT_SIZE + 16 ))

#define COMMAND_ADD_WATCH 1
#define COMMAND_DEL_WATCH 2
#define COMMAND_DETACH_IFACE 3
#define COMMAND_TERMINATE_WATCH 4

#define NOTIFY_ADD_FILE 1
#define NOTIFY_CLOSE_FILE 2
#define NOTIFY_DELETE_FILE 3
#define NOTIFY_CHANGE_ATTRIB 4
#define NOTIFY_WATCH_TERMINATED 5
#define NOTIFY_NEED_REDISPLAY 6

#endif

#define SORTING_ASCEND 	1
#define SORTING_DESCEND	2

#define SORTING_NAME	1
#define SORTING_DATE	2
#define SORTING_SIZE	3

#define MAX_ICON_SIZE_LIMIT 128

#define ICON_NODE_NOT_INITED 0
#define ICON_NODE_INITED 1

/* User's home directory */
char *home_dir;

#include <semaphore.h>
//#include "errormsg.h"

#include "ftype.h"


/* User's UID and GID (Are you root?) */
uid_t local_uid;
gid_t local_gid;

int icon_loaded;
int fullIconComplect;
int needAddIconToGlobalList;

int CaseSensitiveSorting;
int HiddenFileShow;
int HiddenDirShow;
int ParentDirShow;
int CurrentDirShow;
char NormalIconsSetPath[4096];

XmString XmIconTitleString;
XmString XmNameTitleString;
XmString XmSizeTitleString;
XmString XmDateTitleString;
XmString XmPermTitleString;
XmString XmOwnerTitleString;
XmString XmOwnergrpTitleString;

Pixmap upSortIcon, upSortMask, downSortIcon, downSortMask;

Cursor WaithCursor;
Boolean CursorCreated;

struct _ResData
{
	String IconTitleString;
	String NameTitleString;
	String SizeTitleString;
	String DateTitleString;
	String PermTitleString;
	String OwnerTitleString;
	String OwnergrpTitleString;
	String BytesNameString;
	String KBytesNameString;
	String MBytesNameString;
	String GBytesNameString;
	String DirectoryNameString;
	String SymLinkNameString;
	String CharDevNameString;
	String BlockDevNameString;
	String FifoNameString;
	String SocketNameString;
	String TimeAccessNameString;
	String TimeModifyNameString;
	String TimeChangeNameString;
	String ItemsNameString;
	String SelectNameString;
/********** Popup Menu Label ******************/
	String PopupMenuCopyString;
	String PopupMenuCutString;
	String PopupMenuPastString;
	String PopupMenuDeleteString;
	String PopupMenuInfoString;
	String PopupMenuTermHereString;
	String PopupMenuInTermString;
	String PopupMenuReverseString;
/********** Dialog File Info ******************/
	String DialInfoTitleString;
	String DialInfoMessageString;
	String DialInfoFolderInfoString;
	String DialInfoFolderPermString;
	String DialInfoFolderAssociationString;

	String DialInfoTypeString;

	String DialInfoTryChownString;
	String DialInfoTryChgrString;
	String DialInfoReadString;
	String DialInfoWriteString;
	String DialInfoExecuteString;
	String DialInfoSetuidString;
	String DialInfoSetgidString;
	String DialInfoStickyString;

	String DialInfoEmptyItemString;

	String DialInfoOpenWithString;
	String DialInfoLargeIconString;
	String DialInfoSmallIconString;
	String DialInfoIconEditString;
/********** Dialog Icon Select ******************/
	String DialIconSelectTitleString;
	String DialIconSelectMessageStringLarge;
	String DialIconSelectMessageStringSmall;
/********** Dialog File Exist ******************/
	String DialExistFileSourceString;
	String DialExistFileExistString;
	String DialExistFileSizeString;
	String DialExistFileModTimeString;
} typedef ResData;

ResData resdata;

static XtResource resources[] = {
	{"iconTitleLabel", "IconTitleLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, IconTitleString), XmRString, "O"},
	{"nameTitleLabel", "NameTitleLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, NameTitleString), XmRString, "Name"},
	{"sizeTitleLabel", "SizeTitleLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, SizeTitleString), XmRString, "Size"},
	{"dateTitleLabel", "DateTitleLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DateTitleString), XmRString, "Date"},
	{"permTitleLabel", "PermTitleLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, PermTitleString), XmRString, "Permission"},
	{"ownerTitleLabel", "OwnerTitleLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, OwnerTitleString), XmRString, "Owner"},
	{"ownergrpTitleLabel", "OwnergrpTitleLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, OwnergrpTitleString), XmRString, "Group"},
	{"bytesNameLabel", "BytesNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, BytesNameString), XmRString, "bytes"},
	{"kbytesNameLabel", "KBytesNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, KBytesNameString), XmRString, "Kbytes"},
	{"mbytesNameLabel", "MBytesNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, MBytesNameString), XmRString, "Mbytes"},
	{"gbytesNameLabel", "GBytesNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, GBytesNameString), XmRString, "Gbytes"},
	{"dirNameLabel", "DirNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DirectoryNameString), XmRString, "Directory"},
	{"symlinkNameLabel", "SymlinkNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, SymLinkNameString), XmRString, "symbolic link"},
	{"chardevNameLabel", "ChardevNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, CharDevNameString), XmRString, "character device"},
	{"blockdevNameLabel", "BlockdevNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, BlockDevNameString), XmRString, "block device"},
	{"fifoNameLabel", "FifoNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, FifoNameString), XmRString, "FIFO (named pipe)"},
	{"socketNameLabel", "SocketNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, SocketNameString), XmRString, "socket"},
	{"timeAccessNameLabel", "TimeAccessNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, TimeAccessNameString), XmRString, "Time of last access:"},
	{"timeModifyNameLabel", "TimeModifyNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, TimeModifyNameString), XmRString, "Time of last modification:"},
	{"timeChangeNameLabel", "TimeChangeNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, TimeChangeNameString), XmRString, "Time of last status change:"},
	{"itemNameLabel", "ItemNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, ItemsNameString), XmRString, "item(s)"},
	{"selectNameLabel", "SelectNameLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, SelectNameString), XmRString, "Selected: "},
/********** Popup Menu Label ******************/
	{"popupMenuCopyLabel", "PopupMenuCopyLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, PopupMenuCopyString), XmRString, "Copy"},
	{"popupMenuCutLabel", "PopupMenuCutLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, PopupMenuCutString), XmRString, "Cut"},
	{"popupMenuPastLabel", "PopupMenuPastLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, PopupMenuPastString), XmRString, "Past"},
	{"popupMenuInfoLabel", "PopupMenuInfoLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, PopupMenuInfoString), XmRString, "Information"},
	{"popupMenuDeleteLabel", "PopupMenuDeleteLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, PopupMenuDeleteString), XmRString, "Delete"},
	{"popupMenuInTermLabel", "PopupMenuInTermLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, PopupMenuInTermString), XmRString, "Open in Xterminal"},
	{"popupMenuTermHereLabel", "PopupMenuTermHereLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, PopupMenuTermHereString), XmRString, "Open Xterminal here"},
	{"popupMenuReverseLabel", "PopupMenuReverseLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, PopupMenuReverseString), XmRString, "Reverse Order"},
/********** Dialog File Info ******************/
	{"dialInfoTitleLabel", "DialInfoTitleLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoTitleString), XmRString, "Parameters"},
	{"dialInfoMessageLabel", "DialInfoMessageLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoMessageString), XmRString, "Properties"},
	{"dialInfoFolderInfoLabel", "DialInfoFolderInfoLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoFolderInfoString), XmRString, "Information"},
	{"dialInfoFolderPermLabel", "DialInfoFolderPermLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoFolderPermString), XmRString, "Permission"},
	{"dialInfoFolderAssocLabel", "DialInfoFolderAssocLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoFolderAssociationString), XmRString, "File association"},

	{"dialInfoTyepLabel", "DialInfoTypeLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoTypeString), XmRString, "Type of file:"},

	{"dialInfoEmptyItemLabel", "DialInfoEmptyItemLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoEmptyItemString), XmRString, "EMPTY"},

	{"dialInfoTryChownLabel", "DialInfoTryChownLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoTryChownString), XmRString, "Try change owner"},
	{"dialInfoTryChgrLabel", "DialInfoTryChgrLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoTryChgrString), XmRString, "Try change group"},
	{"dialInfoReadLabel", "DialInfoReadLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoReadString), XmRString, "Read"},
	{"dialInfoWriteLabel", "DialInfoWriteLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoWriteString), XmRString, "Write"},
	{"dialInfoExecuteLabel", "DialInfoExecuteLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoExecuteString), XmRString, "Execute"},
	{"dialInfoSetuidLabel", "DialInfoSetuidLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoSetuidString), XmRString, "Set UID"},
	{"dialInfoSetgidLabel", "DialInfoSetgidLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoSetgidString), XmRString, "Set GID"},
	{"dialInfoStickyLabel", "DialInfoStickyLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoStickyString), XmRString, "Sticky bit"},

	{"dialInfoOpenWithLabel", "DialInfoOpenWithLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoOpenWithString), XmRString, "Open with"},
	{"dialInfoLargeIconLabel", "DialInfoLargeIconLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoLargeIconString), XmRString, "Current large icon"},
	{"dialInfoSmallIconLabel", "DialInfoSmallIconLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoSmallIconString), XmRString, "Current small icon"},
	{"dialInfoIconEditLabel", "DialInfoIconEditLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialInfoIconEditString), XmRString, "Change"},

/********** Dialog Icon Select ******************/
	{"dialIconSelectTitleLabel", "DialIconSelectTitleLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialIconSelectTitleString), XmRString, "Icon File Selection"},
	{"dialIconSelectMessageLabelLarge", "DialIconSelectMessageLabelLarge", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialIconSelectMessageStringLarge), XmRString, "Select pixmap file for large icon"},
	{"dialIconSelectMessageLabelSmall", "DialIconSelectMessageLabelSmall", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialIconSelectMessageStringSmall), XmRString, "Select pixmap file for small icon"},
/********** Dialog File Exist ******************/
	{"dialExistFileSourceLabel", "DialExistFileSourceLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialExistFileSourceString), XmRString, "Source file - "},
	{"dialExistFileExistLabel", "DialExistFileExistLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialExistFileExistString), XmRString, "Exist file - "},
	{"dialExistFileSizeLabel", "DialExistFileSizeLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialExistFileSizeString), XmRString, "size:  "},
	{"dialExistFileModTimeLabel", "DialExistFileModTimeLabel", XmRString, sizeof(String),
		XtOffsetOf(ResData, DialExistFileModTimeString), XmRString, "time of last modification: "},
};



/* This struct holds file info */
struct fileinfo {
	off_t f_size;
	time_t f_atime;
	time_t f_mtime;
	time_t f_ctime;
	mode_t f_perm;	
	uid_t f_owner;
	gid_t f_owngrp;
	void * magic;
};

/* This struct holds file data */
struct filedata {
	char *name;
	char *linkto;
	mode_t filetype;
	bxfm_ftype * magic;
	struct fileinfo * info;
};



#ifdef USE_INOTIFY
struct _WatchEvent
{
	int code;
	char * path;
	struct filedata * file_ptr;
	struct _WatchEvent * next;
} typedef WatchEvent;

pthread_t notify_thread_id;

#endif

typedef struct _PatternList
{
	char ** text;
	int text_segment_count;
	int offset1;
	int offset2;
	char asterisk_start;
	char asterisk_end;
} PatternList;

unsigned int maxIconHeight;
unsigned int maxIconWidth;

typedef struct _appPixmapList
{
	Pixmap icon;
	Pixmap mask;
	char * name;
	struct _appPixmapList * next;
	char used;
} appPixmapList;

appPixmapList * globalPixmapList;
appPixmapList * buildingIconNode;

struct _IfaceBranche
{
	pthread_t thread_id;
	int thread_number;
	int first_time;
	XtAppContext app;
	Widget top_level;
	Widget fm_main_window;
	Widget fm_scroll_win;
	Widget fm_menubar;
	Widget fm_textfield;
	Widget large_bt;
	Widget small_bt;
	Widget detail_bt;
	Widget case_sensitive_bt;
	Widget hid_dir_bt;
	Widget hid_file_bt;
	Widget par_dir_bt;
	Widget cur_dir_bt;
/*******************************/
	Widget sort_name_bt;
	Widget sort_size_bt;
	Widget sort_date_bt;
	Widget sort_reverse_bt;
/******************************/
	Widget stop_load_dir;
	Widget go_up_dir;
	Widget go;
	Widget menu_bar;
	Widget file_pulldown;
	Widget dir_pulldown;
	Widget edit_pulldown;
	Widget view_pulldown;
	Widget show_pulldown;
	Widget menuAiconbox;
	Widget menuAdetail;
	Widget menuBiconbox;
	Widget menuBdetail;
	Widget menuCiconbox;
	Widget statusBar;
	Widget info_dialog;
	XtTranslations parsed_trans;
	int DropSiteRegisterNeedIbox;
	int DropSiteRegisterNeedDeatail;
	int HlgCallbackAttached;
	int CurrentViewType;
	int CaseSensitiveSorting;
	int HiddenFileShow;
	int HiddenDirShow;
	int ParentDirShow;
	int CurrentDirShow;
	int SortingCategory;
	int SortingType;
	char * current_wd;
	char * file_list;
	struct filedata ** files_ptr;
	int view_closed;
	int reading_process;
	int nfiles;
	int filesallocated;
	
	struct filedata ** dirs_ptr;
	int ndirs;
	int dirsallocated;
	
	int filesready;
	int processed;
	int load_dir_joined;
	int cancel_reading;
	int load_dir_error_set;
	char * load_dir_error_message;
	int wait_cursor;
	int resort_callback_installed;
//	int fileptr;
	int index;
//	int close_main_win;
/***********************/
//	sem_t files_sem;
	pthread_t files_thread_id;

/***********************/
	struct _IfaceBranche * next_branche;
#ifdef	USE_INOTIFY
	char ievent_buf[EVENT_BUF_LEN];
	XtInputId inp_id;
	int i_fd;
	int i_wd;
	WatchEvent * WatchEventQueue;
	pthread_mutex_t branch_mutex;
#endif
/* Background threads properies (copy, move, delete) */
	void ** fops;
	int copy_move_thread_count;
	int fops_allocated;
	PatternList PatternRec;
	Pixmap DialPixLarge;
	Pixmap DialPixSmall;
} typedef IfaceBranche;

IfaceBranche * AllIfaceBranches;

#ifdef	USE_INOTIFY

pthread_mutex_t watch_mutex;

struct _WatchCommand
{
	int code;
	char * path;
	int thread_number;
	int watch_fd;
	IfaceBranche * IfBrPtr;
	struct _WatchCommand * next;
} typedef WatchCommand;

WatchCommand * WatchCommandQueue;


void PutWatchCommand(IfaceBranche * IbPtr, int command);
WatchEvent * GetWatchEvent(IfaceBranche * IbPtr);

#endif
/*
typedef struct _PatternList
{
	char * text;
	struct _PatternList * next;
	int offset1;
	int offset2;
	char asterisk1;
	char asterisk2;
} PatternList;
*/

