%{
                   
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <X11/xpm.h>
#include "ftype.h"
#include <string.h>

#define YYSTYPE char * 

extern FILE*  yyin;
extern int yylineno;
int yylex(void);
int yyparse(void);


bxfm_ftype ** ftype_list = NULL;
int count_all = 0;
int count_current = 0;
int counter_item = 0;
char * path_magic_file = NULL;
char * path_icons_set = NULL;
char * show_hidden_dir = NULL;
char * show_hidden_file = NULL;
char * show_parent_dir = NULL;
char * show_current_dir = NULL;
char * terminal_command = NULL;

alter_action * alter_action_list = NULL;
int alter_count_all = 0;
int alter_count_current = 0;
int alter_counter_item = 0;
int l_count = 0;
int ac_count = 0;

ext_ftype ** ext_ftype_list = NULL;
int ext_count_all = 0;
int ext_count_current = 0;
int ext_counter_item = 0;

char * strreload(char * name)
{
	char * ptr1, * ptr2, * ret;
	ptr1 = strchr(name, '\"');
	ptr2 = strrchr(name, '\"');
	if (ptr1 && ptr2 && (ptr2 > ptr1))
	{
		ret = calloc(ptr2 - ptr1 + 2, sizeof(char));
		if (ret) strncpy(ret, ptr1 + 1, ptr2 - ptr1 - 1);
		return ret;
	}
	else return NULL;
}

int parse_config_start(char * fname)
{
	if ((yyin = fopen(fname, "r"))) 
	{
		make_new_record();
		make_new_alter_record();
		make_new_ext_record();
		yyparse();
		return 0;
	}
	else return 1;
}

int yywrap()
{
        return 1;
} 

yyerror( s )
char *s;
{
    fprintf( stderr ,"%s: %s\n" , "Config parse" , s );
}

int make_new_record(void)
{
	bxfm_ftype * ptr;
	int i;
	
	if (!ftype_list)
	{
		ftype_list = (bxfm_ftype **) calloc(20, sizeof(bxfm_ftype *));
		ptr = (bxfm_ftype *) calloc(20, sizeof(bxfm_ftype));

		count_all = 20;

		for (i = 0; i < count_all; i++)
		{
			ftype_list[i] = ptr + i;
		}

		count_current = 0;
		counter_item = 0;
		return count_current;
	}
	else
	{
		if (count_all == count_current + 1)
		{
			ftype_list = (bxfm_ftype **) realloc(ftype_list, (10 + count_all) * sizeof(bxfm_ftype *));
			ptr = calloc(10, sizeof(bxfm_ftype));
			for (i = 0; i < 10; i++)
			{
				ftype_list[count_all + i] = ptr + i;
			}
			count_all += 10;
		}
		count_current ++;
		counter_item = 0;
		return count_current;
	}
}

int make_new_alter_record(void)
{
	if (!alter_action_list)
	{
		alter_action_list = calloc(20, sizeof(alter_action));
		alter_count_all = 20;
		alter_count_current = 0;
		alter_counter_item = 0;
		return alter_count_current;
	}
	else
	{
		if (alter_count_all == alter_count_current + 1)
		{
			alter_action_list = realloc(alter_action_list, (10 + alter_count_all) * sizeof(alter_action) );
			alter_count_all += 10;
		}
		alter_count_current ++;
		alter_counter_item = 0;
		return alter_count_current;
	}
}

int make_new_ext_record(void)
{
	ext_ftype * ptr;
	int i;
	
	if (!ext_ftype_list)
	{
		ext_ftype_list = (ext_ftype **) calloc(20, sizeof(ext_ftype *));
		ptr = (ext_ftype *) calloc(20, sizeof(ext_ftype));

		ext_count_all = 20;

		for (i = 0; i < ext_count_all; i++)
		{
			ext_ftype_list[i] = ptr + i;
		}

		ext_count_current = 0;
		ext_counter_item = 0;
		return ext_count_current;
	}
	else
	{
		if (ext_count_all == ext_count_current + 1)
		{
			ext_ftype_list = (ext_ftype **) realloc(ext_ftype_list, (10 + ext_count_all) * sizeof(ext_ftype *));
			ptr = calloc(10, sizeof(ext_ftype));
			for (i = 0; i < 10; i++)
			{
				ext_ftype_list[ext_count_all + i] = ptr + i;
			}
			ext_count_all += 10;
		}
		ext_count_current ++;
		ext_counter_item = 0;
		return ext_count_current;
	}
}

void put_magic_path(char * name)
{
	path_magic_file = strreload(name);
}

void put_icon_path(char * name)
{
	path_icons_set = strreload(name);
}

void put_hidden_dir(char * name)
{
	show_hidden_dir = strreload(name);
}

void put_hidden_file(char * name)
{
	show_hidden_file = strreload(name);
}

void put_parent_dir(char * name)
{
	show_parent_dir = strreload(name);
}

void put_current_dir(char * name)
{
	show_current_dir = strreload(name);
}

void put_terminal_command(char * name)
{
	terminal_command = strreload(name);
}

void put_magic_string(char * name)
{
	int len;
	
	len = strlen (name);
	if (len <= 2)
		return ;
	(ftype_list[count_current])->magic = strndup(name + 1, len - 2);
	make_new_record();
}

void put_ext_magic_string(char * name)
{
	int len;
	
	len = strlen (name);
	if (len <= 2)
		return ;
	(ext_ftype_list[ext_count_current])->magic = strndup(name + 1, len - 2);
	make_new_ext_record();
}

void put_big_icon_name(char * name)
{
	(ftype_list[count_current])->big_icon_name = strreload(name);
}

void put_small_icon_name(char * name)
{
	(ftype_list[count_current])->small_icon_name = strreload(name);
}

void put_action_name(char * name)
{
	(ftype_list[count_current])->action = strreload(name);
}

void put_alter_name(char * name)
{
	(ftype_list[count_current])->alter_name = strreload(name);
}

void put_ext_type_link(char * name)
{
	(ext_ftype_list[ext_count_current])->type_link = strreload(name);
}

void put_ext_type_pattern(char * name)
{
	(ext_ftype_list[ext_count_current])->pattern = strreload(name);
}

void put_alter_label(char * name)
{
	if (l_count == 0) 
	{
		(alter_action_list + alter_count_current)->label1 = strreload(name);
		l_count ++;
	}
	else
	{
		if (l_count == 1)
		{
			(alter_action_list + alter_count_current)->label2 = strreload(name);
			l_count ++;
		}
		else
		{
			if (l_count == 2)
			{
				(alter_action_list + alter_count_current)->label3 = strreload(name);
				l_count ++;
			}
			else if (l_count > 2) return ;
		}
	}
}


void put_alter_ac(char * name)
{
	if (ac_count == 0) 
	{
		(alter_action_list + alter_count_current)->action1 = strreload(name);
		ac_count ++;
	}
	else
	{
		if (ac_count == 1)
		{
			(alter_action_list + alter_count_current)->action2 = strreload(name);
			ac_count ++;
		}
		else
		{
			if (ac_count == 2)
			{
				(alter_action_list + alter_count_current)->action3 = strreload(name);
				ac_count ++;
			}
			else if (ac_count > 2) return ;
		}
	}
}


void put_alter_string(char * name)
{
	(alter_action_list + alter_count_current)->name = strreload(name);
	make_new_alter_record();
	l_count = 0;
	ac_count = 0;
}


%}

%token TYPETOK LARGETOK MAGICNAME SMALLTOK WORD QUOTEDNAME QUOTE OBRACE EBRACE SEMICOLON PATHTOK ACTIONTOK MAGICPATHTOK TYPEALTERTOK ALTERLABEL ALTERACTION CHARNAME ALTERNAMERTOK HIDDENDIR HIDDENFILE PARENTDIR CURRENTDIR TERMINALCOMMAND
EXTTYPETOK TYPELINKTOK TYPEPATTERNTOK

%%
commands:
        |        
        commands command SEMICOLON
        ;


command:
        type_set 
	|
	icon_set
	|
	magic_set
	|
	hidden_dir_set
	|
	hidden_file_set
	|
	parent_dir_set
	|
	current_dir_set
	|
	terminal_command_set
	|
	alter_set
	|
	ext_type_set
        ;

icon_set:
	PATHTOK icon_path
	;

magic_set:
	MAGICPATHTOK magic_path
	;

hidden_dir_set:
	HIDDENDIR hidden_dir
	;

hidden_file_set:
	HIDDENFILE hidden_file
	;

parent_dir_set:
	PARENTDIR parent_dir
	;

current_dir_set:
	CURRENTDIR current_dir
	;

terminal_command_set:
	TERMINALCOMMAND terminal_cmd
	;

alter_set:
        TYPEALTERTOK alter_name altercontent
        {
        #ifdef DEBUG
                printf("Найден alter type '%s'\n",$2);
		#endif
		put_alter_string($2);
        }
        ;

alter_name:
        CHARNAME 
        {
                $$=$1;
        }
	;

type_set:
        TYPETOK magic_name typecontent
        {
        #ifdef DEBUG
                printf("Found magic type '%s'\n",$2);
		#endif
		put_magic_string($2);
        }
        ;

altercontent:
        OBRACE alterinfos EBRACE 
	;

typecontent:
        OBRACE typeinfos EBRACE 
	;

magic_name:
        MAGICNAME
        {
                $$=$1;
        }
	;

itemname:
        CHARNAME
        {
                $$=$1;
        }
	;

alterinfos:
        |
        alterinfos alterinfo SEMICOLON
        ;

alterinfo:
		|
        ALTERLABEL itemname
        {
        #ifdef DEBUG
                printf("Found name action1 '%s'\n", $1);
		#endif
		put_alter_label($2);
        }
        |
        ALTERACTION itemname 
        {
        #ifdef DEBUG
                printf("Found action1 '%s'\n", $2);
		#endif
		put_alter_ac($2);
        }
        ;

typeinfos:
        |
        typeinfos typeinfo SEMICOLON
        ;

typeinfo:
        SMALLTOK itemname
        {
         #ifdef DEBUG
               printf("Found name for small icon '%s'\n", $2);
		#endif
		put_small_icon_name($2);
        }
        |
        LARGETOK itemname 
        {
         #ifdef DEBUG
               printf("Found name for large icon '%s'\n", $2);
		#endif
		put_big_icon_name($2);
        }
	    |
        ACTIONTOK itemname 
        {
        #ifdef DEBUG
                printf("Found action '%s'\n", $2);
		#endif
		put_action_name($2);
        }
        |
        ALTERNAMERTOK itemname 
        {
        #ifdef DEBUG
                printf("Found alternativ action '%s'\n", $2);
		#endif
		put_alter_name($2);
        }
        ;

ext_type_set:
        EXTTYPETOK magic_name ext_typecontent
        {
        #ifdef DEBUG
                printf("Found magic exttype '%s'\n",$2);
		#endif
		put_ext_magic_string($2);
        }
        ;

ext_typecontent:
        OBRACE ext_typeinfos EBRACE 
	;

ext_typeinfos:
        |
        ext_typeinfos ext_typeinfo SEMICOLON
        ;

ext_typeinfo:
        TYPELINKTOK itemname
        {
         #ifdef DEBUG
               printf("Found name for ext type link '%s'\n", $2);
		#endif
		put_ext_type_link($2);
        }
        |
        TYPEPATTERNTOK itemname 
        {
         #ifdef DEBUG
               printf("Found name for pattern '%s'\n", $2);
		#endif
		put_ext_type_pattern($2);
        }
        ;


icon_path:
	itemname
        {
        #ifdef DEBUG
                printf("Found path to icons'%s'\n", $1);
		#endif
		put_icon_path($1);
        }
	;

magic_path:
	itemname
        {
        #ifdef DEBUG
			printf("Found path to magic'%s'\n", $1);
		#endif
			put_magic_path($1);
        }
	;

hidden_dir:
	itemname
        {
        #ifdef DEBUG
			printf("Found show hidden dir switch'%s'\n", $1);
		#endif
			put_hidden_dir($1);
        }
	;
	
hidden_file:
	itemname
        {
        #ifdef DEBUG
			printf("Found show hidden file switch'%s'\n", $1);
		#endif
			put_hidden_file($1);
        }
	;

parent_dir:
	itemname
        {
        #ifdef DEBUG
			printf("Found show parent dir switch'%s'\n", $1);
		#endif
			put_parent_dir($1);
        }
	;

current_dir:
	itemname
        {
        #ifdef DEBUG
			printf("Found show current dir switch'%s'\n", $1);
		#endif
			put_current_dir($1);
        }
	;

terminal_cmd:
	itemname
        {
        #ifdef DEBUG
			printf("Found terminal command define'%s'\n", $1);
		#endif
			put_terminal_command($1);
        }
	;
%%

