%{
#include <stdio.h>
#include "b_parser.h"
%}

%option yylineno

%%
ShowHiddenDir          return HIDDENDIR;
ShowHiddenFile         return HIDDENFILE;
ShowParent             return PARENTDIR;
ShowCurrent            return CURRENTDIR;
TerminalCommand        return TERMINALCOMMAND;
MagicPath              return MAGICPATHTOK;
IconPath                return PATHTOK;
TypeAlternative			return TYPEALTERTOK;
AlterLabel				return ALTERLABEL;
AlterAction			return ALTERACTION;
Action                return ACTIONTOK;
Type                    return TYPETOK;
LargeIcon                return LARGETOK;
SmallIcon                return SMALLTOK;
AlterName			return ALTERNAMERTOK;
ExtType			return EXTTYPETOK;
TypeLink		return TYPELINKTOK;
TypePattern		return TYPEPATTERNTOK;
\<[a-zA-Z0-9\+\/.-]+\>        yylval=strdup(yytext); return MAGICNAME;
\"([^\\\"]|\\.)*\"      yylval=strdup(yytext); return CHARNAME;
\"                      return QUOTE;
\{                      return OBRACE;
\}                      return EBRACE;
;                       return SEMICOLON;
\n                      /* пропускаем концы строк */;
[ \t]+                  /* пропускаем пробелы */;
%%


