/*
	This module assumes that floating point numbers are in
	Motorola FastFloatingPointFormat format.
*/

#include <math.h>

/*
	The function |ldexp()| returns x*(2**n)
*/

double
ldexp (x, n)
	double	x;
	int	n;
{
	long *	mptr = &x;

	if (*mptr == 0)
		return ((double) 0);

	n += (*mptr & 0x7f);
	if (n < 0) {
		errno = ERANGE;
		return (0.0);
	}
	if (n > 127) {
		errno = ERANGE;
		return (x<0.0 ? -HUGE : HUGE);
	}
	*mptr = (*mptr & ~0x7f) | n;		/* this changes x */
	return (x);
}
