/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.protocol.http;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import sun.plugin.cache.CachedFile;
import sun.plugin.cache.FileCache;
import sun.plugin.net.cookie.PluginCookieManager;
import sun.plugin.net.protocol.http.Handler;
import sun.plugin.net.protocol.http.HttpClient;
import sun.plugin.net.proxy.PluginProxyManager;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.ProgressInputStream;
import sun.plugin.usability.Trace;

public class HttpURLConnection
extends sun.net.www.protocol.http.HttpURLConnection {
    protected String proxy = null;
    protected int proxyPort = -1;
    protected boolean resolveProxy = true;
    boolean failedOnce = false;
    private Map cachedHeaders = null;
    private static MessageFormat mf1 = new MessageFormat(ResourceHandler.getMessage("net.connect.no_proxy"));
    private static MessageFormat mf2 = new MessageFormat(ResourceHandler.getMessage("net.connect.proxy_is"));
    private boolean securityCheck = false;
    private boolean cacheConnect = false;
    private boolean realConnect = false;
    private boolean checkSetCookie = false;
    private InputStream cacheStream = null;
    private static ResourceBundle rb;

    public HttpURLConnection(URL uRL, Handler handler) throws IOException {
        super(uRL, handler);
    }

    public HttpURLConnection(URL uRL, String string, int n) throws IOException {
        this(uRL, string, n, true);
    }

    public HttpURLConnection(URL uRL, String string, int n, boolean bl) throws IOException {
        super(uRL, string, n);
        this.proxy = string;
        this.proxyPort = n;
        this.resolveProxy = bl;
    }

    protected boolean fromClassLoader() {
        Exception exception = new Exception();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        String string = byteArrayOutputStream.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.startsWith("sun.applet.AppletClassLoader") && !string2.startsWith("sun.applet.AppletResourceLoader") && !string2.startsWith("sun.plugin.security.PluginClassLoader")) continue;
            return true;
        }
        return false;
    }

    void privBlock() throws Exception {
        this.http = "http".equals(this.url.getProtocol()) && !this.failedOnce ? HttpClient.New(this.url, this.proxy, this.proxyPort, this.resolveProxy) : this.getProxiedClient(this.url, this.proxy, this.proxyPort);
        this.ps = (PrintStream)this.http.getOutputStream();
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.checkPermission();
        this.connectWithCache();
        if (this.cacheStream == null) {
            try {
                this.connectSetup();
                AccessController.doPrivileged(new PrivilegedBlockAction(this));
            }
            catch (PrivilegedActionException privilegedActionException) {
                IOException iOException = (IOException)privilegedActionException.getException();
                throw iOException;
            }
        }
        this.connected = true;
    }

    public synchronized void disconnect() {
        super.disconnect();
        if (this.cacheStream != null) {
            this.cacheStream = null;
        }
        if (this.cachedHeaders != null) {
            this.cachedHeaders.clear();
        }
    }

    public void checkPermission() throws IOException {
        if (this.securityCheck) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.url.getHost(), this.url.getPort());
        }
        this.securityCheck = true;
    }

    public void connectWithCache() throws IOException {
        block7: {
            if (this.cacheConnect) {
                return;
            }
            if (this.getUseCaches() && this.getRequestMethod().equalsIgnoreCase("GET")) {
                try {
                    final CachedFile cachedFile = FileCache.get(this.url);
                    if (cachedFile == null) break block7;
                    InputStream inputStream = null;
                    try {
                        inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                return new FileInputStream(cachedFile);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        // empty catch block
                    }
                    if (inputStream != null) {
                        this.responseCode = 200;
                        this.cachedHeaders = cachedFile.getHeaderFields();
                        this.cacheStream = new ProgressInputStream(inputStream, this);
                    }
                }
                catch (IOException iOException) {
                    Trace.netPrintException(iOException);
                }
            }
        }
        this.cacheConnect = true;
    }

    public String getHeaderField(String string) {
        String string2 = null;
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string2 = this.cachedHeaders != null ? (String)this.cachedHeaders.get(string.toLowerCase()) : super.getHeaderField(string);
        return string2;
    }

    public void connectSetup() throws IOException {
        Object object;
        if (this.realConnect) {
            return;
        }
        if (this.proxy == null && this.resolveProxy && (object = PluginProxyManager.getProxyInfo(this.url)) != null) {
            this.proxy = object.getProxy();
            this.proxyPort = object.getPort();
        }
        if (this.proxy == null) {
            object = new Object[]{this.url};
            Trace.netPrintln(mf1.format(object), 2);
        } else {
            object = new Object[]{this.url, this.proxy + (this.proxyPort != -1 ? ":" + this.proxyPort : "")};
            Trace.netPrintln(mf2.format(object), 2);
        }
        if (this.getRequestProperty("cookie") == null && (object = PluginCookieManager.getCookieInfo(this.url)) != null) {
            this.addRequestProperty("cookie", (String)object);
        }
        this.realConnect = true;
    }

    public synchronized void checkCookieHeader() {
        if (this.checkSetCookie) {
            return;
        }
        this.checkSetCookie = true;
        Map<String, List<String>> map = this.getHeaderFields();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string == null || !string.equalsIgnoreCase("Set-Cookie")) continue;
            List<String> list = map.get(string);
            Iterator<String> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string2 = iterator2.next();
                if (string2 == null) continue;
                PluginCookieManager.setCookieInfo(this.url, string2);
            }
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.connect();
        if (this.cacheStream != null) {
            return this.cacheStream;
        }
        this.checkCookieHeader();
        InputStream inputStream = super.getInputStream();
        if (inputStream != null) {
            this.cacheStream = new ProgressInputStream(inputStream, this);
        }
        return this.cacheStream;
    }

    protected sun.net.www.http.HttpClient getNewClient(URL uRL) throws IOException {
        this.failedOnce = true;
        return this.getProxiedClient(uRL, this.proxy, this.proxyPort);
    }

    protected sun.net.www.http.HttpClient getProxiedClient(URL uRL, String string, int n) throws IOException {
        return new HttpClient(uRL, string, n, this.resolveProxy);
    }

    public static String getMessage(String string) {
        return ResourceHandler.getMessage(string);
    }

    class PrivilegedBlockAction
    implements PrivilegedExceptionAction {
        HttpURLConnection conn;

        PrivilegedBlockAction(HttpURLConnection httpURLConnection2) {
            this.conn = httpURLConnection2;
        }

        public Object run() throws Exception {
            this.conn.privBlock();
            return null;
        }
    }
}

